// components/mirroring/mojom/session_observer.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "components/mirroring/mojom/session_observer.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/mirroring/mojom/session_observer.mojom-params-data.h"
namespace mirroring {
namespace mojom {

NOINLINE static const char* SessionErrorToStringHelper(SessionError value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case SessionError::ANSWER_TIME_OUT:
      return "ANSWER_TIME_OUT";
    case SessionError::ANSWER_NOT_OK:
      return "ANSWER_NOT_OK";
    case SessionError::ANSWER_MISMATCHED_CAST_MODE:
      return "ANSWER_MISMATCHED_CAST_MODE";
    case SessionError::ANSWER_MISMATCHED_SSRC_LENGTH:
      return "ANSWER_MISMATCHED_SSRC_LENGTH";
    case SessionError::ANSWER_SELECT_MULTIPLE_AUDIO:
      return "ANSWER_SELECT_MULTIPLE_AUDIO";
    case SessionError::ANSWER_SELECT_MULTIPLE_VIDEO:
      return "ANSWER_SELECT_MULTIPLE_VIDEO";
    case SessionError::ANSWER_SELECT_INVALID_INDEX:
      return "ANSWER_SELECT_INVALID_INDEX";
    case SessionError::ANSWER_NO_AUDIO_OR_VIDEO:
      return "ANSWER_NO_AUDIO_OR_VIDEO";
    case SessionError::AUDIO_CAPTURE_ERROR:
      return "AUDIO_CAPTURE_ERROR";
    case SessionError::VIDEO_CAPTURE_ERROR:
      return "VIDEO_CAPTURE_ERROR";
    case SessionError::RTP_STREAM_ERROR:
      return "RTP_STREAM_ERROR";
    case SessionError::ENCODING_ERROR:
      return "ENCODING_ERROR";
    case SessionError::CAST_TRANSPORT_ERROR:
      return "CAST_TRANSPORT_ERROR";
    case SessionError::OPENSCREEN_SESSION_ERROR:
      return "OPENSCREEN_SESSION_ERROR";
    default:
      return nullptr;
  }
}

std::string SessionErrorToString(SessionError value) {
  const char *str = SessionErrorToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown SessionError value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, SessionError value) {
  return os << SessionErrorToString(value);
}

namespace internal {


// static
bool SessionObserver_OnError_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SessionObserver_OnError_Params_Data* object =
      static_cast<const SessionObserver_OnError_Params_Data*>(data);


  if (!::mirroring::mojom::internal::SessionError_Data
        ::Validate(object->error, validation_context))
    return false;

  return true;
}

SessionObserver_OnError_Params_Data::SessionObserver_OnError_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SessionObserver_DidStart_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SessionObserver_DidStart_Params_Data* object =
      static_cast<const SessionObserver_DidStart_Params_Data*>(data);

  return true;
}

SessionObserver_DidStart_Params_Data::SessionObserver_DidStart_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SessionObserver_DidStop_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SessionObserver_DidStop_Params_Data* object =
      static_cast<const SessionObserver_DidStop_Params_Data*>(data);

  return true;
}

SessionObserver_DidStop_Params_Data::SessionObserver_DidStop_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SessionObserver_LogInfoMessage_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SessionObserver_LogInfoMessage_Params_Data* object =
      static_cast<const SessionObserver_LogInfoMessage_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->message, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& message_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->message, validation_context,
                                         &message_validate_params)) {
    return false;
  }

  return true;
}

SessionObserver_LogInfoMessage_Params_Data::SessionObserver_LogInfoMessage_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SessionObserver_LogErrorMessage_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SessionObserver_LogErrorMessage_Params_Data* object =
      static_cast<const SessionObserver_LogErrorMessage_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->message, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& message_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->message, validation_context,
                                         &message_validate_params)) {
    return false;
  }

  return true;
}

SessionObserver_LogErrorMessage_Params_Data::SessionObserver_LogErrorMessage_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SessionObserver_OnSourceChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SessionObserver_OnSourceChanged_Params_Data* object =
      static_cast<const SessionObserver_OnSourceChanged_Params_Data*>(data);

  return true;
}

SessionObserver_OnSourceChanged_Params_Data::SessionObserver_OnSourceChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SessionObserver_OnRemotingStateChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SessionObserver_OnRemotingStateChanged_Params_Data* object =
      static_cast<const SessionObserver_OnRemotingStateChanged_Params_Data*>(data);

  return true;
}

SessionObserver_OnRemotingStateChanged_Params_Data::SessionObserver_OnRemotingStateChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace mirroring

namespace perfetto {

// static
void TraceFormatTraits<::mirroring::mojom::SessionError>::WriteIntoTrace(
   perfetto::TracedValue context, ::mirroring::mojom::SessionError value) {
  return std::move(context).WriteString(::mirroring::mojom::SessionErrorToString(value));
}

} // namespace perfetto