// components/mirroring/mojom/resource_provider.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_MIRRORING_MOJOM_RESOURCE_PROVIDER_MOJOM_PARAMS_DATA_H_
#define COMPONENTS_MIRRORING_MOJOM_RESOURCE_PROVIDER_MOJOM_PARAMS_DATA_H_

#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

namespace mojo::internal {
class ValidationContext;
}


namespace mirroring::mojom {
namespace internal {
class  AudioStreamCreatorClient_StreamCreated_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Interface_Data stream;
  mojo::internal::Handle_Data client_receiver;
  uint8_t pad1_[4];
  mojo::internal::Pointer<::media::mojom::internal::ReadWriteAudioDataPipe_Data> data_pipe;

 private:
  friend class mojo::internal::MessageFragment<AudioStreamCreatorClient_StreamCreated_Params_Data>;

  AudioStreamCreatorClient_StreamCreated_Params_Data();
  ~AudioStreamCreatorClient_StreamCreated_Params_Data() = delete;
};
static_assert(sizeof(AudioStreamCreatorClient_StreamCreated_Params_Data) == 32,
              "Bad sizeof(AudioStreamCreatorClient_StreamCreated_Params_Data)");
class  ResourceProvider_BindGpu_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Handle_Data receiver;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<ResourceProvider_BindGpu_Params_Data>;

  ResourceProvider_BindGpu_Params_Data();
  ~ResourceProvider_BindGpu_Params_Data() = delete;
};
static_assert(sizeof(ResourceProvider_BindGpu_Params_Data) == 16,
              "Bad sizeof(ResourceProvider_BindGpu_Params_Data)");
class  ResourceProvider_GetVideoCaptureHost_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Handle_Data receiver;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<ResourceProvider_GetVideoCaptureHost_Params_Data>;

  ResourceProvider_GetVideoCaptureHost_Params_Data();
  ~ResourceProvider_GetVideoCaptureHost_Params_Data() = delete;
};
static_assert(sizeof(ResourceProvider_GetVideoCaptureHost_Params_Data) == 16,
              "Bad sizeof(ResourceProvider_GetVideoCaptureHost_Params_Data)");
class  ResourceProvider_GetVideoEncoderMetricsProvider_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Handle_Data receiver;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<ResourceProvider_GetVideoEncoderMetricsProvider_Params_Data>;

  ResourceProvider_GetVideoEncoderMetricsProvider_Params_Data();
  ~ResourceProvider_GetVideoEncoderMetricsProvider_Params_Data() = delete;
};
static_assert(sizeof(ResourceProvider_GetVideoEncoderMetricsProvider_Params_Data) == 16,
              "Bad sizeof(ResourceProvider_GetVideoEncoderMetricsProvider_Params_Data)");
class  ResourceProvider_GetNetworkContext_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Handle_Data receiver;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<ResourceProvider_GetNetworkContext_Params_Data>;

  ResourceProvider_GetNetworkContext_Params_Data();
  ~ResourceProvider_GetNetworkContext_Params_Data() = delete;
};
static_assert(sizeof(ResourceProvider_GetNetworkContext_Params_Data) == 16,
              "Bad sizeof(ResourceProvider_GetNetworkContext_Params_Data)");
class  ResourceProvider_CreateAudioStream_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Interface_Data client;
  mojo::internal::Pointer<::media::mojom::internal::AudioParameters_Data> param;
  uint32_t shared_memory_count;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<ResourceProvider_CreateAudioStream_Params_Data>;

  ResourceProvider_CreateAudioStream_Params_Data();
  ~ResourceProvider_CreateAudioStream_Params_Data() = delete;
};
static_assert(sizeof(ResourceProvider_CreateAudioStream_Params_Data) == 32,
              "Bad sizeof(ResourceProvider_CreateAudioStream_Params_Data)");
class  ResourceProvider_ConnectToRemotingSource_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Interface_Data remoter;
  mojo::internal::Handle_Data receiver;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<ResourceProvider_ConnectToRemotingSource_Params_Data>;

  ResourceProvider_ConnectToRemotingSource_Params_Data();
  ~ResourceProvider_ConnectToRemotingSource_Params_Data() = delete;
};
static_assert(sizeof(ResourceProvider_ConnectToRemotingSource_Params_Data) == 24,
              "Bad sizeof(ResourceProvider_ConnectToRemotingSource_Params_Data)");

}  // namespace internal


class AudioStreamCreatorClient_StreamCreated_ParamsDataView {
 public:
  AudioStreamCreatorClient_StreamCreated_ParamsDataView() = default;

  AudioStreamCreatorClient_StreamCreated_ParamsDataView(
      internal::AudioStreamCreatorClient_StreamCreated_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeStream() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::media::mojom::AudioInputStreamInterfaceBase>>(
            &data_->stream, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeClientReceiver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::media::mojom::AudioInputStreamClientInterfaceBase>>(
            &data_->client_receiver, &result, message_);
    DCHECK(ret);
    return result;
  }
  inline void GetDataPipeDataView(
      ::media::mojom::ReadWriteAudioDataPipeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDataPipe(UserType* output) {
    
    auto* pointer = data_->data_pipe.Get();
    return mojo::internal::Deserialize<::media::mojom::ReadWriteAudioDataPipeDataView>(
        pointer, output, message_);
  }
 private:
  internal::AudioStreamCreatorClient_StreamCreated_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ResourceProvider_BindGpu_ParamsDataView {
 public:
  ResourceProvider_BindGpu_ParamsDataView() = default;

  ResourceProvider_BindGpu_ParamsDataView(
      internal::ResourceProvider_BindGpu_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeReceiver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::viz::mojom::GpuInterfaceBase>>(
            &data_->receiver, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::ResourceProvider_BindGpu_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ResourceProvider_GetVideoCaptureHost_ParamsDataView {
 public:
  ResourceProvider_GetVideoCaptureHost_ParamsDataView() = default;

  ResourceProvider_GetVideoCaptureHost_ParamsDataView(
      internal::ResourceProvider_GetVideoCaptureHost_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeReceiver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::media::mojom::VideoCaptureHostInterfaceBase>>(
            &data_->receiver, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::ResourceProvider_GetVideoCaptureHost_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ResourceProvider_GetVideoEncoderMetricsProvider_ParamsDataView {
 public:
  ResourceProvider_GetVideoEncoderMetricsProvider_ParamsDataView() = default;

  ResourceProvider_GetVideoEncoderMetricsProvider_ParamsDataView(
      internal::ResourceProvider_GetVideoEncoderMetricsProvider_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeReceiver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::media::mojom::VideoEncoderMetricsProviderInterfaceBase>>(
            &data_->receiver, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::ResourceProvider_GetVideoEncoderMetricsProvider_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ResourceProvider_GetNetworkContext_ParamsDataView {
 public:
  ResourceProvider_GetNetworkContext_ParamsDataView() = default;

  ResourceProvider_GetNetworkContext_ParamsDataView(
      internal::ResourceProvider_GetNetworkContext_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeReceiver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::network::mojom::NetworkContextInterfaceBase>>(
            &data_->receiver, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::ResourceProvider_GetNetworkContext_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ResourceProvider_CreateAudioStream_ParamsDataView {
 public:
  ResourceProvider_CreateAudioStream_ParamsDataView() = default;

  ResourceProvider_CreateAudioStream_ParamsDataView(
      internal::ResourceProvider_CreateAudioStream_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeClient() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::mirroring::mojom::AudioStreamCreatorClientInterfaceBase>>(
            &data_->client, &result, message_);
    DCHECK(ret);
    return result;
  }
  inline void GetParamDataView(
      ::media::mojom::AudioParametersDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadParam(UserType* output) {
    
    auto* pointer = data_->param.Get();
    return mojo::internal::Deserialize<::media::mojom::AudioParametersDataView>(
        pointer, output, message_);
  }
  uint32_t shared_memory_count() const {
    return data_->shared_memory_count;
  }
 private:
  internal::ResourceProvider_CreateAudioStream_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ResourceProvider_ConnectToRemotingSource_ParamsDataView {
 public:
  ResourceProvider_ConnectToRemotingSource_ParamsDataView() = default;

  ResourceProvider_ConnectToRemotingSource_ParamsDataView(
      internal::ResourceProvider_ConnectToRemotingSource_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeRemoter() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::media::mojom::RemoterInterfaceBase>>(
            &data_->remoter, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeReceiver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::media::mojom::RemotingSourceInterfaceBase>>(
            &data_->receiver, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::ResourceProvider_ConnectToRemotingSource_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};

inline void AudioStreamCreatorClient_StreamCreated_ParamsDataView::GetDataPipeDataView(
    ::media::mojom::ReadWriteAudioDataPipeDataView* output) {
  auto pointer = data_->data_pipe.Get();
  *output = ::media::mojom::ReadWriteAudioDataPipeDataView(pointer, message_);
}










inline void ResourceProvider_CreateAudioStream_ParamsDataView::GetParamDataView(
    ::media::mojom::AudioParametersDataView* output) {
  auto pointer = data_->param.Get();
  *output = ::media::mojom::AudioParametersDataView(pointer, message_);
}





}  // mirroring::mojom

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // COMPONENTS_MIRRORING_MOJOM_RESOURCE_PROVIDER_MOJOM_PARAMS_DATA_H_