// components/mirroring/mojom/mirroring_service.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/mirroring/mojom/mirroring_service.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/mirroring/mojom/mirroring_service.mojom-params-data.h"
#include "components/mirroring/mojom/mirroring_service.mojom-shared-message-ids.h"

#include "components/mirroring/mojom/mirroring_service.mojom-import-headers.h"
#include "components/mirroring/mojom/mirroring_service.mojom-test-utils.h"


namespace mirroring::mojom {
// The declaration includes the definition on other builds.

MirroringService::IPCStableHashFunction MirroringService::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::MirroringService>(message.name())) {
    case messages::MirroringService::kStart: {
      return &MirroringService::Start_Sym::IPCStableHash;
    }
    case messages::MirroringService::kSwitchMirroringSourceTab: {
      return &MirroringService::SwitchMirroringSourceTab_Sym::IPCStableHash;
    }
    case messages::MirroringService::kGetMirroringStats: {
      return &MirroringService::GetMirroringStats_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* MirroringService::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::MirroringService>(message.name())) {
      case messages::MirroringService::kStart:
            return "Receive mirroring::mojom::MirroringService::Start";
      case messages::MirroringService::kSwitchMirroringSourceTab:
            return "Receive mirroring::mojom::MirroringService::SwitchMirroringSourceTab";
      case messages::MirroringService::kGetMirroringStats:
            return "Receive mirroring::mojom::MirroringService::GetMirroringStats";
    }
  } else {
    switch (static_cast<messages::MirroringService>(message.name())) {
      case messages::MirroringService::kStart:
            return "Receive reply mirroring::mojom::MirroringService::Start";
      case messages::MirroringService::kSwitchMirroringSourceTab:
            return "Receive reply mirroring::mojom::MirroringService::SwitchMirroringSourceTab";
      case messages::MirroringService::kGetMirroringStats:
            return "Receive reply mirroring::mojom::MirroringService::GetMirroringStats";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t MirroringService::Start_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0e6dc033;  // IPCStableHash for mirroring::mojom::MirroringService::Start
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MirroringService::SwitchMirroringSourceTab_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7007e0e7;  // IPCStableHash for mirroring::mojom::MirroringService::SwitchMirroringSourceTab
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MirroringService::GetMirroringStats_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb30c9976;  // IPCStableHash for mirroring::mojom::MirroringService::GetMirroringStats
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class MirroringService_GetMirroringStats_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  MirroringService_GetMirroringStats_ForwardToCallback(
      MirroringService::GetMirroringStatsCallback callback
      ) : callback_(std::move(callback)) {
  }

  MirroringService_GetMirroringStats_ForwardToCallback(const MirroringService_GetMirroringStats_ForwardToCallback&) = delete;
  MirroringService_GetMirroringStats_ForwardToCallback& operator=(const MirroringService_GetMirroringStats_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  MirroringService::GetMirroringStatsCallback callback_;
};

MirroringServiceProxy::MirroringServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void MirroringServiceProxy::Start(
    ::mirroring::mojom::SessionParametersPtr in_params, const ::gfx::Size& in_max_resolution, ::mojo::PendingRemote<::mirroring::mojom::SessionObserver> in_observer, ::mojo::PendingRemote<::mirroring::mojom::ResourceProvider> in_resource_provider, ::mojo::PendingRemote<::mirroring::mojom::CastMessageChannel> in_outbound_channel, ::mojo::PendingReceiver<::mirroring::mojom::CastMessageChannel> in_inbound_channel) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send mirroring::mojom::MirroringService::Start", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type ::mirroring::mojom::SessionParametersPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("max_resolution"), in_max_resolution,
                        "<value of type const ::gfx::Size&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("observer"), in_observer,
                        "<value of type ::mojo::PendingRemote<::mirroring::mojom::SessionObserver>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("resource_provider"), in_resource_provider,
                        "<value of type ::mojo::PendingRemote<::mirroring::mojom::ResourceProvider>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("outbound_channel"), in_outbound_channel,
                        "<value of type ::mojo::PendingRemote<::mirroring::mojom::CastMessageChannel>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("inbound_channel"), in_inbound_channel,
                        "<value of type ::mojo::PendingReceiver<::mirroring::mojom::CastMessageChannel>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MirroringService::kStart), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::mirroring::mojom::internal::MirroringService_Start_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  
  mojo::internal::Serialize<::mirroring::mojom::SessionParametersDataView>(
    in_params,
    params_fragment);

  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->params.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null params in MirroringService.Start request");
  mojo::internal::MessageFragment<
      typename decltype(params->max_resolution)::BaseType> max_resolution_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
    in_max_resolution,
    max_resolution_fragment);

  params->max_resolution.Set(
      max_resolution_fragment.is_null() ? nullptr : max_resolution_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->max_resolution.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null max_resolution in MirroringService.Start request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::mirroring::mojom::SessionObserverInterfaceBase>>(
    in_observer,
    &params->observer,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->observer)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid observer in MirroringService.Start request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::mirroring::mojom::ResourceProviderInterfaceBase>>(
    in_resource_provider,
    &params->resource_provider,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->resource_provider)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid resource_provider in MirroringService.Start request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::mirroring::mojom::CastMessageChannelInterfaceBase>>(
    in_outbound_channel,
    &params->outbound_channel,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->outbound_channel)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid outbound_channel in MirroringService.Start request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::mirroring::mojom::CastMessageChannelInterfaceBase>>(
    in_inbound_channel,
    &params->inbound_channel,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->inbound_channel)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid inbound_channel in MirroringService.Start request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MirroringService::Name_);
  message.set_method_name("Start");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MirroringServiceProxy::SwitchMirroringSourceTab(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send mirroring::mojom::MirroringService::SwitchMirroringSourceTab");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MirroringService::kSwitchMirroringSourceTab), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::mirroring::mojom::internal::MirroringService_SwitchMirroringSourceTab_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MirroringService::Name_);
  message.set_method_name("SwitchMirroringSourceTab");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MirroringServiceProxy::GetMirroringStats(
    GetMirroringStatsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send mirroring::mojom::MirroringService::GetMirroringStats");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MirroringService::kGetMirroringStats), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::mirroring::mojom::internal::MirroringService_GetMirroringStats_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MirroringService::Name_);
  message.set_method_name("GetMirroringStats");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new MirroringService_GetMirroringStats_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class MirroringService_GetMirroringStats_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static MirroringService::GetMirroringStatsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<MirroringService_GetMirroringStats_ProxyToResponder> proxy(
        new MirroringService_GetMirroringStats_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&MirroringService_GetMirroringStats_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~MirroringService_GetMirroringStats_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  MirroringService_GetMirroringStats_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "MirroringService::GetMirroringStatsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::base::Value in_json_stats);
};

bool MirroringService_GetMirroringStats_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::MirroringService_GetMirroringStats_ResponseParams_Data* params =
      reinterpret_cast<
          internal::MirroringService_GetMirroringStats_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for MirroringService.2
  bool success = true;
  ::base::Value p_json_stats{};
  MirroringService_GetMirroringStats_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadJsonStats(&p_json_stats))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        MirroringService::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_json_stats));
  }
  return true;
}

void MirroringService_GetMirroringStats_ProxyToResponder::Run(
    ::base::Value in_json_stats) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply mirroring::mojom::MirroringService::GetMirroringStats", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("json_stats"), in_json_stats,
                        "<value of type ::base::Value>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MirroringService::kGetMirroringStats), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::mirroring::mojom::internal::MirroringService_GetMirroringStats_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->json_stats)>
      json_stats_fragment(params.message());
  json_stats_fragment.Claim(&params->json_stats);
  
  mojo::internal::Serialize<::mojo_base::mojom::ValueDataView>(
    in_json_stats,
    json_stats_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->json_stats.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null json_stats in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MirroringService::Name_);
  message.set_method_name("GetMirroringStats");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool MirroringServiceStubDispatch::Accept(
    MirroringService* impl,
    mojo::Message* message) {
  switch (static_cast<messages::MirroringService>(message->header()->name)) {
    case messages::MirroringService::kStart: {
      DCHECK(message->is_serialized());
      internal::MirroringService_Start_Params_Data* params =
          reinterpret_cast<internal::MirroringService_Start_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MirroringService.0
      bool success = true;
      ::mirroring::mojom::SessionParametersPtr p_params{};
      ::gfx::Size p_max_resolution{};
      ::mojo::PendingRemote<::mirroring::mojom::SessionObserver> p_observer{};
      ::mojo::PendingRemote<::mirroring::mojom::ResourceProvider> p_resource_provider{};
      ::mojo::PendingRemote<::mirroring::mojom::CastMessageChannel> p_outbound_channel{};
      ::mojo::PendingReceiver<::mirroring::mojom::CastMessageChannel> p_inbound_channel{};
      MirroringService_Start_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (success && !input_data_view.ReadMaxResolution(&p_max_resolution))
        success = false;
      if (success) {
        p_observer =
            input_data_view.TakeObserver<decltype(p_observer)>();
      }
      if (success) {
        p_resource_provider =
            input_data_view.TakeResourceProvider<decltype(p_resource_provider)>();
      }
      if (success) {
        p_outbound_channel =
            input_data_view.TakeOutboundChannel<decltype(p_outbound_channel)>();
      }
      if (success) {
        p_inbound_channel =
            input_data_view.TakeInboundChannel<decltype(p_inbound_channel)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MirroringService::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Start(        
        std::move(p_params), 
        std::move(p_max_resolution), 
        std::move(p_observer), 
        std::move(p_resource_provider), 
        std::move(p_outbound_channel), 
        std::move(p_inbound_channel));
      return true;
    }
    case messages::MirroringService::kSwitchMirroringSourceTab: {
      DCHECK(message->is_serialized());
      internal::MirroringService_SwitchMirroringSourceTab_Params_Data* params =
          reinterpret_cast<internal::MirroringService_SwitchMirroringSourceTab_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MirroringService.1
      bool success = true;
      MirroringService_SwitchMirroringSourceTab_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MirroringService::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SwitchMirroringSourceTab(        );
      return true;
    }
    case messages::MirroringService::kGetMirroringStats: {
      break;
    }
  }
  return false;
}

// static
bool MirroringServiceStubDispatch::AcceptWithResponder(
    MirroringService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::MirroringService>(message->header()->name)) {
    case messages::MirroringService::kStart: {
      break;
    }
    case messages::MirroringService::kSwitchMirroringSourceTab: {
      break;
    }
    case messages::MirroringService::kGetMirroringStats: {
      internal::MirroringService_GetMirroringStats_Params_Data* params =
          reinterpret_cast<
              internal::MirroringService_GetMirroringStats_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for MirroringService.2
      bool success = true;
      MirroringService_GetMirroringStats_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MirroringService::Name_, 2, false);
        return false;
      }
      auto callback =
          MirroringService_GetMirroringStats_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetMirroringStats(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kMirroringServiceValidationInfo[] = {
    { &internal::MirroringService_Start_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MirroringService_SwitchMirroringSourceTab_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MirroringService_GetMirroringStats_Params_Data::Validate,
     &internal::MirroringService_GetMirroringStats_ResponseParams_Data::Validate},
};

bool MirroringServiceRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::mirroring::mojom::MirroringService::Name_,
    kMirroringServiceValidationInfo);
}

bool MirroringServiceResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::mirroring::mojom::MirroringService::Name_,
    kMirroringServiceValidationInfo);
}


}  // mirroring::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace mirroring::mojom {


void MirroringServiceInterceptorForTesting::Start(::mirroring::mojom::SessionParametersPtr params, const ::gfx::Size& max_resolution, ::mojo::PendingRemote<::mirroring::mojom::SessionObserver> observer, ::mojo::PendingRemote<::mirroring::mojom::ResourceProvider> resource_provider, ::mojo::PendingRemote<::mirroring::mojom::CastMessageChannel> outbound_channel, ::mojo::PendingReceiver<::mirroring::mojom::CastMessageChannel> inbound_channel) {
  GetForwardingInterface()->Start(
    std::move(params)
    , 
    std::move(max_resolution)
    , 
    std::move(observer)
    , 
    std::move(resource_provider)
    , 
    std::move(outbound_channel)
    , 
    std::move(inbound_channel)
    );
}
void MirroringServiceInterceptorForTesting::SwitchMirroringSourceTab() {
  GetForwardingInterface()->SwitchMirroringSourceTab();
}
void MirroringServiceInterceptorForTesting::GetMirroringStats(GetMirroringStatsCallback callback) {
  GetForwardingInterface()->GetMirroringStats(std::move(callback));
}
MirroringServiceAsyncWaiter::MirroringServiceAsyncWaiter(
    MirroringService* proxy) : proxy_(proxy) {}

MirroringServiceAsyncWaiter::~MirroringServiceAsyncWaiter() = default;


void MirroringServiceAsyncWaiter::GetMirroringStats(
    ::base::Value* out_json_stats) {
  base::RunLoop loop;
  proxy_->GetMirroringStats(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::base::Value* out_json_stats
,
             ::base::Value json_stats) {*out_json_stats = std::move(json_stats);
            loop->Quit();
          },
          &loop,
          out_json_stats));
  loop.Run();
}

::base::Value MirroringServiceAsyncWaiter::GetMirroringStats(
    ) {
  ::base::Value async_wait_result;
  GetMirroringStats(&async_wait_result);
  return async_wait_result;
}






}  // mirroring::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif