// components/mirroring/mojom/cast_message_channel.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/mirroring/mojom/cast_message_channel.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/mirroring/mojom/cast_message_channel.mojom-params-data.h"
#include "components/mirroring/mojom/cast_message_channel.mojom-shared-message-ids.h"

#include "components/mirroring/mojom/cast_message_channel.mojom-import-headers.h"
#include "components/mirroring/mojom/cast_message_channel.mojom-test-utils.h"


namespace mirroring::mojom {
CastMessage::CastMessage()
    : message_namespace(),
      json_format_data() {}

CastMessage::CastMessage(
    const std::string& message_namespace_in,
    const std::string& json_format_data_in)
    : message_namespace(std::move(message_namespace_in)),
      json_format_data(std::move(json_format_data_in)) {}

CastMessage::~CastMessage() = default;
size_t CastMessage::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->message_namespace);
  seed = mojo::internal::Hash(seed, this->json_format_data);
  return seed;
}

void CastMessage::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "message_namespace"), this->message_namespace,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "json_format_data"), this->json_format_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CastMessage::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

CastMessageChannel::IPCStableHashFunction CastMessageChannel::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::CastMessageChannel>(message.name())) {
    case messages::CastMessageChannel::kOnMessage: {
      return &CastMessageChannel::OnMessage_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* CastMessageChannel::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::CastMessageChannel>(message.name())) {
      case messages::CastMessageChannel::kOnMessage:
            return "Receive mirroring::mojom::CastMessageChannel::OnMessage";
    }
  } else {
    switch (static_cast<messages::CastMessageChannel>(message.name())) {
      case messages::CastMessageChannel::kOnMessage:
            return "Receive reply mirroring::mojom::CastMessageChannel::OnMessage";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t CastMessageChannel::OnMessage_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa9ee6856;  // IPCStableHash for mirroring::mojom::CastMessageChannel::OnMessage
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

CastMessageChannelProxy::CastMessageChannelProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void CastMessageChannelProxy::OnMessage(
    CastMessagePtr in_message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send mirroring::mojom::CastMessageChannel::OnMessage", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("message"), in_message,
                        "<value of type CastMessagePtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CastMessageChannel::kOnMessage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::mirroring::mojom::internal::CastMessageChannel_OnMessage_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->message)::BaseType> message_fragment(
          params.message());
  
  mojo::internal::Serialize<::mirroring::mojom::CastMessageDataView>(
    in_message,
    message_fragment);

  params->message.Set(
      message_fragment.is_null() ? nullptr : message_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->message.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null message in CastMessageChannel.OnMessage request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CastMessageChannel::Name_);
  message.set_method_name("OnMessage");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool CastMessageChannelStubDispatch::Accept(
    CastMessageChannel* impl,
    mojo::Message* message) {
  switch (static_cast<messages::CastMessageChannel>(message->header()->name)) {
    case messages::CastMessageChannel::kOnMessage: {
      DCHECK(message->is_serialized());
      internal::CastMessageChannel_OnMessage_Params_Data* params =
          reinterpret_cast<internal::CastMessageChannel_OnMessage_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CastMessageChannel.0
      bool success = true;
      CastMessagePtr p_message{};
      CastMessageChannel_OnMessage_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMessage(&p_message))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CastMessageChannel::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnMessage(        
        std::move(p_message));
      return true;
    }
  }
  return false;
}

// static
bool CastMessageChannelStubDispatch::AcceptWithResponder(
    CastMessageChannel* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::CastMessageChannel>(message->header()->name)) {
    case messages::CastMessageChannel::kOnMessage: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kCastMessageChannelValidationInfo[] = {
    { &internal::CastMessageChannel_OnMessage_Params_Data::Validate,
     nullptr /* no response */},
};

bool CastMessageChannelRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::mirroring::mojom::CastMessageChannel::Name_,
    kCastMessageChannelValidationInfo);
}



}  // mirroring::mojom


namespace mojo {


// static
bool StructTraits<::mirroring::mojom::CastMessage::DataView, ::mirroring::mojom::CastMessagePtr>::Read(
    ::mirroring::mojom::CastMessage::DataView input,
    ::mirroring::mojom::CastMessagePtr* output) {
  bool success = true;
  ::mirroring::mojom::CastMessagePtr result(::mirroring::mojom::CastMessage::New());
  
      if (success && !input.ReadMessageNamespace(&result->message_namespace))
        success = false;
      if (success && !input.ReadJsonFormatData(&result->json_format_data))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace mirroring::mojom {


void CastMessageChannelInterceptorForTesting::OnMessage(CastMessagePtr message) {
  GetForwardingInterface()->OnMessage(
    std::move(message)
    );
}
CastMessageChannelAsyncWaiter::CastMessageChannelAsyncWaiter(
    CastMessageChannel* proxy) : proxy_(proxy) {}

CastMessageChannelAsyncWaiter::~CastMessageChannelAsyncWaiter() = default;







}  // mirroring::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif