// components/metrics/structured/mojom/event.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/metrics/structured/mojom/event.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/metrics/structured/mojom/event.mojom-params-data.h"
#include "components/metrics/structured/mojom/event.mojom-shared-message-ids.h"

#include "components/metrics/structured/mojom/event.mojom-import-headers.h"
#include "components/metrics/structured/mojom/event.mojom-test-utils.h"


namespace metrics::structured::mojom {
Event::Event()
    : project_name(),
      event_name(),
      metrics(),
      system_uptime(),
      is_event_sequence() {}

Event::Event(
    const std::string& project_name_in,
    const std::string& event_name_in,
    base::flat_map<std::string, MetricValuePtr> metrics_in)
    : project_name(std::move(project_name_in)),
      event_name(std::move(event_name_in)),
      metrics(std::move(metrics_in)),
      system_uptime(),
      is_event_sequence() {}

Event::Event(
    const std::string& project_name_in,
    const std::string& event_name_in,
    base::flat_map<std::string, MetricValuePtr> metrics_in,
    std::optional<::base::TimeDelta> system_uptime_in,
    bool is_event_sequence_in)
    : project_name(std::move(project_name_in)),
      event_name(std::move(event_name_in)),
      metrics(std::move(metrics_in)),
      system_uptime(std::move(system_uptime_in)),
      is_event_sequence(std::move(is_event_sequence_in)) {}

Event::~Event() = default;

void Event::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "project_name"), this->project_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "event_name"), this->event_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "metrics"), this->metrics,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type base::flat_map<std::string, MetricValuePtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "system_uptime"), this->system_uptime,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::base::TimeDelta>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_event_sequence"), this->is_event_sequence,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Event::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
MetricValuePtr
MetricValue::NewHmacValue(
    const std::string& value) {
  return MetricValuePtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kHmacValue)>,
      std::move(value));
}

MetricValuePtr
MetricValue::NewLongValue(
    int64_t value) {
  return MetricValuePtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kLongValue)>,
      std::move(value));
}

MetricValuePtr
MetricValue::NewIntValue(
    int32_t value) {
  return MetricValuePtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kIntValue)>,
      std::move(value));
}

MetricValuePtr
MetricValue::NewDoubleValue(
    double value) {
  return MetricValuePtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kDoubleValue)>,
      std::move(value));
}

MetricValuePtr
MetricValue::NewRawStrValue(
    const std::string& value) {
  return MetricValuePtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kRawStrValue)>,
      std::move(value));
}

MetricValuePtr
MetricValue::NewBoolValue(
    bool value) {
  return MetricValuePtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kBoolValue)>,
      std::move(value));
}

MetricValue::MetricValue(
    std::in_place_index_t<static_cast<size_t>(Tag::kHmacValue)>,
    const std::string& value)
    : tag_(Tag::kHmacValue),
      data_(std::in_place_index<static_cast<size_t>(Tag::kHmacValue)>,
            std::move(value)) {}

MetricValue::MetricValue(
    std::in_place_index_t<static_cast<size_t>(Tag::kLongValue)>,
    int64_t value)
    : tag_(Tag::kLongValue),
      data_(std::in_place_index<static_cast<size_t>(Tag::kLongValue)>,
            std::move(value)) {}

MetricValue::MetricValue(
    std::in_place_index_t<static_cast<size_t>(Tag::kIntValue)>,
    int32_t value)
    : tag_(Tag::kIntValue),
      data_(std::in_place_index<static_cast<size_t>(Tag::kIntValue)>,
            std::move(value)) {}

MetricValue::MetricValue(
    std::in_place_index_t<static_cast<size_t>(Tag::kDoubleValue)>,
    double value)
    : tag_(Tag::kDoubleValue),
      data_(std::in_place_index<static_cast<size_t>(Tag::kDoubleValue)>,
            std::move(value)) {}

MetricValue::MetricValue(
    std::in_place_index_t<static_cast<size_t>(Tag::kRawStrValue)>,
    const std::string& value)
    : tag_(Tag::kRawStrValue),
      data_(std::in_place_index<static_cast<size_t>(Tag::kRawStrValue)>,
            std::move(value)) {}

MetricValue::MetricValue(
    std::in_place_index_t<static_cast<size_t>(Tag::kBoolValue)>,
    bool value)
    : tag_(Tag::kBoolValue),
      data_(std::in_place_index<static_cast<size_t>(Tag::kBoolValue)>,
            std::move(value)) {}
MetricValue::~MetricValue() {
  DestroyActive();
}

void MetricValue::set_hmac_value(const std::string& hmac_value) {
  if (tag_ == Tag::kHmacValue) {
    data_.hmac_value = std::move(hmac_value);
  } else {
    DestroyActive();
    tag_ = Tag::kHmacValue;
    new (&data_.hmac_value) std::string(
        std::move(hmac_value));
  }
}

void MetricValue::set_long_value(int64_t long_value) {
  if (tag_ != Tag::kLongValue) {
    DestroyActive();
    tag_ = Tag::kLongValue;
  }
  data_.long_value = long_value;
}

void MetricValue::set_int_value(int32_t int_value) {
  if (tag_ != Tag::kIntValue) {
    DestroyActive();
    tag_ = Tag::kIntValue;
  }
  data_.int_value = int_value;
}

void MetricValue::set_double_value(double double_value) {
  if (tag_ != Tag::kDoubleValue) {
    DestroyActive();
    tag_ = Tag::kDoubleValue;
  }
  data_.double_value = double_value;
}

void MetricValue::set_raw_str_value(const std::string& raw_str_value) {
  if (tag_ == Tag::kRawStrValue) {
    data_.raw_str_value = std::move(raw_str_value);
  } else {
    DestroyActive();
    tag_ = Tag::kRawStrValue;
    new (&data_.raw_str_value) std::string(
        std::move(raw_str_value));
  }
}

void MetricValue::set_bool_value(bool bool_value) {
  if (tag_ != Tag::kBoolValue) {
    DestroyActive();
    tag_ = Tag::kBoolValue;
  }
  data_.bool_value = bool_value;
}


MetricValue::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kHmacValue)>,
    const std::string& value)
    : hmac_value(std::move(value)) {}

MetricValue::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kLongValue)>,
    int64_t value)
    : long_value(std::move(value)) {}

MetricValue::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kIntValue)>,
    int32_t value)
    : int_value(std::move(value)) {}

MetricValue::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kDoubleValue)>,
    double value)
    : double_value(std::move(value)) {}

MetricValue::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kRawStrValue)>,
    const std::string& value)
    : raw_str_value(std::move(value)) {}

MetricValue::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kBoolValue)>,
    bool value)
    : bool_value(std::move(value)) {}

void MetricValue::DestroyActive() {
  switch (tag_) {

    case Tag::kHmacValue:
      std::destroy_at(&data_.hmac_value);
      break;
    case Tag::kLongValue:
      std::destroy_at(&data_.long_value);
      break;
    case Tag::kIntValue:
      std::destroy_at(&data_.int_value);
      break;
    case Tag::kDoubleValue:
      std::destroy_at(&data_.double_value);
      break;
    case Tag::kRawStrValue:
      std::destroy_at(&data_.raw_str_value);
      break;
    case Tag::kBoolValue:
      std::destroy_at(&data_.bool_value);
      break;
  }
}
size_t MetricValue::Hash(size_t seed) const {
  seed = mojo::internal::HashCombine(seed, static_cast<uint32_t>(tag_));
  switch (tag_) {

    case Tag::kHmacValue:
      return mojo::internal::Hash(seed, data_.hmac_value);
    case Tag::kLongValue:
      return mojo::internal::Hash(seed, data_.long_value);
    case Tag::kIntValue:
      return mojo::internal::Hash(seed, data_.int_value);
    case Tag::kDoubleValue:
      return mojo::internal::Hash(seed, data_.double_value);
    case Tag::kRawStrValue:
      return mojo::internal::Hash(seed, data_.raw_str_value);
    case Tag::kBoolValue:
      return mojo::internal::Hash(seed, data_.bool_value);
    default:
      NOTREACHED();
  }
}

bool MetricValue::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}


}  // metrics::structured::mojom


namespace mojo {


// static
bool StructTraits<::metrics::structured::mojom::Event::DataView, ::metrics::structured::mojom::EventPtr>::Read(
    ::metrics::structured::mojom::Event::DataView input,
    ::metrics::structured::mojom::EventPtr* output) {
  bool success = true;
  ::metrics::structured::mojom::EventPtr result(::metrics::structured::mojom::Event::New());
  
      if (success && !input.ReadProjectName(&result->project_name))
        success = false;
      if (success && !input.ReadEventName(&result->event_name))
        success = false;
      if (success && !input.ReadMetrics(&result->metrics))
        success = false;
      if (success && !input.ReadSystemUptime(&result->system_uptime))
        success = false;
      if (success)
        result->is_event_sequence = input.is_event_sequence();
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::metrics::structured::mojom::MetricValue::DataView, ::metrics::structured::mojom::MetricValuePtr>::Read(
    ::metrics::structured::mojom::MetricValue::DataView input,
    ::metrics::structured::mojom::MetricValuePtr* output) {
  using UnionType = ::metrics::structured::mojom::MetricValue;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kHmacValue: {
      std::string result_hmac_value{};
      if (!input.ReadHmacValue(&result_hmac_value))
        return false;

      *output = UnionType::NewHmacValue(
          std::move(result_hmac_value));
      break;
    }
    case Tag::kLongValue: {
      *output = UnionType::NewLongValue(input.long_value());
      break;
    }
    case Tag::kIntValue: {
      *output = UnionType::NewIntValue(input.int_value());
      break;
    }
    case Tag::kDoubleValue: {
      *output = UnionType::NewDoubleValue(input.double_value());
      break;
    }
    case Tag::kRawStrValue: {
      std::string result_raw_str_value{};
      if (!input.ReadRawStrValue(&result_raw_str_value))
        return false;

      *output = UnionType::NewRawStrValue(
          std::move(result_raw_str_value));
      break;
    }
    case Tag::kBoolValue: {
      *output = UnionType::NewBoolValue(input.bool_value());
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace metrics::structured::mojom {




}  // metrics::structured::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif