// components/metrics/structured/mojom/event.mojom-shared-internal.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_METRICS_STRUCTURED_MOJOM_EVENT_MOJOM_SHARED_INTERNAL_H_
#define COMPONENTS_METRICS_STRUCTURED_MOJOM_EVENT_MOJOM_SHARED_INTERNAL_H_
#include "mojo/public/cpp/bindings/lib/array_internal.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/map_data_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"
#include "mojo/public/mojom/base/time.mojom-shared-internal.h"
#include "mojo/public/cpp/bindings/lib/native_enum_data.h"
#include "mojo/public/interfaces/bindings/native_struct.mojom-shared-internal.h"



namespace mojo {
namespace internal {
class ValidationContext;
}
}


namespace metrics::structured::mojom {
namespace internal {
class Event_Data;
class MetricValue_Data;

#pragma pack(push, 1)


class  MetricValue_Data {
 public:
  // Used to identify Mojom Union Data Classes.
  typedef void MojomUnionDataType;

  MetricValue_Data() = default;
  // Do nothing in the destructor since it won't be called when it is a
  // non-inlined union.
  ~MetricValue_Data() = default;

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context,
                       bool inlined);

  bool is_null() const { return size == 0; }

  void set_null() {
    size = 0U;
    tag = static_cast<MetricValue_Tag>(0);
    data.unknown = 0U;
  }

  // TODO(crbug.com/40731316): SHOUTY_CASE values are being deprecated per C++ code style
  // guidelines (https://google.github.io/styleguide/cppguide.html#Enumerator_Names),
  // please use kCamelCase values instead.  Cleanup NULL_VALUE, BOOL_VALUE, INT_VALUE, etc.
  // generation once codebase is transitioned to kNullValue, kBoolValue, kIntValue, etc.
  enum class MetricValue_Tag : uint32_t {

    
    kHmacValue,
    
    kLongValue,
    
    kIntValue,
    
    kDoubleValue,
    
    kRawStrValue,
    
    kBoolValue,
  };

  // A note on layout:
  // "Each non-static data member is allocated as if it were the sole member of
  // a struct." - Section 9.5.2 ISO/IEC 14882:2011 (The C++ Spec)
  union MOJO_ALIGNAS(8) Union_ {
    Union_() : unknown(0) {}
    mojo::internal::Pointer<mojo::internal::String_Data> f_hmac_value;
    int64_t f_long_value;
    int32_t f_int_value;
    double f_double_value;
    mojo::internal::Pointer<mojo::internal::String_Data> f_raw_str_value;
    uint8_t f_bool_value : 1;
    uint64_t unknown;
  };

  uint32_t size;
  MetricValue_Tag tag;
  Union_ data;
};
static_assert(sizeof(MetricValue_Data) == mojo::internal::kUnionDataSize,
              "Bad sizeof(MetricValue_Data)");
class  Event_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> project_name;
  mojo::internal::Pointer<mojo::internal::String_Data> event_name;
  mojo::internal::Pointer<mojo::internal::Map_Data<mojo::internal::Pointer<mojo::internal::String_Data>, internal::MetricValue_Data>> metrics;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeDelta_Data> system_uptime;
  uint8_t is_event_sequence : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<Event_Data>;

  Event_Data();
  ~Event_Data() = delete;
};
static_assert(sizeof(Event_Data) == 48,
              "Bad sizeof(Event_Data)");
// Used by Event::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct Event_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  Event_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~Event_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<Event_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    Event_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};

#pragma pack(pop)

}  // namespace internal

}  // metrics::structured::mojom

#endif  // COMPONENTS_METRICS_STRUCTURED_MOJOM_EVENT_MOJOM_SHARED_INTERNAL_H_