// components/metrics/public/mojom/call_stack_profile_collector.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/metrics/public/mojom/call_stack_profile_collector.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/metrics/public/mojom/call_stack_profile_collector.mojom-params-data.h"
#include "components/metrics/public/mojom/call_stack_profile_collector.mojom-shared-message-ids.h"

#include "components/metrics/public/mojom/call_stack_profile_collector.mojom-import-headers.h"
#include "components/metrics/public/mojom/call_stack_profile_collector.mojom-test-utils.h"


namespace metrics::mojom {
SampledProfile::SampledProfile()
    : contents(mojo::internal::DefaultConstructTag()) {}

SampledProfile::SampledProfile(
    ::mojo_base::ProtoWrapper contents_in)
    : contents(std::move(contents_in)) {}

SampledProfile::~SampledProfile() = default;

void SampledProfile::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "contents"), this->contents,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo_base::ProtoWrapper>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SampledProfile::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

CallStackProfileCollector::IPCStableHashFunction CallStackProfileCollector::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::CallStackProfileCollector>(message.name())) {
    case messages::CallStackProfileCollector::kCollect: {
      return &CallStackProfileCollector::Collect_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* CallStackProfileCollector::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::CallStackProfileCollector>(message.name())) {
      case messages::CallStackProfileCollector::kCollect:
            return "Receive metrics::mojom::CallStackProfileCollector::Collect";
    }
  } else {
    switch (static_cast<messages::CallStackProfileCollector>(message.name())) {
      case messages::CallStackProfileCollector::kCollect:
            return "Receive reply metrics::mojom::CallStackProfileCollector::Collect";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t CallStackProfileCollector::Collect_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xbdaf46a8;  // IPCStableHash for metrics::mojom::CallStackProfileCollector::Collect
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

CallStackProfileCollectorProxy::CallStackProfileCollectorProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void CallStackProfileCollectorProxy::Collect(
    ::base::TimeTicks in_start_timestamp, ProfileType in_profile_type, SampledProfilePtr in_profile) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send metrics::mojom::CallStackProfileCollector::Collect", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("start_timestamp"), in_start_timestamp,
                        "<value of type ::base::TimeTicks>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("profile_type"), in_profile_type,
                        "<value of type ProfileType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("profile"), in_profile,
                        "<value of type SampledProfilePtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CallStackProfileCollector::kCollect), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::metrics::mojom::internal::CallStackProfileCollector_Collect_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->start_timestamp)::BaseType> start_timestamp_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
    in_start_timestamp,
    start_timestamp_fragment);

  params->start_timestamp.Set(
      start_timestamp_fragment.is_null() ? nullptr : start_timestamp_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->start_timestamp.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null start_timestamp in CallStackProfileCollector.Collect request");

  
  mojo::internal::Serialize<::metrics::mojom::ProfileType>(
    in_profile_type,
    &params->profile_type);
  mojo::internal::MessageFragment<
      typename decltype(params->profile)::BaseType> profile_fragment(
          params.message());
  
  mojo::internal::Serialize<::metrics::mojom::SampledProfileDataView>(
    in_profile,
    profile_fragment);

  params->profile.Set(
      profile_fragment.is_null() ? nullptr : profile_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->profile.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null profile in CallStackProfileCollector.Collect request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CallStackProfileCollector::Name_);
  message.set_method_name("Collect");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool CallStackProfileCollectorStubDispatch::Accept(
    CallStackProfileCollector* impl,
    mojo::Message* message) {
  switch (static_cast<messages::CallStackProfileCollector>(message->header()->name)) {
    case messages::CallStackProfileCollector::kCollect: {
      DCHECK(message->is_serialized());
      internal::CallStackProfileCollector_Collect_Params_Data* params =
          reinterpret_cast<internal::CallStackProfileCollector_Collect_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CallStackProfileCollector.0
      bool success = true;
      ::base::TimeTicks p_start_timestamp{};
      ProfileType p_profile_type{};
      SampledProfilePtr p_profile{};
      CallStackProfileCollector_Collect_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadStartTimestamp(&p_start_timestamp))
        success = false;
      if (success && !input_data_view.ReadProfileType(&p_profile_type))
        success = false;
      if (success && !input_data_view.ReadProfile(&p_profile))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CallStackProfileCollector::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Collect(        
        std::move(p_start_timestamp), 
        std::move(p_profile_type), 
        std::move(p_profile));
      return true;
    }
  }
  return false;
}

// static
bool CallStackProfileCollectorStubDispatch::AcceptWithResponder(
    CallStackProfileCollector* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::CallStackProfileCollector>(message->header()->name)) {
    case messages::CallStackProfileCollector::kCollect: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kCallStackProfileCollectorValidationInfo[] = {
    { &internal::CallStackProfileCollector_Collect_Params_Data::Validate,
     nullptr /* no response */},
};

bool CallStackProfileCollectorRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::metrics::mojom::CallStackProfileCollector::Name_,
    kCallStackProfileCollectorValidationInfo);
}



}  // metrics::mojom


namespace mojo {


// static
bool StructTraits<::metrics::mojom::SampledProfile::DataView, ::metrics::mojom::SampledProfilePtr>::Read(
    ::metrics::mojom::SampledProfile::DataView input,
    ::metrics::mojom::SampledProfilePtr* output) {
  bool success = true;
  ::metrics::mojom::SampledProfilePtr result(::metrics::mojom::SampledProfile::New());
  
      if (success && !input.ReadContents(&result->contents))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace metrics::mojom {


void CallStackProfileCollectorInterceptorForTesting::Collect(::base::TimeTicks start_timestamp, ProfileType profile_type, SampledProfilePtr profile) {
  GetForwardingInterface()->Collect(
    std::move(start_timestamp)
    , 
    std::move(profile_type)
    , 
    std::move(profile)
    );
}
CallStackProfileCollectorAsyncWaiter::CallStackProfileCollectorAsyncWaiter(
    CallStackProfileCollector* proxy) : proxy_(proxy) {}

CallStackProfileCollectorAsyncWaiter::~CallStackProfileCollectorAsyncWaiter() = default;







}  // metrics::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif