// components/metrics/private_metrics/mojom/private_metrics_interface.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/metrics/private_metrics/mojom/private_metrics_interface.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/metrics/private_metrics/mojom/private_metrics_interface.mojom-params-data.h"
#include "components/metrics/private_metrics/mojom/private_metrics_interface.mojom-shared-message-ids.h"

#include "components/metrics/private_metrics/mojom/private_metrics_interface.mojom-import-headers.h"
#include "components/metrics/private_metrics/mojom/private_metrics_interface.mojom-test-utils.h"


namespace metrics::private_metrics::mojom {
PrivateMetricsEntry::PrivateMetricsEntry()
    : event_hash(),
      content_hash(),
      source_id(),
      studies_of_interest(),
      metrics(),
      type() {}

PrivateMetricsEntry::PrivateMetricsEntry(
    uint64_t event_hash_in,
    std::optional<uint64_t> content_hash_in,
    std::optional<uint64_t> source_id_in,
    const base::flat_map<std::string, bool>& studies_of_interest_in,
    const base::flat_map<uint64_t, int64_t>& metrics_in,
    PrivateMetricsEntry::Type type_in)
    : event_hash(std::move(event_hash_in)),
      content_hash(std::move(content_hash_in)),
      source_id(std::move(source_id_in)),
      studies_of_interest(std::move(studies_of_interest_in)),
      metrics(std::move(metrics_in)),
      type(std::move(type_in)) {}

PrivateMetricsEntry::~PrivateMetricsEntry() = default;

void PrivateMetricsEntry::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "event_hash"), this->event_hash,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "content_hash"), this->content_hash,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<uint64_t>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "source_id"), this->source_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<uint64_t>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "studies_of_interest"), this->studies_of_interest,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const base::flat_map<std::string, bool>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "metrics"), this->metrics,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const base::flat_map<uint64_t, int64_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "type"), this->type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type PrivateMetricsEntry::Type>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PrivateMetricsEntry::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}


}  // metrics::private_metrics::mojom


namespace mojo {


// static
bool StructTraits<::metrics::private_metrics::mojom::PrivateMetricsEntry::DataView, ::metrics::private_metrics::mojom::PrivateMetricsEntryPtr>::Read(
    ::metrics::private_metrics::mojom::PrivateMetricsEntry::DataView input,
    ::metrics::private_metrics::mojom::PrivateMetricsEntryPtr* output) {
  bool success = true;
  ::metrics::private_metrics::mojom::PrivateMetricsEntryPtr result(::metrics::private_metrics::mojom::PrivateMetricsEntry::New());
  
      if (success)
        result->event_hash = input.event_hash();
      if (success) {
        result->content_hash = input.content_hash();
      }
      if (success) {
        result->source_id = input.source_id();
      }
      if (success && !input.ReadStudiesOfInterest(&result->studies_of_interest))
        success = false;
      if (success && !input.ReadMetrics(&result->metrics))
        success = false;
      if (success && !input.ReadType(&result->type))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace metrics::private_metrics::mojom {




}  // metrics::private_metrics::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif