// components/media_router/common/mojom/media_router.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/media_router/common/mojom/media_router.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/media_router/common/mojom/media_router.mojom-params-data.h"
#include "components/media_router/common/mojom/media_router.mojom-shared-message-ids.h"

#include "components/media_router/common/mojom/media_router.mojom-import-headers.h"
#include "components/media_router/common/mojom/media_router.mojom-test-utils.h"


namespace media_router::mojom {
MediaSink::MediaSink()
    : sink_id(),
      name(),
      icon_type(),
      provider_id(),
      extra_data() {}

MediaSink::MediaSink(
    const std::string& sink_id_in,
    const std::string& name_in,
    SinkIconType icon_type_in,
    ::media_router::mojom::MediaRouteProviderId provider_id_in,
    MediaSinkExtraDataPtr extra_data_in)
    : sink_id(std::move(sink_id_in)),
      name(std::move(name_in)),
      icon_type(std::move(icon_type_in)),
      provider_id(std::move(provider_id_in)),
      extra_data(std::move(extra_data_in)) {}

MediaSink::~MediaSink() = default;

void MediaSink::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sink_id"), this->sink_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "icon_type"), this->icon_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type SinkIconType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "provider_id"), this->provider_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::media_router::mojom::MediaRouteProviderId>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "extra_data"), this->extra_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type MediaSinkExtraDataPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool MediaSink::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DialMediaSink::DialMediaSink()
    : ip_address(),
      model_name(),
      app_url() {}

DialMediaSink::DialMediaSink(
    const ::net::IPAddress& ip_address_in,
    const std::string& model_name_in,
    const ::GURL& app_url_in)
    : ip_address(std::move(ip_address_in)),
      model_name(std::move(model_name_in)),
      app_url(std::move(app_url_in)) {}

DialMediaSink::~DialMediaSink() = default;

void DialMediaSink::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ip_address"), this->ip_address,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::net::IPAddress&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "model_name"), this->model_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "app_url"), this->app_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DialMediaSink::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CastMediaSink::CastMediaSink()
    : ip_endpoint(),
      model_name(),
      capabilities(),
      cast_channel_id() {}

CastMediaSink::CastMediaSink(
    const ::net::IPEndPoint& ip_endpoint_in,
    const std::string& model_name_in,
    uint64_t capabilities_in,
    int32_t cast_channel_id_in)
    : ip_endpoint(std::move(ip_endpoint_in)),
      model_name(std::move(model_name_in)),
      capabilities(std::move(capabilities_in)),
      cast_channel_id(std::move(cast_channel_id_in)) {}

CastMediaSink::~CastMediaSink() = default;

void CastMediaSink::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ip_endpoint"), this->ip_endpoint,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::net::IPEndPoint&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "model_name"), this->model_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "capabilities"), this->capabilities,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cast_channel_id"), this->cast_channel_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CastMediaSink::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
MediaRoute::MediaRoute()
    : media_route_id(),
      presentation_id(),
      media_source(),
      media_sink_id(),
      media_sink_name(),
      description(),
      is_local(),
      controller_type(),
      is_local_presentation(),
      is_connecting() {}

MediaRoute::MediaRoute(
    const std::string& media_route_id_in,
    const std::string& presentation_id_in,
    const std::optional<std::string>& media_source_in,
    const std::string& media_sink_id_in,
    const std::string& media_sink_name_in,
    const std::string& description_in,
    bool is_local_in,
    RouteControllerType controller_type_in,
    bool is_local_presentation_in,
    bool is_connecting_in)
    : media_route_id(std::move(media_route_id_in)),
      presentation_id(std::move(presentation_id_in)),
      media_source(std::move(media_source_in)),
      media_sink_id(std::move(media_sink_id_in)),
      media_sink_name(std::move(media_sink_name_in)),
      description(std::move(description_in)),
      is_local(std::move(is_local_in)),
      controller_type(std::move(controller_type_in)),
      is_local_presentation(std::move(is_local_presentation_in)),
      is_connecting(std::move(is_connecting_in)) {}

MediaRoute::~MediaRoute() = default;

void MediaRoute::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "media_route_id"), this->media_route_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "presentation_id"), this->presentation_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "media_source"), this->media_source,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "media_sink_id"), this->media_sink_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "media_sink_name"), this->media_sink_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "description"), this->description,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_local"), this->is_local,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "controller_type"), this->controller_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type RouteControllerType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_local_presentation"), this->is_local_presentation,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_connecting"), this->is_connecting,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool MediaRoute::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
Issue::Issue()
    : route_id(),
      sink_id(),
      severity(),
      title(),
      message() {}

Issue::Issue(
    const std::string& route_id_in,
    const std::string& sink_id_in,
    ::media_router::IssueInfo::Severity severity_in,
    const std::string& title_in,
    const std::optional<std::string>& message_in)
    : route_id(std::move(route_id_in)),
      sink_id(std::move(sink_id_in)),
      severity(std::move(severity_in)),
      title(std::move(title_in)),
      message(std::move(message_in)) {}

Issue::~Issue() = default;

void Issue::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "route_id"), this->route_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sink_id"), this->sink_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "severity"), this->severity,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::media_router::IssueInfo::Severity>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "title"), this->title,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "message"), this->message,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Issue::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
RouteMessage::RouteMessage()
    : type(),
      message(),
      data() {}

RouteMessage::RouteMessage(
    RouteMessage::Type type_in,
    const std::optional<std::string>& message_in,
    std::optional<std::vector<uint8_t>> data_in)
    : type(std::move(type_in)),
      message(std::move(message_in)),
      data(std::move(data_in)) {}

RouteMessage::~RouteMessage() = default;

void RouteMessage::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "type"), this->type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type RouteMessage::Type>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "message"), this->message,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "data"), this->data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::vector<uint8_t>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool RouteMessage::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
RoutePresentationConnection::RoutePresentationConnection()
    : connection_remote(),
      connection_receiver() {}

RoutePresentationConnection::RoutePresentationConnection(
    ::mojo::PendingRemote<::blink::mojom::PresentationConnection> connection_remote_in,
    ::mojo::PendingReceiver<::blink::mojom::PresentationConnection> connection_receiver_in)
    : connection_remote(std::move(connection_remote_in)),
      connection_receiver(std::move(connection_receiver_in)) {}

RoutePresentationConnection::~RoutePresentationConnection() = default;

void RoutePresentationConnection::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "connection_remote"), this->connection_remote,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingRemote<::blink::mojom::PresentationConnection>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "connection_receiver"), this->connection_receiver,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingReceiver<::blink::mojom::PresentationConnection>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool RoutePresentationConnection::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CastSessionState::CastSessionState()
    : sink_id(),
      app_id(),
      session_id(),
      route_description() {}

CastSessionState::CastSessionState(
    const std::string& sink_id_in,
    const std::string& app_id_in,
    const std::string& session_id_in,
    const std::string& route_description_in)
    : sink_id(std::move(sink_id_in)),
      app_id(std::move(app_id_in)),
      session_id(std::move(session_id_in)),
      route_description(std::move(route_description_in)) {}

CastSessionState::~CastSessionState() = default;
size_t CastSessionState::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->sink_id);
  seed = mojo::internal::Hash(seed, this->app_id);
  seed = mojo::internal::Hash(seed, this->session_id);
  seed = mojo::internal::Hash(seed, this->route_description);
  return seed;
}

void CastSessionState::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sink_id"), this->sink_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "app_id"), this->app_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "session_id"), this->session_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "route_description"), this->route_description,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CastSessionState::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CastProviderState::CastProviderState()
    : session_state() {}

CastProviderState::CastProviderState(
    std::vector<CastSessionStatePtr> session_state_in)
    : session_state(std::move(session_state_in)) {}

CastProviderState::~CastProviderState() = default;

void CastProviderState::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "session_state"), this->session_state,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<CastSessionStatePtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CastProviderState::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
MediaSinkExtraDataPtr
MediaSinkExtraData::NewDialMediaSink(
    DialMediaSinkPtr value) {
  return MediaSinkExtraDataPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kDialMediaSink)>,
      std::move(value));
}

MediaSinkExtraDataPtr
MediaSinkExtraData::NewCastMediaSink(
    CastMediaSinkPtr value) {
  return MediaSinkExtraDataPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kCastMediaSink)>,
      std::move(value));
}

MediaSinkExtraData::MediaSinkExtraData(
    std::in_place_index_t<static_cast<size_t>(Tag::kDialMediaSink)>,
    DialMediaSinkPtr value)
    : tag_(Tag::kDialMediaSink),
      data_(std::in_place_index<static_cast<size_t>(Tag::kDialMediaSink)>,
            std::move(value)) {}

MediaSinkExtraData::MediaSinkExtraData(
    std::in_place_index_t<static_cast<size_t>(Tag::kCastMediaSink)>,
    CastMediaSinkPtr value)
    : tag_(Tag::kCastMediaSink),
      data_(std::in_place_index<static_cast<size_t>(Tag::kCastMediaSink)>,
            std::move(value)) {}
MediaSinkExtraData::~MediaSinkExtraData() {
  DestroyActive();
}

void MediaSinkExtraData::set_dial_media_sink(DialMediaSinkPtr dial_media_sink) {
  if (tag_ == Tag::kDialMediaSink) {
    data_.dial_media_sink = std::move(dial_media_sink);
  } else {
    DestroyActive();
    tag_ = Tag::kDialMediaSink;
    new (&data_.dial_media_sink) DialMediaSinkPtr(
        std::move(dial_media_sink));
  }
}

void MediaSinkExtraData::set_cast_media_sink(CastMediaSinkPtr cast_media_sink) {
  if (tag_ == Tag::kCastMediaSink) {
    data_.cast_media_sink = std::move(cast_media_sink);
  } else {
    DestroyActive();
    tag_ = Tag::kCastMediaSink;
    new (&data_.cast_media_sink) CastMediaSinkPtr(
        std::move(cast_media_sink));
  }
}


MediaSinkExtraData::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kDialMediaSink)>,
    DialMediaSinkPtr value)
    : dial_media_sink(std::move(value)) {}

MediaSinkExtraData::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kCastMediaSink)>,
    CastMediaSinkPtr value)
    : cast_media_sink(std::move(value)) {}

void MediaSinkExtraData::DestroyActive() {
  switch (tag_) {

    case Tag::kDialMediaSink:
      std::destroy_at(&data_.dial_media_sink);
      break;
    case Tag::kCastMediaSink:
      std::destroy_at(&data_.cast_media_sink);
      break;
  }
}

bool MediaSinkExtraData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
ProviderStatePtr
ProviderState::NewCastProviderState(
    CastProviderStatePtr value) {
  return ProviderStatePtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kCastProviderState)>,
      std::move(value));
}

ProviderState::ProviderState(
    std::in_place_index_t<static_cast<size_t>(Tag::kCastProviderState)>,
    CastProviderStatePtr value)
    : tag_(Tag::kCastProviderState),
      data_(std::in_place_index<static_cast<size_t>(Tag::kCastProviderState)>,
            std::move(value)) {}
ProviderState::~ProviderState() {
  DestroyActive();
}

void ProviderState::set_cast_provider_state(CastProviderStatePtr cast_provider_state) {
  if (tag_ == Tag::kCastProviderState) {
    data_.cast_provider_state = std::move(cast_provider_state);
  } else {
    DestroyActive();
    tag_ = Tag::kCastProviderState;
    new (&data_.cast_provider_state) CastProviderStatePtr(
        std::move(cast_provider_state));
  }
}


ProviderState::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kCastProviderState)>,
    CastProviderStatePtr value)
    : cast_provider_state(std::move(value)) {}

void ProviderState::DestroyActive() {
  switch (tag_) {

    case Tag::kCastProviderState:
      std::destroy_at(&data_.cast_provider_state);
      break;
  }
}

bool ProviderState::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
// The declaration includes the definition on other builds.

MediaRouteProvider::IPCStableHashFunction MediaRouteProvider::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::MediaRouteProvider>(message.name())) {
    case messages::MediaRouteProvider::kCreateRoute: {
      return &MediaRouteProvider::CreateRoute_Sym::IPCStableHash;
    }
    case messages::MediaRouteProvider::kJoinRoute: {
      return &MediaRouteProvider::JoinRoute_Sym::IPCStableHash;
    }
    case messages::MediaRouteProvider::kTerminateRoute: {
      return &MediaRouteProvider::TerminateRoute_Sym::IPCStableHash;
    }
    case messages::MediaRouteProvider::kSendRouteMessage: {
      return &MediaRouteProvider::SendRouteMessage_Sym::IPCStableHash;
    }
    case messages::MediaRouteProvider::kSendRouteBinaryMessage: {
      return &MediaRouteProvider::SendRouteBinaryMessage_Sym::IPCStableHash;
    }
    case messages::MediaRouteProvider::kStartObservingMediaSinks: {
      return &MediaRouteProvider::StartObservingMediaSinks_Sym::IPCStableHash;
    }
    case messages::MediaRouteProvider::kStopObservingMediaSinks: {
      return &MediaRouteProvider::StopObservingMediaSinks_Sym::IPCStableHash;
    }
    case messages::MediaRouteProvider::kStartObservingMediaRoutes: {
      return &MediaRouteProvider::StartObservingMediaRoutes_Sym::IPCStableHash;
    }
    case messages::MediaRouteProvider::kDetachRoute: {
      return &MediaRouteProvider::DetachRoute_Sym::IPCStableHash;
    }
    case messages::MediaRouteProvider::kDiscoverSinksNow: {
      return &MediaRouteProvider::DiscoverSinksNow_Sym::IPCStableHash;
    }
    case messages::MediaRouteProvider::kBindMediaController: {
      return &MediaRouteProvider::BindMediaController_Sym::IPCStableHash;
    }
    case messages::MediaRouteProvider::kGetState: {
      return &MediaRouteProvider::GetState_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* MediaRouteProvider::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::MediaRouteProvider>(message.name())) {
      case messages::MediaRouteProvider::kCreateRoute:
            return "Receive media_router::mojom::MediaRouteProvider::CreateRoute";
      case messages::MediaRouteProvider::kJoinRoute:
            return "Receive media_router::mojom::MediaRouteProvider::JoinRoute";
      case messages::MediaRouteProvider::kTerminateRoute:
            return "Receive media_router::mojom::MediaRouteProvider::TerminateRoute";
      case messages::MediaRouteProvider::kSendRouteMessage:
            return "Receive media_router::mojom::MediaRouteProvider::SendRouteMessage";
      case messages::MediaRouteProvider::kSendRouteBinaryMessage:
            return "Receive media_router::mojom::MediaRouteProvider::SendRouteBinaryMessage";
      case messages::MediaRouteProvider::kStartObservingMediaSinks:
            return "Receive media_router::mojom::MediaRouteProvider::StartObservingMediaSinks";
      case messages::MediaRouteProvider::kStopObservingMediaSinks:
            return "Receive media_router::mojom::MediaRouteProvider::StopObservingMediaSinks";
      case messages::MediaRouteProvider::kStartObservingMediaRoutes:
            return "Receive media_router::mojom::MediaRouteProvider::StartObservingMediaRoutes";
      case messages::MediaRouteProvider::kDetachRoute:
            return "Receive media_router::mojom::MediaRouteProvider::DetachRoute";
      case messages::MediaRouteProvider::kDiscoverSinksNow:
            return "Receive media_router::mojom::MediaRouteProvider::DiscoverSinksNow";
      case messages::MediaRouteProvider::kBindMediaController:
            return "Receive media_router::mojom::MediaRouteProvider::BindMediaController";
      case messages::MediaRouteProvider::kGetState:
            return "Receive media_router::mojom::MediaRouteProvider::GetState";
    }
  } else {
    switch (static_cast<messages::MediaRouteProvider>(message.name())) {
      case messages::MediaRouteProvider::kCreateRoute:
            return "Receive reply media_router::mojom::MediaRouteProvider::CreateRoute";
      case messages::MediaRouteProvider::kJoinRoute:
            return "Receive reply media_router::mojom::MediaRouteProvider::JoinRoute";
      case messages::MediaRouteProvider::kTerminateRoute:
            return "Receive reply media_router::mojom::MediaRouteProvider::TerminateRoute";
      case messages::MediaRouteProvider::kSendRouteMessage:
            return "Receive reply media_router::mojom::MediaRouteProvider::SendRouteMessage";
      case messages::MediaRouteProvider::kSendRouteBinaryMessage:
            return "Receive reply media_router::mojom::MediaRouteProvider::SendRouteBinaryMessage";
      case messages::MediaRouteProvider::kStartObservingMediaSinks:
            return "Receive reply media_router::mojom::MediaRouteProvider::StartObservingMediaSinks";
      case messages::MediaRouteProvider::kStopObservingMediaSinks:
            return "Receive reply media_router::mojom::MediaRouteProvider::StopObservingMediaSinks";
      case messages::MediaRouteProvider::kStartObservingMediaRoutes:
            return "Receive reply media_router::mojom::MediaRouteProvider::StartObservingMediaRoutes";
      case messages::MediaRouteProvider::kDetachRoute:
            return "Receive reply media_router::mojom::MediaRouteProvider::DetachRoute";
      case messages::MediaRouteProvider::kDiscoverSinksNow:
            return "Receive reply media_router::mojom::MediaRouteProvider::DiscoverSinksNow";
      case messages::MediaRouteProvider::kBindMediaController:
            return "Receive reply media_router::mojom::MediaRouteProvider::BindMediaController";
      case messages::MediaRouteProvider::kGetState:
            return "Receive reply media_router::mojom::MediaRouteProvider::GetState";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t MediaRouteProvider::CreateRoute_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x781cb95b;  // IPCStableHash for media_router::mojom::MediaRouteProvider::CreateRoute
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaRouteProvider::JoinRoute_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x061327c0;  // IPCStableHash for media_router::mojom::MediaRouteProvider::JoinRoute
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaRouteProvider::TerminateRoute_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xbde6212d;  // IPCStableHash for media_router::mojom::MediaRouteProvider::TerminateRoute
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaRouteProvider::SendRouteMessage_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x35ee5522;  // IPCStableHash for media_router::mojom::MediaRouteProvider::SendRouteMessage
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaRouteProvider::SendRouteBinaryMessage_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x36ce9a6c;  // IPCStableHash for media_router::mojom::MediaRouteProvider::SendRouteBinaryMessage
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaRouteProvider::StartObservingMediaSinks_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x83909724;  // IPCStableHash for media_router::mojom::MediaRouteProvider::StartObservingMediaSinks
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaRouteProvider::StopObservingMediaSinks_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe74fd3ee;  // IPCStableHash for media_router::mojom::MediaRouteProvider::StopObservingMediaSinks
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaRouteProvider::StartObservingMediaRoutes_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x11d0cfa3;  // IPCStableHash for media_router::mojom::MediaRouteProvider::StartObservingMediaRoutes
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaRouteProvider::DetachRoute_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb986b62f;  // IPCStableHash for media_router::mojom::MediaRouteProvider::DetachRoute
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaRouteProvider::DiscoverSinksNow_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x914609a4;  // IPCStableHash for media_router::mojom::MediaRouteProvider::DiscoverSinksNow
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaRouteProvider::BindMediaController_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd33f3756;  // IPCStableHash for media_router::mojom::MediaRouteProvider::BindMediaController
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaRouteProvider::GetState_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb7626f53;  // IPCStableHash for media_router::mojom::MediaRouteProvider::GetState
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class MediaRouteProvider_CreateRoute_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  MediaRouteProvider_CreateRoute_ForwardToCallback(
      MediaRouteProvider::CreateRouteCallback callback
      ) : callback_(std::move(callback)) {
  }

  MediaRouteProvider_CreateRoute_ForwardToCallback(const MediaRouteProvider_CreateRoute_ForwardToCallback&) = delete;
  MediaRouteProvider_CreateRoute_ForwardToCallback& operator=(const MediaRouteProvider_CreateRoute_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  MediaRouteProvider::CreateRouteCallback callback_;
};

class MediaRouteProvider_JoinRoute_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  MediaRouteProvider_JoinRoute_ForwardToCallback(
      MediaRouteProvider::JoinRouteCallback callback
      ) : callback_(std::move(callback)) {
  }

  MediaRouteProvider_JoinRoute_ForwardToCallback(const MediaRouteProvider_JoinRoute_ForwardToCallback&) = delete;
  MediaRouteProvider_JoinRoute_ForwardToCallback& operator=(const MediaRouteProvider_JoinRoute_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  MediaRouteProvider::JoinRouteCallback callback_;
};

class MediaRouteProvider_TerminateRoute_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  MediaRouteProvider_TerminateRoute_ForwardToCallback(
      MediaRouteProvider::TerminateRouteCallback callback
      ) : callback_(std::move(callback)) {
  }

  MediaRouteProvider_TerminateRoute_ForwardToCallback(const MediaRouteProvider_TerminateRoute_ForwardToCallback&) = delete;
  MediaRouteProvider_TerminateRoute_ForwardToCallback& operator=(const MediaRouteProvider_TerminateRoute_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  MediaRouteProvider::TerminateRouteCallback callback_;
};

class MediaRouteProvider_BindMediaController_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  MediaRouteProvider_BindMediaController_ForwardToCallback(
      MediaRouteProvider::BindMediaControllerCallback callback
      ) : callback_(std::move(callback)) {
  }

  MediaRouteProvider_BindMediaController_ForwardToCallback(const MediaRouteProvider_BindMediaController_ForwardToCallback&) = delete;
  MediaRouteProvider_BindMediaController_ForwardToCallback& operator=(const MediaRouteProvider_BindMediaController_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  MediaRouteProvider::BindMediaControllerCallback callback_;
};

class MediaRouteProvider_GetState_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  MediaRouteProvider_GetState_ForwardToCallback(
      MediaRouteProvider::GetStateCallback callback
      ) : callback_(std::move(callback)) {
  }

  MediaRouteProvider_GetState_ForwardToCallback(const MediaRouteProvider_GetState_ForwardToCallback&) = delete;
  MediaRouteProvider_GetState_ForwardToCallback& operator=(const MediaRouteProvider_GetState_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  MediaRouteProvider::GetStateCallback callback_;
};

MediaRouteProviderProxy::MediaRouteProviderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void MediaRouteProviderProxy::CreateRoute(
    const std::string& in_media_source, const std::string& in_sink_id, const std::string& in_original_presentation_id, const ::url::Origin& in_origin, int32_t in_frame_tree_node_id, ::base::TimeDelta in_timeout, CreateRouteCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media_router::mojom::MediaRouteProvider::CreateRoute", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("media_source"), in_media_source,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("sink_id"), in_sink_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("original_presentation_id"), in_original_presentation_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("origin"), in_origin,
                        "<value of type const ::url::Origin&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_tree_node_id"), in_frame_tree_node_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("timeout"), in_timeout,
                        "<value of type ::base::TimeDelta>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaRouteProvider::kCreateRoute), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_router::mojom::internal::MediaRouteProvider_CreateRoute_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->media_source)::BaseType> media_source_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_media_source,
    media_source_fragment);

  params->media_source.Set(
      media_source_fragment.is_null() ? nullptr : media_source_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->media_source.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null media_source in MediaRouteProvider.CreateRoute request");
  mojo::internal::MessageFragment<
      typename decltype(params->sink_id)::BaseType> sink_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_sink_id,
    sink_id_fragment);

  params->sink_id.Set(
      sink_id_fragment.is_null() ? nullptr : sink_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->sink_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null sink_id in MediaRouteProvider.CreateRoute request");
  mojo::internal::MessageFragment<
      typename decltype(params->original_presentation_id)::BaseType> original_presentation_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_original_presentation_id,
    original_presentation_id_fragment);

  params->original_presentation_id.Set(
      original_presentation_id_fragment.is_null() ? nullptr : original_presentation_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->original_presentation_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null original_presentation_id in MediaRouteProvider.CreateRoute request");
  mojo::internal::MessageFragment<
      typename decltype(params->origin)::BaseType> origin_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
    in_origin,
    origin_fragment);

  params->origin.Set(
      origin_fragment.is_null() ? nullptr : origin_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->origin.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null origin in MediaRouteProvider.CreateRoute request");

  params->frame_tree_node_id = in_frame_tree_node_id;
  mojo::internal::MessageFragment<
      typename decltype(params->timeout)::BaseType> timeout_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
    in_timeout,
    timeout_fragment);

  params->timeout.Set(
      timeout_fragment.is_null() ? nullptr : timeout_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->timeout.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null timeout in MediaRouteProvider.CreateRoute request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaRouteProvider::Name_);
  message.set_method_name("CreateRoute");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new MediaRouteProvider_CreateRoute_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void MediaRouteProviderProxy::JoinRoute(
    const std::string& in_media_source, const std::string& in_presentation_id, const ::url::Origin& in_origin, int32_t in_frame_tree_node_id, ::base::TimeDelta in_timeout, JoinRouteCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media_router::mojom::MediaRouteProvider::JoinRoute", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("media_source"), in_media_source,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("presentation_id"), in_presentation_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("origin"), in_origin,
                        "<value of type const ::url::Origin&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_tree_node_id"), in_frame_tree_node_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("timeout"), in_timeout,
                        "<value of type ::base::TimeDelta>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaRouteProvider::kJoinRoute), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_router::mojom::internal::MediaRouteProvider_JoinRoute_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->media_source)::BaseType> media_source_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_media_source,
    media_source_fragment);

  params->media_source.Set(
      media_source_fragment.is_null() ? nullptr : media_source_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->media_source.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null media_source in MediaRouteProvider.JoinRoute request");
  mojo::internal::MessageFragment<
      typename decltype(params->presentation_id)::BaseType> presentation_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_presentation_id,
    presentation_id_fragment);

  params->presentation_id.Set(
      presentation_id_fragment.is_null() ? nullptr : presentation_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->presentation_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null presentation_id in MediaRouteProvider.JoinRoute request");
  mojo::internal::MessageFragment<
      typename decltype(params->origin)::BaseType> origin_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
    in_origin,
    origin_fragment);

  params->origin.Set(
      origin_fragment.is_null() ? nullptr : origin_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->origin.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null origin in MediaRouteProvider.JoinRoute request");

  params->frame_tree_node_id = in_frame_tree_node_id;
  mojo::internal::MessageFragment<
      typename decltype(params->timeout)::BaseType> timeout_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
    in_timeout,
    timeout_fragment);

  params->timeout.Set(
      timeout_fragment.is_null() ? nullptr : timeout_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->timeout.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null timeout in MediaRouteProvider.JoinRoute request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaRouteProvider::Name_);
  message.set_method_name("JoinRoute");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new MediaRouteProvider_JoinRoute_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void MediaRouteProviderProxy::TerminateRoute(
    const std::string& in_route_id, TerminateRouteCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media_router::mojom::MediaRouteProvider::TerminateRoute", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("route_id"), in_route_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaRouteProvider::kTerminateRoute), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_router::mojom::internal::MediaRouteProvider_TerminateRoute_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->route_id)::BaseType> route_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_route_id,
    route_id_fragment);

  params->route_id.Set(
      route_id_fragment.is_null() ? nullptr : route_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->route_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null route_id in MediaRouteProvider.TerminateRoute request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaRouteProvider::Name_);
  message.set_method_name("TerminateRoute");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new MediaRouteProvider_TerminateRoute_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void MediaRouteProviderProxy::SendRouteMessage(
    const std::string& in_media_route_id, const std::string& in_message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media_router::mojom::MediaRouteProvider::SendRouteMessage", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("media_route_id"), in_media_route_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("message"), in_message,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaRouteProvider::kSendRouteMessage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_router::mojom::internal::MediaRouteProvider_SendRouteMessage_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->media_route_id)::BaseType> media_route_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_media_route_id,
    media_route_id_fragment);

  params->media_route_id.Set(
      media_route_id_fragment.is_null() ? nullptr : media_route_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->media_route_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null media_route_id in MediaRouteProvider.SendRouteMessage request");
  mojo::internal::MessageFragment<
      typename decltype(params->message)::BaseType> message_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_message,
    message_fragment);

  params->message.Set(
      message_fragment.is_null() ? nullptr : message_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->message.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null message in MediaRouteProvider.SendRouteMessage request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaRouteProvider::Name_);
  message.set_method_name("SendRouteMessage");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaRouteProviderProxy::SendRouteBinaryMessage(
    const std::string& in_media_route_id, const std::vector<uint8_t>& in_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media_router::mojom::MediaRouteProvider::SendRouteBinaryMessage", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("media_route_id"), in_media_route_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data,
                        "<value of type const std::vector<uint8_t>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaRouteProvider::kSendRouteBinaryMessage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_router::mojom::internal::MediaRouteProvider_SendRouteBinaryMessage_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->media_route_id)::BaseType> media_route_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_media_route_id,
    media_route_id_fragment);

  params->media_route_id.Set(
      media_route_id_fragment.is_null() ? nullptr : media_route_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->media_route_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null media_route_id in MediaRouteProvider.SendRouteBinaryMessage request");
  mojo::internal::MessageFragment<
      typename decltype(params->data)::BaseType>
      data_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
    in_data,
    data_fragment,
    &data_validate_params);

  params->data.Set(
      data_fragment.is_null() ? nullptr : data_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null data in MediaRouteProvider.SendRouteBinaryMessage request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaRouteProvider::Name_);
  message.set_method_name("SendRouteBinaryMessage");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaRouteProviderProxy::StartObservingMediaSinks(
    const std::string& in_media_source) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media_router::mojom::MediaRouteProvider::StartObservingMediaSinks", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("media_source"), in_media_source,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaRouteProvider::kStartObservingMediaSinks), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_router::mojom::internal::MediaRouteProvider_StartObservingMediaSinks_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->media_source)::BaseType> media_source_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_media_source,
    media_source_fragment);

  params->media_source.Set(
      media_source_fragment.is_null() ? nullptr : media_source_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->media_source.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null media_source in MediaRouteProvider.StartObservingMediaSinks request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaRouteProvider::Name_);
  message.set_method_name("StartObservingMediaSinks");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaRouteProviderProxy::StopObservingMediaSinks(
    const std::string& in_media_source) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media_router::mojom::MediaRouteProvider::StopObservingMediaSinks", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("media_source"), in_media_source,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaRouteProvider::kStopObservingMediaSinks), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_router::mojom::internal::MediaRouteProvider_StopObservingMediaSinks_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->media_source)::BaseType> media_source_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_media_source,
    media_source_fragment);

  params->media_source.Set(
      media_source_fragment.is_null() ? nullptr : media_source_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->media_source.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null media_source in MediaRouteProvider.StopObservingMediaSinks request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaRouteProvider::Name_);
  message.set_method_name("StopObservingMediaSinks");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaRouteProviderProxy::StartObservingMediaRoutes(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media_router::mojom::MediaRouteProvider::StartObservingMediaRoutes");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaRouteProvider::kStartObservingMediaRoutes), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_router::mojom::internal::MediaRouteProvider_StartObservingMediaRoutes_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaRouteProvider::Name_);
  message.set_method_name("StartObservingMediaRoutes");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaRouteProviderProxy::DetachRoute(
    const std::string& in_route_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media_router::mojom::MediaRouteProvider::DetachRoute", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("route_id"), in_route_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaRouteProvider::kDetachRoute), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_router::mojom::internal::MediaRouteProvider_DetachRoute_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->route_id)::BaseType> route_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_route_id,
    route_id_fragment);

  params->route_id.Set(
      route_id_fragment.is_null() ? nullptr : route_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->route_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null route_id in MediaRouteProvider.DetachRoute request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaRouteProvider::Name_);
  message.set_method_name("DetachRoute");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaRouteProviderProxy::DiscoverSinksNow(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media_router::mojom::MediaRouteProvider::DiscoverSinksNow");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaRouteProvider::kDiscoverSinksNow), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_router::mojom::internal::MediaRouteProvider_DiscoverSinksNow_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaRouteProvider::Name_);
  message.set_method_name("DiscoverSinksNow");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaRouteProviderProxy::BindMediaController(
    const std::string& in_route_id, ::mojo::PendingReceiver<::media_router::mojom::MediaController> in_media_controller, ::mojo::PendingRemote<::media_router::mojom::MediaStatusObserver> in_observer, BindMediaControllerCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media_router::mojom::MediaRouteProvider::BindMediaController", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("route_id"), in_route_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("media_controller"), in_media_controller,
                        "<value of type ::mojo::PendingReceiver<::media_router::mojom::MediaController>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("observer"), in_observer,
                        "<value of type ::mojo::PendingRemote<::media_router::mojom::MediaStatusObserver>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaRouteProvider::kBindMediaController), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_router::mojom::internal::MediaRouteProvider_BindMediaController_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->route_id)::BaseType> route_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_route_id,
    route_id_fragment);

  params->route_id.Set(
      route_id_fragment.is_null() ? nullptr : route_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->route_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null route_id in MediaRouteProvider.BindMediaController request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::media_router::mojom::MediaControllerInterfaceBase>>(
    in_media_controller,
    &params->media_controller,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->media_controller)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid media_controller in MediaRouteProvider.BindMediaController request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::media_router::mojom::MediaStatusObserverInterfaceBase>>(
    in_observer,
    &params->observer,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->observer)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid observer in MediaRouteProvider.BindMediaController request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaRouteProvider::Name_);
  message.set_method_name("BindMediaController");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new MediaRouteProvider_BindMediaController_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void MediaRouteProviderProxy::GetState(
    GetStateCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media_router::mojom::MediaRouteProvider::GetState");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaRouteProvider::kGetState), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_router::mojom::internal::MediaRouteProvider_GetState_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaRouteProvider::Name_);
  message.set_method_name("GetState");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new MediaRouteProvider_GetState_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class MediaRouteProvider_CreateRoute_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static MediaRouteProvider::CreateRouteCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<MediaRouteProvider_CreateRoute_ProxyToResponder> proxy(
        new MediaRouteProvider_CreateRoute_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&MediaRouteProvider_CreateRoute_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~MediaRouteProvider_CreateRoute_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  MediaRouteProvider_CreateRoute_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "MediaRouteProvider::CreateRouteCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::optional<::media_router::MediaRoute>& in_route, RoutePresentationConnectionPtr in_connection, const std::optional<std::string>& in_error_text, ::media_router::mojom::RouteRequestResultCode in_result_code);
};

bool MediaRouteProvider_CreateRoute_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::MediaRouteProvider_CreateRoute_ResponseParams_Data* params =
      reinterpret_cast<
          internal::MediaRouteProvider_CreateRoute_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for MediaRouteProvider.0
  bool success = true;
  std::optional<::media_router::MediaRoute> p_route{};
  RoutePresentationConnectionPtr p_connection{};
  std::optional<std::string> p_error_text{};
  ::media_router::mojom::RouteRequestResultCode p_result_code{};
  MediaRouteProvider_CreateRoute_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadRoute(&p_route))
    success = false;
  if (success && !input_data_view.ReadConnection(&p_connection))
    success = false;
  if (success && !input_data_view.ReadErrorText(&p_error_text))
    success = false;
  if (success && !input_data_view.ReadResultCode(&p_result_code))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        MediaRouteProvider::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_route), 
std::move(p_connection), 
std::move(p_error_text), 
std::move(p_result_code));
  }
  return true;
}

void MediaRouteProvider_CreateRoute_ProxyToResponder::Run(
    const std::optional<::media_router::MediaRoute>& in_route, RoutePresentationConnectionPtr in_connection, const std::optional<std::string>& in_error_text, ::media_router::mojom::RouteRequestResultCode in_result_code) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply media_router::mojom::MediaRouteProvider::CreateRoute", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("route"), in_route,
                        "<value of type const std::optional<::media_router::MediaRoute>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("connection"), in_connection,
                        "<value of type RoutePresentationConnectionPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error_text"), in_error_text,
                        "<value of type const std::optional<std::string>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result_code"), in_result_code,
                        "<value of type ::media_router::mojom::RouteRequestResultCode>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaRouteProvider::kCreateRoute), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_router::mojom::internal::MediaRouteProvider_CreateRoute_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->route)::BaseType> route_fragment(
          params.message());
  
  mojo::internal::Serialize<::media_router::mojom::MediaRouteDataView>(
    in_route,
    route_fragment);

  params->route.Set(
      route_fragment.is_null() ? nullptr : route_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->connection)::BaseType> connection_fragment(
          params.message());
  
  mojo::internal::Serialize<::media_router::mojom::RoutePresentationConnectionDataView>(
    in_connection,
    connection_fragment);

  params->connection.Set(
      connection_fragment.is_null() ? nullptr : connection_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->error_text)::BaseType> error_text_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_error_text,
    error_text_fragment);

  params->error_text.Set(
      error_text_fragment.is_null() ? nullptr : error_text_fragment.data());

  
  mojo::internal::Serialize<::media_router::mojom::RouteRequestResultCode>(
    in_result_code,
    &params->result_code);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaRouteProvider::Name_);
  message.set_method_name("CreateRoute");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class MediaRouteProvider_JoinRoute_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static MediaRouteProvider::JoinRouteCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<MediaRouteProvider_JoinRoute_ProxyToResponder> proxy(
        new MediaRouteProvider_JoinRoute_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&MediaRouteProvider_JoinRoute_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~MediaRouteProvider_JoinRoute_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  MediaRouteProvider_JoinRoute_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "MediaRouteProvider::JoinRouteCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::optional<::media_router::MediaRoute>& in_route, RoutePresentationConnectionPtr in_connection, const std::optional<std::string>& in_error_text, ::media_router::mojom::RouteRequestResultCode in_result_code);
};

bool MediaRouteProvider_JoinRoute_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::MediaRouteProvider_JoinRoute_ResponseParams_Data* params =
      reinterpret_cast<
          internal::MediaRouteProvider_JoinRoute_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for MediaRouteProvider.1
  bool success = true;
  std::optional<::media_router::MediaRoute> p_route{};
  RoutePresentationConnectionPtr p_connection{};
  std::optional<std::string> p_error_text{};
  ::media_router::mojom::RouteRequestResultCode p_result_code{};
  MediaRouteProvider_JoinRoute_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadRoute(&p_route))
    success = false;
  if (success && !input_data_view.ReadConnection(&p_connection))
    success = false;
  if (success && !input_data_view.ReadErrorText(&p_error_text))
    success = false;
  if (success && !input_data_view.ReadResultCode(&p_result_code))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        MediaRouteProvider::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_route), 
std::move(p_connection), 
std::move(p_error_text), 
std::move(p_result_code));
  }
  return true;
}

void MediaRouteProvider_JoinRoute_ProxyToResponder::Run(
    const std::optional<::media_router::MediaRoute>& in_route, RoutePresentationConnectionPtr in_connection, const std::optional<std::string>& in_error_text, ::media_router::mojom::RouteRequestResultCode in_result_code) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply media_router::mojom::MediaRouteProvider::JoinRoute", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("route"), in_route,
                        "<value of type const std::optional<::media_router::MediaRoute>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("connection"), in_connection,
                        "<value of type RoutePresentationConnectionPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error_text"), in_error_text,
                        "<value of type const std::optional<std::string>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result_code"), in_result_code,
                        "<value of type ::media_router::mojom::RouteRequestResultCode>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaRouteProvider::kJoinRoute), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_router::mojom::internal::MediaRouteProvider_JoinRoute_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->route)::BaseType> route_fragment(
          params.message());
  
  mojo::internal::Serialize<::media_router::mojom::MediaRouteDataView>(
    in_route,
    route_fragment);

  params->route.Set(
      route_fragment.is_null() ? nullptr : route_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->connection)::BaseType> connection_fragment(
          params.message());
  
  mojo::internal::Serialize<::media_router::mojom::RoutePresentationConnectionDataView>(
    in_connection,
    connection_fragment);

  params->connection.Set(
      connection_fragment.is_null() ? nullptr : connection_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->error_text)::BaseType> error_text_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_error_text,
    error_text_fragment);

  params->error_text.Set(
      error_text_fragment.is_null() ? nullptr : error_text_fragment.data());

  
  mojo::internal::Serialize<::media_router::mojom::RouteRequestResultCode>(
    in_result_code,
    &params->result_code);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaRouteProvider::Name_);
  message.set_method_name("JoinRoute");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class MediaRouteProvider_TerminateRoute_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static MediaRouteProvider::TerminateRouteCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<MediaRouteProvider_TerminateRoute_ProxyToResponder> proxy(
        new MediaRouteProvider_TerminateRoute_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&MediaRouteProvider_TerminateRoute_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~MediaRouteProvider_TerminateRoute_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  MediaRouteProvider_TerminateRoute_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "MediaRouteProvider::TerminateRouteCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::optional<std::string>& in_error_text, ::media_router::mojom::RouteRequestResultCode in_result_code);
};

bool MediaRouteProvider_TerminateRoute_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::MediaRouteProvider_TerminateRoute_ResponseParams_Data* params =
      reinterpret_cast<
          internal::MediaRouteProvider_TerminateRoute_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for MediaRouteProvider.2
  bool success = true;
  std::optional<std::string> p_error_text{};
  ::media_router::mojom::RouteRequestResultCode p_result_code{};
  MediaRouteProvider_TerminateRoute_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadErrorText(&p_error_text))
    success = false;
  if (success && !input_data_view.ReadResultCode(&p_result_code))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        MediaRouteProvider::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_error_text), 
std::move(p_result_code));
  }
  return true;
}

void MediaRouteProvider_TerminateRoute_ProxyToResponder::Run(
    const std::optional<std::string>& in_error_text, ::media_router::mojom::RouteRequestResultCode in_result_code) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply media_router::mojom::MediaRouteProvider::TerminateRoute", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error_text"), in_error_text,
                        "<value of type const std::optional<std::string>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result_code"), in_result_code,
                        "<value of type ::media_router::mojom::RouteRequestResultCode>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaRouteProvider::kTerminateRoute), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_router::mojom::internal::MediaRouteProvider_TerminateRoute_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->error_text)::BaseType> error_text_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_error_text,
    error_text_fragment);

  params->error_text.Set(
      error_text_fragment.is_null() ? nullptr : error_text_fragment.data());

  
  mojo::internal::Serialize<::media_router::mojom::RouteRequestResultCode>(
    in_result_code,
    &params->result_code);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaRouteProvider::Name_);
  message.set_method_name("TerminateRoute");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class MediaRouteProvider_BindMediaController_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static MediaRouteProvider::BindMediaControllerCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<MediaRouteProvider_BindMediaController_ProxyToResponder> proxy(
        new MediaRouteProvider_BindMediaController_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&MediaRouteProvider_BindMediaController_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~MediaRouteProvider_BindMediaController_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  MediaRouteProvider_BindMediaController_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "MediaRouteProvider::BindMediaControllerCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);
};

bool MediaRouteProvider_BindMediaController_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::MediaRouteProvider_BindMediaController_ResponseParams_Data* params =
      reinterpret_cast<
          internal::MediaRouteProvider_BindMediaController_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for MediaRouteProvider.10
  bool success = true;
  bool p_success{};
  MediaRouteProvider_BindMediaController_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        MediaRouteProvider::Name_, 10, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success));
  }
  return true;
}

void MediaRouteProvider_BindMediaController_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply media_router::mojom::MediaRouteProvider::BindMediaController", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaRouteProvider::kBindMediaController), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_router::mojom::internal::MediaRouteProvider_BindMediaController_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaRouteProvider::Name_);
  message.set_method_name("BindMediaController");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class MediaRouteProvider_GetState_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static MediaRouteProvider::GetStateCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<MediaRouteProvider_GetState_ProxyToResponder> proxy(
        new MediaRouteProvider_GetState_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&MediaRouteProvider_GetState_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~MediaRouteProvider_GetState_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  MediaRouteProvider_GetState_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "MediaRouteProvider::GetStateCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ProviderStatePtr in_state);
};

bool MediaRouteProvider_GetState_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::MediaRouteProvider_GetState_ResponseParams_Data* params =
      reinterpret_cast<
          internal::MediaRouteProvider_GetState_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for MediaRouteProvider.11
  bool success = true;
  ProviderStatePtr p_state{};
  MediaRouteProvider_GetState_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadState(&p_state))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        MediaRouteProvider::Name_, 11, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_state));
  }
  return true;
}

void MediaRouteProvider_GetState_ProxyToResponder::Run(
    ProviderStatePtr in_state) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply media_router::mojom::MediaRouteProvider::GetState", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("state"), in_state,
                        "<value of type ProviderStatePtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaRouteProvider::kGetState), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_router::mojom::internal::MediaRouteProvider_GetState_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->state)>
      state_fragment(params.message());
  state_fragment.Claim(&params->state);
  
  mojo::internal::Serialize<::media_router::mojom::ProviderStateDataView>(
    in_state,
    state_fragment,
    true);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaRouteProvider::Name_);
  message.set_method_name("GetState");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool MediaRouteProviderStubDispatch::Accept(
    MediaRouteProvider* impl,
    mojo::Message* message) {
  switch (static_cast<messages::MediaRouteProvider>(message->header()->name)) {
    case messages::MediaRouteProvider::kCreateRoute: {
      break;
    }
    case messages::MediaRouteProvider::kJoinRoute: {
      break;
    }
    case messages::MediaRouteProvider::kTerminateRoute: {
      break;
    }
    case messages::MediaRouteProvider::kSendRouteMessage: {
      DCHECK(message->is_serialized());
      internal::MediaRouteProvider_SendRouteMessage_Params_Data* params =
          reinterpret_cast<internal::MediaRouteProvider_SendRouteMessage_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaRouteProvider.3
      bool success = true;
      std::string p_media_route_id{};
      std::string p_message{};
      MediaRouteProvider_SendRouteMessage_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMediaRouteId(&p_media_route_id))
        success = false;
      if (success && !input_data_view.ReadMessage(&p_message))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaRouteProvider::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SendRouteMessage(        
        std::move(p_media_route_id), 
        std::move(p_message));
      return true;
    }
    case messages::MediaRouteProvider::kSendRouteBinaryMessage: {
      DCHECK(message->is_serialized());
      internal::MediaRouteProvider_SendRouteBinaryMessage_Params_Data* params =
          reinterpret_cast<internal::MediaRouteProvider_SendRouteBinaryMessage_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaRouteProvider.4
      bool success = true;
      std::string p_media_route_id{};
      std::vector<uint8_t> p_data{};
      MediaRouteProvider_SendRouteBinaryMessage_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMediaRouteId(&p_media_route_id))
        success = false;
      if (success && !input_data_view.ReadData(&p_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaRouteProvider::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SendRouteBinaryMessage(        
        std::move(p_media_route_id), 
        std::move(p_data));
      return true;
    }
    case messages::MediaRouteProvider::kStartObservingMediaSinks: {
      DCHECK(message->is_serialized());
      internal::MediaRouteProvider_StartObservingMediaSinks_Params_Data* params =
          reinterpret_cast<internal::MediaRouteProvider_StartObservingMediaSinks_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaRouteProvider.5
      bool success = true;
      std::string p_media_source{};
      MediaRouteProvider_StartObservingMediaSinks_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMediaSource(&p_media_source))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaRouteProvider::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StartObservingMediaSinks(        
        std::move(p_media_source));
      return true;
    }
    case messages::MediaRouteProvider::kStopObservingMediaSinks: {
      DCHECK(message->is_serialized());
      internal::MediaRouteProvider_StopObservingMediaSinks_Params_Data* params =
          reinterpret_cast<internal::MediaRouteProvider_StopObservingMediaSinks_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaRouteProvider.6
      bool success = true;
      std::string p_media_source{};
      MediaRouteProvider_StopObservingMediaSinks_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMediaSource(&p_media_source))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaRouteProvider::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StopObservingMediaSinks(        
        std::move(p_media_source));
      return true;
    }
    case messages::MediaRouteProvider::kStartObservingMediaRoutes: {
      DCHECK(message->is_serialized());
      internal::MediaRouteProvider_StartObservingMediaRoutes_Params_Data* params =
          reinterpret_cast<internal::MediaRouteProvider_StartObservingMediaRoutes_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaRouteProvider.7
      bool success = true;
      MediaRouteProvider_StartObservingMediaRoutes_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaRouteProvider::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StartObservingMediaRoutes(        );
      return true;
    }
    case messages::MediaRouteProvider::kDetachRoute: {
      DCHECK(message->is_serialized());
      internal::MediaRouteProvider_DetachRoute_Params_Data* params =
          reinterpret_cast<internal::MediaRouteProvider_DetachRoute_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaRouteProvider.8
      bool success = true;
      std::string p_route_id{};
      MediaRouteProvider_DetachRoute_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRouteId(&p_route_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaRouteProvider::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DetachRoute(        
        std::move(p_route_id));
      return true;
    }
    case messages::MediaRouteProvider::kDiscoverSinksNow: {
      DCHECK(message->is_serialized());
      internal::MediaRouteProvider_DiscoverSinksNow_Params_Data* params =
          reinterpret_cast<internal::MediaRouteProvider_DiscoverSinksNow_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaRouteProvider.9
      bool success = true;
      MediaRouteProvider_DiscoverSinksNow_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaRouteProvider::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DiscoverSinksNow(        );
      return true;
    }
    case messages::MediaRouteProvider::kBindMediaController: {
      break;
    }
    case messages::MediaRouteProvider::kGetState: {
      break;
    }
  }
  return false;
}

// static
bool MediaRouteProviderStubDispatch::AcceptWithResponder(
    MediaRouteProvider* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::MediaRouteProvider>(message->header()->name)) {
    case messages::MediaRouteProvider::kCreateRoute: {
      internal::MediaRouteProvider_CreateRoute_Params_Data* params =
          reinterpret_cast<
              internal::MediaRouteProvider_CreateRoute_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for MediaRouteProvider.0
      bool success = true;
      std::string p_media_source{};
      std::string p_sink_id{};
      std::string p_original_presentation_id{};
      ::url::Origin p_origin{};
      int32_t p_frame_tree_node_id{};
      ::base::TimeDelta p_timeout{};
      MediaRouteProvider_CreateRoute_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMediaSource(&p_media_source))
        success = false;
      if (success && !input_data_view.ReadSinkId(&p_sink_id))
        success = false;
      if (success && !input_data_view.ReadOriginalPresentationId(&p_original_presentation_id))
        success = false;
      if (success && !input_data_view.ReadOrigin(&p_origin))
        success = false;
      if (success)
        p_frame_tree_node_id = input_data_view.frame_tree_node_id();
      if (success && !input_data_view.ReadTimeout(&p_timeout))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaRouteProvider::Name_, 0, false);
        return false;
      }
      auto callback =
          MediaRouteProvider_CreateRoute_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateRoute(        
        std::move(p_media_source), 
        std::move(p_sink_id), 
        std::move(p_original_presentation_id), 
        std::move(p_origin), 
        std::move(p_frame_tree_node_id), 
        std::move(p_timeout), std::move(callback));
      return true;
    }
    case messages::MediaRouteProvider::kJoinRoute: {
      internal::MediaRouteProvider_JoinRoute_Params_Data* params =
          reinterpret_cast<
              internal::MediaRouteProvider_JoinRoute_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for MediaRouteProvider.1
      bool success = true;
      std::string p_media_source{};
      std::string p_presentation_id{};
      ::url::Origin p_origin{};
      int32_t p_frame_tree_node_id{};
      ::base::TimeDelta p_timeout{};
      MediaRouteProvider_JoinRoute_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMediaSource(&p_media_source))
        success = false;
      if (success && !input_data_view.ReadPresentationId(&p_presentation_id))
        success = false;
      if (success && !input_data_view.ReadOrigin(&p_origin))
        success = false;
      if (success)
        p_frame_tree_node_id = input_data_view.frame_tree_node_id();
      if (success && !input_data_view.ReadTimeout(&p_timeout))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaRouteProvider::Name_, 1, false);
        return false;
      }
      auto callback =
          MediaRouteProvider_JoinRoute_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->JoinRoute(        
        std::move(p_media_source), 
        std::move(p_presentation_id), 
        std::move(p_origin), 
        std::move(p_frame_tree_node_id), 
        std::move(p_timeout), std::move(callback));
      return true;
    }
    case messages::MediaRouteProvider::kTerminateRoute: {
      internal::MediaRouteProvider_TerminateRoute_Params_Data* params =
          reinterpret_cast<
              internal::MediaRouteProvider_TerminateRoute_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for MediaRouteProvider.2
      bool success = true;
      std::string p_route_id{};
      MediaRouteProvider_TerminateRoute_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRouteId(&p_route_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaRouteProvider::Name_, 2, false);
        return false;
      }
      auto callback =
          MediaRouteProvider_TerminateRoute_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->TerminateRoute(        
        std::move(p_route_id), std::move(callback));
      return true;
    }
    case messages::MediaRouteProvider::kSendRouteMessage: {
      break;
    }
    case messages::MediaRouteProvider::kSendRouteBinaryMessage: {
      break;
    }
    case messages::MediaRouteProvider::kStartObservingMediaSinks: {
      break;
    }
    case messages::MediaRouteProvider::kStopObservingMediaSinks: {
      break;
    }
    case messages::MediaRouteProvider::kStartObservingMediaRoutes: {
      break;
    }
    case messages::MediaRouteProvider::kDetachRoute: {
      break;
    }
    case messages::MediaRouteProvider::kDiscoverSinksNow: {
      break;
    }
    case messages::MediaRouteProvider::kBindMediaController: {
      internal::MediaRouteProvider_BindMediaController_Params_Data* params =
          reinterpret_cast<
              internal::MediaRouteProvider_BindMediaController_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for MediaRouteProvider.10
      bool success = true;
      std::string p_route_id{};
      ::mojo::PendingReceiver<::media_router::mojom::MediaController> p_media_controller{};
      ::mojo::PendingRemote<::media_router::mojom::MediaStatusObserver> p_observer{};
      MediaRouteProvider_BindMediaController_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRouteId(&p_route_id))
        success = false;
      if (success) {
        p_media_controller =
            input_data_view.TakeMediaController<decltype(p_media_controller)>();
      }
      if (success) {
        p_observer =
            input_data_view.TakeObserver<decltype(p_observer)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaRouteProvider::Name_, 10, false);
        return false;
      }
      auto callback =
          MediaRouteProvider_BindMediaController_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindMediaController(        
        std::move(p_route_id), 
        std::move(p_media_controller), 
        std::move(p_observer), std::move(callback));
      return true;
    }
    case messages::MediaRouteProvider::kGetState: {
      internal::MediaRouteProvider_GetState_Params_Data* params =
          reinterpret_cast<
              internal::MediaRouteProvider_GetState_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for MediaRouteProvider.11
      bool success = true;
      MediaRouteProvider_GetState_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaRouteProvider::Name_, 11, false);
        return false;
      }
      auto callback =
          MediaRouteProvider_GetState_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetState(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kMediaRouteProviderValidationInfo[] = {
    { &internal::MediaRouteProvider_CreateRoute_Params_Data::Validate,
     &internal::MediaRouteProvider_CreateRoute_ResponseParams_Data::Validate},
    { &internal::MediaRouteProvider_JoinRoute_Params_Data::Validate,
     &internal::MediaRouteProvider_JoinRoute_ResponseParams_Data::Validate},
    { &internal::MediaRouteProvider_TerminateRoute_Params_Data::Validate,
     &internal::MediaRouteProvider_TerminateRoute_ResponseParams_Data::Validate},
    { &internal::MediaRouteProvider_SendRouteMessage_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaRouteProvider_SendRouteBinaryMessage_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaRouteProvider_StartObservingMediaSinks_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaRouteProvider_StopObservingMediaSinks_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaRouteProvider_StartObservingMediaRoutes_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaRouteProvider_DetachRoute_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaRouteProvider_DiscoverSinksNow_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaRouteProvider_BindMediaController_Params_Data::Validate,
     &internal::MediaRouteProvider_BindMediaController_ResponseParams_Data::Validate},
    { &internal::MediaRouteProvider_GetState_Params_Data::Validate,
     &internal::MediaRouteProvider_GetState_ResponseParams_Data::Validate},
};

bool MediaRouteProviderRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::media_router::mojom::MediaRouteProvider::Name_,
    kMediaRouteProviderValidationInfo);
}

bool MediaRouteProviderResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::media_router::mojom::MediaRouteProvider::Name_,
    kMediaRouteProviderValidationInfo);
}
// The declaration includes the definition on other builds.

MediaRouter::IPCStableHashFunction MediaRouter::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::MediaRouter>(message.name())) {
    case messages::MediaRouter::kRegisterMediaRouteProvider: {
      return &MediaRouter::RegisterMediaRouteProvider_Sym::IPCStableHash;
    }
    case messages::MediaRouter::kOnSinksReceived: {
      return &MediaRouter::OnSinksReceived_Sym::IPCStableHash;
    }
    case messages::MediaRouter::kOnIssue: {
      return &MediaRouter::OnIssue_Sym::IPCStableHash;
    }
    case messages::MediaRouter::kClearTopIssueForSink: {
      return &MediaRouter::ClearTopIssueForSink_Sym::IPCStableHash;
    }
    case messages::MediaRouter::kOnRoutesUpdated: {
      return &MediaRouter::OnRoutesUpdated_Sym::IPCStableHash;
    }
    case messages::MediaRouter::kOnPresentationConnectionStateChanged: {
      return &MediaRouter::OnPresentationConnectionStateChanged_Sym::IPCStableHash;
    }
    case messages::MediaRouter::kOnPresentationConnectionClosed: {
      return &MediaRouter::OnPresentationConnectionClosed_Sym::IPCStableHash;
    }
    case messages::MediaRouter::kOnRouteMessagesReceived: {
      return &MediaRouter::OnRouteMessagesReceived_Sym::IPCStableHash;
    }
    case messages::MediaRouter::kGetMediaSinkServiceStatus: {
      return &MediaRouter::GetMediaSinkServiceStatus_Sym::IPCStableHash;
    }
    case messages::MediaRouter::kGetLogger: {
      return &MediaRouter::GetLogger_Sym::IPCStableHash;
    }
    case messages::MediaRouter::kGetDebugger: {
      return &MediaRouter::GetDebugger_Sym::IPCStableHash;
    }
    case messages::MediaRouter::kGetLogsAsString: {
      return &MediaRouter::GetLogsAsString_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* MediaRouter::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::MediaRouter>(message.name())) {
      case messages::MediaRouter::kRegisterMediaRouteProvider:
            return "Receive media_router::mojom::MediaRouter::RegisterMediaRouteProvider";
      case messages::MediaRouter::kOnSinksReceived:
            return "Receive media_router::mojom::MediaRouter::OnSinksReceived";
      case messages::MediaRouter::kOnIssue:
            return "Receive media_router::mojom::MediaRouter::OnIssue";
      case messages::MediaRouter::kClearTopIssueForSink:
            return "Receive media_router::mojom::MediaRouter::ClearTopIssueForSink";
      case messages::MediaRouter::kOnRoutesUpdated:
            return "Receive media_router::mojom::MediaRouter::OnRoutesUpdated";
      case messages::MediaRouter::kOnPresentationConnectionStateChanged:
            return "Receive media_router::mojom::MediaRouter::OnPresentationConnectionStateChanged";
      case messages::MediaRouter::kOnPresentationConnectionClosed:
            return "Receive media_router::mojom::MediaRouter::OnPresentationConnectionClosed";
      case messages::MediaRouter::kOnRouteMessagesReceived:
            return "Receive media_router::mojom::MediaRouter::OnRouteMessagesReceived";
      case messages::MediaRouter::kGetMediaSinkServiceStatus:
            return "Receive media_router::mojom::MediaRouter::GetMediaSinkServiceStatus";
      case messages::MediaRouter::kGetLogger:
            return "Receive media_router::mojom::MediaRouter::GetLogger";
      case messages::MediaRouter::kGetDebugger:
            return "Receive media_router::mojom::MediaRouter::GetDebugger";
      case messages::MediaRouter::kGetLogsAsString:
            return "Receive media_router::mojom::MediaRouter::GetLogsAsString";
    }
  } else {
    switch (static_cast<messages::MediaRouter>(message.name())) {
      case messages::MediaRouter::kRegisterMediaRouteProvider:
            return "Receive reply media_router::mojom::MediaRouter::RegisterMediaRouteProvider";
      case messages::MediaRouter::kOnSinksReceived:
            return "Receive reply media_router::mojom::MediaRouter::OnSinksReceived";
      case messages::MediaRouter::kOnIssue:
            return "Receive reply media_router::mojom::MediaRouter::OnIssue";
      case messages::MediaRouter::kClearTopIssueForSink:
            return "Receive reply media_router::mojom::MediaRouter::ClearTopIssueForSink";
      case messages::MediaRouter::kOnRoutesUpdated:
            return "Receive reply media_router::mojom::MediaRouter::OnRoutesUpdated";
      case messages::MediaRouter::kOnPresentationConnectionStateChanged:
            return "Receive reply media_router::mojom::MediaRouter::OnPresentationConnectionStateChanged";
      case messages::MediaRouter::kOnPresentationConnectionClosed:
            return "Receive reply media_router::mojom::MediaRouter::OnPresentationConnectionClosed";
      case messages::MediaRouter::kOnRouteMessagesReceived:
            return "Receive reply media_router::mojom::MediaRouter::OnRouteMessagesReceived";
      case messages::MediaRouter::kGetMediaSinkServiceStatus:
            return "Receive reply media_router::mojom::MediaRouter::GetMediaSinkServiceStatus";
      case messages::MediaRouter::kGetLogger:
            return "Receive reply media_router::mojom::MediaRouter::GetLogger";
      case messages::MediaRouter::kGetDebugger:
            return "Receive reply media_router::mojom::MediaRouter::GetDebugger";
      case messages::MediaRouter::kGetLogsAsString:
            return "Receive reply media_router::mojom::MediaRouter::GetLogsAsString";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t MediaRouter::RegisterMediaRouteProvider_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc64ad56b;  // IPCStableHash for media_router::mojom::MediaRouter::RegisterMediaRouteProvider
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaRouter::OnSinksReceived_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xedf9f42a;  // IPCStableHash for media_router::mojom::MediaRouter::OnSinksReceived
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaRouter::OnIssue_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1eb70bb8;  // IPCStableHash for media_router::mojom::MediaRouter::OnIssue
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaRouter::ClearTopIssueForSink_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x08a3eb59;  // IPCStableHash for media_router::mojom::MediaRouter::ClearTopIssueForSink
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaRouter::OnRoutesUpdated_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x64bcf3c3;  // IPCStableHash for media_router::mojom::MediaRouter::OnRoutesUpdated
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaRouter::OnPresentationConnectionStateChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xee93c2a1;  // IPCStableHash for media_router::mojom::MediaRouter::OnPresentationConnectionStateChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaRouter::OnPresentationConnectionClosed_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1f11348a;  // IPCStableHash for media_router::mojom::MediaRouter::OnPresentationConnectionClosed
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaRouter::OnRouteMessagesReceived_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x8a286b1f;  // IPCStableHash for media_router::mojom::MediaRouter::OnRouteMessagesReceived
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaRouter::GetMediaSinkServiceStatus_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x793f06e3;  // IPCStableHash for media_router::mojom::MediaRouter::GetMediaSinkServiceStatus
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaRouter::GetLogger_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb67866b4;  // IPCStableHash for media_router::mojom::MediaRouter::GetLogger
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaRouter::GetDebugger_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9d182dfb;  // IPCStableHash for media_router::mojom::MediaRouter::GetDebugger
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaRouter::GetLogsAsString_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb9049177;  // IPCStableHash for media_router::mojom::MediaRouter::GetLogsAsString
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class MediaRouter_GetMediaSinkServiceStatus_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  MediaRouter_GetMediaSinkServiceStatus_ForwardToCallback(
      MediaRouter::GetMediaSinkServiceStatusCallback callback
      ) : callback_(std::move(callback)) {
  }

  MediaRouter_GetMediaSinkServiceStatus_ForwardToCallback(const MediaRouter_GetMediaSinkServiceStatus_ForwardToCallback&) = delete;
  MediaRouter_GetMediaSinkServiceStatus_ForwardToCallback& operator=(const MediaRouter_GetMediaSinkServiceStatus_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  MediaRouter::GetMediaSinkServiceStatusCallback callback_;
};

class MediaRouter_GetLogsAsString_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  MediaRouter_GetLogsAsString_ForwardToCallback(
      MediaRouter::GetLogsAsStringCallback callback
      ) : callback_(std::move(callback)) {
  }

  MediaRouter_GetLogsAsString_ForwardToCallback(const MediaRouter_GetLogsAsString_ForwardToCallback&) = delete;
  MediaRouter_GetLogsAsString_ForwardToCallback& operator=(const MediaRouter_GetLogsAsString_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  MediaRouter::GetLogsAsStringCallback callback_;
};

MediaRouterProxy::MediaRouterProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void MediaRouterProxy::RegisterMediaRouteProvider(
    ::media_router::mojom::MediaRouteProviderId in_provider_id, ::mojo::PendingRemote<MediaRouteProvider> in_media_router_provider) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media_router::mojom::MediaRouter::RegisterMediaRouteProvider", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("provider_id"), in_provider_id,
                        "<value of type ::media_router::mojom::MediaRouteProviderId>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("media_router_provider"), in_media_router_provider,
                        "<value of type ::mojo::PendingRemote<MediaRouteProvider>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaRouter::kRegisterMediaRouteProvider), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_router::mojom::internal::MediaRouter_RegisterMediaRouteProvider_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::media_router::mojom::MediaRouteProviderId>(
    in_provider_id,
    &params->provider_id);

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::media_router::mojom::MediaRouteProviderInterfaceBase>>(
    in_media_router_provider,
    &params->media_router_provider,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->media_router_provider)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid media_router_provider in MediaRouter.RegisterMediaRouteProvider request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaRouter::Name_);
  message.set_method_name("RegisterMediaRouteProvider");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaRouterProxy::OnSinksReceived(
    ::media_router::mojom::MediaRouteProviderId in_provider_id, const std::string& in_media_source, const std::vector<::media_router::MediaSinkInternal>& in_sinks, const std::vector<::url::Origin>& in_origins) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media_router::mojom::MediaRouter::OnSinksReceived", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("provider_id"), in_provider_id,
                        "<value of type ::media_router::mojom::MediaRouteProviderId>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("media_source"), in_media_source,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("sinks"), in_sinks,
                        "<value of type const std::vector<::media_router::MediaSinkInternal>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("origins"), in_origins,
                        "<value of type const std::vector<::url::Origin>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaRouter::kOnSinksReceived), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_router::mojom::internal::MediaRouter_OnSinksReceived_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::media_router::mojom::MediaRouteProviderId>(
    in_provider_id,
    &params->provider_id);
  mojo::internal::MessageFragment<
      typename decltype(params->media_source)::BaseType> media_source_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_media_source,
    media_source_fragment);

  params->media_source.Set(
      media_source_fragment.is_null() ? nullptr : media_source_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->media_source.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null media_source in MediaRouter.OnSinksReceived request");
  mojo::internal::MessageFragment<
      typename decltype(params->sinks)::BaseType>
      sinks_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& sinks_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::media_router::mojom::MediaSinkDataView>>(
    in_sinks,
    sinks_fragment,
    &sinks_validate_params);

  params->sinks.Set(
      sinks_fragment.is_null() ? nullptr : sinks_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->sinks.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null sinks in MediaRouter.OnSinksReceived request");
  mojo::internal::MessageFragment<
      typename decltype(params->origins)::BaseType>
      origins_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& origins_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::url::mojom::OriginDataView>>(
    in_origins,
    origins_fragment,
    &origins_validate_params);

  params->origins.Set(
      origins_fragment.is_null() ? nullptr : origins_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->origins.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null origins in MediaRouter.OnSinksReceived request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaRouter::Name_);
  message.set_method_name("OnSinksReceived");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaRouterProxy::OnIssue(
    const ::media_router::IssueInfo& in_issue) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media_router::mojom::MediaRouter::OnIssue", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("issue"), in_issue,
                        "<value of type const ::media_router::IssueInfo&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaRouter::kOnIssue), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_router::mojom::internal::MediaRouter_OnIssue_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->issue)::BaseType> issue_fragment(
          params.message());
  
  mojo::internal::Serialize<::media_router::mojom::IssueDataView>(
    in_issue,
    issue_fragment);

  params->issue.Set(
      issue_fragment.is_null() ? nullptr : issue_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->issue.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null issue in MediaRouter.OnIssue request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaRouter::Name_);
  message.set_method_name("OnIssue");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaRouterProxy::ClearTopIssueForSink(
    const std::string& in_sink_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media_router::mojom::MediaRouter::ClearTopIssueForSink", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("sink_id"), in_sink_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaRouter::kClearTopIssueForSink), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_router::mojom::internal::MediaRouter_ClearTopIssueForSink_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->sink_id)::BaseType> sink_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_sink_id,
    sink_id_fragment);

  params->sink_id.Set(
      sink_id_fragment.is_null() ? nullptr : sink_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->sink_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null sink_id in MediaRouter.ClearTopIssueForSink request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaRouter::Name_);
  message.set_method_name("ClearTopIssueForSink");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaRouterProxy::OnRoutesUpdated(
    ::media_router::mojom::MediaRouteProviderId in_provider_id, const std::vector<::media_router::MediaRoute>& in_routes) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media_router::mojom::MediaRouter::OnRoutesUpdated", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("provider_id"), in_provider_id,
                        "<value of type ::media_router::mojom::MediaRouteProviderId>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("routes"), in_routes,
                        "<value of type const std::vector<::media_router::MediaRoute>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaRouter::kOnRoutesUpdated), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_router::mojom::internal::MediaRouter_OnRoutesUpdated_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::media_router::mojom::MediaRouteProviderId>(
    in_provider_id,
    &params->provider_id);
  mojo::internal::MessageFragment<
      typename decltype(params->routes)::BaseType>
      routes_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& routes_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::media_router::mojom::MediaRouteDataView>>(
    in_routes,
    routes_fragment,
    &routes_validate_params);

  params->routes.Set(
      routes_fragment.is_null() ? nullptr : routes_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->routes.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null routes in MediaRouter.OnRoutesUpdated request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaRouter::Name_);
  message.set_method_name("OnRoutesUpdated");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaRouterProxy::OnPresentationConnectionStateChanged(
    const std::string& in_route_id, ::blink::mojom::PresentationConnectionState in_state) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media_router::mojom::MediaRouter::OnPresentationConnectionStateChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("route_id"), in_route_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("state"), in_state,
                        "<value of type ::blink::mojom::PresentationConnectionState>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaRouter::kOnPresentationConnectionStateChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_router::mojom::internal::MediaRouter_OnPresentationConnectionStateChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->route_id)::BaseType> route_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_route_id,
    route_id_fragment);

  params->route_id.Set(
      route_id_fragment.is_null() ? nullptr : route_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->route_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null route_id in MediaRouter.OnPresentationConnectionStateChanged request");

  
  mojo::internal::Serialize<::blink::mojom::PresentationConnectionState>(
    in_state,
    &params->state);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaRouter::Name_);
  message.set_method_name("OnPresentationConnectionStateChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaRouterProxy::OnPresentationConnectionClosed(
    const std::string& in_route_id, ::blink::mojom::PresentationConnectionCloseReason in_reason, const std::string& in_message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media_router::mojom::MediaRouter::OnPresentationConnectionClosed", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("route_id"), in_route_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("reason"), in_reason,
                        "<value of type ::blink::mojom::PresentationConnectionCloseReason>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("message"), in_message,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaRouter::kOnPresentationConnectionClosed), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_router::mojom::internal::MediaRouter_OnPresentationConnectionClosed_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->route_id)::BaseType> route_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_route_id,
    route_id_fragment);

  params->route_id.Set(
      route_id_fragment.is_null() ? nullptr : route_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->route_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null route_id in MediaRouter.OnPresentationConnectionClosed request");

  
  mojo::internal::Serialize<::blink::mojom::PresentationConnectionCloseReason>(
    in_reason,
    &params->reason);
  mojo::internal::MessageFragment<
      typename decltype(params->message)::BaseType> message_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_message,
    message_fragment);

  params->message.Set(
      message_fragment.is_null() ? nullptr : message_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->message.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null message in MediaRouter.OnPresentationConnectionClosed request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaRouter::Name_);
  message.set_method_name("OnPresentationConnectionClosed");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaRouterProxy::OnRouteMessagesReceived(
    const std::string& in_route_id, std::vector<RouteMessagePtr> in_messages) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media_router::mojom::MediaRouter::OnRouteMessagesReceived", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("route_id"), in_route_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("messages"), in_messages,
                        "<value of type std::vector<RouteMessagePtr>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaRouter::kOnRouteMessagesReceived), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_router::mojom::internal::MediaRouter_OnRouteMessagesReceived_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->route_id)::BaseType> route_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_route_id,
    route_id_fragment);

  params->route_id.Set(
      route_id_fragment.is_null() ? nullptr : route_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->route_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null route_id in MediaRouter.OnRouteMessagesReceived request");
  mojo::internal::MessageFragment<
      typename decltype(params->messages)::BaseType>
      messages_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& messages_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::media_router::mojom::RouteMessageDataView>>(
    in_messages,
    messages_fragment,
    &messages_validate_params);

  params->messages.Set(
      messages_fragment.is_null() ? nullptr : messages_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->messages.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null messages in MediaRouter.OnRouteMessagesReceived request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaRouter::Name_);
  message.set_method_name("OnRouteMessagesReceived");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaRouterProxy::GetMediaSinkServiceStatus(
    GetMediaSinkServiceStatusCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media_router::mojom::MediaRouter::GetMediaSinkServiceStatus");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaRouter::kGetMediaSinkServiceStatus), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_router::mojom::internal::MediaRouter_GetMediaSinkServiceStatus_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaRouter::Name_);
  message.set_method_name("GetMediaSinkServiceStatus");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new MediaRouter_GetMediaSinkServiceStatus_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void MediaRouterProxy::GetLogger(
    ::mojo::PendingReceiver<::media_router::mojom::Logger> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media_router::mojom::MediaRouter::GetLogger", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::media_router::mojom::Logger>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaRouter::kGetLogger), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_router::mojom::internal::MediaRouter_GetLogger_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::media_router::mojom::LoggerInterfaceBase>>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid receiver in MediaRouter.GetLogger request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaRouter::Name_);
  message.set_method_name("GetLogger");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaRouterProxy::GetDebugger(
    ::mojo::PendingReceiver<::media_router::mojom::Debugger> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media_router::mojom::MediaRouter::GetDebugger", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::media_router::mojom::Debugger>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaRouter::kGetDebugger), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_router::mojom::internal::MediaRouter_GetDebugger_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::media_router::mojom::DebuggerInterfaceBase>>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid receiver in MediaRouter.GetDebugger request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaRouter::Name_);
  message.set_method_name("GetDebugger");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaRouterProxy::GetLogsAsString(
    GetLogsAsStringCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media_router::mojom::MediaRouter::GetLogsAsString");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaRouter::kGetLogsAsString), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_router::mojom::internal::MediaRouter_GetLogsAsString_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaRouter::Name_);
  message.set_method_name("GetLogsAsString");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new MediaRouter_GetLogsAsString_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class MediaRouter_GetMediaSinkServiceStatus_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static MediaRouter::GetMediaSinkServiceStatusCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<MediaRouter_GetMediaSinkServiceStatus_ProxyToResponder> proxy(
        new MediaRouter_GetMediaSinkServiceStatus_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&MediaRouter_GetMediaSinkServiceStatus_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~MediaRouter_GetMediaSinkServiceStatus_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  MediaRouter_GetMediaSinkServiceStatus_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "MediaRouter::GetMediaSinkServiceStatusCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::string& in_status);
};

bool MediaRouter_GetMediaSinkServiceStatus_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::MediaRouter_GetMediaSinkServiceStatus_ResponseParams_Data* params =
      reinterpret_cast<
          internal::MediaRouter_GetMediaSinkServiceStatus_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for MediaRouter.8
  bool success = true;
  std::string p_status{};
  MediaRouter_GetMediaSinkServiceStatus_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        MediaRouter::Name_, 8, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_status));
  }
  return true;
}

void MediaRouter_GetMediaSinkServiceStatus_ProxyToResponder::Run(
    const std::string& in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply media_router::mojom::MediaRouter::GetMediaSinkServiceStatus", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type const std::string&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaRouter::kGetMediaSinkServiceStatus), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_router::mojom::internal::MediaRouter_GetMediaSinkServiceStatus_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->status)::BaseType> status_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_status,
    status_fragment);

  params->status.Set(
      status_fragment.is_null() ? nullptr : status_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->status.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null status in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaRouter::Name_);
  message.set_method_name("GetMediaSinkServiceStatus");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class MediaRouter_GetLogsAsString_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static MediaRouter::GetLogsAsStringCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<MediaRouter_GetLogsAsString_ProxyToResponder> proxy(
        new MediaRouter_GetLogsAsString_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&MediaRouter_GetLogsAsString_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~MediaRouter_GetLogsAsString_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  MediaRouter_GetLogsAsString_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "MediaRouter::GetLogsAsStringCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::string& in_logs);
};

bool MediaRouter_GetLogsAsString_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::MediaRouter_GetLogsAsString_ResponseParams_Data* params =
      reinterpret_cast<
          internal::MediaRouter_GetLogsAsString_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for MediaRouter.11
  bool success = true;
  std::string p_logs{};
  MediaRouter_GetLogsAsString_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadLogs(&p_logs))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        MediaRouter::Name_, 11, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_logs));
  }
  return true;
}

void MediaRouter_GetLogsAsString_ProxyToResponder::Run(
    const std::string& in_logs) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply media_router::mojom::MediaRouter::GetLogsAsString", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("logs"), in_logs,
                        "<value of type const std::string&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaRouter::kGetLogsAsString), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_router::mojom::internal::MediaRouter_GetLogsAsString_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->logs)::BaseType> logs_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_logs,
    logs_fragment);

  params->logs.Set(
      logs_fragment.is_null() ? nullptr : logs_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->logs.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null logs in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaRouter::Name_);
  message.set_method_name("GetLogsAsString");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool MediaRouterStubDispatch::Accept(
    MediaRouter* impl,
    mojo::Message* message) {
  switch (static_cast<messages::MediaRouter>(message->header()->name)) {
    case messages::MediaRouter::kRegisterMediaRouteProvider: {
      DCHECK(message->is_serialized());
      internal::MediaRouter_RegisterMediaRouteProvider_Params_Data* params =
          reinterpret_cast<internal::MediaRouter_RegisterMediaRouteProvider_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaRouter.0
      bool success = true;
      ::media_router::mojom::MediaRouteProviderId p_provider_id{};
      ::mojo::PendingRemote<MediaRouteProvider> p_media_router_provider{};
      MediaRouter_RegisterMediaRouteProvider_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadProviderId(&p_provider_id))
        success = false;
      if (success) {
        p_media_router_provider =
            input_data_view.TakeMediaRouterProvider<decltype(p_media_router_provider)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaRouter::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RegisterMediaRouteProvider(        
        std::move(p_provider_id), 
        std::move(p_media_router_provider));
      return true;
    }
    case messages::MediaRouter::kOnSinksReceived: {
      DCHECK(message->is_serialized());
      internal::MediaRouter_OnSinksReceived_Params_Data* params =
          reinterpret_cast<internal::MediaRouter_OnSinksReceived_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaRouter.1
      bool success = true;
      ::media_router::mojom::MediaRouteProviderId p_provider_id{};
      std::string p_media_source{};
      std::vector<::media_router::MediaSinkInternal> p_sinks{};
      std::vector<::url::Origin> p_origins{};
      MediaRouter_OnSinksReceived_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadProviderId(&p_provider_id))
        success = false;
      if (success && !input_data_view.ReadMediaSource(&p_media_source))
        success = false;
      if (success && !input_data_view.ReadSinks(&p_sinks))
        success = false;
      if (success && !input_data_view.ReadOrigins(&p_origins))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaRouter::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnSinksReceived(        
        std::move(p_provider_id), 
        std::move(p_media_source), 
        std::move(p_sinks), 
        std::move(p_origins));
      return true;
    }
    case messages::MediaRouter::kOnIssue: {
      DCHECK(message->is_serialized());
      internal::MediaRouter_OnIssue_Params_Data* params =
          reinterpret_cast<internal::MediaRouter_OnIssue_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaRouter.2
      bool success = true;
      ::media_router::IssueInfo p_issue{};
      MediaRouter_OnIssue_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadIssue(&p_issue))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaRouter::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnIssue(        
        std::move(p_issue));
      return true;
    }
    case messages::MediaRouter::kClearTopIssueForSink: {
      DCHECK(message->is_serialized());
      internal::MediaRouter_ClearTopIssueForSink_Params_Data* params =
          reinterpret_cast<internal::MediaRouter_ClearTopIssueForSink_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaRouter.3
      bool success = true;
      std::string p_sink_id{};
      MediaRouter_ClearTopIssueForSink_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSinkId(&p_sink_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaRouter::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ClearTopIssueForSink(        
        std::move(p_sink_id));
      return true;
    }
    case messages::MediaRouter::kOnRoutesUpdated: {
      DCHECK(message->is_serialized());
      internal::MediaRouter_OnRoutesUpdated_Params_Data* params =
          reinterpret_cast<internal::MediaRouter_OnRoutesUpdated_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaRouter.4
      bool success = true;
      ::media_router::mojom::MediaRouteProviderId p_provider_id{};
      std::vector<::media_router::MediaRoute> p_routes{};
      MediaRouter_OnRoutesUpdated_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadProviderId(&p_provider_id))
        success = false;
      if (success && !input_data_view.ReadRoutes(&p_routes))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaRouter::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnRoutesUpdated(        
        std::move(p_provider_id), 
        std::move(p_routes));
      return true;
    }
    case messages::MediaRouter::kOnPresentationConnectionStateChanged: {
      DCHECK(message->is_serialized());
      internal::MediaRouter_OnPresentationConnectionStateChanged_Params_Data* params =
          reinterpret_cast<internal::MediaRouter_OnPresentationConnectionStateChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaRouter.5
      bool success = true;
      std::string p_route_id{};
      ::blink::mojom::PresentationConnectionState p_state{};
      MediaRouter_OnPresentationConnectionStateChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRouteId(&p_route_id))
        success = false;
      if (success && !input_data_view.ReadState(&p_state))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaRouter::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnPresentationConnectionStateChanged(        
        std::move(p_route_id), 
        std::move(p_state));
      return true;
    }
    case messages::MediaRouter::kOnPresentationConnectionClosed: {
      DCHECK(message->is_serialized());
      internal::MediaRouter_OnPresentationConnectionClosed_Params_Data* params =
          reinterpret_cast<internal::MediaRouter_OnPresentationConnectionClosed_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaRouter.6
      bool success = true;
      std::string p_route_id{};
      ::blink::mojom::PresentationConnectionCloseReason p_reason{};
      std::string p_message{};
      MediaRouter_OnPresentationConnectionClosed_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRouteId(&p_route_id))
        success = false;
      if (success && !input_data_view.ReadReason(&p_reason))
        success = false;
      if (success && !input_data_view.ReadMessage(&p_message))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaRouter::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnPresentationConnectionClosed(        
        std::move(p_route_id), 
        std::move(p_reason), 
        std::move(p_message));
      return true;
    }
    case messages::MediaRouter::kOnRouteMessagesReceived: {
      DCHECK(message->is_serialized());
      internal::MediaRouter_OnRouteMessagesReceived_Params_Data* params =
          reinterpret_cast<internal::MediaRouter_OnRouteMessagesReceived_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaRouter.7
      bool success = true;
      std::string p_route_id{};
      std::vector<RouteMessagePtr> p_messages{};
      MediaRouter_OnRouteMessagesReceived_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRouteId(&p_route_id))
        success = false;
      if (success && !input_data_view.ReadMessages(&p_messages))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaRouter::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnRouteMessagesReceived(        
        std::move(p_route_id), 
        std::move(p_messages));
      return true;
    }
    case messages::MediaRouter::kGetMediaSinkServiceStatus: {
      break;
    }
    case messages::MediaRouter::kGetLogger: {
      DCHECK(message->is_serialized());
      internal::MediaRouter_GetLogger_Params_Data* params =
          reinterpret_cast<internal::MediaRouter_GetLogger_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaRouter.9
      bool success = true;
      ::mojo::PendingReceiver<::media_router::mojom::Logger> p_receiver{};
      MediaRouter_GetLogger_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaRouter::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetLogger(        
        std::move(p_receiver));
      return true;
    }
    case messages::MediaRouter::kGetDebugger: {
      DCHECK(message->is_serialized());
      internal::MediaRouter_GetDebugger_Params_Data* params =
          reinterpret_cast<internal::MediaRouter_GetDebugger_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaRouter.10
      bool success = true;
      ::mojo::PendingReceiver<::media_router::mojom::Debugger> p_receiver{};
      MediaRouter_GetDebugger_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaRouter::Name_, 10, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetDebugger(        
        std::move(p_receiver));
      return true;
    }
    case messages::MediaRouter::kGetLogsAsString: {
      break;
    }
  }
  return false;
}

// static
bool MediaRouterStubDispatch::AcceptWithResponder(
    MediaRouter* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::MediaRouter>(message->header()->name)) {
    case messages::MediaRouter::kRegisterMediaRouteProvider: {
      break;
    }
    case messages::MediaRouter::kOnSinksReceived: {
      break;
    }
    case messages::MediaRouter::kOnIssue: {
      break;
    }
    case messages::MediaRouter::kClearTopIssueForSink: {
      break;
    }
    case messages::MediaRouter::kOnRoutesUpdated: {
      break;
    }
    case messages::MediaRouter::kOnPresentationConnectionStateChanged: {
      break;
    }
    case messages::MediaRouter::kOnPresentationConnectionClosed: {
      break;
    }
    case messages::MediaRouter::kOnRouteMessagesReceived: {
      break;
    }
    case messages::MediaRouter::kGetMediaSinkServiceStatus: {
      internal::MediaRouter_GetMediaSinkServiceStatus_Params_Data* params =
          reinterpret_cast<
              internal::MediaRouter_GetMediaSinkServiceStatus_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for MediaRouter.8
      bool success = true;
      MediaRouter_GetMediaSinkServiceStatus_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaRouter::Name_, 8, false);
        return false;
      }
      auto callback =
          MediaRouter_GetMediaSinkServiceStatus_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetMediaSinkServiceStatus(std::move(callback));
      return true;
    }
    case messages::MediaRouter::kGetLogger: {
      break;
    }
    case messages::MediaRouter::kGetDebugger: {
      break;
    }
    case messages::MediaRouter::kGetLogsAsString: {
      internal::MediaRouter_GetLogsAsString_Params_Data* params =
          reinterpret_cast<
              internal::MediaRouter_GetLogsAsString_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for MediaRouter.11
      bool success = true;
      MediaRouter_GetLogsAsString_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaRouter::Name_, 11, false);
        return false;
      }
      auto callback =
          MediaRouter_GetLogsAsString_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetLogsAsString(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kMediaRouterValidationInfo[] = {
    { &internal::MediaRouter_RegisterMediaRouteProvider_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaRouter_OnSinksReceived_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaRouter_OnIssue_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaRouter_ClearTopIssueForSink_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaRouter_OnRoutesUpdated_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaRouter_OnPresentationConnectionStateChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaRouter_OnPresentationConnectionClosed_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaRouter_OnRouteMessagesReceived_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaRouter_GetMediaSinkServiceStatus_Params_Data::Validate,
     &internal::MediaRouter_GetMediaSinkServiceStatus_ResponseParams_Data::Validate},
    { &internal::MediaRouter_GetLogger_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaRouter_GetDebugger_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaRouter_GetLogsAsString_Params_Data::Validate,
     &internal::MediaRouter_GetLogsAsString_ResponseParams_Data::Validate},
};

bool MediaRouterRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::media_router::mojom::MediaRouter::Name_,
    kMediaRouterValidationInfo);
}

bool MediaRouterResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::media_router::mojom::MediaRouter::Name_,
    kMediaRouterValidationInfo);
}


}  // media_router::mojom


namespace mojo {


// static
bool StructTraits<::media_router::mojom::MediaSink::DataView, ::media_router::mojom::MediaSinkPtr>::Read(
    ::media_router::mojom::MediaSink::DataView input,
    ::media_router::mojom::MediaSinkPtr* output) {
  bool success = true;
  ::media_router::mojom::MediaSinkPtr result(::media_router::mojom::MediaSink::New());
  
      if (success && !input.ReadSinkId(&result->sink_id))
        success = false;
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success && !input.ReadIconType(&result->icon_type))
        success = false;
      if (success && !input.ReadProviderId(&result->provider_id))
        success = false;
      if (success && !input.ReadExtraData(&result->extra_data))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media_router::mojom::DialMediaSink::DataView, ::media_router::mojom::DialMediaSinkPtr>::Read(
    ::media_router::mojom::DialMediaSink::DataView input,
    ::media_router::mojom::DialMediaSinkPtr* output) {
  bool success = true;
  ::media_router::mojom::DialMediaSinkPtr result(::media_router::mojom::DialMediaSink::New());
  
      if (success && !input.ReadIpAddress(&result->ip_address))
        success = false;
      if (success && !input.ReadModelName(&result->model_name))
        success = false;
      if (success && !input.ReadAppUrl(&result->app_url))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media_router::mojom::CastMediaSink::DataView, ::media_router::mojom::CastMediaSinkPtr>::Read(
    ::media_router::mojom::CastMediaSink::DataView input,
    ::media_router::mojom::CastMediaSinkPtr* output) {
  bool success = true;
  ::media_router::mojom::CastMediaSinkPtr result(::media_router::mojom::CastMediaSink::New());
  
      if (success && !input.ReadIpEndpoint(&result->ip_endpoint))
        success = false;
      if (success && !input.ReadModelName(&result->model_name))
        success = false;
      if (success)
        result->capabilities = input.capabilities();
      if (success)
        result->cast_channel_id = input.cast_channel_id();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media_router::mojom::MediaRoute::DataView, ::media_router::mojom::MediaRoutePtr>::Read(
    ::media_router::mojom::MediaRoute::DataView input,
    ::media_router::mojom::MediaRoutePtr* output) {
  bool success = true;
  ::media_router::mojom::MediaRoutePtr result(::media_router::mojom::MediaRoute::New());
  
      if (success && !input.ReadMediaRouteId(&result->media_route_id))
        success = false;
      if (success && !input.ReadPresentationId(&result->presentation_id))
        success = false;
      if (success && !input.ReadMediaSource(&result->media_source))
        success = false;
      if (success && !input.ReadMediaSinkId(&result->media_sink_id))
        success = false;
      if (success && !input.ReadMediaSinkName(&result->media_sink_name))
        success = false;
      if (success && !input.ReadDescription(&result->description))
        success = false;
      if (success)
        result->is_local = input.is_local();
      if (success && !input.ReadControllerType(&result->controller_type))
        success = false;
      if (success)
        result->is_local_presentation = input.is_local_presentation();
      if (success)
        result->is_connecting = input.is_connecting();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media_router::mojom::Issue::DataView, ::media_router::mojom::IssuePtr>::Read(
    ::media_router::mojom::Issue::DataView input,
    ::media_router::mojom::IssuePtr* output) {
  bool success = true;
  ::media_router::mojom::IssuePtr result(::media_router::mojom::Issue::New());
  
      if (success && !input.ReadRouteId(&result->route_id))
        success = false;
      if (success && !input.ReadSinkId(&result->sink_id))
        success = false;
      if (success && !input.ReadSeverity(&result->severity))
        success = false;
      if (success && !input.ReadTitle(&result->title))
        success = false;
      if (success && !input.ReadMessage(&result->message))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media_router::mojom::RouteMessage::DataView, ::media_router::mojom::RouteMessagePtr>::Read(
    ::media_router::mojom::RouteMessage::DataView input,
    ::media_router::mojom::RouteMessagePtr* output) {
  bool success = true;
  ::media_router::mojom::RouteMessagePtr result(::media_router::mojom::RouteMessage::New());
  
      if (success && !input.ReadType(&result->type))
        success = false;
      if (success && !input.ReadMessage(&result->message))
        success = false;
      if (success && !input.ReadData(&result->data))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media_router::mojom::RoutePresentationConnection::DataView, ::media_router::mojom::RoutePresentationConnectionPtr>::Read(
    ::media_router::mojom::RoutePresentationConnection::DataView input,
    ::media_router::mojom::RoutePresentationConnectionPtr* output) {
  bool success = true;
  ::media_router::mojom::RoutePresentationConnectionPtr result(::media_router::mojom::RoutePresentationConnection::New());
  
      if (success) {
        result->connection_remote =
            input.TakeConnectionRemote<decltype(result->connection_remote)>();
      }
      if (success) {
        result->connection_receiver =
            input.TakeConnectionReceiver<decltype(result->connection_receiver)>();
      }
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media_router::mojom::CastSessionState::DataView, ::media_router::mojom::CastSessionStatePtr>::Read(
    ::media_router::mojom::CastSessionState::DataView input,
    ::media_router::mojom::CastSessionStatePtr* output) {
  bool success = true;
  ::media_router::mojom::CastSessionStatePtr result(::media_router::mojom::CastSessionState::New());
  
      if (success && !input.ReadSinkId(&result->sink_id))
        success = false;
      if (success && !input.ReadAppId(&result->app_id))
        success = false;
      if (success && !input.ReadSessionId(&result->session_id))
        success = false;
      if (success && !input.ReadRouteDescription(&result->route_description))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media_router::mojom::CastProviderState::DataView, ::media_router::mojom::CastProviderStatePtr>::Read(
    ::media_router::mojom::CastProviderState::DataView input,
    ::media_router::mojom::CastProviderStatePtr* output) {
  bool success = true;
  ::media_router::mojom::CastProviderStatePtr result(::media_router::mojom::CastProviderState::New());
  
      if (success && !input.ReadSessionState(&result->session_state))
        success = false;
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::media_router::mojom::MediaSinkExtraData::DataView, ::media_router::mojom::MediaSinkExtraDataPtr>::Read(
    ::media_router::mojom::MediaSinkExtraData::DataView input,
    ::media_router::mojom::MediaSinkExtraDataPtr* output) {
  using UnionType = ::media_router::mojom::MediaSinkExtraData;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kDialMediaSink: {
      ::media_router::mojom::DialMediaSinkPtr result_dial_media_sink{};
      if (!input.ReadDialMediaSink(&result_dial_media_sink))
        return false;

      *output = UnionType::NewDialMediaSink(
          std::move(result_dial_media_sink));
      break;
    }
    case Tag::kCastMediaSink: {
      ::media_router::mojom::CastMediaSinkPtr result_cast_media_sink{};
      if (!input.ReadCastMediaSink(&result_cast_media_sink))
        return false;

      *output = UnionType::NewCastMediaSink(
          std::move(result_cast_media_sink));
      break;
    }
    default:

      return false;
  }
  return true;
}

// static
bool UnionTraits<::media_router::mojom::ProviderState::DataView, ::media_router::mojom::ProviderStatePtr>::Read(
    ::media_router::mojom::ProviderState::DataView input,
    ::media_router::mojom::ProviderStatePtr* output) {
  using UnionType = ::media_router::mojom::ProviderState;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kCastProviderState: {
      ::media_router::mojom::CastProviderStatePtr result_cast_provider_state{};
      if (!input.ReadCastProviderState(&result_cast_provider_state))
        return false;

      *output = UnionType::NewCastProviderState(
          std::move(result_cast_provider_state));
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace media_router::mojom {


void MediaRouteProviderInterceptorForTesting::CreateRoute(const std::string& media_source, const std::string& sink_id, const std::string& original_presentation_id, const ::url::Origin& origin, int32_t frame_tree_node_id, ::base::TimeDelta timeout, CreateRouteCallback callback) {
  GetForwardingInterface()->CreateRoute(
    std::move(media_source)
    , 
    std::move(sink_id)
    , 
    std::move(original_presentation_id)
    , 
    std::move(origin)
    , 
    std::move(frame_tree_node_id)
    , 
    std::move(timeout)
    , std::move(callback));
}
void MediaRouteProviderInterceptorForTesting::JoinRoute(const std::string& media_source, const std::string& presentation_id, const ::url::Origin& origin, int32_t frame_tree_node_id, ::base::TimeDelta timeout, JoinRouteCallback callback) {
  GetForwardingInterface()->JoinRoute(
    std::move(media_source)
    , 
    std::move(presentation_id)
    , 
    std::move(origin)
    , 
    std::move(frame_tree_node_id)
    , 
    std::move(timeout)
    , std::move(callback));
}
void MediaRouteProviderInterceptorForTesting::TerminateRoute(const std::string& route_id, TerminateRouteCallback callback) {
  GetForwardingInterface()->TerminateRoute(
    std::move(route_id)
    , std::move(callback));
}
void MediaRouteProviderInterceptorForTesting::SendRouteMessage(const std::string& media_route_id, const std::string& message) {
  GetForwardingInterface()->SendRouteMessage(
    std::move(media_route_id)
    , 
    std::move(message)
    );
}
void MediaRouteProviderInterceptorForTesting::SendRouteBinaryMessage(const std::string& media_route_id, const std::vector<uint8_t>& data) {
  GetForwardingInterface()->SendRouteBinaryMessage(
    std::move(media_route_id)
    , 
    std::move(data)
    );
}
void MediaRouteProviderInterceptorForTesting::StartObservingMediaSinks(const std::string& media_source) {
  GetForwardingInterface()->StartObservingMediaSinks(
    std::move(media_source)
    );
}
void MediaRouteProviderInterceptorForTesting::StopObservingMediaSinks(const std::string& media_source) {
  GetForwardingInterface()->StopObservingMediaSinks(
    std::move(media_source)
    );
}
void MediaRouteProviderInterceptorForTesting::StartObservingMediaRoutes() {
  GetForwardingInterface()->StartObservingMediaRoutes();
}
void MediaRouteProviderInterceptorForTesting::DetachRoute(const std::string& route_id) {
  GetForwardingInterface()->DetachRoute(
    std::move(route_id)
    );
}
void MediaRouteProviderInterceptorForTesting::DiscoverSinksNow() {
  GetForwardingInterface()->DiscoverSinksNow();
}
void MediaRouteProviderInterceptorForTesting::BindMediaController(const std::string& route_id, ::mojo::PendingReceiver<::media_router::mojom::MediaController> media_controller, ::mojo::PendingRemote<::media_router::mojom::MediaStatusObserver> observer, BindMediaControllerCallback callback) {
  GetForwardingInterface()->BindMediaController(
    std::move(route_id)
    , 
    std::move(media_controller)
    , 
    std::move(observer)
    , std::move(callback));
}
void MediaRouteProviderInterceptorForTesting::GetState(GetStateCallback callback) {
  GetForwardingInterface()->GetState(std::move(callback));
}
MediaRouteProviderAsyncWaiter::MediaRouteProviderAsyncWaiter(
    MediaRouteProvider* proxy) : proxy_(proxy) {}

MediaRouteProviderAsyncWaiter::~MediaRouteProviderAsyncWaiter() = default;


void MediaRouteProviderAsyncWaiter::CreateRoute(
    const std::string& media_source, const std::string& sink_id, const std::string& original_presentation_id, const ::url::Origin& origin, int32_t frame_tree_node_id, ::base::TimeDelta timeout, std::optional<::media_router::MediaRoute>* out_route, RoutePresentationConnectionPtr* out_connection, std::optional<std::string>* out_error_text, ::media_router::mojom::RouteRequestResultCode* out_result_code) {
  base::RunLoop loop;
  proxy_->CreateRoute(
      std::move(media_source),
      std::move(sink_id),
      std::move(original_presentation_id),
      std::move(origin),
      std::move(frame_tree_node_id),
      std::move(timeout),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::optional<::media_router::MediaRoute>* out_route
,
             RoutePresentationConnectionPtr* out_connection
,
             std::optional<std::string>* out_error_text
,
             ::media_router::mojom::RouteRequestResultCode* out_result_code
,
             const std::optional<::media_router::MediaRoute>& route,
             RoutePresentationConnectionPtr connection,
             const std::optional<std::string>& error_text,
             ::media_router::mojom::RouteRequestResultCode result_code) {*out_route = std::move(route);*out_connection = std::move(connection);*out_error_text = std::move(error_text);*out_result_code = std::move(result_code);
            loop->Quit();
          },
          &loop,
          out_route,
          out_connection,
          out_error_text,
          out_result_code));
  loop.Run();
}



void MediaRouteProviderAsyncWaiter::JoinRoute(
    const std::string& media_source, const std::string& presentation_id, const ::url::Origin& origin, int32_t frame_tree_node_id, ::base::TimeDelta timeout, std::optional<::media_router::MediaRoute>* out_route, RoutePresentationConnectionPtr* out_connection, std::optional<std::string>* out_error_text, ::media_router::mojom::RouteRequestResultCode* out_result_code) {
  base::RunLoop loop;
  proxy_->JoinRoute(
      std::move(media_source),
      std::move(presentation_id),
      std::move(origin),
      std::move(frame_tree_node_id),
      std::move(timeout),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::optional<::media_router::MediaRoute>* out_route
,
             RoutePresentationConnectionPtr* out_connection
,
             std::optional<std::string>* out_error_text
,
             ::media_router::mojom::RouteRequestResultCode* out_result_code
,
             const std::optional<::media_router::MediaRoute>& route,
             RoutePresentationConnectionPtr connection,
             const std::optional<std::string>& error_text,
             ::media_router::mojom::RouteRequestResultCode result_code) {*out_route = std::move(route);*out_connection = std::move(connection);*out_error_text = std::move(error_text);*out_result_code = std::move(result_code);
            loop->Quit();
          },
          &loop,
          out_route,
          out_connection,
          out_error_text,
          out_result_code));
  loop.Run();
}



void MediaRouteProviderAsyncWaiter::TerminateRoute(
    const std::string& route_id, std::optional<std::string>* out_error_text, ::media_router::mojom::RouteRequestResultCode* out_result_code) {
  base::RunLoop loop;
  proxy_->TerminateRoute(
      std::move(route_id),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::optional<std::string>* out_error_text
,
             ::media_router::mojom::RouteRequestResultCode* out_result_code
,
             const std::optional<std::string>& error_text,
             ::media_router::mojom::RouteRequestResultCode result_code) {*out_error_text = std::move(error_text);*out_result_code = std::move(result_code);
            loop->Quit();
          },
          &loop,
          out_error_text,
          out_result_code));
  loop.Run();
}



void MediaRouteProviderAsyncWaiter::BindMediaController(
    const std::string& route_id, ::mojo::PendingReceiver<::media_router::mojom::MediaController> media_controller, ::mojo::PendingRemote<::media_router::mojom::MediaStatusObserver> observer, bool* out_success) {
  base::RunLoop loop;
  proxy_->BindMediaController(
      std::move(route_id),
      std::move(media_controller),
      std::move(observer),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}

bool MediaRouteProviderAsyncWaiter::BindMediaController(
    const std::string& route_id, ::mojo::PendingReceiver<::media_router::mojom::MediaController> media_controller, ::mojo::PendingRemote<::media_router::mojom::MediaStatusObserver> observer) {
  bool async_wait_result;
  BindMediaController(std::move(route_id),std::move(media_controller),std::move(observer),&async_wait_result);
  return async_wait_result;
}

void MediaRouteProviderAsyncWaiter::GetState(
    ProviderStatePtr* out_state) {
  base::RunLoop loop;
  proxy_->GetState(
      base::BindOnce(
          [](base::RunLoop* loop,
             ProviderStatePtr* out_state
,
             ProviderStatePtr state) {*out_state = std::move(state);
            loop->Quit();
          },
          &loop,
          out_state));
  loop.Run();
}

ProviderStatePtr MediaRouteProviderAsyncWaiter::GetState(
    ) {
  ProviderStatePtr async_wait_result;
  GetState(&async_wait_result);
  return async_wait_result;
}




void MediaRouterInterceptorForTesting::RegisterMediaRouteProvider(::media_router::mojom::MediaRouteProviderId provider_id, ::mojo::PendingRemote<MediaRouteProvider> media_router_provider) {
  GetForwardingInterface()->RegisterMediaRouteProvider(
    std::move(provider_id)
    , 
    std::move(media_router_provider)
    );
}
void MediaRouterInterceptorForTesting::OnSinksReceived(::media_router::mojom::MediaRouteProviderId provider_id, const std::string& media_source, const std::vector<::media_router::MediaSinkInternal>& sinks, const std::vector<::url::Origin>& origins) {
  GetForwardingInterface()->OnSinksReceived(
    std::move(provider_id)
    , 
    std::move(media_source)
    , 
    std::move(sinks)
    , 
    std::move(origins)
    );
}
void MediaRouterInterceptorForTesting::OnIssue(const ::media_router::IssueInfo& issue) {
  GetForwardingInterface()->OnIssue(
    std::move(issue)
    );
}
void MediaRouterInterceptorForTesting::ClearTopIssueForSink(const std::string& sink_id) {
  GetForwardingInterface()->ClearTopIssueForSink(
    std::move(sink_id)
    );
}
void MediaRouterInterceptorForTesting::OnRoutesUpdated(::media_router::mojom::MediaRouteProviderId provider_id, const std::vector<::media_router::MediaRoute>& routes) {
  GetForwardingInterface()->OnRoutesUpdated(
    std::move(provider_id)
    , 
    std::move(routes)
    );
}
void MediaRouterInterceptorForTesting::OnPresentationConnectionStateChanged(const std::string& route_id, ::blink::mojom::PresentationConnectionState state) {
  GetForwardingInterface()->OnPresentationConnectionStateChanged(
    std::move(route_id)
    , 
    std::move(state)
    );
}
void MediaRouterInterceptorForTesting::OnPresentationConnectionClosed(const std::string& route_id, ::blink::mojom::PresentationConnectionCloseReason reason, const std::string& message) {
  GetForwardingInterface()->OnPresentationConnectionClosed(
    std::move(route_id)
    , 
    std::move(reason)
    , 
    std::move(message)
    );
}
void MediaRouterInterceptorForTesting::OnRouteMessagesReceived(const std::string& route_id, std::vector<RouteMessagePtr> messages) {
  GetForwardingInterface()->OnRouteMessagesReceived(
    std::move(route_id)
    , 
    std::move(messages)
    );
}
void MediaRouterInterceptorForTesting::GetMediaSinkServiceStatus(GetMediaSinkServiceStatusCallback callback) {
  GetForwardingInterface()->GetMediaSinkServiceStatus(std::move(callback));
}
void MediaRouterInterceptorForTesting::GetLogger(::mojo::PendingReceiver<::media_router::mojom::Logger> receiver) {
  GetForwardingInterface()->GetLogger(
    std::move(receiver)
    );
}
void MediaRouterInterceptorForTesting::GetDebugger(::mojo::PendingReceiver<::media_router::mojom::Debugger> receiver) {
  GetForwardingInterface()->GetDebugger(
    std::move(receiver)
    );
}
void MediaRouterInterceptorForTesting::GetLogsAsString(GetLogsAsStringCallback callback) {
  GetForwardingInterface()->GetLogsAsString(std::move(callback));
}
MediaRouterAsyncWaiter::MediaRouterAsyncWaiter(
    MediaRouter* proxy) : proxy_(proxy) {}

MediaRouterAsyncWaiter::~MediaRouterAsyncWaiter() = default;


void MediaRouterAsyncWaiter::GetMediaSinkServiceStatus(
    std::string* out_status) {
  base::RunLoop loop;
  proxy_->GetMediaSinkServiceStatus(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::string* out_status
,
             const std::string& status) {*out_status = std::move(status);
            loop->Quit();
          },
          &loop,
          out_status));
  loop.Run();
}

std::string MediaRouterAsyncWaiter::GetMediaSinkServiceStatus(
    ) {
  std::string async_wait_result;
  GetMediaSinkServiceStatus(&async_wait_result);
  return async_wait_result;
}

void MediaRouterAsyncWaiter::GetLogsAsString(
    std::string* out_logs) {
  base::RunLoop loop;
  proxy_->GetLogsAsString(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::string* out_logs
,
             const std::string& logs) {*out_logs = std::move(logs);
            loop->Quit();
          },
          &loop,
          out_logs));
  loop.Run();
}

std::string MediaRouterAsyncWaiter::GetLogsAsString(
    ) {
  std::string async_wait_result;
  GetLogsAsString(&async_wait_result);
  return async_wait_result;
}






}  // media_router::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif