// components/media_router/common/mojom/logger.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/media_router/common/mojom/logger.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/media_router/common/mojom/logger.mojom-params-data.h"
#include "components/media_router/common/mojom/logger.mojom-shared-message-ids.h"

#include "components/media_router/common/mojom/logger.mojom-import-headers.h"
#include "components/media_router/common/mojom/logger.mojom-test-utils.h"


namespace media_router::mojom {
// The declaration includes the definition on other builds.

Logger::IPCStableHashFunction Logger::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::Logger>(message.name())) {
    case messages::Logger::kLogInfo: {
      return &Logger::LogInfo_Sym::IPCStableHash;
    }
    case messages::Logger::kLogWarning: {
      return &Logger::LogWarning_Sym::IPCStableHash;
    }
    case messages::Logger::kLogError: {
      return &Logger::LogError_Sym::IPCStableHash;
    }
    case messages::Logger::kBindReceiver: {
      return &Logger::BindReceiver_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* Logger::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::Logger>(message.name())) {
      case messages::Logger::kLogInfo:
            return "Receive media_router::mojom::Logger::LogInfo";
      case messages::Logger::kLogWarning:
            return "Receive media_router::mojom::Logger::LogWarning";
      case messages::Logger::kLogError:
            return "Receive media_router::mojom::Logger::LogError";
      case messages::Logger::kBindReceiver:
            return "Receive media_router::mojom::Logger::BindReceiver";
    }
  } else {
    switch (static_cast<messages::Logger>(message.name())) {
      case messages::Logger::kLogInfo:
            return "Receive reply media_router::mojom::Logger::LogInfo";
      case messages::Logger::kLogWarning:
            return "Receive reply media_router::mojom::Logger::LogWarning";
      case messages::Logger::kLogError:
            return "Receive reply media_router::mojom::Logger::LogError";
      case messages::Logger::kBindReceiver:
            return "Receive reply media_router::mojom::Logger::BindReceiver";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t Logger::LogInfo_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x29834ace;  // IPCStableHash for media_router::mojom::Logger::LogInfo
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Logger::LogWarning_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x28e2b8ce;  // IPCStableHash for media_router::mojom::Logger::LogWarning
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Logger::LogError_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1cfffaed;  // IPCStableHash for media_router::mojom::Logger::LogError
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Logger::BindReceiver_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x717f62e0;  // IPCStableHash for media_router::mojom::Logger::BindReceiver
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

LoggerProxy::LoggerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void LoggerProxy::LogInfo(
    LogCategory in_category, const std::string& in_component, const std::string& in_message, const std::string& in_sink_id, const std::string& in_media_source, const std::string& in_session_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media_router::mojom::Logger::LogInfo", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("category"), in_category,
                        "<value of type LogCategory>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("component"), in_component,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("message"), in_message,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("sink_id"), in_sink_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("media_source"), in_media_source,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("session_id"), in_session_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Logger::kLogInfo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_router::mojom::internal::Logger_LogInfo_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::media_router::mojom::LogCategory>(
    in_category,
    &params->category);
  mojo::internal::MessageFragment<
      typename decltype(params->component)::BaseType> component_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_component,
    component_fragment);

  params->component.Set(
      component_fragment.is_null() ? nullptr : component_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->component.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null component in Logger.LogInfo request");
  mojo::internal::MessageFragment<
      typename decltype(params->message)::BaseType> message_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_message,
    message_fragment);

  params->message.Set(
      message_fragment.is_null() ? nullptr : message_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->message.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null message in Logger.LogInfo request");
  mojo::internal::MessageFragment<
      typename decltype(params->sink_id)::BaseType> sink_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_sink_id,
    sink_id_fragment);

  params->sink_id.Set(
      sink_id_fragment.is_null() ? nullptr : sink_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->sink_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null sink_id in Logger.LogInfo request");
  mojo::internal::MessageFragment<
      typename decltype(params->media_source)::BaseType> media_source_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_media_source,
    media_source_fragment);

  params->media_source.Set(
      media_source_fragment.is_null() ? nullptr : media_source_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->media_source.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null media_source in Logger.LogInfo request");
  mojo::internal::MessageFragment<
      typename decltype(params->session_id)::BaseType> session_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_session_id,
    session_id_fragment);

  params->session_id.Set(
      session_id_fragment.is_null() ? nullptr : session_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->session_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null session_id in Logger.LogInfo request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Logger::Name_);
  message.set_method_name("LogInfo");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LoggerProxy::LogWarning(
    LogCategory in_category, const std::string& in_component, const std::string& in_message, const std::string& in_sink_id, const std::string& in_media_source, const std::string& in_session_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media_router::mojom::Logger::LogWarning", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("category"), in_category,
                        "<value of type LogCategory>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("component"), in_component,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("message"), in_message,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("sink_id"), in_sink_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("media_source"), in_media_source,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("session_id"), in_session_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Logger::kLogWarning), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_router::mojom::internal::Logger_LogWarning_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::media_router::mojom::LogCategory>(
    in_category,
    &params->category);
  mojo::internal::MessageFragment<
      typename decltype(params->component)::BaseType> component_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_component,
    component_fragment);

  params->component.Set(
      component_fragment.is_null() ? nullptr : component_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->component.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null component in Logger.LogWarning request");
  mojo::internal::MessageFragment<
      typename decltype(params->message)::BaseType> message_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_message,
    message_fragment);

  params->message.Set(
      message_fragment.is_null() ? nullptr : message_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->message.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null message in Logger.LogWarning request");
  mojo::internal::MessageFragment<
      typename decltype(params->sink_id)::BaseType> sink_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_sink_id,
    sink_id_fragment);

  params->sink_id.Set(
      sink_id_fragment.is_null() ? nullptr : sink_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->sink_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null sink_id in Logger.LogWarning request");
  mojo::internal::MessageFragment<
      typename decltype(params->media_source)::BaseType> media_source_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_media_source,
    media_source_fragment);

  params->media_source.Set(
      media_source_fragment.is_null() ? nullptr : media_source_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->media_source.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null media_source in Logger.LogWarning request");
  mojo::internal::MessageFragment<
      typename decltype(params->session_id)::BaseType> session_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_session_id,
    session_id_fragment);

  params->session_id.Set(
      session_id_fragment.is_null() ? nullptr : session_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->session_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null session_id in Logger.LogWarning request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Logger::Name_);
  message.set_method_name("LogWarning");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LoggerProxy::LogError(
    LogCategory in_category, const std::string& in_component, const std::string& in_message, const std::string& in_sink_id, const std::string& in_media_source, const std::string& in_session_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media_router::mojom::Logger::LogError", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("category"), in_category,
                        "<value of type LogCategory>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("component"), in_component,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("message"), in_message,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("sink_id"), in_sink_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("media_source"), in_media_source,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("session_id"), in_session_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Logger::kLogError), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_router::mojom::internal::Logger_LogError_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::media_router::mojom::LogCategory>(
    in_category,
    &params->category);
  mojo::internal::MessageFragment<
      typename decltype(params->component)::BaseType> component_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_component,
    component_fragment);

  params->component.Set(
      component_fragment.is_null() ? nullptr : component_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->component.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null component in Logger.LogError request");
  mojo::internal::MessageFragment<
      typename decltype(params->message)::BaseType> message_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_message,
    message_fragment);

  params->message.Set(
      message_fragment.is_null() ? nullptr : message_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->message.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null message in Logger.LogError request");
  mojo::internal::MessageFragment<
      typename decltype(params->sink_id)::BaseType> sink_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_sink_id,
    sink_id_fragment);

  params->sink_id.Set(
      sink_id_fragment.is_null() ? nullptr : sink_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->sink_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null sink_id in Logger.LogError request");
  mojo::internal::MessageFragment<
      typename decltype(params->media_source)::BaseType> media_source_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_media_source,
    media_source_fragment);

  params->media_source.Set(
      media_source_fragment.is_null() ? nullptr : media_source_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->media_source.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null media_source in Logger.LogError request");
  mojo::internal::MessageFragment<
      typename decltype(params->session_id)::BaseType> session_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_session_id,
    session_id_fragment);

  params->session_id.Set(
      session_id_fragment.is_null() ? nullptr : session_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->session_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null session_id in Logger.LogError request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Logger::Name_);
  message.set_method_name("LogError");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LoggerProxy::BindReceiver(
    ::mojo::PendingReceiver<Logger> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media_router::mojom::Logger::BindReceiver", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<Logger>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Logger::kBindReceiver), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_router::mojom::internal::Logger_BindReceiver_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::media_router::mojom::LoggerInterfaceBase>>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid receiver in Logger.BindReceiver request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Logger::Name_);
  message.set_method_name("BindReceiver");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool LoggerStubDispatch::Accept(
    Logger* impl,
    mojo::Message* message) {
  switch (static_cast<messages::Logger>(message->header()->name)) {
    case messages::Logger::kLogInfo: {
      DCHECK(message->is_serialized());
      internal::Logger_LogInfo_Params_Data* params =
          reinterpret_cast<internal::Logger_LogInfo_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Logger.0
      bool success = true;
      LogCategory p_category{};
      std::string p_component{};
      std::string p_message{};
      std::string p_sink_id{};
      std::string p_media_source{};
      std::string p_session_id{};
      Logger_LogInfo_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCategory(&p_category))
        success = false;
      if (success && !input_data_view.ReadComponent(&p_component))
        success = false;
      if (success && !input_data_view.ReadMessage(&p_message))
        success = false;
      if (success && !input_data_view.ReadSinkId(&p_sink_id))
        success = false;
      if (success && !input_data_view.ReadMediaSource(&p_media_source))
        success = false;
      if (success && !input_data_view.ReadSessionId(&p_session_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Logger::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->LogInfo(        
        std::move(p_category), 
        std::move(p_component), 
        std::move(p_message), 
        std::move(p_sink_id), 
        std::move(p_media_source), 
        std::move(p_session_id));
      return true;
    }
    case messages::Logger::kLogWarning: {
      DCHECK(message->is_serialized());
      internal::Logger_LogWarning_Params_Data* params =
          reinterpret_cast<internal::Logger_LogWarning_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Logger.1
      bool success = true;
      LogCategory p_category{};
      std::string p_component{};
      std::string p_message{};
      std::string p_sink_id{};
      std::string p_media_source{};
      std::string p_session_id{};
      Logger_LogWarning_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCategory(&p_category))
        success = false;
      if (success && !input_data_view.ReadComponent(&p_component))
        success = false;
      if (success && !input_data_view.ReadMessage(&p_message))
        success = false;
      if (success && !input_data_view.ReadSinkId(&p_sink_id))
        success = false;
      if (success && !input_data_view.ReadMediaSource(&p_media_source))
        success = false;
      if (success && !input_data_view.ReadSessionId(&p_session_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Logger::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->LogWarning(        
        std::move(p_category), 
        std::move(p_component), 
        std::move(p_message), 
        std::move(p_sink_id), 
        std::move(p_media_source), 
        std::move(p_session_id));
      return true;
    }
    case messages::Logger::kLogError: {
      DCHECK(message->is_serialized());
      internal::Logger_LogError_Params_Data* params =
          reinterpret_cast<internal::Logger_LogError_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Logger.2
      bool success = true;
      LogCategory p_category{};
      std::string p_component{};
      std::string p_message{};
      std::string p_sink_id{};
      std::string p_media_source{};
      std::string p_session_id{};
      Logger_LogError_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCategory(&p_category))
        success = false;
      if (success && !input_data_view.ReadComponent(&p_component))
        success = false;
      if (success && !input_data_view.ReadMessage(&p_message))
        success = false;
      if (success && !input_data_view.ReadSinkId(&p_sink_id))
        success = false;
      if (success && !input_data_view.ReadMediaSource(&p_media_source))
        success = false;
      if (success && !input_data_view.ReadSessionId(&p_session_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Logger::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->LogError(        
        std::move(p_category), 
        std::move(p_component), 
        std::move(p_message), 
        std::move(p_sink_id), 
        std::move(p_media_source), 
        std::move(p_session_id));
      return true;
    }
    case messages::Logger::kBindReceiver: {
      DCHECK(message->is_serialized());
      internal::Logger_BindReceiver_Params_Data* params =
          reinterpret_cast<internal::Logger_BindReceiver_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Logger.3
      bool success = true;
      ::mojo::PendingReceiver<Logger> p_receiver{};
      Logger_BindReceiver_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Logger::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindReceiver(        
        std::move(p_receiver));
      return true;
    }
  }
  return false;
}

// static
bool LoggerStubDispatch::AcceptWithResponder(
    Logger* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::Logger>(message->header()->name)) {
    case messages::Logger::kLogInfo: {
      break;
    }
    case messages::Logger::kLogWarning: {
      break;
    }
    case messages::Logger::kLogError: {
      break;
    }
    case messages::Logger::kBindReceiver: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kLoggerValidationInfo[] = {
    { &internal::Logger_LogInfo_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Logger_LogWarning_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Logger_LogError_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Logger_BindReceiver_Params_Data::Validate,
     nullptr /* no response */},
};

bool LoggerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::media_router::mojom::Logger::Name_,
    kLoggerValidationInfo);
}



}  // media_router::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace media_router::mojom {


void LoggerInterceptorForTesting::LogInfo(LogCategory category, const std::string& component, const std::string& message, const std::string& sink_id, const std::string& media_source, const std::string& session_id) {
  GetForwardingInterface()->LogInfo(
    std::move(category)
    , 
    std::move(component)
    , 
    std::move(message)
    , 
    std::move(sink_id)
    , 
    std::move(media_source)
    , 
    std::move(session_id)
    );
}
void LoggerInterceptorForTesting::LogWarning(LogCategory category, const std::string& component, const std::string& message, const std::string& sink_id, const std::string& media_source, const std::string& session_id) {
  GetForwardingInterface()->LogWarning(
    std::move(category)
    , 
    std::move(component)
    , 
    std::move(message)
    , 
    std::move(sink_id)
    , 
    std::move(media_source)
    , 
    std::move(session_id)
    );
}
void LoggerInterceptorForTesting::LogError(LogCategory category, const std::string& component, const std::string& message, const std::string& sink_id, const std::string& media_source, const std::string& session_id) {
  GetForwardingInterface()->LogError(
    std::move(category)
    , 
    std::move(component)
    , 
    std::move(message)
    , 
    std::move(sink_id)
    , 
    std::move(media_source)
    , 
    std::move(session_id)
    );
}
void LoggerInterceptorForTesting::BindReceiver(::mojo::PendingReceiver<Logger> receiver) {
  GetForwardingInterface()->BindReceiver(
    std::move(receiver)
    );
}
LoggerAsyncWaiter::LoggerAsyncWaiter(
    Logger* proxy) : proxy_(proxy) {}

LoggerAsyncWaiter::~LoggerAsyncWaiter() = default;







}  // media_router::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif