// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// vector_icons.cc.template is used to generate vector_icons.cc. Edit the former
// rather than the latter.

#include "components/media_message_center/vector_icons/vector_icons.h"

#include "components/vector_icons/cc_macros.h"
#include "ui/gfx/vector_icon_types.h"

#define DECLARE_VECTOR_COMMAND(x) using gfx::x;
DECLARE_VECTOR_COMMANDS

namespace media_message_center {

VECTOR_ICON_REP_TEMPLATE(kChevronRightPath, CANVAS_DIMENSIONS, 24,
MOVE_TO, 10, 6,
LINE_TO, 8.59, 7.41,
LINE_TO, 13.17, 12,
R_LINE_TO, -4.58, 4.59,
LINE_TO, 10, 18,
R_LINE_TO, 6, -6,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kChevronRightRepList, kChevronRightIcon, {kChevronRightPath})
VECTOR_ICON_REP_TEMPLATE(kMediaCastStartPath, MOVE_TO, 42, 6,
H_LINE_TO, 6,
R_CUBIC_TO, -2.2, 0, -4, 1.8, -4, 4,
R_V_LINE_TO, 6,
R_H_LINE_TO, 4,
R_V_LINE_TO, -6,
R_H_LINE_TO, 36,
R_V_LINE_TO, 28,
H_LINE_TO, 28,
R_V_LINE_TO, 4,
R_H_LINE_TO, 14,
R_CUBIC_TO, 2.2, 0, 4, -1.8, 4, -4,
V_LINE_TO, 10,
R_CUBIC_TO, 0, -2.2, -1.8, -4, -4, -4,
CLOSE,
MOVE_TO, 2, 36,
R_V_LINE_TO, 6,
R_H_LINE_TO, 6,
R_CUBIC_TO, 0, -3.3, -2.7, -6, -6, -6,
CLOSE,
R_MOVE_TO, 0, -8,
R_V_LINE_TO, 4,
R_CUBIC_TO, 5.5, 0, 10, 4.5, 10, 10,
R_H_LINE_TO, 4,
R_CUBIC_TO, 0, -7.7, -6.3, -14, -14, -14,
CLOSE,
R_MOVE_TO, 0, -8,
R_V_LINE_TO, 4,
R_CUBIC_TO, 9.9, 0, 18, 8.1, 18, 18,
R_H_LINE_TO, 4,
R_CUBIC_TO, 0, -12.2, -9.9, -22, -22, -22,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kMediaCastStartRepList, kMediaCastStartIcon, {kMediaCastStartPath})
VECTOR_ICON_REP_TEMPLATE(kMediaCastStopPath, CANVAS_DIMENSIONS, 20,
MOVE_TO, 7, 13,
R_H_LINE_TO, 6,
V_LINE_TO, 7,
H_LINE_TO, 7,
R_V_LINE_TO, 6,
CLOSE,
R_MOVE_TO, 3, 5,
R_ARC_TO, 7.8, 7.8, 0, 0, 1, -3.1, -0.62,
R_ARC_TO, 8.28, 8.28, 0, 0, 1, -2.56, -1.71,
R_ARC_TO, 8.28, 8.28, 0, 0, 1, -1.71, -2.56,
ARC_TO, 7.8, 7.8, 0, 0, 1, 2, 10,
R_ARC_TO, 7.7, 7.7, 0, 0, 1, 0.63, -3.1,
R_ARC_TO, 8.03, 8.03, 0, 0, 1, 4.27, -4.27,
ARC_TO, 7.8, 7.8, 0, 0, 1, 10, 2,
R_ARC_TO, 7.7, 7.7, 0, 0, 1, 3.1, 0.63,
R_CUBIC_TO, 0.97, 0.42, 1.82, 0.99, 2.54, 1.73,
R_ARC_TO, 7.86, 7.86, 0, 0, 1, 1.73, 2.54,
ARC_TO, 7.7, 7.7, 0, 0, 1, 18, 10,
R_ARC_TO, 7.8, 7.8, 0, 0, 1, -0.62, 3.1,
R_ARC_TO, 8.03, 8.03, 0, 0, 1, -4.27, 4.27,
R_ARC_TO, 7.7, 7.7, 0, 0, 1, -3.1, 0.63,
CLOSE,
R_MOVE_TO, 0, -1.5,
R_CUBIC_TO, 1.81, 0, 3.34, -0.63, 4.6, -1.9,
CUBIC_TO, 15.87, 13.34, 16.5, 11.81, 16.5, 10,
R_CUBIC_TO, 0, -1.81, -0.63, -3.34, -1.9, -4.6,
CUBIC_TO, 13.34, 4.13, 11.81, 3.5, 10, 3.5,
R_CUBIC_TO, -1.81, 0, -3.34, 0.63, -4.6, 1.9,
CUBIC_TO, 4.13, 6.66, 3.5, 8.19, 3.5, 10,
R_CUBIC_TO, 0, 1.81, 0.63, 3.34, 1.9, 4.6,
CUBIC_TO, 6.66, 15.87, 8.19, 16.5, 10, 16.5,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kMediaCastStopRepList, kMediaCastStopIcon, {kMediaCastStopPath})
VECTOR_ICON_REP_TEMPLATE(kMediaEnterPipPath, CANVAS_DIMENSIONS, 16,
MOVE_TO, 12, 7,
H_LINE_TO, 7,
R_V_LINE_TO, 4,
R_H_LINE_TO, 5,
V_LINE_TO, 7,
CLOSE,
R_MOVE_TO, 3, 5.67,
V_LINE_TO, 3.32,
CUBIC_TO, 15, 2.59, 14.43, 2, 13.73, 2,
H_LINE_TO, 2.27,
CUBIC_TO, 1.57, 2, 1, 2.59, 1, 3.32,
R_V_LINE_TO, 9.35,
CUBIC_TO, 1, 13.4, 1.57, 14, 2.27, 14,
R_H_LINE_TO, 11.45,
R_CUBIC_TO, 0.7, 0, 1.27, -0.6, 1.27, -1.33,
CLOSE,
R_MOVE_TO, -1.5, -0.17,
R_H_LINE_TO, -11,
R_V_LINE_TO, -9,
R_H_LINE_TO, 11,
R_V_LINE_TO, 9,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kMediaEnterPipRepList, kMediaEnterPipIcon, {kMediaEnterPipPath})
VECTOR_ICON_REP_TEMPLATE(kMediaExitPipPath, CANVAS_DIMENSIONS, 16,
MOVE_TO, 13.73, 2,
R_CUBIC_TO, 0.7, 0, 1.27, 0.59, 1.27, 1.32,
V_LINE_TO, 9,
R_H_LINE_TO, -1.5,
V_LINE_TO, 3.5,
R_H_LINE_TO, -11,
R_V_LINE_TO, 9,
H_LINE_TO, 9,
V_LINE_TO, 14,
H_LINE_TO, 2.27,
CUBIC_TO, 1.57, 14, 1, 13.4, 1, 12.67,
V_LINE_TO, 3.32,
CUBIC_TO, 1, 2.59, 1.57, 2, 2.27, 2,
CLOSE,
MOVE_TO, 9, 5,
H_LINE_TO, 4,
R_V_LINE_TO, 4,
R_H_LINE_TO, 5,
CLOSE,
MOVE_TO, 12, 10,
R_V_LINE_TO, 4,
R_H_LINE_TO, -1,
R_V_LINE_TO, -4,
CLOSE,
MOVE_TO, 11.71, 10,
R_LINE_TO, 4.24, 4.24,
R_LINE_TO, -0.71, 0.71,
LINE_TO, 11, 10.71,
CLOSE,
MOVE_TO, 11, 10,
R_H_LINE_TO, 4,
R_V_LINE_TO, 1,
R_H_LINE_TO, -4,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kMediaExitPipRepList, kMediaExitPipIcon, {kMediaExitPipPath})
VECTOR_ICON_REP_TEMPLATE(kMediaNextTrackPath, CANVAS_DIMENSIONS, 16,
MOVE_TO, 3, 13,
LINE_TO, 9, 8,
LINE_TO, 3, 3,
LINE_TO, 3, 13,
CLOSE,
MOVE_TO, 11, 3,
LINE_TO, 11, 13,
LINE_TO, 13, 13,
LINE_TO, 13, 3,
LINE_TO, 11, 3,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kMediaNextTrackRepList, kMediaNextTrackIcon, {kMediaNextTrackPath})
VECTOR_ICON_REP_TEMPLATE(kMediaPreviousTrackPath, CANVAS_DIMENSIONS, 16,
MOVE_TO, 3, 3,
LINE_TO, 5, 3,
LINE_TO, 5, 13,
LINE_TO, 3, 13,
LINE_TO, 3, 3,
CLOSE,
MOVE_TO, 7, 8,
LINE_TO, 13, 13,
LINE_TO, 13, 3,
LINE_TO, 7, 8,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kMediaPreviousTrackRepList, kMediaPreviousTrackIcon, {kMediaPreviousTrackPath})
VECTOR_ICON_REP_TEMPLATE(kMediaSeekBackwardPath, CANVAS_DIMENSIONS, 16,
MOVE_TO, 8, 13,
LINE_TO, 8, 3,
LINE_TO, 2, 8,
LINE_TO, 8, 13,
CLOSE,
MOVE_TO, 8, 8,
LINE_TO, 14, 13,
LINE_TO, 14, 3,
LINE_TO, 8, 8,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kMediaSeekBackwardRepList, kMediaSeekBackwardIcon, {kMediaSeekBackwardPath})
VECTOR_ICON_REP_TEMPLATE(kMediaSeekForwardPath, CANVAS_DIMENSIONS, 16,
MOVE_TO, 2, 13,
LINE_TO, 8, 8,
LINE_TO, 2, 3,
LINE_TO, 2, 13,
CLOSE,
MOVE_TO, 8, 3,
LINE_TO, 8, 13,
LINE_TO, 14, 8,
LINE_TO, 8, 3,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kMediaSeekForwardRepList, kMediaSeekForwardIcon, {kMediaSeekForwardPath})
VECTOR_ICON_REP_TEMPLATE(kPausePath, CANVAS_DIMENSIONS, 16,
MOVE_TO, 7, 2,
LINE_TO, 7, 14,
LINE_TO, 4, 14,
LINE_TO, 4, 2,
LINE_TO, 7, 2,
CLOSE,
MOVE_TO, 12, 2,
LINE_TO, 12, 14,
LINE_TO, 9, 14,
LINE_TO, 9, 2,
LINE_TO, 12, 2,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kPauseRepList, kPauseIcon, {kPausePath})
VECTOR_ICON_REP_TEMPLATE(kPlayArrowPath, CANVAS_DIMENSIONS, 16,
MOVE_TO, 6, 13,
R_LINE_TO, 6, -5,
R_LINE_TO, -6, -5,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kPlayArrowRepList, kPlayArrowIcon, {kPlayArrowPath})

}
