// components/ip_protection/mojom/core_test.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_IP_PROTECTION_MOJOM_CORE_TEST_MOJOM_BLINK_H_
#define COMPONENTS_IP_PROTECTION_MOJOM_CORE_TEST_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/ip_protection/mojom/core_test.mojom-features.h"  // IWYU pragma: export
#include "components/ip_protection/mojom/core_test.mojom-shared.h"  // IWYU pragma: export
#include "components/ip_protection/mojom/core_test.mojom-blink-forward.h"  // IWYU pragma: export
#include "components/ip_protection/mojom/data_types.mojom-blink-forward.h"
#include "mojo/public/mojom/base/time.mojom-blink.h"
#include "url/mojom/url.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace ip_protection::mojom::blink {

class CoreControlTestProxy;

template <typename ImplRefTraits>
class CoreControlTestStub;

class CoreControlTestRequestValidator;
class CoreControlTestResponseValidator;


class CoreControlTest
    : public CoreControlTestInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "ip_protection.mojom.CoreControlTest";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = CoreControlTestInterfaceBase;
  using Proxy_ = CoreControlTestProxy;

  template <typename ImplRefTraits>
  using Stub_ = CoreControlTestStub<ImplRefTraits>;

  using RequestValidator_ = CoreControlTestRequestValidator;
  using ResponseValidator_ = CoreControlTestResponseValidator;
  enum MethodMinVersions : uint32_t {
    kVerifyIpProtectionCoreHostForTestingMinVersion = 0,
    kIsIpProtectionEnabledForTestingMinVersion = 0,
    kGetAuthTokenForTestingMinVersion = 0,
    kHasTrackingProtectionExceptionForTestingMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct VerifyIpProtectionCoreHostForTesting_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct IsIpProtectionEnabledForTesting_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetAuthTokenForTesting_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct HasTrackingProtectionExceptionForTesting_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~CoreControlTest() = default;

  using VerifyIpProtectionCoreHostForTestingCallback = base::OnceCallback<void(::ip_protection::mojom::blink::BlindSignedAuthTokenPtr, std::optional<::base::Time>)>;
  using VerifyIpProtectionCoreHostForTestingMojoCallback = base::OnceCallback<void(::ip_protection::mojom::blink::BlindSignedAuthTokenPtr, std::optional<::base::Time>)>;

  virtual void VerifyIpProtectionCoreHostForTesting(VerifyIpProtectionCoreHostForTestingCallback callback) = 0;

  using IsIpProtectionEnabledForTestingCallback = base::OnceCallback<void(bool)>;
  using IsIpProtectionEnabledForTestingMojoCallback = base::OnceCallback<void(bool)>;

  virtual void IsIpProtectionEnabledForTesting(IsIpProtectionEnabledForTestingCallback callback) = 0;

  using GetAuthTokenForTestingCallback = base::OnceCallback<void(::ip_protection::mojom::blink::BlindSignedAuthTokenPtr)>;
  using GetAuthTokenForTestingMojoCallback = base::OnceCallback<void(::ip_protection::mojom::blink::BlindSignedAuthTokenPtr)>;

  virtual void GetAuthTokenForTesting(::ip_protection::mojom::blink::ProxyLayer proxy_layer, const ::blink::String& geo_id, GetAuthTokenForTestingCallback callback) = 0;

  using HasTrackingProtectionExceptionForTestingCallback = base::OnceCallback<void(bool)>;
  using HasTrackingProtectionExceptionForTestingMojoCallback = base::OnceCallback<void(bool)>;

  virtual void HasTrackingProtectionExceptionForTesting(const ::blink::KURL& first_party_url, HasTrackingProtectionExceptionForTestingCallback callback) = 0;
};



class  CoreControlTestProxy
    : public CoreControlTest {
 public:
  using InterfaceType = CoreControlTest;

  explicit CoreControlTestProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void VerifyIpProtectionCoreHostForTesting(VerifyIpProtectionCoreHostForTestingCallback callback) final;
  
  void IsIpProtectionEnabledForTesting(IsIpProtectionEnabledForTestingCallback callback) final;
  
  void GetAuthTokenForTesting(::ip_protection::mojom::blink::ProxyLayer proxy_layer, const ::blink::String& geo_id, GetAuthTokenForTestingCallback callback) final;
  
  void HasTrackingProtectionExceptionForTesting(const ::blink::KURL& first_party_url, HasTrackingProtectionExceptionForTestingCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  CoreControlTestStubDispatch {
 public:
  static bool Accept(CoreControlTest* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      CoreControlTest* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<CoreControlTest>>
class CoreControlTestStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  CoreControlTestStub() = default;
  ~CoreControlTestStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CoreControlTestStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CoreControlTestStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  CoreControlTestRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  CoreControlTestResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // ip_protection::mojom::blink

namespace mojo {

}  // namespace mojo

#endif  // COMPONENTS_IP_PROTECTION_MOJOM_CORE_TEST_MOJOM_BLINK_H_