// components/history_clusters/public/mojom/history_cluster_types.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "components/history_clusters/public/mojom/history_cluster_types.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/history_clusters/public/mojom/history_cluster_types.mojom-params-data.h"
namespace history_clusters {
namespace mojom {

NOINLINE static const char* AnnotationToStringHelper(Annotation value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case Annotation::kBookmarked:
      return "kBookmarked";
    case Annotation::kSearchResultsPage:
      return "kSearchResultsPage";
    default:
      return nullptr;
  }
}

std::string AnnotationToString(Annotation value) {
  const char *str = AnnotationToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown Annotation value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, Annotation value) {
  return os << AnnotationToString(value);
}

NOINLINE static const char* InteractionStateToStringHelper(InteractionState value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case InteractionState::kDefault:
      return "kDefault";
    case InteractionState::kHidden:
      return "kHidden";
    case InteractionState::kDone:
      return "kDone";
    default:
      return nullptr;
  }
}

std::string InteractionStateToString(InteractionState value) {
  const char *str = InteractionStateToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown InteractionState value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, InteractionState value) {
  return os << InteractionStateToString(value);
}

namespace internal {


// static
bool MatchPosition_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MatchPosition_Data* object =
      static_cast<const MatchPosition_Data*>(data);

  return true;
}

MatchPosition_Data::MatchPosition_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SearchQuery_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SearchQuery_Data* object =
      static_cast<const SearchQuery_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->query, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& query_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->query, validation_context,
                                         &query_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  return true;
}

SearchQuery_Data::SearchQuery_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RawVisitData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RawVisitData_Data* object =
      static_cast<const RawVisitData_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->visit_time, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->visit_time, validation_context))
    return false;

  return true;
}

RawVisitData_Data::RawVisitData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool URLVisit_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 104, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const URLVisit_Data* object =
      static_cast<const URLVisit_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->normalized_url, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->normalized_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url_for_display, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& url_for_display_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->url_for_display, validation_context,
                                         &url_for_display_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->page_title, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& page_title_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->page_title, validation_context,
                                         &page_title_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->title_match_positions, 5, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& title_match_positions_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->title_match_positions, validation_context,
                                         &title_match_positions_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url_for_display_match_positions, 6, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& url_for_display_match_positions_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->url_for_display_match_positions, validation_context,
                                         &url_for_display_match_positions_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->raw_visit_data, 7, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->raw_visit_data, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->duplicates, 8, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& duplicates_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->duplicates, validation_context,
                                         &duplicates_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->relative_date, 9, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& relative_date_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->relative_date, validation_context,
                                         &relative_date_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->annotations, 10, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& annotations_validate_params =
      mojo::internal::GetArrayOfEnumsValidator<0, false, ::history_clusters::mojom::internal::Annotation_Data::Validate>();
  if (!mojo::internal::ValidateContainer(object->annotations, validation_context,
                                         &annotations_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->debug_info, 12, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& debug_info_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
  if (!mojo::internal::ValidateContainer(object->debug_info, validation_context,
                                         &debug_info_validate_params)) {
    return false;
  }

  return true;
}

URLVisit_Data::URLVisit_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Cluster_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 80, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Cluster_Data* object =
      static_cast<const Cluster_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->visits, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& visits_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->visits, validation_context,
                                         &visits_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->label, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& label_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->label, validation_context,
                                         &label_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& tab_group_name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->tab_group_name, validation_context,
                                         &tab_group_name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->label_match_positions, 5, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& label_match_positions_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->label_match_positions, validation_context,
                                         &label_match_positions_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->related_searches, 6, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& related_searches_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->related_searches, validation_context,
                                         &related_searches_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->image_url, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& debug_info_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->debug_info, validation_context,
                                         &debug_info_validate_params)) {
    return false;
  }

  return true;
}

Cluster_Data::Cluster_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace history_clusters

namespace perfetto {

// static
void TraceFormatTraits<::history_clusters::mojom::Annotation>::WriteIntoTrace(
   perfetto::TracedValue context, ::history_clusters::mojom::Annotation value) {
  return std::move(context).WriteString(::history_clusters::mojom::AnnotationToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::history_clusters::mojom::InteractionState>::WriteIntoTrace(
   perfetto::TracedValue context, ::history_clusters::mojom::InteractionState value) {
  return std::move(context).WriteString(::history_clusters::mojom::InteractionStateToString(value));
}

} // namespace perfetto