// components/heap_profiling/in_process/mojom/snapshot_controller.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/heap_profiling/in_process/mojom/snapshot_controller.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/heap_profiling/in_process/mojom/snapshot_controller.mojom-params-data.h"
#include "components/heap_profiling/in_process/mojom/snapshot_controller.mojom-shared-message-ids.h"

#include "components/heap_profiling/in_process/mojom/snapshot_controller.mojom-import-headers.h"
#include "components/heap_profiling/in_process/mojom/snapshot_controller.mojom-test-utils.h"


namespace heap_profiling::mojom {
// The declaration includes the definition on other builds.

SnapshotController::IPCStableHashFunction SnapshotController::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::SnapshotController>(message.name())) {
    case messages::SnapshotController::kTakeSnapshot: {
      return &SnapshotController::TakeSnapshot_Sym::IPCStableHash;
    }
    case messages::SnapshotController::kLogMetricsWithoutSnapshot: {
      return &SnapshotController::LogMetricsWithoutSnapshot_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* SnapshotController::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::SnapshotController>(message.name())) {
      case messages::SnapshotController::kTakeSnapshot:
            return "Receive heap_profiling::mojom::SnapshotController::TakeSnapshot";
      case messages::SnapshotController::kLogMetricsWithoutSnapshot:
            return "Receive heap_profiling::mojom::SnapshotController::LogMetricsWithoutSnapshot";
    }
  } else {
    switch (static_cast<messages::SnapshotController>(message.name())) {
      case messages::SnapshotController::kTakeSnapshot:
            return "Receive reply heap_profiling::mojom::SnapshotController::TakeSnapshot";
      case messages::SnapshotController::kLogMetricsWithoutSnapshot:
            return "Receive reply heap_profiling::mojom::SnapshotController::LogMetricsWithoutSnapshot";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t SnapshotController::TakeSnapshot_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6dea058a;  // IPCStableHash for heap_profiling::mojom::SnapshotController::TakeSnapshot
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SnapshotController::LogMetricsWithoutSnapshot_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd4b5db60;  // IPCStableHash for heap_profiling::mojom::SnapshotController::LogMetricsWithoutSnapshot
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

SnapshotControllerProxy::SnapshotControllerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SnapshotControllerProxy::TakeSnapshot(
    uint32_t in_process_probability_pct, uint32_t in_process_index) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send heap_profiling::mojom::SnapshotController::TakeSnapshot", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("process_probability_pct"), in_process_probability_pct,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("process_index"), in_process_index,
                        "<value of type uint32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SnapshotController::kTakeSnapshot), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::heap_profiling::mojom::internal::SnapshotController_TakeSnapshot_Params_Data> params(
          message);
  params.Allocate();

  params->process_probability_pct = in_process_probability_pct;

  params->process_index = in_process_index;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SnapshotController::Name_);
  message.set_method_name("TakeSnapshot");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void SnapshotControllerProxy::LogMetricsWithoutSnapshot(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send heap_profiling::mojom::SnapshotController::LogMetricsWithoutSnapshot");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SnapshotController::kLogMetricsWithoutSnapshot), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::heap_profiling::mojom::internal::SnapshotController_LogMetricsWithoutSnapshot_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SnapshotController::Name_);
  message.set_method_name("LogMetricsWithoutSnapshot");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool SnapshotControllerStubDispatch::Accept(
    SnapshotController* impl,
    mojo::Message* message) {
  switch (static_cast<messages::SnapshotController>(message->header()->name)) {
    case messages::SnapshotController::kTakeSnapshot: {
      DCHECK(message->is_serialized());
      internal::SnapshotController_TakeSnapshot_Params_Data* params =
          reinterpret_cast<internal::SnapshotController_TakeSnapshot_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SnapshotController.0
      bool success = true;
      uint32_t p_process_probability_pct{};
      uint32_t p_process_index{};
      SnapshotController_TakeSnapshot_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_process_probability_pct = input_data_view.process_probability_pct();
      if (success)
        p_process_index = input_data_view.process_index();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SnapshotController::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->TakeSnapshot(        
        std::move(p_process_probability_pct), 
        std::move(p_process_index));
      return true;
    }
    case messages::SnapshotController::kLogMetricsWithoutSnapshot: {
      DCHECK(message->is_serialized());
      internal::SnapshotController_LogMetricsWithoutSnapshot_Params_Data* params =
          reinterpret_cast<internal::SnapshotController_LogMetricsWithoutSnapshot_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SnapshotController.1
      bool success = true;
      SnapshotController_LogMetricsWithoutSnapshot_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SnapshotController::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->LogMetricsWithoutSnapshot(        );
      return true;
    }
  }
  return false;
}

// static
bool SnapshotControllerStubDispatch::AcceptWithResponder(
    SnapshotController* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::SnapshotController>(message->header()->name)) {
    case messages::SnapshotController::kTakeSnapshot: {
      break;
    }
    case messages::SnapshotController::kLogMetricsWithoutSnapshot: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kSnapshotControllerValidationInfo[] = {
    { &internal::SnapshotController_TakeSnapshot_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::SnapshotController_LogMetricsWithoutSnapshot_Params_Data::Validate,
     nullptr /* no response */},
};

bool SnapshotControllerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::heap_profiling::mojom::SnapshotController::Name_,
    kSnapshotControllerValidationInfo);
}



}  // heap_profiling::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace heap_profiling::mojom {


void SnapshotControllerInterceptorForTesting::TakeSnapshot(uint32_t process_probability_pct, uint32_t process_index) {
  GetForwardingInterface()->TakeSnapshot(
    std::move(process_probability_pct)
    , 
    std::move(process_index)
    );
}
void SnapshotControllerInterceptorForTesting::LogMetricsWithoutSnapshot() {
  GetForwardingInterface()->LogMetricsWithoutSnapshot();
}
SnapshotControllerAsyncWaiter::SnapshotControllerAsyncWaiter(
    SnapshotController* proxy) : proxy_(proxy) {}

SnapshotControllerAsyncWaiter::~SnapshotControllerAsyncWaiter() = default;







}  // heap_profiling::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif