// components/dom_distiller/content/common/mojom/distillability_service.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/dom_distiller/content/common/mojom/distillability_service.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/dom_distiller/content/common/mojom/distillability_service.mojom-params-data.h"
#include "components/dom_distiller/content/common/mojom/distillability_service.mojom-shared-message-ids.h"

#include "components/dom_distiller/content/common/mojom/distillability_service.mojom-import-headers.h"
#include "components/dom_distiller/content/common/mojom/distillability_service.mojom-test-utils.h"


namespace dom_distiller::mojom {
// The declaration includes the definition on other builds.

DistillabilityService::IPCStableHashFunction DistillabilityService::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::DistillabilityService>(message.name())) {
    case messages::DistillabilityService::kNotifyIsDistillable: {
      return &DistillabilityService::NotifyIsDistillable_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* DistillabilityService::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::DistillabilityService>(message.name())) {
      case messages::DistillabilityService::kNotifyIsDistillable:
            return "Receive dom_distiller::mojom::DistillabilityService::NotifyIsDistillable";
    }
  } else {
    switch (static_cast<messages::DistillabilityService>(message.name())) {
      case messages::DistillabilityService::kNotifyIsDistillable:
            return "Receive reply dom_distiller::mojom::DistillabilityService::NotifyIsDistillable";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t DistillabilityService::NotifyIsDistillable_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xdff24a95;  // IPCStableHash for dom_distiller::mojom::DistillabilityService::NotifyIsDistillable
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

DistillabilityServiceProxy::DistillabilityServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void DistillabilityServiceProxy::NotifyIsDistillable(
    bool in_page_is_distillable, bool in_is_last_update, bool in_is_long_article, bool in_is_mobile_friendly) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send dom_distiller::mojom::DistillabilityService::NotifyIsDistillable", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("page_is_distillable"), in_page_is_distillable,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_last_update"), in_is_last_update,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_long_article"), in_is_long_article,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_mobile_friendly"), in_is_mobile_friendly,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DistillabilityService::kNotifyIsDistillable), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::dom_distiller::mojom::internal::DistillabilityService_NotifyIsDistillable_Params_Data> params(
          message);
  params.Allocate();

  params->page_is_distillable = in_page_is_distillable;

  params->is_last_update = in_is_last_update;

  params->is_long_article = in_is_long_article;

  params->is_mobile_friendly = in_is_mobile_friendly;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DistillabilityService::Name_);
  message.set_method_name("NotifyIsDistillable");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool DistillabilityServiceStubDispatch::Accept(
    DistillabilityService* impl,
    mojo::Message* message) {
  switch (static_cast<messages::DistillabilityService>(message->header()->name)) {
    case messages::DistillabilityService::kNotifyIsDistillable: {
      DCHECK(message->is_serialized());
      internal::DistillabilityService_NotifyIsDistillable_Params_Data* params =
          reinterpret_cast<internal::DistillabilityService_NotifyIsDistillable_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DistillabilityService.0
      bool success = true;
      bool p_page_is_distillable{};
      bool p_is_last_update{};
      bool p_is_long_article{};
      bool p_is_mobile_friendly{};
      DistillabilityService_NotifyIsDistillable_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_page_is_distillable = input_data_view.page_is_distillable();
      if (success)
        p_is_last_update = input_data_view.is_last_update();
      if (success)
        p_is_long_article = input_data_view.is_long_article();
      if (success)
        p_is_mobile_friendly = input_data_view.is_mobile_friendly();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DistillabilityService::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NotifyIsDistillable(        
        std::move(p_page_is_distillable), 
        std::move(p_is_last_update), 
        std::move(p_is_long_article), 
        std::move(p_is_mobile_friendly));
      return true;
    }
  }
  return false;
}

// static
bool DistillabilityServiceStubDispatch::AcceptWithResponder(
    DistillabilityService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::DistillabilityService>(message->header()->name)) {
    case messages::DistillabilityService::kNotifyIsDistillable: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kDistillabilityServiceValidationInfo[] = {
    { &internal::DistillabilityService_NotifyIsDistillable_Params_Data::Validate,
     nullptr /* no response */},
};

bool DistillabilityServiceRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::dom_distiller::mojom::DistillabilityService::Name_,
    kDistillabilityServiceValidationInfo);
}



}  // dom_distiller::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace dom_distiller::mojom {


void DistillabilityServiceInterceptorForTesting::NotifyIsDistillable(bool page_is_distillable, bool is_last_update, bool is_long_article, bool is_mobile_friendly) {
  GetForwardingInterface()->NotifyIsDistillable(
    std::move(page_is_distillable)
    , 
    std::move(is_last_update)
    , 
    std::move(is_long_article)
    , 
    std::move(is_mobile_friendly)
    );
}
DistillabilityServiceAsyncWaiter::DistillabilityServiceAsyncWaiter(
    DistillabilityService* proxy) : proxy_(proxy) {}

DistillabilityServiceAsyncWaiter::~DistillabilityServiceAsyncWaiter() = default;







}  // dom_distiller::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif