// components/continuous_search/common/public/mojom/continuous_search.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_CONTINUOUS_SEARCH_COMMON_PUBLIC_MOJOM_CONTINUOUS_SEARCH_MOJOM_DATA_VIEW_H_
#define COMPONENTS_CONTINUOUS_SEARCH_COMMON_PUBLIC_MOJOM_CONTINUOUS_SEARCH_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "components/continuous_search/common/public/mojom/continuous_search.mojom-shared-internal.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"


namespace continuous_search::mojom {
class SearchResultDataView;

class ResultGroupDataView;

class CategoryResultsDataView;



}  // continuous_search::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::continuous_search::mojom::SearchResultDataView> {
  using Data = ::continuous_search::mojom::internal::SearchResult_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::continuous_search::mojom::ResultGroupDataView> {
  using Data = ::continuous_search::mojom::internal::ResultGroup_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::continuous_search::mojom::CategoryResultsDataView> {
  using Data = ::continuous_search::mojom::internal::CategoryResults_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace continuous_search::mojom {


enum class ResultType : int32_t {
  
  kSearchResults = 0,
  
  kRelatedSearches = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, ResultType value);
inline bool IsKnownEnumValue(ResultType value) {
  return internal::ResultType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class Category : int32_t {
  
  kNone = 0,
  
  kOrganic = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, Category value);
inline bool IsKnownEnumValue(Category value) {
  return internal::Category_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class SearchResultExtractor_Status : int32_t {
  
  kSuccess = 0,
  
  kNoResults = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, SearchResultExtractor_Status value);
inline bool IsKnownEnumValue(SearchResultExtractor_Status value) {
  return internal::SearchResultExtractor_Status_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class SearchResultExtractorInterfaceBase {};

using SearchResultExtractorPtrDataView =
    mojo::InterfacePtrDataView<SearchResultExtractorInterfaceBase>;
using SearchResultExtractorRequestDataView =
    mojo::InterfaceRequestDataView<SearchResultExtractorInterfaceBase>;
using SearchResultExtractorAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<SearchResultExtractorInterfaceBase>;
using SearchResultExtractorAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<SearchResultExtractorInterfaceBase>;


class SearchResultDataView {
 public:
  SearchResultDataView() = default;

  SearchResultDataView(
      internal::SearchResult_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetLinkDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLink(UserType* output) {
    
    auto* pointer = data_->link.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetTitleDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTitle(UserType* output) {
    
    auto* pointer = data_->title.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
 private:
  internal::SearchResult_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ResultGroupDataView {
 public:
  ResultGroupDataView() = default;

  ResultGroupDataView(
      internal::ResultGroup_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::continuous_search::mojom::ResultType>(
        data_value, output);
  }
  ResultType type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::continuous_search::mojom::ResultType>(data_->type));
  }
  inline void GetResultsDataView(
      mojo::ArrayDataView<SearchResultDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadResults(UserType* output) {
    
    auto* pointer = data_->results.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::continuous_search::mojom::SearchResultDataView>>(
        pointer, output, message_);
  }
 private:
  internal::ResultGroup_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CategoryResultsDataView {
 public:
  CategoryResultsDataView() = default;

  CategoryResultsDataView(
      internal::CategoryResults_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetDocumentUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDocumentUrl(UserType* output) {
    
    auto* pointer = data_->document_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadCategoryType(UserType* output) const {
    auto data_value = data_->category_type;
    return mojo::internal::Deserialize<::continuous_search::mojom::Category>(
        data_value, output);
  }
  Category category_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::continuous_search::mojom::Category>(data_->category_type));
  }
  inline void GetGroupsDataView(
      mojo::ArrayDataView<ResultGroupDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGroups(UserType* output) {
    
    auto* pointer = data_->groups.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::continuous_search::mojom::ResultGroupDataView>>(
        pointer, output, message_);
  }
 private:
  internal::CategoryResults_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // continuous_search::mojom

#endif  // COMPONENTS_CONTINUOUS_SEARCH_COMMON_PUBLIC_MOJOM_CONTINUOUS_SEARCH_MOJOM_DATA_VIEW_H_