// components/content_settings/core/common/content_settings_types.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "components/content_settings/core/common/content_settings_types.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/content_settings/core/common/content_settings_types.mojom-params-data.h"
namespace content_settings {
namespace mojom {

NOINLINE static const char* ContentSettingsTypeToStringHelper(ContentSettingsType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ContentSettingsType::DEFAULT:
      return "DEFAULT";
    case ContentSettingsType::COOKIES:
      return "COOKIES";
    case ContentSettingsType::IMAGES:
      return "IMAGES";
    case ContentSettingsType::JAVASCRIPT:
      return "JAVASCRIPT";
    case ContentSettingsType::POPUPS:
      return "POPUPS";
    case ContentSettingsType::GEOLOCATION:
      return "GEOLOCATION";
    case ContentSettingsType::GEOLOCATION_WITH_OPTIONS:
      return "GEOLOCATION_WITH_OPTIONS";
    case ContentSettingsType::NOTIFICATIONS:
      return "NOTIFICATIONS";
    case ContentSettingsType::AUTO_SELECT_CERTIFICATE:
      return "AUTO_SELECT_CERTIFICATE";
    case ContentSettingsType::MIXEDSCRIPT:
      return "MIXEDSCRIPT";
    case ContentSettingsType::MEDIASTREAM_MIC:
      return "MEDIASTREAM_MIC";
    case ContentSettingsType::MEDIASTREAM_CAMERA:
      return "MEDIASTREAM_CAMERA";
    case ContentSettingsType::PROTOCOL_HANDLERS:
      return "PROTOCOL_HANDLERS";
    case ContentSettingsType::DEPRECATED_PPAPI_BROKER:
      return "DEPRECATED_PPAPI_BROKER";
    case ContentSettingsType::AUTOMATIC_DOWNLOADS:
      return "AUTOMATIC_DOWNLOADS";
    case ContentSettingsType::MIDI_SYSEX:
      return "MIDI_SYSEX";
    case ContentSettingsType::SSL_CERT_DECISIONS:
      return "SSL_CERT_DECISIONS";
    case ContentSettingsType::PROTECTED_MEDIA_IDENTIFIER:
      return "PROTECTED_MEDIA_IDENTIFIER";
    case ContentSettingsType::APP_BANNER:
      return "APP_BANNER";
    case ContentSettingsType::SITE_ENGAGEMENT:
      return "SITE_ENGAGEMENT";
    case ContentSettingsType::DURABLE_STORAGE:
      return "DURABLE_STORAGE";
    case ContentSettingsType::USB_CHOOSER_DATA:
      return "USB_CHOOSER_DATA";
    case ContentSettingsType::BLUETOOTH_GUARD:
      return "BLUETOOTH_GUARD";
    case ContentSettingsType::BACKGROUND_SYNC:
      return "BACKGROUND_SYNC";
    case ContentSettingsType::AUTOPLAY:
      return "AUTOPLAY";
    case ContentSettingsType::IMPORTANT_SITE_INFO:
      return "IMPORTANT_SITE_INFO";
    case ContentSettingsType::PERMISSION_AUTOBLOCKER_DATA:
      return "PERMISSION_AUTOBLOCKER_DATA";
    case ContentSettingsType::ADS:
      return "ADS";
    case ContentSettingsType::ADS_DATA:
      return "ADS_DATA";
    case ContentSettingsType::MIDI:
      return "MIDI";
    case ContentSettingsType::PASSWORD_PROTECTION:
      return "PASSWORD_PROTECTION";
    case ContentSettingsType::MEDIA_ENGAGEMENT:
      return "MEDIA_ENGAGEMENT";
    case ContentSettingsType::SOUND:
      return "SOUND";
    case ContentSettingsType::CLIENT_HINTS:
      return "CLIENT_HINTS";
    case ContentSettingsType::SENSORS:
      return "SENSORS";
    case ContentSettingsType::DEPRECATED_ACCESSIBILITY_EVENTS:
      return "DEPRECATED_ACCESSIBILITY_EVENTS";
    case ContentSettingsType::PAYMENT_HANDLER:
      return "PAYMENT_HANDLER";
    case ContentSettingsType::USB_GUARD:
      return "USB_GUARD";
    case ContentSettingsType::BACKGROUND_FETCH:
      return "BACKGROUND_FETCH";
    case ContentSettingsType::INTENT_PICKER_DISPLAY:
      return "INTENT_PICKER_DISPLAY";
    case ContentSettingsType::IDLE_DETECTION:
      return "IDLE_DETECTION";
    case ContentSettingsType::SERIAL_GUARD:
      return "SERIAL_GUARD";
    case ContentSettingsType::SERIAL_CHOOSER_DATA:
      return "SERIAL_CHOOSER_DATA";
    case ContentSettingsType::PERIODIC_BACKGROUND_SYNC:
      return "PERIODIC_BACKGROUND_SYNC";
    case ContentSettingsType::BLUETOOTH_SCANNING:
      return "BLUETOOTH_SCANNING";
    case ContentSettingsType::HID_GUARD:
      return "HID_GUARD";
    case ContentSettingsType::HID_CHOOSER_DATA:
      return "HID_CHOOSER_DATA";
    case ContentSettingsType::WAKE_LOCK_SCREEN:
      return "WAKE_LOCK_SCREEN";
    case ContentSettingsType::WAKE_LOCK_SYSTEM:
      return "WAKE_LOCK_SYSTEM";
    case ContentSettingsType::LEGACY_COOKIE_ACCESS:
      return "LEGACY_COOKIE_ACCESS";
    case ContentSettingsType::FILE_SYSTEM_WRITE_GUARD:
      return "FILE_SYSTEM_WRITE_GUARD";
    case ContentSettingsType::NFC:
      return "NFC";
    case ContentSettingsType::BLUETOOTH_CHOOSER_DATA:
      return "BLUETOOTH_CHOOSER_DATA";
    case ContentSettingsType::CLIPBOARD_READ_WRITE:
      return "CLIPBOARD_READ_WRITE";
    case ContentSettingsType::CLIPBOARD_SANITIZED_WRITE:
      return "CLIPBOARD_SANITIZED_WRITE";
    case ContentSettingsType::SAFE_BROWSING_URL_CHECK_DATA:
      return "SAFE_BROWSING_URL_CHECK_DATA";
    case ContentSettingsType::VR:
      return "VR";
    case ContentSettingsType::AR:
      return "AR";
    case ContentSettingsType::FILE_SYSTEM_READ_GUARD:
      return "FILE_SYSTEM_READ_GUARD";
    case ContentSettingsType::STORAGE_ACCESS:
      return "STORAGE_ACCESS";
    case ContentSettingsType::CAMERA_PAN_TILT_ZOOM:
      return "CAMERA_PAN_TILT_ZOOM";
    case ContentSettingsType::WINDOW_MANAGEMENT:
      return "WINDOW_MANAGEMENT";
    case ContentSettingsType::LOCAL_FONTS:
      return "LOCAL_FONTS";
    case ContentSettingsType::PERMISSION_AUTOREVOCATION_DATA:
      return "PERMISSION_AUTOREVOCATION_DATA";
    case ContentSettingsType::FILE_SYSTEM_LAST_PICKED_DIRECTORY:
      return "FILE_SYSTEM_LAST_PICKED_DIRECTORY";
    case ContentSettingsType::DISPLAY_CAPTURE:
      return "DISPLAY_CAPTURE";
    case ContentSettingsType::FILE_SYSTEM_ACCESS_CHOOSER_DATA:
      return "FILE_SYSTEM_ACCESS_CHOOSER_DATA";
    case ContentSettingsType::FEDERATED_IDENTITY_SHARING:
      return "FEDERATED_IDENTITY_SHARING";
    case ContentSettingsType::JAVASCRIPT_JIT:
      return "JAVASCRIPT_JIT";
    case ContentSettingsType::HTTP_ALLOWED:
      return "HTTP_ALLOWED";
    case ContentSettingsType::FORMFILL_METADATA:
      return "FORMFILL_METADATA";
    case ContentSettingsType::DEPRECATED_FEDERATED_IDENTITY_ACTIVE_SESSION:
      return "DEPRECATED_FEDERATED_IDENTITY_ACTIVE_SESSION";
    case ContentSettingsType::AUTO_DARK_WEB_CONTENT:
      return "AUTO_DARK_WEB_CONTENT";
    case ContentSettingsType::REQUEST_DESKTOP_SITE:
      return "REQUEST_DESKTOP_SITE";
    case ContentSettingsType::FEDERATED_IDENTITY_API:
      return "FEDERATED_IDENTITY_API";
    case ContentSettingsType::NOTIFICATION_INTERACTIONS:
      return "NOTIFICATION_INTERACTIONS";
    case ContentSettingsType::REDUCED_ACCEPT_LANGUAGE:
      return "REDUCED_ACCEPT_LANGUAGE";
    case ContentSettingsType::NOTIFICATION_PERMISSION_REVIEW:
      return "NOTIFICATION_PERMISSION_REVIEW";
    case ContentSettingsType::FEDERATED_IDENTITY_IDENTITY_PROVIDER_SIGNIN_STATUS:
      return "FEDERATED_IDENTITY_IDENTITY_PROVIDER_SIGNIN_STATUS";
    case ContentSettingsType::REVOKED_UNUSED_SITE_PERMISSIONS:
      return "REVOKED_UNUSED_SITE_PERMISSIONS";
    case ContentSettingsType::TOP_LEVEL_STORAGE_ACCESS:
      return "TOP_LEVEL_STORAGE_ACCESS";
    case ContentSettingsType::FEDERATED_IDENTITY_AUTO_REAUTHN_PERMISSION:
      return "FEDERATED_IDENTITY_AUTO_REAUTHN_PERMISSION";
    case ContentSettingsType::FEDERATED_IDENTITY_IDENTITY_PROVIDER_REGISTRATION:
      return "FEDERATED_IDENTITY_IDENTITY_PROVIDER_REGISTRATION";
    case ContentSettingsType::ANTI_ABUSE:
      return "ANTI_ABUSE";
    case ContentSettingsType::THIRD_PARTY_STORAGE_PARTITIONING:
      return "THIRD_PARTY_STORAGE_PARTITIONING";
    case ContentSettingsType::HTTPS_ENFORCED:
      return "HTTPS_ENFORCED";
    case ContentSettingsType::ALL_SCREEN_CAPTURE:
      return "ALL_SCREEN_CAPTURE";
    case ContentSettingsType::COOKIE_CONTROLS_METADATA:
      return "COOKIE_CONTROLS_METADATA";
    case ContentSettingsType::TPCD_HEURISTICS_GRANTS:
      return "TPCD_HEURISTICS_GRANTS";
    case ContentSettingsType::TPCD_METADATA_GRANTS:
      return "TPCD_METADATA_GRANTS";
    case ContentSettingsType::TPCD_TRIAL:
      return "TPCD_TRIAL";
    case ContentSettingsType::TOP_LEVEL_TPCD_TRIAL:
      return "TOP_LEVEL_TPCD_TRIAL";
    case ContentSettingsType::TOP_LEVEL_TPCD_ORIGIN_TRIAL:
      return "TOP_LEVEL_TPCD_ORIGIN_TRIAL";
    case ContentSettingsType::AUTO_PICTURE_IN_PICTURE:
      return "AUTO_PICTURE_IN_PICTURE";
    case ContentSettingsType::FILE_SYSTEM_ACCESS_EXTENDED_PERMISSION:
      return "FILE_SYSTEM_ACCESS_EXTENDED_PERMISSION";
    case ContentSettingsType::FILE_SYSTEM_ACCESS_RESTORE_PERMISSION:
      return "FILE_SYSTEM_ACCESS_RESTORE_PERMISSION";
    case ContentSettingsType::CAPTURED_SURFACE_CONTROL:
      return "CAPTURED_SURFACE_CONTROL";
    case ContentSettingsType::SMART_CARD_GUARD:
      return "SMART_CARD_GUARD";
    case ContentSettingsType::SMART_CARD_DATA:
      return "SMART_CARD_DATA";
    case ContentSettingsType::WEB_PRINTING:
      return "WEB_PRINTING";
    case ContentSettingsType::AUTOMATIC_FULLSCREEN:
      return "AUTOMATIC_FULLSCREEN";
    case ContentSettingsType::SUB_APP_INSTALLATION_PROMPTS:
      return "SUB_APP_INSTALLATION_PROMPTS";
    case ContentSettingsType::SPEAKER_SELECTION:
      return "SPEAKER_SELECTION";
    case ContentSettingsType::DIRECT_SOCKETS:
      return "DIRECT_SOCKETS";
    case ContentSettingsType::KEYBOARD_LOCK:
      return "KEYBOARD_LOCK";
    case ContentSettingsType::POINTER_LOCK:
      return "POINTER_LOCK";
    case ContentSettingsType::REVOKED_ABUSIVE_NOTIFICATION_PERMISSIONS:
      return "REVOKED_ABUSIVE_NOTIFICATION_PERMISSIONS";
    case ContentSettingsType::TRACKING_PROTECTION:
      return "TRACKING_PROTECTION";
    case ContentSettingsType::DISPLAY_MEDIA_SYSTEM_AUDIO:
      return "DISPLAY_MEDIA_SYSTEM_AUDIO";
    case ContentSettingsType::JAVASCRIPT_OPTIMIZER:
      return "JAVASCRIPT_OPTIMIZER";
    case ContentSettingsType::STORAGE_ACCESS_HEADER_ORIGIN_TRIAL:
      return "STORAGE_ACCESS_HEADER_ORIGIN_TRIAL";
    case ContentSettingsType::HAND_TRACKING:
      return "HAND_TRACKING";
    case ContentSettingsType::WEB_APP_INSTALLATION:
      return "WEB_APP_INSTALLATION";
    case ContentSettingsType::DIRECT_SOCKETS_PRIVATE_NETWORK_ACCESS:
      return "DIRECT_SOCKETS_PRIVATE_NETWORK_ACCESS";
    case ContentSettingsType::LEGACY_COOKIE_SCOPE:
      return "LEGACY_COOKIE_SCOPE";
    case ContentSettingsType::ARE_SUSPICIOUS_NOTIFICATIONS_ALLOWLISTED_BY_USER:
      return "ARE_SUSPICIOUS_NOTIFICATIONS_ALLOWLISTED_BY_USER";
    case ContentSettingsType::CONTROLLED_FRAME:
      return "CONTROLLED_FRAME";
    case ContentSettingsType::REVOKED_DISRUPTIVE_NOTIFICATION_PERMISSIONS:
      return "REVOKED_DISRUPTIVE_NOTIFICATION_PERMISSIONS";
    case ContentSettingsType::LOCAL_NETWORK_ACCESS:
      return "LOCAL_NETWORK_ACCESS";
    case ContentSettingsType::ON_DEVICE_SPEECH_RECOGNITION_LANGUAGES_DOWNLOADED:
      return "ON_DEVICE_SPEECH_RECOGNITION_LANGUAGES_DOWNLOADED";
    case ContentSettingsType::INITIALIZED_TRANSLATIONS:
      return "INITIALIZED_TRANSLATIONS";
    case ContentSettingsType::SUSPICIOUS_NOTIFICATION_IDS:
      return "SUSPICIOUS_NOTIFICATION_IDS";
    case ContentSettingsType::DEVICE_ATTRIBUTES:
      return "DEVICE_ATTRIBUTES";
    case ContentSettingsType::PERMISSION_ACTIONS_HISTORY:
      return "PERMISSION_ACTIONS_HISTORY";
    case ContentSettingsType::SUSPICIOUS_NOTIFICATION_SHOW_ORIGINAL:
      return "SUSPICIOUS_NOTIFICATION_SHOW_ORIGINAL";
    default:
      return nullptr;
  }
}

std::string ContentSettingsTypeToString(ContentSettingsType value) {
  const char *str = ContentSettingsTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ContentSettingsType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ContentSettingsType value) {
  return os << ContentSettingsTypeToString(value);
}

namespace internal {

}  // namespace internal
}  // namespace mojom
}  // namespace content_settings

namespace perfetto {

// static
void TraceFormatTraits<::content_settings::mojom::ContentSettingsType>::WriteIntoTrace(
   perfetto::TracedValue context, ::content_settings::mojom::ContentSettingsType value) {
  return std::move(context).WriteString(::content_settings::mojom::ContentSettingsTypeToString(value));
}

} // namespace perfetto