// components/content_settings/common/content_settings_manager.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/content_settings/common/content_settings_manager.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/content_settings/common/content_settings_manager.mojom-params-data.h"
#include "components/content_settings/common/content_settings_manager.mojom-shared-message-ids.h"

#include "components/content_settings/common/content_settings_manager.mojom-import-headers.h"
#include "components/content_settings/common/content_settings_manager.mojom-test-utils.h"


namespace content_settings::mojom {
// The declaration includes the definition on other builds.

ContentSettingsManager::IPCStableHashFunction ContentSettingsManager::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ContentSettingsManager>(message.name())) {
    case messages::ContentSettingsManager::kClone: {
      return &ContentSettingsManager::Clone_Sym::IPCStableHash;
    }
    case messages::ContentSettingsManager::kAllowStorageAccess: {
      return &ContentSettingsManager::AllowStorageAccess_Sym::IPCStableHash;
    }
    case messages::ContentSettingsManager::kOnContentBlocked: {
      return &ContentSettingsManager::OnContentBlocked_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ContentSettingsManager::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ContentSettingsManager>(message.name())) {
      case messages::ContentSettingsManager::kClone:
            return "Receive content_settings::mojom::ContentSettingsManager::Clone";
      case messages::ContentSettingsManager::kAllowStorageAccess:
            return "Receive content_settings::mojom::ContentSettingsManager::AllowStorageAccess";
      case messages::ContentSettingsManager::kOnContentBlocked:
            return "Receive content_settings::mojom::ContentSettingsManager::OnContentBlocked";
    }
  } else {
    switch (static_cast<messages::ContentSettingsManager>(message.name())) {
      case messages::ContentSettingsManager::kClone:
            return "Receive reply content_settings::mojom::ContentSettingsManager::Clone";
      case messages::ContentSettingsManager::kAllowStorageAccess:
            return "Receive reply content_settings::mojom::ContentSettingsManager::AllowStorageAccess";
      case messages::ContentSettingsManager::kOnContentBlocked:
            return "Receive reply content_settings::mojom::ContentSettingsManager::OnContentBlocked";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ContentSettingsManager::Clone_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2732b3b4;  // IPCStableHash for content_settings::mojom::ContentSettingsManager::Clone
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ContentSettingsManager::AllowStorageAccess_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3167253e;  // IPCStableHash for content_settings::mojom::ContentSettingsManager::AllowStorageAccess
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ContentSettingsManager::OnContentBlocked_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xbeb8ae82;  // IPCStableHash for content_settings::mojom::ContentSettingsManager::OnContentBlocked
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)
bool ContentSettingsManager::AllowStorageAccess(const ::blink::LocalFrameToken& frame_token, ContentSettingsManager::StorageType storage_type, const ::url::Origin& origin, const ::net::SiteForCookies& site_for_cookies, const ::url::Origin& top_frame_origin, bool* out_allowed) {
  NOTREACHED();
}
class ContentSettingsManager_AllowStorageAccess_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  ContentSettingsManager_AllowStorageAccess_HandleSyncResponse(
      bool* result, bool* out_allowed)
      : result_(result), out_allowed_(out_allowed) {
    DCHECK(!*result_);
  }

  ContentSettingsManager_AllowStorageAccess_HandleSyncResponse(const ContentSettingsManager_AllowStorageAccess_HandleSyncResponse&) = delete;
  ContentSettingsManager_AllowStorageAccess_HandleSyncResponse& operator=(const ContentSettingsManager_AllowStorageAccess_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  bool* out_allowed_;};

class ContentSettingsManager_AllowStorageAccess_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ContentSettingsManager_AllowStorageAccess_ForwardToCallback(
      ContentSettingsManager::AllowStorageAccessCallback callback
      ) : callback_(std::move(callback)) {
  }

  ContentSettingsManager_AllowStorageAccess_ForwardToCallback(const ContentSettingsManager_AllowStorageAccess_ForwardToCallback&) = delete;
  ContentSettingsManager_AllowStorageAccess_ForwardToCallback& operator=(const ContentSettingsManager_AllowStorageAccess_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ContentSettingsManager::AllowStorageAccessCallback callback_;
};

ContentSettingsManagerProxy::ContentSettingsManagerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ContentSettingsManagerProxy::Clone(
    ::mojo::PendingReceiver<ContentSettingsManager> in_clone) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send content_settings::mojom::ContentSettingsManager::Clone", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("clone"), in_clone,
                        "<value of type ::mojo::PendingReceiver<ContentSettingsManager>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ContentSettingsManager::kClone), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content_settings::mojom::internal::ContentSettingsManager_Clone_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::content_settings::mojom::ContentSettingsManagerInterfaceBase>>(
    in_clone,
    &params->clone,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->clone)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid clone in ContentSettingsManager.Clone request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ContentSettingsManager::Name_);
  message.set_method_name("Clone");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
bool ContentSettingsManagerProxy::AllowStorageAccess(
    const ::blink::LocalFrameToken& param_frame_token, ContentSettingsManager::StorageType param_storage_type, const ::url::Origin& param_origin, const ::net::SiteForCookies& param_site_for_cookies, const ::url::Origin& param_top_frame_origin, bool* out_param_allowed) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call content_settings::mojom::ContentSettingsManager::AllowStorageAccess (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_token"), param_frame_token,
                        "<value of type const ::blink::LocalFrameToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("storage_type"), param_storage_type,
                        "<value of type ContentSettingsManager::StorageType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("origin"), param_origin,
                        "<value of type const ::url::Origin&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("site_for_cookies"), param_site_for_cookies,
                        "<value of type const ::net::SiteForCookies&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("top_frame_origin"), param_top_frame_origin,
                        "<value of type const ::url::Origin&>");
   });
#else
  TRACE_EVENT0("mojom", "ContentSettingsManager::AllowStorageAccess");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ContentSettingsManager::kAllowStorageAccess), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content_settings::mojom::internal::ContentSettingsManager_AllowStorageAccess_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->frame_token)::BaseType> frame_token_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::LocalFrameTokenDataView>(
    param_frame_token,
    frame_token_fragment);

  params->frame_token.Set(
      frame_token_fragment.is_null() ? nullptr : frame_token_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->frame_token.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null frame_token in ContentSettingsManager.AllowStorageAccess request");

  
  mojo::internal::Serialize<::content_settings::mojom::ContentSettingsManager_StorageType>(
    param_storage_type,
    &params->storage_type);
  mojo::internal::MessageFragment<
      typename decltype(params->origin)::BaseType> origin_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
    param_origin,
    origin_fragment);

  params->origin.Set(
      origin_fragment.is_null() ? nullptr : origin_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->origin.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null origin in ContentSettingsManager.AllowStorageAccess request");
  mojo::internal::MessageFragment<
      typename decltype(params->site_for_cookies)::BaseType> site_for_cookies_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::SiteForCookiesDataView>(
    param_site_for_cookies,
    site_for_cookies_fragment);

  params->site_for_cookies.Set(
      site_for_cookies_fragment.is_null() ? nullptr : site_for_cookies_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->site_for_cookies.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null site_for_cookies in ContentSettingsManager.AllowStorageAccess request");
  mojo::internal::MessageFragment<
      typename decltype(params->top_frame_origin)::BaseType> top_frame_origin_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
    param_top_frame_origin,
    top_frame_origin_fragment);

  params->top_frame_origin.Set(
      top_frame_origin_fragment.is_null() ? nullptr : top_frame_origin_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->top_frame_origin.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null top_frame_origin in ContentSettingsManager.AllowStorageAccess request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ContentSettingsManager::Name_);
  message.set_method_name("AllowStorageAccess");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ContentSettingsManager_AllowStorageAccess_HandleSyncResponse(
          &result, out_param_allowed));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "ContentSettingsManager::AllowStorageAccess", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("allowed"), out_param_allowed,
                        "<value of type bool>");
   });
#endif
  return result;
}

void ContentSettingsManagerProxy::AllowStorageAccess(
    const ::blink::LocalFrameToken& in_frame_token, ContentSettingsManager::StorageType in_storage_type, const ::url::Origin& in_origin, const ::net::SiteForCookies& in_site_for_cookies, const ::url::Origin& in_top_frame_origin, AllowStorageAccessCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send content_settings::mojom::ContentSettingsManager::AllowStorageAccess", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_token"), in_frame_token,
                        "<value of type const ::blink::LocalFrameToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("storage_type"), in_storage_type,
                        "<value of type ContentSettingsManager::StorageType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("origin"), in_origin,
                        "<value of type const ::url::Origin&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("site_for_cookies"), in_site_for_cookies,
                        "<value of type const ::net::SiteForCookies&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("top_frame_origin"), in_top_frame_origin,
                        "<value of type const ::url::Origin&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ContentSettingsManager::kAllowStorageAccess), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content_settings::mojom::internal::ContentSettingsManager_AllowStorageAccess_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->frame_token)::BaseType> frame_token_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::LocalFrameTokenDataView>(
    in_frame_token,
    frame_token_fragment);

  params->frame_token.Set(
      frame_token_fragment.is_null() ? nullptr : frame_token_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->frame_token.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null frame_token in ContentSettingsManager.AllowStorageAccess request");

  
  mojo::internal::Serialize<::content_settings::mojom::ContentSettingsManager_StorageType>(
    in_storage_type,
    &params->storage_type);
  mojo::internal::MessageFragment<
      typename decltype(params->origin)::BaseType> origin_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
    in_origin,
    origin_fragment);

  params->origin.Set(
      origin_fragment.is_null() ? nullptr : origin_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->origin.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null origin in ContentSettingsManager.AllowStorageAccess request");
  mojo::internal::MessageFragment<
      typename decltype(params->site_for_cookies)::BaseType> site_for_cookies_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::SiteForCookiesDataView>(
    in_site_for_cookies,
    site_for_cookies_fragment);

  params->site_for_cookies.Set(
      site_for_cookies_fragment.is_null() ? nullptr : site_for_cookies_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->site_for_cookies.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null site_for_cookies in ContentSettingsManager.AllowStorageAccess request");
  mojo::internal::MessageFragment<
      typename decltype(params->top_frame_origin)::BaseType> top_frame_origin_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
    in_top_frame_origin,
    top_frame_origin_fragment);

  params->top_frame_origin.Set(
      top_frame_origin_fragment.is_null() ? nullptr : top_frame_origin_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->top_frame_origin.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null top_frame_origin in ContentSettingsManager.AllowStorageAccess request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ContentSettingsManager::Name_);
  message.set_method_name("AllowStorageAccess");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ContentSettingsManager_AllowStorageAccess_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ContentSettingsManagerProxy::OnContentBlocked(
    const ::blink::LocalFrameToken& in_frame_token, ::content_settings::mojom::ContentSettingsType in_type) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send content_settings::mojom::ContentSettingsManager::OnContentBlocked", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_token"), in_frame_token,
                        "<value of type const ::blink::LocalFrameToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("type"), in_type,
                        "<value of type ::content_settings::mojom::ContentSettingsType>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ContentSettingsManager::kOnContentBlocked), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content_settings::mojom::internal::ContentSettingsManager_OnContentBlocked_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->frame_token)::BaseType> frame_token_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::LocalFrameTokenDataView>(
    in_frame_token,
    frame_token_fragment);

  params->frame_token.Set(
      frame_token_fragment.is_null() ? nullptr : frame_token_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->frame_token.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null frame_token in ContentSettingsManager.OnContentBlocked request");

  
  mojo::internal::Serialize<::content_settings::mojom::ContentSettingsType>(
    in_type,
    &params->type);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ContentSettingsManager::Name_);
  message.set_method_name("OnContentBlocked");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class ContentSettingsManager_AllowStorageAccess_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ContentSettingsManager::AllowStorageAccessCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ContentSettingsManager_AllowStorageAccess_ProxyToResponder> proxy(
        new ContentSettingsManager_AllowStorageAccess_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ContentSettingsManager_AllowStorageAccess_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ContentSettingsManager_AllowStorageAccess_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ContentSettingsManager_AllowStorageAccess_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ContentSettingsManager::AllowStorageAccessCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_allowed);
};

bool ContentSettingsManager_AllowStorageAccess_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ContentSettingsManager_AllowStorageAccess_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ContentSettingsManager_AllowStorageAccess_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ContentSettingsManager.1
  bool success = true;
  bool p_allowed{};
  ContentSettingsManager_AllowStorageAccess_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_allowed = input_data_view.allowed();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ContentSettingsManager::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_allowed));
  }
  return true;
}

void ContentSettingsManager_AllowStorageAccess_ProxyToResponder::Run(
    bool in_allowed) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply content_settings::mojom::ContentSettingsManager::AllowStorageAccess", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("allowed"), in_allowed,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ContentSettingsManager::kAllowStorageAccess), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content_settings::mojom::internal::ContentSettingsManager_AllowStorageAccess_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->allowed = in_allowed;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ContentSettingsManager::Name_);
  message.set_method_name("AllowStorageAccess");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool ContentSettingsManager_AllowStorageAccess_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ContentSettingsManager_AllowStorageAccess_ResponseParams_Data* params =
      reinterpret_cast<internal::ContentSettingsManager_AllowStorageAccess_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for ContentSettingsManager.1
  bool success = true;
  bool p_allowed{};
  ContentSettingsManager_AllowStorageAccess_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_allowed = input_data_view.allowed();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ContentSettingsManager::Name_, 1, true);
    return false;
  }
  *out_allowed_ = std::move(p_allowed);
  *result_ = true;
  return true;
}

// static
bool ContentSettingsManagerStubDispatch::Accept(
    ContentSettingsManager* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ContentSettingsManager>(message->header()->name)) {
    case messages::ContentSettingsManager::kClone: {
      DCHECK(message->is_serialized());
      internal::ContentSettingsManager_Clone_Params_Data* params =
          reinterpret_cast<internal::ContentSettingsManager_Clone_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ContentSettingsManager.0
      bool success = true;
      ::mojo::PendingReceiver<ContentSettingsManager> p_clone{};
      ContentSettingsManager_Clone_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_clone =
            input_data_view.TakeClone<decltype(p_clone)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ContentSettingsManager::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Clone(        
        std::move(p_clone));
      return true;
    }
    case messages::ContentSettingsManager::kAllowStorageAccess: {
      break;
    }
    case messages::ContentSettingsManager::kOnContentBlocked: {
      DCHECK(message->is_serialized());
      internal::ContentSettingsManager_OnContentBlocked_Params_Data* params =
          reinterpret_cast<internal::ContentSettingsManager_OnContentBlocked_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ContentSettingsManager.2
      bool success = true;
      ::blink::LocalFrameToken p_frame_token{};
      ::content_settings::mojom::ContentSettingsType p_type{};
      ContentSettingsManager_OnContentBlocked_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFrameToken(&p_frame_token))
        success = false;
      if (success && !input_data_view.ReadType(&p_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ContentSettingsManager::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnContentBlocked(        
        std::move(p_frame_token), 
        std::move(p_type));
      return true;
    }
  }
  return false;
}

// static
bool ContentSettingsManagerStubDispatch::AcceptWithResponder(
    ContentSettingsManager* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ContentSettingsManager>(message->header()->name)) {
    case messages::ContentSettingsManager::kClone: {
      break;
    }
    case messages::ContentSettingsManager::kAllowStorageAccess: {
      internal::ContentSettingsManager_AllowStorageAccess_Params_Data* params =
          reinterpret_cast<
              internal::ContentSettingsManager_AllowStorageAccess_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ContentSettingsManager.1
      bool success = true;
      ::blink::LocalFrameToken p_frame_token{};
      ContentSettingsManager::StorageType p_storage_type{};
      ::url::Origin p_origin{};
      ::net::SiteForCookies p_site_for_cookies{};
      ::url::Origin p_top_frame_origin{};
      ContentSettingsManager_AllowStorageAccess_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFrameToken(&p_frame_token))
        success = false;
      if (success && !input_data_view.ReadStorageType(&p_storage_type))
        success = false;
      if (success && !input_data_view.ReadOrigin(&p_origin))
        success = false;
      if (success && !input_data_view.ReadSiteForCookies(&p_site_for_cookies))
        success = false;
      if (success && !input_data_view.ReadTopFrameOrigin(&p_top_frame_origin))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ContentSettingsManager::Name_, 1, false);
        return false;
      }
      auto callback =
          ContentSettingsManager_AllowStorageAccess_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AllowStorageAccess(        
        std::move(p_frame_token), 
        std::move(p_storage_type), 
        std::move(p_origin), 
        std::move(p_site_for_cookies), 
        std::move(p_top_frame_origin), std::move(callback));
      return true;
    }
    case messages::ContentSettingsManager::kOnContentBlocked: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kContentSettingsManagerValidationInfo[] = {
    { &internal::ContentSettingsManager_Clone_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ContentSettingsManager_AllowStorageAccess_Params_Data::Validate,
     &internal::ContentSettingsManager_AllowStorageAccess_ResponseParams_Data::Validate},
    { &internal::ContentSettingsManager_OnContentBlocked_Params_Data::Validate,
     nullptr /* no response */},
};

bool ContentSettingsManagerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::content_settings::mojom::ContentSettingsManager::Name_,
    kContentSettingsManagerValidationInfo);
}

bool ContentSettingsManagerResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::content_settings::mojom::ContentSettingsManager::Name_,
    kContentSettingsManagerValidationInfo);
}


}  // content_settings::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace content_settings::mojom {


void ContentSettingsManagerInterceptorForTesting::Clone(::mojo::PendingReceiver<ContentSettingsManager> clone) {
  GetForwardingInterface()->Clone(
    std::move(clone)
    );
}
void ContentSettingsManagerInterceptorForTesting::AllowStorageAccess(const ::blink::LocalFrameToken& frame_token, ContentSettingsManager::StorageType storage_type, const ::url::Origin& origin, const ::net::SiteForCookies& site_for_cookies, const ::url::Origin& top_frame_origin, AllowStorageAccessCallback callback) {
  GetForwardingInterface()->AllowStorageAccess(
    std::move(frame_token)
    , 
    std::move(storage_type)
    , 
    std::move(origin)
    , 
    std::move(site_for_cookies)
    , 
    std::move(top_frame_origin)
    , std::move(callback));
}
void ContentSettingsManagerInterceptorForTesting::OnContentBlocked(const ::blink::LocalFrameToken& frame_token, ::content_settings::mojom::ContentSettingsType type) {
  GetForwardingInterface()->OnContentBlocked(
    std::move(frame_token)
    , 
    std::move(type)
    );
}
ContentSettingsManagerAsyncWaiter::ContentSettingsManagerAsyncWaiter(
    ContentSettingsManager* proxy) : proxy_(proxy) {}

ContentSettingsManagerAsyncWaiter::~ContentSettingsManagerAsyncWaiter() = default;


void ContentSettingsManagerAsyncWaiter::AllowStorageAccess(
    const ::blink::LocalFrameToken& frame_token, ContentSettingsManager::StorageType storage_type, const ::url::Origin& origin, const ::net::SiteForCookies& site_for_cookies, const ::url::Origin& top_frame_origin, bool* out_allowed) {
  base::RunLoop loop;
  proxy_->AllowStorageAccess(
      std::move(frame_token),
      std::move(storage_type),
      std::move(origin),
      std::move(site_for_cookies),
      std::move(top_frame_origin),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_allowed
,
             bool allowed) {*out_allowed = std::move(allowed);
            loop->Quit();
          },
          &loop,
          out_allowed));
  loop.Run();
}

bool ContentSettingsManagerAsyncWaiter::AllowStorageAccess(
    const ::blink::LocalFrameToken& frame_token, ContentSettingsManager::StorageType storage_type, const ::url::Origin& origin, const ::net::SiteForCookies& site_for_cookies, const ::url::Origin& top_frame_origin) {
  bool async_wait_result;
  AllowStorageAccess(std::move(frame_token),std::move(storage_type),std::move(origin),std::move(site_for_cookies),std::move(top_frame_origin),&async_wait_result);
  return async_wait_result;
}






}  // content_settings::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif