// components/content_settings/common/content_settings_manager.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "components/content_settings/common/content_settings_manager.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/content_settings/common/content_settings_manager.mojom-params-data.h"
namespace content_settings {
namespace mojom {

NOINLINE static const char* ContentSettingsManager_StorageTypeToStringHelper(ContentSettingsManager_StorageType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ContentSettingsManager_StorageType::LOCAL_STORAGE:
      return "LOCAL_STORAGE";
    case ContentSettingsManager_StorageType::SESSION_STORAGE:
      return "SESSION_STORAGE";
    case ContentSettingsManager_StorageType::FILE_SYSTEM:
      return "FILE_SYSTEM";
    case ContentSettingsManager_StorageType::INDEXED_DB:
      return "INDEXED_DB";
    case ContentSettingsManager_StorageType::CACHE:
      return "CACHE";
    case ContentSettingsManager_StorageType::WEB_LOCKS:
      return "WEB_LOCKS";
    default:
      return nullptr;
  }
}

std::string ContentSettingsManager_StorageTypeToString(ContentSettingsManager_StorageType value) {
  const char *str = ContentSettingsManager_StorageTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ContentSettingsManager_StorageType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ContentSettingsManager_StorageType value) {
  return os << ContentSettingsManager_StorageTypeToString(value);
}

namespace internal {


// static
bool ContentSettingsManager_Clone_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ContentSettingsManager_Clone_Params_Data* object =
      static_cast<const ContentSettingsManager_Clone_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->clone, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->clone,
                                                 validation_context)) {
    return false;
  }

  return true;
}

ContentSettingsManager_Clone_Params_Data::ContentSettingsManager_Clone_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ContentSettingsManager_AllowStorageAccess_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ContentSettingsManager_AllowStorageAccess_Params_Data* object =
      static_cast<const ContentSettingsManager_AllowStorageAccess_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->frame_token, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->frame_token, validation_context))
    return false;


  if (!::content_settings::mojom::internal::ContentSettingsManager_StorageType_Data
        ::Validate(object->storage_type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->origin, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->origin, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->site_for_cookies, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->site_for_cookies, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->top_frame_origin, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->top_frame_origin, validation_context))
    return false;

  return true;
}

ContentSettingsManager_AllowStorageAccess_Params_Data::ContentSettingsManager_AllowStorageAccess_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ContentSettingsManager_AllowStorageAccess_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ContentSettingsManager_AllowStorageAccess_ResponseParams_Data* object =
      static_cast<const ContentSettingsManager_AllowStorageAccess_ResponseParams_Data*>(data);

  return true;
}

ContentSettingsManager_AllowStorageAccess_ResponseParams_Data::ContentSettingsManager_AllowStorageAccess_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ContentSettingsManager_OnContentBlocked_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ContentSettingsManager_OnContentBlocked_Params_Data* object =
      static_cast<const ContentSettingsManager_OnContentBlocked_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->frame_token, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->frame_token, validation_context))
    return false;


  if (!::content_settings::mojom::internal::ContentSettingsType_Data
        ::Validate(object->type, validation_context))
    return false;

  return true;
}

ContentSettingsManager_OnContentBlocked_Params_Data::ContentSettingsManager_OnContentBlocked_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace content_settings

namespace perfetto {

// static
void TraceFormatTraits<::content_settings::mojom::ContentSettingsManager_StorageType>::WriteIntoTrace(
   perfetto::TracedValue context, ::content_settings::mojom::ContentSettingsManager_StorageType value) {
  return std::move(context).WriteString(::content_settings::mojom::ContentSettingsManager_StorageTypeToString(value));
}

} // namespace perfetto