// components/commerce/core/mojom/product_specifications.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/commerce/core/mojom/product_specifications.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/commerce/core/mojom/product_specifications.mojom-params-data.h"
#include "components/commerce/core/mojom/product_specifications.mojom-shared-message-ids.h"

#include "components/commerce/core/mojom/product_specifications.mojom-import-headers.h"
#include "components/commerce/core/mojom/product_specifications.mojom-test-utils.h"


namespace commerce::product_specifications::mojom {
// The declaration includes the definition on other builds.

ProductSpecificationsHandler::IPCStableHashFunction ProductSpecificationsHandler::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ProductSpecificationsHandler>(message.name())) {
    case messages::ProductSpecificationsHandler::kSetAcceptedDisclosureVersion: {
      return &ProductSpecificationsHandler::SetAcceptedDisclosureVersion_Sym::IPCStableHash;
    }
    case messages::ProductSpecificationsHandler::kMaybeShowDisclosure: {
      return &ProductSpecificationsHandler::MaybeShowDisclosure_Sym::IPCStableHash;
    }
    case messages::ProductSpecificationsHandler::kDeclineDisclosure: {
      return &ProductSpecificationsHandler::DeclineDisclosure_Sym::IPCStableHash;
    }
    case messages::ProductSpecificationsHandler::kShowSyncSetupFlow: {
      return &ProductSpecificationsHandler::ShowSyncSetupFlow_Sym::IPCStableHash;
    }
    case messages::ProductSpecificationsHandler::kGetPageTitleFromHistory: {
      return &ProductSpecificationsHandler::GetPageTitleFromHistory_Sym::IPCStableHash;
    }
    case messages::ProductSpecificationsHandler::kShowProductSpecificationsSetForUuid: {
      return &ProductSpecificationsHandler::ShowProductSpecificationsSetForUuid_Sym::IPCStableHash;
    }
    case messages::ProductSpecificationsHandler::kShowProductSpecificationsSetsForUuids: {
      return &ProductSpecificationsHandler::ShowProductSpecificationsSetsForUuids_Sym::IPCStableHash;
    }
    case messages::ProductSpecificationsHandler::kShowComparePage: {
      return &ProductSpecificationsHandler::ShowComparePage_Sym::IPCStableHash;
    }
    case messages::ProductSpecificationsHandler::kGetComparisonTableUrlForUuid: {
      return &ProductSpecificationsHandler::GetComparisonTableUrlForUuid_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ProductSpecificationsHandler::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ProductSpecificationsHandler>(message.name())) {
      case messages::ProductSpecificationsHandler::kSetAcceptedDisclosureVersion:
            return "Receive commerce::product_specifications::mojom::ProductSpecificationsHandler::SetAcceptedDisclosureVersion";
      case messages::ProductSpecificationsHandler::kMaybeShowDisclosure:
            return "Receive commerce::product_specifications::mojom::ProductSpecificationsHandler::MaybeShowDisclosure";
      case messages::ProductSpecificationsHandler::kDeclineDisclosure:
            return "Receive commerce::product_specifications::mojom::ProductSpecificationsHandler::DeclineDisclosure";
      case messages::ProductSpecificationsHandler::kShowSyncSetupFlow:
            return "Receive commerce::product_specifications::mojom::ProductSpecificationsHandler::ShowSyncSetupFlow";
      case messages::ProductSpecificationsHandler::kGetPageTitleFromHistory:
            return "Receive commerce::product_specifications::mojom::ProductSpecificationsHandler::GetPageTitleFromHistory";
      case messages::ProductSpecificationsHandler::kShowProductSpecificationsSetForUuid:
            return "Receive commerce::product_specifications::mojom::ProductSpecificationsHandler::ShowProductSpecificationsSetForUuid";
      case messages::ProductSpecificationsHandler::kShowProductSpecificationsSetsForUuids:
            return "Receive commerce::product_specifications::mojom::ProductSpecificationsHandler::ShowProductSpecificationsSetsForUuids";
      case messages::ProductSpecificationsHandler::kShowComparePage:
            return "Receive commerce::product_specifications::mojom::ProductSpecificationsHandler::ShowComparePage";
      case messages::ProductSpecificationsHandler::kGetComparisonTableUrlForUuid:
            return "Receive commerce::product_specifications::mojom::ProductSpecificationsHandler::GetComparisonTableUrlForUuid";
    }
  } else {
    switch (static_cast<messages::ProductSpecificationsHandler>(message.name())) {
      case messages::ProductSpecificationsHandler::kSetAcceptedDisclosureVersion:
            return "Receive reply commerce::product_specifications::mojom::ProductSpecificationsHandler::SetAcceptedDisclosureVersion";
      case messages::ProductSpecificationsHandler::kMaybeShowDisclosure:
            return "Receive reply commerce::product_specifications::mojom::ProductSpecificationsHandler::MaybeShowDisclosure";
      case messages::ProductSpecificationsHandler::kDeclineDisclosure:
            return "Receive reply commerce::product_specifications::mojom::ProductSpecificationsHandler::DeclineDisclosure";
      case messages::ProductSpecificationsHandler::kShowSyncSetupFlow:
            return "Receive reply commerce::product_specifications::mojom::ProductSpecificationsHandler::ShowSyncSetupFlow";
      case messages::ProductSpecificationsHandler::kGetPageTitleFromHistory:
            return "Receive reply commerce::product_specifications::mojom::ProductSpecificationsHandler::GetPageTitleFromHistory";
      case messages::ProductSpecificationsHandler::kShowProductSpecificationsSetForUuid:
            return "Receive reply commerce::product_specifications::mojom::ProductSpecificationsHandler::ShowProductSpecificationsSetForUuid";
      case messages::ProductSpecificationsHandler::kShowProductSpecificationsSetsForUuids:
            return "Receive reply commerce::product_specifications::mojom::ProductSpecificationsHandler::ShowProductSpecificationsSetsForUuids";
      case messages::ProductSpecificationsHandler::kShowComparePage:
            return "Receive reply commerce::product_specifications::mojom::ProductSpecificationsHandler::ShowComparePage";
      case messages::ProductSpecificationsHandler::kGetComparisonTableUrlForUuid:
            return "Receive reply commerce::product_specifications::mojom::ProductSpecificationsHandler::GetComparisonTableUrlForUuid";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ProductSpecificationsHandler::SetAcceptedDisclosureVersion_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0ceffc2b;  // IPCStableHash for commerce::product_specifications::mojom::ProductSpecificationsHandler::SetAcceptedDisclosureVersion
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ProductSpecificationsHandler::MaybeShowDisclosure_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x03663584;  // IPCStableHash for commerce::product_specifications::mojom::ProductSpecificationsHandler::MaybeShowDisclosure
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ProductSpecificationsHandler::DeclineDisclosure_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5abb6f33;  // IPCStableHash for commerce::product_specifications::mojom::ProductSpecificationsHandler::DeclineDisclosure
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ProductSpecificationsHandler::ShowSyncSetupFlow_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x34817720;  // IPCStableHash for commerce::product_specifications::mojom::ProductSpecificationsHandler::ShowSyncSetupFlow
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ProductSpecificationsHandler::GetPageTitleFromHistory_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xae411c93;  // IPCStableHash for commerce::product_specifications::mojom::ProductSpecificationsHandler::GetPageTitleFromHistory
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ProductSpecificationsHandler::ShowProductSpecificationsSetForUuid_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x02bade51;  // IPCStableHash for commerce::product_specifications::mojom::ProductSpecificationsHandler::ShowProductSpecificationsSetForUuid
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ProductSpecificationsHandler::ShowProductSpecificationsSetsForUuids_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x23df421c;  // IPCStableHash for commerce::product_specifications::mojom::ProductSpecificationsHandler::ShowProductSpecificationsSetsForUuids
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ProductSpecificationsHandler::ShowComparePage_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc404b774;  // IPCStableHash for commerce::product_specifications::mojom::ProductSpecificationsHandler::ShowComparePage
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ProductSpecificationsHandler::GetComparisonTableUrlForUuid_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5349395f;  // IPCStableHash for commerce::product_specifications::mojom::ProductSpecificationsHandler::GetComparisonTableUrlForUuid
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class ProductSpecificationsHandler_MaybeShowDisclosure_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ProductSpecificationsHandler_MaybeShowDisclosure_ForwardToCallback(
      ProductSpecificationsHandler::MaybeShowDisclosureCallback callback
      ) : callback_(std::move(callback)) {
  }

  ProductSpecificationsHandler_MaybeShowDisclosure_ForwardToCallback(const ProductSpecificationsHandler_MaybeShowDisclosure_ForwardToCallback&) = delete;
  ProductSpecificationsHandler_MaybeShowDisclosure_ForwardToCallback& operator=(const ProductSpecificationsHandler_MaybeShowDisclosure_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ProductSpecificationsHandler::MaybeShowDisclosureCallback callback_;
};

class ProductSpecificationsHandler_GetPageTitleFromHistory_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ProductSpecificationsHandler_GetPageTitleFromHistory_ForwardToCallback(
      ProductSpecificationsHandler::GetPageTitleFromHistoryCallback callback
      ) : callback_(std::move(callback)) {
  }

  ProductSpecificationsHandler_GetPageTitleFromHistory_ForwardToCallback(const ProductSpecificationsHandler_GetPageTitleFromHistory_ForwardToCallback&) = delete;
  ProductSpecificationsHandler_GetPageTitleFromHistory_ForwardToCallback& operator=(const ProductSpecificationsHandler_GetPageTitleFromHistory_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ProductSpecificationsHandler::GetPageTitleFromHistoryCallback callback_;
};

class ProductSpecificationsHandler_GetComparisonTableUrlForUuid_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ProductSpecificationsHandler_GetComparisonTableUrlForUuid_ForwardToCallback(
      ProductSpecificationsHandler::GetComparisonTableUrlForUuidCallback callback
      ) : callback_(std::move(callback)) {
  }

  ProductSpecificationsHandler_GetComparisonTableUrlForUuid_ForwardToCallback(const ProductSpecificationsHandler_GetComparisonTableUrlForUuid_ForwardToCallback&) = delete;
  ProductSpecificationsHandler_GetComparisonTableUrlForUuid_ForwardToCallback& operator=(const ProductSpecificationsHandler_GetComparisonTableUrlForUuid_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ProductSpecificationsHandler::GetComparisonTableUrlForUuidCallback callback_;
};

ProductSpecificationsHandlerProxy::ProductSpecificationsHandlerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ProductSpecificationsHandlerProxy::SetAcceptedDisclosureVersion(
    DisclosureVersion in_version) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send commerce::product_specifications::mojom::ProductSpecificationsHandler::SetAcceptedDisclosureVersion", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("version"), in_version,
                        "<value of type DisclosureVersion>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ProductSpecificationsHandler::kSetAcceptedDisclosureVersion), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::commerce::product_specifications::mojom::internal::ProductSpecificationsHandler_SetAcceptedDisclosureVersion_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::commerce::product_specifications::mojom::DisclosureVersion>(
    in_version,
    &params->version);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProductSpecificationsHandler::Name_);
  message.set_method_name("SetAcceptedDisclosureVersion");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ProductSpecificationsHandlerProxy::MaybeShowDisclosure(
    const std::vector<::GURL>& in_urls, const std::string& in_name, const std::string& in_set_id, MaybeShowDisclosureCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send commerce::product_specifications::mojom::ProductSpecificationsHandler::MaybeShowDisclosure", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("urls"), in_urls,
                        "<value of type const std::vector<::GURL>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("name"), in_name,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("set_id"), in_set_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ProductSpecificationsHandler::kMaybeShowDisclosure), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::commerce::product_specifications::mojom::internal::ProductSpecificationsHandler_MaybeShowDisclosure_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->urls)::BaseType>
      urls_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& urls_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::url::mojom::UrlDataView>>(
    in_urls,
    urls_fragment,
    &urls_validate_params);

  params->urls.Set(
      urls_fragment.is_null() ? nullptr : urls_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->urls.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null urls in ProductSpecificationsHandler.MaybeShowDisclosure request");
  mojo::internal::MessageFragment<
      typename decltype(params->name)::BaseType> name_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_name,
    name_fragment);

  params->name.Set(
      name_fragment.is_null() ? nullptr : name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null name in ProductSpecificationsHandler.MaybeShowDisclosure request");
  mojo::internal::MessageFragment<
      typename decltype(params->set_id)::BaseType> set_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_set_id,
    set_id_fragment);

  params->set_id.Set(
      set_id_fragment.is_null() ? nullptr : set_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->set_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null set_id in ProductSpecificationsHandler.MaybeShowDisclosure request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProductSpecificationsHandler::Name_);
  message.set_method_name("MaybeShowDisclosure");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ProductSpecificationsHandler_MaybeShowDisclosure_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ProductSpecificationsHandlerProxy::DeclineDisclosure(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send commerce::product_specifications::mojom::ProductSpecificationsHandler::DeclineDisclosure");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ProductSpecificationsHandler::kDeclineDisclosure), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::commerce::product_specifications::mojom::internal::ProductSpecificationsHandler_DeclineDisclosure_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProductSpecificationsHandler::Name_);
  message.set_method_name("DeclineDisclosure");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ProductSpecificationsHandlerProxy::ShowSyncSetupFlow(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send commerce::product_specifications::mojom::ProductSpecificationsHandler::ShowSyncSetupFlow");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ProductSpecificationsHandler::kShowSyncSetupFlow), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::commerce::product_specifications::mojom::internal::ProductSpecificationsHandler_ShowSyncSetupFlow_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProductSpecificationsHandler::Name_);
  message.set_method_name("ShowSyncSetupFlow");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ProductSpecificationsHandlerProxy::GetPageTitleFromHistory(
    const ::GURL& in_url, GetPageTitleFromHistoryCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send commerce::product_specifications::mojom::ProductSpecificationsHandler::GetPageTitleFromHistory", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ProductSpecificationsHandler::kGetPageTitleFromHistory), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::commerce::product_specifications::mojom::internal::ProductSpecificationsHandler_GetPageTitleFromHistory_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in ProductSpecificationsHandler.GetPageTitleFromHistory request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProductSpecificationsHandler::Name_);
  message.set_method_name("GetPageTitleFromHistory");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ProductSpecificationsHandler_GetPageTitleFromHistory_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ProductSpecificationsHandlerProxy::ShowProductSpecificationsSetForUuid(
    const ::base::Uuid& in_uuid, bool in_in_new_tab) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send commerce::product_specifications::mojom::ProductSpecificationsHandler::ShowProductSpecificationsSetForUuid", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("uuid"), in_uuid,
                        "<value of type const ::base::Uuid&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("in_new_tab"), in_in_new_tab,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ProductSpecificationsHandler::kShowProductSpecificationsSetForUuid), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::commerce::product_specifications::mojom::internal::ProductSpecificationsHandler_ShowProductSpecificationsSetForUuid_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->uuid)::BaseType> uuid_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UuidDataView>(
    in_uuid,
    uuid_fragment);

  params->uuid.Set(
      uuid_fragment.is_null() ? nullptr : uuid_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->uuid.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null uuid in ProductSpecificationsHandler.ShowProductSpecificationsSetForUuid request");

  params->in_new_tab = in_in_new_tab;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProductSpecificationsHandler::Name_);
  message.set_method_name("ShowProductSpecificationsSetForUuid");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ProductSpecificationsHandlerProxy::ShowProductSpecificationsSetsForUuids(
    const std::vector<::base::Uuid>& in_uuids, ShowSetDisposition in_disposition) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send commerce::product_specifications::mojom::ProductSpecificationsHandler::ShowProductSpecificationsSetsForUuids", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("uuids"), in_uuids,
                        "<value of type const std::vector<::base::Uuid>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("disposition"), in_disposition,
                        "<value of type ShowSetDisposition>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ProductSpecificationsHandler::kShowProductSpecificationsSetsForUuids), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::commerce::product_specifications::mojom::internal::ProductSpecificationsHandler_ShowProductSpecificationsSetsForUuids_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->uuids)::BaseType>
      uuids_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& uuids_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::mojo_base::mojom::UuidDataView>>(
    in_uuids,
    uuids_fragment,
    &uuids_validate_params);

  params->uuids.Set(
      uuids_fragment.is_null() ? nullptr : uuids_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->uuids.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null uuids in ProductSpecificationsHandler.ShowProductSpecificationsSetsForUuids request");

  
  mojo::internal::Serialize<::commerce::product_specifications::mojom::ShowSetDisposition>(
    in_disposition,
    &params->disposition);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProductSpecificationsHandler::Name_);
  message.set_method_name("ShowProductSpecificationsSetsForUuids");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ProductSpecificationsHandlerProxy::ShowComparePage(
    bool in_in_new_tab) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send commerce::product_specifications::mojom::ProductSpecificationsHandler::ShowComparePage", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("in_new_tab"), in_in_new_tab,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ProductSpecificationsHandler::kShowComparePage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::commerce::product_specifications::mojom::internal::ProductSpecificationsHandler_ShowComparePage_Params_Data> params(
          message);
  params.Allocate();

  params->in_new_tab = in_in_new_tab;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProductSpecificationsHandler::Name_);
  message.set_method_name("ShowComparePage");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ProductSpecificationsHandlerProxy::GetComparisonTableUrlForUuid(
    const ::base::Uuid& in_uuid, GetComparisonTableUrlForUuidCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send commerce::product_specifications::mojom::ProductSpecificationsHandler::GetComparisonTableUrlForUuid", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("uuid"), in_uuid,
                        "<value of type const ::base::Uuid&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ProductSpecificationsHandler::kGetComparisonTableUrlForUuid), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::commerce::product_specifications::mojom::internal::ProductSpecificationsHandler_GetComparisonTableUrlForUuid_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->uuid)::BaseType> uuid_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UuidDataView>(
    in_uuid,
    uuid_fragment);

  params->uuid.Set(
      uuid_fragment.is_null() ? nullptr : uuid_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->uuid.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null uuid in ProductSpecificationsHandler.GetComparisonTableUrlForUuid request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProductSpecificationsHandler::Name_);
  message.set_method_name("GetComparisonTableUrlForUuid");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ProductSpecificationsHandler_GetComparisonTableUrlForUuid_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class ProductSpecificationsHandler_MaybeShowDisclosure_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ProductSpecificationsHandler::MaybeShowDisclosureCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ProductSpecificationsHandler_MaybeShowDisclosure_ProxyToResponder> proxy(
        new ProductSpecificationsHandler_MaybeShowDisclosure_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ProductSpecificationsHandler_MaybeShowDisclosure_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ProductSpecificationsHandler_MaybeShowDisclosure_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ProductSpecificationsHandler_MaybeShowDisclosure_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ProductSpecificationsHandler::MaybeShowDisclosureCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_disclosure_shown);
};

bool ProductSpecificationsHandler_MaybeShowDisclosure_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ProductSpecificationsHandler_MaybeShowDisclosure_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ProductSpecificationsHandler_MaybeShowDisclosure_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ProductSpecificationsHandler.1
  bool success = true;
  bool p_disclosure_shown{};
  ProductSpecificationsHandler_MaybeShowDisclosure_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_disclosure_shown = input_data_view.disclosure_shown();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ProductSpecificationsHandler::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_disclosure_shown));
  }
  return true;
}

void ProductSpecificationsHandler_MaybeShowDisclosure_ProxyToResponder::Run(
    bool in_disclosure_shown) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply commerce::product_specifications::mojom::ProductSpecificationsHandler::MaybeShowDisclosure", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("disclosure_shown"), in_disclosure_shown,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ProductSpecificationsHandler::kMaybeShowDisclosure), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::commerce::product_specifications::mojom::internal::ProductSpecificationsHandler_MaybeShowDisclosure_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->disclosure_shown = in_disclosure_shown;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProductSpecificationsHandler::Name_);
  message.set_method_name("MaybeShowDisclosure");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ProductSpecificationsHandler_GetPageTitleFromHistory_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ProductSpecificationsHandler::GetPageTitleFromHistoryCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ProductSpecificationsHandler_GetPageTitleFromHistory_ProxyToResponder> proxy(
        new ProductSpecificationsHandler_GetPageTitleFromHistory_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ProductSpecificationsHandler_GetPageTitleFromHistory_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ProductSpecificationsHandler_GetPageTitleFromHistory_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ProductSpecificationsHandler_GetPageTitleFromHistory_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ProductSpecificationsHandler::GetPageTitleFromHistoryCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::string& in_title);
};

bool ProductSpecificationsHandler_GetPageTitleFromHistory_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ProductSpecificationsHandler_GetPageTitleFromHistory_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ProductSpecificationsHandler_GetPageTitleFromHistory_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ProductSpecificationsHandler.4
  bool success = true;
  std::string p_title{};
  ProductSpecificationsHandler_GetPageTitleFromHistory_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadTitle(&p_title))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ProductSpecificationsHandler::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_title));
  }
  return true;
}

void ProductSpecificationsHandler_GetPageTitleFromHistory_ProxyToResponder::Run(
    const std::string& in_title) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply commerce::product_specifications::mojom::ProductSpecificationsHandler::GetPageTitleFromHistory", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("title"), in_title,
                        "<value of type const std::string&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ProductSpecificationsHandler::kGetPageTitleFromHistory), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::commerce::product_specifications::mojom::internal::ProductSpecificationsHandler_GetPageTitleFromHistory_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->title)::BaseType> title_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_title,
    title_fragment);

  params->title.Set(
      title_fragment.is_null() ? nullptr : title_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->title.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null title in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProductSpecificationsHandler::Name_);
  message.set_method_name("GetPageTitleFromHistory");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ProductSpecificationsHandler_GetComparisonTableUrlForUuid_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ProductSpecificationsHandler::GetComparisonTableUrlForUuidCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ProductSpecificationsHandler_GetComparisonTableUrlForUuid_ProxyToResponder> proxy(
        new ProductSpecificationsHandler_GetComparisonTableUrlForUuid_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ProductSpecificationsHandler_GetComparisonTableUrlForUuid_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ProductSpecificationsHandler_GetComparisonTableUrlForUuid_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ProductSpecificationsHandler_GetComparisonTableUrlForUuid_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ProductSpecificationsHandler::GetComparisonTableUrlForUuidCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::GURL& in_url);
};

bool ProductSpecificationsHandler_GetComparisonTableUrlForUuid_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ProductSpecificationsHandler_GetComparisonTableUrlForUuid_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ProductSpecificationsHandler_GetComparisonTableUrlForUuid_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ProductSpecificationsHandler.8
  bool success = true;
  ::GURL p_url{};
  ProductSpecificationsHandler_GetComparisonTableUrlForUuid_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadUrl(&p_url))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ProductSpecificationsHandler::Name_, 8, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_url));
  }
  return true;
}

void ProductSpecificationsHandler_GetComparisonTableUrlForUuid_ProxyToResponder::Run(
    const ::GURL& in_url) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply commerce::product_specifications::mojom::ProductSpecificationsHandler::GetComparisonTableUrlForUuid", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ProductSpecificationsHandler::kGetComparisonTableUrlForUuid), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::commerce::product_specifications::mojom::internal::ProductSpecificationsHandler_GetComparisonTableUrlForUuid_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProductSpecificationsHandler::Name_);
  message.set_method_name("GetComparisonTableUrlForUuid");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool ProductSpecificationsHandlerStubDispatch::Accept(
    ProductSpecificationsHandler* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ProductSpecificationsHandler>(message->header()->name)) {
    case messages::ProductSpecificationsHandler::kSetAcceptedDisclosureVersion: {
      DCHECK(message->is_serialized());
      internal::ProductSpecificationsHandler_SetAcceptedDisclosureVersion_Params_Data* params =
          reinterpret_cast<internal::ProductSpecificationsHandler_SetAcceptedDisclosureVersion_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ProductSpecificationsHandler.0
      bool success = true;
      DisclosureVersion p_version{};
      ProductSpecificationsHandler_SetAcceptedDisclosureVersion_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadVersion(&p_version))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ProductSpecificationsHandler::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetAcceptedDisclosureVersion(        
        std::move(p_version));
      return true;
    }
    case messages::ProductSpecificationsHandler::kMaybeShowDisclosure: {
      break;
    }
    case messages::ProductSpecificationsHandler::kDeclineDisclosure: {
      DCHECK(message->is_serialized());
      internal::ProductSpecificationsHandler_DeclineDisclosure_Params_Data* params =
          reinterpret_cast<internal::ProductSpecificationsHandler_DeclineDisclosure_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ProductSpecificationsHandler.2
      bool success = true;
      ProductSpecificationsHandler_DeclineDisclosure_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ProductSpecificationsHandler::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DeclineDisclosure(        );
      return true;
    }
    case messages::ProductSpecificationsHandler::kShowSyncSetupFlow: {
      DCHECK(message->is_serialized());
      internal::ProductSpecificationsHandler_ShowSyncSetupFlow_Params_Data* params =
          reinterpret_cast<internal::ProductSpecificationsHandler_ShowSyncSetupFlow_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ProductSpecificationsHandler.3
      bool success = true;
      ProductSpecificationsHandler_ShowSyncSetupFlow_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ProductSpecificationsHandler::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ShowSyncSetupFlow(        );
      return true;
    }
    case messages::ProductSpecificationsHandler::kGetPageTitleFromHistory: {
      break;
    }
    case messages::ProductSpecificationsHandler::kShowProductSpecificationsSetForUuid: {
      DCHECK(message->is_serialized());
      internal::ProductSpecificationsHandler_ShowProductSpecificationsSetForUuid_Params_Data* params =
          reinterpret_cast<internal::ProductSpecificationsHandler_ShowProductSpecificationsSetForUuid_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ProductSpecificationsHandler.5
      bool success = true;
      ::base::Uuid p_uuid{};
      bool p_in_new_tab{};
      ProductSpecificationsHandler_ShowProductSpecificationsSetForUuid_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUuid(&p_uuid))
        success = false;
      if (success)
        p_in_new_tab = input_data_view.in_new_tab();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ProductSpecificationsHandler::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ShowProductSpecificationsSetForUuid(        
        std::move(p_uuid), 
        std::move(p_in_new_tab));
      return true;
    }
    case messages::ProductSpecificationsHandler::kShowProductSpecificationsSetsForUuids: {
      DCHECK(message->is_serialized());
      internal::ProductSpecificationsHandler_ShowProductSpecificationsSetsForUuids_Params_Data* params =
          reinterpret_cast<internal::ProductSpecificationsHandler_ShowProductSpecificationsSetsForUuids_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ProductSpecificationsHandler.6
      bool success = true;
      std::vector<::base::Uuid> p_uuids{};
      ShowSetDisposition p_disposition{};
      ProductSpecificationsHandler_ShowProductSpecificationsSetsForUuids_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUuids(&p_uuids))
        success = false;
      if (success && !input_data_view.ReadDisposition(&p_disposition))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ProductSpecificationsHandler::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ShowProductSpecificationsSetsForUuids(        
        std::move(p_uuids), 
        std::move(p_disposition));
      return true;
    }
    case messages::ProductSpecificationsHandler::kShowComparePage: {
      DCHECK(message->is_serialized());
      internal::ProductSpecificationsHandler_ShowComparePage_Params_Data* params =
          reinterpret_cast<internal::ProductSpecificationsHandler_ShowComparePage_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ProductSpecificationsHandler.7
      bool success = true;
      bool p_in_new_tab{};
      ProductSpecificationsHandler_ShowComparePage_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_in_new_tab = input_data_view.in_new_tab();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ProductSpecificationsHandler::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ShowComparePage(        
        std::move(p_in_new_tab));
      return true;
    }
    case messages::ProductSpecificationsHandler::kGetComparisonTableUrlForUuid: {
      break;
    }
  }
  return false;
}

// static
bool ProductSpecificationsHandlerStubDispatch::AcceptWithResponder(
    ProductSpecificationsHandler* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ProductSpecificationsHandler>(message->header()->name)) {
    case messages::ProductSpecificationsHandler::kSetAcceptedDisclosureVersion: {
      break;
    }
    case messages::ProductSpecificationsHandler::kMaybeShowDisclosure: {
      internal::ProductSpecificationsHandler_MaybeShowDisclosure_Params_Data* params =
          reinterpret_cast<
              internal::ProductSpecificationsHandler_MaybeShowDisclosure_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ProductSpecificationsHandler.1
      bool success = true;
      std::vector<::GURL> p_urls{};
      std::string p_name{};
      std::string p_set_id{};
      ProductSpecificationsHandler_MaybeShowDisclosure_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrls(&p_urls))
        success = false;
      if (success && !input_data_view.ReadName(&p_name))
        success = false;
      if (success && !input_data_view.ReadSetId(&p_set_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ProductSpecificationsHandler::Name_, 1, false);
        return false;
      }
      auto callback =
          ProductSpecificationsHandler_MaybeShowDisclosure_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->MaybeShowDisclosure(        
        std::move(p_urls), 
        std::move(p_name), 
        std::move(p_set_id), std::move(callback));
      return true;
    }
    case messages::ProductSpecificationsHandler::kDeclineDisclosure: {
      break;
    }
    case messages::ProductSpecificationsHandler::kShowSyncSetupFlow: {
      break;
    }
    case messages::ProductSpecificationsHandler::kGetPageTitleFromHistory: {
      internal::ProductSpecificationsHandler_GetPageTitleFromHistory_Params_Data* params =
          reinterpret_cast<
              internal::ProductSpecificationsHandler_GetPageTitleFromHistory_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ProductSpecificationsHandler.4
      bool success = true;
      ::GURL p_url{};
      ProductSpecificationsHandler_GetPageTitleFromHistory_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ProductSpecificationsHandler::Name_, 4, false);
        return false;
      }
      auto callback =
          ProductSpecificationsHandler_GetPageTitleFromHistory_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetPageTitleFromHistory(        
        std::move(p_url), std::move(callback));
      return true;
    }
    case messages::ProductSpecificationsHandler::kShowProductSpecificationsSetForUuid: {
      break;
    }
    case messages::ProductSpecificationsHandler::kShowProductSpecificationsSetsForUuids: {
      break;
    }
    case messages::ProductSpecificationsHandler::kShowComparePage: {
      break;
    }
    case messages::ProductSpecificationsHandler::kGetComparisonTableUrlForUuid: {
      internal::ProductSpecificationsHandler_GetComparisonTableUrlForUuid_Params_Data* params =
          reinterpret_cast<
              internal::ProductSpecificationsHandler_GetComparisonTableUrlForUuid_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ProductSpecificationsHandler.8
      bool success = true;
      ::base::Uuid p_uuid{};
      ProductSpecificationsHandler_GetComparisonTableUrlForUuid_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUuid(&p_uuid))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ProductSpecificationsHandler::Name_, 8, false);
        return false;
      }
      auto callback =
          ProductSpecificationsHandler_GetComparisonTableUrlForUuid_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetComparisonTableUrlForUuid(        
        std::move(p_uuid), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kProductSpecificationsHandlerValidationInfo[] = {
    { &internal::ProductSpecificationsHandler_SetAcceptedDisclosureVersion_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ProductSpecificationsHandler_MaybeShowDisclosure_Params_Data::Validate,
     &internal::ProductSpecificationsHandler_MaybeShowDisclosure_ResponseParams_Data::Validate},
    { &internal::ProductSpecificationsHandler_DeclineDisclosure_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ProductSpecificationsHandler_ShowSyncSetupFlow_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ProductSpecificationsHandler_GetPageTitleFromHistory_Params_Data::Validate,
     &internal::ProductSpecificationsHandler_GetPageTitleFromHistory_ResponseParams_Data::Validate},
    { &internal::ProductSpecificationsHandler_ShowProductSpecificationsSetForUuid_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ProductSpecificationsHandler_ShowProductSpecificationsSetsForUuids_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ProductSpecificationsHandler_ShowComparePage_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ProductSpecificationsHandler_GetComparisonTableUrlForUuid_Params_Data::Validate,
     &internal::ProductSpecificationsHandler_GetComparisonTableUrlForUuid_ResponseParams_Data::Validate},
};

bool ProductSpecificationsHandlerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::commerce::product_specifications::mojom::ProductSpecificationsHandler::Name_,
    kProductSpecificationsHandlerValidationInfo);
}

bool ProductSpecificationsHandlerResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::commerce::product_specifications::mojom::ProductSpecificationsHandler::Name_,
    kProductSpecificationsHandlerValidationInfo);
}
// The declaration includes the definition on other builds.

Page::IPCStableHashFunction Page::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::Page>(message.name())) {
    case messages::Page::kOnProductSpecificationsSetAdded: {
      return &Page::OnProductSpecificationsSetAdded_Sym::IPCStableHash;
    }
    case messages::Page::kOnProductSpecificationsSetUpdated: {
      return &Page::OnProductSpecificationsSetUpdated_Sym::IPCStableHash;
    }
    case messages::Page::kOnProductSpecificationsSetRemoved: {
      return &Page::OnProductSpecificationsSetRemoved_Sym::IPCStableHash;
    }
    case messages::Page::kOnSyncStateChanged: {
      return &Page::OnSyncStateChanged_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* Page::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::Page>(message.name())) {
      case messages::Page::kOnProductSpecificationsSetAdded:
            return "Receive commerce::product_specifications::mojom::Page::OnProductSpecificationsSetAdded";
      case messages::Page::kOnProductSpecificationsSetUpdated:
            return "Receive commerce::product_specifications::mojom::Page::OnProductSpecificationsSetUpdated";
      case messages::Page::kOnProductSpecificationsSetRemoved:
            return "Receive commerce::product_specifications::mojom::Page::OnProductSpecificationsSetRemoved";
      case messages::Page::kOnSyncStateChanged:
            return "Receive commerce::product_specifications::mojom::Page::OnSyncStateChanged";
    }
  } else {
    switch (static_cast<messages::Page>(message.name())) {
      case messages::Page::kOnProductSpecificationsSetAdded:
            return "Receive reply commerce::product_specifications::mojom::Page::OnProductSpecificationsSetAdded";
      case messages::Page::kOnProductSpecificationsSetUpdated:
            return "Receive reply commerce::product_specifications::mojom::Page::OnProductSpecificationsSetUpdated";
      case messages::Page::kOnProductSpecificationsSetRemoved:
            return "Receive reply commerce::product_specifications::mojom::Page::OnProductSpecificationsSetRemoved";
      case messages::Page::kOnSyncStateChanged:
            return "Receive reply commerce::product_specifications::mojom::Page::OnSyncStateChanged";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t Page::OnProductSpecificationsSetAdded_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe8a169a8;  // IPCStableHash for commerce::product_specifications::mojom::Page::OnProductSpecificationsSetAdded
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Page::OnProductSpecificationsSetUpdated_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x81404259;  // IPCStableHash for commerce::product_specifications::mojom::Page::OnProductSpecificationsSetUpdated
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Page::OnProductSpecificationsSetRemoved_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe54d0b4b;  // IPCStableHash for commerce::product_specifications::mojom::Page::OnProductSpecificationsSetRemoved
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Page::OnSyncStateChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb21102cf;  // IPCStableHash for commerce::product_specifications::mojom::Page::OnSyncStateChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

PageProxy::PageProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PageProxy::OnProductSpecificationsSetAdded(
    ::commerce::shared::mojom::ProductSpecificationsSetPtr in_set) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send commerce::product_specifications::mojom::Page::OnProductSpecificationsSetAdded", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("set"), in_set,
                        "<value of type ::commerce::shared::mojom::ProductSpecificationsSetPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kOnProductSpecificationsSetAdded), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::commerce::product_specifications::mojom::internal::Page_OnProductSpecificationsSetAdded_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->set)::BaseType> set_fragment(
          params.message());
  
  mojo::internal::Serialize<::commerce::shared::mojom::ProductSpecificationsSetDataView>(
    in_set,
    set_fragment);

  params->set.Set(
      set_fragment.is_null() ? nullptr : set_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->set.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null set in Page.OnProductSpecificationsSetAdded request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("OnProductSpecificationsSetAdded");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageProxy::OnProductSpecificationsSetUpdated(
    ::commerce::shared::mojom::ProductSpecificationsSetPtr in_set) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send commerce::product_specifications::mojom::Page::OnProductSpecificationsSetUpdated", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("set"), in_set,
                        "<value of type ::commerce::shared::mojom::ProductSpecificationsSetPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kOnProductSpecificationsSetUpdated), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::commerce::product_specifications::mojom::internal::Page_OnProductSpecificationsSetUpdated_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->set)::BaseType> set_fragment(
          params.message());
  
  mojo::internal::Serialize<::commerce::shared::mojom::ProductSpecificationsSetDataView>(
    in_set,
    set_fragment);

  params->set.Set(
      set_fragment.is_null() ? nullptr : set_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->set.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null set in Page.OnProductSpecificationsSetUpdated request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("OnProductSpecificationsSetUpdated");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageProxy::OnProductSpecificationsSetRemoved(
    const ::base::Uuid& in_uuid) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send commerce::product_specifications::mojom::Page::OnProductSpecificationsSetRemoved", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("uuid"), in_uuid,
                        "<value of type const ::base::Uuid&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kOnProductSpecificationsSetRemoved), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::commerce::product_specifications::mojom::internal::Page_OnProductSpecificationsSetRemoved_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->uuid)::BaseType> uuid_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UuidDataView>(
    in_uuid,
    uuid_fragment);

  params->uuid.Set(
      uuid_fragment.is_null() ? nullptr : uuid_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->uuid.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null uuid in Page.OnProductSpecificationsSetRemoved request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("OnProductSpecificationsSetRemoved");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageProxy::OnSyncStateChanged(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send commerce::product_specifications::mojom::Page::OnSyncStateChanged");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kOnSyncStateChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::commerce::product_specifications::mojom::internal::Page_OnSyncStateChanged_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("OnSyncStateChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool PageStubDispatch::Accept(
    Page* impl,
    mojo::Message* message) {
  switch (static_cast<messages::Page>(message->header()->name)) {
    case messages::Page::kOnProductSpecificationsSetAdded: {
      DCHECK(message->is_serialized());
      internal::Page_OnProductSpecificationsSetAdded_Params_Data* params =
          reinterpret_cast<internal::Page_OnProductSpecificationsSetAdded_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.0
      bool success = true;
      ::commerce::shared::mojom::ProductSpecificationsSetPtr p_set{};
      Page_OnProductSpecificationsSetAdded_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSet(&p_set))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnProductSpecificationsSetAdded(        
        std::move(p_set));
      return true;
    }
    case messages::Page::kOnProductSpecificationsSetUpdated: {
      DCHECK(message->is_serialized());
      internal::Page_OnProductSpecificationsSetUpdated_Params_Data* params =
          reinterpret_cast<internal::Page_OnProductSpecificationsSetUpdated_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.1
      bool success = true;
      ::commerce::shared::mojom::ProductSpecificationsSetPtr p_set{};
      Page_OnProductSpecificationsSetUpdated_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSet(&p_set))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnProductSpecificationsSetUpdated(        
        std::move(p_set));
      return true;
    }
    case messages::Page::kOnProductSpecificationsSetRemoved: {
      DCHECK(message->is_serialized());
      internal::Page_OnProductSpecificationsSetRemoved_Params_Data* params =
          reinterpret_cast<internal::Page_OnProductSpecificationsSetRemoved_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.2
      bool success = true;
      ::base::Uuid p_uuid{};
      Page_OnProductSpecificationsSetRemoved_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUuid(&p_uuid))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnProductSpecificationsSetRemoved(        
        std::move(p_uuid));
      return true;
    }
    case messages::Page::kOnSyncStateChanged: {
      DCHECK(message->is_serialized());
      internal::Page_OnSyncStateChanged_Params_Data* params =
          reinterpret_cast<internal::Page_OnSyncStateChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.3
      bool success = true;
      Page_OnSyncStateChanged_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnSyncStateChanged(        );
      return true;
    }
  }
  return false;
}

// static
bool PageStubDispatch::AcceptWithResponder(
    Page* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::Page>(message->header()->name)) {
    case messages::Page::kOnProductSpecificationsSetAdded: {
      break;
    }
    case messages::Page::kOnProductSpecificationsSetUpdated: {
      break;
    }
    case messages::Page::kOnProductSpecificationsSetRemoved: {
      break;
    }
    case messages::Page::kOnSyncStateChanged: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPageValidationInfo[] = {
    { &internal::Page_OnProductSpecificationsSetAdded_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Page_OnProductSpecificationsSetUpdated_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Page_OnProductSpecificationsSetRemoved_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Page_OnSyncStateChanged_Params_Data::Validate,
     nullptr /* no response */},
};

bool PageRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::commerce::product_specifications::mojom::Page::Name_,
    kPageValidationInfo);
}

// The declaration includes the definition on other builds.

ProductSpecificationsHandlerFactory::IPCStableHashFunction ProductSpecificationsHandlerFactory::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ProductSpecificationsHandlerFactory>(message.name())) {
    case messages::ProductSpecificationsHandlerFactory::kCreateProductSpecificationsHandler: {
      return &ProductSpecificationsHandlerFactory::CreateProductSpecificationsHandler_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ProductSpecificationsHandlerFactory::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ProductSpecificationsHandlerFactory>(message.name())) {
      case messages::ProductSpecificationsHandlerFactory::kCreateProductSpecificationsHandler:
            return "Receive commerce::product_specifications::mojom::ProductSpecificationsHandlerFactory::CreateProductSpecificationsHandler";
    }
  } else {
    switch (static_cast<messages::ProductSpecificationsHandlerFactory>(message.name())) {
      case messages::ProductSpecificationsHandlerFactory::kCreateProductSpecificationsHandler:
            return "Receive reply commerce::product_specifications::mojom::ProductSpecificationsHandlerFactory::CreateProductSpecificationsHandler";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ProductSpecificationsHandlerFactory::CreateProductSpecificationsHandler_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4ed52db3;  // IPCStableHash for commerce::product_specifications::mojom::ProductSpecificationsHandlerFactory::CreateProductSpecificationsHandler
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

ProductSpecificationsHandlerFactoryProxy::ProductSpecificationsHandlerFactoryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ProductSpecificationsHandlerFactoryProxy::CreateProductSpecificationsHandler(
    ::mojo::PendingRemote<Page> in_page, ::mojo::PendingReceiver<ProductSpecificationsHandler> in_handler) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send commerce::product_specifications::mojom::ProductSpecificationsHandlerFactory::CreateProductSpecificationsHandler", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("page"), in_page,
                        "<value of type ::mojo::PendingRemote<Page>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("handler"), in_handler,
                        "<value of type ::mojo::PendingReceiver<ProductSpecificationsHandler>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ProductSpecificationsHandlerFactory::kCreateProductSpecificationsHandler), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::commerce::product_specifications::mojom::internal::ProductSpecificationsHandlerFactory_CreateProductSpecificationsHandler_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::commerce::product_specifications::mojom::PageInterfaceBase>>(
    in_page,
    &params->page,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->page)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid page in ProductSpecificationsHandlerFactory.CreateProductSpecificationsHandler request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::commerce::product_specifications::mojom::ProductSpecificationsHandlerInterfaceBase>>(
    in_handler,
    &params->handler,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->handler)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid handler in ProductSpecificationsHandlerFactory.CreateProductSpecificationsHandler request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProductSpecificationsHandlerFactory::Name_);
  message.set_method_name("CreateProductSpecificationsHandler");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool ProductSpecificationsHandlerFactoryStubDispatch::Accept(
    ProductSpecificationsHandlerFactory* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ProductSpecificationsHandlerFactory>(message->header()->name)) {
    case messages::ProductSpecificationsHandlerFactory::kCreateProductSpecificationsHandler: {
      DCHECK(message->is_serialized());
      internal::ProductSpecificationsHandlerFactory_CreateProductSpecificationsHandler_Params_Data* params =
          reinterpret_cast<internal::ProductSpecificationsHandlerFactory_CreateProductSpecificationsHandler_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ProductSpecificationsHandlerFactory.0
      bool success = true;
      ::mojo::PendingRemote<Page> p_page{};
      ::mojo::PendingReceiver<ProductSpecificationsHandler> p_handler{};
      ProductSpecificationsHandlerFactory_CreateProductSpecificationsHandler_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_page =
            input_data_view.TakePage<decltype(p_page)>();
      }
      if (success) {
        p_handler =
            input_data_view.TakeHandler<decltype(p_handler)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ProductSpecificationsHandlerFactory::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateProductSpecificationsHandler(        
        std::move(p_page), 
        std::move(p_handler));
      return true;
    }
  }
  return false;
}

// static
bool ProductSpecificationsHandlerFactoryStubDispatch::AcceptWithResponder(
    ProductSpecificationsHandlerFactory* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ProductSpecificationsHandlerFactory>(message->header()->name)) {
    case messages::ProductSpecificationsHandlerFactory::kCreateProductSpecificationsHandler: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kProductSpecificationsHandlerFactoryValidationInfo[] = {
    { &internal::ProductSpecificationsHandlerFactory_CreateProductSpecificationsHandler_Params_Data::Validate,
     nullptr /* no response */},
};

bool ProductSpecificationsHandlerFactoryRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::commerce::product_specifications::mojom::ProductSpecificationsHandlerFactory::Name_,
    kProductSpecificationsHandlerFactoryValidationInfo);
}



}  // commerce::product_specifications::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace commerce::product_specifications::mojom {


void ProductSpecificationsHandlerInterceptorForTesting::SetAcceptedDisclosureVersion(DisclosureVersion version) {
  GetForwardingInterface()->SetAcceptedDisclosureVersion(
    std::move(version)
    );
}
void ProductSpecificationsHandlerInterceptorForTesting::MaybeShowDisclosure(const std::vector<::GURL>& urls, const std::string& name, const std::string& set_id, MaybeShowDisclosureCallback callback) {
  GetForwardingInterface()->MaybeShowDisclosure(
    std::move(urls)
    , 
    std::move(name)
    , 
    std::move(set_id)
    , std::move(callback));
}
void ProductSpecificationsHandlerInterceptorForTesting::DeclineDisclosure() {
  GetForwardingInterface()->DeclineDisclosure();
}
void ProductSpecificationsHandlerInterceptorForTesting::ShowSyncSetupFlow() {
  GetForwardingInterface()->ShowSyncSetupFlow();
}
void ProductSpecificationsHandlerInterceptorForTesting::GetPageTitleFromHistory(const ::GURL& url, GetPageTitleFromHistoryCallback callback) {
  GetForwardingInterface()->GetPageTitleFromHistory(
    std::move(url)
    , std::move(callback));
}
void ProductSpecificationsHandlerInterceptorForTesting::ShowProductSpecificationsSetForUuid(const ::base::Uuid& uuid, bool in_new_tab) {
  GetForwardingInterface()->ShowProductSpecificationsSetForUuid(
    std::move(uuid)
    , 
    std::move(in_new_tab)
    );
}
void ProductSpecificationsHandlerInterceptorForTesting::ShowProductSpecificationsSetsForUuids(const std::vector<::base::Uuid>& uuids, ShowSetDisposition disposition) {
  GetForwardingInterface()->ShowProductSpecificationsSetsForUuids(
    std::move(uuids)
    , 
    std::move(disposition)
    );
}
void ProductSpecificationsHandlerInterceptorForTesting::ShowComparePage(bool in_new_tab) {
  GetForwardingInterface()->ShowComparePage(
    std::move(in_new_tab)
    );
}
void ProductSpecificationsHandlerInterceptorForTesting::GetComparisonTableUrlForUuid(const ::base::Uuid& uuid, GetComparisonTableUrlForUuidCallback callback) {
  GetForwardingInterface()->GetComparisonTableUrlForUuid(
    std::move(uuid)
    , std::move(callback));
}
ProductSpecificationsHandlerAsyncWaiter::ProductSpecificationsHandlerAsyncWaiter(
    ProductSpecificationsHandler* proxy) : proxy_(proxy) {}

ProductSpecificationsHandlerAsyncWaiter::~ProductSpecificationsHandlerAsyncWaiter() = default;


void ProductSpecificationsHandlerAsyncWaiter::MaybeShowDisclosure(
    const std::vector<::GURL>& urls, const std::string& name, const std::string& set_id, bool* out_disclosure_shown) {
  base::RunLoop loop;
  proxy_->MaybeShowDisclosure(
      std::move(urls),
      std::move(name),
      std::move(set_id),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_disclosure_shown
,
             bool disclosure_shown) {*out_disclosure_shown = std::move(disclosure_shown);
            loop->Quit();
          },
          &loop,
          out_disclosure_shown));
  loop.Run();
}

bool ProductSpecificationsHandlerAsyncWaiter::MaybeShowDisclosure(
    const std::vector<::GURL>& urls, const std::string& name, const std::string& set_id) {
  bool async_wait_result;
  MaybeShowDisclosure(std::move(urls),std::move(name),std::move(set_id),&async_wait_result);
  return async_wait_result;
}

void ProductSpecificationsHandlerAsyncWaiter::GetPageTitleFromHistory(
    const ::GURL& url, std::string* out_title) {
  base::RunLoop loop;
  proxy_->GetPageTitleFromHistory(
      std::move(url),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::string* out_title
,
             const std::string& title) {*out_title = std::move(title);
            loop->Quit();
          },
          &loop,
          out_title));
  loop.Run();
}

std::string ProductSpecificationsHandlerAsyncWaiter::GetPageTitleFromHistory(
    const ::GURL& url) {
  std::string async_wait_result;
  GetPageTitleFromHistory(std::move(url),&async_wait_result);
  return async_wait_result;
}

void ProductSpecificationsHandlerAsyncWaiter::GetComparisonTableUrlForUuid(
    const ::base::Uuid& uuid, ::GURL* out_url) {
  base::RunLoop loop;
  proxy_->GetComparisonTableUrlForUuid(
      std::move(uuid),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::GURL* out_url
,
             const ::GURL& url) {*out_url = std::move(url);
            loop->Quit();
          },
          &loop,
          out_url));
  loop.Run();
}

::GURL ProductSpecificationsHandlerAsyncWaiter::GetComparisonTableUrlForUuid(
    const ::base::Uuid& uuid) {
  ::GURL async_wait_result;
  GetComparisonTableUrlForUuid(std::move(uuid),&async_wait_result);
  return async_wait_result;
}




void PageInterceptorForTesting::OnProductSpecificationsSetAdded(::commerce::shared::mojom::ProductSpecificationsSetPtr set) {
  GetForwardingInterface()->OnProductSpecificationsSetAdded(
    std::move(set)
    );
}
void PageInterceptorForTesting::OnProductSpecificationsSetUpdated(::commerce::shared::mojom::ProductSpecificationsSetPtr set) {
  GetForwardingInterface()->OnProductSpecificationsSetUpdated(
    std::move(set)
    );
}
void PageInterceptorForTesting::OnProductSpecificationsSetRemoved(const ::base::Uuid& uuid) {
  GetForwardingInterface()->OnProductSpecificationsSetRemoved(
    std::move(uuid)
    );
}
void PageInterceptorForTesting::OnSyncStateChanged() {
  GetForwardingInterface()->OnSyncStateChanged();
}
PageAsyncWaiter::PageAsyncWaiter(
    Page* proxy) : proxy_(proxy) {}

PageAsyncWaiter::~PageAsyncWaiter() = default;





void ProductSpecificationsHandlerFactoryInterceptorForTesting::CreateProductSpecificationsHandler(::mojo::PendingRemote<Page> page, ::mojo::PendingReceiver<ProductSpecificationsHandler> handler) {
  GetForwardingInterface()->CreateProductSpecificationsHandler(
    std::move(page)
    , 
    std::move(handler)
    );
}
ProductSpecificationsHandlerFactoryAsyncWaiter::ProductSpecificationsHandlerFactoryAsyncWaiter(
    ProductSpecificationsHandlerFactory* proxy) : proxy_(proxy) {}

ProductSpecificationsHandlerFactoryAsyncWaiter::~ProductSpecificationsHandlerFactoryAsyncWaiter() = default;







}  // commerce::product_specifications::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif