// components/commerce/core/mojom/commerce_web_extractor.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_COMMERCE_CORE_MOJOM_COMMERCE_WEB_EXTRACTOR_MOJOM_H_
#define COMPONENTS_COMMERCE_CORE_MOJOM_COMMERCE_WEB_EXTRACTOR_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/commerce/core/mojom/commerce_web_extractor.mojom-features.h"  // IWYU pragma: export
#include "components/commerce/core/mojom/commerce_web_extractor.mojom-shared.h"  // IWYU pragma: export
#include "components/commerce/core/mojom/commerce_web_extractor.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/values.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace commerce_web_extractor::mojom {

class CommerceWebExtractorProxy;

template <typename ImplRefTraits>
class CommerceWebExtractorStub;

class CommerceWebExtractorRequestValidator;
class CommerceWebExtractorResponseValidator;


class CommerceWebExtractor
    : public CommerceWebExtractorInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "commerce_web_extractor.mojom.CommerceWebExtractor";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = CommerceWebExtractorInterfaceBase;
  using Proxy_ = CommerceWebExtractorProxy;

  template <typename ImplRefTraits>
  using Stub_ = CommerceWebExtractorStub<ImplRefTraits>;

  using RequestValidator_ = CommerceWebExtractorRequestValidator;
  using ResponseValidator_ = CommerceWebExtractorResponseValidator;
  enum MethodMinVersions : uint32_t {
    kExtractMetaInfoMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct ExtractMetaInfo_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~CommerceWebExtractor() = default;

  using ExtractMetaInfoCallback = base::OnceCallback<void(::base::Value)>;
  using ExtractMetaInfoMojoCallback = base::OnceCallback<void(::base::Value)>;

  virtual void ExtractMetaInfo(ExtractMetaInfoCallback callback) = 0;
};



class  CommerceWebExtractorProxy
    : public CommerceWebExtractor {
 public:
  using InterfaceType = CommerceWebExtractor;

  explicit CommerceWebExtractorProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void ExtractMetaInfo(ExtractMetaInfoCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  CommerceWebExtractorStubDispatch {
 public:
  static bool Accept(CommerceWebExtractor* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      CommerceWebExtractor* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<CommerceWebExtractor>>
class CommerceWebExtractorStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  CommerceWebExtractorStub() = default;
  ~CommerceWebExtractorStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CommerceWebExtractorStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CommerceWebExtractorStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  CommerceWebExtractorRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  CommerceWebExtractorResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // commerce_web_extractor::mojom

namespace mojo {

}  // namespace mojo

#endif  // COMPONENTS_COMMERCE_CORE_MOJOM_COMMERCE_WEB_EXTRACTOR_MOJOM_H_