// components/commerce/core/mojom/shopping_service.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { mojo } from '//resources/mojo/mojo/public/js/bindings.js';
import { ProductInfoSpec as commerce_shared_mojom_ProductInfoSpec, ProductSpecificationsSetSpec as commerce_shared_mojom_ProductSpecificationsSetSpec } from './shared.mojom-webui.js';
import { UuidSpec as mojoBase_mojom_UuidSpec } from '//resources/mojo/mojo/public/mojom/base/uuid.mojom-webui.js';
import { UrlSpec as url_mojom_UrlSpec } from '//resources/mojo/url/mojom/url.mojom-webui.js';
export const UserFeedbackSpec = { $: mojo.internal.Enum() };
export var UserFeedback;
(function (UserFeedback) {
    UserFeedback[UserFeedback["MIN_VALUE"] = 0] = "MIN_VALUE";
    UserFeedback[UserFeedback["MAX_VALUE"] = 2] = "MAX_VALUE";
    UserFeedback[UserFeedback["kUnspecified"] = 0] = "kUnspecified";
    UserFeedback[UserFeedback["kThumbsUp"] = 1] = "kThumbsUp";
    UserFeedback[UserFeedback["kThumbsDown"] = 2] = "kThumbsDown";
})(UserFeedback || (UserFeedback = {}));
export class ShoppingServiceHandlerFactoryPendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'shopping_service.mojom.ShoppingServiceHandlerFactory', scope);
    }
}
export class ShoppingServiceHandlerFactoryRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(ShoppingServiceHandlerFactoryPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    createShoppingServiceHandler(handler) {
        this.proxy.sendMessage(0, ShoppingServiceHandlerFactory_CreateShoppingServiceHandler_ParamsSpec.$, null, [
            handler
        ], false);
    }
}
;
/**
 * An object which receives request messages for the ShoppingServiceHandlerFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class ShoppingServiceHandlerFactoryReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(ShoppingServiceHandlerFactoryRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, ShoppingServiceHandlerFactory_CreateShoppingServiceHandler_ParamsSpec.$, null, impl.createShoppingServiceHandler.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class ShoppingServiceHandlerFactory {
    static get $interfaceName() {
        return "shopping_service.mojom.ShoppingServiceHandlerFactory";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new ShoppingServiceHandlerFactoryRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the ShoppingServiceHandlerFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class ShoppingServiceHandlerFactoryCallbackRouter {
    helper_internal_;
    $;
    router_;
    createShoppingServiceHandler;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(ShoppingServiceHandlerFactoryRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.createShoppingServiceHandler =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, ShoppingServiceHandlerFactory_CreateShoppingServiceHandler_ParamsSpec.$, null, this.createShoppingServiceHandler.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class ShoppingServiceHandlerPendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'shopping_service.mojom.ShoppingServiceHandler', scope);
    }
}
export class ShoppingServiceHandlerRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(ShoppingServiceHandlerPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    getProductInfoForCurrentUrl() {
        return this.proxy.sendMessage(0, ShoppingServiceHandler_GetProductInfoForCurrentUrl_ParamsSpec.$, ShoppingServiceHandler_GetProductInfoForCurrentUrl_ResponseParamsSpec.$, [], false);
    }
    getProductInfoForUrl(url) {
        return this.proxy.sendMessage(1, ShoppingServiceHandler_GetProductInfoForUrl_ParamsSpec.$, ShoppingServiceHandler_GetProductInfoForUrl_ResponseParamsSpec.$, [
            url
        ], false);
    }
    getProductInfoForUrls(urls) {
        return this.proxy.sendMessage(2, ShoppingServiceHandler_GetProductInfoForUrls_ParamsSpec.$, ShoppingServiceHandler_GetProductInfoForUrls_ResponseParamsSpec.$, [
            urls
        ], false);
    }
    getPriceInsightsInfoForCurrentUrl() {
        return this.proxy.sendMessage(3, ShoppingServiceHandler_GetPriceInsightsInfoForCurrentUrl_ParamsSpec.$, ShoppingServiceHandler_GetPriceInsightsInfoForCurrentUrl_ResponseParamsSpec.$, [], false);
    }
    getPriceInsightsInfoForUrl(url) {
        return this.proxy.sendMessage(4, ShoppingServiceHandler_GetPriceInsightsInfoForUrl_ParamsSpec.$, ShoppingServiceHandler_GetPriceInsightsInfoForUrl_ResponseParamsSpec.$, [
            url
        ], false);
    }
    getProductSpecificationsForUrls(urls) {
        return this.proxy.sendMessage(5, ShoppingServiceHandler_GetProductSpecificationsForUrls_ParamsSpec.$, ShoppingServiceHandler_GetProductSpecificationsForUrls_ResponseParamsSpec.$, [
            urls
        ], false);
    }
    getUrlInfosForProductTabs() {
        return this.proxy.sendMessage(6, ShoppingServiceHandler_GetUrlInfosForProductTabs_ParamsSpec.$, ShoppingServiceHandler_GetUrlInfosForProductTabs_ResponseParamsSpec.$, [], false);
    }
    getUrlInfosForRecentlyViewedTabs() {
        return this.proxy.sendMessage(7, ShoppingServiceHandler_GetUrlInfosForRecentlyViewedTabs_ParamsSpec.$, ShoppingServiceHandler_GetUrlInfosForRecentlyViewedTabs_ResponseParamsSpec.$, [], false);
    }
    isShoppingListEligible() {
        return this.proxy.sendMessage(8, ShoppingServiceHandler_IsShoppingListEligible_ParamsSpec.$, ShoppingServiceHandler_IsShoppingListEligible_ResponseParamsSpec.$, [], false);
    }
    getPriceTrackingStatusForCurrentUrl() {
        return this.proxy.sendMessage(9, ShoppingServiceHandler_GetPriceTrackingStatusForCurrentUrl_ParamsSpec.$, ShoppingServiceHandler_GetPriceTrackingStatusForCurrentUrl_ResponseParamsSpec.$, [], false);
    }
    openUrlInNewTab(url) {
        this.proxy.sendMessage(10, ShoppingServiceHandler_OpenUrlInNewTab_ParamsSpec.$, null, [
            url
        ], false);
    }
    switchToOrOpenTab(url) {
        this.proxy.sendMessage(11, ShoppingServiceHandler_SwitchToOrOpenTab_ParamsSpec.$, null, [
            url
        ], false);
    }
    getAllProductSpecificationsSets() {
        return this.proxy.sendMessage(12, ShoppingServiceHandler_GetAllProductSpecificationsSets_ParamsSpec.$, ShoppingServiceHandler_GetAllProductSpecificationsSets_ResponseParamsSpec.$, [], false);
    }
    getProductSpecificationsSetByUuid(uuid) {
        return this.proxy.sendMessage(13, ShoppingServiceHandler_GetProductSpecificationsSetByUuid_ParamsSpec.$, ShoppingServiceHandler_GetProductSpecificationsSetByUuid_ResponseParamsSpec.$, [
            uuid
        ], false);
    }
    addProductSpecificationsSet(name, urls) {
        return this.proxy.sendMessage(14, ShoppingServiceHandler_AddProductSpecificationsSet_ParamsSpec.$, ShoppingServiceHandler_AddProductSpecificationsSet_ResponseParamsSpec.$, [
            name,
            urls
        ], false);
    }
    deleteProductSpecificationsSet(uuid) {
        this.proxy.sendMessage(15, ShoppingServiceHandler_DeleteProductSpecificationsSet_ParamsSpec.$, null, [
            uuid
        ], false);
    }
    setNameForProductSpecificationsSet(uuid, name) {
        return this.proxy.sendMessage(16, ShoppingServiceHandler_SetNameForProductSpecificationsSet_ParamsSpec.$, ShoppingServiceHandler_SetNameForProductSpecificationsSet_ResponseParamsSpec.$, [
            uuid,
            name
        ], false);
    }
    setUrlsForProductSpecificationsSet(uuid, urls) {
        return this.proxy.sendMessage(17, ShoppingServiceHandler_SetUrlsForProductSpecificationsSet_ParamsSpec.$, ShoppingServiceHandler_SetUrlsForProductSpecificationsSet_ResponseParamsSpec.$, [
            uuid,
            urls
        ], false);
    }
    setProductSpecificationsUserFeedback(feedback) {
        this.proxy.sendMessage(18, ShoppingServiceHandler_SetProductSpecificationsUserFeedback_ParamsSpec.$, null, [
            feedback
        ], false);
    }
    getProductSpecificationsFeatureState() {
        return this.proxy.sendMessage(19, ShoppingServiceHandler_GetProductSpecificationsFeatureState_ParamsSpec.$, ShoppingServiceHandler_GetProductSpecificationsFeatureState_ResponseParamsSpec.$, [], false);
    }
}
;
/**
 * An object which receives request messages for the ShoppingServiceHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class ShoppingServiceHandlerReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(ShoppingServiceHandlerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, ShoppingServiceHandler_GetProductInfoForCurrentUrl_ParamsSpec.$, ShoppingServiceHandler_GetProductInfoForCurrentUrl_ResponseParamsSpec.$, impl.getProductInfoForCurrentUrl.bind(impl), false);
        this.helper_internal_.registerHandler(1, ShoppingServiceHandler_GetProductInfoForUrl_ParamsSpec.$, ShoppingServiceHandler_GetProductInfoForUrl_ResponseParamsSpec.$, impl.getProductInfoForUrl.bind(impl), false);
        this.helper_internal_.registerHandler(2, ShoppingServiceHandler_GetProductInfoForUrls_ParamsSpec.$, ShoppingServiceHandler_GetProductInfoForUrls_ResponseParamsSpec.$, impl.getProductInfoForUrls.bind(impl), false);
        this.helper_internal_.registerHandler(3, ShoppingServiceHandler_GetPriceInsightsInfoForCurrentUrl_ParamsSpec.$, ShoppingServiceHandler_GetPriceInsightsInfoForCurrentUrl_ResponseParamsSpec.$, impl.getPriceInsightsInfoForCurrentUrl.bind(impl), false);
        this.helper_internal_.registerHandler(4, ShoppingServiceHandler_GetPriceInsightsInfoForUrl_ParamsSpec.$, ShoppingServiceHandler_GetPriceInsightsInfoForUrl_ResponseParamsSpec.$, impl.getPriceInsightsInfoForUrl.bind(impl), false);
        this.helper_internal_.registerHandler(5, ShoppingServiceHandler_GetProductSpecificationsForUrls_ParamsSpec.$, ShoppingServiceHandler_GetProductSpecificationsForUrls_ResponseParamsSpec.$, impl.getProductSpecificationsForUrls.bind(impl), false);
        this.helper_internal_.registerHandler(6, ShoppingServiceHandler_GetUrlInfosForProductTabs_ParamsSpec.$, ShoppingServiceHandler_GetUrlInfosForProductTabs_ResponseParamsSpec.$, impl.getUrlInfosForProductTabs.bind(impl), false);
        this.helper_internal_.registerHandler(7, ShoppingServiceHandler_GetUrlInfosForRecentlyViewedTabs_ParamsSpec.$, ShoppingServiceHandler_GetUrlInfosForRecentlyViewedTabs_ResponseParamsSpec.$, impl.getUrlInfosForRecentlyViewedTabs.bind(impl), false);
        this.helper_internal_.registerHandler(8, ShoppingServiceHandler_IsShoppingListEligible_ParamsSpec.$, ShoppingServiceHandler_IsShoppingListEligible_ResponseParamsSpec.$, impl.isShoppingListEligible.bind(impl), false);
        this.helper_internal_.registerHandler(9, ShoppingServiceHandler_GetPriceTrackingStatusForCurrentUrl_ParamsSpec.$, ShoppingServiceHandler_GetPriceTrackingStatusForCurrentUrl_ResponseParamsSpec.$, impl.getPriceTrackingStatusForCurrentUrl.bind(impl), false);
        this.helper_internal_.registerHandler(10, ShoppingServiceHandler_OpenUrlInNewTab_ParamsSpec.$, null, impl.openUrlInNewTab.bind(impl), false);
        this.helper_internal_.registerHandler(11, ShoppingServiceHandler_SwitchToOrOpenTab_ParamsSpec.$, null, impl.switchToOrOpenTab.bind(impl), false);
        this.helper_internal_.registerHandler(12, ShoppingServiceHandler_GetAllProductSpecificationsSets_ParamsSpec.$, ShoppingServiceHandler_GetAllProductSpecificationsSets_ResponseParamsSpec.$, impl.getAllProductSpecificationsSets.bind(impl), false);
        this.helper_internal_.registerHandler(13, ShoppingServiceHandler_GetProductSpecificationsSetByUuid_ParamsSpec.$, ShoppingServiceHandler_GetProductSpecificationsSetByUuid_ResponseParamsSpec.$, impl.getProductSpecificationsSetByUuid.bind(impl), false);
        this.helper_internal_.registerHandler(14, ShoppingServiceHandler_AddProductSpecificationsSet_ParamsSpec.$, ShoppingServiceHandler_AddProductSpecificationsSet_ResponseParamsSpec.$, impl.addProductSpecificationsSet.bind(impl), false);
        this.helper_internal_.registerHandler(15, ShoppingServiceHandler_DeleteProductSpecificationsSet_ParamsSpec.$, null, impl.deleteProductSpecificationsSet.bind(impl), false);
        this.helper_internal_.registerHandler(16, ShoppingServiceHandler_SetNameForProductSpecificationsSet_ParamsSpec.$, ShoppingServiceHandler_SetNameForProductSpecificationsSet_ResponseParamsSpec.$, impl.setNameForProductSpecificationsSet.bind(impl), false);
        this.helper_internal_.registerHandler(17, ShoppingServiceHandler_SetUrlsForProductSpecificationsSet_ParamsSpec.$, ShoppingServiceHandler_SetUrlsForProductSpecificationsSet_ResponseParamsSpec.$, impl.setUrlsForProductSpecificationsSet.bind(impl), false);
        this.helper_internal_.registerHandler(18, ShoppingServiceHandler_SetProductSpecificationsUserFeedback_ParamsSpec.$, null, impl.setProductSpecificationsUserFeedback.bind(impl), false);
        this.helper_internal_.registerHandler(19, ShoppingServiceHandler_GetProductSpecificationsFeatureState_ParamsSpec.$, ShoppingServiceHandler_GetProductSpecificationsFeatureState_ResponseParamsSpec.$, impl.getProductSpecificationsFeatureState.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class ShoppingServiceHandler {
    static get $interfaceName() {
        return "shopping_service.mojom.ShoppingServiceHandler";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new ShoppingServiceHandlerRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the ShoppingServiceHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class ShoppingServiceHandlerCallbackRouter {
    helper_internal_;
    $;
    router_;
    getProductInfoForCurrentUrl;
    getProductInfoForUrl;
    getProductInfoForUrls;
    getPriceInsightsInfoForCurrentUrl;
    getPriceInsightsInfoForUrl;
    getProductSpecificationsForUrls;
    getUrlInfosForProductTabs;
    getUrlInfosForRecentlyViewedTabs;
    isShoppingListEligible;
    getPriceTrackingStatusForCurrentUrl;
    openUrlInNewTab;
    switchToOrOpenTab;
    getAllProductSpecificationsSets;
    getProductSpecificationsSetByUuid;
    addProductSpecificationsSet;
    deleteProductSpecificationsSet;
    setNameForProductSpecificationsSet;
    setUrlsForProductSpecificationsSet;
    setProductSpecificationsUserFeedback;
    getProductSpecificationsFeatureState;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(ShoppingServiceHandlerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.getProductInfoForCurrentUrl =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, ShoppingServiceHandler_GetProductInfoForCurrentUrl_ParamsSpec.$, ShoppingServiceHandler_GetProductInfoForCurrentUrl_ResponseParamsSpec.$, this.getProductInfoForCurrentUrl.createReceiverHandler(true /* expectsResponse */), false);
        this.getProductInfoForUrl =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, ShoppingServiceHandler_GetProductInfoForUrl_ParamsSpec.$, ShoppingServiceHandler_GetProductInfoForUrl_ResponseParamsSpec.$, this.getProductInfoForUrl.createReceiverHandler(true /* expectsResponse */), false);
        this.getProductInfoForUrls =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, ShoppingServiceHandler_GetProductInfoForUrls_ParamsSpec.$, ShoppingServiceHandler_GetProductInfoForUrls_ResponseParamsSpec.$, this.getProductInfoForUrls.createReceiverHandler(true /* expectsResponse */), false);
        this.getPriceInsightsInfoForCurrentUrl =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(3, ShoppingServiceHandler_GetPriceInsightsInfoForCurrentUrl_ParamsSpec.$, ShoppingServiceHandler_GetPriceInsightsInfoForCurrentUrl_ResponseParamsSpec.$, this.getPriceInsightsInfoForCurrentUrl.createReceiverHandler(true /* expectsResponse */), false);
        this.getPriceInsightsInfoForUrl =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(4, ShoppingServiceHandler_GetPriceInsightsInfoForUrl_ParamsSpec.$, ShoppingServiceHandler_GetPriceInsightsInfoForUrl_ResponseParamsSpec.$, this.getPriceInsightsInfoForUrl.createReceiverHandler(true /* expectsResponse */), false);
        this.getProductSpecificationsForUrls =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(5, ShoppingServiceHandler_GetProductSpecificationsForUrls_ParamsSpec.$, ShoppingServiceHandler_GetProductSpecificationsForUrls_ResponseParamsSpec.$, this.getProductSpecificationsForUrls.createReceiverHandler(true /* expectsResponse */), false);
        this.getUrlInfosForProductTabs =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(6, ShoppingServiceHandler_GetUrlInfosForProductTabs_ParamsSpec.$, ShoppingServiceHandler_GetUrlInfosForProductTabs_ResponseParamsSpec.$, this.getUrlInfosForProductTabs.createReceiverHandler(true /* expectsResponse */), false);
        this.getUrlInfosForRecentlyViewedTabs =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(7, ShoppingServiceHandler_GetUrlInfosForRecentlyViewedTabs_ParamsSpec.$, ShoppingServiceHandler_GetUrlInfosForRecentlyViewedTabs_ResponseParamsSpec.$, this.getUrlInfosForRecentlyViewedTabs.createReceiverHandler(true /* expectsResponse */), false);
        this.isShoppingListEligible =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(8, ShoppingServiceHandler_IsShoppingListEligible_ParamsSpec.$, ShoppingServiceHandler_IsShoppingListEligible_ResponseParamsSpec.$, this.isShoppingListEligible.createReceiverHandler(true /* expectsResponse */), false);
        this.getPriceTrackingStatusForCurrentUrl =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(9, ShoppingServiceHandler_GetPriceTrackingStatusForCurrentUrl_ParamsSpec.$, ShoppingServiceHandler_GetPriceTrackingStatusForCurrentUrl_ResponseParamsSpec.$, this.getPriceTrackingStatusForCurrentUrl.createReceiverHandler(true /* expectsResponse */), false);
        this.openUrlInNewTab =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(10, ShoppingServiceHandler_OpenUrlInNewTab_ParamsSpec.$, null, this.openUrlInNewTab.createReceiverHandler(false /* expectsResponse */), false);
        this.switchToOrOpenTab =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(11, ShoppingServiceHandler_SwitchToOrOpenTab_ParamsSpec.$, null, this.switchToOrOpenTab.createReceiverHandler(false /* expectsResponse */), false);
        this.getAllProductSpecificationsSets =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(12, ShoppingServiceHandler_GetAllProductSpecificationsSets_ParamsSpec.$, ShoppingServiceHandler_GetAllProductSpecificationsSets_ResponseParamsSpec.$, this.getAllProductSpecificationsSets.createReceiverHandler(true /* expectsResponse */), false);
        this.getProductSpecificationsSetByUuid =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(13, ShoppingServiceHandler_GetProductSpecificationsSetByUuid_ParamsSpec.$, ShoppingServiceHandler_GetProductSpecificationsSetByUuid_ResponseParamsSpec.$, this.getProductSpecificationsSetByUuid.createReceiverHandler(true /* expectsResponse */), false);
        this.addProductSpecificationsSet =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(14, ShoppingServiceHandler_AddProductSpecificationsSet_ParamsSpec.$, ShoppingServiceHandler_AddProductSpecificationsSet_ResponseParamsSpec.$, this.addProductSpecificationsSet.createReceiverHandler(true /* expectsResponse */), false);
        this.deleteProductSpecificationsSet =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(15, ShoppingServiceHandler_DeleteProductSpecificationsSet_ParamsSpec.$, null, this.deleteProductSpecificationsSet.createReceiverHandler(false /* expectsResponse */), false);
        this.setNameForProductSpecificationsSet =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(16, ShoppingServiceHandler_SetNameForProductSpecificationsSet_ParamsSpec.$, ShoppingServiceHandler_SetNameForProductSpecificationsSet_ResponseParamsSpec.$, this.setNameForProductSpecificationsSet.createReceiverHandler(true /* expectsResponse */), false);
        this.setUrlsForProductSpecificationsSet =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(17, ShoppingServiceHandler_SetUrlsForProductSpecificationsSet_ParamsSpec.$, ShoppingServiceHandler_SetUrlsForProductSpecificationsSet_ResponseParamsSpec.$, this.setUrlsForProductSpecificationsSet.createReceiverHandler(true /* expectsResponse */), false);
        this.setProductSpecificationsUserFeedback =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(18, ShoppingServiceHandler_SetProductSpecificationsUserFeedback_ParamsSpec.$, null, this.setProductSpecificationsUserFeedback.createReceiverHandler(false /* expectsResponse */), false);
        this.getProductSpecificationsFeatureState =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(19, ShoppingServiceHandler_GetProductSpecificationsFeatureState_ParamsSpec.$, ShoppingServiceHandler_GetProductSpecificationsFeatureState_ResponseParamsSpec.$, this.getProductSpecificationsFeatureState.createReceiverHandler(true /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export const PricePointSpec = { $: {} };
export const UrlInfoSpec = { $: {} };
export const PriceInsightsInfoSpec = { $: {} };
export const ProductSpecificationsDescriptionTextSpec = { $: {} };
export const ProductSpecificationsOptionSpec = { $: {} };
export const ProductSpecificationsDescriptionSpec = { $: {} };
export const ProductSpecificationsValueSpec = { $: {} };
export const ProductSpecificationsProductSpec = { $: {} };
export const ProductSpecificationsFeatureStateSpec = { $: {} };
export const ProductSpecificationsSpec = { $: {} };
export const ShoppingServiceHandlerFactory_CreateShoppingServiceHandler_ParamsSpec = { $: {} };
export const ShoppingServiceHandler_GetProductInfoForCurrentUrl_ParamsSpec = { $: {} };
export const ShoppingServiceHandler_GetProductInfoForCurrentUrl_ResponseParamsSpec = { $: {} };
export const ShoppingServiceHandler_GetProductInfoForUrl_ParamsSpec = { $: {} };
export const ShoppingServiceHandler_GetProductInfoForUrl_ResponseParamsSpec = { $: {} };
export const ShoppingServiceHandler_GetProductInfoForUrls_ParamsSpec = { $: {} };
export const ShoppingServiceHandler_GetProductInfoForUrls_ResponseParamsSpec = { $: {} };
export const ShoppingServiceHandler_GetPriceInsightsInfoForCurrentUrl_ParamsSpec = { $: {} };
export const ShoppingServiceHandler_GetPriceInsightsInfoForCurrentUrl_ResponseParamsSpec = { $: {} };
export const ShoppingServiceHandler_GetPriceInsightsInfoForUrl_ParamsSpec = { $: {} };
export const ShoppingServiceHandler_GetPriceInsightsInfoForUrl_ResponseParamsSpec = { $: {} };
export const ShoppingServiceHandler_GetProductSpecificationsForUrls_ParamsSpec = { $: {} };
export const ShoppingServiceHandler_GetProductSpecificationsForUrls_ResponseParamsSpec = { $: {} };
export const ShoppingServiceHandler_GetUrlInfosForProductTabs_ParamsSpec = { $: {} };
export const ShoppingServiceHandler_GetUrlInfosForProductTabs_ResponseParamsSpec = { $: {} };
export const ShoppingServiceHandler_GetUrlInfosForRecentlyViewedTabs_ParamsSpec = { $: {} };
export const ShoppingServiceHandler_GetUrlInfosForRecentlyViewedTabs_ResponseParamsSpec = { $: {} };
export const ShoppingServiceHandler_IsShoppingListEligible_ParamsSpec = { $: {} };
export const ShoppingServiceHandler_IsShoppingListEligible_ResponseParamsSpec = { $: {} };
export const ShoppingServiceHandler_GetPriceTrackingStatusForCurrentUrl_ParamsSpec = { $: {} };
export const ShoppingServiceHandler_GetPriceTrackingStatusForCurrentUrl_ResponseParamsSpec = { $: {} };
export const ShoppingServiceHandler_OpenUrlInNewTab_ParamsSpec = { $: {} };
export const ShoppingServiceHandler_SwitchToOrOpenTab_ParamsSpec = { $: {} };
export const ShoppingServiceHandler_GetAllProductSpecificationsSets_ParamsSpec = { $: {} };
export const ShoppingServiceHandler_GetAllProductSpecificationsSets_ResponseParamsSpec = { $: {} };
export const ShoppingServiceHandler_GetProductSpecificationsSetByUuid_ParamsSpec = { $: {} };
export const ShoppingServiceHandler_GetProductSpecificationsSetByUuid_ResponseParamsSpec = { $: {} };
export const ShoppingServiceHandler_AddProductSpecificationsSet_ParamsSpec = { $: {} };
export const ShoppingServiceHandler_AddProductSpecificationsSet_ResponseParamsSpec = { $: {} };
export const ShoppingServiceHandler_DeleteProductSpecificationsSet_ParamsSpec = { $: {} };
export const ShoppingServiceHandler_SetNameForProductSpecificationsSet_ParamsSpec = { $: {} };
export const ShoppingServiceHandler_SetNameForProductSpecificationsSet_ResponseParamsSpec = { $: {} };
export const ShoppingServiceHandler_SetUrlsForProductSpecificationsSet_ParamsSpec = { $: {} };
export const ShoppingServiceHandler_SetUrlsForProductSpecificationsSet_ResponseParamsSpec = { $: {} };
export const ShoppingServiceHandler_SetProductSpecificationsUserFeedback_ParamsSpec = { $: {} };
export const ShoppingServiceHandler_GetProductSpecificationsFeatureState_ParamsSpec = { $: {} };
export const ShoppingServiceHandler_GetProductSpecificationsFeatureState_ResponseParamsSpec = { $: {} };
mojo.internal.Struct(PricePointSpec.$, 'PricePoint', [
    mojo.internal.StructField('date', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('price', 8, 0, mojo.internal.Float, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('formattedPrice', 16, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 32],]);
mojo.internal.Struct(UrlInfoSpec.$, 'UrlInfo', [
    mojo.internal.StructField('title', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('url', 8, 0, url_mojom_UrlSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('faviconUrl', 16, 0, url_mojom_UrlSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('thumbnailUrl', 24, 0, url_mojom_UrlSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('previewText', 32, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 48],]);
export const PriceInsightsInfo_PriceBucketSpec = { $: mojo.internal.Enum() };
export var PriceInsightsInfo_PriceBucket;
(function (PriceInsightsInfo_PriceBucket) {
    PriceInsightsInfo_PriceBucket[PriceInsightsInfo_PriceBucket["MIN_VALUE"] = 0] = "MIN_VALUE";
    PriceInsightsInfo_PriceBucket[PriceInsightsInfo_PriceBucket["MAX_VALUE"] = 3] = "MAX_VALUE";
    PriceInsightsInfo_PriceBucket[PriceInsightsInfo_PriceBucket["kUnknown"] = 0] = "kUnknown";
    PriceInsightsInfo_PriceBucket[PriceInsightsInfo_PriceBucket["kLow"] = 1] = "kLow";
    PriceInsightsInfo_PriceBucket[PriceInsightsInfo_PriceBucket["kTypical"] = 2] = "kTypical";
    PriceInsightsInfo_PriceBucket[PriceInsightsInfo_PriceBucket["kHigh"] = 3] = "kHigh";
})(PriceInsightsInfo_PriceBucket || (PriceInsightsInfo_PriceBucket = {}));
mojo.internal.Struct(PriceInsightsInfoSpec.$, 'PriceInsightsInfo', [
    mojo.internal.StructField('clusterId', 0, 0, mojo.internal.Uint64, BigInt(0), false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('typicalLowPrice', 8, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('typicalHighPrice', 16, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('catalogAttributes', 24, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('jackpot', 32, 0, url_mojom_UrlSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('bucket', 40, 0, PriceInsightsInfo_PriceBucketSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('hasMultipleCatalogs', 44, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('history', 48, 0, mojo.internal.Array(PricePointSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('locale', 56, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('currencyCode', 64, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 80],]);
mojo.internal.Struct(ProductSpecificationsDescriptionTextSpec.$, 'ProductSpecificationsDescriptionText', [
    mojo.internal.StructField('text', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('urls', 8, 0, mojo.internal.Array(UrlInfoSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(ProductSpecificationsOptionSpec.$, 'ProductSpecificationsOption', [
    mojo.internal.StructField('descriptions', 0, 0, mojo.internal.Array(ProductSpecificationsDescriptionTextSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(ProductSpecificationsDescriptionSpec.$, 'ProductSpecificationsDescription', [
    mojo.internal.StructField('options', 0, 0, mojo.internal.Array(ProductSpecificationsOptionSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('label', 8, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('altText', 16, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 32],]);
mojo.internal.Struct(ProductSpecificationsValueSpec.$, 'ProductSpecificationsValue', [
    mojo.internal.StructField('specificationDescriptions', 0, 0, mojo.internal.Array(ProductSpecificationsDescriptionSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('summary', 8, 0, mojo.internal.Array(ProductSpecificationsDescriptionTextSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(ProductSpecificationsProductSpec.$, 'ProductSpecificationsProduct', [
    mojo.internal.StructField('productClusterId', 0, 0, mojo.internal.Uint64, BigInt(0), false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('title', 8, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('imageUrl', 16, 0, url_mojom_UrlSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('productDimensionValues', 24, 0, mojo.internal.Map(mojo.internal.Uint64, ProductSpecificationsValueSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('summary', 32, 0, mojo.internal.Array(ProductSpecificationsDescriptionTextSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('buyingOptionsUrl', 40, 0, url_mojom_UrlSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 56],]);
mojo.internal.Struct(ProductSpecificationsFeatureStateSpec.$, 'ProductSpecificationsFeatureState', [
    mojo.internal.StructField('isSyncingTabCompare', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('canLoadFullPageUi', 0, 1, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('canManageSets', 0, 2, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('canFetchData', 0, 3, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('isAllowedForEnterprise', 0, 4, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('isQualityLoggingAllowed', 0, 5, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('isSignedIn', 0, 6, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(ProductSpecificationsSpec.$, 'ProductSpecifications', [
    mojo.internal.StructField('productDimensionMap', 0, 0, mojo.internal.Map(mojo.internal.Uint64, mojo.internal.String, false), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('products', 8, 0, mojo.internal.Array(ProductSpecificationsProductSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(ShoppingServiceHandlerFactory_CreateShoppingServiceHandler_ParamsSpec.$, 'ShoppingServiceHandlerFactory_CreateShoppingServiceHandler_Params', [
    mojo.internal.StructField('handler', 0, 0, mojo.internal.InterfaceRequest(ShoppingServiceHandlerPendingReceiver), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(ShoppingServiceHandler_GetProductInfoForCurrentUrl_ParamsSpec.$, 'ShoppingServiceHandler_GetProductInfoForCurrentUrl_Params', [], [[0, 8],]);
mojo.internal.Struct(ShoppingServiceHandler_GetProductInfoForCurrentUrl_ResponseParamsSpec.$, 'ShoppingServiceHandler_GetProductInfoForCurrentUrl_ResponseParams', [
    mojo.internal.StructField('productInfo', 0, 0, commerce_shared_mojom_ProductInfoSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(ShoppingServiceHandler_GetProductInfoForUrl_ParamsSpec.$, 'ShoppingServiceHandler_GetProductInfoForUrl_Params', [
    mojo.internal.StructField('url', 0, 0, url_mojom_UrlSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(ShoppingServiceHandler_GetProductInfoForUrl_ResponseParamsSpec.$, 'ShoppingServiceHandler_GetProductInfoForUrl_ResponseParams', [
    mojo.internal.StructField('url', 0, 0, url_mojom_UrlSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('productInfo', 8, 0, commerce_shared_mojom_ProductInfoSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(ShoppingServiceHandler_GetProductInfoForUrls_ParamsSpec.$, 'ShoppingServiceHandler_GetProductInfoForUrls_Params', [
    mojo.internal.StructField('urls', 0, 0, mojo.internal.Array(url_mojom_UrlSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(ShoppingServiceHandler_GetProductInfoForUrls_ResponseParamsSpec.$, 'ShoppingServiceHandler_GetProductInfoForUrls_ResponseParams', [
    mojo.internal.StructField('productInfos', 0, 0, mojo.internal.Array(commerce_shared_mojom_ProductInfoSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(ShoppingServiceHandler_GetPriceInsightsInfoForCurrentUrl_ParamsSpec.$, 'ShoppingServiceHandler_GetPriceInsightsInfoForCurrentUrl_Params', [], [[0, 8],]);
mojo.internal.Struct(ShoppingServiceHandler_GetPriceInsightsInfoForCurrentUrl_ResponseParamsSpec.$, 'ShoppingServiceHandler_GetPriceInsightsInfoForCurrentUrl_ResponseParams', [
    mojo.internal.StructField('priceInsightsInfo', 0, 0, PriceInsightsInfoSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(ShoppingServiceHandler_GetPriceInsightsInfoForUrl_ParamsSpec.$, 'ShoppingServiceHandler_GetPriceInsightsInfoForUrl_Params', [
    mojo.internal.StructField('url', 0, 0, url_mojom_UrlSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(ShoppingServiceHandler_GetPriceInsightsInfoForUrl_ResponseParamsSpec.$, 'ShoppingServiceHandler_GetPriceInsightsInfoForUrl_ResponseParams', [
    mojo.internal.StructField('url', 0, 0, url_mojom_UrlSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('priceInsightsInfo', 8, 0, PriceInsightsInfoSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(ShoppingServiceHandler_GetProductSpecificationsForUrls_ParamsSpec.$, 'ShoppingServiceHandler_GetProductSpecificationsForUrls_Params', [
    mojo.internal.StructField('urls', 0, 0, mojo.internal.Array(url_mojom_UrlSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(ShoppingServiceHandler_GetProductSpecificationsForUrls_ResponseParamsSpec.$, 'ShoppingServiceHandler_GetProductSpecificationsForUrls_ResponseParams', [
    mojo.internal.StructField('productSpecs', 0, 0, ProductSpecificationsSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(ShoppingServiceHandler_GetUrlInfosForProductTabs_ParamsSpec.$, 'ShoppingServiceHandler_GetUrlInfosForProductTabs_Params', [], [[0, 8],]);
mojo.internal.Struct(ShoppingServiceHandler_GetUrlInfosForProductTabs_ResponseParamsSpec.$, 'ShoppingServiceHandler_GetUrlInfosForProductTabs_ResponseParams', [
    mojo.internal.StructField('urlInfos', 0, 0, mojo.internal.Array(UrlInfoSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(ShoppingServiceHandler_GetUrlInfosForRecentlyViewedTabs_ParamsSpec.$, 'ShoppingServiceHandler_GetUrlInfosForRecentlyViewedTabs_Params', [], [[0, 8],]);
mojo.internal.Struct(ShoppingServiceHandler_GetUrlInfosForRecentlyViewedTabs_ResponseParamsSpec.$, 'ShoppingServiceHandler_GetUrlInfosForRecentlyViewedTabs_ResponseParams', [
    mojo.internal.StructField('urlInfos', 0, 0, mojo.internal.Array(UrlInfoSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(ShoppingServiceHandler_IsShoppingListEligible_ParamsSpec.$, 'ShoppingServiceHandler_IsShoppingListEligible_Params', [], [[0, 8],]);
mojo.internal.Struct(ShoppingServiceHandler_IsShoppingListEligible_ResponseParamsSpec.$, 'ShoppingServiceHandler_IsShoppingListEligible_ResponseParams', [
    mojo.internal.StructField('eligible', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(ShoppingServiceHandler_GetPriceTrackingStatusForCurrentUrl_ParamsSpec.$, 'ShoppingServiceHandler_GetPriceTrackingStatusForCurrentUrl_Params', [], [[0, 8],]);
mojo.internal.Struct(ShoppingServiceHandler_GetPriceTrackingStatusForCurrentUrl_ResponseParamsSpec.$, 'ShoppingServiceHandler_GetPriceTrackingStatusForCurrentUrl_ResponseParams', [
    mojo.internal.StructField('tracked', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(ShoppingServiceHandler_OpenUrlInNewTab_ParamsSpec.$, 'ShoppingServiceHandler_OpenUrlInNewTab_Params', [
    mojo.internal.StructField('url', 0, 0, url_mojom_UrlSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(ShoppingServiceHandler_SwitchToOrOpenTab_ParamsSpec.$, 'ShoppingServiceHandler_SwitchToOrOpenTab_Params', [
    mojo.internal.StructField('url', 0, 0, url_mojom_UrlSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(ShoppingServiceHandler_GetAllProductSpecificationsSets_ParamsSpec.$, 'ShoppingServiceHandler_GetAllProductSpecificationsSets_Params', [], [[0, 8],]);
mojo.internal.Struct(ShoppingServiceHandler_GetAllProductSpecificationsSets_ResponseParamsSpec.$, 'ShoppingServiceHandler_GetAllProductSpecificationsSets_ResponseParams', [
    mojo.internal.StructField('sets', 0, 0, mojo.internal.Array(commerce_shared_mojom_ProductSpecificationsSetSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(ShoppingServiceHandler_GetProductSpecificationsSetByUuid_ParamsSpec.$, 'ShoppingServiceHandler_GetProductSpecificationsSetByUuid_Params', [
    mojo.internal.StructField('uuid', 0, 0, mojoBase_mojom_UuidSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(ShoppingServiceHandler_GetProductSpecificationsSetByUuid_ResponseParamsSpec.$, 'ShoppingServiceHandler_GetProductSpecificationsSetByUuid_ResponseParams', [
    mojo.internal.StructField('set', 0, 0, commerce_shared_mojom_ProductSpecificationsSetSpec.$, null, true /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(ShoppingServiceHandler_AddProductSpecificationsSet_ParamsSpec.$, 'ShoppingServiceHandler_AddProductSpecificationsSet_Params', [
    mojo.internal.StructField('name', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('urls', 8, 0, mojo.internal.Array(url_mojom_UrlSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(ShoppingServiceHandler_AddProductSpecificationsSet_ResponseParamsSpec.$, 'ShoppingServiceHandler_AddProductSpecificationsSet_ResponseParams', [
    mojo.internal.StructField('createdSet', 0, 0, commerce_shared_mojom_ProductSpecificationsSetSpec.$, null, true /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(ShoppingServiceHandler_DeleteProductSpecificationsSet_ParamsSpec.$, 'ShoppingServiceHandler_DeleteProductSpecificationsSet_Params', [
    mojo.internal.StructField('uuid', 0, 0, mojoBase_mojom_UuidSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(ShoppingServiceHandler_SetNameForProductSpecificationsSet_ParamsSpec.$, 'ShoppingServiceHandler_SetNameForProductSpecificationsSet_Params', [
    mojo.internal.StructField('uuid', 0, 0, mojoBase_mojom_UuidSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('name', 8, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(ShoppingServiceHandler_SetNameForProductSpecificationsSet_ResponseParamsSpec.$, 'ShoppingServiceHandler_SetNameForProductSpecificationsSet_ResponseParams', [
    mojo.internal.StructField('updatedSet', 0, 0, commerce_shared_mojom_ProductSpecificationsSetSpec.$, null, true /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(ShoppingServiceHandler_SetUrlsForProductSpecificationsSet_ParamsSpec.$, 'ShoppingServiceHandler_SetUrlsForProductSpecificationsSet_Params', [
    mojo.internal.StructField('uuid', 0, 0, mojoBase_mojom_UuidSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('urls', 8, 0, mojo.internal.Array(url_mojom_UrlSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(ShoppingServiceHandler_SetUrlsForProductSpecificationsSet_ResponseParamsSpec.$, 'ShoppingServiceHandler_SetUrlsForProductSpecificationsSet_ResponseParams', [
    mojo.internal.StructField('updatedSet', 0, 0, commerce_shared_mojom_ProductSpecificationsSetSpec.$, null, true /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(ShoppingServiceHandler_SetProductSpecificationsUserFeedback_ParamsSpec.$, 'ShoppingServiceHandler_SetProductSpecificationsUserFeedback_Params', [
    mojo.internal.StructField('feedback', 0, 0, UserFeedbackSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(ShoppingServiceHandler_GetProductSpecificationsFeatureState_ParamsSpec.$, 'ShoppingServiceHandler_GetProductSpecificationsFeatureState_Params', [], [[0, 8],]);
mojo.internal.Struct(ShoppingServiceHandler_GetProductSpecificationsFeatureState_ResponseParamsSpec.$, 'ShoppingServiceHandler_GetProductSpecificationsFeatureState_ResponseParams', [
    mojo.internal.StructField('state', 0, 0, ProductSpecificationsFeatureStateSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
