// components/autofill/core/browser/ml_model/logging/autofill_ml_internals.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_AUTOFILL_CORE_BROWSER_ML_MODEL_LOGGING_AUTOFILL_ML_INTERNALS_MOJOM_H_
#define COMPONENTS_AUTOFILL_CORE_BROWSER_ML_MODEL_LOGGING_AUTOFILL_ML_INTERNALS_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/autofill/core/browser/ml_model/logging/autofill_ml_internals.mojom-features.h"  // IWYU pragma: export
#include "components/autofill/core/browser/ml_model/logging/autofill_ml_internals.mojom-shared.h"  // IWYU pragma: export
#include "components/autofill/core/browser/ml_model/logging/autofill_ml_internals.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/time.mojom.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace autofill_ml_internals::mojom {

class PageProxy;

template <typename ImplRefTraits>
class PageStub;

class PageRequestValidator;


class Page
    : public PageInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "autofill_ml_internals.mojom.Page";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PageInterfaceBase;
  using Proxy_ = PageProxy;

  template <typename ImplRefTraits>
  using Stub_ = PageStub<ImplRefTraits>;

  using RequestValidator_ = PageRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnLogAddedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnLogAdded_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~Page() = default;

  virtual void OnLogAdded(MlPredictionLogPtr log) = 0;
};

class PageHandlerProxy;

template <typename ImplRefTraits>
class PageHandlerStub;

class PageHandlerRequestValidator;


class PageHandler
    : public PageHandlerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "autofill_ml_internals.mojom.PageHandler";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PageHandlerInterfaceBase;
  using Proxy_ = PageHandlerProxy;

  template <typename ImplRefTraits>
  using Stub_ = PageHandlerStub<ImplRefTraits>;

  using RequestValidator_ = PageHandlerRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kSetPageMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SetPage_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PageHandler() = default;

  virtual void SetPage(::mojo::PendingRemote<Page> page) = 0;
};



class  PageProxy
    : public Page {
 public:
  using InterfaceType = Page;

  explicit PageProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnLogAdded(MlPredictionLogPtr log) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  PageHandlerProxy
    : public PageHandler {
 public:
  using InterfaceType = PageHandler;

  explicit PageHandlerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetPage(::mojo::PendingRemote<Page> page) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  PageStubDispatch {
 public:
  static bool Accept(Page* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      Page* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<Page>>
class PageStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PageStub() = default;
  ~PageStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PageHandlerStubDispatch {
 public:
  static bool Accept(PageHandler* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PageHandler* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PageHandler>>
class PageHandlerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PageHandlerStub() = default;
  ~PageHandlerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PageRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PageHandlerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class  SelectOption {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SelectOption, T>::value>;
  using DataView = SelectOptionDataView;
  using Data_ = internal::SelectOption_Data;

  template <typename... Args>
  static SelectOptionPtr New(Args&&... args) {
    return SelectOptionPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SelectOptionPtr From(const U& u) {
    return mojo::TypeConverter<SelectOptionPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SelectOption>::Convert(*this);
  }


  SelectOption();

  SelectOption(
      const std::string& value,
      const std::string& text);


  ~SelectOption();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SelectOptionPtr>
  SelectOptionPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SelectOption::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SelectOption::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SelectOption::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SelectOption::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SelectOption::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SelectOption::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SelectOption_UnserializedMessageContext<
            UserType, SelectOption::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SelectOption::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SelectOption::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SelectOption_UnserializedMessageContext<
            UserType, SelectOption::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SelectOption::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string value;
  
  std::string text;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SelectOption::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SelectOption::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SelectOption::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SelectOption::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}










class  MlFieldPredictionLog {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<MlFieldPredictionLog, T>::value>;
  using DataView = MlFieldPredictionLogDataView;
  using Data_ = internal::MlFieldPredictionLog_Data;

  template <typename... Args>
  static MlFieldPredictionLogPtr New(Args&&... args) {
    return MlFieldPredictionLogPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static MlFieldPredictionLogPtr From(const U& u) {
    return mojo::TypeConverter<MlFieldPredictionLogPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, MlFieldPredictionLog>::Convert(*this);
  }


  MlFieldPredictionLog();

  MlFieldPredictionLog(
      const std::string& label,
      const std::string& placeholder,
      const std::string& name,
      const std::string& id,
      const std::string& autocomplete,
      const std::string& form_control_type,
      std::vector<SelectOptionPtr> select_options,
      std::optional<std::vector<float>> probabilities,
      std::vector<std::string> tokenized_field_representation);

MlFieldPredictionLog(const MlFieldPredictionLog&) = delete;
MlFieldPredictionLog& operator=(const MlFieldPredictionLog&) = delete;

  ~MlFieldPredictionLog();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = MlFieldPredictionLogPtr>
  MlFieldPredictionLogPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, MlFieldPredictionLog::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, MlFieldPredictionLog::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, MlFieldPredictionLog::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        MlFieldPredictionLog::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        MlFieldPredictionLog::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        MlFieldPredictionLog::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::MlFieldPredictionLog_UnserializedMessageContext<
            UserType, MlFieldPredictionLog::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<MlFieldPredictionLog::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return MlFieldPredictionLog::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::MlFieldPredictionLog_UnserializedMessageContext<
            UserType, MlFieldPredictionLog::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<MlFieldPredictionLog::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string label;
  
  std::string placeholder;
  
  std::string name;
  
  std::string id;
  
  std::string autocomplete;
  
  std::string form_control_type;
  
  std::vector<SelectOptionPtr> select_options;
  
  std::optional<std::vector<float>> probabilities;
  
  std::vector<std::string> tokenized_field_representation;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, MlFieldPredictionLog::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, MlFieldPredictionLog::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, MlFieldPredictionLog::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, MlFieldPredictionLog::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  MlPredictionLog {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<MlPredictionLog, T>::value>;
  using DataView = MlPredictionLogDataView;
  using Data_ = internal::MlPredictionLog_Data;

  template <typename... Args>
  static MlPredictionLogPtr New(Args&&... args) {
    return MlPredictionLogPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static MlPredictionLogPtr From(const U& u) {
    return mojo::TypeConverter<MlPredictionLogPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, MlPredictionLog>::Convert(*this);
  }


  MlPredictionLog();

  MlPredictionLog(
      const std::string& form_signature,
      const ::GURL& form_url,
      std::vector<std::string> model_output_types,
      std::vector<MlFieldPredictionLogPtr> field_predictions,
      ::base::Time start_time,
      ::base::Time end_time,
      ::base::TimeDelta duration,
      OptimizationTarget optimization_target);

MlPredictionLog(const MlPredictionLog&) = delete;
MlPredictionLog& operator=(const MlPredictionLog&) = delete;

  ~MlPredictionLog();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = MlPredictionLogPtr>
  MlPredictionLogPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, MlPredictionLog::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, MlPredictionLog::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, MlPredictionLog::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        MlPredictionLog::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        MlPredictionLog::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        MlPredictionLog::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::MlPredictionLog_UnserializedMessageContext<
            UserType, MlPredictionLog::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<MlPredictionLog::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return MlPredictionLog::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::MlPredictionLog_UnserializedMessageContext<
            UserType, MlPredictionLog::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<MlPredictionLog::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string form_signature;
  
  ::GURL form_url;
  
  std::vector<std::string> model_output_types;
  
  std::vector<MlFieldPredictionLogPtr> field_predictions;
  
  ::base::Time start_time;
  
  ::base::Time end_time;
  
  ::base::TimeDelta duration;
  
  OptimizationTarget optimization_target;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, MlPredictionLog::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, MlPredictionLog::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, MlPredictionLog::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, MlPredictionLog::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
SelectOptionPtr SelectOption::Clone() const {
  return New(
      mojo::Clone(value),
      mojo::Clone(text)
  );
}

template <typename T, SelectOption::EnableIfSame<T>*>
bool SelectOption::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->value, other_struct.value))
    return false;
  if (!mojo::Equals(this->text, other_struct.text))
    return false;
  return true;
}

template <typename T, SelectOption::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.value < rhs.value)
    return true;
  if (rhs.value < lhs.value)
    return false;
  if (lhs.text < rhs.text)
    return true;
  if (rhs.text < lhs.text)
    return false;
  return false;
}
template <typename StructPtrType>
MlFieldPredictionLogPtr MlFieldPredictionLog::Clone() const {
  return New(
      mojo::Clone(label),
      mojo::Clone(placeholder),
      mojo::Clone(name),
      mojo::Clone(id),
      mojo::Clone(autocomplete),
      mojo::Clone(form_control_type),
      mojo::Clone(select_options),
      mojo::Clone(probabilities),
      mojo::Clone(tokenized_field_representation)
  );
}

template <typename T, MlFieldPredictionLog::EnableIfSame<T>*>
bool MlFieldPredictionLog::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->label, other_struct.label))
    return false;
  if (!mojo::Equals(this->placeholder, other_struct.placeholder))
    return false;
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->autocomplete, other_struct.autocomplete))
    return false;
  if (!mojo::Equals(this->form_control_type, other_struct.form_control_type))
    return false;
  if (!mojo::Equals(this->select_options, other_struct.select_options))
    return false;
  if (!mojo::Equals(this->probabilities, other_struct.probabilities))
    return false;
  if (!mojo::Equals(this->tokenized_field_representation, other_struct.tokenized_field_representation))
    return false;
  return true;
}

template <typename T, MlFieldPredictionLog::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.label < rhs.label)
    return true;
  if (rhs.label < lhs.label)
    return false;
  if (lhs.placeholder < rhs.placeholder)
    return true;
  if (rhs.placeholder < lhs.placeholder)
    return false;
  if (lhs.name < rhs.name)
    return true;
  if (rhs.name < lhs.name)
    return false;
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.autocomplete < rhs.autocomplete)
    return true;
  if (rhs.autocomplete < lhs.autocomplete)
    return false;
  if (lhs.form_control_type < rhs.form_control_type)
    return true;
  if (rhs.form_control_type < lhs.form_control_type)
    return false;
  if (lhs.select_options < rhs.select_options)
    return true;
  if (rhs.select_options < lhs.select_options)
    return false;
  if (lhs.probabilities < rhs.probabilities)
    return true;
  if (rhs.probabilities < lhs.probabilities)
    return false;
  if (lhs.tokenized_field_representation < rhs.tokenized_field_representation)
    return true;
  if (rhs.tokenized_field_representation < lhs.tokenized_field_representation)
    return false;
  return false;
}
template <typename StructPtrType>
MlPredictionLogPtr MlPredictionLog::Clone() const {
  return New(
      mojo::Clone(form_signature),
      mojo::Clone(form_url),
      mojo::Clone(model_output_types),
      mojo::Clone(field_predictions),
      mojo::Clone(start_time),
      mojo::Clone(end_time),
      mojo::Clone(duration),
      mojo::Clone(optimization_target)
  );
}

template <typename T, MlPredictionLog::EnableIfSame<T>*>
bool MlPredictionLog::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->form_signature, other_struct.form_signature))
    return false;
  if (!mojo::Equals(this->form_url, other_struct.form_url))
    return false;
  if (!mojo::Equals(this->model_output_types, other_struct.model_output_types))
    return false;
  if (!mojo::Equals(this->field_predictions, other_struct.field_predictions))
    return false;
  if (!mojo::Equals(this->start_time, other_struct.start_time))
    return false;
  if (!mojo::Equals(this->end_time, other_struct.end_time))
    return false;
  if (!mojo::Equals(this->duration, other_struct.duration))
    return false;
  if (!mojo::Equals(this->optimization_target, other_struct.optimization_target))
    return false;
  return true;
}

template <typename T, MlPredictionLog::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.form_signature < rhs.form_signature)
    return true;
  if (rhs.form_signature < lhs.form_signature)
    return false;
  if (lhs.form_url < rhs.form_url)
    return true;
  if (rhs.form_url < lhs.form_url)
    return false;
  if (lhs.model_output_types < rhs.model_output_types)
    return true;
  if (rhs.model_output_types < lhs.model_output_types)
    return false;
  if (lhs.field_predictions < rhs.field_predictions)
    return true;
  if (rhs.field_predictions < lhs.field_predictions)
    return false;
  if (lhs.start_time < rhs.start_time)
    return true;
  if (rhs.start_time < lhs.start_time)
    return false;
  if (lhs.end_time < rhs.end_time)
    return true;
  if (rhs.end_time < lhs.end_time)
    return false;
  if (lhs.duration < rhs.duration)
    return true;
  if (rhs.duration < lhs.duration)
    return false;
  if (lhs.optimization_target < rhs.optimization_target)
    return true;
  if (rhs.optimization_target < lhs.optimization_target)
    return false;
  return false;
}


}  // autofill_ml_internals::mojom

namespace mojo {


template <>
struct  StructTraits<::autofill_ml_internals::mojom::SelectOption::DataView,
                                         ::autofill_ml_internals::mojom::SelectOptionPtr> {
  static bool IsNull(const ::autofill_ml_internals::mojom::SelectOptionPtr& input) { return !input; }
  static void SetToNull(::autofill_ml_internals::mojom::SelectOptionPtr* output) { output->reset(); }

  static const decltype(::autofill_ml_internals::mojom::SelectOption::value)& value(
      const ::autofill_ml_internals::mojom::SelectOptionPtr& input) {
    return input->value;
  }

  static const decltype(::autofill_ml_internals::mojom::SelectOption::text)& text(
      const ::autofill_ml_internals::mojom::SelectOptionPtr& input) {
    return input->text;
  }

  static bool Read(::autofill_ml_internals::mojom::SelectOption::DataView input, ::autofill_ml_internals::mojom::SelectOptionPtr* output);
};


template <>
struct  StructTraits<::autofill_ml_internals::mojom::MlFieldPredictionLog::DataView,
                                         ::autofill_ml_internals::mojom::MlFieldPredictionLogPtr> {
  static bool IsNull(const ::autofill_ml_internals::mojom::MlFieldPredictionLogPtr& input) { return !input; }
  static void SetToNull(::autofill_ml_internals::mojom::MlFieldPredictionLogPtr* output) { output->reset(); }

  static const decltype(::autofill_ml_internals::mojom::MlFieldPredictionLog::label)& label(
      const ::autofill_ml_internals::mojom::MlFieldPredictionLogPtr& input) {
    return input->label;
  }

  static const decltype(::autofill_ml_internals::mojom::MlFieldPredictionLog::placeholder)& placeholder(
      const ::autofill_ml_internals::mojom::MlFieldPredictionLogPtr& input) {
    return input->placeholder;
  }

  static const decltype(::autofill_ml_internals::mojom::MlFieldPredictionLog::name)& name(
      const ::autofill_ml_internals::mojom::MlFieldPredictionLogPtr& input) {
    return input->name;
  }

  static const decltype(::autofill_ml_internals::mojom::MlFieldPredictionLog::id)& id(
      const ::autofill_ml_internals::mojom::MlFieldPredictionLogPtr& input) {
    return input->id;
  }

  static const decltype(::autofill_ml_internals::mojom::MlFieldPredictionLog::autocomplete)& autocomplete(
      const ::autofill_ml_internals::mojom::MlFieldPredictionLogPtr& input) {
    return input->autocomplete;
  }

  static const decltype(::autofill_ml_internals::mojom::MlFieldPredictionLog::form_control_type)& form_control_type(
      const ::autofill_ml_internals::mojom::MlFieldPredictionLogPtr& input) {
    return input->form_control_type;
  }

  static const decltype(::autofill_ml_internals::mojom::MlFieldPredictionLog::select_options)& select_options(
      const ::autofill_ml_internals::mojom::MlFieldPredictionLogPtr& input) {
    return input->select_options;
  }

  static const decltype(::autofill_ml_internals::mojom::MlFieldPredictionLog::probabilities)& probabilities(
      const ::autofill_ml_internals::mojom::MlFieldPredictionLogPtr& input) {
    return input->probabilities;
  }

  static const decltype(::autofill_ml_internals::mojom::MlFieldPredictionLog::tokenized_field_representation)& tokenized_field_representation(
      const ::autofill_ml_internals::mojom::MlFieldPredictionLogPtr& input) {
    return input->tokenized_field_representation;
  }

  static bool Read(::autofill_ml_internals::mojom::MlFieldPredictionLog::DataView input, ::autofill_ml_internals::mojom::MlFieldPredictionLogPtr* output);
};


template <>
struct  StructTraits<::autofill_ml_internals::mojom::MlPredictionLog::DataView,
                                         ::autofill_ml_internals::mojom::MlPredictionLogPtr> {
  static bool IsNull(const ::autofill_ml_internals::mojom::MlPredictionLogPtr& input) { return !input; }
  static void SetToNull(::autofill_ml_internals::mojom::MlPredictionLogPtr* output) { output->reset(); }

  static const decltype(::autofill_ml_internals::mojom::MlPredictionLog::form_signature)& form_signature(
      const ::autofill_ml_internals::mojom::MlPredictionLogPtr& input) {
    return input->form_signature;
  }

  static const decltype(::autofill_ml_internals::mojom::MlPredictionLog::form_url)& form_url(
      const ::autofill_ml_internals::mojom::MlPredictionLogPtr& input) {
    return input->form_url;
  }

  static const decltype(::autofill_ml_internals::mojom::MlPredictionLog::model_output_types)& model_output_types(
      const ::autofill_ml_internals::mojom::MlPredictionLogPtr& input) {
    return input->model_output_types;
  }

  static const decltype(::autofill_ml_internals::mojom::MlPredictionLog::field_predictions)& field_predictions(
      const ::autofill_ml_internals::mojom::MlPredictionLogPtr& input) {
    return input->field_predictions;
  }

  static const decltype(::autofill_ml_internals::mojom::MlPredictionLog::start_time)& start_time(
      const ::autofill_ml_internals::mojom::MlPredictionLogPtr& input) {
    return input->start_time;
  }

  static const decltype(::autofill_ml_internals::mojom::MlPredictionLog::end_time)& end_time(
      const ::autofill_ml_internals::mojom::MlPredictionLogPtr& input) {
    return input->end_time;
  }

  static const decltype(::autofill_ml_internals::mojom::MlPredictionLog::duration)& duration(
      const ::autofill_ml_internals::mojom::MlPredictionLogPtr& input) {
    return input->duration;
  }

  static decltype(::autofill_ml_internals::mojom::MlPredictionLog::optimization_target) optimization_target(
      const ::autofill_ml_internals::mojom::MlPredictionLogPtr& input) {
    return input->optimization_target;
  }

  static bool Read(::autofill_ml_internals::mojom::MlPredictionLog::DataView input, ::autofill_ml_internals::mojom::MlPredictionLogPtr* output);
};

}  // namespace mojo

#endif  // COMPONENTS_AUTOFILL_CORE_BROWSER_ML_MODEL_LOGGING_AUTOFILL_ML_INTERNALS_MOJOM_H_