// components/autofill/content/common/mojom/autofill_driver.mojom-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_AUTOFILL_CONTENT_COMMON_MOJOM_AUTOFILL_DRIVER_MOJOM_TEST_UTILS_H_
#define COMPONENTS_AUTOFILL_CONTENT_COMMON_MOJOM_AUTOFILL_DRIVER_MOJOM_TEST_UTILS_H_

#include "components/autofill/content/common/mojom/autofill_driver.mojom.h"


namespace autofill::mojom {


class  AutofillDriverInterceptorForTesting : public AutofillDriver {
  virtual AutofillDriver* GetForwardingInterface() = 0;
  void FormsSeen(const std::vector<::autofill::FormData>& updated_forms, const std::vector<::autofill::FormRendererId>& removed_forms) override;
  void FormSubmitted(const ::autofill::FormData& form, ::autofill::mojom::SubmissionSource source) override;
  void CaretMovedInFormField(const ::autofill::FormData& form, ::autofill::FieldRendererId field_id, const ::gfx::Rect& caret_bounds) override;
  void TextFieldValueChanged(const ::autofill::FormData& form, ::autofill::FieldRendererId field_id, ::base::TimeTicks timestamp) override;
  void DidEndTextFieldEditing() override;
  void TextFieldDidScroll(const ::autofill::FormData& form, ::autofill::FieldRendererId field_id) override;
  void SelectControlSelectionChanged(const ::autofill::FormData& form, ::autofill::FieldRendererId field_id) override;
  void SelectFieldOptionsDidChange(const ::autofill::FormData& form) override;
  void FocusOnFormField(const ::autofill::FormData& form, ::autofill::FieldRendererId field_id) override;
  void FocusOnNonFormField() override;
  void AskForValuesToFill(const ::autofill::FormData& form, ::autofill::FieldRendererId field_id, const ::gfx::Rect& caret_bounds, ::autofill::mojom::AutofillSuggestionTriggerSource trigger_source, const std::optional<::autofill::PasswordSuggestionRequest>& password_request) override;
  void HidePopup() override;
  void DidAutofillForm(const ::autofill::FormData& form, ::base::TimeTicks timestamp) override;
  void JavaScriptChangedAutofilledValue(const ::autofill::FormData& form, ::autofill::FieldRendererId field_id, const ::std::u16string& old_value) override;
};
class  AutofillDriverAsyncWaiter {
 public:
  explicit AutofillDriverAsyncWaiter(AutofillDriver* proxy);

  AutofillDriverAsyncWaiter(const AutofillDriverAsyncWaiter&) = delete;
  AutofillDriverAsyncWaiter& operator=(const AutofillDriverAsyncWaiter&) = delete;

  ~AutofillDriverAsyncWaiter();

 private:
  AutofillDriver* const proxy_;
};


class  PasswordManagerDriverInterceptorForTesting : public PasswordManagerDriver {
  virtual PasswordManagerDriver* GetForwardingInterface() = 0;
  void PasswordFormsParsed(const std::vector<::autofill::FormData>& forms_data) override;
  void PasswordFormsRendered(const std::vector<::autofill::FormData>& visible_forms_data) override;
  void PasswordFormSubmitted(const ::autofill::FormData& form_data) override;
  void InformAboutUserInput(const ::autofill::FormData& form_data) override;
  void DynamicFormSubmission(::autofill::mojom::SubmissionIndicatorEvent submission_indication_event) override;
  void PasswordFormCleared(const ::autofill::FormData& form_data) override;
  void RecordSavePasswordProgress(const std::string& log) override;
  void UserModifiedPasswordField() override;
  void UserModifiedNonPasswordField(::autofill::FieldRendererId renderer_id, const ::std::u16string& value, bool autocomplete_attribute_has_username, bool is_likely_otp) override;
  void ShowPasswordSuggestions(const ::autofill::PasswordSuggestionRequest& request) override;
  void CheckSafeBrowsingReputation(const ::GURL& form_action, const ::GURL& frame_url) override;
  void FocusedInputChanged(::autofill::FieldRendererId focused_field_id, ::autofill::mojom::FocusedFieldType focused_field_type) override;
  void LogFirstFillingResult(::autofill::FormRendererId form_renderer_id, int32_t result) override;
};
class  PasswordManagerDriverAsyncWaiter {
 public:
  explicit PasswordManagerDriverAsyncWaiter(PasswordManagerDriver* proxy);

  PasswordManagerDriverAsyncWaiter(const PasswordManagerDriverAsyncWaiter&) = delete;
  PasswordManagerDriverAsyncWaiter& operator=(const PasswordManagerDriverAsyncWaiter&) = delete;

  ~PasswordManagerDriverAsyncWaiter();

 private:
  PasswordManagerDriver* const proxy_;
};


class  PasswordGenerationDriverInterceptorForTesting : public PasswordGenerationDriver {
  virtual PasswordGenerationDriver* GetForwardingInterface() = 0;
  void AutomaticGenerationAvailable(const ::autofill::password_generation::PasswordGenerationUIData& password_generation_ui_data) override;
  void PresaveGeneratedPassword(const ::autofill::FormData& form_data, const ::std::u16string& password_value) override;
  void PasswordNoLongerGenerated(const ::autofill::FormData& form_data) override;
  void ShowPasswordEditingPopup(const ::gfx::RectF& bounds, const ::autofill::FormData& form_data, ::autofill::FieldRendererId field_renderer_id, const ::std::u16string& password_value) override;
  void PasswordGenerationRejectedByTyping() override;
  void FrameWasScrolled() override;
  void GenerationElementLostFocus() override;
};
class  PasswordGenerationDriverAsyncWaiter {
 public:
  explicit PasswordGenerationDriverAsyncWaiter(PasswordGenerationDriver* proxy);

  PasswordGenerationDriverAsyncWaiter(const PasswordGenerationDriverAsyncWaiter&) = delete;
  PasswordGenerationDriverAsyncWaiter& operator=(const PasswordGenerationDriverAsyncWaiter&) = delete;

  ~PasswordGenerationDriverAsyncWaiter();

 private:
  PasswordGenerationDriver* const proxy_;
};




}  // autofill::mojom

#endif  // COMPONENTS_AUTOFILL_CONTENT_COMMON_MOJOM_AUTOFILL_DRIVER_MOJOM_TEST_UTILS_H_