// components/autofill/content/common/mojom/autofill_agent.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/autofill/content/common/mojom/autofill_agent.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/autofill/content/common/mojom/autofill_agent.mojom-params-data.h"
#include "components/autofill/content/common/mojom/autofill_agent.mojom-shared-message-ids.h"

#include "components/autofill/content/common/mojom/autofill_agent.mojom-import-headers.h"
#include "components/autofill/content/common/mojom/autofill_agent.mojom-test-utils.h"


namespace autofill::mojom {
// The declaration includes the definition on other builds.

AutofillAgent::IPCStableHashFunction AutofillAgent::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::AutofillAgent>(message.name())) {
    case messages::AutofillAgent::kTriggerFormExtraction: {
      return &AutofillAgent::TriggerFormExtraction_Sym::IPCStableHash;
    }
    case messages::AutofillAgent::kTriggerFormExtractionWithResponse: {
      return &AutofillAgent::TriggerFormExtractionWithResponse_Sym::IPCStableHash;
    }
    case messages::AutofillAgent::kApplyFieldsAction: {
      return &AutofillAgent::ApplyFieldsAction_Sym::IPCStableHash;
    }
    case messages::AutofillAgent::kApplyFieldAction: {
      return &AutofillAgent::ApplyFieldAction_Sym::IPCStableHash;
    }
    case messages::AutofillAgent::kExtractForm: {
      return &AutofillAgent::ExtractForm_Sym::IPCStableHash;
    }
    case messages::AutofillAgent::kExtractLabeledTextNodeValue: {
      return &AutofillAgent::ExtractLabeledTextNodeValue_Sym::IPCStableHash;
    }
    case messages::AutofillAgent::kFieldTypePredictionsAvailable: {
      return &AutofillAgent::FieldTypePredictionsAvailable_Sym::IPCStableHash;
    }
    case messages::AutofillAgent::kExposeDomNodeIds: {
      return &AutofillAgent::ExposeDomNodeIds_Sym::IPCStableHash;
    }
    case messages::AutofillAgent::kClearPreviewedForm: {
      return &AutofillAgent::ClearPreviewedForm_Sym::IPCStableHash;
    }
    case messages::AutofillAgent::kTriggerSuggestions: {
      return &AutofillAgent::TriggerSuggestions_Sym::IPCStableHash;
    }
    case messages::AutofillAgent::kSetSuggestionAvailability: {
      return &AutofillAgent::SetSuggestionAvailability_Sym::IPCStableHash;
    }
    case messages::AutofillAgent::kAcceptDataListSuggestion: {
      return &AutofillAgent::AcceptDataListSuggestion_Sym::IPCStableHash;
    }
    case messages::AutofillAgent::kPreviewPasswordSuggestion: {
      return &AutofillAgent::PreviewPasswordSuggestion_Sym::IPCStableHash;
    }
    case messages::AutofillAgent::kPreviewPasswordGenerationSuggestion: {
      return &AutofillAgent::PreviewPasswordGenerationSuggestion_Sym::IPCStableHash;
    }
    case messages::AutofillAgent::kGetPotentialLastFourCombinationsForStandaloneCvc: {
      return &AutofillAgent::GetPotentialLastFourCombinationsForStandaloneCvc_Sym::IPCStableHash;
    }
    case messages::AutofillAgent::kDispatchEmailVerifiedEvent: {
      return &AutofillAgent::DispatchEmailVerifiedEvent_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* AutofillAgent::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::AutofillAgent>(message.name())) {
      case messages::AutofillAgent::kTriggerFormExtraction:
            return "Receive autofill::mojom::AutofillAgent::TriggerFormExtraction";
      case messages::AutofillAgent::kTriggerFormExtractionWithResponse:
            return "Receive autofill::mojom::AutofillAgent::TriggerFormExtractionWithResponse";
      case messages::AutofillAgent::kApplyFieldsAction:
            return "Receive autofill::mojom::AutofillAgent::ApplyFieldsAction";
      case messages::AutofillAgent::kApplyFieldAction:
            return "Receive autofill::mojom::AutofillAgent::ApplyFieldAction";
      case messages::AutofillAgent::kExtractForm:
            return "Receive autofill::mojom::AutofillAgent::ExtractForm";
      case messages::AutofillAgent::kExtractLabeledTextNodeValue:
            return "Receive autofill::mojom::AutofillAgent::ExtractLabeledTextNodeValue";
      case messages::AutofillAgent::kFieldTypePredictionsAvailable:
            return "Receive autofill::mojom::AutofillAgent::FieldTypePredictionsAvailable";
      case messages::AutofillAgent::kExposeDomNodeIds:
            return "Receive autofill::mojom::AutofillAgent::ExposeDomNodeIds";
      case messages::AutofillAgent::kClearPreviewedForm:
            return "Receive autofill::mojom::AutofillAgent::ClearPreviewedForm";
      case messages::AutofillAgent::kTriggerSuggestions:
            return "Receive autofill::mojom::AutofillAgent::TriggerSuggestions";
      case messages::AutofillAgent::kSetSuggestionAvailability:
            return "Receive autofill::mojom::AutofillAgent::SetSuggestionAvailability";
      case messages::AutofillAgent::kAcceptDataListSuggestion:
            return "Receive autofill::mojom::AutofillAgent::AcceptDataListSuggestion";
      case messages::AutofillAgent::kPreviewPasswordSuggestion:
            return "Receive autofill::mojom::AutofillAgent::PreviewPasswordSuggestion";
      case messages::AutofillAgent::kPreviewPasswordGenerationSuggestion:
            return "Receive autofill::mojom::AutofillAgent::PreviewPasswordGenerationSuggestion";
      case messages::AutofillAgent::kGetPotentialLastFourCombinationsForStandaloneCvc:
            return "Receive autofill::mojom::AutofillAgent::GetPotentialLastFourCombinationsForStandaloneCvc";
      case messages::AutofillAgent::kDispatchEmailVerifiedEvent:
            return "Receive autofill::mojom::AutofillAgent::DispatchEmailVerifiedEvent";
    }
  } else {
    switch (static_cast<messages::AutofillAgent>(message.name())) {
      case messages::AutofillAgent::kTriggerFormExtraction:
            return "Receive reply autofill::mojom::AutofillAgent::TriggerFormExtraction";
      case messages::AutofillAgent::kTriggerFormExtractionWithResponse:
            return "Receive reply autofill::mojom::AutofillAgent::TriggerFormExtractionWithResponse";
      case messages::AutofillAgent::kApplyFieldsAction:
            return "Receive reply autofill::mojom::AutofillAgent::ApplyFieldsAction";
      case messages::AutofillAgent::kApplyFieldAction:
            return "Receive reply autofill::mojom::AutofillAgent::ApplyFieldAction";
      case messages::AutofillAgent::kExtractForm:
            return "Receive reply autofill::mojom::AutofillAgent::ExtractForm";
      case messages::AutofillAgent::kExtractLabeledTextNodeValue:
            return "Receive reply autofill::mojom::AutofillAgent::ExtractLabeledTextNodeValue";
      case messages::AutofillAgent::kFieldTypePredictionsAvailable:
            return "Receive reply autofill::mojom::AutofillAgent::FieldTypePredictionsAvailable";
      case messages::AutofillAgent::kExposeDomNodeIds:
            return "Receive reply autofill::mojom::AutofillAgent::ExposeDomNodeIds";
      case messages::AutofillAgent::kClearPreviewedForm:
            return "Receive reply autofill::mojom::AutofillAgent::ClearPreviewedForm";
      case messages::AutofillAgent::kTriggerSuggestions:
            return "Receive reply autofill::mojom::AutofillAgent::TriggerSuggestions";
      case messages::AutofillAgent::kSetSuggestionAvailability:
            return "Receive reply autofill::mojom::AutofillAgent::SetSuggestionAvailability";
      case messages::AutofillAgent::kAcceptDataListSuggestion:
            return "Receive reply autofill::mojom::AutofillAgent::AcceptDataListSuggestion";
      case messages::AutofillAgent::kPreviewPasswordSuggestion:
            return "Receive reply autofill::mojom::AutofillAgent::PreviewPasswordSuggestion";
      case messages::AutofillAgent::kPreviewPasswordGenerationSuggestion:
            return "Receive reply autofill::mojom::AutofillAgent::PreviewPasswordGenerationSuggestion";
      case messages::AutofillAgent::kGetPotentialLastFourCombinationsForStandaloneCvc:
            return "Receive reply autofill::mojom::AutofillAgent::GetPotentialLastFourCombinationsForStandaloneCvc";
      case messages::AutofillAgent::kDispatchEmailVerifiedEvent:
            return "Receive reply autofill::mojom::AutofillAgent::DispatchEmailVerifiedEvent";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t AutofillAgent::TriggerFormExtraction_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xbb636962;  // IPCStableHash for autofill::mojom::AutofillAgent::TriggerFormExtraction
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AutofillAgent::TriggerFormExtractionWithResponse_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb8cacc89;  // IPCStableHash for autofill::mojom::AutofillAgent::TriggerFormExtractionWithResponse
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AutofillAgent::ApplyFieldsAction_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd01dabd5;  // IPCStableHash for autofill::mojom::AutofillAgent::ApplyFieldsAction
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AutofillAgent::ApplyFieldAction_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x619dec03;  // IPCStableHash for autofill::mojom::AutofillAgent::ApplyFieldAction
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AutofillAgent::ExtractForm_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1b989857;  // IPCStableHash for autofill::mojom::AutofillAgent::ExtractForm
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AutofillAgent::ExtractLabeledTextNodeValue_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3642b25e;  // IPCStableHash for autofill::mojom::AutofillAgent::ExtractLabeledTextNodeValue
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AutofillAgent::FieldTypePredictionsAvailable_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1ab500ec;  // IPCStableHash for autofill::mojom::AutofillAgent::FieldTypePredictionsAvailable
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AutofillAgent::ExposeDomNodeIds_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x031d414c;  // IPCStableHash for autofill::mojom::AutofillAgent::ExposeDomNodeIds
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AutofillAgent::ClearPreviewedForm_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x99209d42;  // IPCStableHash for autofill::mojom::AutofillAgent::ClearPreviewedForm
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AutofillAgent::TriggerSuggestions_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf36c6964;  // IPCStableHash for autofill::mojom::AutofillAgent::TriggerSuggestions
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AutofillAgent::SetSuggestionAvailability_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x302c864a;  // IPCStableHash for autofill::mojom::AutofillAgent::SetSuggestionAvailability
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AutofillAgent::AcceptDataListSuggestion_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf5536c15;  // IPCStableHash for autofill::mojom::AutofillAgent::AcceptDataListSuggestion
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AutofillAgent::PreviewPasswordSuggestion_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb6788dfe;  // IPCStableHash for autofill::mojom::AutofillAgent::PreviewPasswordSuggestion
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AutofillAgent::PreviewPasswordGenerationSuggestion_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xdea3f619;  // IPCStableHash for autofill::mojom::AutofillAgent::PreviewPasswordGenerationSuggestion
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AutofillAgent::GetPotentialLastFourCombinationsForStandaloneCvc_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x8f074e3c;  // IPCStableHash for autofill::mojom::AutofillAgent::GetPotentialLastFourCombinationsForStandaloneCvc
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AutofillAgent::DispatchEmailVerifiedEvent_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe7b2005d;  // IPCStableHash for autofill::mojom::AutofillAgent::DispatchEmailVerifiedEvent
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class AutofillAgent_TriggerFormExtractionWithResponse_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  AutofillAgent_TriggerFormExtractionWithResponse_ForwardToCallback(
      AutofillAgent::TriggerFormExtractionWithResponseCallback callback
      ) : callback_(std::move(callback)) {
  }

  AutofillAgent_TriggerFormExtractionWithResponse_ForwardToCallback(const AutofillAgent_TriggerFormExtractionWithResponse_ForwardToCallback&) = delete;
  AutofillAgent_TriggerFormExtractionWithResponse_ForwardToCallback& operator=(const AutofillAgent_TriggerFormExtractionWithResponse_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  AutofillAgent::TriggerFormExtractionWithResponseCallback callback_;
};

class AutofillAgent_ExtractForm_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  AutofillAgent_ExtractForm_ForwardToCallback(
      AutofillAgent::ExtractFormCallback callback
      ) : callback_(std::move(callback)) {
  }

  AutofillAgent_ExtractForm_ForwardToCallback(const AutofillAgent_ExtractForm_ForwardToCallback&) = delete;
  AutofillAgent_ExtractForm_ForwardToCallback& operator=(const AutofillAgent_ExtractForm_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  AutofillAgent::ExtractFormCallback callback_;
};

class AutofillAgent_ExtractLabeledTextNodeValue_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  AutofillAgent_ExtractLabeledTextNodeValue_ForwardToCallback(
      AutofillAgent::ExtractLabeledTextNodeValueCallback callback
      ) : callback_(std::move(callback)) {
  }

  AutofillAgent_ExtractLabeledTextNodeValue_ForwardToCallback(const AutofillAgent_ExtractLabeledTextNodeValue_ForwardToCallback&) = delete;
  AutofillAgent_ExtractLabeledTextNodeValue_ForwardToCallback& operator=(const AutofillAgent_ExtractLabeledTextNodeValue_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  AutofillAgent::ExtractLabeledTextNodeValueCallback callback_;
};

class AutofillAgent_GetPotentialLastFourCombinationsForStandaloneCvc_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  AutofillAgent_GetPotentialLastFourCombinationsForStandaloneCvc_ForwardToCallback(
      AutofillAgent::GetPotentialLastFourCombinationsForStandaloneCvcCallback callback
      ) : callback_(std::move(callback)) {
  }

  AutofillAgent_GetPotentialLastFourCombinationsForStandaloneCvc_ForwardToCallback(const AutofillAgent_GetPotentialLastFourCombinationsForStandaloneCvc_ForwardToCallback&) = delete;
  AutofillAgent_GetPotentialLastFourCombinationsForStandaloneCvc_ForwardToCallback& operator=(const AutofillAgent_GetPotentialLastFourCombinationsForStandaloneCvc_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  AutofillAgent::GetPotentialLastFourCombinationsForStandaloneCvcCallback callback_;
};

AutofillAgentProxy::AutofillAgentProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void AutofillAgentProxy::TriggerFormExtraction(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send autofill::mojom::AutofillAgent::TriggerFormExtraction");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AutofillAgent::kTriggerFormExtraction), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::autofill::mojom::internal::AutofillAgent_TriggerFormExtraction_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AutofillAgent::Name_);
  message.set_method_name("TriggerFormExtraction");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AutofillAgentProxy::TriggerFormExtractionWithResponse(
    TriggerFormExtractionWithResponseCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send autofill::mojom::AutofillAgent::TriggerFormExtractionWithResponse");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AutofillAgent::kTriggerFormExtractionWithResponse), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::autofill::mojom::internal::AutofillAgent_TriggerFormExtractionWithResponse_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AutofillAgent::Name_);
  message.set_method_name("TriggerFormExtractionWithResponse");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new AutofillAgent_TriggerFormExtractionWithResponse_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void AutofillAgentProxy::ApplyFieldsAction(
    ::autofill::mojom::FormActionType in_action_type, ::autofill::mojom::ActionPersistence in_action_persistence, const std::vector<::autofill::FormFieldData::FillData>& in_fields) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send autofill::mojom::AutofillAgent::ApplyFieldsAction", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("action_type"), in_action_type,
                        "<value of type ::autofill::mojom::FormActionType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("action_persistence"), in_action_persistence,
                        "<value of type ::autofill::mojom::ActionPersistence>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("fields"), in_fields,
                        "<value of type const std::vector<::autofill::FormFieldData::FillData>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AutofillAgent::kApplyFieldsAction), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::autofill::mojom::internal::AutofillAgent_ApplyFieldsAction_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::autofill::mojom::FormActionType>(
    in_action_type,
    &params->action_type);

  
  mojo::internal::Serialize<::autofill::mojom::ActionPersistence>(
    in_action_persistence,
    &params->action_persistence);
  mojo::internal::MessageFragment<
      typename decltype(params->fields)::BaseType>
      fields_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& fields_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::autofill::mojom::FormFieldData_FillDataDataView>>(
    in_fields,
    fields_fragment,
    &fields_validate_params);

  params->fields.Set(
      fields_fragment.is_null() ? nullptr : fields_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->fields.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null fields in AutofillAgent.ApplyFieldsAction request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AutofillAgent::Name_);
  message.set_method_name("ApplyFieldsAction");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AutofillAgentProxy::ApplyFieldAction(
    ::autofill::mojom::FieldActionType in_action_type, ::autofill::mojom::ActionPersistence in_action_persistence, ::autofill::FieldRendererId in_field, const ::std::u16string& in_value) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send autofill::mojom::AutofillAgent::ApplyFieldAction", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("action_type"), in_action_type,
                        "<value of type ::autofill::mojom::FieldActionType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("action_persistence"), in_action_persistence,
                        "<value of type ::autofill::mojom::ActionPersistence>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("field"), in_field,
                        "<value of type ::autofill::FieldRendererId>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("value"), in_value,
                        "<value of type const ::std::u16string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AutofillAgent::kApplyFieldAction), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::autofill::mojom::internal::AutofillAgent_ApplyFieldAction_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::autofill::mojom::FieldActionType>(
    in_action_type,
    &params->action_type);

  
  mojo::internal::Serialize<::autofill::mojom::ActionPersistence>(
    in_action_persistence,
    &params->action_persistence);
  mojo::internal::MessageFragment<
      typename decltype(params->field)::BaseType> field_fragment(
          params.message());
  
  mojo::internal::Serialize<::autofill::mojom::FieldRendererIdDataView>(
    in_field,
    field_fragment);

  params->field.Set(
      field_fragment.is_null() ? nullptr : field_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->field.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null field in AutofillAgent.ApplyFieldAction request");
  mojo::internal::MessageFragment<
      typename decltype(params->value)::BaseType> value_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    in_value,
    value_fragment);

  params->value.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->value.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null value in AutofillAgent.ApplyFieldAction request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AutofillAgent::Name_);
  message.set_method_name("ApplyFieldAction");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AutofillAgentProxy::ExtractForm(
    ::autofill::FormRendererId in_form, ExtractFormCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send autofill::mojom::AutofillAgent::ExtractForm", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("form"), in_form,
                        "<value of type ::autofill::FormRendererId>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AutofillAgent::kExtractForm), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::autofill::mojom::internal::AutofillAgent_ExtractForm_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->form)::BaseType> form_fragment(
          params.message());
  
  mojo::internal::Serialize<::autofill::mojom::FormRendererIdDataView>(
    in_form,
    form_fragment);

  params->form.Set(
      form_fragment.is_null() ? nullptr : form_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->form.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null form in AutofillAgent.ExtractForm request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AutofillAgent::Name_);
  message.set_method_name("ExtractForm");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new AutofillAgent_ExtractForm_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void AutofillAgentProxy::ExtractLabeledTextNodeValue(
    const ::std::u16string& in_value_regex, const ::std::u16string& in_label_regex, uint32_t in_number_of_ancestor_levels_to_search, ExtractLabeledTextNodeValueCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send autofill::mojom::AutofillAgent::ExtractLabeledTextNodeValue", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("value_regex"), in_value_regex,
                        "<value of type const ::std::u16string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("label_regex"), in_label_regex,
                        "<value of type const ::std::u16string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("number_of_ancestor_levels_to_search"), in_number_of_ancestor_levels_to_search,
                        "<value of type uint32_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AutofillAgent::kExtractLabeledTextNodeValue), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::autofill::mojom::internal::AutofillAgent_ExtractLabeledTextNodeValue_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->value_regex)::BaseType> value_regex_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    in_value_regex,
    value_regex_fragment);

  params->value_regex.Set(
      value_regex_fragment.is_null() ? nullptr : value_regex_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->value_regex.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null value_regex in AutofillAgent.ExtractLabeledTextNodeValue request");
  mojo::internal::MessageFragment<
      typename decltype(params->label_regex)::BaseType> label_regex_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    in_label_regex,
    label_regex_fragment);

  params->label_regex.Set(
      label_regex_fragment.is_null() ? nullptr : label_regex_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->label_regex.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null label_regex in AutofillAgent.ExtractLabeledTextNodeValue request");

  params->number_of_ancestor_levels_to_search = in_number_of_ancestor_levels_to_search;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AutofillAgent::Name_);
  message.set_method_name("ExtractLabeledTextNodeValue");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new AutofillAgent_ExtractLabeledTextNodeValue_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void AutofillAgentProxy::FieldTypePredictionsAvailable(
    const std::vector<::autofill::FormDataPredictions>& in_forms) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send autofill::mojom::AutofillAgent::FieldTypePredictionsAvailable", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("forms"), in_forms,
                        "<value of type const std::vector<::autofill::FormDataPredictions>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AutofillAgent::kFieldTypePredictionsAvailable), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::autofill::mojom::internal::AutofillAgent_FieldTypePredictionsAvailable_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->forms)::BaseType>
      forms_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& forms_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::autofill::mojom::FormDataPredictionsDataView>>(
    in_forms,
    forms_fragment,
    &forms_validate_params);

  params->forms.Set(
      forms_fragment.is_null() ? nullptr : forms_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->forms.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null forms in AutofillAgent.FieldTypePredictionsAvailable request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AutofillAgent::Name_);
  message.set_method_name("FieldTypePredictionsAvailable");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AutofillAgentProxy::ExposeDomNodeIds(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send autofill::mojom::AutofillAgent::ExposeDomNodeIds");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AutofillAgent::kExposeDomNodeIds), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::autofill::mojom::internal::AutofillAgent_ExposeDomNodeIds_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AutofillAgent::Name_);
  message.set_method_name("ExposeDomNodeIds");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AutofillAgentProxy::ClearPreviewedForm(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send autofill::mojom::AutofillAgent::ClearPreviewedForm");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AutofillAgent::kClearPreviewedForm), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::autofill::mojom::internal::AutofillAgent_ClearPreviewedForm_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AutofillAgent::Name_);
  message.set_method_name("ClearPreviewedForm");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AutofillAgentProxy::TriggerSuggestions(
    ::autofill::FieldRendererId in_field, ::autofill::mojom::AutofillSuggestionTriggerSource in_trigger_source) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send autofill::mojom::AutofillAgent::TriggerSuggestions", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("field"), in_field,
                        "<value of type ::autofill::FieldRendererId>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("trigger_source"), in_trigger_source,
                        "<value of type ::autofill::mojom::AutofillSuggestionTriggerSource>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AutofillAgent::kTriggerSuggestions), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::autofill::mojom::internal::AutofillAgent_TriggerSuggestions_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->field)::BaseType> field_fragment(
          params.message());
  
  mojo::internal::Serialize<::autofill::mojom::FieldRendererIdDataView>(
    in_field,
    field_fragment);

  params->field.Set(
      field_fragment.is_null() ? nullptr : field_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->field.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null field in AutofillAgent.TriggerSuggestions request");

  
  mojo::internal::Serialize<::autofill::mojom::AutofillSuggestionTriggerSource>(
    in_trigger_source,
    &params->trigger_source);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AutofillAgent::Name_);
  message.set_method_name("TriggerSuggestions");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AutofillAgentProxy::SetSuggestionAvailability(
    ::autofill::FieldRendererId in_field, ::autofill::mojom::AutofillSuggestionAvailability in_suggestion_availability) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send autofill::mojom::AutofillAgent::SetSuggestionAvailability", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("field"), in_field,
                        "<value of type ::autofill::FieldRendererId>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("suggestion_availability"), in_suggestion_availability,
                        "<value of type ::autofill::mojom::AutofillSuggestionAvailability>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AutofillAgent::kSetSuggestionAvailability), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::autofill::mojom::internal::AutofillAgent_SetSuggestionAvailability_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->field)::BaseType> field_fragment(
          params.message());
  
  mojo::internal::Serialize<::autofill::mojom::FieldRendererIdDataView>(
    in_field,
    field_fragment);

  params->field.Set(
      field_fragment.is_null() ? nullptr : field_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->field.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null field in AutofillAgent.SetSuggestionAvailability request");

  
  mojo::internal::Serialize<::autofill::mojom::AutofillSuggestionAvailability>(
    in_suggestion_availability,
    &params->suggestion_availability);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AutofillAgent::Name_);
  message.set_method_name("SetSuggestionAvailability");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AutofillAgentProxy::AcceptDataListSuggestion(
    ::autofill::FieldRendererId in_field, const ::std::u16string& in_value) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send autofill::mojom::AutofillAgent::AcceptDataListSuggestion", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("field"), in_field,
                        "<value of type ::autofill::FieldRendererId>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("value"), in_value,
                        "<value of type const ::std::u16string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AutofillAgent::kAcceptDataListSuggestion), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::autofill::mojom::internal::AutofillAgent_AcceptDataListSuggestion_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->field)::BaseType> field_fragment(
          params.message());
  
  mojo::internal::Serialize<::autofill::mojom::FieldRendererIdDataView>(
    in_field,
    field_fragment);

  params->field.Set(
      field_fragment.is_null() ? nullptr : field_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->field.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null field in AutofillAgent.AcceptDataListSuggestion request");
  mojo::internal::MessageFragment<
      typename decltype(params->value)::BaseType> value_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    in_value,
    value_fragment);

  params->value.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->value.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null value in AutofillAgent.AcceptDataListSuggestion request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AutofillAgent::Name_);
  message.set_method_name("AcceptDataListSuggestion");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AutofillAgentProxy::PreviewPasswordSuggestion(
    const ::std::u16string& in_username, const ::std::u16string& in_password) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send autofill::mojom::AutofillAgent::PreviewPasswordSuggestion", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("username"), in_username,
                        "<value of type const ::std::u16string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("password"), in_password,
                        "<value of type const ::std::u16string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AutofillAgent::kPreviewPasswordSuggestion), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::autofill::mojom::internal::AutofillAgent_PreviewPasswordSuggestion_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->username)::BaseType> username_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    in_username,
    username_fragment);

  params->username.Set(
      username_fragment.is_null() ? nullptr : username_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->username.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null username in AutofillAgent.PreviewPasswordSuggestion request");
  mojo::internal::MessageFragment<
      typename decltype(params->password)::BaseType> password_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    in_password,
    password_fragment);

  params->password.Set(
      password_fragment.is_null() ? nullptr : password_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->password.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null password in AutofillAgent.PreviewPasswordSuggestion request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AutofillAgent::Name_);
  message.set_method_name("PreviewPasswordSuggestion");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AutofillAgentProxy::PreviewPasswordGenerationSuggestion(
    const ::std::u16string& in_password) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send autofill::mojom::AutofillAgent::PreviewPasswordGenerationSuggestion", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("password"), in_password,
                        "<value of type const ::std::u16string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AutofillAgent::kPreviewPasswordGenerationSuggestion), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::autofill::mojom::internal::AutofillAgent_PreviewPasswordGenerationSuggestion_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->password)::BaseType> password_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    in_password,
    password_fragment);

  params->password.Set(
      password_fragment.is_null() ? nullptr : password_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->password.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null password in AutofillAgent.PreviewPasswordGenerationSuggestion request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AutofillAgent::Name_);
  message.set_method_name("PreviewPasswordGenerationSuggestion");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AutofillAgentProxy::GetPotentialLastFourCombinationsForStandaloneCvc(
    GetPotentialLastFourCombinationsForStandaloneCvcCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send autofill::mojom::AutofillAgent::GetPotentialLastFourCombinationsForStandaloneCvc");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AutofillAgent::kGetPotentialLastFourCombinationsForStandaloneCvc), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::autofill::mojom::internal::AutofillAgent_GetPotentialLastFourCombinationsForStandaloneCvc_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AutofillAgent::Name_);
  message.set_method_name("GetPotentialLastFourCombinationsForStandaloneCvc");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new AutofillAgent_GetPotentialLastFourCombinationsForStandaloneCvc_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void AutofillAgentProxy::DispatchEmailVerifiedEvent(
    ::autofill::FieldRendererId in_field_id, const std::string& in_presentation_token) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send autofill::mojom::AutofillAgent::DispatchEmailVerifiedEvent", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("field_id"), in_field_id,
                        "<value of type ::autofill::FieldRendererId>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("presentation_token"), in_presentation_token,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AutofillAgent::kDispatchEmailVerifiedEvent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::autofill::mojom::internal::AutofillAgent_DispatchEmailVerifiedEvent_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->field_id)::BaseType> field_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::autofill::mojom::FieldRendererIdDataView>(
    in_field_id,
    field_id_fragment);

  params->field_id.Set(
      field_id_fragment.is_null() ? nullptr : field_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->field_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null field_id in AutofillAgent.DispatchEmailVerifiedEvent request");
  mojo::internal::MessageFragment<
      typename decltype(params->presentation_token)::BaseType> presentation_token_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_presentation_token,
    presentation_token_fragment);

  params->presentation_token.Set(
      presentation_token_fragment.is_null() ? nullptr : presentation_token_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->presentation_token.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null presentation_token in AutofillAgent.DispatchEmailVerifiedEvent request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AutofillAgent::Name_);
  message.set_method_name("DispatchEmailVerifiedEvent");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class AutofillAgent_TriggerFormExtractionWithResponse_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static AutofillAgent::TriggerFormExtractionWithResponseCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<AutofillAgent_TriggerFormExtractionWithResponse_ProxyToResponder> proxy(
        new AutofillAgent_TriggerFormExtractionWithResponse_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&AutofillAgent_TriggerFormExtractionWithResponse_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~AutofillAgent_TriggerFormExtractionWithResponse_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  AutofillAgent_TriggerFormExtractionWithResponse_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "AutofillAgent::TriggerFormExtractionWithResponseCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);
};

bool AutofillAgent_TriggerFormExtractionWithResponse_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::AutofillAgent_TriggerFormExtractionWithResponse_ResponseParams_Data* params =
      reinterpret_cast<
          internal::AutofillAgent_TriggerFormExtractionWithResponse_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for AutofillAgent.1
  bool success = true;
  bool p_success{};
  AutofillAgent_TriggerFormExtractionWithResponse_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        AutofillAgent::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success));
  }
  return true;
}

void AutofillAgent_TriggerFormExtractionWithResponse_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply autofill::mojom::AutofillAgent::TriggerFormExtractionWithResponse", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AutofillAgent::kTriggerFormExtractionWithResponse), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::autofill::mojom::internal::AutofillAgent_TriggerFormExtractionWithResponse_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AutofillAgent::Name_);
  message.set_method_name("TriggerFormExtractionWithResponse");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class AutofillAgent_ExtractForm_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static AutofillAgent::ExtractFormCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<AutofillAgent_ExtractForm_ProxyToResponder> proxy(
        new AutofillAgent_ExtractForm_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&AutofillAgent_ExtractForm_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~AutofillAgent_ExtractForm_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  AutofillAgent_ExtractForm_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "AutofillAgent::ExtractFormCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::optional<::autofill::FormData>& in_form);
};

bool AutofillAgent_ExtractForm_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::AutofillAgent_ExtractForm_ResponseParams_Data* params =
      reinterpret_cast<
          internal::AutofillAgent_ExtractForm_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for AutofillAgent.4
  bool success = true;
  std::optional<::autofill::FormData> p_form{};
  AutofillAgent_ExtractForm_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadForm(&p_form))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        AutofillAgent::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_form));
  }
  return true;
}

void AutofillAgent_ExtractForm_ProxyToResponder::Run(
    const std::optional<::autofill::FormData>& in_form) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply autofill::mojom::AutofillAgent::ExtractForm", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("form"), in_form,
                        "<value of type const std::optional<::autofill::FormData>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AutofillAgent::kExtractForm), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::autofill::mojom::internal::AutofillAgent_ExtractForm_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->form)::BaseType> form_fragment(
          params.message());
  
  mojo::internal::Serialize<::autofill::mojom::FormDataDataView>(
    in_form,
    form_fragment);

  params->form.Set(
      form_fragment.is_null() ? nullptr : form_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AutofillAgent::Name_);
  message.set_method_name("ExtractForm");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class AutofillAgent_ExtractLabeledTextNodeValue_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static AutofillAgent::ExtractLabeledTextNodeValueCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<AutofillAgent_ExtractLabeledTextNodeValue_ProxyToResponder> proxy(
        new AutofillAgent_ExtractLabeledTextNodeValue_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&AutofillAgent_ExtractLabeledTextNodeValue_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~AutofillAgent_ExtractLabeledTextNodeValue_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  AutofillAgent_ExtractLabeledTextNodeValue_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "AutofillAgent::ExtractLabeledTextNodeValueCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::string& in_value);
};

bool AutofillAgent_ExtractLabeledTextNodeValue_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::AutofillAgent_ExtractLabeledTextNodeValue_ResponseParams_Data* params =
      reinterpret_cast<
          internal::AutofillAgent_ExtractLabeledTextNodeValue_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for AutofillAgent.5
  bool success = true;
  std::string p_value{};
  AutofillAgent_ExtractLabeledTextNodeValue_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadValue(&p_value))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        AutofillAgent::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_value));
  }
  return true;
}

void AutofillAgent_ExtractLabeledTextNodeValue_ProxyToResponder::Run(
    const std::string& in_value) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply autofill::mojom::AutofillAgent::ExtractLabeledTextNodeValue", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("value"), in_value,
                        "<value of type const std::string&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AutofillAgent::kExtractLabeledTextNodeValue), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::autofill::mojom::internal::AutofillAgent_ExtractLabeledTextNodeValue_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->value)::BaseType> value_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_value,
    value_fragment);

  params->value.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->value.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null value in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AutofillAgent::Name_);
  message.set_method_name("ExtractLabeledTextNodeValue");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class AutofillAgent_GetPotentialLastFourCombinationsForStandaloneCvc_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static AutofillAgent::GetPotentialLastFourCombinationsForStandaloneCvcCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<AutofillAgent_GetPotentialLastFourCombinationsForStandaloneCvc_ProxyToResponder> proxy(
        new AutofillAgent_GetPotentialLastFourCombinationsForStandaloneCvc_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&AutofillAgent_GetPotentialLastFourCombinationsForStandaloneCvc_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~AutofillAgent_GetPotentialLastFourCombinationsForStandaloneCvc_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  AutofillAgent_GetPotentialLastFourCombinationsForStandaloneCvc_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "AutofillAgent::GetPotentialLastFourCombinationsForStandaloneCvcCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::vector<std::string>& in_potential_matches);
};

bool AutofillAgent_GetPotentialLastFourCombinationsForStandaloneCvc_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::AutofillAgent_GetPotentialLastFourCombinationsForStandaloneCvc_ResponseParams_Data* params =
      reinterpret_cast<
          internal::AutofillAgent_GetPotentialLastFourCombinationsForStandaloneCvc_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for AutofillAgent.14
  bool success = true;
  std::vector<std::string> p_potential_matches{};
  AutofillAgent_GetPotentialLastFourCombinationsForStandaloneCvc_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadPotentialMatches(&p_potential_matches))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        AutofillAgent::Name_, 14, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_potential_matches));
  }
  return true;
}

void AutofillAgent_GetPotentialLastFourCombinationsForStandaloneCvc_ProxyToResponder::Run(
    const std::vector<std::string>& in_potential_matches) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply autofill::mojom::AutofillAgent::GetPotentialLastFourCombinationsForStandaloneCvc", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("potential_matches"), in_potential_matches,
                        "<value of type const std::vector<std::string>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AutofillAgent::kGetPotentialLastFourCombinationsForStandaloneCvc), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::autofill::mojom::internal::AutofillAgent_GetPotentialLastFourCombinationsForStandaloneCvc_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->potential_matches)::BaseType>
      potential_matches_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& potential_matches_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
    in_potential_matches,
    potential_matches_fragment,
    &potential_matches_validate_params);

  params->potential_matches.Set(
      potential_matches_fragment.is_null() ? nullptr : potential_matches_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->potential_matches.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null potential_matches in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AutofillAgent::Name_);
  message.set_method_name("GetPotentialLastFourCombinationsForStandaloneCvc");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool AutofillAgentStubDispatch::Accept(
    AutofillAgent* impl,
    mojo::Message* message) {
  switch (static_cast<messages::AutofillAgent>(message->header()->name)) {
    case messages::AutofillAgent::kTriggerFormExtraction: {
      DCHECK(message->is_serialized());
      internal::AutofillAgent_TriggerFormExtraction_Params_Data* params =
          reinterpret_cast<internal::AutofillAgent_TriggerFormExtraction_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AutofillAgent.0
      bool success = true;
      AutofillAgent_TriggerFormExtraction_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AutofillAgent::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->TriggerFormExtraction(        );
      return true;
    }
    case messages::AutofillAgent::kTriggerFormExtractionWithResponse: {
      break;
    }
    case messages::AutofillAgent::kApplyFieldsAction: {
      DCHECK(message->is_serialized());
      internal::AutofillAgent_ApplyFieldsAction_Params_Data* params =
          reinterpret_cast<internal::AutofillAgent_ApplyFieldsAction_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AutofillAgent.2
      bool success = true;
      ::autofill::mojom::FormActionType p_action_type{};
      ::autofill::mojom::ActionPersistence p_action_persistence{};
      std::vector<::autofill::FormFieldData::FillData> p_fields{};
      AutofillAgent_ApplyFieldsAction_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadActionType(&p_action_type))
        success = false;
      if (success && !input_data_view.ReadActionPersistence(&p_action_persistence))
        success = false;
      if (success && !input_data_view.ReadFields(&p_fields))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AutofillAgent::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ApplyFieldsAction(        
        std::move(p_action_type), 
        std::move(p_action_persistence), 
        std::move(p_fields));
      return true;
    }
    case messages::AutofillAgent::kApplyFieldAction: {
      DCHECK(message->is_serialized());
      internal::AutofillAgent_ApplyFieldAction_Params_Data* params =
          reinterpret_cast<internal::AutofillAgent_ApplyFieldAction_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AutofillAgent.3
      bool success = true;
      ::autofill::mojom::FieldActionType p_action_type{};
      ::autofill::mojom::ActionPersistence p_action_persistence{};
      ::autofill::FieldRendererId p_field{};
      ::std::u16string p_value{};
      AutofillAgent_ApplyFieldAction_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadActionType(&p_action_type))
        success = false;
      if (success && !input_data_view.ReadActionPersistence(&p_action_persistence))
        success = false;
      if (success && !input_data_view.ReadField(&p_field))
        success = false;
      if (success && !input_data_view.ReadValue(&p_value))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AutofillAgent::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ApplyFieldAction(        
        std::move(p_action_type), 
        std::move(p_action_persistence), 
        std::move(p_field), 
        std::move(p_value));
      return true;
    }
    case messages::AutofillAgent::kExtractForm: {
      break;
    }
    case messages::AutofillAgent::kExtractLabeledTextNodeValue: {
      break;
    }
    case messages::AutofillAgent::kFieldTypePredictionsAvailable: {
      DCHECK(message->is_serialized());
      internal::AutofillAgent_FieldTypePredictionsAvailable_Params_Data* params =
          reinterpret_cast<internal::AutofillAgent_FieldTypePredictionsAvailable_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AutofillAgent.6
      bool success = true;
      std::vector<::autofill::FormDataPredictions> p_forms{};
      AutofillAgent_FieldTypePredictionsAvailable_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadForms(&p_forms))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AutofillAgent::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->FieldTypePredictionsAvailable(        
        std::move(p_forms));
      return true;
    }
    case messages::AutofillAgent::kExposeDomNodeIds: {
      DCHECK(message->is_serialized());
      internal::AutofillAgent_ExposeDomNodeIds_Params_Data* params =
          reinterpret_cast<internal::AutofillAgent_ExposeDomNodeIds_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AutofillAgent.7
      bool success = true;
      AutofillAgent_ExposeDomNodeIds_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AutofillAgent::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ExposeDomNodeIds(        );
      return true;
    }
    case messages::AutofillAgent::kClearPreviewedForm: {
      DCHECK(message->is_serialized());
      internal::AutofillAgent_ClearPreviewedForm_Params_Data* params =
          reinterpret_cast<internal::AutofillAgent_ClearPreviewedForm_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AutofillAgent.8
      bool success = true;
      AutofillAgent_ClearPreviewedForm_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AutofillAgent::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ClearPreviewedForm(        );
      return true;
    }
    case messages::AutofillAgent::kTriggerSuggestions: {
      DCHECK(message->is_serialized());
      internal::AutofillAgent_TriggerSuggestions_Params_Data* params =
          reinterpret_cast<internal::AutofillAgent_TriggerSuggestions_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AutofillAgent.9
      bool success = true;
      ::autofill::FieldRendererId p_field{};
      ::autofill::mojom::AutofillSuggestionTriggerSource p_trigger_source{};
      AutofillAgent_TriggerSuggestions_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadField(&p_field))
        success = false;
      if (success && !input_data_view.ReadTriggerSource(&p_trigger_source))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AutofillAgent::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->TriggerSuggestions(        
        std::move(p_field), 
        std::move(p_trigger_source));
      return true;
    }
    case messages::AutofillAgent::kSetSuggestionAvailability: {
      DCHECK(message->is_serialized());
      internal::AutofillAgent_SetSuggestionAvailability_Params_Data* params =
          reinterpret_cast<internal::AutofillAgent_SetSuggestionAvailability_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AutofillAgent.10
      bool success = true;
      ::autofill::FieldRendererId p_field{};
      ::autofill::mojom::AutofillSuggestionAvailability p_suggestion_availability{};
      AutofillAgent_SetSuggestionAvailability_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadField(&p_field))
        success = false;
      if (success && !input_data_view.ReadSuggestionAvailability(&p_suggestion_availability))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AutofillAgent::Name_, 10, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetSuggestionAvailability(        
        std::move(p_field), 
        std::move(p_suggestion_availability));
      return true;
    }
    case messages::AutofillAgent::kAcceptDataListSuggestion: {
      DCHECK(message->is_serialized());
      internal::AutofillAgent_AcceptDataListSuggestion_Params_Data* params =
          reinterpret_cast<internal::AutofillAgent_AcceptDataListSuggestion_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AutofillAgent.11
      bool success = true;
      ::autofill::FieldRendererId p_field{};
      ::std::u16string p_value{};
      AutofillAgent_AcceptDataListSuggestion_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadField(&p_field))
        success = false;
      if (success && !input_data_view.ReadValue(&p_value))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AutofillAgent::Name_, 11, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AcceptDataListSuggestion(        
        std::move(p_field), 
        std::move(p_value));
      return true;
    }
    case messages::AutofillAgent::kPreviewPasswordSuggestion: {
      DCHECK(message->is_serialized());
      internal::AutofillAgent_PreviewPasswordSuggestion_Params_Data* params =
          reinterpret_cast<internal::AutofillAgent_PreviewPasswordSuggestion_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AutofillAgent.12
      bool success = true;
      ::std::u16string p_username{};
      ::std::u16string p_password{};
      AutofillAgent_PreviewPasswordSuggestion_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUsername(&p_username))
        success = false;
      if (success && !input_data_view.ReadPassword(&p_password))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AutofillAgent::Name_, 12, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PreviewPasswordSuggestion(        
        std::move(p_username), 
        std::move(p_password));
      return true;
    }
    case messages::AutofillAgent::kPreviewPasswordGenerationSuggestion: {
      DCHECK(message->is_serialized());
      internal::AutofillAgent_PreviewPasswordGenerationSuggestion_Params_Data* params =
          reinterpret_cast<internal::AutofillAgent_PreviewPasswordGenerationSuggestion_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AutofillAgent.13
      bool success = true;
      ::std::u16string p_password{};
      AutofillAgent_PreviewPasswordGenerationSuggestion_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPassword(&p_password))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AutofillAgent::Name_, 13, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PreviewPasswordGenerationSuggestion(        
        std::move(p_password));
      return true;
    }
    case messages::AutofillAgent::kGetPotentialLastFourCombinationsForStandaloneCvc: {
      break;
    }
    case messages::AutofillAgent::kDispatchEmailVerifiedEvent: {
      DCHECK(message->is_serialized());
      internal::AutofillAgent_DispatchEmailVerifiedEvent_Params_Data* params =
          reinterpret_cast<internal::AutofillAgent_DispatchEmailVerifiedEvent_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AutofillAgent.15
      bool success = true;
      ::autofill::FieldRendererId p_field_id{};
      std::string p_presentation_token{};
      AutofillAgent_DispatchEmailVerifiedEvent_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFieldId(&p_field_id))
        success = false;
      if (success && !input_data_view.ReadPresentationToken(&p_presentation_token))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AutofillAgent::Name_, 15, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DispatchEmailVerifiedEvent(        
        std::move(p_field_id), 
        std::move(p_presentation_token));
      return true;
    }
  }
  return false;
}

// static
bool AutofillAgentStubDispatch::AcceptWithResponder(
    AutofillAgent* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::AutofillAgent>(message->header()->name)) {
    case messages::AutofillAgent::kTriggerFormExtraction: {
      break;
    }
    case messages::AutofillAgent::kTriggerFormExtractionWithResponse: {
      internal::AutofillAgent_TriggerFormExtractionWithResponse_Params_Data* params =
          reinterpret_cast<
              internal::AutofillAgent_TriggerFormExtractionWithResponse_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for AutofillAgent.1
      bool success = true;
      AutofillAgent_TriggerFormExtractionWithResponse_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AutofillAgent::Name_, 1, false);
        return false;
      }
      auto callback =
          AutofillAgent_TriggerFormExtractionWithResponse_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->TriggerFormExtractionWithResponse(std::move(callback));
      return true;
    }
    case messages::AutofillAgent::kApplyFieldsAction: {
      break;
    }
    case messages::AutofillAgent::kApplyFieldAction: {
      break;
    }
    case messages::AutofillAgent::kExtractForm: {
      internal::AutofillAgent_ExtractForm_Params_Data* params =
          reinterpret_cast<
              internal::AutofillAgent_ExtractForm_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for AutofillAgent.4
      bool success = true;
      ::autofill::FormRendererId p_form{};
      AutofillAgent_ExtractForm_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadForm(&p_form))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AutofillAgent::Name_, 4, false);
        return false;
      }
      auto callback =
          AutofillAgent_ExtractForm_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ExtractForm(        
        std::move(p_form), std::move(callback));
      return true;
    }
    case messages::AutofillAgent::kExtractLabeledTextNodeValue: {
      internal::AutofillAgent_ExtractLabeledTextNodeValue_Params_Data* params =
          reinterpret_cast<
              internal::AutofillAgent_ExtractLabeledTextNodeValue_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for AutofillAgent.5
      bool success = true;
      ::std::u16string p_value_regex{};
      ::std::u16string p_label_regex{};
      uint32_t p_number_of_ancestor_levels_to_search{};
      AutofillAgent_ExtractLabeledTextNodeValue_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadValueRegex(&p_value_regex))
        success = false;
      if (success && !input_data_view.ReadLabelRegex(&p_label_regex))
        success = false;
      if (success)
        p_number_of_ancestor_levels_to_search = input_data_view.number_of_ancestor_levels_to_search();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AutofillAgent::Name_, 5, false);
        return false;
      }
      auto callback =
          AutofillAgent_ExtractLabeledTextNodeValue_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ExtractLabeledTextNodeValue(        
        std::move(p_value_regex), 
        std::move(p_label_regex), 
        std::move(p_number_of_ancestor_levels_to_search), std::move(callback));
      return true;
    }
    case messages::AutofillAgent::kFieldTypePredictionsAvailable: {
      break;
    }
    case messages::AutofillAgent::kExposeDomNodeIds: {
      break;
    }
    case messages::AutofillAgent::kClearPreviewedForm: {
      break;
    }
    case messages::AutofillAgent::kTriggerSuggestions: {
      break;
    }
    case messages::AutofillAgent::kSetSuggestionAvailability: {
      break;
    }
    case messages::AutofillAgent::kAcceptDataListSuggestion: {
      break;
    }
    case messages::AutofillAgent::kPreviewPasswordSuggestion: {
      break;
    }
    case messages::AutofillAgent::kPreviewPasswordGenerationSuggestion: {
      break;
    }
    case messages::AutofillAgent::kGetPotentialLastFourCombinationsForStandaloneCvc: {
      internal::AutofillAgent_GetPotentialLastFourCombinationsForStandaloneCvc_Params_Data* params =
          reinterpret_cast<
              internal::AutofillAgent_GetPotentialLastFourCombinationsForStandaloneCvc_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for AutofillAgent.14
      bool success = true;
      AutofillAgent_GetPotentialLastFourCombinationsForStandaloneCvc_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AutofillAgent::Name_, 14, false);
        return false;
      }
      auto callback =
          AutofillAgent_GetPotentialLastFourCombinationsForStandaloneCvc_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetPotentialLastFourCombinationsForStandaloneCvc(std::move(callback));
      return true;
    }
    case messages::AutofillAgent::kDispatchEmailVerifiedEvent: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kAutofillAgentValidationInfo[] = {
    { &internal::AutofillAgent_TriggerFormExtraction_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::AutofillAgent_TriggerFormExtractionWithResponse_Params_Data::Validate,
     &internal::AutofillAgent_TriggerFormExtractionWithResponse_ResponseParams_Data::Validate},
    { &internal::AutofillAgent_ApplyFieldsAction_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::AutofillAgent_ApplyFieldAction_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::AutofillAgent_ExtractForm_Params_Data::Validate,
     &internal::AutofillAgent_ExtractForm_ResponseParams_Data::Validate},
    { &internal::AutofillAgent_ExtractLabeledTextNodeValue_Params_Data::Validate,
     &internal::AutofillAgent_ExtractLabeledTextNodeValue_ResponseParams_Data::Validate},
    { &internal::AutofillAgent_FieldTypePredictionsAvailable_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::AutofillAgent_ExposeDomNodeIds_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::AutofillAgent_ClearPreviewedForm_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::AutofillAgent_TriggerSuggestions_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::AutofillAgent_SetSuggestionAvailability_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::AutofillAgent_AcceptDataListSuggestion_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::AutofillAgent_PreviewPasswordSuggestion_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::AutofillAgent_PreviewPasswordGenerationSuggestion_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::AutofillAgent_GetPotentialLastFourCombinationsForStandaloneCvc_Params_Data::Validate,
     &internal::AutofillAgent_GetPotentialLastFourCombinationsForStandaloneCvc_ResponseParams_Data::Validate},
    { &internal::AutofillAgent_DispatchEmailVerifiedEvent_Params_Data::Validate,
     nullptr /* no response */},
};

bool AutofillAgentRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::autofill::mojom::AutofillAgent::Name_,
    kAutofillAgentValidationInfo);
}

bool AutofillAgentResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::autofill::mojom::AutofillAgent::Name_,
    kAutofillAgentValidationInfo);
}
// The declaration includes the definition on other builds.

PasswordAutofillAgent::IPCStableHashFunction PasswordAutofillAgent::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PasswordAutofillAgent>(message.name())) {
    case messages::PasswordAutofillAgent::kApplyFillDataOnParsingCompletion: {
      return &PasswordAutofillAgent::ApplyFillDataOnParsingCompletion_Sym::IPCStableHash;
    }
    case messages::PasswordAutofillAgent::kFillPasswordSuggestion: {
      return &PasswordAutofillAgent::FillPasswordSuggestion_Sym::IPCStableHash;
    }
    case messages::PasswordAutofillAgent::kFillPasswordSuggestionById: {
      return &PasswordAutofillAgent::FillPasswordSuggestionById_Sym::IPCStableHash;
    }
    case messages::PasswordAutofillAgent::kPreviewPasswordSuggestionById: {
      return &PasswordAutofillAgent::PreviewPasswordSuggestionById_Sym::IPCStableHash;
    }
    case messages::PasswordAutofillAgent::kInformNoSavedCredentials: {
      return &PasswordAutofillAgent::InformNoSavedCredentials_Sym::IPCStableHash;
    }
    case messages::PasswordAutofillAgent::kFillIntoFocusedField: {
      return &PasswordAutofillAgent::FillIntoFocusedField_Sym::IPCStableHash;
    }
    case messages::PasswordAutofillAgent::kPreviewField: {
      return &PasswordAutofillAgent::PreviewField_Sym::IPCStableHash;
    }
    case messages::PasswordAutofillAgent::kFillField: {
      return &PasswordAutofillAgent::FillField_Sym::IPCStableHash;
    }
    case messages::PasswordAutofillAgent::kFillChangePasswordForm: {
      return &PasswordAutofillAgent::FillChangePasswordForm_Sym::IPCStableHash;
    }
    case messages::PasswordAutofillAgent::kSubmitFormWithEnter: {
      return &PasswordAutofillAgent::SubmitFormWithEnter_Sym::IPCStableHash;
    }
    case messages::PasswordAutofillAgent::kSetLoggingState: {
      return &PasswordAutofillAgent::SetLoggingState_Sym::IPCStableHash;
    }
    case messages::PasswordAutofillAgent::kAnnotateFieldsWithParsingResult: {
      return &PasswordAutofillAgent::AnnotateFieldsWithParsingResult_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PasswordAutofillAgent::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PasswordAutofillAgent>(message.name())) {
      case messages::PasswordAutofillAgent::kApplyFillDataOnParsingCompletion:
            return "Receive autofill::mojom::PasswordAutofillAgent::ApplyFillDataOnParsingCompletion";
      case messages::PasswordAutofillAgent::kFillPasswordSuggestion:
            return "Receive autofill::mojom::PasswordAutofillAgent::FillPasswordSuggestion";
      case messages::PasswordAutofillAgent::kFillPasswordSuggestionById:
            return "Receive autofill::mojom::PasswordAutofillAgent::FillPasswordSuggestionById";
      case messages::PasswordAutofillAgent::kPreviewPasswordSuggestionById:
            return "Receive autofill::mojom::PasswordAutofillAgent::PreviewPasswordSuggestionById";
      case messages::PasswordAutofillAgent::kInformNoSavedCredentials:
            return "Receive autofill::mojom::PasswordAutofillAgent::InformNoSavedCredentials";
      case messages::PasswordAutofillAgent::kFillIntoFocusedField:
            return "Receive autofill::mojom::PasswordAutofillAgent::FillIntoFocusedField";
      case messages::PasswordAutofillAgent::kPreviewField:
            return "Receive autofill::mojom::PasswordAutofillAgent::PreviewField";
      case messages::PasswordAutofillAgent::kFillField:
            return "Receive autofill::mojom::PasswordAutofillAgent::FillField";
      case messages::PasswordAutofillAgent::kFillChangePasswordForm:
            return "Receive autofill::mojom::PasswordAutofillAgent::FillChangePasswordForm";
      case messages::PasswordAutofillAgent::kSubmitFormWithEnter:
            return "Receive autofill::mojom::PasswordAutofillAgent::SubmitFormWithEnter";
      case messages::PasswordAutofillAgent::kSetLoggingState:
            return "Receive autofill::mojom::PasswordAutofillAgent::SetLoggingState";
      case messages::PasswordAutofillAgent::kAnnotateFieldsWithParsingResult:
            return "Receive autofill::mojom::PasswordAutofillAgent::AnnotateFieldsWithParsingResult";
    }
  } else {
    switch (static_cast<messages::PasswordAutofillAgent>(message.name())) {
      case messages::PasswordAutofillAgent::kApplyFillDataOnParsingCompletion:
            return "Receive reply autofill::mojom::PasswordAutofillAgent::ApplyFillDataOnParsingCompletion";
      case messages::PasswordAutofillAgent::kFillPasswordSuggestion:
            return "Receive reply autofill::mojom::PasswordAutofillAgent::FillPasswordSuggestion";
      case messages::PasswordAutofillAgent::kFillPasswordSuggestionById:
            return "Receive reply autofill::mojom::PasswordAutofillAgent::FillPasswordSuggestionById";
      case messages::PasswordAutofillAgent::kPreviewPasswordSuggestionById:
            return "Receive reply autofill::mojom::PasswordAutofillAgent::PreviewPasswordSuggestionById";
      case messages::PasswordAutofillAgent::kInformNoSavedCredentials:
            return "Receive reply autofill::mojom::PasswordAutofillAgent::InformNoSavedCredentials";
      case messages::PasswordAutofillAgent::kFillIntoFocusedField:
            return "Receive reply autofill::mojom::PasswordAutofillAgent::FillIntoFocusedField";
      case messages::PasswordAutofillAgent::kPreviewField:
            return "Receive reply autofill::mojom::PasswordAutofillAgent::PreviewField";
      case messages::PasswordAutofillAgent::kFillField:
            return "Receive reply autofill::mojom::PasswordAutofillAgent::FillField";
      case messages::PasswordAutofillAgent::kFillChangePasswordForm:
            return "Receive reply autofill::mojom::PasswordAutofillAgent::FillChangePasswordForm";
      case messages::PasswordAutofillAgent::kSubmitFormWithEnter:
            return "Receive reply autofill::mojom::PasswordAutofillAgent::SubmitFormWithEnter";
      case messages::PasswordAutofillAgent::kSetLoggingState:
            return "Receive reply autofill::mojom::PasswordAutofillAgent::SetLoggingState";
      case messages::PasswordAutofillAgent::kAnnotateFieldsWithParsingResult:
            return "Receive reply autofill::mojom::PasswordAutofillAgent::AnnotateFieldsWithParsingResult";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PasswordAutofillAgent::ApplyFillDataOnParsingCompletion_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xcab605b4;  // IPCStableHash for autofill::mojom::PasswordAutofillAgent::ApplyFillDataOnParsingCompletion
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PasswordAutofillAgent::FillPasswordSuggestion_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf55be0f7;  // IPCStableHash for autofill::mojom::PasswordAutofillAgent::FillPasswordSuggestion
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PasswordAutofillAgent::FillPasswordSuggestionById_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xcfe61647;  // IPCStableHash for autofill::mojom::PasswordAutofillAgent::FillPasswordSuggestionById
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PasswordAutofillAgent::PreviewPasswordSuggestionById_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa528d3f0;  // IPCStableHash for autofill::mojom::PasswordAutofillAgent::PreviewPasswordSuggestionById
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PasswordAutofillAgent::InformNoSavedCredentials_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd4a05310;  // IPCStableHash for autofill::mojom::PasswordAutofillAgent::InformNoSavedCredentials
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PasswordAutofillAgent::FillIntoFocusedField_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7020890d;  // IPCStableHash for autofill::mojom::PasswordAutofillAgent::FillIntoFocusedField
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PasswordAutofillAgent::PreviewField_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x73b646f2;  // IPCStableHash for autofill::mojom::PasswordAutofillAgent::PreviewField
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PasswordAutofillAgent::FillField_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1f1f4e92;  // IPCStableHash for autofill::mojom::PasswordAutofillAgent::FillField
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PasswordAutofillAgent::FillChangePasswordForm_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb0304e6e;  // IPCStableHash for autofill::mojom::PasswordAutofillAgent::FillChangePasswordForm
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PasswordAutofillAgent::SubmitFormWithEnter_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x27c2c4ee;  // IPCStableHash for autofill::mojom::PasswordAutofillAgent::SubmitFormWithEnter
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PasswordAutofillAgent::SetLoggingState_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xcced4410;  // IPCStableHash for autofill::mojom::PasswordAutofillAgent::SetLoggingState
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PasswordAutofillAgent::AnnotateFieldsWithParsingResult_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x702a41e4;  // IPCStableHash for autofill::mojom::PasswordAutofillAgent::AnnotateFieldsWithParsingResult
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class PasswordAutofillAgent_FillPasswordSuggestion_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PasswordAutofillAgent_FillPasswordSuggestion_ForwardToCallback(
      PasswordAutofillAgent::FillPasswordSuggestionCallback callback
      ) : callback_(std::move(callback)) {
  }

  PasswordAutofillAgent_FillPasswordSuggestion_ForwardToCallback(const PasswordAutofillAgent_FillPasswordSuggestion_ForwardToCallback&) = delete;
  PasswordAutofillAgent_FillPasswordSuggestion_ForwardToCallback& operator=(const PasswordAutofillAgent_FillPasswordSuggestion_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PasswordAutofillAgent::FillPasswordSuggestionCallback callback_;
};

class PasswordAutofillAgent_FillField_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PasswordAutofillAgent_FillField_ForwardToCallback(
      PasswordAutofillAgent::FillFieldCallback callback
      ) : callback_(std::move(callback)) {
  }

  PasswordAutofillAgent_FillField_ForwardToCallback(const PasswordAutofillAgent_FillField_ForwardToCallback&) = delete;
  PasswordAutofillAgent_FillField_ForwardToCallback& operator=(const PasswordAutofillAgent_FillField_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PasswordAutofillAgent::FillFieldCallback callback_;
};

class PasswordAutofillAgent_FillChangePasswordForm_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PasswordAutofillAgent_FillChangePasswordForm_ForwardToCallback(
      PasswordAutofillAgent::FillChangePasswordFormCallback callback
      ) : callback_(std::move(callback)) {
  }

  PasswordAutofillAgent_FillChangePasswordForm_ForwardToCallback(const PasswordAutofillAgent_FillChangePasswordForm_ForwardToCallback&) = delete;
  PasswordAutofillAgent_FillChangePasswordForm_ForwardToCallback& operator=(const PasswordAutofillAgent_FillChangePasswordForm_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PasswordAutofillAgent::FillChangePasswordFormCallback callback_;
};

class PasswordAutofillAgent_SubmitFormWithEnter_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PasswordAutofillAgent_SubmitFormWithEnter_ForwardToCallback(
      PasswordAutofillAgent::SubmitFormWithEnterCallback callback
      ) : callback_(std::move(callback)) {
  }

  PasswordAutofillAgent_SubmitFormWithEnter_ForwardToCallback(const PasswordAutofillAgent_SubmitFormWithEnter_ForwardToCallback&) = delete;
  PasswordAutofillAgent_SubmitFormWithEnter_ForwardToCallback& operator=(const PasswordAutofillAgent_SubmitFormWithEnter_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PasswordAutofillAgent::SubmitFormWithEnterCallback callback_;
};

PasswordAutofillAgentProxy::PasswordAutofillAgentProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PasswordAutofillAgentProxy::ApplyFillDataOnParsingCompletion(
    const ::autofill::PasswordFormFillData& in_form_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send autofill::mojom::PasswordAutofillAgent::ApplyFillDataOnParsingCompletion", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("form_data"), in_form_data,
                        "<value of type const ::autofill::PasswordFormFillData&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PasswordAutofillAgent::kApplyFillDataOnParsingCompletion), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::autofill::mojom::internal::PasswordAutofillAgent_ApplyFillDataOnParsingCompletion_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->form_data)::BaseType> form_data_fragment(
          params.message());
  
  mojo::internal::Serialize<::autofill::mojom::PasswordFormFillDataDataView>(
    in_form_data,
    form_data_fragment);

  params->form_data.Set(
      form_data_fragment.is_null() ? nullptr : form_data_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->form_data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null form_data in PasswordAutofillAgent.ApplyFillDataOnParsingCompletion request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PasswordAutofillAgent::Name_);
  message.set_method_name("ApplyFillDataOnParsingCompletion");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PasswordAutofillAgentProxy::FillPasswordSuggestion(
    const ::std::u16string& in_username, const ::std::u16string& in_password, FillPasswordSuggestionCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send autofill::mojom::PasswordAutofillAgent::FillPasswordSuggestion", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("username"), in_username,
                        "<value of type const ::std::u16string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("password"), in_password,
                        "<value of type const ::std::u16string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PasswordAutofillAgent::kFillPasswordSuggestion), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::autofill::mojom::internal::PasswordAutofillAgent_FillPasswordSuggestion_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->username)::BaseType> username_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    in_username,
    username_fragment);

  params->username.Set(
      username_fragment.is_null() ? nullptr : username_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->username.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null username in PasswordAutofillAgent.FillPasswordSuggestion request");
  mojo::internal::MessageFragment<
      typename decltype(params->password)::BaseType> password_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    in_password,
    password_fragment);

  params->password.Set(
      password_fragment.is_null() ? nullptr : password_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->password.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null password in PasswordAutofillAgent.FillPasswordSuggestion request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PasswordAutofillAgent::Name_);
  message.set_method_name("FillPasswordSuggestion");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PasswordAutofillAgent_FillPasswordSuggestion_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PasswordAutofillAgentProxy::FillPasswordSuggestionById(
    ::autofill::FieldRendererId in_username_element_id, ::autofill::FieldRendererId in_password_element_id, const ::std::u16string& in_username, const ::std::u16string& in_password, ::autofill::mojom::AutofillSuggestionTriggerSource in_suggestion_source) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send autofill::mojom::PasswordAutofillAgent::FillPasswordSuggestionById", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("username_element_id"), in_username_element_id,
                        "<value of type ::autofill::FieldRendererId>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("password_element_id"), in_password_element_id,
                        "<value of type ::autofill::FieldRendererId>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("username"), in_username,
                        "<value of type const ::std::u16string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("password"), in_password,
                        "<value of type const ::std::u16string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("suggestion_source"), in_suggestion_source,
                        "<value of type ::autofill::mojom::AutofillSuggestionTriggerSource>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PasswordAutofillAgent::kFillPasswordSuggestionById), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::autofill::mojom::internal::PasswordAutofillAgent_FillPasswordSuggestionById_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->username_element_id)::BaseType> username_element_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::autofill::mojom::FieldRendererIdDataView>(
    in_username_element_id,
    username_element_id_fragment);

  params->username_element_id.Set(
      username_element_id_fragment.is_null() ? nullptr : username_element_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->username_element_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null username_element_id in PasswordAutofillAgent.FillPasswordSuggestionById request");
  mojo::internal::MessageFragment<
      typename decltype(params->password_element_id)::BaseType> password_element_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::autofill::mojom::FieldRendererIdDataView>(
    in_password_element_id,
    password_element_id_fragment);

  params->password_element_id.Set(
      password_element_id_fragment.is_null() ? nullptr : password_element_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->password_element_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null password_element_id in PasswordAutofillAgent.FillPasswordSuggestionById request");
  mojo::internal::MessageFragment<
      typename decltype(params->username)::BaseType> username_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    in_username,
    username_fragment);

  params->username.Set(
      username_fragment.is_null() ? nullptr : username_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->username.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null username in PasswordAutofillAgent.FillPasswordSuggestionById request");
  mojo::internal::MessageFragment<
      typename decltype(params->password)::BaseType> password_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    in_password,
    password_fragment);

  params->password.Set(
      password_fragment.is_null() ? nullptr : password_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->password.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null password in PasswordAutofillAgent.FillPasswordSuggestionById request");

  
  mojo::internal::Serialize<::autofill::mojom::AutofillSuggestionTriggerSource>(
    in_suggestion_source,
    &params->suggestion_source);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PasswordAutofillAgent::Name_);
  message.set_method_name("FillPasswordSuggestionById");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PasswordAutofillAgentProxy::PreviewPasswordSuggestionById(
    ::autofill::FieldRendererId in_username_element_id, ::autofill::FieldRendererId in_password_element_id, const ::std::u16string& in_username, const ::std::u16string& in_password) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send autofill::mojom::PasswordAutofillAgent::PreviewPasswordSuggestionById", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("username_element_id"), in_username_element_id,
                        "<value of type ::autofill::FieldRendererId>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("password_element_id"), in_password_element_id,
                        "<value of type ::autofill::FieldRendererId>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("username"), in_username,
                        "<value of type const ::std::u16string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("password"), in_password,
                        "<value of type const ::std::u16string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PasswordAutofillAgent::kPreviewPasswordSuggestionById), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::autofill::mojom::internal::PasswordAutofillAgent_PreviewPasswordSuggestionById_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->username_element_id)::BaseType> username_element_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::autofill::mojom::FieldRendererIdDataView>(
    in_username_element_id,
    username_element_id_fragment);

  params->username_element_id.Set(
      username_element_id_fragment.is_null() ? nullptr : username_element_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->username_element_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null username_element_id in PasswordAutofillAgent.PreviewPasswordSuggestionById request");
  mojo::internal::MessageFragment<
      typename decltype(params->password_element_id)::BaseType> password_element_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::autofill::mojom::FieldRendererIdDataView>(
    in_password_element_id,
    password_element_id_fragment);

  params->password_element_id.Set(
      password_element_id_fragment.is_null() ? nullptr : password_element_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->password_element_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null password_element_id in PasswordAutofillAgent.PreviewPasswordSuggestionById request");
  mojo::internal::MessageFragment<
      typename decltype(params->username)::BaseType> username_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    in_username,
    username_fragment);

  params->username.Set(
      username_fragment.is_null() ? nullptr : username_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->username.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null username in PasswordAutofillAgent.PreviewPasswordSuggestionById request");
  mojo::internal::MessageFragment<
      typename decltype(params->password)::BaseType> password_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    in_password,
    password_fragment);

  params->password.Set(
      password_fragment.is_null() ? nullptr : password_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->password.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null password in PasswordAutofillAgent.PreviewPasswordSuggestionById request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PasswordAutofillAgent::Name_);
  message.set_method_name("PreviewPasswordSuggestionById");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PasswordAutofillAgentProxy::InformNoSavedCredentials(
    bool in_should_show_popup_without_passwords) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send autofill::mojom::PasswordAutofillAgent::InformNoSavedCredentials", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("should_show_popup_without_passwords"), in_should_show_popup_without_passwords,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PasswordAutofillAgent::kInformNoSavedCredentials), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::autofill::mojom::internal::PasswordAutofillAgent_InformNoSavedCredentials_Params_Data> params(
          message);
  params.Allocate();

  params->should_show_popup_without_passwords = in_should_show_popup_without_passwords;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PasswordAutofillAgent::Name_);
  message.set_method_name("InformNoSavedCredentials");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PasswordAutofillAgentProxy::FillIntoFocusedField(
    bool in_is_password, const ::std::u16string& in_credential) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send autofill::mojom::PasswordAutofillAgent::FillIntoFocusedField", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_password"), in_is_password,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("credential"), in_credential,
                        "<value of type const ::std::u16string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PasswordAutofillAgent::kFillIntoFocusedField), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::autofill::mojom::internal::PasswordAutofillAgent_FillIntoFocusedField_Params_Data> params(
          message);
  params.Allocate();

  params->is_password = in_is_password;
  mojo::internal::MessageFragment<
      typename decltype(params->credential)::BaseType> credential_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    in_credential,
    credential_fragment);

  params->credential.Set(
      credential_fragment.is_null() ? nullptr : credential_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->credential.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null credential in PasswordAutofillAgent.FillIntoFocusedField request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PasswordAutofillAgent::Name_);
  message.set_method_name("FillIntoFocusedField");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PasswordAutofillAgentProxy::PreviewField(
    ::autofill::FieldRendererId in_field_id, const ::std::u16string& in_value) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send autofill::mojom::PasswordAutofillAgent::PreviewField", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("field_id"), in_field_id,
                        "<value of type ::autofill::FieldRendererId>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("value"), in_value,
                        "<value of type const ::std::u16string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PasswordAutofillAgent::kPreviewField), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::autofill::mojom::internal::PasswordAutofillAgent_PreviewField_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->field_id)::BaseType> field_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::autofill::mojom::FieldRendererIdDataView>(
    in_field_id,
    field_id_fragment);

  params->field_id.Set(
      field_id_fragment.is_null() ? nullptr : field_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->field_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null field_id in PasswordAutofillAgent.PreviewField request");
  mojo::internal::MessageFragment<
      typename decltype(params->value)::BaseType> value_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    in_value,
    value_fragment);

  params->value.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->value.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null value in PasswordAutofillAgent.PreviewField request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PasswordAutofillAgent::Name_);
  message.set_method_name("PreviewField");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PasswordAutofillAgentProxy::FillField(
    ::autofill::FieldRendererId in_field_id, const ::std::u16string& in_value, uint32_t in_field_properties, FillFieldCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send autofill::mojom::PasswordAutofillAgent::FillField", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("field_id"), in_field_id,
                        "<value of type ::autofill::FieldRendererId>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("value"), in_value,
                        "<value of type const ::std::u16string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("field_properties"), in_field_properties,
                        "<value of type uint32_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PasswordAutofillAgent::kFillField), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::autofill::mojom::internal::PasswordAutofillAgent_FillField_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->field_id)::BaseType> field_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::autofill::mojom::FieldRendererIdDataView>(
    in_field_id,
    field_id_fragment);

  params->field_id.Set(
      field_id_fragment.is_null() ? nullptr : field_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->field_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null field_id in PasswordAutofillAgent.FillField request");
  mojo::internal::MessageFragment<
      typename decltype(params->value)::BaseType> value_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    in_value,
    value_fragment);

  params->value.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->value.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null value in PasswordAutofillAgent.FillField request");

  params->field_properties = in_field_properties;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PasswordAutofillAgent::Name_);
  message.set_method_name("FillField");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PasswordAutofillAgent_FillField_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PasswordAutofillAgentProxy::FillChangePasswordForm(
    ::autofill::FieldRendererId in_password_element_id, ::autofill::FieldRendererId in_new_password_element_id, ::autofill::FieldRendererId in_confirm_password_element_id, const ::std::u16string& in_old_password, const ::std::u16string& in_new_password, FillChangePasswordFormCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send autofill::mojom::PasswordAutofillAgent::FillChangePasswordForm", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("password_element_id"), in_password_element_id,
                        "<value of type ::autofill::FieldRendererId>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("new_password_element_id"), in_new_password_element_id,
                        "<value of type ::autofill::FieldRendererId>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("confirm_password_element_id"), in_confirm_password_element_id,
                        "<value of type ::autofill::FieldRendererId>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("old_password"), in_old_password,
                        "<value of type const ::std::u16string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("new_password"), in_new_password,
                        "<value of type const ::std::u16string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PasswordAutofillAgent::kFillChangePasswordForm), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::autofill::mojom::internal::PasswordAutofillAgent_FillChangePasswordForm_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->password_element_id)::BaseType> password_element_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::autofill::mojom::FieldRendererIdDataView>(
    in_password_element_id,
    password_element_id_fragment);

  params->password_element_id.Set(
      password_element_id_fragment.is_null() ? nullptr : password_element_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->password_element_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null password_element_id in PasswordAutofillAgent.FillChangePasswordForm request");
  mojo::internal::MessageFragment<
      typename decltype(params->new_password_element_id)::BaseType> new_password_element_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::autofill::mojom::FieldRendererIdDataView>(
    in_new_password_element_id,
    new_password_element_id_fragment);

  params->new_password_element_id.Set(
      new_password_element_id_fragment.is_null() ? nullptr : new_password_element_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->new_password_element_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null new_password_element_id in PasswordAutofillAgent.FillChangePasswordForm request");
  mojo::internal::MessageFragment<
      typename decltype(params->confirm_password_element_id)::BaseType> confirm_password_element_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::autofill::mojom::FieldRendererIdDataView>(
    in_confirm_password_element_id,
    confirm_password_element_id_fragment);

  params->confirm_password_element_id.Set(
      confirm_password_element_id_fragment.is_null() ? nullptr : confirm_password_element_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->confirm_password_element_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null confirm_password_element_id in PasswordAutofillAgent.FillChangePasswordForm request");
  mojo::internal::MessageFragment<
      typename decltype(params->old_password)::BaseType> old_password_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    in_old_password,
    old_password_fragment);

  params->old_password.Set(
      old_password_fragment.is_null() ? nullptr : old_password_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->old_password.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null old_password in PasswordAutofillAgent.FillChangePasswordForm request");
  mojo::internal::MessageFragment<
      typename decltype(params->new_password)::BaseType> new_password_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    in_new_password,
    new_password_fragment);

  params->new_password.Set(
      new_password_fragment.is_null() ? nullptr : new_password_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->new_password.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null new_password in PasswordAutofillAgent.FillChangePasswordForm request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PasswordAutofillAgent::Name_);
  message.set_method_name("FillChangePasswordForm");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PasswordAutofillAgent_FillChangePasswordForm_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PasswordAutofillAgentProxy::SubmitFormWithEnter(
    ::autofill::FieldRendererId in_field_id, SubmitFormWithEnterCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send autofill::mojom::PasswordAutofillAgent::SubmitFormWithEnter", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("field_id"), in_field_id,
                        "<value of type ::autofill::FieldRendererId>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PasswordAutofillAgent::kSubmitFormWithEnter), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::autofill::mojom::internal::PasswordAutofillAgent_SubmitFormWithEnter_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->field_id)::BaseType> field_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::autofill::mojom::FieldRendererIdDataView>(
    in_field_id,
    field_id_fragment);

  params->field_id.Set(
      field_id_fragment.is_null() ? nullptr : field_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->field_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null field_id in PasswordAutofillAgent.SubmitFormWithEnter request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PasswordAutofillAgent::Name_);
  message.set_method_name("SubmitFormWithEnter");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PasswordAutofillAgent_SubmitFormWithEnter_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PasswordAutofillAgentProxy::SetLoggingState(
    bool in_active) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send autofill::mojom::PasswordAutofillAgent::SetLoggingState", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("active"), in_active,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PasswordAutofillAgent::kSetLoggingState), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::autofill::mojom::internal::PasswordAutofillAgent_SetLoggingState_Params_Data> params(
          message);
  params.Allocate();

  params->active = in_active;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PasswordAutofillAgent::Name_);
  message.set_method_name("SetLoggingState");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PasswordAutofillAgentProxy::AnnotateFieldsWithParsingResult(
    const ::autofill::ParsingResult& in_parsing_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send autofill::mojom::PasswordAutofillAgent::AnnotateFieldsWithParsingResult", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("parsing_result"), in_parsing_result,
                        "<value of type const ::autofill::ParsingResult&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PasswordAutofillAgent::kAnnotateFieldsWithParsingResult), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::autofill::mojom::internal::PasswordAutofillAgent_AnnotateFieldsWithParsingResult_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->parsing_result)::BaseType> parsing_result_fragment(
          params.message());
  
  mojo::internal::Serialize<::autofill::mojom::ParsingResultDataView>(
    in_parsing_result,
    parsing_result_fragment);

  params->parsing_result.Set(
      parsing_result_fragment.is_null() ? nullptr : parsing_result_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->parsing_result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null parsing_result in PasswordAutofillAgent.AnnotateFieldsWithParsingResult request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PasswordAutofillAgent::Name_);
  message.set_method_name("AnnotateFieldsWithParsingResult");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class PasswordAutofillAgent_FillPasswordSuggestion_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PasswordAutofillAgent::FillPasswordSuggestionCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PasswordAutofillAgent_FillPasswordSuggestion_ProxyToResponder> proxy(
        new PasswordAutofillAgent_FillPasswordSuggestion_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PasswordAutofillAgent_FillPasswordSuggestion_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PasswordAutofillAgent_FillPasswordSuggestion_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PasswordAutofillAgent_FillPasswordSuggestion_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PasswordAutofillAgent::FillPasswordSuggestionCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);
};

bool PasswordAutofillAgent_FillPasswordSuggestion_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PasswordAutofillAgent_FillPasswordSuggestion_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PasswordAutofillAgent_FillPasswordSuggestion_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PasswordAutofillAgent.1
  bool success = true;
  bool p_success{};
  PasswordAutofillAgent_FillPasswordSuggestion_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PasswordAutofillAgent::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success));
  }
  return true;
}

void PasswordAutofillAgent_FillPasswordSuggestion_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply autofill::mojom::PasswordAutofillAgent::FillPasswordSuggestion", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PasswordAutofillAgent::kFillPasswordSuggestion), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::autofill::mojom::internal::PasswordAutofillAgent_FillPasswordSuggestion_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PasswordAutofillAgent::Name_);
  message.set_method_name("FillPasswordSuggestion");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PasswordAutofillAgent_FillField_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PasswordAutofillAgent::FillFieldCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PasswordAutofillAgent_FillField_ProxyToResponder> proxy(
        new PasswordAutofillAgent_FillField_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PasswordAutofillAgent_FillField_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PasswordAutofillAgent_FillField_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PasswordAutofillAgent_FillField_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PasswordAutofillAgent::FillFieldCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);
};

bool PasswordAutofillAgent_FillField_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PasswordAutofillAgent_FillField_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PasswordAutofillAgent_FillField_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PasswordAutofillAgent.7
  bool success = true;
  bool p_success{};
  PasswordAutofillAgent_FillField_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PasswordAutofillAgent::Name_, 7, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success));
  }
  return true;
}

void PasswordAutofillAgent_FillField_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply autofill::mojom::PasswordAutofillAgent::FillField", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PasswordAutofillAgent::kFillField), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::autofill::mojom::internal::PasswordAutofillAgent_FillField_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PasswordAutofillAgent::Name_);
  message.set_method_name("FillField");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PasswordAutofillAgent_FillChangePasswordForm_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PasswordAutofillAgent::FillChangePasswordFormCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PasswordAutofillAgent_FillChangePasswordForm_ProxyToResponder> proxy(
        new PasswordAutofillAgent_FillChangePasswordForm_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PasswordAutofillAgent_FillChangePasswordForm_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PasswordAutofillAgent_FillChangePasswordForm_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PasswordAutofillAgent_FillChangePasswordForm_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PasswordAutofillAgent::FillChangePasswordFormCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::optional<::autofill::FormData>& in_form_data);
};

bool PasswordAutofillAgent_FillChangePasswordForm_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PasswordAutofillAgent_FillChangePasswordForm_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PasswordAutofillAgent_FillChangePasswordForm_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PasswordAutofillAgent.8
  bool success = true;
  std::optional<::autofill::FormData> p_form_data{};
  PasswordAutofillAgent_FillChangePasswordForm_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadFormData(&p_form_data))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PasswordAutofillAgent::Name_, 8, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_form_data));
  }
  return true;
}

void PasswordAutofillAgent_FillChangePasswordForm_ProxyToResponder::Run(
    const std::optional<::autofill::FormData>& in_form_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply autofill::mojom::PasswordAutofillAgent::FillChangePasswordForm", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("form_data"), in_form_data,
                        "<value of type const std::optional<::autofill::FormData>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PasswordAutofillAgent::kFillChangePasswordForm), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::autofill::mojom::internal::PasswordAutofillAgent_FillChangePasswordForm_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->form_data)::BaseType> form_data_fragment(
          params.message());
  
  mojo::internal::Serialize<::autofill::mojom::FormDataDataView>(
    in_form_data,
    form_data_fragment);

  params->form_data.Set(
      form_data_fragment.is_null() ? nullptr : form_data_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PasswordAutofillAgent::Name_);
  message.set_method_name("FillChangePasswordForm");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PasswordAutofillAgent_SubmitFormWithEnter_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PasswordAutofillAgent::SubmitFormWithEnterCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PasswordAutofillAgent_SubmitFormWithEnter_ProxyToResponder> proxy(
        new PasswordAutofillAgent_SubmitFormWithEnter_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PasswordAutofillAgent_SubmitFormWithEnter_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PasswordAutofillAgent_SubmitFormWithEnter_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PasswordAutofillAgent_SubmitFormWithEnter_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PasswordAutofillAgent::SubmitFormWithEnterCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);
};

bool PasswordAutofillAgent_SubmitFormWithEnter_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PasswordAutofillAgent_SubmitFormWithEnter_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PasswordAutofillAgent_SubmitFormWithEnter_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PasswordAutofillAgent.9
  bool success = true;
  bool p_success{};
  PasswordAutofillAgent_SubmitFormWithEnter_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PasswordAutofillAgent::Name_, 9, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success));
  }
  return true;
}

void PasswordAutofillAgent_SubmitFormWithEnter_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply autofill::mojom::PasswordAutofillAgent::SubmitFormWithEnter", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PasswordAutofillAgent::kSubmitFormWithEnter), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::autofill::mojom::internal::PasswordAutofillAgent_SubmitFormWithEnter_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PasswordAutofillAgent::Name_);
  message.set_method_name("SubmitFormWithEnter");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool PasswordAutofillAgentStubDispatch::Accept(
    PasswordAutofillAgent* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PasswordAutofillAgent>(message->header()->name)) {
    case messages::PasswordAutofillAgent::kApplyFillDataOnParsingCompletion: {
      DCHECK(message->is_serialized());
      internal::PasswordAutofillAgent_ApplyFillDataOnParsingCompletion_Params_Data* params =
          reinterpret_cast<internal::PasswordAutofillAgent_ApplyFillDataOnParsingCompletion_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PasswordAutofillAgent.0
      bool success = true;
      ::autofill::PasswordFormFillData p_form_data{};
      PasswordAutofillAgent_ApplyFillDataOnParsingCompletion_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFormData(&p_form_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PasswordAutofillAgent::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ApplyFillDataOnParsingCompletion(        
        std::move(p_form_data));
      return true;
    }
    case messages::PasswordAutofillAgent::kFillPasswordSuggestion: {
      break;
    }
    case messages::PasswordAutofillAgent::kFillPasswordSuggestionById: {
      DCHECK(message->is_serialized());
      internal::PasswordAutofillAgent_FillPasswordSuggestionById_Params_Data* params =
          reinterpret_cast<internal::PasswordAutofillAgent_FillPasswordSuggestionById_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PasswordAutofillAgent.2
      bool success = true;
      ::autofill::FieldRendererId p_username_element_id{};
      ::autofill::FieldRendererId p_password_element_id{};
      ::std::u16string p_username{};
      ::std::u16string p_password{};
      ::autofill::mojom::AutofillSuggestionTriggerSource p_suggestion_source{};
      PasswordAutofillAgent_FillPasswordSuggestionById_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUsernameElementId(&p_username_element_id))
        success = false;
      if (success && !input_data_view.ReadPasswordElementId(&p_password_element_id))
        success = false;
      if (success && !input_data_view.ReadUsername(&p_username))
        success = false;
      if (success && !input_data_view.ReadPassword(&p_password))
        success = false;
      if (success && !input_data_view.ReadSuggestionSource(&p_suggestion_source))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PasswordAutofillAgent::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->FillPasswordSuggestionById(        
        std::move(p_username_element_id), 
        std::move(p_password_element_id), 
        std::move(p_username), 
        std::move(p_password), 
        std::move(p_suggestion_source));
      return true;
    }
    case messages::PasswordAutofillAgent::kPreviewPasswordSuggestionById: {
      DCHECK(message->is_serialized());
      internal::PasswordAutofillAgent_PreviewPasswordSuggestionById_Params_Data* params =
          reinterpret_cast<internal::PasswordAutofillAgent_PreviewPasswordSuggestionById_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PasswordAutofillAgent.3
      bool success = true;
      ::autofill::FieldRendererId p_username_element_id{};
      ::autofill::FieldRendererId p_password_element_id{};
      ::std::u16string p_username{};
      ::std::u16string p_password{};
      PasswordAutofillAgent_PreviewPasswordSuggestionById_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUsernameElementId(&p_username_element_id))
        success = false;
      if (success && !input_data_view.ReadPasswordElementId(&p_password_element_id))
        success = false;
      if (success && !input_data_view.ReadUsername(&p_username))
        success = false;
      if (success && !input_data_view.ReadPassword(&p_password))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PasswordAutofillAgent::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PreviewPasswordSuggestionById(        
        std::move(p_username_element_id), 
        std::move(p_password_element_id), 
        std::move(p_username), 
        std::move(p_password));
      return true;
    }
    case messages::PasswordAutofillAgent::kInformNoSavedCredentials: {
      DCHECK(message->is_serialized());
      internal::PasswordAutofillAgent_InformNoSavedCredentials_Params_Data* params =
          reinterpret_cast<internal::PasswordAutofillAgent_InformNoSavedCredentials_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PasswordAutofillAgent.4
      bool success = true;
      bool p_should_show_popup_without_passwords{};
      PasswordAutofillAgent_InformNoSavedCredentials_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_should_show_popup_without_passwords = input_data_view.should_show_popup_without_passwords();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PasswordAutofillAgent::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->InformNoSavedCredentials(        
        std::move(p_should_show_popup_without_passwords));
      return true;
    }
    case messages::PasswordAutofillAgent::kFillIntoFocusedField: {
      DCHECK(message->is_serialized());
      internal::PasswordAutofillAgent_FillIntoFocusedField_Params_Data* params =
          reinterpret_cast<internal::PasswordAutofillAgent_FillIntoFocusedField_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PasswordAutofillAgent.5
      bool success = true;
      bool p_is_password{};
      ::std::u16string p_credential{};
      PasswordAutofillAgent_FillIntoFocusedField_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_is_password = input_data_view.is_password();
      if (success && !input_data_view.ReadCredential(&p_credential))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PasswordAutofillAgent::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->FillIntoFocusedField(        
        std::move(p_is_password), 
        std::move(p_credential));
      return true;
    }
    case messages::PasswordAutofillAgent::kPreviewField: {
      DCHECK(message->is_serialized());
      internal::PasswordAutofillAgent_PreviewField_Params_Data* params =
          reinterpret_cast<internal::PasswordAutofillAgent_PreviewField_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PasswordAutofillAgent.6
      bool success = true;
      ::autofill::FieldRendererId p_field_id{};
      ::std::u16string p_value{};
      PasswordAutofillAgent_PreviewField_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFieldId(&p_field_id))
        success = false;
      if (success && !input_data_view.ReadValue(&p_value))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PasswordAutofillAgent::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PreviewField(        
        std::move(p_field_id), 
        std::move(p_value));
      return true;
    }
    case messages::PasswordAutofillAgent::kFillField: {
      break;
    }
    case messages::PasswordAutofillAgent::kFillChangePasswordForm: {
      break;
    }
    case messages::PasswordAutofillAgent::kSubmitFormWithEnter: {
      break;
    }
    case messages::PasswordAutofillAgent::kSetLoggingState: {
      DCHECK(message->is_serialized());
      internal::PasswordAutofillAgent_SetLoggingState_Params_Data* params =
          reinterpret_cast<internal::PasswordAutofillAgent_SetLoggingState_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PasswordAutofillAgent.10
      bool success = true;
      bool p_active{};
      PasswordAutofillAgent_SetLoggingState_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_active = input_data_view.active();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PasswordAutofillAgent::Name_, 10, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetLoggingState(        
        std::move(p_active));
      return true;
    }
    case messages::PasswordAutofillAgent::kAnnotateFieldsWithParsingResult: {
      DCHECK(message->is_serialized());
      internal::PasswordAutofillAgent_AnnotateFieldsWithParsingResult_Params_Data* params =
          reinterpret_cast<internal::PasswordAutofillAgent_AnnotateFieldsWithParsingResult_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PasswordAutofillAgent.11
      bool success = true;
      ::autofill::ParsingResult p_parsing_result{};
      PasswordAutofillAgent_AnnotateFieldsWithParsingResult_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParsingResult(&p_parsing_result))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PasswordAutofillAgent::Name_, 11, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AnnotateFieldsWithParsingResult(        
        std::move(p_parsing_result));
      return true;
    }
  }
  return false;
}

// static
bool PasswordAutofillAgentStubDispatch::AcceptWithResponder(
    PasswordAutofillAgent* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PasswordAutofillAgent>(message->header()->name)) {
    case messages::PasswordAutofillAgent::kApplyFillDataOnParsingCompletion: {
      break;
    }
    case messages::PasswordAutofillAgent::kFillPasswordSuggestion: {
      internal::PasswordAutofillAgent_FillPasswordSuggestion_Params_Data* params =
          reinterpret_cast<
              internal::PasswordAutofillAgent_FillPasswordSuggestion_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PasswordAutofillAgent.1
      bool success = true;
      ::std::u16string p_username{};
      ::std::u16string p_password{};
      PasswordAutofillAgent_FillPasswordSuggestion_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUsername(&p_username))
        success = false;
      if (success && !input_data_view.ReadPassword(&p_password))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PasswordAutofillAgent::Name_, 1, false);
        return false;
      }
      auto callback =
          PasswordAutofillAgent_FillPasswordSuggestion_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->FillPasswordSuggestion(        
        std::move(p_username), 
        std::move(p_password), std::move(callback));
      return true;
    }
    case messages::PasswordAutofillAgent::kFillPasswordSuggestionById: {
      break;
    }
    case messages::PasswordAutofillAgent::kPreviewPasswordSuggestionById: {
      break;
    }
    case messages::PasswordAutofillAgent::kInformNoSavedCredentials: {
      break;
    }
    case messages::PasswordAutofillAgent::kFillIntoFocusedField: {
      break;
    }
    case messages::PasswordAutofillAgent::kPreviewField: {
      break;
    }
    case messages::PasswordAutofillAgent::kFillField: {
      internal::PasswordAutofillAgent_FillField_Params_Data* params =
          reinterpret_cast<
              internal::PasswordAutofillAgent_FillField_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PasswordAutofillAgent.7
      bool success = true;
      ::autofill::FieldRendererId p_field_id{};
      ::std::u16string p_value{};
      uint32_t p_field_properties{};
      PasswordAutofillAgent_FillField_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFieldId(&p_field_id))
        success = false;
      if (success && !input_data_view.ReadValue(&p_value))
        success = false;
      if (success)
        p_field_properties = input_data_view.field_properties();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PasswordAutofillAgent::Name_, 7, false);
        return false;
      }
      auto callback =
          PasswordAutofillAgent_FillField_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->FillField(        
        std::move(p_field_id), 
        std::move(p_value), 
        std::move(p_field_properties), std::move(callback));
      return true;
    }
    case messages::PasswordAutofillAgent::kFillChangePasswordForm: {
      internal::PasswordAutofillAgent_FillChangePasswordForm_Params_Data* params =
          reinterpret_cast<
              internal::PasswordAutofillAgent_FillChangePasswordForm_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PasswordAutofillAgent.8
      bool success = true;
      ::autofill::FieldRendererId p_password_element_id{};
      ::autofill::FieldRendererId p_new_password_element_id{};
      ::autofill::FieldRendererId p_confirm_password_element_id{};
      ::std::u16string p_old_password{};
      ::std::u16string p_new_password{};
      PasswordAutofillAgent_FillChangePasswordForm_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPasswordElementId(&p_password_element_id))
        success = false;
      if (success && !input_data_view.ReadNewPasswordElementId(&p_new_password_element_id))
        success = false;
      if (success && !input_data_view.ReadConfirmPasswordElementId(&p_confirm_password_element_id))
        success = false;
      if (success && !input_data_view.ReadOldPassword(&p_old_password))
        success = false;
      if (success && !input_data_view.ReadNewPassword(&p_new_password))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PasswordAutofillAgent::Name_, 8, false);
        return false;
      }
      auto callback =
          PasswordAutofillAgent_FillChangePasswordForm_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->FillChangePasswordForm(        
        std::move(p_password_element_id), 
        std::move(p_new_password_element_id), 
        std::move(p_confirm_password_element_id), 
        std::move(p_old_password), 
        std::move(p_new_password), std::move(callback));
      return true;
    }
    case messages::PasswordAutofillAgent::kSubmitFormWithEnter: {
      internal::PasswordAutofillAgent_SubmitFormWithEnter_Params_Data* params =
          reinterpret_cast<
              internal::PasswordAutofillAgent_SubmitFormWithEnter_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PasswordAutofillAgent.9
      bool success = true;
      ::autofill::FieldRendererId p_field_id{};
      PasswordAutofillAgent_SubmitFormWithEnter_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFieldId(&p_field_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PasswordAutofillAgent::Name_, 9, false);
        return false;
      }
      auto callback =
          PasswordAutofillAgent_SubmitFormWithEnter_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SubmitFormWithEnter(        
        std::move(p_field_id), std::move(callback));
      return true;
    }
    case messages::PasswordAutofillAgent::kSetLoggingState: {
      break;
    }
    case messages::PasswordAutofillAgent::kAnnotateFieldsWithParsingResult: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPasswordAutofillAgentValidationInfo[] = {
    { &internal::PasswordAutofillAgent_ApplyFillDataOnParsingCompletion_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PasswordAutofillAgent_FillPasswordSuggestion_Params_Data::Validate,
     &internal::PasswordAutofillAgent_FillPasswordSuggestion_ResponseParams_Data::Validate},
    { &internal::PasswordAutofillAgent_FillPasswordSuggestionById_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PasswordAutofillAgent_PreviewPasswordSuggestionById_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PasswordAutofillAgent_InformNoSavedCredentials_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PasswordAutofillAgent_FillIntoFocusedField_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PasswordAutofillAgent_PreviewField_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PasswordAutofillAgent_FillField_Params_Data::Validate,
     &internal::PasswordAutofillAgent_FillField_ResponseParams_Data::Validate},
    { &internal::PasswordAutofillAgent_FillChangePasswordForm_Params_Data::Validate,
     &internal::PasswordAutofillAgent_FillChangePasswordForm_ResponseParams_Data::Validate},
    { &internal::PasswordAutofillAgent_SubmitFormWithEnter_Params_Data::Validate,
     &internal::PasswordAutofillAgent_SubmitFormWithEnter_ResponseParams_Data::Validate},
    { &internal::PasswordAutofillAgent_SetLoggingState_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PasswordAutofillAgent_AnnotateFieldsWithParsingResult_Params_Data::Validate,
     nullptr /* no response */},
};

bool PasswordAutofillAgentRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::autofill::mojom::PasswordAutofillAgent::Name_,
    kPasswordAutofillAgentValidationInfo);
}

bool PasswordAutofillAgentResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::autofill::mojom::PasswordAutofillAgent::Name_,
    kPasswordAutofillAgentValidationInfo);
}
// The declaration includes the definition on other builds.

PasswordGenerationAgent::IPCStableHashFunction PasswordGenerationAgent::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PasswordGenerationAgent>(message.name())) {
    case messages::PasswordGenerationAgent::kGeneratedPasswordAccepted: {
      return &PasswordGenerationAgent::GeneratedPasswordAccepted_Sym::IPCStableHash;
    }
    case messages::PasswordGenerationAgent::kGeneratedPasswordRejected: {
      return &PasswordGenerationAgent::GeneratedPasswordRejected_Sym::IPCStableHash;
    }
    case messages::PasswordGenerationAgent::kTriggeredGeneratePassword: {
      return &PasswordGenerationAgent::TriggeredGeneratePassword_Sym::IPCStableHash;
    }
    case messages::PasswordGenerationAgent::kFoundFormEligibleForGeneration: {
      return &PasswordGenerationAgent::FoundFormEligibleForGeneration_Sym::IPCStableHash;
    }
    case messages::PasswordGenerationAgent::kFocusNextFieldAfterPasswords: {
      return &PasswordGenerationAgent::FocusNextFieldAfterPasswords_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PasswordGenerationAgent::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PasswordGenerationAgent>(message.name())) {
      case messages::PasswordGenerationAgent::kGeneratedPasswordAccepted:
            return "Receive autofill::mojom::PasswordGenerationAgent::GeneratedPasswordAccepted";
      case messages::PasswordGenerationAgent::kGeneratedPasswordRejected:
            return "Receive autofill::mojom::PasswordGenerationAgent::GeneratedPasswordRejected";
      case messages::PasswordGenerationAgent::kTriggeredGeneratePassword:
            return "Receive autofill::mojom::PasswordGenerationAgent::TriggeredGeneratePassword";
      case messages::PasswordGenerationAgent::kFoundFormEligibleForGeneration:
            return "Receive autofill::mojom::PasswordGenerationAgent::FoundFormEligibleForGeneration";
      case messages::PasswordGenerationAgent::kFocusNextFieldAfterPasswords:
            return "Receive autofill::mojom::PasswordGenerationAgent::FocusNextFieldAfterPasswords";
    }
  } else {
    switch (static_cast<messages::PasswordGenerationAgent>(message.name())) {
      case messages::PasswordGenerationAgent::kGeneratedPasswordAccepted:
            return "Receive reply autofill::mojom::PasswordGenerationAgent::GeneratedPasswordAccepted";
      case messages::PasswordGenerationAgent::kGeneratedPasswordRejected:
            return "Receive reply autofill::mojom::PasswordGenerationAgent::GeneratedPasswordRejected";
      case messages::PasswordGenerationAgent::kTriggeredGeneratePassword:
            return "Receive reply autofill::mojom::PasswordGenerationAgent::TriggeredGeneratePassword";
      case messages::PasswordGenerationAgent::kFoundFormEligibleForGeneration:
            return "Receive reply autofill::mojom::PasswordGenerationAgent::FoundFormEligibleForGeneration";
      case messages::PasswordGenerationAgent::kFocusNextFieldAfterPasswords:
            return "Receive reply autofill::mojom::PasswordGenerationAgent::FocusNextFieldAfterPasswords";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PasswordGenerationAgent::GeneratedPasswordAccepted_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x21830b11;  // IPCStableHash for autofill::mojom::PasswordGenerationAgent::GeneratedPasswordAccepted
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PasswordGenerationAgent::GeneratedPasswordRejected_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x49e67d7c;  // IPCStableHash for autofill::mojom::PasswordGenerationAgent::GeneratedPasswordRejected
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PasswordGenerationAgent::TriggeredGeneratePassword_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc26d9f84;  // IPCStableHash for autofill::mojom::PasswordGenerationAgent::TriggeredGeneratePassword
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PasswordGenerationAgent::FoundFormEligibleForGeneration_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x564768a7;  // IPCStableHash for autofill::mojom::PasswordGenerationAgent::FoundFormEligibleForGeneration
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PasswordGenerationAgent::FocusNextFieldAfterPasswords_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x96073949;  // IPCStableHash for autofill::mojom::PasswordGenerationAgent::FocusNextFieldAfterPasswords
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class PasswordGenerationAgent_TriggeredGeneratePassword_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PasswordGenerationAgent_TriggeredGeneratePassword_ForwardToCallback(
      PasswordGenerationAgent::TriggeredGeneratePasswordCallback callback
      ) : callback_(std::move(callback)) {
  }

  PasswordGenerationAgent_TriggeredGeneratePassword_ForwardToCallback(const PasswordGenerationAgent_TriggeredGeneratePassword_ForwardToCallback&) = delete;
  PasswordGenerationAgent_TriggeredGeneratePassword_ForwardToCallback& operator=(const PasswordGenerationAgent_TriggeredGeneratePassword_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PasswordGenerationAgent::TriggeredGeneratePasswordCallback callback_;
};

PasswordGenerationAgentProxy::PasswordGenerationAgentProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PasswordGenerationAgentProxy::GeneratedPasswordAccepted(
    const ::std::u16string& in_generated_password) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send autofill::mojom::PasswordGenerationAgent::GeneratedPasswordAccepted", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("generated_password"), in_generated_password,
                        "<value of type const ::std::u16string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PasswordGenerationAgent::kGeneratedPasswordAccepted), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::autofill::mojom::internal::PasswordGenerationAgent_GeneratedPasswordAccepted_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->generated_password)::BaseType> generated_password_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    in_generated_password,
    generated_password_fragment);

  params->generated_password.Set(
      generated_password_fragment.is_null() ? nullptr : generated_password_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->generated_password.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null generated_password in PasswordGenerationAgent.GeneratedPasswordAccepted request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PasswordGenerationAgent::Name_);
  message.set_method_name("GeneratedPasswordAccepted");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PasswordGenerationAgentProxy::GeneratedPasswordRejected(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send autofill::mojom::PasswordGenerationAgent::GeneratedPasswordRejected");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PasswordGenerationAgent::kGeneratedPasswordRejected), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::autofill::mojom::internal::PasswordGenerationAgent_GeneratedPasswordRejected_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PasswordGenerationAgent::Name_);
  message.set_method_name("GeneratedPasswordRejected");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PasswordGenerationAgentProxy::TriggeredGeneratePassword(
    TriggeredGeneratePasswordCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send autofill::mojom::PasswordGenerationAgent::TriggeredGeneratePassword");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PasswordGenerationAgent::kTriggeredGeneratePassword), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::autofill::mojom::internal::PasswordGenerationAgent_TriggeredGeneratePassword_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PasswordGenerationAgent::Name_);
  message.set_method_name("TriggeredGeneratePassword");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PasswordGenerationAgent_TriggeredGeneratePassword_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PasswordGenerationAgentProxy::FoundFormEligibleForGeneration(
    const ::autofill::PasswordFormGenerationData& in_form) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send autofill::mojom::PasswordGenerationAgent::FoundFormEligibleForGeneration", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("form"), in_form,
                        "<value of type const ::autofill::PasswordFormGenerationData&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PasswordGenerationAgent::kFoundFormEligibleForGeneration), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::autofill::mojom::internal::PasswordGenerationAgent_FoundFormEligibleForGeneration_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->form)::BaseType> form_fragment(
          params.message());
  
  mojo::internal::Serialize<::autofill::mojom::PasswordFormGenerationDataDataView>(
    in_form,
    form_fragment);

  params->form.Set(
      form_fragment.is_null() ? nullptr : form_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->form.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null form in PasswordGenerationAgent.FoundFormEligibleForGeneration request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PasswordGenerationAgent::Name_);
  message.set_method_name("FoundFormEligibleForGeneration");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PasswordGenerationAgentProxy::FocusNextFieldAfterPasswords(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send autofill::mojom::PasswordGenerationAgent::FocusNextFieldAfterPasswords");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PasswordGenerationAgent::kFocusNextFieldAfterPasswords), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::autofill::mojom::internal::PasswordGenerationAgent_FocusNextFieldAfterPasswords_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PasswordGenerationAgent::Name_);
  message.set_method_name("FocusNextFieldAfterPasswords");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class PasswordGenerationAgent_TriggeredGeneratePassword_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PasswordGenerationAgent::TriggeredGeneratePasswordCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PasswordGenerationAgent_TriggeredGeneratePassword_ProxyToResponder> proxy(
        new PasswordGenerationAgent_TriggeredGeneratePassword_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PasswordGenerationAgent_TriggeredGeneratePassword_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PasswordGenerationAgent_TriggeredGeneratePassword_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PasswordGenerationAgent_TriggeredGeneratePassword_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PasswordGenerationAgent::TriggeredGeneratePasswordCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::optional<::autofill::password_generation::PasswordGenerationUIData>& in_data);
};

bool PasswordGenerationAgent_TriggeredGeneratePassword_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PasswordGenerationAgent_TriggeredGeneratePassword_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PasswordGenerationAgent_TriggeredGeneratePassword_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PasswordGenerationAgent.2
  bool success = true;
  std::optional<::autofill::password_generation::PasswordGenerationUIData> p_data{};
  PasswordGenerationAgent_TriggeredGeneratePassword_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadData(&p_data))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PasswordGenerationAgent::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_data));
  }
  return true;
}

void PasswordGenerationAgent_TriggeredGeneratePassword_ProxyToResponder::Run(
    const std::optional<::autofill::password_generation::PasswordGenerationUIData>& in_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply autofill::mojom::PasswordGenerationAgent::TriggeredGeneratePassword", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data,
                        "<value of type const std::optional<::autofill::password_generation::PasswordGenerationUIData>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PasswordGenerationAgent::kTriggeredGeneratePassword), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::autofill::mojom::internal::PasswordGenerationAgent_TriggeredGeneratePassword_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->data)::BaseType> data_fragment(
          params.message());
  
  mojo::internal::Serialize<::autofill::mojom::PasswordGenerationUIDataDataView>(
    in_data,
    data_fragment);

  params->data.Set(
      data_fragment.is_null() ? nullptr : data_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PasswordGenerationAgent::Name_);
  message.set_method_name("TriggeredGeneratePassword");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool PasswordGenerationAgentStubDispatch::Accept(
    PasswordGenerationAgent* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PasswordGenerationAgent>(message->header()->name)) {
    case messages::PasswordGenerationAgent::kGeneratedPasswordAccepted: {
      DCHECK(message->is_serialized());
      internal::PasswordGenerationAgent_GeneratedPasswordAccepted_Params_Data* params =
          reinterpret_cast<internal::PasswordGenerationAgent_GeneratedPasswordAccepted_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PasswordGenerationAgent.0
      bool success = true;
      ::std::u16string p_generated_password{};
      PasswordGenerationAgent_GeneratedPasswordAccepted_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadGeneratedPassword(&p_generated_password))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PasswordGenerationAgent::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GeneratedPasswordAccepted(        
        std::move(p_generated_password));
      return true;
    }
    case messages::PasswordGenerationAgent::kGeneratedPasswordRejected: {
      DCHECK(message->is_serialized());
      internal::PasswordGenerationAgent_GeneratedPasswordRejected_Params_Data* params =
          reinterpret_cast<internal::PasswordGenerationAgent_GeneratedPasswordRejected_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PasswordGenerationAgent.1
      bool success = true;
      PasswordGenerationAgent_GeneratedPasswordRejected_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PasswordGenerationAgent::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GeneratedPasswordRejected(        );
      return true;
    }
    case messages::PasswordGenerationAgent::kTriggeredGeneratePassword: {
      break;
    }
    case messages::PasswordGenerationAgent::kFoundFormEligibleForGeneration: {
      DCHECK(message->is_serialized());
      internal::PasswordGenerationAgent_FoundFormEligibleForGeneration_Params_Data* params =
          reinterpret_cast<internal::PasswordGenerationAgent_FoundFormEligibleForGeneration_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PasswordGenerationAgent.3
      bool success = true;
      ::autofill::PasswordFormGenerationData p_form{};
      PasswordGenerationAgent_FoundFormEligibleForGeneration_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadForm(&p_form))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PasswordGenerationAgent::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->FoundFormEligibleForGeneration(        
        std::move(p_form));
      return true;
    }
    case messages::PasswordGenerationAgent::kFocusNextFieldAfterPasswords: {
      DCHECK(message->is_serialized());
      internal::PasswordGenerationAgent_FocusNextFieldAfterPasswords_Params_Data* params =
          reinterpret_cast<internal::PasswordGenerationAgent_FocusNextFieldAfterPasswords_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PasswordGenerationAgent.4
      bool success = true;
      PasswordGenerationAgent_FocusNextFieldAfterPasswords_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PasswordGenerationAgent::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->FocusNextFieldAfterPasswords(        );
      return true;
    }
  }
  return false;
}

// static
bool PasswordGenerationAgentStubDispatch::AcceptWithResponder(
    PasswordGenerationAgent* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PasswordGenerationAgent>(message->header()->name)) {
    case messages::PasswordGenerationAgent::kGeneratedPasswordAccepted: {
      break;
    }
    case messages::PasswordGenerationAgent::kGeneratedPasswordRejected: {
      break;
    }
    case messages::PasswordGenerationAgent::kTriggeredGeneratePassword: {
      internal::PasswordGenerationAgent_TriggeredGeneratePassword_Params_Data* params =
          reinterpret_cast<
              internal::PasswordGenerationAgent_TriggeredGeneratePassword_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PasswordGenerationAgent.2
      bool success = true;
      PasswordGenerationAgent_TriggeredGeneratePassword_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PasswordGenerationAgent::Name_, 2, false);
        return false;
      }
      auto callback =
          PasswordGenerationAgent_TriggeredGeneratePassword_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->TriggeredGeneratePassword(std::move(callback));
      return true;
    }
    case messages::PasswordGenerationAgent::kFoundFormEligibleForGeneration: {
      break;
    }
    case messages::PasswordGenerationAgent::kFocusNextFieldAfterPasswords: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPasswordGenerationAgentValidationInfo[] = {
    { &internal::PasswordGenerationAgent_GeneratedPasswordAccepted_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PasswordGenerationAgent_GeneratedPasswordRejected_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PasswordGenerationAgent_TriggeredGeneratePassword_Params_Data::Validate,
     &internal::PasswordGenerationAgent_TriggeredGeneratePassword_ResponseParams_Data::Validate},
    { &internal::PasswordGenerationAgent_FoundFormEligibleForGeneration_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PasswordGenerationAgent_FocusNextFieldAfterPasswords_Params_Data::Validate,
     nullptr /* no response */},
};

bool PasswordGenerationAgentRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::autofill::mojom::PasswordGenerationAgent::Name_,
    kPasswordGenerationAgentValidationInfo);
}

bool PasswordGenerationAgentResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::autofill::mojom::PasswordGenerationAgent::Name_,
    kPasswordGenerationAgentValidationInfo);
}


}  // autofill::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace autofill::mojom {


void AutofillAgentInterceptorForTesting::TriggerFormExtraction() {
  GetForwardingInterface()->TriggerFormExtraction();
}
void AutofillAgentInterceptorForTesting::TriggerFormExtractionWithResponse(TriggerFormExtractionWithResponseCallback callback) {
  GetForwardingInterface()->TriggerFormExtractionWithResponse(std::move(callback));
}
void AutofillAgentInterceptorForTesting::ApplyFieldsAction(::autofill::mojom::FormActionType action_type, ::autofill::mojom::ActionPersistence action_persistence, const std::vector<::autofill::FormFieldData::FillData>& fields) {
  GetForwardingInterface()->ApplyFieldsAction(
    std::move(action_type)
    , 
    std::move(action_persistence)
    , 
    std::move(fields)
    );
}
void AutofillAgentInterceptorForTesting::ApplyFieldAction(::autofill::mojom::FieldActionType action_type, ::autofill::mojom::ActionPersistence action_persistence, ::autofill::FieldRendererId field, const ::std::u16string& value) {
  GetForwardingInterface()->ApplyFieldAction(
    std::move(action_type)
    , 
    std::move(action_persistence)
    , 
    std::move(field)
    , 
    std::move(value)
    );
}
void AutofillAgentInterceptorForTesting::ExtractForm(::autofill::FormRendererId form, ExtractFormCallback callback) {
  GetForwardingInterface()->ExtractForm(
    std::move(form)
    , std::move(callback));
}
void AutofillAgentInterceptorForTesting::ExtractLabeledTextNodeValue(const ::std::u16string& value_regex, const ::std::u16string& label_regex, uint32_t number_of_ancestor_levels_to_search, ExtractLabeledTextNodeValueCallback callback) {
  GetForwardingInterface()->ExtractLabeledTextNodeValue(
    std::move(value_regex)
    , 
    std::move(label_regex)
    , 
    std::move(number_of_ancestor_levels_to_search)
    , std::move(callback));
}
void AutofillAgentInterceptorForTesting::FieldTypePredictionsAvailable(const std::vector<::autofill::FormDataPredictions>& forms) {
  GetForwardingInterface()->FieldTypePredictionsAvailable(
    std::move(forms)
    );
}
void AutofillAgentInterceptorForTesting::ExposeDomNodeIds() {
  GetForwardingInterface()->ExposeDomNodeIds();
}
void AutofillAgentInterceptorForTesting::ClearPreviewedForm() {
  GetForwardingInterface()->ClearPreviewedForm();
}
void AutofillAgentInterceptorForTesting::TriggerSuggestions(::autofill::FieldRendererId field, ::autofill::mojom::AutofillSuggestionTriggerSource trigger_source) {
  GetForwardingInterface()->TriggerSuggestions(
    std::move(field)
    , 
    std::move(trigger_source)
    );
}
void AutofillAgentInterceptorForTesting::SetSuggestionAvailability(::autofill::FieldRendererId field, ::autofill::mojom::AutofillSuggestionAvailability suggestion_availability) {
  GetForwardingInterface()->SetSuggestionAvailability(
    std::move(field)
    , 
    std::move(suggestion_availability)
    );
}
void AutofillAgentInterceptorForTesting::AcceptDataListSuggestion(::autofill::FieldRendererId field, const ::std::u16string& value) {
  GetForwardingInterface()->AcceptDataListSuggestion(
    std::move(field)
    , 
    std::move(value)
    );
}
void AutofillAgentInterceptorForTesting::PreviewPasswordSuggestion(const ::std::u16string& username, const ::std::u16string& password) {
  GetForwardingInterface()->PreviewPasswordSuggestion(
    std::move(username)
    , 
    std::move(password)
    );
}
void AutofillAgentInterceptorForTesting::PreviewPasswordGenerationSuggestion(const ::std::u16string& password) {
  GetForwardingInterface()->PreviewPasswordGenerationSuggestion(
    std::move(password)
    );
}
void AutofillAgentInterceptorForTesting::GetPotentialLastFourCombinationsForStandaloneCvc(GetPotentialLastFourCombinationsForStandaloneCvcCallback callback) {
  GetForwardingInterface()->GetPotentialLastFourCombinationsForStandaloneCvc(std::move(callback));
}
void AutofillAgentInterceptorForTesting::DispatchEmailVerifiedEvent(::autofill::FieldRendererId field_id, const std::string& presentation_token) {
  GetForwardingInterface()->DispatchEmailVerifiedEvent(
    std::move(field_id)
    , 
    std::move(presentation_token)
    );
}
AutofillAgentAsyncWaiter::AutofillAgentAsyncWaiter(
    AutofillAgent* proxy) : proxy_(proxy) {}

AutofillAgentAsyncWaiter::~AutofillAgentAsyncWaiter() = default;


void AutofillAgentAsyncWaiter::TriggerFormExtractionWithResponse(
    bool* out_success) {
  base::RunLoop loop;
  proxy_->TriggerFormExtractionWithResponse(
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}

bool AutofillAgentAsyncWaiter::TriggerFormExtractionWithResponse(
    ) {
  bool async_wait_result;
  TriggerFormExtractionWithResponse(&async_wait_result);
  return async_wait_result;
}

void AutofillAgentAsyncWaiter::ExtractForm(
    ::autofill::FormRendererId form, std::optional<::autofill::FormData>* out_form) {
  base::RunLoop loop;
  proxy_->ExtractForm(
      std::move(form),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::optional<::autofill::FormData>* out_form
,
             const std::optional<::autofill::FormData>& form) {*out_form = std::move(form);
            loop->Quit();
          },
          &loop,
          out_form));
  loop.Run();
}

std::optional<::autofill::FormData> AutofillAgentAsyncWaiter::ExtractForm(
    ::autofill::FormRendererId form) {
  std::optional<::autofill::FormData> async_wait_result;
  ExtractForm(std::move(form),&async_wait_result);
  return async_wait_result;
}

void AutofillAgentAsyncWaiter::ExtractLabeledTextNodeValue(
    const ::std::u16string& value_regex, const ::std::u16string& label_regex, uint32_t number_of_ancestor_levels_to_search, std::string* out_value) {
  base::RunLoop loop;
  proxy_->ExtractLabeledTextNodeValue(
      std::move(value_regex),
      std::move(label_regex),
      std::move(number_of_ancestor_levels_to_search),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::string* out_value
,
             const std::string& value) {*out_value = std::move(value);
            loop->Quit();
          },
          &loop,
          out_value));
  loop.Run();
}

std::string AutofillAgentAsyncWaiter::ExtractLabeledTextNodeValue(
    const ::std::u16string& value_regex, const ::std::u16string& label_regex, uint32_t number_of_ancestor_levels_to_search) {
  std::string async_wait_result;
  ExtractLabeledTextNodeValue(std::move(value_regex),std::move(label_regex),std::move(number_of_ancestor_levels_to_search),&async_wait_result);
  return async_wait_result;
}

void AutofillAgentAsyncWaiter::GetPotentialLastFourCombinationsForStandaloneCvc(
    std::vector<std::string>* out_potential_matches) {
  base::RunLoop loop;
  proxy_->GetPotentialLastFourCombinationsForStandaloneCvc(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<std::string>* out_potential_matches
,
             const std::vector<std::string>& potential_matches) {*out_potential_matches = std::move(potential_matches);
            loop->Quit();
          },
          &loop,
          out_potential_matches));
  loop.Run();
}

std::vector<std::string> AutofillAgentAsyncWaiter::GetPotentialLastFourCombinationsForStandaloneCvc(
    ) {
  std::vector<std::string> async_wait_result;
  GetPotentialLastFourCombinationsForStandaloneCvc(&async_wait_result);
  return async_wait_result;
}




void PasswordAutofillAgentInterceptorForTesting::ApplyFillDataOnParsingCompletion(const ::autofill::PasswordFormFillData& form_data) {
  GetForwardingInterface()->ApplyFillDataOnParsingCompletion(
    std::move(form_data)
    );
}
void PasswordAutofillAgentInterceptorForTesting::FillPasswordSuggestion(const ::std::u16string& username, const ::std::u16string& password, FillPasswordSuggestionCallback callback) {
  GetForwardingInterface()->FillPasswordSuggestion(
    std::move(username)
    , 
    std::move(password)
    , std::move(callback));
}
void PasswordAutofillAgentInterceptorForTesting::FillPasswordSuggestionById(::autofill::FieldRendererId username_element_id, ::autofill::FieldRendererId password_element_id, const ::std::u16string& username, const ::std::u16string& password, ::autofill::mojom::AutofillSuggestionTriggerSource suggestion_source) {
  GetForwardingInterface()->FillPasswordSuggestionById(
    std::move(username_element_id)
    , 
    std::move(password_element_id)
    , 
    std::move(username)
    , 
    std::move(password)
    , 
    std::move(suggestion_source)
    );
}
void PasswordAutofillAgentInterceptorForTesting::PreviewPasswordSuggestionById(::autofill::FieldRendererId username_element_id, ::autofill::FieldRendererId password_element_id, const ::std::u16string& username, const ::std::u16string& password) {
  GetForwardingInterface()->PreviewPasswordSuggestionById(
    std::move(username_element_id)
    , 
    std::move(password_element_id)
    , 
    std::move(username)
    , 
    std::move(password)
    );
}
void PasswordAutofillAgentInterceptorForTesting::InformNoSavedCredentials(bool should_show_popup_without_passwords) {
  GetForwardingInterface()->InformNoSavedCredentials(
    std::move(should_show_popup_without_passwords)
    );
}
void PasswordAutofillAgentInterceptorForTesting::FillIntoFocusedField(bool is_password, const ::std::u16string& credential) {
  GetForwardingInterface()->FillIntoFocusedField(
    std::move(is_password)
    , 
    std::move(credential)
    );
}
void PasswordAutofillAgentInterceptorForTesting::PreviewField(::autofill::FieldRendererId field_id, const ::std::u16string& value) {
  GetForwardingInterface()->PreviewField(
    std::move(field_id)
    , 
    std::move(value)
    );
}
void PasswordAutofillAgentInterceptorForTesting::FillField(::autofill::FieldRendererId field_id, const ::std::u16string& value, uint32_t field_properties, FillFieldCallback callback) {
  GetForwardingInterface()->FillField(
    std::move(field_id)
    , 
    std::move(value)
    , 
    std::move(field_properties)
    , std::move(callback));
}
void PasswordAutofillAgentInterceptorForTesting::FillChangePasswordForm(::autofill::FieldRendererId password_element_id, ::autofill::FieldRendererId new_password_element_id, ::autofill::FieldRendererId confirm_password_element_id, const ::std::u16string& old_password, const ::std::u16string& new_password, FillChangePasswordFormCallback callback) {
  GetForwardingInterface()->FillChangePasswordForm(
    std::move(password_element_id)
    , 
    std::move(new_password_element_id)
    , 
    std::move(confirm_password_element_id)
    , 
    std::move(old_password)
    , 
    std::move(new_password)
    , std::move(callback));
}
void PasswordAutofillAgentInterceptorForTesting::SubmitFormWithEnter(::autofill::FieldRendererId field_id, SubmitFormWithEnterCallback callback) {
  GetForwardingInterface()->SubmitFormWithEnter(
    std::move(field_id)
    , std::move(callback));
}
void PasswordAutofillAgentInterceptorForTesting::SetLoggingState(bool active) {
  GetForwardingInterface()->SetLoggingState(
    std::move(active)
    );
}
void PasswordAutofillAgentInterceptorForTesting::AnnotateFieldsWithParsingResult(const ::autofill::ParsingResult& parsing_result) {
  GetForwardingInterface()->AnnotateFieldsWithParsingResult(
    std::move(parsing_result)
    );
}
PasswordAutofillAgentAsyncWaiter::PasswordAutofillAgentAsyncWaiter(
    PasswordAutofillAgent* proxy) : proxy_(proxy) {}

PasswordAutofillAgentAsyncWaiter::~PasswordAutofillAgentAsyncWaiter() = default;


void PasswordAutofillAgentAsyncWaiter::FillPasswordSuggestion(
    const ::std::u16string& username, const ::std::u16string& password, bool* out_success) {
  base::RunLoop loop;
  proxy_->FillPasswordSuggestion(
      std::move(username),
      std::move(password),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}

bool PasswordAutofillAgentAsyncWaiter::FillPasswordSuggestion(
    const ::std::u16string& username, const ::std::u16string& password) {
  bool async_wait_result;
  FillPasswordSuggestion(std::move(username),std::move(password),&async_wait_result);
  return async_wait_result;
}

void PasswordAutofillAgentAsyncWaiter::FillField(
    ::autofill::FieldRendererId field_id, const ::std::u16string& value, uint32_t field_properties, bool* out_success) {
  base::RunLoop loop;
  proxy_->FillField(
      std::move(field_id),
      std::move(value),
      std::move(field_properties),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}

bool PasswordAutofillAgentAsyncWaiter::FillField(
    ::autofill::FieldRendererId field_id, const ::std::u16string& value, uint32_t field_properties) {
  bool async_wait_result;
  FillField(std::move(field_id),std::move(value),std::move(field_properties),&async_wait_result);
  return async_wait_result;
}

void PasswordAutofillAgentAsyncWaiter::FillChangePasswordForm(
    ::autofill::FieldRendererId password_element_id, ::autofill::FieldRendererId new_password_element_id, ::autofill::FieldRendererId confirm_password_element_id, const ::std::u16string& old_password, const ::std::u16string& new_password, std::optional<::autofill::FormData>* out_form_data) {
  base::RunLoop loop;
  proxy_->FillChangePasswordForm(
      std::move(password_element_id),
      std::move(new_password_element_id),
      std::move(confirm_password_element_id),
      std::move(old_password),
      std::move(new_password),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::optional<::autofill::FormData>* out_form_data
,
             const std::optional<::autofill::FormData>& form_data) {*out_form_data = std::move(form_data);
            loop->Quit();
          },
          &loop,
          out_form_data));
  loop.Run();
}

std::optional<::autofill::FormData> PasswordAutofillAgentAsyncWaiter::FillChangePasswordForm(
    ::autofill::FieldRendererId password_element_id, ::autofill::FieldRendererId new_password_element_id, ::autofill::FieldRendererId confirm_password_element_id, const ::std::u16string& old_password, const ::std::u16string& new_password) {
  std::optional<::autofill::FormData> async_wait_result;
  FillChangePasswordForm(std::move(password_element_id),std::move(new_password_element_id),std::move(confirm_password_element_id),std::move(old_password),std::move(new_password),&async_wait_result);
  return async_wait_result;
}

void PasswordAutofillAgentAsyncWaiter::SubmitFormWithEnter(
    ::autofill::FieldRendererId field_id, bool* out_success) {
  base::RunLoop loop;
  proxy_->SubmitFormWithEnter(
      std::move(field_id),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}

bool PasswordAutofillAgentAsyncWaiter::SubmitFormWithEnter(
    ::autofill::FieldRendererId field_id) {
  bool async_wait_result;
  SubmitFormWithEnter(std::move(field_id),&async_wait_result);
  return async_wait_result;
}




void PasswordGenerationAgentInterceptorForTesting::GeneratedPasswordAccepted(const ::std::u16string& generated_password) {
  GetForwardingInterface()->GeneratedPasswordAccepted(
    std::move(generated_password)
    );
}
void PasswordGenerationAgentInterceptorForTesting::GeneratedPasswordRejected() {
  GetForwardingInterface()->GeneratedPasswordRejected();
}
void PasswordGenerationAgentInterceptorForTesting::TriggeredGeneratePassword(TriggeredGeneratePasswordCallback callback) {
  GetForwardingInterface()->TriggeredGeneratePassword(std::move(callback));
}
void PasswordGenerationAgentInterceptorForTesting::FoundFormEligibleForGeneration(const ::autofill::PasswordFormGenerationData& form) {
  GetForwardingInterface()->FoundFormEligibleForGeneration(
    std::move(form)
    );
}
void PasswordGenerationAgentInterceptorForTesting::FocusNextFieldAfterPasswords() {
  GetForwardingInterface()->FocusNextFieldAfterPasswords();
}
PasswordGenerationAgentAsyncWaiter::PasswordGenerationAgentAsyncWaiter(
    PasswordGenerationAgent* proxy) : proxy_(proxy) {}

PasswordGenerationAgentAsyncWaiter::~PasswordGenerationAgentAsyncWaiter() = default;


void PasswordGenerationAgentAsyncWaiter::TriggeredGeneratePassword(
    std::optional<::autofill::password_generation::PasswordGenerationUIData>* out_data) {
  base::RunLoop loop;
  proxy_->TriggeredGeneratePassword(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::optional<::autofill::password_generation::PasswordGenerationUIData>* out_data
,
             const std::optional<::autofill::password_generation::PasswordGenerationUIData>& data) {*out_data = std::move(data);
            loop->Quit();
          },
          &loop,
          out_data));
  loop.Run();
}

std::optional<::autofill::password_generation::PasswordGenerationUIData> PasswordGenerationAgentAsyncWaiter::TriggeredGeneratePassword(
    ) {
  std::optional<::autofill::password_generation::PasswordGenerationUIData> async_wait_result;
  TriggeredGeneratePassword(&async_wait_result);
  return async_wait_result;
}






}  // autofill::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif