// components/attribution_reporting/debug_types.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "components/attribution_reporting/debug_types.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/attribution_reporting/debug_types.mojom-params-data.h"
namespace attribution_reporting {
namespace mojom {

NOINLINE static const char* DebugDataTypeToStringHelper(DebugDataType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case DebugDataType::kSourceDestinationLimit:
      return "kSourceDestinationLimit";
    case DebugDataType::kSourceNoised:
      return "kSourceNoised";
    case DebugDataType::kSourceStorageLimit:
      return "kSourceStorageLimit";
    case DebugDataType::kSourceSuccess:
      return "kSourceSuccess";
    case DebugDataType::kSourceUnknownError:
      return "kSourceUnknownError";
    case DebugDataType::kSourceDestinationRateLimit:
      return "kSourceDestinationRateLimit";
    case DebugDataType::kTriggerNoMatchingSource:
      return "kTriggerNoMatchingSource";
    case DebugDataType::kTriggerNoMatchingFilterData:
      return "kTriggerNoMatchingFilterData";
    case DebugDataType::kTriggerReportingOriginLimit:
      return "kTriggerReportingOriginLimit";
    case DebugDataType::kTriggerEventDeduplicated:
      return "kTriggerEventDeduplicated";
    case DebugDataType::kTriggerEventNoMatchingConfigurations:
      return "kTriggerEventNoMatchingConfigurations";
    case DebugDataType::kTriggerEventNoise:
      return "kTriggerEventNoise";
    case DebugDataType::kTriggerEventLowPriority:
      return "kTriggerEventLowPriority";
    case DebugDataType::kTriggerEventExcessiveReports:
      return "kTriggerEventExcessiveReports";
    case DebugDataType::kTriggerEventStorageLimit:
      return "kTriggerEventStorageLimit";
    case DebugDataType::kTriggerEventReportWindowPassed:
      return "kTriggerEventReportWindowPassed";
    case DebugDataType::kTriggerAggregateDeduplicated:
      return "kTriggerAggregateDeduplicated";
    case DebugDataType::kTriggerAggregateNoContributions:
      return "kTriggerAggregateNoContributions";
    case DebugDataType::kTriggerAggregateInsufficientBudget:
      return "kTriggerAggregateInsufficientBudget";
    case DebugDataType::kTriggerAggregateStorageLimit:
      return "kTriggerAggregateStorageLimit";
    case DebugDataType::kTriggerAggregateReportWindowPassed:
      return "kTriggerAggregateReportWindowPassed";
    case DebugDataType::kTriggerAggregateExcessiveReports:
      return "kTriggerAggregateExcessiveReports";
    case DebugDataType::kTriggerUnknownError:
      return "kTriggerUnknownError";
    case DebugDataType::kOsSourceDelegated:
      return "kOsSourceDelegated";
    case DebugDataType::kOsTriggerDelegated:
      return "kOsTriggerDelegated";
    case DebugDataType::kTriggerEventReportWindowNotStarted:
      return "kTriggerEventReportWindowNotStarted";
    case DebugDataType::kTriggerEventNoMatchingTriggerData:
      return "kTriggerEventNoMatchingTriggerData";
    case DebugDataType::kHeaderParsingError:
      return "kHeaderParsingError";
    case DebugDataType::kSourceReportingOriginPerSiteLimit:
      return "kSourceReportingOriginPerSiteLimit";
    case DebugDataType::kTriggerEventAttributionsPerSourceDestinationLimit:
      return "kTriggerEventAttributionsPerSourceDestinationLimit";
    case DebugDataType::kTriggerAggregateAttributionsPerSourceDestinationLimit:
      return "kTriggerAggregateAttributionsPerSourceDestinationLimit";
    case DebugDataType::kSourceChannelCapacityLimit:
      return "kSourceChannelCapacityLimit";
    case DebugDataType::kSourceTriggerStateCardinalityLimit:
      return "kSourceTriggerStateCardinalityLimit";
    case DebugDataType::kSourceDestinationGlobalRateLimit:
      return "kSourceDestinationGlobalRateLimit";
    case DebugDataType::kSourceReportingOriginLimit:
      return "kSourceReportingOriginLimit";
    case DebugDataType::kSourceDestinationPerDayRateLimit:
      return "kSourceDestinationPerDayRateLimit";
    case DebugDataType::kSourceDestinationLimitReplaced:
      return "kSourceDestinationLimitReplaced";
    case DebugDataType::kSourceScopesChannelCapacityLimit:
      return "kSourceScopesChannelCapacityLimit";
    case DebugDataType::kSourceMaxEventStatesLimit:
      return "kSourceMaxEventStatesLimit";
    case DebugDataType::kTriggerAggregateInsufficientNamedBudget:
      return "kTriggerAggregateInsufficientNamedBudget";
    default:
      return nullptr;
  }
}

std::string DebugDataTypeToString(DebugDataType value) {
  const char *str = DebugDataTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown DebugDataType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, DebugDataType value) {
  return os << DebugDataTypeToString(value);
}

namespace internal {

}  // namespace internal
}  // namespace mojom
}  // namespace attribution_reporting

namespace perfetto {

// static
void TraceFormatTraits<::attribution_reporting::mojom::DebugDataType>::WriteIntoTrace(
   perfetto::TracedValue context, ::attribution_reporting::mojom::DebugDataType value) {
  return std::move(context).WriteString(::attribution_reporting::mojom::DebugDataTypeToString(value));
}

} // namespace perfetto