// components/attribution_reporting/data_host.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'components/attribution_reporting/data_host.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('attributionReporting.mojom');
  var registration$ =
      mojo.internal.exposeNamespace('attributionReporting.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'components/attribution_reporting/registration.mojom', 'registration.mojom.js');
  }
  var registration_header_error$ =
      mojo.internal.exposeNamespace('attributionReporting.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'components/attribution_reporting/registration_header_error.mojom', 'registration_header_error.mojom.js');
  }


  var DataAvailableCallsite = {};
  DataAvailableCallsite.kBlink = 0;
  DataAvailableCallsite.kBrowser = 1;
  DataAvailableCallsite.MIN_VALUE = 0;
  DataAvailableCallsite.MAX_VALUE = 1;

  DataAvailableCallsite.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
      return true;
    }
    return false;
  };

  DataAvailableCallsite.toKnownEnumValue = function(value) {
    return value;
  };

  DataAvailableCallsite.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function DataHost_SourceDataAvailable_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DataHost_SourceDataAvailable_Params.prototype.initDefaults_ = function() {
    this.reportingOrigin = null;
    this.data = null;
    this.wasFetchedViaServiceWorker = false;
  };
  DataHost_SourceDataAvailable_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DataHost_SourceDataAvailable_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DataHost_SourceDataAvailable_Params.reportingOrigin
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, registration$.SuitableOrigin, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DataHost_SourceDataAvailable_Params.data
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, registration$.SourceRegistration, false);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  DataHost_SourceDataAvailable_Params.encodedSize = codec.kStructHeaderSize + 24;

  DataHost_SourceDataAvailable_Params.decode = function(decoder) {
    var packed;
    var val = new DataHost_SourceDataAvailable_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.reportingOrigin =
        decoder.decodeStructPointer(registration$.SuitableOrigin);
    val.data =
        decoder.decodeStructPointer(registration$.SourceRegistration);
    packed = decoder.readUint8();
    val.wasFetchedViaServiceWorker = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  DataHost_SourceDataAvailable_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DataHost_SourceDataAvailable_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(registration$.SuitableOrigin, val.reportingOrigin);
    encoder.encodeStructPointer(registration$.SourceRegistration, val.data);
    packed = 0;
    packed |= (val.wasFetchedViaServiceWorker & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function DataHost_TriggerDataAvailable_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DataHost_TriggerDataAvailable_Params.prototype.initDefaults_ = function() {
    this.reportingOrigin = null;
    this.data = null;
    this.wasFetchedViaServiceWorker = false;
  };
  DataHost_TriggerDataAvailable_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DataHost_TriggerDataAvailable_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DataHost_TriggerDataAvailable_Params.reportingOrigin
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, registration$.SuitableOrigin, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DataHost_TriggerDataAvailable_Params.data
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, registration$.TriggerRegistration, false);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  DataHost_TriggerDataAvailable_Params.encodedSize = codec.kStructHeaderSize + 24;

  DataHost_TriggerDataAvailable_Params.decode = function(decoder) {
    var packed;
    var val = new DataHost_TriggerDataAvailable_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.reportingOrigin =
        decoder.decodeStructPointer(registration$.SuitableOrigin);
    val.data =
        decoder.decodeStructPointer(registration$.TriggerRegistration);
    packed = decoder.readUint8();
    val.wasFetchedViaServiceWorker = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  DataHost_TriggerDataAvailable_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DataHost_TriggerDataAvailable_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(registration$.SuitableOrigin, val.reportingOrigin);
    encoder.encodeStructPointer(registration$.TriggerRegistration, val.data);
    packed = 0;
    packed |= (val.wasFetchedViaServiceWorker & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function DataHost_OsSourceDataAvailable_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DataHost_OsSourceDataAvailable_Params.prototype.initDefaults_ = function() {
    this.registration = null;
    this.wasFetchedViaServiceWorker = false;
  };
  DataHost_OsSourceDataAvailable_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DataHost_OsSourceDataAvailable_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DataHost_OsSourceDataAvailable_Params.registration
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, registration$.OsRegistration, false);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  DataHost_OsSourceDataAvailable_Params.encodedSize = codec.kStructHeaderSize + 16;

  DataHost_OsSourceDataAvailable_Params.decode = function(decoder) {
    var packed;
    var val = new DataHost_OsSourceDataAvailable_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.registration =
        decoder.decodeStructPointer(registration$.OsRegistration);
    packed = decoder.readUint8();
    val.wasFetchedViaServiceWorker = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  DataHost_OsSourceDataAvailable_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DataHost_OsSourceDataAvailable_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(registration$.OsRegistration, val.registration);
    packed = 0;
    packed |= (val.wasFetchedViaServiceWorker & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function DataHost_OsTriggerDataAvailable_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DataHost_OsTriggerDataAvailable_Params.prototype.initDefaults_ = function() {
    this.registration = null;
    this.wasFetchedViaServiceWorker = false;
  };
  DataHost_OsTriggerDataAvailable_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DataHost_OsTriggerDataAvailable_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DataHost_OsTriggerDataAvailable_Params.registration
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, registration$.OsRegistration, false);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  DataHost_OsTriggerDataAvailable_Params.encodedSize = codec.kStructHeaderSize + 16;

  DataHost_OsTriggerDataAvailable_Params.decode = function(decoder) {
    var packed;
    var val = new DataHost_OsTriggerDataAvailable_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.registration =
        decoder.decodeStructPointer(registration$.OsRegistration);
    packed = decoder.readUint8();
    val.wasFetchedViaServiceWorker = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  DataHost_OsTriggerDataAvailable_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DataHost_OsTriggerDataAvailable_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(registration$.OsRegistration, val.registration);
    packed = 0;
    packed |= (val.wasFetchedViaServiceWorker & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function DataHost_ReportRegistrationHeaderError_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DataHost_ReportRegistrationHeaderError_Params.prototype.initDefaults_ = function() {
    this.reportingOrigin = null;
    this.error = null;
  };
  DataHost_ReportRegistrationHeaderError_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DataHost_ReportRegistrationHeaderError_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DataHost_ReportRegistrationHeaderError_Params.reportingOrigin
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, registration$.SuitableOrigin, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DataHost_ReportRegistrationHeaderError_Params.error
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, registration_header_error$.RegistrationHeaderError, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  DataHost_ReportRegistrationHeaderError_Params.encodedSize = codec.kStructHeaderSize + 16;

  DataHost_ReportRegistrationHeaderError_Params.decode = function(decoder) {
    var packed;
    var val = new DataHost_ReportRegistrationHeaderError_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.reportingOrigin =
        decoder.decodeStructPointer(registration$.SuitableOrigin);
    val.error =
        decoder.decodeStructPointer(registration_header_error$.RegistrationHeaderError);
    return val;
  };

  DataHost_ReportRegistrationHeaderError_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DataHost_ReportRegistrationHeaderError_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(registration$.SuitableOrigin, val.reportingOrigin);
    encoder.encodeStructPointer(registration_header_error$.RegistrationHeaderError, val.error);
  };
  var kDataHost_SourceDataAvailable_Name = 0;
  var kDataHost_TriggerDataAvailable_Name = 1;
  var kDataHost_OsSourceDataAvailable_Name = 2;
  var kDataHost_OsTriggerDataAvailable_Name = 3;
  var kDataHost_ReportRegistrationHeaderError_Name = 4;

  function DataHostPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(DataHost,
                                                   handleOrPtrInfo);
  }

  function DataHostAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        DataHost, associatedInterfacePtrInfo);
  }

  DataHostAssociatedPtr.prototype =
      Object.create(DataHostPtr.prototype);
  DataHostAssociatedPtr.prototype.constructor =
      DataHostAssociatedPtr;

  function DataHostProxy(receiver) {
    this.receiver_ = receiver;
  }
  DataHostPtr.prototype.sourceDataAvailable = function() {
    return DataHostProxy.prototype.sourceDataAvailable
        .apply(this.ptr.getProxy(), arguments);
  };

  DataHostProxy.prototype.sourceDataAvailable = function(reportingOrigin, data, wasFetchedViaServiceWorker) {
    var params_ = new DataHost_SourceDataAvailable_Params();
    params_.reportingOrigin = reportingOrigin;
    params_.data = data;
    params_.wasFetchedViaServiceWorker = wasFetchedViaServiceWorker;
    var builder = new codec.MessageV0Builder(
        kDataHost_SourceDataAvailable_Name,
        codec.align(DataHost_SourceDataAvailable_Params.encodedSize));
    builder.encodeStruct(DataHost_SourceDataAvailable_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  DataHostPtr.prototype.triggerDataAvailable = function() {
    return DataHostProxy.prototype.triggerDataAvailable
        .apply(this.ptr.getProxy(), arguments);
  };

  DataHostProxy.prototype.triggerDataAvailable = function(reportingOrigin, data, wasFetchedViaServiceWorker) {
    var params_ = new DataHost_TriggerDataAvailable_Params();
    params_.reportingOrigin = reportingOrigin;
    params_.data = data;
    params_.wasFetchedViaServiceWorker = wasFetchedViaServiceWorker;
    var builder = new codec.MessageV0Builder(
        kDataHost_TriggerDataAvailable_Name,
        codec.align(DataHost_TriggerDataAvailable_Params.encodedSize));
    builder.encodeStruct(DataHost_TriggerDataAvailable_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  DataHostPtr.prototype.osSourceDataAvailable = function() {
    return DataHostProxy.prototype.osSourceDataAvailable
        .apply(this.ptr.getProxy(), arguments);
  };

  DataHostProxy.prototype.osSourceDataAvailable = function(registration, wasFetchedViaServiceWorker) {
    var params_ = new DataHost_OsSourceDataAvailable_Params();
    params_.registration = registration;
    params_.wasFetchedViaServiceWorker = wasFetchedViaServiceWorker;
    var builder = new codec.MessageV0Builder(
        kDataHost_OsSourceDataAvailable_Name,
        codec.align(DataHost_OsSourceDataAvailable_Params.encodedSize));
    builder.encodeStruct(DataHost_OsSourceDataAvailable_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  DataHostPtr.prototype.osTriggerDataAvailable = function() {
    return DataHostProxy.prototype.osTriggerDataAvailable
        .apply(this.ptr.getProxy(), arguments);
  };

  DataHostProxy.prototype.osTriggerDataAvailable = function(registration, wasFetchedViaServiceWorker) {
    var params_ = new DataHost_OsTriggerDataAvailable_Params();
    params_.registration = registration;
    params_.wasFetchedViaServiceWorker = wasFetchedViaServiceWorker;
    var builder = new codec.MessageV0Builder(
        kDataHost_OsTriggerDataAvailable_Name,
        codec.align(DataHost_OsTriggerDataAvailable_Params.encodedSize));
    builder.encodeStruct(DataHost_OsTriggerDataAvailable_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  DataHostPtr.prototype.reportRegistrationHeaderError = function() {
    return DataHostProxy.prototype.reportRegistrationHeaderError
        .apply(this.ptr.getProxy(), arguments);
  };

  DataHostProxy.prototype.reportRegistrationHeaderError = function(reportingOrigin, error) {
    var params_ = new DataHost_ReportRegistrationHeaderError_Params();
    params_.reportingOrigin = reportingOrigin;
    params_.error = error;
    var builder = new codec.MessageV0Builder(
        kDataHost_ReportRegistrationHeaderError_Name,
        codec.align(DataHost_ReportRegistrationHeaderError_Params.encodedSize));
    builder.encodeStruct(DataHost_ReportRegistrationHeaderError_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function DataHostStub(delegate) {
    this.delegate_ = delegate;
  }
  DataHostStub.prototype.sourceDataAvailable = function(reportingOrigin, data, wasFetchedViaServiceWorker) {
    return this.delegate_ && this.delegate_.sourceDataAvailable && this.delegate_.sourceDataAvailable(reportingOrigin, data, wasFetchedViaServiceWorker);
  }
  DataHostStub.prototype.triggerDataAvailable = function(reportingOrigin, data, wasFetchedViaServiceWorker) {
    return this.delegate_ && this.delegate_.triggerDataAvailable && this.delegate_.triggerDataAvailable(reportingOrigin, data, wasFetchedViaServiceWorker);
  }
  DataHostStub.prototype.osSourceDataAvailable = function(registration, wasFetchedViaServiceWorker) {
    return this.delegate_ && this.delegate_.osSourceDataAvailable && this.delegate_.osSourceDataAvailable(registration, wasFetchedViaServiceWorker);
  }
  DataHostStub.prototype.osTriggerDataAvailable = function(registration, wasFetchedViaServiceWorker) {
    return this.delegate_ && this.delegate_.osTriggerDataAvailable && this.delegate_.osTriggerDataAvailable(registration, wasFetchedViaServiceWorker);
  }
  DataHostStub.prototype.reportRegistrationHeaderError = function(reportingOrigin, error) {
    return this.delegate_ && this.delegate_.reportRegistrationHeaderError && this.delegate_.reportRegistrationHeaderError(reportingOrigin, error);
  }

  DataHostStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kDataHost_SourceDataAvailable_Name:
      var params = reader.decodeStruct(DataHost_SourceDataAvailable_Params);
      this.sourceDataAvailable(params.reportingOrigin, params.data, params.wasFetchedViaServiceWorker);
      return true;
    case kDataHost_TriggerDataAvailable_Name:
      var params = reader.decodeStruct(DataHost_TriggerDataAvailable_Params);
      this.triggerDataAvailable(params.reportingOrigin, params.data, params.wasFetchedViaServiceWorker);
      return true;
    case kDataHost_OsSourceDataAvailable_Name:
      var params = reader.decodeStruct(DataHost_OsSourceDataAvailable_Params);
      this.osSourceDataAvailable(params.registration, params.wasFetchedViaServiceWorker);
      return true;
    case kDataHost_OsTriggerDataAvailable_Name:
      var params = reader.decodeStruct(DataHost_OsTriggerDataAvailable_Params);
      this.osTriggerDataAvailable(params.registration, params.wasFetchedViaServiceWorker);
      return true;
    case kDataHost_ReportRegistrationHeaderError_Name:
      var params = reader.decodeStruct(DataHost_ReportRegistrationHeaderError_Params);
      this.reportRegistrationHeaderError(params.reportingOrigin, params.error);
      return true;
    default:
      return false;
    }
  };

  DataHostStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateDataHostRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kDataHost_SourceDataAvailable_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = DataHost_SourceDataAvailable_Params;
      break;
      case kDataHost_TriggerDataAvailable_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = DataHost_TriggerDataAvailable_Params;
      break;
      case kDataHost_OsSourceDataAvailable_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = DataHost_OsSourceDataAvailable_Params;
      break;
      case kDataHost_OsTriggerDataAvailable_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = DataHost_OsTriggerDataAvailable_Params;
      break;
      case kDataHost_ReportRegistrationHeaderError_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = DataHost_ReportRegistrationHeaderError_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateDataHostResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var DataHost = {
    name: 'attribution_reporting.mojom.DataHost',
    kVersion: 0,
    ptrClass: DataHostPtr,
    proxyClass: DataHostProxy,
    stubClass: DataHostStub,
    validateRequest: validateDataHostRequest,
    validateResponse: null,
  };
  DataHostStub.prototype.validator = validateDataHostRequest;
  DataHostProxy.prototype.validator = null;
  exports.DataAvailableCallsite = DataAvailableCallsite;
  exports.DataHost = DataHost;
  exports.DataHostPtr = DataHostPtr;
  exports.DataHostAssociatedPtr = DataHostAssociatedPtr;
})();