// chrome/updater/mojom/updater_service.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "chrome/updater/mojom/updater_service.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/updater/mojom/updater_service.mojom-params-data.h"
#include "chrome/updater/mojom/updater_service.mojom-shared-message-ids.h"

#include "chrome/updater/mojom/updater_service.mojom-import-headers.h"
#include "chrome/updater/mojom/updater_service.mojom-test-utils.h"


namespace updater::mojom {
RegistrationRequest::RegistrationRequest()
    : app_id(),
      brand_code(),
      brand_path(),
      ap(),
      version(),
      existence_checker_path(),
      ap_path(),
      ap_key(),
      version_path(),
      version_key(),
      install_id(),
      lang(),
      dla(),
      dlrc(),
      install_date(),
      cohort(),
      cohort_name(),
      cohort_hint() {}

RegistrationRequest::RegistrationRequest(
    const std::string& app_id_in,
    const std::string& brand_code_in,
    const ::base::FilePath& brand_path_in,
    const std::string& ap_in,
    const std::string& version_in,
    const ::base::FilePath& existence_checker_path_in)
    : app_id(std::move(app_id_in)),
      brand_code(std::move(brand_code_in)),
      brand_path(std::move(brand_path_in)),
      ap(std::move(ap_in)),
      version(std::move(version_in)),
      existence_checker_path(std::move(existence_checker_path_in)),
      ap_path(),
      ap_key(),
      version_path(),
      version_key(),
      install_id(),
      lang(),
      dla(),
      dlrc(),
      install_date(),
      cohort(),
      cohort_name(),
      cohort_hint() {}

RegistrationRequest::RegistrationRequest(
    const std::string& app_id_in,
    const std::string& brand_code_in,
    const ::base::FilePath& brand_path_in,
    const std::string& ap_in,
    const std::string& version_in,
    const ::base::FilePath& existence_checker_path_in,
    const std::optional<::base::FilePath>& ap_path_in,
    const std::optional<std::string>& ap_key_in,
    const std::optional<::base::FilePath>& version_path_in,
    const std::optional<std::string>& version_key_in)
    : app_id(std::move(app_id_in)),
      brand_code(std::move(brand_code_in)),
      brand_path(std::move(brand_path_in)),
      ap(std::move(ap_in)),
      version(std::move(version_in)),
      existence_checker_path(std::move(existence_checker_path_in)),
      ap_path(std::move(ap_path_in)),
      ap_key(std::move(ap_key_in)),
      version_path(std::move(version_path_in)),
      version_key(std::move(version_key_in)),
      install_id(),
      lang(),
      dla(),
      dlrc(),
      install_date(),
      cohort(),
      cohort_name(),
      cohort_hint() {}

RegistrationRequest::RegistrationRequest(
    const std::string& app_id_in,
    const std::string& brand_code_in,
    const ::base::FilePath& brand_path_in,
    const std::string& ap_in,
    const std::string& version_in,
    const ::base::FilePath& existence_checker_path_in,
    const std::optional<::base::FilePath>& ap_path_in,
    const std::optional<std::string>& ap_key_in,
    const std::optional<::base::FilePath>& version_path_in,
    const std::optional<std::string>& version_key_in,
    const std::optional<std::string>& install_id_in)
    : app_id(std::move(app_id_in)),
      brand_code(std::move(brand_code_in)),
      brand_path(std::move(brand_path_in)),
      ap(std::move(ap_in)),
      version(std::move(version_in)),
      existence_checker_path(std::move(existence_checker_path_in)),
      ap_path(std::move(ap_path_in)),
      ap_key(std::move(ap_key_in)),
      version_path(std::move(version_path_in)),
      version_key(std::move(version_key_in)),
      install_id(std::move(install_id_in)),
      lang(),
      dla(),
      dlrc(),
      install_date(),
      cohort(),
      cohort_name(),
      cohort_hint() {}

RegistrationRequest::RegistrationRequest(
    const std::string& app_id_in,
    const std::string& brand_code_in,
    const ::base::FilePath& brand_path_in,
    const std::string& ap_in,
    const std::string& version_in,
    const ::base::FilePath& existence_checker_path_in,
    const std::optional<::base::FilePath>& ap_path_in,
    const std::optional<std::string>& ap_key_in,
    const std::optional<::base::FilePath>& version_path_in,
    const std::optional<std::string>& version_key_in,
    const std::optional<std::string>& install_id_in,
    const std::optional<std::string>& lang_in)
    : app_id(std::move(app_id_in)),
      brand_code(std::move(brand_code_in)),
      brand_path(std::move(brand_path_in)),
      ap(std::move(ap_in)),
      version(std::move(version_in)),
      existence_checker_path(std::move(existence_checker_path_in)),
      ap_path(std::move(ap_path_in)),
      ap_key(std::move(ap_key_in)),
      version_path(std::move(version_path_in)),
      version_key(std::move(version_key_in)),
      install_id(std::move(install_id_in)),
      lang(std::move(lang_in)),
      dla(),
      dlrc(),
      install_date(),
      cohort(),
      cohort_name(),
      cohort_hint() {}

RegistrationRequest::RegistrationRequest(
    const std::string& app_id_in,
    const std::string& brand_code_in,
    const ::base::FilePath& brand_path_in,
    const std::string& ap_in,
    const std::string& version_in,
    const ::base::FilePath& existence_checker_path_in,
    const std::optional<::base::FilePath>& ap_path_in,
    const std::optional<std::string>& ap_key_in,
    const std::optional<::base::FilePath>& version_path_in,
    const std::optional<std::string>& version_key_in,
    const std::optional<std::string>& install_id_in,
    const std::optional<std::string>& lang_in,
    std::optional<int32_t> dla_in,
    std::optional<int32_t> dlrc_in,
    std::optional<int32_t> install_date_in,
    const std::optional<std::string>& cohort_in,
    const std::optional<std::string>& cohort_name_in,
    const std::optional<std::string>& cohort_hint_in)
    : app_id(std::move(app_id_in)),
      brand_code(std::move(brand_code_in)),
      brand_path(std::move(brand_path_in)),
      ap(std::move(ap_in)),
      version(std::move(version_in)),
      existence_checker_path(std::move(existence_checker_path_in)),
      ap_path(std::move(ap_path_in)),
      ap_key(std::move(ap_key_in)),
      version_path(std::move(version_path_in)),
      version_key(std::move(version_key_in)),
      install_id(std::move(install_id_in)),
      lang(std::move(lang_in)),
      dla(std::move(dla_in)),
      dlrc(std::move(dlrc_in)),
      install_date(std::move(install_date_in)),
      cohort(std::move(cohort_in)),
      cohort_name(std::move(cohort_name_in)),
      cohort_hint(std::move(cohort_hint_in)) {}

RegistrationRequest::~RegistrationRequest() = default;

void RegistrationRequest::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "app_id"), this->app_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "brand_code"), this->brand_code,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "brand_path"), this->brand_path,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::base::FilePath&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ap"), this->ap,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "version"), this->version,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "existence_checker_path"), this->existence_checker_path,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::base::FilePath&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ap_path"), this->ap_path,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::base::FilePath>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ap_key"), this->ap_key,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "version_path"), this->version_path,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::base::FilePath>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "version_key"), this->version_key,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "install_id"), this->install_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "lang"), this->lang,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "dla"), this->dla,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<int32_t>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "dlrc"), this->dlrc,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<int32_t>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "install_date"), this->install_date,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<int32_t>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cohort"), this->cohort,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cohort_name"), this->cohort_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cohort_hint"), this->cohort_hint,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool RegistrationRequest::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
UpdateState::UpdateState()
    : app_id(),
      state(UpdateState_State::kUnknown),
      next_version(),
      downloaded_bytes(-1),
      total_bytes(-1),
      install_progress(-1),
      error_category(UpdateService_ErrorCategory::kNone),
      error_code(0),
      extra_code1(0),
      installer_text(),
      installer_cmd_line() {}

UpdateState::UpdateState(
    const std::string& app_id_in,
    UpdateState::State state_in,
    const std::string& next_version_in,
    int64_t downloaded_bytes_in,
    int64_t total_bytes_in,
    int8_t install_progress_in,
    UpdateService::ErrorCategory error_category_in,
    int32_t error_code_in,
    int32_t extra_code1_in,
    const std::string& installer_text_in,
    const std::string& installer_cmd_line_in)
    : app_id(std::move(app_id_in)),
      state(std::move(state_in)),
      next_version(std::move(next_version_in)),
      downloaded_bytes(std::move(downloaded_bytes_in)),
      total_bytes(std::move(total_bytes_in)),
      install_progress(std::move(install_progress_in)),
      error_category(std::move(error_category_in)),
      error_code(std::move(error_code_in)),
      extra_code1(std::move(extra_code1_in)),
      installer_text(std::move(installer_text_in)),
      installer_cmd_line(std::move(installer_cmd_line_in)) {}

UpdateState::~UpdateState() = default;
size_t UpdateState::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->app_id);
  seed = mojo::internal::Hash(seed, this->state);
  seed = mojo::internal::Hash(seed, this->next_version);
  seed = mojo::internal::Hash(seed, this->downloaded_bytes);
  seed = mojo::internal::Hash(seed, this->total_bytes);
  seed = mojo::internal::Hash(seed, this->install_progress);
  seed = mojo::internal::Hash(seed, this->error_category);
  seed = mojo::internal::Hash(seed, this->error_code);
  seed = mojo::internal::Hash(seed, this->extra_code1);
  seed = mojo::internal::Hash(seed, this->installer_text);
  seed = mojo::internal::Hash(seed, this->installer_cmd_line);
  return seed;
}

void UpdateState::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "app_id"), this->app_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "state"), this->state,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type UpdateState::State>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "next_version"), this->next_version,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "downloaded_bytes"), this->downloaded_bytes,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "total_bytes"), this->total_bytes,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "install_progress"), this->install_progress,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int8_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "error_category"), this->error_category,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type UpdateService::ErrorCategory>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "error_code"), this->error_code,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "extra_code1"), this->extra_code1,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "installer_text"), this->installer_text,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "installer_cmd_line"), this->installer_cmd_line,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool UpdateState::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AppState::AppState()
    : app_id(),
      version(),
      ap(),
      brand_code(),
      brand_path(),
      ecp(),
      ap_path(),
      ap_key(),
      version_path(),
      version_key(),
      cohort() {}

AppState::AppState(
    const std::string& app_id_in,
    const std::string& version_in,
    const std::string& ap_in,
    const std::string& brand_code_in,
    const ::base::FilePath& brand_path_in,
    const ::base::FilePath& ecp_in)
    : app_id(std::move(app_id_in)),
      version(std::move(version_in)),
      ap(std::move(ap_in)),
      brand_code(std::move(brand_code_in)),
      brand_path(std::move(brand_path_in)),
      ecp(std::move(ecp_in)),
      ap_path(),
      ap_key(),
      version_path(),
      version_key(),
      cohort() {}

AppState::AppState(
    const std::string& app_id_in,
    const std::string& version_in,
    const std::string& ap_in,
    const std::string& brand_code_in,
    const ::base::FilePath& brand_path_in,
    const ::base::FilePath& ecp_in,
    const std::optional<::base::FilePath>& ap_path_in,
    const std::optional<std::string>& ap_key_in,
    const std::optional<::base::FilePath>& version_path_in,
    const std::optional<std::string>& version_key_in)
    : app_id(std::move(app_id_in)),
      version(std::move(version_in)),
      ap(std::move(ap_in)),
      brand_code(std::move(brand_code_in)),
      brand_path(std::move(brand_path_in)),
      ecp(std::move(ecp_in)),
      ap_path(std::move(ap_path_in)),
      ap_key(std::move(ap_key_in)),
      version_path(std::move(version_path_in)),
      version_key(std::move(version_key_in)),
      cohort() {}

AppState::AppState(
    const std::string& app_id_in,
    const std::string& version_in,
    const std::string& ap_in,
    const std::string& brand_code_in,
    const ::base::FilePath& brand_path_in,
    const ::base::FilePath& ecp_in,
    const std::optional<::base::FilePath>& ap_path_in,
    const std::optional<std::string>& ap_key_in,
    const std::optional<::base::FilePath>& version_path_in,
    const std::optional<std::string>& version_key_in,
    const std::optional<std::string>& cohort_in)
    : app_id(std::move(app_id_in)),
      version(std::move(version_in)),
      ap(std::move(ap_in)),
      brand_code(std::move(brand_code_in)),
      brand_path(std::move(brand_path_in)),
      ecp(std::move(ecp_in)),
      ap_path(std::move(ap_path_in)),
      ap_key(std::move(ap_key_in)),
      version_path(std::move(version_path_in)),
      version_key(std::move(version_key_in)),
      cohort(std::move(cohort_in)) {}

AppState::~AppState() = default;

void AppState::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "app_id"), this->app_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "version"), this->version,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ap"), this->ap,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "brand_code"), this->brand_code,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "brand_path"), this->brand_path,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::base::FilePath&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ecp"), this->ecp,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::base::FilePath&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ap_path"), this->ap_path,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::base::FilePath>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ap_key"), this->ap_key,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "version_path"), this->version_path,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::base::FilePath>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "version_key"), this->version_key,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cohort"), this->cohort,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AppState::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

UpdateService::IPCStableHashFunction UpdateService::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::UpdateService>(message.name())) {
    case messages::UpdateService::kGetVersion: {
      return &UpdateService::GetVersion_Sym::IPCStableHash;
    }
    case messages::UpdateService::kFetchPolicies: {
      return &UpdateService::FetchPolicies_Sym::IPCStableHash;
    }
    case messages::UpdateService::kRegisterApp: {
      return &UpdateService::RegisterApp_Sym::IPCStableHash;
    }
    case messages::UpdateService::kGetAppStates: {
      return &UpdateService::GetAppStates_Sym::IPCStableHash;
    }
    case messages::UpdateService::kRunPeriodicTasks: {
      return &UpdateService::RunPeriodicTasks_Sym::IPCStableHash;
    }
    case messages::UpdateService::kUpdateAll: {
      return &UpdateService::UpdateAll_Sym::IPCStableHash;
    }
    case messages::UpdateService::kUpdate: {
      return &UpdateService::Update_Sym::IPCStableHash;
    }
    case messages::UpdateService::kInstall: {
      return &UpdateService::Install_Sym::IPCStableHash;
    }
    case messages::UpdateService::kCancelInstalls: {
      return &UpdateService::CancelInstalls_Sym::IPCStableHash;
    }
    case messages::UpdateService::kRunInstaller: {
      return &UpdateService::RunInstaller_Sym::IPCStableHash;
    }
    case messages::UpdateService::kCheckForUpdate: {
      return &UpdateService::CheckForUpdate_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* UpdateService::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::UpdateService>(message.name())) {
      case messages::UpdateService::kGetVersion:
            return "Receive updater::mojom::UpdateService::GetVersion";
      case messages::UpdateService::kFetchPolicies:
            return "Receive updater::mojom::UpdateService::FetchPolicies";
      case messages::UpdateService::kRegisterApp:
            return "Receive updater::mojom::UpdateService::RegisterApp";
      case messages::UpdateService::kGetAppStates:
            return "Receive updater::mojom::UpdateService::GetAppStates";
      case messages::UpdateService::kRunPeriodicTasks:
            return "Receive updater::mojom::UpdateService::RunPeriodicTasks";
      case messages::UpdateService::kUpdateAll:
            return "Receive updater::mojom::UpdateService::UpdateAll";
      case messages::UpdateService::kUpdate:
            return "Receive updater::mojom::UpdateService::Update";
      case messages::UpdateService::kInstall:
            return "Receive updater::mojom::UpdateService::Install";
      case messages::UpdateService::kCancelInstalls:
            return "Receive updater::mojom::UpdateService::CancelInstalls";
      case messages::UpdateService::kRunInstaller:
            return "Receive updater::mojom::UpdateService::RunInstaller";
      case messages::UpdateService::kCheckForUpdate:
            return "Receive updater::mojom::UpdateService::CheckForUpdate";
    }
  } else {
    switch (static_cast<messages::UpdateService>(message.name())) {
      case messages::UpdateService::kGetVersion:
            return "Receive reply updater::mojom::UpdateService::GetVersion";
      case messages::UpdateService::kFetchPolicies:
            return "Receive reply updater::mojom::UpdateService::FetchPolicies";
      case messages::UpdateService::kRegisterApp:
            return "Receive reply updater::mojom::UpdateService::RegisterApp";
      case messages::UpdateService::kGetAppStates:
            return "Receive reply updater::mojom::UpdateService::GetAppStates";
      case messages::UpdateService::kRunPeriodicTasks:
            return "Receive reply updater::mojom::UpdateService::RunPeriodicTasks";
      case messages::UpdateService::kUpdateAll:
            return "Receive reply updater::mojom::UpdateService::UpdateAll";
      case messages::UpdateService::kUpdate:
            return "Receive reply updater::mojom::UpdateService::Update";
      case messages::UpdateService::kInstall:
            return "Receive reply updater::mojom::UpdateService::Install";
      case messages::UpdateService::kCancelInstalls:
            return "Receive reply updater::mojom::UpdateService::CancelInstalls";
      case messages::UpdateService::kRunInstaller:
            return "Receive reply updater::mojom::UpdateService::RunInstaller";
      case messages::UpdateService::kCheckForUpdate:
            return "Receive reply updater::mojom::UpdateService::CheckForUpdate";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t UpdateService::GetVersion_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xcaeeed7b;  // IPCStableHash for updater::mojom::UpdateService::GetVersion
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t UpdateService::FetchPolicies_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xfc840de2;  // IPCStableHash for updater::mojom::UpdateService::FetchPolicies
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t UpdateService::RegisterApp_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4b41efc4;  // IPCStableHash for updater::mojom::UpdateService::RegisterApp
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t UpdateService::GetAppStates_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe110de26;  // IPCStableHash for updater::mojom::UpdateService::GetAppStates
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t UpdateService::RunPeriodicTasks_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x280c8410;  // IPCStableHash for updater::mojom::UpdateService::RunPeriodicTasks
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t UpdateService::UpdateAll_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x99d79a64;  // IPCStableHash for updater::mojom::UpdateService::UpdateAll
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t UpdateService::Update_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0961f6d9;  // IPCStableHash for updater::mojom::UpdateService::Update
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t UpdateService::Install_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe9da5c1d;  // IPCStableHash for updater::mojom::UpdateService::Install
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t UpdateService::CancelInstalls_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x980e3b06;  // IPCStableHash for updater::mojom::UpdateService::CancelInstalls
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t UpdateService::RunInstaller_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3316a1a8;  // IPCStableHash for updater::mojom::UpdateService::RunInstaller
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t UpdateService::CheckForUpdate_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x979cb4fd;  // IPCStableHash for updater::mojom::UpdateService::CheckForUpdate
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class UpdateService_GetVersion_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  UpdateService_GetVersion_ForwardToCallback(
      UpdateService::GetVersionCallback callback
      ) : callback_(std::move(callback)) {
  }

  UpdateService_GetVersion_ForwardToCallback(const UpdateService_GetVersion_ForwardToCallback&) = delete;
  UpdateService_GetVersion_ForwardToCallback& operator=(const UpdateService_GetVersion_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  UpdateService::GetVersionCallback callback_;
};

class UpdateService_FetchPolicies_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  UpdateService_FetchPolicies_ForwardToCallback(
      UpdateService::FetchPoliciesCallback callback
      ) : callback_(std::move(callback)) {
  }

  UpdateService_FetchPolicies_ForwardToCallback(const UpdateService_FetchPolicies_ForwardToCallback&) = delete;
  UpdateService_FetchPolicies_ForwardToCallback& operator=(const UpdateService_FetchPolicies_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  UpdateService::FetchPoliciesCallback callback_;
};

class UpdateService_RegisterApp_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  UpdateService_RegisterApp_ForwardToCallback(
      UpdateService::RegisterAppCallback callback
      ) : callback_(std::move(callback)) {
  }

  UpdateService_RegisterApp_ForwardToCallback(const UpdateService_RegisterApp_ForwardToCallback&) = delete;
  UpdateService_RegisterApp_ForwardToCallback& operator=(const UpdateService_RegisterApp_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  UpdateService::RegisterAppCallback callback_;
};

class UpdateService_GetAppStates_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  UpdateService_GetAppStates_ForwardToCallback(
      UpdateService::GetAppStatesCallback callback
      ) : callback_(std::move(callback)) {
  }

  UpdateService_GetAppStates_ForwardToCallback(const UpdateService_GetAppStates_ForwardToCallback&) = delete;
  UpdateService_GetAppStates_ForwardToCallback& operator=(const UpdateService_GetAppStates_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  UpdateService::GetAppStatesCallback callback_;
};

class UpdateService_RunPeriodicTasks_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  UpdateService_RunPeriodicTasks_ForwardToCallback(
      UpdateService::RunPeriodicTasksCallback callback
      ) : callback_(std::move(callback)) {
  }

  UpdateService_RunPeriodicTasks_ForwardToCallback(const UpdateService_RunPeriodicTasks_ForwardToCallback&) = delete;
  UpdateService_RunPeriodicTasks_ForwardToCallback& operator=(const UpdateService_RunPeriodicTasks_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  UpdateService::RunPeriodicTasksCallback callback_;
};

class UpdateService_UpdateAll_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  UpdateService_UpdateAll_ForwardToCallback(
      UpdateService::UpdateAllCallback callback
      ) : callback_(std::move(callback)) {
  }

  UpdateService_UpdateAll_ForwardToCallback(const UpdateService_UpdateAll_ForwardToCallback&) = delete;
  UpdateService_UpdateAll_ForwardToCallback& operator=(const UpdateService_UpdateAll_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  UpdateService::UpdateAllCallback callback_;
};

class UpdateService_Update_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  UpdateService_Update_ForwardToCallback(
      UpdateService::UpdateCallback callback
      ) : callback_(std::move(callback)) {
  }

  UpdateService_Update_ForwardToCallback(const UpdateService_Update_ForwardToCallback&) = delete;
  UpdateService_Update_ForwardToCallback& operator=(const UpdateService_Update_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  UpdateService::UpdateCallback callback_;
};

class UpdateService_Install_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  UpdateService_Install_ForwardToCallback(
      UpdateService::InstallCallback callback
      ) : callback_(std::move(callback)) {
  }

  UpdateService_Install_ForwardToCallback(const UpdateService_Install_ForwardToCallback&) = delete;
  UpdateService_Install_ForwardToCallback& operator=(const UpdateService_Install_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  UpdateService::InstallCallback callback_;
};

class UpdateService_RunInstaller_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  UpdateService_RunInstaller_ForwardToCallback(
      UpdateService::RunInstallerCallback callback
      ) : callback_(std::move(callback)) {
  }

  UpdateService_RunInstaller_ForwardToCallback(const UpdateService_RunInstaller_ForwardToCallback&) = delete;
  UpdateService_RunInstaller_ForwardToCallback& operator=(const UpdateService_RunInstaller_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  UpdateService::RunInstallerCallback callback_;
};

class UpdateService_CheckForUpdate_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  UpdateService_CheckForUpdate_ForwardToCallback(
      UpdateService::CheckForUpdateCallback callback
      ) : callback_(std::move(callback)) {
  }

  UpdateService_CheckForUpdate_ForwardToCallback(const UpdateService_CheckForUpdate_ForwardToCallback&) = delete;
  UpdateService_CheckForUpdate_ForwardToCallback& operator=(const UpdateService_CheckForUpdate_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  UpdateService::CheckForUpdateCallback callback_;
};

UpdateServiceProxy::UpdateServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void UpdateServiceProxy::GetVersion(
    GetVersionCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send updater::mojom::UpdateService::GetVersion");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UpdateService::kGetVersion), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::updater::mojom::internal::UpdateService_GetVersion_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UpdateService::Name_);
  message.set_method_name("GetVersion");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new UpdateService_GetVersion_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void UpdateServiceProxy::FetchPolicies(
    ::policy::PolicyFetchReason in_reason, FetchPoliciesCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send updater::mojom::UpdateService::FetchPolicies", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("reason"), in_reason,
                        "<value of type ::policy::PolicyFetchReason>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UpdateService::kFetchPolicies), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::updater::mojom::internal::UpdateService_FetchPolicies_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::enterprise_companion::mojom::PolicyFetchReason>(
    in_reason,
    &params->reason);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UpdateService::Name_);
  message.set_method_name("FetchPolicies");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new UpdateService_FetchPolicies_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void UpdateServiceProxy::RegisterApp(
    RegistrationRequestPtr in_request, RegisterAppCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send updater::mojom::UpdateService::RegisterApp", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request"), in_request,
                        "<value of type RegistrationRequestPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UpdateService::kRegisterApp), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::updater::mojom::internal::UpdateService_RegisterApp_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->request)::BaseType> request_fragment(
          params.message());
  
  mojo::internal::Serialize<::updater::mojom::RegistrationRequestDataView>(
    in_request,
    request_fragment);

  params->request.Set(
      request_fragment.is_null() ? nullptr : request_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->request.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null request in UpdateService.RegisterApp request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UpdateService::Name_);
  message.set_method_name("RegisterApp");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new UpdateService_RegisterApp_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void UpdateServiceProxy::GetAppStates(
    GetAppStatesCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send updater::mojom::UpdateService::GetAppStates");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UpdateService::kGetAppStates), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::updater::mojom::internal::UpdateService_GetAppStates_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UpdateService::Name_);
  message.set_method_name("GetAppStates");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new UpdateService_GetAppStates_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void UpdateServiceProxy::RunPeriodicTasks(
    RunPeriodicTasksCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send updater::mojom::UpdateService::RunPeriodicTasks");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UpdateService::kRunPeriodicTasks), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::updater::mojom::internal::UpdateService_RunPeriodicTasks_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UpdateService::Name_);
  message.set_method_name("RunPeriodicTasks");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new UpdateService_RunPeriodicTasks_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void UpdateServiceProxy::UpdateAll(
    UpdateAllCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send updater::mojom::UpdateService::UpdateAll");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UpdateService::kUpdateAll), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::updater::mojom::internal::UpdateService_UpdateAll_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UpdateService::Name_);
  message.set_method_name("UpdateAll");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new UpdateService_UpdateAll_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void UpdateServiceProxy::Update(
    const std::string& in_app_id, const std::string& in_install_data_index, UpdateService::Priority in_priority, UpdateService::PolicySameVersionUpdate in_policy_same_version_update, bool in_do_update_check_only, const std::optional<std::string>& in_language, UpdateCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send updater::mojom::UpdateService::Update", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("app_id"), in_app_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("install_data_index"), in_install_data_index,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("priority"), in_priority,
                        "<value of type UpdateService::Priority>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("policy_same_version_update"), in_policy_same_version_update,
                        "<value of type UpdateService::PolicySameVersionUpdate>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("do_update_check_only"), in_do_update_check_only,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("language"), in_language,
                        "<value of type const std::optional<std::string>&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UpdateService::kUpdate), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::updater::mojom::internal::UpdateService_Update_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->app_id)::BaseType> app_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_app_id,
    app_id_fragment);

  params->app_id.Set(
      app_id_fragment.is_null() ? nullptr : app_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->app_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null app_id in UpdateService.Update request");
  mojo::internal::MessageFragment<
      typename decltype(params->install_data_index)::BaseType> install_data_index_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_install_data_index,
    install_data_index_fragment);

  params->install_data_index.Set(
      install_data_index_fragment.is_null() ? nullptr : install_data_index_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->install_data_index.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null install_data_index in UpdateService.Update request");

  
  mojo::internal::Serialize<::updater::mojom::UpdateService_Priority>(
    in_priority,
    &params->priority);

  
  mojo::internal::Serialize<::updater::mojom::UpdateService_PolicySameVersionUpdate>(
    in_policy_same_version_update,
    &params->policy_same_version_update);

  params->do_update_check_only = in_do_update_check_only;
  mojo::internal::MessageFragment<
      typename decltype(params->language)::BaseType> language_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_language,
    language_fragment);

  params->language.Set(
      language_fragment.is_null() ? nullptr : language_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UpdateService::Name_);
  message.set_method_name("Update");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new UpdateService_Update_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void UpdateServiceProxy::Install(
    RegistrationRequestPtr in_registration, const std::string& in_client_install_data, const std::string& in_install_data_index, UpdateService::Priority in_priority, const std::optional<std::string>& in_language, InstallCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send updater::mojom::UpdateService::Install", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("registration"), in_registration,
                        "<value of type RegistrationRequestPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client_install_data"), in_client_install_data,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("install_data_index"), in_install_data_index,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("priority"), in_priority,
                        "<value of type UpdateService::Priority>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("language"), in_language,
                        "<value of type const std::optional<std::string>&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UpdateService::kInstall), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::updater::mojom::internal::UpdateService_Install_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->registration)::BaseType> registration_fragment(
          params.message());
  
  mojo::internal::Serialize<::updater::mojom::RegistrationRequestDataView>(
    in_registration,
    registration_fragment);

  params->registration.Set(
      registration_fragment.is_null() ? nullptr : registration_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->registration.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null registration in UpdateService.Install request");
  mojo::internal::MessageFragment<
      typename decltype(params->client_install_data)::BaseType> client_install_data_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_client_install_data,
    client_install_data_fragment);

  params->client_install_data.Set(
      client_install_data_fragment.is_null() ? nullptr : client_install_data_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->client_install_data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null client_install_data in UpdateService.Install request");
  mojo::internal::MessageFragment<
      typename decltype(params->install_data_index)::BaseType> install_data_index_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_install_data_index,
    install_data_index_fragment);

  params->install_data_index.Set(
      install_data_index_fragment.is_null() ? nullptr : install_data_index_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->install_data_index.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null install_data_index in UpdateService.Install request");

  
  mojo::internal::Serialize<::updater::mojom::UpdateService_Priority>(
    in_priority,
    &params->priority);
  mojo::internal::MessageFragment<
      typename decltype(params->language)::BaseType> language_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_language,
    language_fragment);

  params->language.Set(
      language_fragment.is_null() ? nullptr : language_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UpdateService::Name_);
  message.set_method_name("Install");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new UpdateService_Install_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void UpdateServiceProxy::CancelInstalls(
    const std::string& in_app_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send updater::mojom::UpdateService::CancelInstalls", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("app_id"), in_app_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UpdateService::kCancelInstalls), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::updater::mojom::internal::UpdateService_CancelInstalls_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->app_id)::BaseType> app_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_app_id,
    app_id_fragment);

  params->app_id.Set(
      app_id_fragment.is_null() ? nullptr : app_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->app_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null app_id in UpdateService.CancelInstalls request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UpdateService::Name_);
  message.set_method_name("CancelInstalls");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void UpdateServiceProxy::RunInstaller(
    const std::string& in_app_id, const ::base::FilePath& in_installer_path, const std::string& in_install_args, const std::string& in_install_data, const std::string& in_install_settings, const std::optional<std::string>& in_language, RunInstallerCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send updater::mojom::UpdateService::RunInstaller", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("app_id"), in_app_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("installer_path"), in_installer_path,
                        "<value of type const ::base::FilePath&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("install_args"), in_install_args,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("install_data"), in_install_data,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("install_settings"), in_install_settings,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("language"), in_language,
                        "<value of type const std::optional<std::string>&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UpdateService::kRunInstaller), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::updater::mojom::internal::UpdateService_RunInstaller_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->app_id)::BaseType> app_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_app_id,
    app_id_fragment);

  params->app_id.Set(
      app_id_fragment.is_null() ? nullptr : app_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->app_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null app_id in UpdateService.RunInstaller request");
  mojo::internal::MessageFragment<
      typename decltype(params->installer_path)::BaseType> installer_path_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView>(
    in_installer_path,
    installer_path_fragment);

  params->installer_path.Set(
      installer_path_fragment.is_null() ? nullptr : installer_path_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->installer_path.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null installer_path in UpdateService.RunInstaller request");
  mojo::internal::MessageFragment<
      typename decltype(params->install_args)::BaseType> install_args_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_install_args,
    install_args_fragment);

  params->install_args.Set(
      install_args_fragment.is_null() ? nullptr : install_args_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->install_args.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null install_args in UpdateService.RunInstaller request");
  mojo::internal::MessageFragment<
      typename decltype(params->install_data)::BaseType> install_data_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_install_data,
    install_data_fragment);

  params->install_data.Set(
      install_data_fragment.is_null() ? nullptr : install_data_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->install_data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null install_data in UpdateService.RunInstaller request");
  mojo::internal::MessageFragment<
      typename decltype(params->install_settings)::BaseType> install_settings_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_install_settings,
    install_settings_fragment);

  params->install_settings.Set(
      install_settings_fragment.is_null() ? nullptr : install_settings_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->install_settings.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null install_settings in UpdateService.RunInstaller request");
  mojo::internal::MessageFragment<
      typename decltype(params->language)::BaseType> language_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_language,
    language_fragment);

  params->language.Set(
      language_fragment.is_null() ? nullptr : language_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UpdateService::Name_);
  message.set_method_name("RunInstaller");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new UpdateService_RunInstaller_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void UpdateServiceProxy::CheckForUpdate(
    const std::string& in_app_id, UpdateService::Priority in_priority, UpdateService::PolicySameVersionUpdate in_policy_same_version_update, const std::optional<std::string>& in_language, CheckForUpdateCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send updater::mojom::UpdateService::CheckForUpdate", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("app_id"), in_app_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("priority"), in_priority,
                        "<value of type UpdateService::Priority>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("policy_same_version_update"), in_policy_same_version_update,
                        "<value of type UpdateService::PolicySameVersionUpdate>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("language"), in_language,
                        "<value of type const std::optional<std::string>&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UpdateService::kCheckForUpdate), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::updater::mojom::internal::UpdateService_CheckForUpdate_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->app_id)::BaseType> app_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_app_id,
    app_id_fragment);

  params->app_id.Set(
      app_id_fragment.is_null() ? nullptr : app_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->app_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null app_id in UpdateService.CheckForUpdate request");

  
  mojo::internal::Serialize<::updater::mojom::UpdateService_Priority>(
    in_priority,
    &params->priority);

  
  mojo::internal::Serialize<::updater::mojom::UpdateService_PolicySameVersionUpdate>(
    in_policy_same_version_update,
    &params->policy_same_version_update);
  mojo::internal::MessageFragment<
      typename decltype(params->language)::BaseType> language_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_language,
    language_fragment);

  params->language.Set(
      language_fragment.is_null() ? nullptr : language_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UpdateService::Name_);
  message.set_method_name("CheckForUpdate");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new UpdateService_CheckForUpdate_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class UpdateService_GetVersion_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static UpdateService::GetVersionCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<UpdateService_GetVersion_ProxyToResponder> proxy(
        new UpdateService_GetVersion_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&UpdateService_GetVersion_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~UpdateService_GetVersion_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  UpdateService_GetVersion_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "UpdateService::GetVersionCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::string& in_version);
};

bool UpdateService_GetVersion_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::UpdateService_GetVersion_ResponseParams_Data* params =
      reinterpret_cast<
          internal::UpdateService_GetVersion_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for UpdateService.0
  bool success = true;
  std::string p_version{};
  UpdateService_GetVersion_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadVersion(&p_version))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        UpdateService::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_version));
  }
  return true;
}

void UpdateService_GetVersion_ProxyToResponder::Run(
    const std::string& in_version) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply updater::mojom::UpdateService::GetVersion", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("version"), in_version,
                        "<value of type const std::string&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UpdateService::kGetVersion), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::updater::mojom::internal::UpdateService_GetVersion_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->version)::BaseType> version_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_version,
    version_fragment);

  params->version.Set(
      version_fragment.is_null() ? nullptr : version_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->version.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null version in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UpdateService::Name_);
  message.set_method_name("GetVersion");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class UpdateService_FetchPolicies_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static UpdateService::FetchPoliciesCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<UpdateService_FetchPolicies_ProxyToResponder> proxy(
        new UpdateService_FetchPolicies_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&UpdateService_FetchPolicies_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~UpdateService_FetchPolicies_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  UpdateService_FetchPolicies_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "UpdateService::FetchPoliciesCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_result);
};

bool UpdateService_FetchPolicies_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::UpdateService_FetchPolicies_ResponseParams_Data* params =
      reinterpret_cast<
          internal::UpdateService_FetchPolicies_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for UpdateService.1
  bool success = true;
  int32_t p_result{};
  UpdateService_FetchPolicies_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_result = input_data_view.result();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        UpdateService::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void UpdateService_FetchPolicies_ProxyToResponder::Run(
    int32_t in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply updater::mojom::UpdateService::FetchPolicies", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type int32_t>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UpdateService::kFetchPolicies), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::updater::mojom::internal::UpdateService_FetchPolicies_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->result = in_result;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UpdateService::Name_);
  message.set_method_name("FetchPolicies");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class UpdateService_RegisterApp_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static UpdateService::RegisterAppCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<UpdateService_RegisterApp_ProxyToResponder> proxy(
        new UpdateService_RegisterApp_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&UpdateService_RegisterApp_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~UpdateService_RegisterApp_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  UpdateService_RegisterApp_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "UpdateService::RegisterAppCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_result);
};

bool UpdateService_RegisterApp_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::UpdateService_RegisterApp_ResponseParams_Data* params =
      reinterpret_cast<
          internal::UpdateService_RegisterApp_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for UpdateService.2
  bool success = true;
  int32_t p_result{};
  UpdateService_RegisterApp_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_result = input_data_view.result();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        UpdateService::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void UpdateService_RegisterApp_ProxyToResponder::Run(
    int32_t in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply updater::mojom::UpdateService::RegisterApp", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type int32_t>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UpdateService::kRegisterApp), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::updater::mojom::internal::UpdateService_RegisterApp_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->result = in_result;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UpdateService::Name_);
  message.set_method_name("RegisterApp");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class UpdateService_GetAppStates_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static UpdateService::GetAppStatesCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<UpdateService_GetAppStates_ProxyToResponder> proxy(
        new UpdateService_GetAppStates_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&UpdateService_GetAppStates_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~UpdateService_GetAppStates_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  UpdateService_GetAppStates_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "UpdateService::GetAppStatesCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::vector<AppStatePtr> in_app_states);
};

bool UpdateService_GetAppStates_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::UpdateService_GetAppStates_ResponseParams_Data* params =
      reinterpret_cast<
          internal::UpdateService_GetAppStates_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for UpdateService.3
  bool success = true;
  std::vector<AppStatePtr> p_app_states{};
  UpdateService_GetAppStates_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadAppStates(&p_app_states))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        UpdateService::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_app_states));
  }
  return true;
}

void UpdateService_GetAppStates_ProxyToResponder::Run(
    std::vector<AppStatePtr> in_app_states) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply updater::mojom::UpdateService::GetAppStates", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("app_states"), in_app_states,
                        "<value of type std::vector<AppStatePtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UpdateService::kGetAppStates), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::updater::mojom::internal::UpdateService_GetAppStates_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->app_states)::BaseType>
      app_states_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& app_states_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::updater::mojom::AppStateDataView>>(
    in_app_states,
    app_states_fragment,
    &app_states_validate_params);

  params->app_states.Set(
      app_states_fragment.is_null() ? nullptr : app_states_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->app_states.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null app_states in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UpdateService::Name_);
  message.set_method_name("GetAppStates");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class UpdateService_RunPeriodicTasks_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static UpdateService::RunPeriodicTasksCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<UpdateService_RunPeriodicTasks_ProxyToResponder> proxy(
        new UpdateService_RunPeriodicTasks_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&UpdateService_RunPeriodicTasks_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~UpdateService_RunPeriodicTasks_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  UpdateService_RunPeriodicTasks_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "UpdateService::RunPeriodicTasksCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool UpdateService_RunPeriodicTasks_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::UpdateService_RunPeriodicTasks_ResponseParams_Data* params =
      reinterpret_cast<
          internal::UpdateService_RunPeriodicTasks_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for UpdateService.4
  bool success = true;
  UpdateService_RunPeriodicTasks_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        UpdateService::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void UpdateService_RunPeriodicTasks_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply updater::mojom::UpdateService::RunPeriodicTasks");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UpdateService::kRunPeriodicTasks), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::updater::mojom::internal::UpdateService_RunPeriodicTasks_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UpdateService::Name_);
  message.set_method_name("RunPeriodicTasks");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class UpdateService_UpdateAll_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static UpdateService::UpdateAllCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<UpdateService_UpdateAll_ProxyToResponder> proxy(
        new UpdateService_UpdateAll_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&UpdateService_UpdateAll_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~UpdateService_UpdateAll_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  UpdateService_UpdateAll_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "UpdateService::UpdateAllCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::mojo::PendingReceiver<StateChangeObserver> in_observer);
};

bool UpdateService_UpdateAll_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::UpdateService_UpdateAll_ResponseParams_Data* params =
      reinterpret_cast<
          internal::UpdateService_UpdateAll_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for UpdateService.5
  bool success = true;
  ::mojo::PendingReceiver<StateChangeObserver> p_observer{};
  UpdateService_UpdateAll_ResponseParamsDataView input_data_view(params, message);
  
  if (success) {
    p_observer =
        input_data_view.TakeObserver<decltype(p_observer)>();
  }
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        UpdateService::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_observer));
  }
  return true;
}

void UpdateService_UpdateAll_ProxyToResponder::Run(
    ::mojo::PendingReceiver<StateChangeObserver> in_observer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply updater::mojom::UpdateService::UpdateAll", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("observer"), in_observer,
                        "<value of type ::mojo::PendingReceiver<StateChangeObserver>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UpdateService::kUpdateAll), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::updater::mojom::internal::UpdateService_UpdateAll_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::updater::mojom::StateChangeObserverInterfaceBase>>(
    in_observer,
    &params->observer,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->observer)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid observer in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UpdateService::Name_);
  message.set_method_name("UpdateAll");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class UpdateService_Update_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static UpdateService::UpdateCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<UpdateService_Update_ProxyToResponder> proxy(
        new UpdateService_Update_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&UpdateService_Update_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~UpdateService_Update_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  UpdateService_Update_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "UpdateService::UpdateCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::mojo::PendingReceiver<StateChangeObserver> in_observer);
};

bool UpdateService_Update_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::UpdateService_Update_ResponseParams_Data* params =
      reinterpret_cast<
          internal::UpdateService_Update_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for UpdateService.6
  bool success = true;
  ::mojo::PendingReceiver<StateChangeObserver> p_observer{};
  UpdateService_Update_ResponseParamsDataView input_data_view(params, message);
  
  if (success) {
    p_observer =
        input_data_view.TakeObserver<decltype(p_observer)>();
  }
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        UpdateService::Name_, 6, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_observer));
  }
  return true;
}

void UpdateService_Update_ProxyToResponder::Run(
    ::mojo::PendingReceiver<StateChangeObserver> in_observer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply updater::mojom::UpdateService::Update", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("observer"), in_observer,
                        "<value of type ::mojo::PendingReceiver<StateChangeObserver>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UpdateService::kUpdate), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::updater::mojom::internal::UpdateService_Update_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::updater::mojom::StateChangeObserverInterfaceBase>>(
    in_observer,
    &params->observer,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->observer)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid observer in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UpdateService::Name_);
  message.set_method_name("Update");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class UpdateService_Install_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static UpdateService::InstallCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<UpdateService_Install_ProxyToResponder> proxy(
        new UpdateService_Install_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&UpdateService_Install_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~UpdateService_Install_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  UpdateService_Install_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "UpdateService::InstallCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::mojo::PendingReceiver<StateChangeObserver> in_observer);
};

bool UpdateService_Install_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::UpdateService_Install_ResponseParams_Data* params =
      reinterpret_cast<
          internal::UpdateService_Install_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for UpdateService.7
  bool success = true;
  ::mojo::PendingReceiver<StateChangeObserver> p_observer{};
  UpdateService_Install_ResponseParamsDataView input_data_view(params, message);
  
  if (success) {
    p_observer =
        input_data_view.TakeObserver<decltype(p_observer)>();
  }
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        UpdateService::Name_, 7, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_observer));
  }
  return true;
}

void UpdateService_Install_ProxyToResponder::Run(
    ::mojo::PendingReceiver<StateChangeObserver> in_observer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply updater::mojom::UpdateService::Install", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("observer"), in_observer,
                        "<value of type ::mojo::PendingReceiver<StateChangeObserver>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UpdateService::kInstall), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::updater::mojom::internal::UpdateService_Install_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::updater::mojom::StateChangeObserverInterfaceBase>>(
    in_observer,
    &params->observer,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->observer)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid observer in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UpdateService::Name_);
  message.set_method_name("Install");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class UpdateService_RunInstaller_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static UpdateService::RunInstallerCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<UpdateService_RunInstaller_ProxyToResponder> proxy(
        new UpdateService_RunInstaller_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&UpdateService_RunInstaller_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~UpdateService_RunInstaller_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  UpdateService_RunInstaller_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "UpdateService::RunInstallerCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::mojo::PendingReceiver<StateChangeObserver> in_observer);
};

bool UpdateService_RunInstaller_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::UpdateService_RunInstaller_ResponseParams_Data* params =
      reinterpret_cast<
          internal::UpdateService_RunInstaller_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for UpdateService.9
  bool success = true;
  ::mojo::PendingReceiver<StateChangeObserver> p_observer{};
  UpdateService_RunInstaller_ResponseParamsDataView input_data_view(params, message);
  
  if (success) {
    p_observer =
        input_data_view.TakeObserver<decltype(p_observer)>();
  }
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        UpdateService::Name_, 9, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_observer));
  }
  return true;
}

void UpdateService_RunInstaller_ProxyToResponder::Run(
    ::mojo::PendingReceiver<StateChangeObserver> in_observer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply updater::mojom::UpdateService::RunInstaller", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("observer"), in_observer,
                        "<value of type ::mojo::PendingReceiver<StateChangeObserver>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UpdateService::kRunInstaller), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::updater::mojom::internal::UpdateService_RunInstaller_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::updater::mojom::StateChangeObserverInterfaceBase>>(
    in_observer,
    &params->observer,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->observer)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid observer in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UpdateService::Name_);
  message.set_method_name("RunInstaller");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class UpdateService_CheckForUpdate_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static UpdateService::CheckForUpdateCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<UpdateService_CheckForUpdate_ProxyToResponder> proxy(
        new UpdateService_CheckForUpdate_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&UpdateService_CheckForUpdate_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~UpdateService_CheckForUpdate_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  UpdateService_CheckForUpdate_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "UpdateService::CheckForUpdateCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::mojo::PendingReceiver<StateChangeObserver> in_observer);
};

bool UpdateService_CheckForUpdate_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::UpdateService_CheckForUpdate_ResponseParams_Data* params =
      reinterpret_cast<
          internal::UpdateService_CheckForUpdate_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for UpdateService.10
  bool success = true;
  ::mojo::PendingReceiver<StateChangeObserver> p_observer{};
  UpdateService_CheckForUpdate_ResponseParamsDataView input_data_view(params, message);
  
  if (success) {
    p_observer =
        input_data_view.TakeObserver<decltype(p_observer)>();
  }
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        UpdateService::Name_, 10, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_observer));
  }
  return true;
}

void UpdateService_CheckForUpdate_ProxyToResponder::Run(
    ::mojo::PendingReceiver<StateChangeObserver> in_observer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply updater::mojom::UpdateService::CheckForUpdate", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("observer"), in_observer,
                        "<value of type ::mojo::PendingReceiver<StateChangeObserver>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UpdateService::kCheckForUpdate), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::updater::mojom::internal::UpdateService_CheckForUpdate_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::updater::mojom::StateChangeObserverInterfaceBase>>(
    in_observer,
    &params->observer,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->observer)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid observer in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UpdateService::Name_);
  message.set_method_name("CheckForUpdate");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool UpdateServiceStubDispatch::Accept(
    UpdateService* impl,
    mojo::Message* message) {
  switch (static_cast<messages::UpdateService>(message->header()->name)) {
    case messages::UpdateService::kGetVersion: {
      break;
    }
    case messages::UpdateService::kFetchPolicies: {
      break;
    }
    case messages::UpdateService::kRegisterApp: {
      break;
    }
    case messages::UpdateService::kGetAppStates: {
      break;
    }
    case messages::UpdateService::kRunPeriodicTasks: {
      break;
    }
    case messages::UpdateService::kUpdateAll: {
      break;
    }
    case messages::UpdateService::kUpdate: {
      break;
    }
    case messages::UpdateService::kInstall: {
      break;
    }
    case messages::UpdateService::kCancelInstalls: {
      DCHECK(message->is_serialized());
      internal::UpdateService_CancelInstalls_Params_Data* params =
          reinterpret_cast<internal::UpdateService_CancelInstalls_Params_Data*>(
              message->mutable_payload());
      

      // Validation for UpdateService.8
      bool success = true;
      std::string p_app_id{};
      UpdateService_CancelInstalls_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAppId(&p_app_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            UpdateService::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CancelInstalls(        
        std::move(p_app_id));
      return true;
    }
    case messages::UpdateService::kRunInstaller: {
      break;
    }
    case messages::UpdateService::kCheckForUpdate: {
      break;
    }
  }
  return false;
}

// static
bool UpdateServiceStubDispatch::AcceptWithResponder(
    UpdateService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::UpdateService>(message->header()->name)) {
    case messages::UpdateService::kGetVersion: {
      internal::UpdateService_GetVersion_Params_Data* params =
          reinterpret_cast<
              internal::UpdateService_GetVersion_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for UpdateService.0
      bool success = true;
      UpdateService_GetVersion_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            UpdateService::Name_, 0, false);
        return false;
      }
      auto callback =
          UpdateService_GetVersion_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetVersion(std::move(callback));
      return true;
    }
    case messages::UpdateService::kFetchPolicies: {
      internal::UpdateService_FetchPolicies_Params_Data* params =
          reinterpret_cast<
              internal::UpdateService_FetchPolicies_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for UpdateService.1
      bool success = true;
      ::policy::PolicyFetchReason p_reason{};
      UpdateService_FetchPolicies_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadReason(&p_reason))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            UpdateService::Name_, 1, false);
        return false;
      }
      auto callback =
          UpdateService_FetchPolicies_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->FetchPolicies(        
        std::move(p_reason), std::move(callback));
      return true;
    }
    case messages::UpdateService::kRegisterApp: {
      internal::UpdateService_RegisterApp_Params_Data* params =
          reinterpret_cast<
              internal::UpdateService_RegisterApp_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for UpdateService.2
      bool success = true;
      RegistrationRequestPtr p_request{};
      UpdateService_RegisterApp_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRequest(&p_request))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            UpdateService::Name_, 2, false);
        return false;
      }
      auto callback =
          UpdateService_RegisterApp_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RegisterApp(        
        std::move(p_request), std::move(callback));
      return true;
    }
    case messages::UpdateService::kGetAppStates: {
      internal::UpdateService_GetAppStates_Params_Data* params =
          reinterpret_cast<
              internal::UpdateService_GetAppStates_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for UpdateService.3
      bool success = true;
      UpdateService_GetAppStates_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            UpdateService::Name_, 3, false);
        return false;
      }
      auto callback =
          UpdateService_GetAppStates_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetAppStates(std::move(callback));
      return true;
    }
    case messages::UpdateService::kRunPeriodicTasks: {
      internal::UpdateService_RunPeriodicTasks_Params_Data* params =
          reinterpret_cast<
              internal::UpdateService_RunPeriodicTasks_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for UpdateService.4
      bool success = true;
      UpdateService_RunPeriodicTasks_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            UpdateService::Name_, 4, false);
        return false;
      }
      auto callback =
          UpdateService_RunPeriodicTasks_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RunPeriodicTasks(std::move(callback));
      return true;
    }
    case messages::UpdateService::kUpdateAll: {
      internal::UpdateService_UpdateAll_Params_Data* params =
          reinterpret_cast<
              internal::UpdateService_UpdateAll_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for UpdateService.5
      bool success = true;
      UpdateService_UpdateAll_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            UpdateService::Name_, 5, false);
        return false;
      }
      auto callback =
          UpdateService_UpdateAll_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateAll(std::move(callback));
      return true;
    }
    case messages::UpdateService::kUpdate: {
      internal::UpdateService_Update_Params_Data* params =
          reinterpret_cast<
              internal::UpdateService_Update_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for UpdateService.6
      bool success = true;
      std::string p_app_id{};
      std::string p_install_data_index{};
      UpdateService::Priority p_priority{};
      UpdateService::PolicySameVersionUpdate p_policy_same_version_update{};
      bool p_do_update_check_only{};
      std::optional<std::string> p_language{};
      UpdateService_Update_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAppId(&p_app_id))
        success = false;
      if (success && !input_data_view.ReadInstallDataIndex(&p_install_data_index))
        success = false;
      if (success && !input_data_view.ReadPriority(&p_priority))
        success = false;
      if (success && !input_data_view.ReadPolicySameVersionUpdate(&p_policy_same_version_update))
        success = false;
      if (success)
        p_do_update_check_only = input_data_view.do_update_check_only();
      if (success && !input_data_view.ReadLanguage(&p_language))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            UpdateService::Name_, 6, false);
        return false;
      }
      auto callback =
          UpdateService_Update_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Update(        
        std::move(p_app_id), 
        std::move(p_install_data_index), 
        std::move(p_priority), 
        std::move(p_policy_same_version_update), 
        std::move(p_do_update_check_only), 
        std::move(p_language), std::move(callback));
      return true;
    }
    case messages::UpdateService::kInstall: {
      internal::UpdateService_Install_Params_Data* params =
          reinterpret_cast<
              internal::UpdateService_Install_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for UpdateService.7
      bool success = true;
      RegistrationRequestPtr p_registration{};
      std::string p_client_install_data{};
      std::string p_install_data_index{};
      UpdateService::Priority p_priority{};
      std::optional<std::string> p_language{};
      UpdateService_Install_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRegistration(&p_registration))
        success = false;
      if (success && !input_data_view.ReadClientInstallData(&p_client_install_data))
        success = false;
      if (success && !input_data_view.ReadInstallDataIndex(&p_install_data_index))
        success = false;
      if (success && !input_data_view.ReadPriority(&p_priority))
        success = false;
      if (success && !input_data_view.ReadLanguage(&p_language))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            UpdateService::Name_, 7, false);
        return false;
      }
      auto callback =
          UpdateService_Install_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Install(        
        std::move(p_registration), 
        std::move(p_client_install_data), 
        std::move(p_install_data_index), 
        std::move(p_priority), 
        std::move(p_language), std::move(callback));
      return true;
    }
    case messages::UpdateService::kCancelInstalls: {
      break;
    }
    case messages::UpdateService::kRunInstaller: {
      internal::UpdateService_RunInstaller_Params_Data* params =
          reinterpret_cast<
              internal::UpdateService_RunInstaller_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for UpdateService.9
      bool success = true;
      std::string p_app_id{};
      ::base::FilePath p_installer_path{};
      std::string p_install_args{};
      std::string p_install_data{};
      std::string p_install_settings{};
      std::optional<std::string> p_language{};
      UpdateService_RunInstaller_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAppId(&p_app_id))
        success = false;
      if (success && !input_data_view.ReadInstallerPath(&p_installer_path))
        success = false;
      if (success && !input_data_view.ReadInstallArgs(&p_install_args))
        success = false;
      if (success && !input_data_view.ReadInstallData(&p_install_data))
        success = false;
      if (success && !input_data_view.ReadInstallSettings(&p_install_settings))
        success = false;
      if (success && !input_data_view.ReadLanguage(&p_language))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            UpdateService::Name_, 9, false);
        return false;
      }
      auto callback =
          UpdateService_RunInstaller_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RunInstaller(        
        std::move(p_app_id), 
        std::move(p_installer_path), 
        std::move(p_install_args), 
        std::move(p_install_data), 
        std::move(p_install_settings), 
        std::move(p_language), std::move(callback));
      return true;
    }
    case messages::UpdateService::kCheckForUpdate: {
      internal::UpdateService_CheckForUpdate_Params_Data* params =
          reinterpret_cast<
              internal::UpdateService_CheckForUpdate_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for UpdateService.10
      bool success = true;
      std::string p_app_id{};
      UpdateService::Priority p_priority{};
      UpdateService::PolicySameVersionUpdate p_policy_same_version_update{};
      std::optional<std::string> p_language{};
      UpdateService_CheckForUpdate_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAppId(&p_app_id))
        success = false;
      if (success && !input_data_view.ReadPriority(&p_priority))
        success = false;
      if (success && !input_data_view.ReadPolicySameVersionUpdate(&p_policy_same_version_update))
        success = false;
      if (success && !input_data_view.ReadLanguage(&p_language))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            UpdateService::Name_, 10, false);
        return false;
      }
      auto callback =
          UpdateService_CheckForUpdate_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CheckForUpdate(        
        std::move(p_app_id), 
        std::move(p_priority), 
        std::move(p_policy_same_version_update), 
        std::move(p_language), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kUpdateServiceValidationInfo[] = {
    { &internal::UpdateService_GetVersion_Params_Data::Validate,
     &internal::UpdateService_GetVersion_ResponseParams_Data::Validate},
    { &internal::UpdateService_FetchPolicies_Params_Data::Validate,
     &internal::UpdateService_FetchPolicies_ResponseParams_Data::Validate},
    { &internal::UpdateService_RegisterApp_Params_Data::Validate,
     &internal::UpdateService_RegisterApp_ResponseParams_Data::Validate},
    { &internal::UpdateService_GetAppStates_Params_Data::Validate,
     &internal::UpdateService_GetAppStates_ResponseParams_Data::Validate},
    { &internal::UpdateService_RunPeriodicTasks_Params_Data::Validate,
     &internal::UpdateService_RunPeriodicTasks_ResponseParams_Data::Validate},
    { &internal::UpdateService_UpdateAll_Params_Data::Validate,
     &internal::UpdateService_UpdateAll_ResponseParams_Data::Validate},
    { &internal::UpdateService_Update_Params_Data::Validate,
     &internal::UpdateService_Update_ResponseParams_Data::Validate},
    { &internal::UpdateService_Install_Params_Data::Validate,
     &internal::UpdateService_Install_ResponseParams_Data::Validate},
    { &internal::UpdateService_CancelInstalls_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::UpdateService_RunInstaller_Params_Data::Validate,
     &internal::UpdateService_RunInstaller_ResponseParams_Data::Validate},
    { &internal::UpdateService_CheckForUpdate_Params_Data::Validate,
     &internal::UpdateService_CheckForUpdate_ResponseParams_Data::Validate},
};

bool UpdateServiceRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::updater::mojom::UpdateService::Name_,
    kUpdateServiceValidationInfo);
}

bool UpdateServiceResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::updater::mojom::UpdateService::Name_,
    kUpdateServiceValidationInfo);
}
// The declaration includes the definition on other builds.

StateChangeObserver::IPCStableHashFunction StateChangeObserver::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::StateChangeObserver>(message.name())) {
    case messages::StateChangeObserver::kOnStateChange: {
      return &StateChangeObserver::OnStateChange_Sym::IPCStableHash;
    }
    case messages::StateChangeObserver::kOnComplete: {
      return &StateChangeObserver::OnComplete_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* StateChangeObserver::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::StateChangeObserver>(message.name())) {
      case messages::StateChangeObserver::kOnStateChange:
            return "Receive updater::mojom::StateChangeObserver::OnStateChange";
      case messages::StateChangeObserver::kOnComplete:
            return "Receive updater::mojom::StateChangeObserver::OnComplete";
    }
  } else {
    switch (static_cast<messages::StateChangeObserver>(message.name())) {
      case messages::StateChangeObserver::kOnStateChange:
            return "Receive reply updater::mojom::StateChangeObserver::OnStateChange";
      case messages::StateChangeObserver::kOnComplete:
            return "Receive reply updater::mojom::StateChangeObserver::OnComplete";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t StateChangeObserver::OnStateChange_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3b381282;  // IPCStableHash for updater::mojom::StateChangeObserver::OnStateChange
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t StateChangeObserver::OnComplete_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x44b87a92;  // IPCStableHash for updater::mojom::StateChangeObserver::OnComplete
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

StateChangeObserverProxy::StateChangeObserverProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void StateChangeObserverProxy::OnStateChange(
    UpdateStatePtr in_state) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send updater::mojom::StateChangeObserver::OnStateChange", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("state"), in_state,
                        "<value of type UpdateStatePtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::StateChangeObserver::kOnStateChange), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::updater::mojom::internal::StateChangeObserver_OnStateChange_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->state)::BaseType> state_fragment(
          params.message());
  
  mojo::internal::Serialize<::updater::mojom::UpdateStateDataView>(
    in_state,
    state_fragment);

  params->state.Set(
      state_fragment.is_null() ? nullptr : state_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->state.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null state in StateChangeObserver.OnStateChange request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(StateChangeObserver::Name_);
  message.set_method_name("OnStateChange");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void StateChangeObserverProxy::OnComplete(
    UpdateService::Result in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send updater::mojom::StateChangeObserver::OnComplete", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type UpdateService::Result>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::StateChangeObserver::kOnComplete), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::updater::mojom::internal::StateChangeObserver_OnComplete_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::updater::mojom::UpdateService_Result>(
    in_result,
    &params->result);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(StateChangeObserver::Name_);
  message.set_method_name("OnComplete");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool StateChangeObserverStubDispatch::Accept(
    StateChangeObserver* impl,
    mojo::Message* message) {
  switch (static_cast<messages::StateChangeObserver>(message->header()->name)) {
    case messages::StateChangeObserver::kOnStateChange: {
      DCHECK(message->is_serialized());
      internal::StateChangeObserver_OnStateChange_Params_Data* params =
          reinterpret_cast<internal::StateChangeObserver_OnStateChange_Params_Data*>(
              message->mutable_payload());
      

      // Validation for StateChangeObserver.0
      bool success = true;
      UpdateStatePtr p_state{};
      StateChangeObserver_OnStateChange_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadState(&p_state))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            StateChangeObserver::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnStateChange(        
        std::move(p_state));
      return true;
    }
    case messages::StateChangeObserver::kOnComplete: {
      DCHECK(message->is_serialized());
      internal::StateChangeObserver_OnComplete_Params_Data* params =
          reinterpret_cast<internal::StateChangeObserver_OnComplete_Params_Data*>(
              message->mutable_payload());
      

      // Validation for StateChangeObserver.1
      bool success = true;
      UpdateService::Result p_result{};
      StateChangeObserver_OnComplete_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadResult(&p_result))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            StateChangeObserver::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnComplete(        
        std::move(p_result));
      return true;
    }
  }
  return false;
}

// static
bool StateChangeObserverStubDispatch::AcceptWithResponder(
    StateChangeObserver* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::StateChangeObserver>(message->header()->name)) {
    case messages::StateChangeObserver::kOnStateChange: {
      break;
    }
    case messages::StateChangeObserver::kOnComplete: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kStateChangeObserverValidationInfo[] = {
    { &internal::StateChangeObserver_OnStateChange_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::StateChangeObserver_OnComplete_Params_Data::Validate,
     nullptr /* no response */},
};

bool StateChangeObserverRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::updater::mojom::StateChangeObserver::Name_,
    kStateChangeObserverValidationInfo);
}



}  // updater::mojom


namespace mojo {


// static
bool StructTraits<::updater::mojom::RegistrationRequest::DataView, ::updater::mojom::RegistrationRequestPtr>::Read(
    ::updater::mojom::RegistrationRequest::DataView input,
    ::updater::mojom::RegistrationRequestPtr* output) {
  bool success = true;
  ::updater::mojom::RegistrationRequestPtr result(::updater::mojom::RegistrationRequest::New());
  
      if (success && !input.ReadAppId(&result->app_id))
        success = false;
      if (success && !input.ReadBrandCode(&result->brand_code))
        success = false;
      if (success && !input.ReadBrandPath(&result->brand_path))
        success = false;
      if (success && !input.ReadAp(&result->ap))
        success = false;
      if (success && !input.ReadVersion(&result->version))
        success = false;
      if (success && !input.ReadExistenceCheckerPath(&result->existence_checker_path))
        success = false;
      if (success && !input.ReadApPath(&result->ap_path))
        success = false;
      if (success && !input.ReadApKey(&result->ap_key))
        success = false;
      if (success && !input.ReadVersionPath(&result->version_path))
        success = false;
      if (success && !input.ReadVersionKey(&result->version_key))
        success = false;
      if (success && !input.ReadInstallId(&result->install_id))
        success = false;
      if (success && !input.ReadLang(&result->lang))
        success = false;
      if (success) {
        result->dla = input.dla();
      }
      if (success) {
        result->dlrc = input.dlrc();
      }
      if (success) {
        result->install_date = input.install_date();
      }
      if (success && !input.ReadCohort(&result->cohort))
        success = false;
      if (success && !input.ReadCohortName(&result->cohort_name))
        success = false;
      if (success && !input.ReadCohortHint(&result->cohort_hint))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::updater::mojom::UpdateState::DataView, ::updater::mojom::UpdateStatePtr>::Read(
    ::updater::mojom::UpdateState::DataView input,
    ::updater::mojom::UpdateStatePtr* output) {
  bool success = true;
  ::updater::mojom::UpdateStatePtr result(::updater::mojom::UpdateState::New());
  
      if (success && !input.ReadAppId(&result->app_id))
        success = false;
      if (success && !input.ReadState(&result->state))
        success = false;
      if (success && !input.ReadNextVersion(&result->next_version))
        success = false;
      if (success)
        result->downloaded_bytes = input.downloaded_bytes();
      if (success)
        result->total_bytes = input.total_bytes();
      if (success)
        result->install_progress = input.install_progress();
      if (success && !input.ReadErrorCategory(&result->error_category))
        success = false;
      if (success)
        result->error_code = input.error_code();
      if (success)
        result->extra_code1 = input.extra_code1();
      if (success && !input.ReadInstallerText(&result->installer_text))
        success = false;
      if (success && !input.ReadInstallerCmdLine(&result->installer_cmd_line))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::updater::mojom::AppState::DataView, ::updater::mojom::AppStatePtr>::Read(
    ::updater::mojom::AppState::DataView input,
    ::updater::mojom::AppStatePtr* output) {
  bool success = true;
  ::updater::mojom::AppStatePtr result(::updater::mojom::AppState::New());
  
      if (success && !input.ReadAppId(&result->app_id))
        success = false;
      if (success && !input.ReadVersion(&result->version))
        success = false;
      if (success && !input.ReadAp(&result->ap))
        success = false;
      if (success && !input.ReadBrandCode(&result->brand_code))
        success = false;
      if (success && !input.ReadBrandPath(&result->brand_path))
        success = false;
      if (success && !input.ReadEcp(&result->ecp))
        success = false;
      if (success && !input.ReadApPath(&result->ap_path))
        success = false;
      if (success && !input.ReadApKey(&result->ap_key))
        success = false;
      if (success && !input.ReadVersionPath(&result->version_path))
        success = false;
      if (success && !input.ReadVersionKey(&result->version_key))
        success = false;
      if (success && !input.ReadCohort(&result->cohort))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace updater::mojom {


void UpdateServiceInterceptorForTesting::GetVersion(GetVersionCallback callback) {
  GetForwardingInterface()->GetVersion(std::move(callback));
}
void UpdateServiceInterceptorForTesting::FetchPolicies(::policy::PolicyFetchReason reason, FetchPoliciesCallback callback) {
  GetForwardingInterface()->FetchPolicies(
    std::move(reason)
    , std::move(callback));
}
void UpdateServiceInterceptorForTesting::RegisterApp(RegistrationRequestPtr request, RegisterAppCallback callback) {
  GetForwardingInterface()->RegisterApp(
    std::move(request)
    , std::move(callback));
}
void UpdateServiceInterceptorForTesting::GetAppStates(GetAppStatesCallback callback) {
  GetForwardingInterface()->GetAppStates(std::move(callback));
}
void UpdateServiceInterceptorForTesting::RunPeriodicTasks(RunPeriodicTasksCallback callback) {
  GetForwardingInterface()->RunPeriodicTasks(std::move(callback));
}
void UpdateServiceInterceptorForTesting::UpdateAll(UpdateAllCallback callback) {
  GetForwardingInterface()->UpdateAll(std::move(callback));
}
void UpdateServiceInterceptorForTesting::Update(const std::string& app_id, const std::string& install_data_index, UpdateService::Priority priority, UpdateService::PolicySameVersionUpdate policy_same_version_update, bool do_update_check_only, const std::optional<std::string>& language, UpdateCallback callback) {
  GetForwardingInterface()->Update(
    std::move(app_id)
    , 
    std::move(install_data_index)
    , 
    std::move(priority)
    , 
    std::move(policy_same_version_update)
    , 
    std::move(do_update_check_only)
    , 
    std::move(language)
    , std::move(callback));
}
void UpdateServiceInterceptorForTesting::Install(RegistrationRequestPtr registration, const std::string& client_install_data, const std::string& install_data_index, UpdateService::Priority priority, const std::optional<std::string>& language, InstallCallback callback) {
  GetForwardingInterface()->Install(
    std::move(registration)
    , 
    std::move(client_install_data)
    , 
    std::move(install_data_index)
    , 
    std::move(priority)
    , 
    std::move(language)
    , std::move(callback));
}
void UpdateServiceInterceptorForTesting::CancelInstalls(const std::string& app_id) {
  GetForwardingInterface()->CancelInstalls(
    std::move(app_id)
    );
}
void UpdateServiceInterceptorForTesting::RunInstaller(const std::string& app_id, const ::base::FilePath& installer_path, const std::string& install_args, const std::string& install_data, const std::string& install_settings, const std::optional<std::string>& language, RunInstallerCallback callback) {
  GetForwardingInterface()->RunInstaller(
    std::move(app_id)
    , 
    std::move(installer_path)
    , 
    std::move(install_args)
    , 
    std::move(install_data)
    , 
    std::move(install_settings)
    , 
    std::move(language)
    , std::move(callback));
}
void UpdateServiceInterceptorForTesting::CheckForUpdate(const std::string& app_id, UpdateService::Priority priority, UpdateService::PolicySameVersionUpdate policy_same_version_update, const std::optional<std::string>& language, CheckForUpdateCallback callback) {
  GetForwardingInterface()->CheckForUpdate(
    std::move(app_id)
    , 
    std::move(priority)
    , 
    std::move(policy_same_version_update)
    , 
    std::move(language)
    , std::move(callback));
}
UpdateServiceAsyncWaiter::UpdateServiceAsyncWaiter(
    UpdateService* proxy) : proxy_(proxy) {}

UpdateServiceAsyncWaiter::~UpdateServiceAsyncWaiter() = default;


void UpdateServiceAsyncWaiter::GetVersion(
    std::string* out_version) {
  base::RunLoop loop;
  proxy_->GetVersion(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::string* out_version
,
             const std::string& version) {*out_version = std::move(version);
            loop->Quit();
          },
          &loop,
          out_version));
  loop.Run();
}

std::string UpdateServiceAsyncWaiter::GetVersion(
    ) {
  std::string async_wait_result;
  GetVersion(&async_wait_result);
  return async_wait_result;
}

void UpdateServiceAsyncWaiter::FetchPolicies(
    ::policy::PolicyFetchReason reason, int32_t* out_result) {
  base::RunLoop loop;
  proxy_->FetchPolicies(
      std::move(reason),
      base::BindOnce(
          [](base::RunLoop* loop,
             int32_t* out_result
,
             int32_t result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

int32_t UpdateServiceAsyncWaiter::FetchPolicies(
    ::policy::PolicyFetchReason reason) {
  int32_t async_wait_result;
  FetchPolicies(std::move(reason),&async_wait_result);
  return async_wait_result;
}

void UpdateServiceAsyncWaiter::RegisterApp(
    RegistrationRequestPtr request, int32_t* out_result) {
  base::RunLoop loop;
  proxy_->RegisterApp(
      std::move(request),
      base::BindOnce(
          [](base::RunLoop* loop,
             int32_t* out_result
,
             int32_t result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

int32_t UpdateServiceAsyncWaiter::RegisterApp(
    RegistrationRequestPtr request) {
  int32_t async_wait_result;
  RegisterApp(std::move(request),&async_wait_result);
  return async_wait_result;
}

void UpdateServiceAsyncWaiter::GetAppStates(
    std::vector<AppStatePtr>* out_app_states) {
  base::RunLoop loop;
  proxy_->GetAppStates(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<AppStatePtr>* out_app_states
,
             std::vector<AppStatePtr> app_states) {*out_app_states = std::move(app_states);
            loop->Quit();
          },
          &loop,
          out_app_states));
  loop.Run();
}

std::vector<AppStatePtr> UpdateServiceAsyncWaiter::GetAppStates(
    ) {
  std::vector<AppStatePtr> async_wait_result;
  GetAppStates(&async_wait_result);
  return async_wait_result;
}

void UpdateServiceAsyncWaiter::RunPeriodicTasks(
    ) {
  base::RunLoop loop;
  proxy_->RunPeriodicTasks(
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void UpdateServiceAsyncWaiter::UpdateAll(
    ::mojo::PendingReceiver<StateChangeObserver>* out_observer) {
  base::RunLoop loop;
  proxy_->UpdateAll(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::mojo::PendingReceiver<StateChangeObserver>* out_observer
,
             ::mojo::PendingReceiver<StateChangeObserver> observer) {*out_observer = std::move(observer);
            loop->Quit();
          },
          &loop,
          out_observer));
  loop.Run();
}

::mojo::PendingReceiver<StateChangeObserver> UpdateServiceAsyncWaiter::UpdateAll(
    ) {
  ::mojo::PendingReceiver<StateChangeObserver> async_wait_result;
  UpdateAll(&async_wait_result);
  return async_wait_result;
}

void UpdateServiceAsyncWaiter::Update(
    const std::string& app_id, const std::string& install_data_index, UpdateService::Priority priority, UpdateService::PolicySameVersionUpdate policy_same_version_update, bool do_update_check_only, const std::optional<std::string>& language, ::mojo::PendingReceiver<StateChangeObserver>* out_observer) {
  base::RunLoop loop;
  proxy_->Update(
      std::move(app_id),
      std::move(install_data_index),
      std::move(priority),
      std::move(policy_same_version_update),
      std::move(do_update_check_only),
      std::move(language),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::mojo::PendingReceiver<StateChangeObserver>* out_observer
,
             ::mojo::PendingReceiver<StateChangeObserver> observer) {*out_observer = std::move(observer);
            loop->Quit();
          },
          &loop,
          out_observer));
  loop.Run();
}

::mojo::PendingReceiver<StateChangeObserver> UpdateServiceAsyncWaiter::Update(
    const std::string& app_id, const std::string& install_data_index, UpdateService::Priority priority, UpdateService::PolicySameVersionUpdate policy_same_version_update, bool do_update_check_only, const std::optional<std::string>& language) {
  ::mojo::PendingReceiver<StateChangeObserver> async_wait_result;
  Update(std::move(app_id),std::move(install_data_index),std::move(priority),std::move(policy_same_version_update),std::move(do_update_check_only),std::move(language),&async_wait_result);
  return async_wait_result;
}

void UpdateServiceAsyncWaiter::Install(
    RegistrationRequestPtr registration, const std::string& client_install_data, const std::string& install_data_index, UpdateService::Priority priority, const std::optional<std::string>& language, ::mojo::PendingReceiver<StateChangeObserver>* out_observer) {
  base::RunLoop loop;
  proxy_->Install(
      std::move(registration),
      std::move(client_install_data),
      std::move(install_data_index),
      std::move(priority),
      std::move(language),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::mojo::PendingReceiver<StateChangeObserver>* out_observer
,
             ::mojo::PendingReceiver<StateChangeObserver> observer) {*out_observer = std::move(observer);
            loop->Quit();
          },
          &loop,
          out_observer));
  loop.Run();
}

::mojo::PendingReceiver<StateChangeObserver> UpdateServiceAsyncWaiter::Install(
    RegistrationRequestPtr registration, const std::string& client_install_data, const std::string& install_data_index, UpdateService::Priority priority, const std::optional<std::string>& language) {
  ::mojo::PendingReceiver<StateChangeObserver> async_wait_result;
  Install(std::move(registration),std::move(client_install_data),std::move(install_data_index),std::move(priority),std::move(language),&async_wait_result);
  return async_wait_result;
}

void UpdateServiceAsyncWaiter::RunInstaller(
    const std::string& app_id, const ::base::FilePath& installer_path, const std::string& install_args, const std::string& install_data, const std::string& install_settings, const std::optional<std::string>& language, ::mojo::PendingReceiver<StateChangeObserver>* out_observer) {
  base::RunLoop loop;
  proxy_->RunInstaller(
      std::move(app_id),
      std::move(installer_path),
      std::move(install_args),
      std::move(install_data),
      std::move(install_settings),
      std::move(language),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::mojo::PendingReceiver<StateChangeObserver>* out_observer
,
             ::mojo::PendingReceiver<StateChangeObserver> observer) {*out_observer = std::move(observer);
            loop->Quit();
          },
          &loop,
          out_observer));
  loop.Run();
}

::mojo::PendingReceiver<StateChangeObserver> UpdateServiceAsyncWaiter::RunInstaller(
    const std::string& app_id, const ::base::FilePath& installer_path, const std::string& install_args, const std::string& install_data, const std::string& install_settings, const std::optional<std::string>& language) {
  ::mojo::PendingReceiver<StateChangeObserver> async_wait_result;
  RunInstaller(std::move(app_id),std::move(installer_path),std::move(install_args),std::move(install_data),std::move(install_settings),std::move(language),&async_wait_result);
  return async_wait_result;
}

void UpdateServiceAsyncWaiter::CheckForUpdate(
    const std::string& app_id, UpdateService::Priority priority, UpdateService::PolicySameVersionUpdate policy_same_version_update, const std::optional<std::string>& language, ::mojo::PendingReceiver<StateChangeObserver>* out_observer) {
  base::RunLoop loop;
  proxy_->CheckForUpdate(
      std::move(app_id),
      std::move(priority),
      std::move(policy_same_version_update),
      std::move(language),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::mojo::PendingReceiver<StateChangeObserver>* out_observer
,
             ::mojo::PendingReceiver<StateChangeObserver> observer) {*out_observer = std::move(observer);
            loop->Quit();
          },
          &loop,
          out_observer));
  loop.Run();
}

::mojo::PendingReceiver<StateChangeObserver> UpdateServiceAsyncWaiter::CheckForUpdate(
    const std::string& app_id, UpdateService::Priority priority, UpdateService::PolicySameVersionUpdate policy_same_version_update, const std::optional<std::string>& language) {
  ::mojo::PendingReceiver<StateChangeObserver> async_wait_result;
  CheckForUpdate(std::move(app_id),std::move(priority),std::move(policy_same_version_update),std::move(language),&async_wait_result);
  return async_wait_result;
}




void StateChangeObserverInterceptorForTesting::OnStateChange(UpdateStatePtr state) {
  GetForwardingInterface()->OnStateChange(
    std::move(state)
    );
}
void StateChangeObserverInterceptorForTesting::OnComplete(UpdateService::Result result) {
  GetForwardingInterface()->OnComplete(
    std::move(result)
    );
}
StateChangeObserverAsyncWaiter::StateChangeObserverAsyncWaiter(
    StateChangeObserver* proxy) : proxy_(proxy) {}

StateChangeObserverAsyncWaiter::~StateChangeObserverAsyncWaiter() = default;







}  // updater::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif