// chrome/services/printing/public/mojom/printing_service.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_SERVICES_PRINTING_PUBLIC_MOJOM_PRINTING_SERVICE_MOJOM_H_
#define CHROME_SERVICES_PRINTING_PUBLIC_MOJOM_PRINTING_SERVICE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/services/printing/public/mojom/printing_service.mojom-features.h"  // IWYU pragma: export
#include "chrome/services/printing/public/mojom/printing_service.mojom-shared.h"  // IWYU pragma: export
#include "chrome/services/printing/public/mojom/printing_service.mojom-forward.h"  // IWYU pragma: export
#include "chrome/services/printing/public/mojom/pdf_nup_converter.mojom-forward.h"
#include "chrome/services/printing/public/mojom/pdf_to_pwg_raster_converter.mojom-forward.h"
#include "sandbox/policy/mojom/sandbox.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"





constexpr ::sandbox::mojom::Sandbox kPrintingServiceSandbox = ::sandbox::mojom::Sandbox::kUtility;


namespace printing::mojom {

class PrintingServiceProxy;

template <typename ImplRefTraits>
class PrintingServiceStub;

class PrintingServiceRequestValidator;


class PrintingService
    : public PrintingServiceInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "printing.mojom.PrintingService";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr auto kServiceSandbox = sandbox::mojom::Sandbox::kUtility;
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PrintingServiceInterfaceBase;
  using Proxy_ = PrintingServiceProxy;

  template <typename ImplRefTraits>
  using Stub_ = PrintingServiceStub<ImplRefTraits>;

  using RequestValidator_ = PrintingServiceRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kBindPdfNupConverterMinVersion = 0,
    kBindPdfToPwgRasterConverterMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct BindPdfNupConverter_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct BindPdfToPwgRasterConverter_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PrintingService() = default;

  virtual void BindPdfNupConverter(::mojo::PendingReceiver<::printing::mojom::PdfNupConverter> receiver) = 0;

  virtual void BindPdfToPwgRasterConverter(::mojo::PendingReceiver<::printing::mojom::PdfToPwgRasterConverter> receiver) = 0;
};



class  PrintingServiceProxy
    : public PrintingService {
 public:
  using InterfaceType = PrintingService;

  explicit PrintingServiceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void BindPdfNupConverter(::mojo::PendingReceiver<::printing::mojom::PdfNupConverter> receiver) final;
  
  void BindPdfToPwgRasterConverter(::mojo::PendingReceiver<::printing::mojom::PdfToPwgRasterConverter> receiver) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  PrintingServiceStubDispatch {
 public:
  static bool Accept(PrintingService* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PrintingService* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PrintingService>>
class PrintingServiceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PrintingServiceStub() = default;
  ~PrintingServiceStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PrintingServiceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PrintingServiceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PrintingServiceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // printing::mojom

namespace mojo {

}  // namespace mojo

#endif  // CHROME_SERVICES_PRINTING_PUBLIC_MOJOM_PRINTING_SERVICE_MOJOM_H_