// chrome/services/printing/public/mojom/printing_service.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "chrome/services/printing/public/mojom/printing_service.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/services/printing/public/mojom/printing_service.mojom-params-data.h"
#include "chrome/services/printing/public/mojom/printing_service.mojom-shared-message-ids.h"

#include "chrome/services/printing/public/mojom/printing_service.mojom-import-headers.h"
#include "chrome/services/printing/public/mojom/printing_service.mojom-test-utils.h"


namespace printing::mojom {
// The declaration includes the definition on other builds.

PrintingService::IPCStableHashFunction PrintingService::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PrintingService>(message.name())) {
    case messages::PrintingService::kBindPdfNupConverter: {
      return &PrintingService::BindPdfNupConverter_Sym::IPCStableHash;
    }
    case messages::PrintingService::kBindPdfToPwgRasterConverter: {
      return &PrintingService::BindPdfToPwgRasterConverter_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PrintingService::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PrintingService>(message.name())) {
      case messages::PrintingService::kBindPdfNupConverter:
            return "Receive printing::mojom::PrintingService::BindPdfNupConverter";
      case messages::PrintingService::kBindPdfToPwgRasterConverter:
            return "Receive printing::mojom::PrintingService::BindPdfToPwgRasterConverter";
    }
  } else {
    switch (static_cast<messages::PrintingService>(message.name())) {
      case messages::PrintingService::kBindPdfNupConverter:
            return "Receive reply printing::mojom::PrintingService::BindPdfNupConverter";
      case messages::PrintingService::kBindPdfToPwgRasterConverter:
            return "Receive reply printing::mojom::PrintingService::BindPdfToPwgRasterConverter";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PrintingService::BindPdfNupConverter_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6b25568c;  // IPCStableHash for printing::mojom::PrintingService::BindPdfNupConverter
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PrintingService::BindPdfToPwgRasterConverter_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3a0c3acf;  // IPCStableHash for printing::mojom::PrintingService::BindPdfToPwgRasterConverter
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

PrintingServiceProxy::PrintingServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PrintingServiceProxy::BindPdfNupConverter(
    ::mojo::PendingReceiver<::printing::mojom::PdfNupConverter> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send printing::mojom::PrintingService::BindPdfNupConverter", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::printing::mojom::PdfNupConverter>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PrintingService::kBindPdfNupConverter), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintingService_BindPdfNupConverter_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::printing::mojom::PdfNupConverterInterfaceBase>>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid receiver in PrintingService.BindPdfNupConverter request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintingService::Name_);
  message.set_method_name("BindPdfNupConverter");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PrintingServiceProxy::BindPdfToPwgRasterConverter(
    ::mojo::PendingReceiver<::printing::mojom::PdfToPwgRasterConverter> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send printing::mojom::PrintingService::BindPdfToPwgRasterConverter", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::printing::mojom::PdfToPwgRasterConverter>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PrintingService::kBindPdfToPwgRasterConverter), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintingService_BindPdfToPwgRasterConverter_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::printing::mojom::PdfToPwgRasterConverterInterfaceBase>>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid receiver in PrintingService.BindPdfToPwgRasterConverter request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintingService::Name_);
  message.set_method_name("BindPdfToPwgRasterConverter");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool PrintingServiceStubDispatch::Accept(
    PrintingService* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PrintingService>(message->header()->name)) {
    case messages::PrintingService::kBindPdfNupConverter: {
      DCHECK(message->is_serialized());
      internal::PrintingService_BindPdfNupConverter_Params_Data* params =
          reinterpret_cast<internal::PrintingService_BindPdfNupConverter_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PrintingService.0
      bool success = true;
      ::mojo::PendingReceiver<::printing::mojom::PdfNupConverter> p_receiver{};
      PrintingService_BindPdfNupConverter_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PrintingService::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindPdfNupConverter(        
        std::move(p_receiver));
      return true;
    }
    case messages::PrintingService::kBindPdfToPwgRasterConverter: {
      DCHECK(message->is_serialized());
      internal::PrintingService_BindPdfToPwgRasterConverter_Params_Data* params =
          reinterpret_cast<internal::PrintingService_BindPdfToPwgRasterConverter_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PrintingService.1
      bool success = true;
      ::mojo::PendingReceiver<::printing::mojom::PdfToPwgRasterConverter> p_receiver{};
      PrintingService_BindPdfToPwgRasterConverter_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PrintingService::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindPdfToPwgRasterConverter(        
        std::move(p_receiver));
      return true;
    }
  }
  return false;
}

// static
bool PrintingServiceStubDispatch::AcceptWithResponder(
    PrintingService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PrintingService>(message->header()->name)) {
    case messages::PrintingService::kBindPdfNupConverter: {
      break;
    }
    case messages::PrintingService::kBindPdfToPwgRasterConverter: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPrintingServiceValidationInfo[] = {
    { &internal::PrintingService_BindPdfNupConverter_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PrintingService_BindPdfToPwgRasterConverter_Params_Data::Validate,
     nullptr /* no response */},
};

bool PrintingServiceRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::printing::mojom::PrintingService::Name_,
    kPrintingServiceValidationInfo);
}



}  // printing::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace printing::mojom {


void PrintingServiceInterceptorForTesting::BindPdfNupConverter(::mojo::PendingReceiver<::printing::mojom::PdfNupConverter> receiver) {
  GetForwardingInterface()->BindPdfNupConverter(
    std::move(receiver)
    );
}
void PrintingServiceInterceptorForTesting::BindPdfToPwgRasterConverter(::mojo::PendingReceiver<::printing::mojom::PdfToPwgRasterConverter> receiver) {
  GetForwardingInterface()->BindPdfToPwgRasterConverter(
    std::move(receiver)
    );
}
PrintingServiceAsyncWaiter::PrintingServiceAsyncWaiter(
    PrintingService* proxy) : proxy_(proxy) {}

PrintingServiceAsyncWaiter::~PrintingServiceAsyncWaiter() = default;







}  // printing::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif