// chrome/services/printing/public/mojom/print_backend_service.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "chrome/services/printing/public/mojom/print_backend_service.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/services/printing/public/mojom/print_backend_service.mojom-params-data.h"
namespace printing {
namespace mojom {

namespace internal {
// static
bool PrintBackendService_EnumeratePrinters_ResponseParam_Result_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const PrintBackendService_EnumeratePrinters_ResponseParam_Result_Data* object = static_cast<const PrintBackendService_EnumeratePrinters_ResponseParam_Result_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case PrintBackendService_EnumeratePrinters_ResponseParam_Result_Tag::kSuccess: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_success, 1, validation_context)) {
        return false;
      }
      constexpr const mojo::internal::ContainerValidateParams& success_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      if (!mojo::internal::ValidateContainer(object->data.f_success, validation_context,
                                             &success_validate_params)) {
        return false;
      }
      return true;
    }
    case PrintBackendService_EnumeratePrinters_ResponseParam_Result_Tag::kFailure: {


      if (!::printing::mojom::internal::ResultCode_Data
            ::Validate(object->data.f_failure, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in PrintBackendService_EnumeratePrinters_ResponseParam_Result");
      return false;
    }
  }
}
// static
bool PrintBackendService_GetDefaultPrinterName_ResponseParam_Result_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const PrintBackendService_GetDefaultPrinterName_ResponseParam_Result_Data* object = static_cast<const PrintBackendService_GetDefaultPrinterName_ResponseParam_Result_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case PrintBackendService_GetDefaultPrinterName_ResponseParam_Result_Tag::kSuccess: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_success, 1, validation_context)) {
        return false;
      }
      constexpr const mojo::internal::ContainerValidateParams& success_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      if (!mojo::internal::ValidateContainer(object->data.f_success, validation_context,
                                             &success_validate_params)) {
        return false;
      }
      return true;
    }
    case PrintBackendService_GetDefaultPrinterName_ResponseParam_Result_Tag::kFailure: {


      if (!::printing::mojom::internal::ResultCode_Data
            ::Validate(object->data.f_failure, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in PrintBackendService_GetDefaultPrinterName_ResponseParam_Result");
      return false;
    }
  }
}
// static
bool PrintBackendService_FetchCapabilities_ResponseParam_Result_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const PrintBackendService_FetchCapabilities_ResponseParam_Result_Data* object = static_cast<const PrintBackendService_FetchCapabilities_ResponseParam_Result_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case PrintBackendService_FetchCapabilities_ResponseParam_Result_Tag::kSuccess: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_success, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_success, validation_context))
        return false;
      return true;
    }
    case PrintBackendService_FetchCapabilities_ResponseParam_Result_Tag::kFailure: {


      if (!::printing::mojom::internal::ResultCode_Data
            ::Validate(object->data.f_failure, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in PrintBackendService_FetchCapabilities_ResponseParam_Result");
      return false;
    }
  }
}
// static
bool PrintBackendService_UseDefaultSettings_ResponseParam_Result_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const PrintBackendService_UseDefaultSettings_ResponseParam_Result_Data* object = static_cast<const PrintBackendService_UseDefaultSettings_ResponseParam_Result_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case PrintBackendService_UseDefaultSettings_ResponseParam_Result_Tag::kSuccess: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_success, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_success, validation_context))
        return false;
      return true;
    }
    case PrintBackendService_UseDefaultSettings_ResponseParam_Result_Tag::kFailure: {


      if (!::printing::mojom::internal::ResultCode_Data
            ::Validate(object->data.f_failure, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in PrintBackendService_UseDefaultSettings_ResponseParam_Result");
      return false;
    }
  }
}
// static
bool PrintBackendService_UpdatePrintSettings_ResponseParam_Result_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const PrintBackendService_UpdatePrintSettings_ResponseParam_Result_Data* object = static_cast<const PrintBackendService_UpdatePrintSettings_ResponseParam_Result_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case PrintBackendService_UpdatePrintSettings_ResponseParam_Result_Tag::kSuccess: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_success, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_success, validation_context))
        return false;
      return true;
    }
    case PrintBackendService_UpdatePrintSettings_ResponseParam_Result_Tag::kFailure: {


      if (!::printing::mojom::internal::ResultCode_Data
            ::Validate(object->data.f_failure, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in PrintBackendService_UpdatePrintSettings_ResponseParam_Result");
      return false;
    }
  }
}


// static
bool PrinterCapsAndInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PrinterCapsAndInfo_Data* object =
      static_cast<const PrinterCapsAndInfo_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->printer_info, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->printer_info, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->printer_caps, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->printer_caps, validation_context))
    return false;

  return true;
}

PrinterCapsAndInfo_Data::PrinterCapsAndInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UnsandboxedPrintBackendHost_BindBackend_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UnsandboxedPrintBackendHost_BindBackend_Params_Data* object =
      static_cast<const UnsandboxedPrintBackendHost_BindBackend_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->service, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->service,
                                                 validation_context)) {
    return false;
  }

  return true;
}

UnsandboxedPrintBackendHost_BindBackend_Params_Data::UnsandboxedPrintBackendHost_BindBackend_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SandboxedPrintBackendHost_BindBackend_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SandboxedPrintBackendHost_BindBackend_Params_Data* object =
      static_cast<const SandboxedPrintBackendHost_BindBackend_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->service, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->service,
                                                 validation_context)) {
    return false;
  }

  return true;
}

SandboxedPrintBackendHost_BindBackend_Params_Data::SandboxedPrintBackendHost_BindBackend_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PrintBackendService_Init_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PrintBackendService_Init_Params_Data* object =
      static_cast<const PrintBackendService_Init_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->locale, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& locale_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->locale, validation_context,
                                         &locale_validate_params)) {
    return false;
  }

  return true;
}

PrintBackendService_Init_Params_Data::PrintBackendService_Init_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PrintBackendService_Poke_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PrintBackendService_Poke_Params_Data* object =
      static_cast<const PrintBackendService_Poke_Params_Data*>(data);

  return true;
}

PrintBackendService_Poke_Params_Data::PrintBackendService_Poke_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PrintBackendService_EnumeratePrinters_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PrintBackendService_EnumeratePrinters_Params_Data* object =
      static_cast<const PrintBackendService_EnumeratePrinters_Params_Data*>(data);

  return true;
}

PrintBackendService_EnumeratePrinters_Params_Data::PrintBackendService_EnumeratePrinters_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PrintBackendService_EnumeratePrinters_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PrintBackendService_EnumeratePrinters_ResponseParams_Data* object =
      static_cast<const PrintBackendService_EnumeratePrinters_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->result, validation_context))
    return false;

  return true;
}

PrintBackendService_EnumeratePrinters_ResponseParams_Data::PrintBackendService_EnumeratePrinters_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PrintBackendService_GetDefaultPrinterName_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PrintBackendService_GetDefaultPrinterName_Params_Data* object =
      static_cast<const PrintBackendService_GetDefaultPrinterName_Params_Data*>(data);

  return true;
}

PrintBackendService_GetDefaultPrinterName_Params_Data::PrintBackendService_GetDefaultPrinterName_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PrintBackendService_GetDefaultPrinterName_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PrintBackendService_GetDefaultPrinterName_ResponseParams_Data* object =
      static_cast<const PrintBackendService_GetDefaultPrinterName_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->result, validation_context))
    return false;

  return true;
}

PrintBackendService_GetDefaultPrinterName_ResponseParams_Data::PrintBackendService_GetDefaultPrinterName_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PrintBackendService_FetchCapabilities_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PrintBackendService_FetchCapabilities_Params_Data* object =
      static_cast<const PrintBackendService_FetchCapabilities_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->printer_name, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& printer_name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->printer_name, validation_context,
                                         &printer_name_validate_params)) {
    return false;
  }

  return true;
}

PrintBackendService_FetchCapabilities_Params_Data::PrintBackendService_FetchCapabilities_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PrintBackendService_FetchCapabilities_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PrintBackendService_FetchCapabilities_ResponseParams_Data* object =
      static_cast<const PrintBackendService_FetchCapabilities_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->result, validation_context))
    return false;

  return true;
}

PrintBackendService_FetchCapabilities_ResponseParams_Data::PrintBackendService_FetchCapabilities_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PrintBackendService_EstablishPrintingContext_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PrintBackendService_EstablishPrintingContext_Params_Data* object =
      static_cast<const PrintBackendService_EstablishPrintingContext_Params_Data*>(data);

  return true;
}

PrintBackendService_EstablishPrintingContext_Params_Data::PrintBackendService_EstablishPrintingContext_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PrintBackendService_UseDefaultSettings_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PrintBackendService_UseDefaultSettings_Params_Data* object =
      static_cast<const PrintBackendService_UseDefaultSettings_Params_Data*>(data);

  return true;
}

PrintBackendService_UseDefaultSettings_Params_Data::PrintBackendService_UseDefaultSettings_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PrintBackendService_UseDefaultSettings_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PrintBackendService_UseDefaultSettings_ResponseParams_Data* object =
      static_cast<const PrintBackendService_UseDefaultSettings_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->result, validation_context))
    return false;

  return true;
}

PrintBackendService_UseDefaultSettings_ResponseParams_Data::PrintBackendService_UseDefaultSettings_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PrintBackendService_UpdatePrintSettings_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PrintBackendService_UpdatePrintSettings_Params_Data* object =
      static_cast<const PrintBackendService_UpdatePrintSettings_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->job_settings, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->job_settings, validation_context))
    return false;

  return true;
}

PrintBackendService_UpdatePrintSettings_Params_Data::PrintBackendService_UpdatePrintSettings_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PrintBackendService_UpdatePrintSettings_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PrintBackendService_UpdatePrintSettings_ResponseParams_Data* object =
      static_cast<const PrintBackendService_UpdatePrintSettings_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->result, validation_context))
    return false;

  return true;
}

PrintBackendService_UpdatePrintSettings_ResponseParams_Data::PrintBackendService_UpdatePrintSettings_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PrintBackendService_StartPrinting_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PrintBackendService_StartPrinting_Params_Data* object =
      static_cast<const PrintBackendService_StartPrinting_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->document_name, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->document_name, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->settings, validation_context))
    return false;

  return true;
}

PrintBackendService_StartPrinting_Params_Data::PrintBackendService_StartPrinting_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PrintBackendService_StartPrinting_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PrintBackendService_StartPrinting_ResponseParams_Data* object =
      static_cast<const PrintBackendService_StartPrinting_ResponseParams_Data*>(data);


  if (!::printing::mojom::internal::ResultCode_Data
        ::Validate(object->result_code, validation_context))
    return false;

  return true;
}

PrintBackendService_StartPrinting_ResponseParams_Data::PrintBackendService_StartPrinting_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PrintBackendService_RenderPrintedDocument_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PrintBackendService_RenderPrintedDocument_Params_Data* object =
      static_cast<const PrintBackendService_RenderPrintedDocument_Params_Data*>(data);


  if (!::printing::mojom::internal::MetafileDataType_Data
        ::Validate(object->data_type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->serialized_doc, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->serialized_doc, validation_context))
    return false;

  return true;
}

PrintBackendService_RenderPrintedDocument_Params_Data::PrintBackendService_RenderPrintedDocument_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PrintBackendService_RenderPrintedDocument_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PrintBackendService_RenderPrintedDocument_ResponseParams_Data* object =
      static_cast<const PrintBackendService_RenderPrintedDocument_ResponseParams_Data*>(data);


  if (!::printing::mojom::internal::ResultCode_Data
        ::Validate(object->result_code, validation_context))
    return false;

  return true;
}

PrintBackendService_RenderPrintedDocument_ResponseParams_Data::PrintBackendService_RenderPrintedDocument_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PrintBackendService_DocumentDone_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PrintBackendService_DocumentDone_Params_Data* object =
      static_cast<const PrintBackendService_DocumentDone_Params_Data*>(data);

  return true;
}

PrintBackendService_DocumentDone_Params_Data::PrintBackendService_DocumentDone_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PrintBackendService_DocumentDone_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PrintBackendService_DocumentDone_ResponseParams_Data* object =
      static_cast<const PrintBackendService_DocumentDone_ResponseParams_Data*>(data);


  if (!::printing::mojom::internal::ResultCode_Data
        ::Validate(object->result_code, validation_context))
    return false;

  return true;
}

PrintBackendService_DocumentDone_ResponseParams_Data::PrintBackendService_DocumentDone_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PrintBackendService_Cancel_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PrintBackendService_Cancel_Params_Data* object =
      static_cast<const PrintBackendService_Cancel_Params_Data*>(data);

  return true;
}

PrintBackendService_Cancel_Params_Data::PrintBackendService_Cancel_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PrintBackendService_Cancel_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PrintBackendService_Cancel_ResponseParams_Data* object =
      static_cast<const PrintBackendService_Cancel_ResponseParams_Data*>(data);

  return true;
}

PrintBackendService_Cancel_ResponseParams_Data::PrintBackendService_Cancel_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace printing