// chrome/services/printing/public/mojom/pdf_nup_converter.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_SERVICES_PRINTING_PUBLIC_MOJOM_PDF_NUP_CONVERTER_MOJOM_PARAMS_DATA_H_
#define CHROME_SERVICES_PRINTING_PUBLIC_MOJOM_PDF_NUP_CONVERTER_MOJOM_PARAMS_DATA_H_

#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

namespace mojo::internal {
class ValidationContext;
}


namespace printing::mojom {
namespace internal {
class  PdfNupConverter_NupPageConvert_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint32_t pages_per_sheet;
  uint8_t pad0_[4];
  mojo::internal::Pointer<::gfx::mojom::internal::Size_Data> page_size;
  mojo::internal::Pointer<::gfx::mojom::internal::Rect_Data> printable_area;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<::mojo_base::mojom::internal::ReadOnlySharedMemoryRegion_Data>>> pdf_page_regions;

 private:
  friend class mojo::internal::MessageFragment<PdfNupConverter_NupPageConvert_Params_Data>;

  PdfNupConverter_NupPageConvert_Params_Data();
  ~PdfNupConverter_NupPageConvert_Params_Data() = delete;
};
static_assert(sizeof(PdfNupConverter_NupPageConvert_Params_Data) == 40,
              "Bad sizeof(PdfNupConverter_NupPageConvert_Params_Data)");
class  PdfNupConverter_NupPageConvert_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t status;
  uint8_t pad0_[4];
  mojo::internal::Pointer<::mojo_base::mojom::internal::ReadOnlySharedMemoryRegion_Data> pdf_region;

 private:
  friend class mojo::internal::MessageFragment<PdfNupConverter_NupPageConvert_ResponseParams_Data>;

  PdfNupConverter_NupPageConvert_ResponseParams_Data();
  ~PdfNupConverter_NupPageConvert_ResponseParams_Data() = delete;
};
static_assert(sizeof(PdfNupConverter_NupPageConvert_ResponseParams_Data) == 24,
              "Bad sizeof(PdfNupConverter_NupPageConvert_ResponseParams_Data)");
class  PdfNupConverter_NupDocumentConvert_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint32_t pages_per_sheet;
  uint8_t pad0_[4];
  mojo::internal::Pointer<::gfx::mojom::internal::Size_Data> page_size;
  mojo::internal::Pointer<::gfx::mojom::internal::Rect_Data> printable_area;
  mojo::internal::Pointer<::mojo_base::mojom::internal::ReadOnlySharedMemoryRegion_Data> src_pdf_region;

 private:
  friend class mojo::internal::MessageFragment<PdfNupConverter_NupDocumentConvert_Params_Data>;

  PdfNupConverter_NupDocumentConvert_Params_Data();
  ~PdfNupConverter_NupDocumentConvert_Params_Data() = delete;
};
static_assert(sizeof(PdfNupConverter_NupDocumentConvert_Params_Data) == 40,
              "Bad sizeof(PdfNupConverter_NupDocumentConvert_Params_Data)");
class  PdfNupConverter_NupDocumentConvert_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t status;
  uint8_t pad0_[4];
  mojo::internal::Pointer<::mojo_base::mojom::internal::ReadOnlySharedMemoryRegion_Data> pdf_region;

 private:
  friend class mojo::internal::MessageFragment<PdfNupConverter_NupDocumentConvert_ResponseParams_Data>;

  PdfNupConverter_NupDocumentConvert_ResponseParams_Data();
  ~PdfNupConverter_NupDocumentConvert_ResponseParams_Data() = delete;
};
static_assert(sizeof(PdfNupConverter_NupDocumentConvert_ResponseParams_Data) == 24,
              "Bad sizeof(PdfNupConverter_NupDocumentConvert_ResponseParams_Data)");
class  PdfNupConverter_SetWebContentsURL_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> url;

 private:
  friend class mojo::internal::MessageFragment<PdfNupConverter_SetWebContentsURL_Params_Data>;

  PdfNupConverter_SetWebContentsURL_Params_Data();
  ~PdfNupConverter_SetWebContentsURL_Params_Data() = delete;
};
static_assert(sizeof(PdfNupConverter_SetWebContentsURL_Params_Data) == 16,
              "Bad sizeof(PdfNupConverter_SetWebContentsURL_Params_Data)");
class  PdfNupConverter_SetUseSkiaRendererPolicy_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t use_skia : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<PdfNupConverter_SetUseSkiaRendererPolicy_Params_Data>;

  PdfNupConverter_SetUseSkiaRendererPolicy_Params_Data();
  ~PdfNupConverter_SetUseSkiaRendererPolicy_Params_Data() = delete;
};
static_assert(sizeof(PdfNupConverter_SetUseSkiaRendererPolicy_Params_Data) == 16,
              "Bad sizeof(PdfNupConverter_SetUseSkiaRendererPolicy_Params_Data)");

}  // namespace internal


class PdfNupConverter_NupPageConvert_ParamsDataView {
 public:
  PdfNupConverter_NupPageConvert_ParamsDataView() = default;

  PdfNupConverter_NupPageConvert_ParamsDataView(
      internal::PdfNupConverter_NupPageConvert_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  uint32_t pages_per_sheet() const {
    return data_->pages_per_sheet;
  }
  inline void GetPageSizeDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPageSize(UserType* output) {
    
    auto* pointer = data_->page_size.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
  inline void GetPrintableAreaDataView(
      ::gfx::mojom::RectDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPrintableArea(UserType* output) {
    
    auto* pointer = data_->printable_area.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        pointer, output, message_);
  }
  inline void GetPdfPageRegionsDataView(
      mojo::ArrayDataView<::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPdfPageRegions(UserType* output) {
    
    auto* pointer = data_->pdf_page_regions.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView>>(
        pointer, output, message_);
  }
 private:
  internal::PdfNupConverter_NupPageConvert_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PdfNupConverter_NupPageConvert_ResponseParamsDataView {
 public:
  PdfNupConverter_NupPageConvert_ResponseParamsDataView() = default;

  PdfNupConverter_NupPageConvert_ResponseParamsDataView(
      internal::PdfNupConverter_NupPageConvert_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadStatus(UserType* output) const {
    auto data_value = data_->status;
    return mojo::internal::Deserialize<::printing::mojom::PdfNupConverter_Status>(
        data_value, output);
  }
  PdfNupConverter_Status status() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::printing::mojom::PdfNupConverter_Status>(data_->status));
  }
  inline void GetPdfRegionDataView(
      ::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPdfRegion(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView, UserType>(),
    "Attempting to read the optional `pdf_region` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPdfRegion` instead "
    "of `ReadPdfRegion if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->pdf_region.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView>(
        pointer, output, message_);
  }
 private:
  internal::PdfNupConverter_NupPageConvert_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PdfNupConverter_NupDocumentConvert_ParamsDataView {
 public:
  PdfNupConverter_NupDocumentConvert_ParamsDataView() = default;

  PdfNupConverter_NupDocumentConvert_ParamsDataView(
      internal::PdfNupConverter_NupDocumentConvert_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  uint32_t pages_per_sheet() const {
    return data_->pages_per_sheet;
  }
  inline void GetPageSizeDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPageSize(UserType* output) {
    
    auto* pointer = data_->page_size.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
  inline void GetPrintableAreaDataView(
      ::gfx::mojom::RectDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPrintableArea(UserType* output) {
    
    auto* pointer = data_->printable_area.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        pointer, output, message_);
  }
  inline void GetSrcPdfRegionDataView(
      ::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSrcPdfRegion(UserType* output) {
    
    auto* pointer = data_->src_pdf_region.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView>(
        pointer, output, message_);
  }
 private:
  internal::PdfNupConverter_NupDocumentConvert_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PdfNupConverter_NupDocumentConvert_ResponseParamsDataView {
 public:
  PdfNupConverter_NupDocumentConvert_ResponseParamsDataView() = default;

  PdfNupConverter_NupDocumentConvert_ResponseParamsDataView(
      internal::PdfNupConverter_NupDocumentConvert_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadStatus(UserType* output) const {
    auto data_value = data_->status;
    return mojo::internal::Deserialize<::printing::mojom::PdfNupConverter_Status>(
        data_value, output);
  }
  PdfNupConverter_Status status() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::printing::mojom::PdfNupConverter_Status>(data_->status));
  }
  inline void GetPdfRegionDataView(
      ::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPdfRegion(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView, UserType>(),
    "Attempting to read the optional `pdf_region` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPdfRegion` instead "
    "of `ReadPdfRegion if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->pdf_region.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView>(
        pointer, output, message_);
  }
 private:
  internal::PdfNupConverter_NupDocumentConvert_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PdfNupConverter_SetWebContentsURL_ParamsDataView {
 public:
  PdfNupConverter_SetWebContentsURL_ParamsDataView() = default;

  PdfNupConverter_SetWebContentsURL_ParamsDataView(
      internal::PdfNupConverter_SetWebContentsURL_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
 private:
  internal::PdfNupConverter_SetWebContentsURL_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PdfNupConverter_SetUseSkiaRendererPolicy_ParamsDataView {
 public:
  PdfNupConverter_SetUseSkiaRendererPolicy_ParamsDataView() = default;

  PdfNupConverter_SetUseSkiaRendererPolicy_ParamsDataView(
      internal::PdfNupConverter_SetUseSkiaRendererPolicy_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool use_skia() const {
    return data_->use_skia;
  }
 private:
  internal::PdfNupConverter_SetUseSkiaRendererPolicy_Params_Data* data_ = nullptr;
};

inline void PdfNupConverter_NupPageConvert_ParamsDataView::GetPageSizeDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->page_size.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, message_);
}
inline void PdfNupConverter_NupPageConvert_ParamsDataView::GetPrintableAreaDataView(
    ::gfx::mojom::RectDataView* output) {
  auto pointer = data_->printable_area.Get();
  *output = ::gfx::mojom::RectDataView(pointer, message_);
}
inline void PdfNupConverter_NupPageConvert_ParamsDataView::GetPdfPageRegionsDataView(
    mojo::ArrayDataView<::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView>* output) {
  auto pointer = data_->pdf_page_regions.Get();
  *output = mojo::ArrayDataView<::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView>(pointer, message_);
}


inline void PdfNupConverter_NupPageConvert_ResponseParamsDataView::GetPdfRegionDataView(
    ::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView* output) {
  auto pointer = data_->pdf_region.Get();
  *output = ::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView(pointer, message_);
}


inline void PdfNupConverter_NupDocumentConvert_ParamsDataView::GetPageSizeDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->page_size.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, message_);
}
inline void PdfNupConverter_NupDocumentConvert_ParamsDataView::GetPrintableAreaDataView(
    ::gfx::mojom::RectDataView* output) {
  auto pointer = data_->printable_area.Get();
  *output = ::gfx::mojom::RectDataView(pointer, message_);
}
inline void PdfNupConverter_NupDocumentConvert_ParamsDataView::GetSrcPdfRegionDataView(
    ::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView* output) {
  auto pointer = data_->src_pdf_region.Get();
  *output = ::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView(pointer, message_);
}


inline void PdfNupConverter_NupDocumentConvert_ResponseParamsDataView::GetPdfRegionDataView(
    ::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView* output) {
  auto pointer = data_->pdf_region.Get();
  *output = ::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView(pointer, message_);
}


inline void PdfNupConverter_SetWebContentsURL_ParamsDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}





}  // printing::mojom

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // CHROME_SERVICES_PRINTING_PUBLIC_MOJOM_PDF_NUP_CONVERTER_MOJOM_PARAMS_DATA_H_