// chrome/services/media_gallery_util/public/mojom/media_parser.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "chrome/services/media_gallery_util/public/mojom/media_parser.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/services/media_gallery_util/public/mojom/media_parser.mojom-params-data.h"
#include "chrome/services/media_gallery_util/public/mojom/media_parser.mojom-shared-message-ids.h"

#include "chrome/services/media_gallery_util/public/mojom/media_parser.mojom-import-headers.h"
#include "chrome/services/media_gallery_util/public/mojom/media_parser.mojom-test-utils.h"


namespace chrome::mojom {
MediaStreamInfo::MediaStreamInfo()
    : type(),
      additional_properties() {}

MediaStreamInfo::MediaStreamInfo(
    const std::string& type_in,
    ::base::Value::Dict additional_properties_in)
    : type(std::move(type_in)),
      additional_properties(std::move(additional_properties_in)) {}

MediaStreamInfo::~MediaStreamInfo() = default;

void MediaStreamInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "type"), this->type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "additional_properties"), this->additional_properties,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::Value::Dict>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool MediaStreamInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
MediaMetadata::MediaMetadata()
    : mime_type(),
      height(-1),
      width(-1),
      duration(-1),
      rotation(),
      album(),
      artist(),
      comment(),
      copyright(),
      disc(-1),
      genre(),
      language(),
      title(),
      track(-1),
      raw_tags() {}

MediaMetadata::MediaMetadata(
    const std::string& mime_type_in,
    int32_t height_in,
    int32_t width_in,
    double duration_in,
    int32_t rotation_in,
    const std::string& album_in,
    const std::string& artist_in,
    const std::string& comment_in,
    const std::string& copyright_in,
    int32_t disc_in,
    const std::string& genre_in,
    const std::string& language_in,
    const std::string& title_in,
    int32_t track_in,
    std::vector<MediaStreamInfoPtr> raw_tags_in)
    : mime_type(std::move(mime_type_in)),
      height(std::move(height_in)),
      width(std::move(width_in)),
      duration(std::move(duration_in)),
      rotation(std::move(rotation_in)),
      album(std::move(album_in)),
      artist(std::move(artist_in)),
      comment(std::move(comment_in)),
      copyright(std::move(copyright_in)),
      disc(std::move(disc_in)),
      genre(std::move(genre_in)),
      language(std::move(language_in)),
      title(std::move(title_in)),
      track(std::move(track_in)),
      raw_tags(std::move(raw_tags_in)) {}

MediaMetadata::~MediaMetadata() = default;

void MediaMetadata::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mime_type"), this->mime_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "height"), this->height,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "width"), this->width,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "duration"), this->duration,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "rotation"), this->rotation,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "album"), this->album,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "artist"), this->artist,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "comment"), this->comment,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "copyright"), this->copyright,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "disc"), this->disc,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "genre"), this->genre,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "language"), this->language,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "title"), this->title,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "track"), this->track,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "raw_tags"), this->raw_tags,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<MediaStreamInfoPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool MediaMetadata::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AttachedImage::AttachedImage()
    : type(),
      data() {}

AttachedImage::AttachedImage(
    const std::string& type_in,
    std::vector<uint8_t> data_in)
    : type(std::move(type_in)),
      data(std::move(data_in)) {}

AttachedImage::~AttachedImage() = default;

void AttachedImage::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "type"), this->type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "data"), this->data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<uint8_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AttachedImage::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

MediaParser::IPCStableHashFunction MediaParser::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::MediaParser>(message.name())) {
    case messages::MediaParser::kParseMediaMetadata: {
      return &MediaParser::ParseMediaMetadata_Sym::IPCStableHash;
    }
    case messages::MediaParser::kCheckMediaFile: {
      return &MediaParser::CheckMediaFile_Sym::IPCStableHash;
    }
    case messages::MediaParser::kGetCpuInfo: {
      return &MediaParser::GetCpuInfo_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* MediaParser::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::MediaParser>(message.name())) {
      case messages::MediaParser::kParseMediaMetadata:
            return "Receive chrome::mojom::MediaParser::ParseMediaMetadata";
      case messages::MediaParser::kCheckMediaFile:
            return "Receive chrome::mojom::MediaParser::CheckMediaFile";
      case messages::MediaParser::kGetCpuInfo:
            return "Receive chrome::mojom::MediaParser::GetCpuInfo";
    }
  } else {
    switch (static_cast<messages::MediaParser>(message.name())) {
      case messages::MediaParser::kParseMediaMetadata:
            return "Receive reply chrome::mojom::MediaParser::ParseMediaMetadata";
      case messages::MediaParser::kCheckMediaFile:
            return "Receive reply chrome::mojom::MediaParser::CheckMediaFile";
      case messages::MediaParser::kGetCpuInfo:
            return "Receive reply chrome::mojom::MediaParser::GetCpuInfo";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t MediaParser::ParseMediaMetadata_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd55326f2;  // IPCStableHash for chrome::mojom::MediaParser::ParseMediaMetadata
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaParser::CheckMediaFile_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5d6d6bb7;  // IPCStableHash for chrome::mojom::MediaParser::CheckMediaFile
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaParser::GetCpuInfo_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xff2e40c4;  // IPCStableHash for chrome::mojom::MediaParser::GetCpuInfo
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class MediaParser_ParseMediaMetadata_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  MediaParser_ParseMediaMetadata_ForwardToCallback(
      MediaParser::ParseMediaMetadataCallback callback
      ) : callback_(std::move(callback)) {
  }

  MediaParser_ParseMediaMetadata_ForwardToCallback(const MediaParser_ParseMediaMetadata_ForwardToCallback&) = delete;
  MediaParser_ParseMediaMetadata_ForwardToCallback& operator=(const MediaParser_ParseMediaMetadata_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  MediaParser::ParseMediaMetadataCallback callback_;
};

class MediaParser_CheckMediaFile_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  MediaParser_CheckMediaFile_ForwardToCallback(
      MediaParser::CheckMediaFileCallback callback
      ) : callback_(std::move(callback)) {
  }

  MediaParser_CheckMediaFile_ForwardToCallback(const MediaParser_CheckMediaFile_ForwardToCallback&) = delete;
  MediaParser_CheckMediaFile_ForwardToCallback& operator=(const MediaParser_CheckMediaFile_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  MediaParser::CheckMediaFileCallback callback_;
};

class MediaParser_GetCpuInfo_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  MediaParser_GetCpuInfo_ForwardToCallback(
      MediaParser::GetCpuInfoCallback callback
      ) : callback_(std::move(callback)) {
  }

  MediaParser_GetCpuInfo_ForwardToCallback(const MediaParser_GetCpuInfo_ForwardToCallback&) = delete;
  MediaParser_GetCpuInfo_ForwardToCallback& operator=(const MediaParser_GetCpuInfo_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  MediaParser::GetCpuInfoCallback callback_;
};

MediaParserProxy::MediaParserProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void MediaParserProxy::ParseMediaMetadata(
    const std::string& in_mime_type, int64_t in_total_size, bool in_get_attached_images, ::mojo::PendingRemote<MediaDataSource> in_media_data_source, ParseMediaMetadataCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send chrome::mojom::MediaParser::ParseMediaMetadata", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("mime_type"), in_mime_type,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("total_size"), in_total_size,
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("get_attached_images"), in_get_attached_images,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("media_data_source"), in_media_data_source,
                        "<value of type ::mojo::PendingRemote<MediaDataSource>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaParser::kParseMediaMetadata), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::MediaParser_ParseMediaMetadata_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->mime_type)::BaseType> mime_type_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_mime_type,
    mime_type_fragment);

  params->mime_type.Set(
      mime_type_fragment.is_null() ? nullptr : mime_type_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->mime_type.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null mime_type in MediaParser.ParseMediaMetadata request");

  params->total_size = in_total_size;

  params->get_attached_images = in_get_attached_images;

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::chrome::mojom::MediaDataSourceInterfaceBase>>(
    in_media_data_source,
    &params->media_data_source,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->media_data_source)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid media_data_source in MediaParser.ParseMediaMetadata request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaParser::Name_);
  message.set_method_name("ParseMediaMetadata");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new MediaParser_ParseMediaMetadata_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void MediaParserProxy::CheckMediaFile(
    ::base::TimeDelta in_decode_time, ::base::File in_file, CheckMediaFileCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send chrome::mojom::MediaParser::CheckMediaFile", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("decode_time"), in_decode_time,
                        "<value of type ::base::TimeDelta>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("file"), in_file,
                        "<value of type ::base::File>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaParser::kCheckMediaFile), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::MediaParser_CheckMediaFile_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->decode_time)::BaseType> decode_time_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
    in_decode_time,
    decode_time_fragment);

  params->decode_time.Set(
      decode_time_fragment.is_null() ? nullptr : decode_time_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->decode_time.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null decode_time in MediaParser.CheckMediaFile request");
  mojo::internal::MessageFragment<
      typename decltype(params->file)::BaseType> file_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::ReadOnlyFileDataView>(
    in_file,
    file_fragment);

  params->file.Set(
      file_fragment.is_null() ? nullptr : file_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->file.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null file in MediaParser.CheckMediaFile request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaParser::Name_);
  message.set_method_name("CheckMediaFile");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new MediaParser_CheckMediaFile_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void MediaParserProxy::GetCpuInfo(
    GetCpuInfoCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send chrome::mojom::MediaParser::GetCpuInfo");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaParser::kGetCpuInfo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::MediaParser_GetCpuInfo_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaParser::Name_);
  message.set_method_name("GetCpuInfo");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new MediaParser_GetCpuInfo_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class MediaParser_ParseMediaMetadata_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static MediaParser::ParseMediaMetadataCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<MediaParser_ParseMediaMetadata_ProxyToResponder> proxy(
        new MediaParser_ParseMediaMetadata_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&MediaParser_ParseMediaMetadata_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~MediaParser_ParseMediaMetadata_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  MediaParser_ParseMediaMetadata_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "MediaParser::ParseMediaMetadataCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_parse_success, MediaMetadataPtr in_metadata, const std::vector<::metadata::AttachedImage>& in_attached_images);
};

bool MediaParser_ParseMediaMetadata_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::MediaParser_ParseMediaMetadata_ResponseParams_Data* params =
      reinterpret_cast<
          internal::MediaParser_ParseMediaMetadata_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for MediaParser.0
  bool success = true;
  bool p_parse_success{};
  MediaMetadataPtr p_metadata{};
  std::vector<::metadata::AttachedImage> p_attached_images{};
  MediaParser_ParseMediaMetadata_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_parse_success = input_data_view.parse_success();
  if (success && !input_data_view.ReadMetadata(&p_metadata))
    success = false;
  if (success && !input_data_view.ReadAttachedImages(&p_attached_images))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        MediaParser::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_parse_success), 
std::move(p_metadata), 
std::move(p_attached_images));
  }
  return true;
}

void MediaParser_ParseMediaMetadata_ProxyToResponder::Run(
    bool in_parse_success, MediaMetadataPtr in_metadata, const std::vector<::metadata::AttachedImage>& in_attached_images) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply chrome::mojom::MediaParser::ParseMediaMetadata", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("parse_success"), in_parse_success,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("metadata"), in_metadata,
                        "<value of type MediaMetadataPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("attached_images"), in_attached_images,
                        "<value of type const std::vector<::metadata::AttachedImage>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaParser::kParseMediaMetadata), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::MediaParser_ParseMediaMetadata_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->parse_success = in_parse_success;
  mojo::internal::MessageFragment<
      typename decltype(params->metadata)::BaseType> metadata_fragment(
          params.message());
  
  mojo::internal::Serialize<::chrome::mojom::MediaMetadataDataView>(
    in_metadata,
    metadata_fragment);

  params->metadata.Set(
      metadata_fragment.is_null() ? nullptr : metadata_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->metadata.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null metadata in ");
  mojo::internal::MessageFragment<
      typename decltype(params->attached_images)::BaseType>
      attached_images_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& attached_images_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::chrome::mojom::AttachedImageDataView>>(
    in_attached_images,
    attached_images_fragment,
    &attached_images_validate_params);

  params->attached_images.Set(
      attached_images_fragment.is_null() ? nullptr : attached_images_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->attached_images.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null attached_images in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaParser::Name_);
  message.set_method_name("ParseMediaMetadata");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class MediaParser_CheckMediaFile_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static MediaParser::CheckMediaFileCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<MediaParser_CheckMediaFile_ProxyToResponder> proxy(
        new MediaParser_CheckMediaFile_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&MediaParser_CheckMediaFile_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~MediaParser_CheckMediaFile_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  MediaParser_CheckMediaFile_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "MediaParser::CheckMediaFileCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);
};

bool MediaParser_CheckMediaFile_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::MediaParser_CheckMediaFile_ResponseParams_Data* params =
      reinterpret_cast<
          internal::MediaParser_CheckMediaFile_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for MediaParser.1
  bool success = true;
  bool p_success{};
  MediaParser_CheckMediaFile_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        MediaParser::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success));
  }
  return true;
}

void MediaParser_CheckMediaFile_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply chrome::mojom::MediaParser::CheckMediaFile", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaParser::kCheckMediaFile), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::MediaParser_CheckMediaFile_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaParser::Name_);
  message.set_method_name("CheckMediaFile");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class MediaParser_GetCpuInfo_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static MediaParser::GetCpuInfoCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<MediaParser_GetCpuInfo_ProxyToResponder> proxy(
        new MediaParser_GetCpuInfo_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&MediaParser_GetCpuInfo_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~MediaParser_GetCpuInfo_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  MediaParser_GetCpuInfo_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "MediaParser::GetCpuInfoCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      int64_t in_libyuv_cpu_flags, int64_t in_ffmpeg_cpu_flags);
};

bool MediaParser_GetCpuInfo_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::MediaParser_GetCpuInfo_ResponseParams_Data* params =
      reinterpret_cast<
          internal::MediaParser_GetCpuInfo_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for MediaParser.2
  bool success = true;
  int64_t p_libyuv_cpu_flags{};
  int64_t p_ffmpeg_cpu_flags{};
  MediaParser_GetCpuInfo_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_libyuv_cpu_flags = input_data_view.libyuv_cpu_flags();
  if (success)
    p_ffmpeg_cpu_flags = input_data_view.ffmpeg_cpu_flags();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        MediaParser::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_libyuv_cpu_flags), 
std::move(p_ffmpeg_cpu_flags));
  }
  return true;
}

void MediaParser_GetCpuInfo_ProxyToResponder::Run(
    int64_t in_libyuv_cpu_flags, int64_t in_ffmpeg_cpu_flags) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply chrome::mojom::MediaParser::GetCpuInfo", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("libyuv_cpu_flags"), in_libyuv_cpu_flags,
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("ffmpeg_cpu_flags"), in_ffmpeg_cpu_flags,
                        "<value of type int64_t>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaParser::kGetCpuInfo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::MediaParser_GetCpuInfo_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->libyuv_cpu_flags = in_libyuv_cpu_flags;

  params->ffmpeg_cpu_flags = in_ffmpeg_cpu_flags;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaParser::Name_);
  message.set_method_name("GetCpuInfo");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool MediaParserStubDispatch::Accept(
    MediaParser* impl,
    mojo::Message* message) {
  switch (static_cast<messages::MediaParser>(message->header()->name)) {
    case messages::MediaParser::kParseMediaMetadata: {
      break;
    }
    case messages::MediaParser::kCheckMediaFile: {
      break;
    }
    case messages::MediaParser::kGetCpuInfo: {
      break;
    }
  }
  return false;
}

// static
bool MediaParserStubDispatch::AcceptWithResponder(
    MediaParser* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::MediaParser>(message->header()->name)) {
    case messages::MediaParser::kParseMediaMetadata: {
      internal::MediaParser_ParseMediaMetadata_Params_Data* params =
          reinterpret_cast<
              internal::MediaParser_ParseMediaMetadata_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for MediaParser.0
      bool success = true;
      std::string p_mime_type{};
      int64_t p_total_size{};
      bool p_get_attached_images{};
      ::mojo::PendingRemote<MediaDataSource> p_media_data_source{};
      MediaParser_ParseMediaMetadata_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMimeType(&p_mime_type))
        success = false;
      if (success)
        p_total_size = input_data_view.total_size();
      if (success)
        p_get_attached_images = input_data_view.get_attached_images();
      if (success) {
        p_media_data_source =
            input_data_view.TakeMediaDataSource<decltype(p_media_data_source)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaParser::Name_, 0, false);
        return false;
      }
      auto callback =
          MediaParser_ParseMediaMetadata_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ParseMediaMetadata(        
        std::move(p_mime_type), 
        std::move(p_total_size), 
        std::move(p_get_attached_images), 
        std::move(p_media_data_source), std::move(callback));
      return true;
    }
    case messages::MediaParser::kCheckMediaFile: {
      internal::MediaParser_CheckMediaFile_Params_Data* params =
          reinterpret_cast<
              internal::MediaParser_CheckMediaFile_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for MediaParser.1
      bool success = true;
      ::base::TimeDelta p_decode_time{};
      ::base::File p_file{};
      MediaParser_CheckMediaFile_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDecodeTime(&p_decode_time))
        success = false;
      if (success && !input_data_view.ReadFile(&p_file))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaParser::Name_, 1, false);
        return false;
      }
      auto callback =
          MediaParser_CheckMediaFile_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CheckMediaFile(        
        std::move(p_decode_time), 
        std::move(p_file), std::move(callback));
      return true;
    }
    case messages::MediaParser::kGetCpuInfo: {
      internal::MediaParser_GetCpuInfo_Params_Data* params =
          reinterpret_cast<
              internal::MediaParser_GetCpuInfo_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for MediaParser.2
      bool success = true;
      MediaParser_GetCpuInfo_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaParser::Name_, 2, false);
        return false;
      }
      auto callback =
          MediaParser_GetCpuInfo_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetCpuInfo(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kMediaParserValidationInfo[] = {
    { &internal::MediaParser_ParseMediaMetadata_Params_Data::Validate,
     &internal::MediaParser_ParseMediaMetadata_ResponseParams_Data::Validate},
    { &internal::MediaParser_CheckMediaFile_Params_Data::Validate,
     &internal::MediaParser_CheckMediaFile_ResponseParams_Data::Validate},
    { &internal::MediaParser_GetCpuInfo_Params_Data::Validate,
     &internal::MediaParser_GetCpuInfo_ResponseParams_Data::Validate},
};

bool MediaParserRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::chrome::mojom::MediaParser::Name_,
    kMediaParserValidationInfo);
}

bool MediaParserResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::chrome::mojom::MediaParser::Name_,
    kMediaParserValidationInfo);
}
// The declaration includes the definition on other builds.

MediaParserFactory::IPCStableHashFunction MediaParserFactory::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::MediaParserFactory>(message.name())) {
    case messages::MediaParserFactory::kCreateMediaParser: {
      return &MediaParserFactory::CreateMediaParser_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* MediaParserFactory::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::MediaParserFactory>(message.name())) {
      case messages::MediaParserFactory::kCreateMediaParser:
            return "Receive chrome::mojom::MediaParserFactory::CreateMediaParser";
    }
  } else {
    switch (static_cast<messages::MediaParserFactory>(message.name())) {
      case messages::MediaParserFactory::kCreateMediaParser:
            return "Receive reply chrome::mojom::MediaParserFactory::CreateMediaParser";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t MediaParserFactory::CreateMediaParser_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa22a960b;  // IPCStableHash for chrome::mojom::MediaParserFactory::CreateMediaParser
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class MediaParserFactory_CreateMediaParser_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  MediaParserFactory_CreateMediaParser_ForwardToCallback(
      MediaParserFactory::CreateMediaParserCallback callback
      ) : callback_(std::move(callback)) {
  }

  MediaParserFactory_CreateMediaParser_ForwardToCallback(const MediaParserFactory_CreateMediaParser_ForwardToCallback&) = delete;
  MediaParserFactory_CreateMediaParser_ForwardToCallback& operator=(const MediaParserFactory_CreateMediaParser_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  MediaParserFactory::CreateMediaParserCallback callback_;
};

MediaParserFactoryProxy::MediaParserFactoryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void MediaParserFactoryProxy::CreateMediaParser(
    int64_t in_libyuv_cpu_flags, int64_t in_libavutil_cpu_flags, CreateMediaParserCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send chrome::mojom::MediaParserFactory::CreateMediaParser", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("libyuv_cpu_flags"), in_libyuv_cpu_flags,
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("libavutil_cpu_flags"), in_libavutil_cpu_flags,
                        "<value of type int64_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaParserFactory::kCreateMediaParser), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::MediaParserFactory_CreateMediaParser_Params_Data> params(
          message);
  params.Allocate();

  params->libyuv_cpu_flags = in_libyuv_cpu_flags;

  params->libavutil_cpu_flags = in_libavutil_cpu_flags;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaParserFactory::Name_);
  message.set_method_name("CreateMediaParser");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new MediaParserFactory_CreateMediaParser_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class MediaParserFactory_CreateMediaParser_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static MediaParserFactory::CreateMediaParserCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<MediaParserFactory_CreateMediaParser_ProxyToResponder> proxy(
        new MediaParserFactory_CreateMediaParser_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&MediaParserFactory_CreateMediaParser_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~MediaParserFactory_CreateMediaParser_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  MediaParserFactory_CreateMediaParser_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "MediaParserFactory::CreateMediaParserCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::mojo::PendingRemote<MediaParser> in_media_parser);
};

bool MediaParserFactory_CreateMediaParser_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::MediaParserFactory_CreateMediaParser_ResponseParams_Data* params =
      reinterpret_cast<
          internal::MediaParserFactory_CreateMediaParser_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for MediaParserFactory.0
  bool success = true;
  ::mojo::PendingRemote<MediaParser> p_media_parser{};
  MediaParserFactory_CreateMediaParser_ResponseParamsDataView input_data_view(params, message);
  
  if (success) {
    p_media_parser =
        input_data_view.TakeMediaParser<decltype(p_media_parser)>();
  }
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        MediaParserFactory::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_media_parser));
  }
  return true;
}

void MediaParserFactory_CreateMediaParser_ProxyToResponder::Run(
    ::mojo::PendingRemote<MediaParser> in_media_parser) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply chrome::mojom::MediaParserFactory::CreateMediaParser", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("media_parser"), in_media_parser,
                        "<value of type ::mojo::PendingRemote<MediaParser>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaParserFactory::kCreateMediaParser), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::MediaParserFactory_CreateMediaParser_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::chrome::mojom::MediaParserInterfaceBase>>(
    in_media_parser,
    &params->media_parser,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->media_parser)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid media_parser in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaParserFactory::Name_);
  message.set_method_name("CreateMediaParser");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool MediaParserFactoryStubDispatch::Accept(
    MediaParserFactory* impl,
    mojo::Message* message) {
  switch (static_cast<messages::MediaParserFactory>(message->header()->name)) {
    case messages::MediaParserFactory::kCreateMediaParser: {
      break;
    }
  }
  return false;
}

// static
bool MediaParserFactoryStubDispatch::AcceptWithResponder(
    MediaParserFactory* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::MediaParserFactory>(message->header()->name)) {
    case messages::MediaParserFactory::kCreateMediaParser: {
      internal::MediaParserFactory_CreateMediaParser_Params_Data* params =
          reinterpret_cast<
              internal::MediaParserFactory_CreateMediaParser_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for MediaParserFactory.0
      bool success = true;
      int64_t p_libyuv_cpu_flags{};
      int64_t p_libavutil_cpu_flags{};
      MediaParserFactory_CreateMediaParser_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_libyuv_cpu_flags = input_data_view.libyuv_cpu_flags();
      if (success)
        p_libavutil_cpu_flags = input_data_view.libavutil_cpu_flags();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaParserFactory::Name_, 0, false);
        return false;
      }
      auto callback =
          MediaParserFactory_CreateMediaParser_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateMediaParser(        
        std::move(p_libyuv_cpu_flags), 
        std::move(p_libavutil_cpu_flags), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kMediaParserFactoryValidationInfo[] = {
    { &internal::MediaParserFactory_CreateMediaParser_Params_Data::Validate,
     &internal::MediaParserFactory_CreateMediaParser_ResponseParams_Data::Validate},
};

bool MediaParserFactoryRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::chrome::mojom::MediaParserFactory::Name_,
    kMediaParserFactoryValidationInfo);
}

bool MediaParserFactoryResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::chrome::mojom::MediaParserFactory::Name_,
    kMediaParserFactoryValidationInfo);
}
// The declaration includes the definition on other builds.

MediaDataSource::IPCStableHashFunction MediaDataSource::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::MediaDataSource>(message.name())) {
    case messages::MediaDataSource::kRead: {
      return &MediaDataSource::Read_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* MediaDataSource::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::MediaDataSource>(message.name())) {
      case messages::MediaDataSource::kRead:
            return "Receive chrome::mojom::MediaDataSource::Read";
    }
  } else {
    switch (static_cast<messages::MediaDataSource>(message.name())) {
      case messages::MediaDataSource::kRead:
            return "Receive reply chrome::mojom::MediaDataSource::Read";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t MediaDataSource::Read_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x453ca410;  // IPCStableHash for chrome::mojom::MediaDataSource::Read
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class MediaDataSource_Read_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  MediaDataSource_Read_ForwardToCallback(
      MediaDataSource::ReadCallback callback
      ) : callback_(std::move(callback)) {
  }

  MediaDataSource_Read_ForwardToCallback(const MediaDataSource_Read_ForwardToCallback&) = delete;
  MediaDataSource_Read_ForwardToCallback& operator=(const MediaDataSource_Read_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  MediaDataSource::ReadCallback callback_;
};

MediaDataSourceProxy::MediaDataSourceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void MediaDataSourceProxy::Read(
    int64_t in_position, int64_t in_length, ReadCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send chrome::mojom::MediaDataSource::Read", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("position"), in_position,
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("length"), in_length,
                        "<value of type int64_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaDataSource::kRead), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::MediaDataSource_Read_Params_Data> params(
          message);
  params.Allocate();

  params->position = in_position;

  params->length = in_length;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaDataSource::Name_);
  message.set_method_name("Read");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new MediaDataSource_Read_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class MediaDataSource_Read_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static MediaDataSource::ReadCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<MediaDataSource_Read_ProxyToResponder> proxy(
        new MediaDataSource_Read_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&MediaDataSource_Read_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~MediaDataSource_Read_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  MediaDataSource_Read_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "MediaDataSource::ReadCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::vector<uint8_t>& in_data);
};

bool MediaDataSource_Read_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::MediaDataSource_Read_ResponseParams_Data* params =
      reinterpret_cast<
          internal::MediaDataSource_Read_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for MediaDataSource.0
  bool success = true;
  std::vector<uint8_t> p_data{};
  MediaDataSource_Read_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadData(&p_data))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        MediaDataSource::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_data));
  }
  return true;
}

void MediaDataSource_Read_ProxyToResponder::Run(
    const std::vector<uint8_t>& in_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply chrome::mojom::MediaDataSource::Read", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data,
                        "<value of type const std::vector<uint8_t>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaDataSource::kRead), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::MediaDataSource_Read_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->data)::BaseType>
      data_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
    in_data,
    data_fragment,
    &data_validate_params);

  params->data.Set(
      data_fragment.is_null() ? nullptr : data_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null data in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaDataSource::Name_);
  message.set_method_name("Read");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool MediaDataSourceStubDispatch::Accept(
    MediaDataSource* impl,
    mojo::Message* message) {
  switch (static_cast<messages::MediaDataSource>(message->header()->name)) {
    case messages::MediaDataSource::kRead: {
      break;
    }
  }
  return false;
}

// static
bool MediaDataSourceStubDispatch::AcceptWithResponder(
    MediaDataSource* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::MediaDataSource>(message->header()->name)) {
    case messages::MediaDataSource::kRead: {
      internal::MediaDataSource_Read_Params_Data* params =
          reinterpret_cast<
              internal::MediaDataSource_Read_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for MediaDataSource.0
      bool success = true;
      int64_t p_position{};
      int64_t p_length{};
      MediaDataSource_Read_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_position = input_data_view.position();
      if (success)
        p_length = input_data_view.length();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaDataSource::Name_, 0, false);
        return false;
      }
      auto callback =
          MediaDataSource_Read_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Read(        
        std::move(p_position), 
        std::move(p_length), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kMediaDataSourceValidationInfo[] = {
    { &internal::MediaDataSource_Read_Params_Data::Validate,
     &internal::MediaDataSource_Read_ResponseParams_Data::Validate},
};

bool MediaDataSourceRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::chrome::mojom::MediaDataSource::Name_,
    kMediaDataSourceValidationInfo);
}

bool MediaDataSourceResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::chrome::mojom::MediaDataSource::Name_,
    kMediaDataSourceValidationInfo);
}


}  // chrome::mojom


namespace mojo {


// static
bool StructTraits<::chrome::mojom::MediaStreamInfo::DataView, ::chrome::mojom::MediaStreamInfoPtr>::Read(
    ::chrome::mojom::MediaStreamInfo::DataView input,
    ::chrome::mojom::MediaStreamInfoPtr* output) {
  bool success = true;
  ::chrome::mojom::MediaStreamInfoPtr result(::chrome::mojom::MediaStreamInfo::New());
  
      if (success && !input.ReadType(&result->type))
        success = false;
      if (success && !input.ReadAdditionalProperties(&result->additional_properties))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::chrome::mojom::MediaMetadata::DataView, ::chrome::mojom::MediaMetadataPtr>::Read(
    ::chrome::mojom::MediaMetadata::DataView input,
    ::chrome::mojom::MediaMetadataPtr* output) {
  bool success = true;
  ::chrome::mojom::MediaMetadataPtr result(::chrome::mojom::MediaMetadata::New());
  
      if (success && !input.ReadMimeType(&result->mime_type))
        success = false;
      if (success)
        result->height = input.height();
      if (success)
        result->width = input.width();
      if (success)
        result->duration = input.duration();
      if (success)
        result->rotation = input.rotation();
      if (success && !input.ReadAlbum(&result->album))
        success = false;
      if (success && !input.ReadArtist(&result->artist))
        success = false;
      if (success && !input.ReadComment(&result->comment))
        success = false;
      if (success && !input.ReadCopyright(&result->copyright))
        success = false;
      if (success)
        result->disc = input.disc();
      if (success && !input.ReadGenre(&result->genre))
        success = false;
      if (success && !input.ReadLanguage(&result->language))
        success = false;
      if (success && !input.ReadTitle(&result->title))
        success = false;
      if (success)
        result->track = input.track();
      if (success && !input.ReadRawTags(&result->raw_tags))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::chrome::mojom::AttachedImage::DataView, ::chrome::mojom::AttachedImagePtr>::Read(
    ::chrome::mojom::AttachedImage::DataView input,
    ::chrome::mojom::AttachedImagePtr* output) {
  bool success = true;
  ::chrome::mojom::AttachedImagePtr result(::chrome::mojom::AttachedImage::New());
  
      if (success && !input.ReadType(&result->type))
        success = false;
      if (success && !input.ReadData(&result->data))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace chrome::mojom {


void MediaParserInterceptorForTesting::ParseMediaMetadata(const std::string& mime_type, int64_t total_size, bool get_attached_images, ::mojo::PendingRemote<MediaDataSource> media_data_source, ParseMediaMetadataCallback callback) {
  GetForwardingInterface()->ParseMediaMetadata(
    std::move(mime_type)
    , 
    std::move(total_size)
    , 
    std::move(get_attached_images)
    , 
    std::move(media_data_source)
    , std::move(callback));
}
void MediaParserInterceptorForTesting::CheckMediaFile(::base::TimeDelta decode_time, ::base::File file, CheckMediaFileCallback callback) {
  GetForwardingInterface()->CheckMediaFile(
    std::move(decode_time)
    , 
    std::move(file)
    , std::move(callback));
}
void MediaParserInterceptorForTesting::GetCpuInfo(GetCpuInfoCallback callback) {
  GetForwardingInterface()->GetCpuInfo(std::move(callback));
}
MediaParserAsyncWaiter::MediaParserAsyncWaiter(
    MediaParser* proxy) : proxy_(proxy) {}

MediaParserAsyncWaiter::~MediaParserAsyncWaiter() = default;


void MediaParserAsyncWaiter::ParseMediaMetadata(
    const std::string& mime_type, int64_t total_size, bool get_attached_images, ::mojo::PendingRemote<MediaDataSource> media_data_source, bool* out_parse_success, MediaMetadataPtr* out_metadata, std::vector<::metadata::AttachedImage>* out_attached_images) {
  base::RunLoop loop;
  proxy_->ParseMediaMetadata(
      std::move(mime_type),
      std::move(total_size),
      std::move(get_attached_images),
      std::move(media_data_source),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_parse_success
,
             MediaMetadataPtr* out_metadata
,
             std::vector<::metadata::AttachedImage>* out_attached_images
,
             bool parse_success,
             MediaMetadataPtr metadata,
             const std::vector<::metadata::AttachedImage>& attached_images) {*out_parse_success = std::move(parse_success);*out_metadata = std::move(metadata);*out_attached_images = std::move(attached_images);
            loop->Quit();
          },
          &loop,
          out_parse_success,
          out_metadata,
          out_attached_images));
  loop.Run();
}



void MediaParserAsyncWaiter::CheckMediaFile(
    ::base::TimeDelta decode_time, ::base::File file, bool* out_success) {
  base::RunLoop loop;
  proxy_->CheckMediaFile(
      std::move(decode_time),
      std::move(file),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}

bool MediaParserAsyncWaiter::CheckMediaFile(
    ::base::TimeDelta decode_time, ::base::File file) {
  bool async_wait_result;
  CheckMediaFile(std::move(decode_time),std::move(file),&async_wait_result);
  return async_wait_result;
}

void MediaParserAsyncWaiter::GetCpuInfo(
    int64_t* out_libyuv_cpu_flags, int64_t* out_ffmpeg_cpu_flags) {
  base::RunLoop loop;
  proxy_->GetCpuInfo(
      base::BindOnce(
          [](base::RunLoop* loop,
             int64_t* out_libyuv_cpu_flags
,
             int64_t* out_ffmpeg_cpu_flags
,
             int64_t libyuv_cpu_flags,
             int64_t ffmpeg_cpu_flags) {*out_libyuv_cpu_flags = std::move(libyuv_cpu_flags);*out_ffmpeg_cpu_flags = std::move(ffmpeg_cpu_flags);
            loop->Quit();
          },
          &loop,
          out_libyuv_cpu_flags,
          out_ffmpeg_cpu_flags));
  loop.Run();
}






void MediaParserFactoryInterceptorForTesting::CreateMediaParser(int64_t libyuv_cpu_flags, int64_t libavutil_cpu_flags, CreateMediaParserCallback callback) {
  GetForwardingInterface()->CreateMediaParser(
    std::move(libyuv_cpu_flags)
    , 
    std::move(libavutil_cpu_flags)
    , std::move(callback));
}
MediaParserFactoryAsyncWaiter::MediaParserFactoryAsyncWaiter(
    MediaParserFactory* proxy) : proxy_(proxy) {}

MediaParserFactoryAsyncWaiter::~MediaParserFactoryAsyncWaiter() = default;


void MediaParserFactoryAsyncWaiter::CreateMediaParser(
    int64_t libyuv_cpu_flags, int64_t libavutil_cpu_flags, ::mojo::PendingRemote<MediaParser>* out_media_parser) {
  base::RunLoop loop;
  proxy_->CreateMediaParser(
      std::move(libyuv_cpu_flags),
      std::move(libavutil_cpu_flags),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::mojo::PendingRemote<MediaParser>* out_media_parser
,
             ::mojo::PendingRemote<MediaParser> media_parser) {*out_media_parser = std::move(media_parser);
            loop->Quit();
          },
          &loop,
          out_media_parser));
  loop.Run();
}

::mojo::PendingRemote<MediaParser> MediaParserFactoryAsyncWaiter::CreateMediaParser(
    int64_t libyuv_cpu_flags, int64_t libavutil_cpu_flags) {
  ::mojo::PendingRemote<MediaParser> async_wait_result;
  CreateMediaParser(std::move(libyuv_cpu_flags),std::move(libavutil_cpu_flags),&async_wait_result);
  return async_wait_result;
}




void MediaDataSourceInterceptorForTesting::Read(int64_t position, int64_t length, ReadCallback callback) {
  GetForwardingInterface()->Read(
    std::move(position)
    , 
    std::move(length)
    , std::move(callback));
}
MediaDataSourceAsyncWaiter::MediaDataSourceAsyncWaiter(
    MediaDataSource* proxy) : proxy_(proxy) {}

MediaDataSourceAsyncWaiter::~MediaDataSourceAsyncWaiter() = default;


void MediaDataSourceAsyncWaiter::Read(
    int64_t position, int64_t length, std::vector<uint8_t>* out_data) {
  base::RunLoop loop;
  proxy_->Read(
      std::move(position),
      std::move(length),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<uint8_t>* out_data
,
             const std::vector<uint8_t>& data) {*out_data = std::move(data);
            loop->Quit();
          },
          &loop,
          out_data));
  loop.Run();
}

std::vector<uint8_t> MediaDataSourceAsyncWaiter::Read(
    int64_t position, int64_t length) {
  std::vector<uint8_t> async_wait_result;
  Read(std::move(position),std::move(length),&async_wait_result);
  return async_wait_result;
}






}  // chrome::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif