// chrome/services/file_util/public/mojom/file_util_service.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "chrome/services/file_util/public/mojom/file_util_service.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/services/file_util/public/mojom/file_util_service.mojom-params-data.h"
#include "chrome/services/file_util/public/mojom/file_util_service.mojom-shared-message-ids.h"

#include "chrome/services/file_util/public/mojom/file_util_service.mojom-import-headers.h"
#include "chrome/services/file_util/public/mojom/file_util_service.mojom-test-utils.h"


namespace chrome::mojom {
// The declaration includes the definition on other builds.

FileUtilService::IPCStableHashFunction FileUtilService::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::FileUtilService>(message.name())) {
    case messages::FileUtilService::kBindSafeArchiveAnalyzer: {
      return &FileUtilService::BindSafeArchiveAnalyzer_Sym::IPCStableHash;
    }
    case messages::FileUtilService::kBindSingleFileTarFileExtractor: {
      return &FileUtilService::BindSingleFileTarFileExtractor_Sym::IPCStableHash;
    }
    case messages::FileUtilService::kBindSingleFileTarXzFileExtractor: {
      return &FileUtilService::BindSingleFileTarXzFileExtractor_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* FileUtilService::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::FileUtilService>(message.name())) {
      case messages::FileUtilService::kBindSafeArchiveAnalyzer:
            return "Receive chrome::mojom::FileUtilService::BindSafeArchiveAnalyzer";
      case messages::FileUtilService::kBindSingleFileTarFileExtractor:
            return "Receive chrome::mojom::FileUtilService::BindSingleFileTarFileExtractor";
      case messages::FileUtilService::kBindSingleFileTarXzFileExtractor:
            return "Receive chrome::mojom::FileUtilService::BindSingleFileTarXzFileExtractor";
    }
  } else {
    switch (static_cast<messages::FileUtilService>(message.name())) {
      case messages::FileUtilService::kBindSafeArchiveAnalyzer:
            return "Receive reply chrome::mojom::FileUtilService::BindSafeArchiveAnalyzer";
      case messages::FileUtilService::kBindSingleFileTarFileExtractor:
            return "Receive reply chrome::mojom::FileUtilService::BindSingleFileTarFileExtractor";
      case messages::FileUtilService::kBindSingleFileTarXzFileExtractor:
            return "Receive reply chrome::mojom::FileUtilService::BindSingleFileTarXzFileExtractor";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t FileUtilService::BindSafeArchiveAnalyzer_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x64418e87;  // IPCStableHash for chrome::mojom::FileUtilService::BindSafeArchiveAnalyzer
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FileUtilService::BindSingleFileTarFileExtractor_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb00f6b20;  // IPCStableHash for chrome::mojom::FileUtilService::BindSingleFileTarFileExtractor
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FileUtilService::BindSingleFileTarXzFileExtractor_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xab02cbe1;  // IPCStableHash for chrome::mojom::FileUtilService::BindSingleFileTarXzFileExtractor
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

FileUtilServiceProxy::FileUtilServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void FileUtilServiceProxy::BindSafeArchiveAnalyzer(
    ::mojo::PendingReceiver<::chrome::mojom::SafeArchiveAnalyzer> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send chrome::mojom::FileUtilService::BindSafeArchiveAnalyzer", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::chrome::mojom::SafeArchiveAnalyzer>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileUtilService::kBindSafeArchiveAnalyzer), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::FileUtilService_BindSafeArchiveAnalyzer_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::chrome::mojom::SafeArchiveAnalyzerInterfaceBase>>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid receiver in FileUtilService.BindSafeArchiveAnalyzer request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileUtilService::Name_);
  message.set_method_name("BindSafeArchiveAnalyzer");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FileUtilServiceProxy::BindSingleFileTarFileExtractor(
    ::mojo::PendingReceiver<::chrome::mojom::SingleFileExtractor> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send chrome::mojom::FileUtilService::BindSingleFileTarFileExtractor", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::chrome::mojom::SingleFileExtractor>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileUtilService::kBindSingleFileTarFileExtractor), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::FileUtilService_BindSingleFileTarFileExtractor_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::chrome::mojom::SingleFileExtractorInterfaceBase>>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid receiver in FileUtilService.BindSingleFileTarFileExtractor request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileUtilService::Name_);
  message.set_method_name("BindSingleFileTarFileExtractor");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FileUtilServiceProxy::BindSingleFileTarXzFileExtractor(
    ::mojo::PendingReceiver<::chrome::mojom::SingleFileExtractor> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send chrome::mojom::FileUtilService::BindSingleFileTarXzFileExtractor", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::chrome::mojom::SingleFileExtractor>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileUtilService::kBindSingleFileTarXzFileExtractor), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::FileUtilService_BindSingleFileTarXzFileExtractor_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::chrome::mojom::SingleFileExtractorInterfaceBase>>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid receiver in FileUtilService.BindSingleFileTarXzFileExtractor request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileUtilService::Name_);
  message.set_method_name("BindSingleFileTarXzFileExtractor");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool FileUtilServiceStubDispatch::Accept(
    FileUtilService* impl,
    mojo::Message* message) {
  switch (static_cast<messages::FileUtilService>(message->header()->name)) {
    case messages::FileUtilService::kBindSafeArchiveAnalyzer: {
      DCHECK(message->is_serialized());
      internal::FileUtilService_BindSafeArchiveAnalyzer_Params_Data* params =
          reinterpret_cast<internal::FileUtilService_BindSafeArchiveAnalyzer_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FileUtilService.0
      bool success = true;
      ::mojo::PendingReceiver<::chrome::mojom::SafeArchiveAnalyzer> p_receiver{};
      FileUtilService_BindSafeArchiveAnalyzer_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FileUtilService::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindSafeArchiveAnalyzer(        
        std::move(p_receiver));
      return true;
    }
    case messages::FileUtilService::kBindSingleFileTarFileExtractor: {
      DCHECK(message->is_serialized());
      internal::FileUtilService_BindSingleFileTarFileExtractor_Params_Data* params =
          reinterpret_cast<internal::FileUtilService_BindSingleFileTarFileExtractor_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FileUtilService.1
      bool success = true;
      ::mojo::PendingReceiver<::chrome::mojom::SingleFileExtractor> p_receiver{};
      FileUtilService_BindSingleFileTarFileExtractor_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FileUtilService::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindSingleFileTarFileExtractor(        
        std::move(p_receiver));
      return true;
    }
    case messages::FileUtilService::kBindSingleFileTarXzFileExtractor: {
      DCHECK(message->is_serialized());
      internal::FileUtilService_BindSingleFileTarXzFileExtractor_Params_Data* params =
          reinterpret_cast<internal::FileUtilService_BindSingleFileTarXzFileExtractor_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FileUtilService.2
      bool success = true;
      ::mojo::PendingReceiver<::chrome::mojom::SingleFileExtractor> p_receiver{};
      FileUtilService_BindSingleFileTarXzFileExtractor_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FileUtilService::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindSingleFileTarXzFileExtractor(        
        std::move(p_receiver));
      return true;
    }
  }
  return false;
}

// static
bool FileUtilServiceStubDispatch::AcceptWithResponder(
    FileUtilService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::FileUtilService>(message->header()->name)) {
    case messages::FileUtilService::kBindSafeArchiveAnalyzer: {
      break;
    }
    case messages::FileUtilService::kBindSingleFileTarFileExtractor: {
      break;
    }
    case messages::FileUtilService::kBindSingleFileTarXzFileExtractor: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kFileUtilServiceValidationInfo[] = {
    { &internal::FileUtilService_BindSafeArchiveAnalyzer_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::FileUtilService_BindSingleFileTarFileExtractor_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::FileUtilService_BindSingleFileTarXzFileExtractor_Params_Data::Validate,
     nullptr /* no response */},
};

bool FileUtilServiceRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::chrome::mojom::FileUtilService::Name_,
    kFileUtilServiceValidationInfo);
}



}  // chrome::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace chrome::mojom {


void FileUtilServiceInterceptorForTesting::BindSafeArchiveAnalyzer(::mojo::PendingReceiver<::chrome::mojom::SafeArchiveAnalyzer> receiver) {
  GetForwardingInterface()->BindSafeArchiveAnalyzer(
    std::move(receiver)
    );
}
void FileUtilServiceInterceptorForTesting::BindSingleFileTarFileExtractor(::mojo::PendingReceiver<::chrome::mojom::SingleFileExtractor> receiver) {
  GetForwardingInterface()->BindSingleFileTarFileExtractor(
    std::move(receiver)
    );
}
void FileUtilServiceInterceptorForTesting::BindSingleFileTarXzFileExtractor(::mojo::PendingReceiver<::chrome::mojom::SingleFileExtractor> receiver) {
  GetForwardingInterface()->BindSingleFileTarXzFileExtractor(
    std::move(receiver)
    );
}
FileUtilServiceAsyncWaiter::FileUtilServiceAsyncWaiter(
    FileUtilService* proxy) : proxy_(proxy) {}

FileUtilServiceAsyncWaiter::~FileUtilServiceAsyncWaiter() = default;







}  // chrome::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif