// chrome/common/trusted_vault_encryption_keys_extension.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_COMMON_TRUSTED_VAULT_ENCRYPTION_KEYS_EXTENSION_MOJOM_H_
#define CHROME_COMMON_TRUSTED_VAULT_ENCRYPTION_KEYS_EXTENSION_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/common/trusted_vault_encryption_keys_extension.mojom-features.h"  // IWYU pragma: export
#include "chrome/common/trusted_vault_encryption_keys_extension.mojom-shared.h"  // IWYU pragma: export
#include "chrome/common/trusted_vault_encryption_keys_extension.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace chrome::mojom {

class TrustedVaultEncryptionKeysExtensionProxy;

template <typename ImplRefTraits>
class TrustedVaultEncryptionKeysExtensionStub;

class TrustedVaultEncryptionKeysExtensionRequestValidator;
class TrustedVaultEncryptionKeysExtensionResponseValidator;


class TrustedVaultEncryptionKeysExtension
    : public TrustedVaultEncryptionKeysExtensionInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "chrome.mojom.TrustedVaultEncryptionKeysExtension";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = TrustedVaultEncryptionKeysExtensionInterfaceBase;
  using Proxy_ = TrustedVaultEncryptionKeysExtensionProxy;

  template <typename ImplRefTraits>
  using Stub_ = TrustedVaultEncryptionKeysExtensionStub<ImplRefTraits>;

  using RequestValidator_ = TrustedVaultEncryptionKeysExtensionRequestValidator;
  using ResponseValidator_ = TrustedVaultEncryptionKeysExtensionResponseValidator;
  enum MethodMinVersions : uint32_t {
    kSetEncryptionKeysMinVersion = 0,
    kAddTrustedRecoveryMethodMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SetEncryptionKeys_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AddTrustedRecoveryMethod_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~TrustedVaultEncryptionKeysExtension() = default;

  using SetEncryptionKeysCallback = base::OnceCallback<void()>;
  using SetEncryptionKeysMojoCallback = base::OnceCallback<void()>;

  virtual void SetEncryptionKeys(const std::string& gaia_id, base::flat_map<std::string, std::vector<TrustedVaultKeyPtr>> encryption_keys, SetEncryptionKeysCallback callback) = 0;

  using AddTrustedRecoveryMethodCallback = base::OnceCallback<void()>;
  using AddTrustedRecoveryMethodMojoCallback = base::OnceCallback<void()>;

  virtual void AddTrustedRecoveryMethod(const std::string& gaia_id, const std::vector<uint8_t>& public_key, int32_t method_type_hint, AddTrustedRecoveryMethodCallback callback) = 0;
};



class  TrustedVaultEncryptionKeysExtensionProxy
    : public TrustedVaultEncryptionKeysExtension {
 public:
  using InterfaceType = TrustedVaultEncryptionKeysExtension;

  explicit TrustedVaultEncryptionKeysExtensionProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetEncryptionKeys(const std::string& gaia_id, base::flat_map<std::string, std::vector<TrustedVaultKeyPtr>> encryption_keys, SetEncryptionKeysCallback callback) final;
  
  void AddTrustedRecoveryMethod(const std::string& gaia_id, const std::vector<uint8_t>& public_key, int32_t method_type_hint, AddTrustedRecoveryMethodCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  TrustedVaultEncryptionKeysExtensionStubDispatch {
 public:
  static bool Accept(TrustedVaultEncryptionKeysExtension* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      TrustedVaultEncryptionKeysExtension* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<TrustedVaultEncryptionKeysExtension>>
class TrustedVaultEncryptionKeysExtensionStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  TrustedVaultEncryptionKeysExtensionStub() = default;
  ~TrustedVaultEncryptionKeysExtensionStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return TrustedVaultEncryptionKeysExtensionStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return TrustedVaultEncryptionKeysExtensionStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  TrustedVaultEncryptionKeysExtensionRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  TrustedVaultEncryptionKeysExtensionResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class  TrustedVaultKey {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<TrustedVaultKey, T>::value>;
  using DataView = TrustedVaultKeyDataView;
  using Data_ = internal::TrustedVaultKey_Data;

  template <typename... Args>
  static TrustedVaultKeyPtr New(Args&&... args) {
    return TrustedVaultKeyPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TrustedVaultKeyPtr From(const U& u) {
    return mojo::TypeConverter<TrustedVaultKeyPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TrustedVaultKey>::Convert(*this);
  }


  TrustedVaultKey();

  TrustedVaultKey(
      int32_t version,
      std::vector<uint8_t> bytes);


  ~TrustedVaultKey();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TrustedVaultKeyPtr>
  TrustedVaultKeyPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, TrustedVaultKey::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, TrustedVaultKey::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, TrustedVaultKey::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TrustedVaultKey::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TrustedVaultKey::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TrustedVaultKey::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::TrustedVaultKey_UnserializedMessageContext<
            UserType, TrustedVaultKey::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<TrustedVaultKey::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return TrustedVaultKey::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::TrustedVaultKey_UnserializedMessageContext<
            UserType, TrustedVaultKey::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<TrustedVaultKey::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int32_t version;
  
  std::vector<uint8_t> bytes;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, TrustedVaultKey::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, TrustedVaultKey::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, TrustedVaultKey::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, TrustedVaultKey::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
TrustedVaultKeyPtr TrustedVaultKey::Clone() const {
  return New(
      mojo::Clone(version),
      mojo::Clone(bytes)
  );
}

template <typename T, TrustedVaultKey::EnableIfSame<T>*>
bool TrustedVaultKey::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->version, other_struct.version))
    return false;
  if (!mojo::Equals(this->bytes, other_struct.bytes))
    return false;
  return true;
}

template <typename T, TrustedVaultKey::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.version < rhs.version)
    return true;
  if (rhs.version < lhs.version)
    return false;
  if (lhs.bytes < rhs.bytes)
    return true;
  if (rhs.bytes < lhs.bytes)
    return false;
  return false;
}


}  // chrome::mojom

namespace mojo {


template <>
struct  StructTraits<::chrome::mojom::TrustedVaultKey::DataView,
                                         ::chrome::mojom::TrustedVaultKeyPtr> {
  static bool IsNull(const ::chrome::mojom::TrustedVaultKeyPtr& input) { return !input; }
  static void SetToNull(::chrome::mojom::TrustedVaultKeyPtr* output) { output->reset(); }

  static decltype(::chrome::mojom::TrustedVaultKey::version) version(
      const ::chrome::mojom::TrustedVaultKeyPtr& input) {
    return input->version;
  }

  static const decltype(::chrome::mojom::TrustedVaultKey::bytes)& bytes(
      const ::chrome::mojom::TrustedVaultKeyPtr& input) {
    return input->bytes;
  }

  static bool Read(::chrome::mojom::TrustedVaultKey::DataView input, ::chrome::mojom::TrustedVaultKeyPtr* output);
};

}  // namespace mojo

#endif  // CHROME_COMMON_TRUSTED_VAULT_ENCRYPTION_KEYS_EXTENSION_MOJOM_H_