// chrome/common/trusted_vault_encryption_keys_extension.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "chrome/common/trusted_vault_encryption_keys_extension.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/common/trusted_vault_encryption_keys_extension.mojom-params-data.h"
#include "chrome/common/trusted_vault_encryption_keys_extension.mojom-shared-message-ids.h"

#include "chrome/common/trusted_vault_encryption_keys_extension.mojom-import-headers.h"
#include "chrome/common/trusted_vault_encryption_keys_extension.mojom-test-utils.h"


namespace chrome::mojom {
TrustedVaultKey::TrustedVaultKey()
    : version(),
      bytes() {}

TrustedVaultKey::TrustedVaultKey(
    int32_t version_in,
    std::vector<uint8_t> bytes_in)
    : version(std::move(version_in)),
      bytes(std::move(bytes_in)) {}

TrustedVaultKey::~TrustedVaultKey() = default;

void TrustedVaultKey::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "version"), this->version,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "bytes"), this->bytes,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<uint8_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool TrustedVaultKey::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

TrustedVaultEncryptionKeysExtension::IPCStableHashFunction TrustedVaultEncryptionKeysExtension::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::TrustedVaultEncryptionKeysExtension>(message.name())) {
    case messages::TrustedVaultEncryptionKeysExtension::kSetEncryptionKeys: {
      return &TrustedVaultEncryptionKeysExtension::SetEncryptionKeys_Sym::IPCStableHash;
    }
    case messages::TrustedVaultEncryptionKeysExtension::kAddTrustedRecoveryMethod: {
      return &TrustedVaultEncryptionKeysExtension::AddTrustedRecoveryMethod_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* TrustedVaultEncryptionKeysExtension::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::TrustedVaultEncryptionKeysExtension>(message.name())) {
      case messages::TrustedVaultEncryptionKeysExtension::kSetEncryptionKeys:
            return "Receive chrome::mojom::TrustedVaultEncryptionKeysExtension::SetEncryptionKeys";
      case messages::TrustedVaultEncryptionKeysExtension::kAddTrustedRecoveryMethod:
            return "Receive chrome::mojom::TrustedVaultEncryptionKeysExtension::AddTrustedRecoveryMethod";
    }
  } else {
    switch (static_cast<messages::TrustedVaultEncryptionKeysExtension>(message.name())) {
      case messages::TrustedVaultEncryptionKeysExtension::kSetEncryptionKeys:
            return "Receive reply chrome::mojom::TrustedVaultEncryptionKeysExtension::SetEncryptionKeys";
      case messages::TrustedVaultEncryptionKeysExtension::kAddTrustedRecoveryMethod:
            return "Receive reply chrome::mojom::TrustedVaultEncryptionKeysExtension::AddTrustedRecoveryMethod";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t TrustedVaultEncryptionKeysExtension::SetEncryptionKeys_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc7be8418;  // IPCStableHash for chrome::mojom::TrustedVaultEncryptionKeysExtension::SetEncryptionKeys
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t TrustedVaultEncryptionKeysExtension::AddTrustedRecoveryMethod_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x22b49616;  // IPCStableHash for chrome::mojom::TrustedVaultEncryptionKeysExtension::AddTrustedRecoveryMethod
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class TrustedVaultEncryptionKeysExtension_SetEncryptionKeys_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  TrustedVaultEncryptionKeysExtension_SetEncryptionKeys_ForwardToCallback(
      TrustedVaultEncryptionKeysExtension::SetEncryptionKeysCallback callback
      ) : callback_(std::move(callback)) {
  }

  TrustedVaultEncryptionKeysExtension_SetEncryptionKeys_ForwardToCallback(const TrustedVaultEncryptionKeysExtension_SetEncryptionKeys_ForwardToCallback&) = delete;
  TrustedVaultEncryptionKeysExtension_SetEncryptionKeys_ForwardToCallback& operator=(const TrustedVaultEncryptionKeysExtension_SetEncryptionKeys_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  TrustedVaultEncryptionKeysExtension::SetEncryptionKeysCallback callback_;
};

class TrustedVaultEncryptionKeysExtension_AddTrustedRecoveryMethod_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  TrustedVaultEncryptionKeysExtension_AddTrustedRecoveryMethod_ForwardToCallback(
      TrustedVaultEncryptionKeysExtension::AddTrustedRecoveryMethodCallback callback
      ) : callback_(std::move(callback)) {
  }

  TrustedVaultEncryptionKeysExtension_AddTrustedRecoveryMethod_ForwardToCallback(const TrustedVaultEncryptionKeysExtension_AddTrustedRecoveryMethod_ForwardToCallback&) = delete;
  TrustedVaultEncryptionKeysExtension_AddTrustedRecoveryMethod_ForwardToCallback& operator=(const TrustedVaultEncryptionKeysExtension_AddTrustedRecoveryMethod_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  TrustedVaultEncryptionKeysExtension::AddTrustedRecoveryMethodCallback callback_;
};

TrustedVaultEncryptionKeysExtensionProxy::TrustedVaultEncryptionKeysExtensionProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void TrustedVaultEncryptionKeysExtensionProxy::SetEncryptionKeys(
    const std::string& in_gaia_id, base::flat_map<std::string, std::vector<TrustedVaultKeyPtr>> in_encryption_keys, SetEncryptionKeysCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send chrome::mojom::TrustedVaultEncryptionKeysExtension::SetEncryptionKeys", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("gaia_id"), in_gaia_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("encryption_keys"), in_encryption_keys,
                        "<value of type base::flat_map<std::string, std::vector<TrustedVaultKeyPtr>>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TrustedVaultEncryptionKeysExtension::kSetEncryptionKeys), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::TrustedVaultEncryptionKeysExtension_SetEncryptionKeys_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->gaia_id)::BaseType> gaia_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_gaia_id,
    gaia_id_fragment);

  params->gaia_id.Set(
      gaia_id_fragment.is_null() ? nullptr : gaia_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->gaia_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null gaia_id in TrustedVaultEncryptionKeysExtension.SetEncryptionKeys request");
  mojo::internal::MessageFragment<
      typename decltype(params->encryption_keys)::BaseType>
      encryption_keys_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& encryption_keys_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
  
  mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, mojo::ArrayDataView<::chrome::mojom::TrustedVaultKeyDataView>>>(
    in_encryption_keys,
    encryption_keys_fragment,
    &encryption_keys_validate_params);

  params->encryption_keys.Set(
      encryption_keys_fragment.is_null() ? nullptr : encryption_keys_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->encryption_keys.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null encryption_keys in TrustedVaultEncryptionKeysExtension.SetEncryptionKeys request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TrustedVaultEncryptionKeysExtension::Name_);
  message.set_method_name("SetEncryptionKeys");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new TrustedVaultEncryptionKeysExtension_SetEncryptionKeys_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void TrustedVaultEncryptionKeysExtensionProxy::AddTrustedRecoveryMethod(
    const std::string& in_gaia_id, const std::vector<uint8_t>& in_public_key, int32_t in_method_type_hint, AddTrustedRecoveryMethodCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send chrome::mojom::TrustedVaultEncryptionKeysExtension::AddTrustedRecoveryMethod", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("gaia_id"), in_gaia_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("public_key"), in_public_key,
                        "<value of type const std::vector<uint8_t>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("method_type_hint"), in_method_type_hint,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TrustedVaultEncryptionKeysExtension::kAddTrustedRecoveryMethod), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::TrustedVaultEncryptionKeysExtension_AddTrustedRecoveryMethod_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->gaia_id)::BaseType> gaia_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_gaia_id,
    gaia_id_fragment);

  params->gaia_id.Set(
      gaia_id_fragment.is_null() ? nullptr : gaia_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->gaia_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null gaia_id in TrustedVaultEncryptionKeysExtension.AddTrustedRecoveryMethod request");
  mojo::internal::MessageFragment<
      typename decltype(params->public_key)::BaseType>
      public_key_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& public_key_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
    in_public_key,
    public_key_fragment,
    &public_key_validate_params);

  params->public_key.Set(
      public_key_fragment.is_null() ? nullptr : public_key_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->public_key.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null public_key in TrustedVaultEncryptionKeysExtension.AddTrustedRecoveryMethod request");

  params->method_type_hint = in_method_type_hint;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TrustedVaultEncryptionKeysExtension::Name_);
  message.set_method_name("AddTrustedRecoveryMethod");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new TrustedVaultEncryptionKeysExtension_AddTrustedRecoveryMethod_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class TrustedVaultEncryptionKeysExtension_SetEncryptionKeys_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static TrustedVaultEncryptionKeysExtension::SetEncryptionKeysCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<TrustedVaultEncryptionKeysExtension_SetEncryptionKeys_ProxyToResponder> proxy(
        new TrustedVaultEncryptionKeysExtension_SetEncryptionKeys_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&TrustedVaultEncryptionKeysExtension_SetEncryptionKeys_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~TrustedVaultEncryptionKeysExtension_SetEncryptionKeys_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  TrustedVaultEncryptionKeysExtension_SetEncryptionKeys_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "TrustedVaultEncryptionKeysExtension::SetEncryptionKeysCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool TrustedVaultEncryptionKeysExtension_SetEncryptionKeys_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::TrustedVaultEncryptionKeysExtension_SetEncryptionKeys_ResponseParams_Data* params =
      reinterpret_cast<
          internal::TrustedVaultEncryptionKeysExtension_SetEncryptionKeys_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for TrustedVaultEncryptionKeysExtension.0
  bool success = true;
  TrustedVaultEncryptionKeysExtension_SetEncryptionKeys_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        TrustedVaultEncryptionKeysExtension::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void TrustedVaultEncryptionKeysExtension_SetEncryptionKeys_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply chrome::mojom::TrustedVaultEncryptionKeysExtension::SetEncryptionKeys");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TrustedVaultEncryptionKeysExtension::kSetEncryptionKeys), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::TrustedVaultEncryptionKeysExtension_SetEncryptionKeys_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TrustedVaultEncryptionKeysExtension::Name_);
  message.set_method_name("SetEncryptionKeys");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class TrustedVaultEncryptionKeysExtension_AddTrustedRecoveryMethod_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static TrustedVaultEncryptionKeysExtension::AddTrustedRecoveryMethodCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<TrustedVaultEncryptionKeysExtension_AddTrustedRecoveryMethod_ProxyToResponder> proxy(
        new TrustedVaultEncryptionKeysExtension_AddTrustedRecoveryMethod_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&TrustedVaultEncryptionKeysExtension_AddTrustedRecoveryMethod_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~TrustedVaultEncryptionKeysExtension_AddTrustedRecoveryMethod_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  TrustedVaultEncryptionKeysExtension_AddTrustedRecoveryMethod_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "TrustedVaultEncryptionKeysExtension::AddTrustedRecoveryMethodCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool TrustedVaultEncryptionKeysExtension_AddTrustedRecoveryMethod_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::TrustedVaultEncryptionKeysExtension_AddTrustedRecoveryMethod_ResponseParams_Data* params =
      reinterpret_cast<
          internal::TrustedVaultEncryptionKeysExtension_AddTrustedRecoveryMethod_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for TrustedVaultEncryptionKeysExtension.1
  bool success = true;
  TrustedVaultEncryptionKeysExtension_AddTrustedRecoveryMethod_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        TrustedVaultEncryptionKeysExtension::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void TrustedVaultEncryptionKeysExtension_AddTrustedRecoveryMethod_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply chrome::mojom::TrustedVaultEncryptionKeysExtension::AddTrustedRecoveryMethod");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TrustedVaultEncryptionKeysExtension::kAddTrustedRecoveryMethod), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::TrustedVaultEncryptionKeysExtension_AddTrustedRecoveryMethod_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TrustedVaultEncryptionKeysExtension::Name_);
  message.set_method_name("AddTrustedRecoveryMethod");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool TrustedVaultEncryptionKeysExtensionStubDispatch::Accept(
    TrustedVaultEncryptionKeysExtension* impl,
    mojo::Message* message) {
  switch (static_cast<messages::TrustedVaultEncryptionKeysExtension>(message->header()->name)) {
    case messages::TrustedVaultEncryptionKeysExtension::kSetEncryptionKeys: {
      break;
    }
    case messages::TrustedVaultEncryptionKeysExtension::kAddTrustedRecoveryMethod: {
      break;
    }
  }
  return false;
}

// static
bool TrustedVaultEncryptionKeysExtensionStubDispatch::AcceptWithResponder(
    TrustedVaultEncryptionKeysExtension* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::TrustedVaultEncryptionKeysExtension>(message->header()->name)) {
    case messages::TrustedVaultEncryptionKeysExtension::kSetEncryptionKeys: {
      internal::TrustedVaultEncryptionKeysExtension_SetEncryptionKeys_Params_Data* params =
          reinterpret_cast<
              internal::TrustedVaultEncryptionKeysExtension_SetEncryptionKeys_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for TrustedVaultEncryptionKeysExtension.0
      bool success = true;
      std::string p_gaia_id{};
      base::flat_map<std::string, std::vector<TrustedVaultKeyPtr>> p_encryption_keys{};
      TrustedVaultEncryptionKeysExtension_SetEncryptionKeys_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadGaiaId(&p_gaia_id))
        success = false;
      if (success && !input_data_view.ReadEncryptionKeys(&p_encryption_keys))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TrustedVaultEncryptionKeysExtension::Name_, 0, false);
        return false;
      }
      auto callback =
          TrustedVaultEncryptionKeysExtension_SetEncryptionKeys_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetEncryptionKeys(        
        std::move(p_gaia_id), 
        std::move(p_encryption_keys), std::move(callback));
      return true;
    }
    case messages::TrustedVaultEncryptionKeysExtension::kAddTrustedRecoveryMethod: {
      internal::TrustedVaultEncryptionKeysExtension_AddTrustedRecoveryMethod_Params_Data* params =
          reinterpret_cast<
              internal::TrustedVaultEncryptionKeysExtension_AddTrustedRecoveryMethod_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for TrustedVaultEncryptionKeysExtension.1
      bool success = true;
      std::string p_gaia_id{};
      std::vector<uint8_t> p_public_key{};
      int32_t p_method_type_hint{};
      TrustedVaultEncryptionKeysExtension_AddTrustedRecoveryMethod_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadGaiaId(&p_gaia_id))
        success = false;
      if (success && !input_data_view.ReadPublicKey(&p_public_key))
        success = false;
      if (success)
        p_method_type_hint = input_data_view.method_type_hint();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TrustedVaultEncryptionKeysExtension::Name_, 1, false);
        return false;
      }
      auto callback =
          TrustedVaultEncryptionKeysExtension_AddTrustedRecoveryMethod_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddTrustedRecoveryMethod(        
        std::move(p_gaia_id), 
        std::move(p_public_key), 
        std::move(p_method_type_hint), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kTrustedVaultEncryptionKeysExtensionValidationInfo[] = {
    { &internal::TrustedVaultEncryptionKeysExtension_SetEncryptionKeys_Params_Data::Validate,
     &internal::TrustedVaultEncryptionKeysExtension_SetEncryptionKeys_ResponseParams_Data::Validate},
    { &internal::TrustedVaultEncryptionKeysExtension_AddTrustedRecoveryMethod_Params_Data::Validate,
     &internal::TrustedVaultEncryptionKeysExtension_AddTrustedRecoveryMethod_ResponseParams_Data::Validate},
};

bool TrustedVaultEncryptionKeysExtensionRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::chrome::mojom::TrustedVaultEncryptionKeysExtension::Name_,
    kTrustedVaultEncryptionKeysExtensionValidationInfo);
}

bool TrustedVaultEncryptionKeysExtensionResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::chrome::mojom::TrustedVaultEncryptionKeysExtension::Name_,
    kTrustedVaultEncryptionKeysExtensionValidationInfo);
}


}  // chrome::mojom


namespace mojo {


// static
bool StructTraits<::chrome::mojom::TrustedVaultKey::DataView, ::chrome::mojom::TrustedVaultKeyPtr>::Read(
    ::chrome::mojom::TrustedVaultKey::DataView input,
    ::chrome::mojom::TrustedVaultKeyPtr* output) {
  bool success = true;
  ::chrome::mojom::TrustedVaultKeyPtr result(::chrome::mojom::TrustedVaultKey::New());
  
      if (success)
        result->version = input.version();
      if (success && !input.ReadBytes(&result->bytes))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace chrome::mojom {


void TrustedVaultEncryptionKeysExtensionInterceptorForTesting::SetEncryptionKeys(const std::string& gaia_id, base::flat_map<std::string, std::vector<TrustedVaultKeyPtr>> encryption_keys, SetEncryptionKeysCallback callback) {
  GetForwardingInterface()->SetEncryptionKeys(
    std::move(gaia_id)
    , 
    std::move(encryption_keys)
    , std::move(callback));
}
void TrustedVaultEncryptionKeysExtensionInterceptorForTesting::AddTrustedRecoveryMethod(const std::string& gaia_id, const std::vector<uint8_t>& public_key, int32_t method_type_hint, AddTrustedRecoveryMethodCallback callback) {
  GetForwardingInterface()->AddTrustedRecoveryMethod(
    std::move(gaia_id)
    , 
    std::move(public_key)
    , 
    std::move(method_type_hint)
    , std::move(callback));
}
TrustedVaultEncryptionKeysExtensionAsyncWaiter::TrustedVaultEncryptionKeysExtensionAsyncWaiter(
    TrustedVaultEncryptionKeysExtension* proxy) : proxy_(proxy) {}

TrustedVaultEncryptionKeysExtensionAsyncWaiter::~TrustedVaultEncryptionKeysExtensionAsyncWaiter() = default;


void TrustedVaultEncryptionKeysExtensionAsyncWaiter::SetEncryptionKeys(
    const std::string& gaia_id, base::flat_map<std::string, std::vector<TrustedVaultKeyPtr>> encryption_keys) {
  base::RunLoop loop;
  proxy_->SetEncryptionKeys(
      std::move(gaia_id),
      std::move(encryption_keys),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void TrustedVaultEncryptionKeysExtensionAsyncWaiter::AddTrustedRecoveryMethod(
    const std::string& gaia_id, const std::vector<uint8_t>& public_key, int32_t method_type_hint) {
  base::RunLoop loop;
  proxy_->AddTrustedRecoveryMethod(
      std::move(gaia_id),
      std::move(public_key),
      std::move(method_type_hint),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}








}  // chrome::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif