// chrome/common/read_anything/read_anything.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_COMMON_READ_ANYTHING_READ_ANYTHING_MOJOM_H_
#define CHROME_COMMON_READ_ANYTHING_READ_ANYTHING_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/common/read_anything/read_anything.mojom-features.h"  // IWYU pragma: export
#include "chrome/common/read_anything/read_anything.mojom-shared.h"  // IWYU pragma: export
#include "chrome/common/read_anything/read_anything.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/file.mojom.h"
#include "skia/public/mojom/skcolor.mojom-forward.h"
#include "skia/public/mojom/bitmap.mojom.h"
#include "ui/accessibility/ax_features.mojom-forward.h"
#include "ui/accessibility/mojom/ax_event.mojom.h"
#include "ui/accessibility/mojom/ax_location_and_scroll_updates.mojom.h"
#include "ui/accessibility/mojom/ax_tree_id.mojom.h"
#include "ui/accessibility/mojom/ax_tree_update.mojom.h"
#include "mojo/public/mojom/base/values.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace read_anything::mojom {

class UntrustedPageHandlerFactoryProxy;

template <typename ImplRefTraits>
class UntrustedPageHandlerFactoryStub;

class UntrustedPageHandlerFactoryRequestValidator;


class UntrustedPageHandlerFactory
    : public UntrustedPageHandlerFactoryInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "read_anything.mojom.UntrustedPageHandlerFactory";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = UntrustedPageHandlerFactoryInterfaceBase;
  using Proxy_ = UntrustedPageHandlerFactoryProxy;

  template <typename ImplRefTraits>
  using Stub_ = UntrustedPageHandlerFactoryStub<ImplRefTraits>;

  using RequestValidator_ = UntrustedPageHandlerFactoryRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kCreateUntrustedPageHandlerMinVersion = 0,
    kShouldShowUIMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CreateUntrustedPageHandler_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ShouldShowUI_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~UntrustedPageHandlerFactory() = default;

  virtual void CreateUntrustedPageHandler(::mojo::PendingRemote<UntrustedPage> page, ::mojo::PendingReceiver<UntrustedPageHandler> handler) = 0;

  virtual void ShouldShowUI() = 0;
};

class UntrustedPageHandlerProxy;

template <typename ImplRefTraits>
class UntrustedPageHandlerStub;

class UntrustedPageHandlerRequestValidator;
class UntrustedPageHandlerResponseValidator;


class UntrustedPageHandler
    : public UntrustedPageHandlerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "read_anything.mojom.UntrustedPageHandler";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = UntrustedPageHandlerInterfaceBase;
  using Proxy_ = UntrustedPageHandlerProxy;

  template <typename ImplRefTraits>
  using Stub_ = UntrustedPageHandlerStub<ImplRefTraits>;

  using RequestValidator_ = UntrustedPageHandlerRequestValidator;
  using ResponseValidator_ = UntrustedPageHandlerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetDependencyParserModelMinVersion = 0,
    kGetVoicePackInfoMinVersion = 0,
    kInstallVoicePackMinVersion = 0,
    kUninstallVoiceMinVersion = 0,
    kOnCopyMinVersion = 0,
    kOnLineSpaceChangeMinVersion = 0,
    kOnLetterSpaceChangeMinVersion = 0,
    kOnFontChangeMinVersion = 0,
    kOnFontSizeChangeMinVersion = 0,
    kOnLinksEnabledChangedMinVersion = 0,
    kOnImagesEnabledChangedMinVersion = 0,
    kOnColorChangeMinVersion = 0,
    kOnSpeechRateChangeMinVersion = 0,
    kOnVoiceChangeMinVersion = 0,
    kOnLanguagePrefChangeMinVersion = 0,
    kLogExtensionStateMinVersion = 0,
    kOnHighlightGranularityChangedMinVersion = 0,
    kOnReadAloudAudioStateChangeMinVersion = 0,
    kOnLinkClickedMinVersion = 0,
    kOnImageDataRequestedMinVersion = 0,
    kOnSelectionChangeMinVersion = 0,
    kOnCollapseSelectionMinVersion = 0,
    kOnScreenshotRequestedMinVersion = 0,
    kScrollToTargetNodeMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GetDependencyParserModel_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetVoicePackInfo_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct InstallVoicePack_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UninstallVoice_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnCopy_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnLineSpaceChange_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnLetterSpaceChange_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnFontChange_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnFontSizeChange_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnLinksEnabledChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnImagesEnabledChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnColorChange_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnSpeechRateChange_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnVoiceChange_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnLanguagePrefChange_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct LogExtensionState_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnHighlightGranularityChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnReadAloudAudioStateChange_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnLinkClicked_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnImageDataRequested_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnSelectionChange_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnCollapseSelection_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnScreenshotRequested_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ScrollToTargetNode_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~UntrustedPageHandler() = default;

  using GetDependencyParserModelCallback = base::OnceCallback<void(::base::File)>;
  using GetDependencyParserModelMojoCallback = base::OnceCallback<void(::base::File)>;

  virtual void GetDependencyParserModel(GetDependencyParserModelCallback callback) = 0;

  virtual void GetVoicePackInfo(const std::string& language) = 0;

  virtual void InstallVoicePack(const std::string& language) = 0;

  virtual void UninstallVoice(const std::string& language) = 0;

  virtual void OnCopy() = 0;

  virtual void OnLineSpaceChange(LineSpacing line_spacing) = 0;

  virtual void OnLetterSpaceChange(LetterSpacing letter_spacing) = 0;

  virtual void OnFontChange(const std::string& font) = 0;

  virtual void OnFontSizeChange(double font_size) = 0;

  virtual void OnLinksEnabledChanged(bool enabled) = 0;

  virtual void OnImagesEnabledChanged(bool enabled) = 0;

  virtual void OnColorChange(Colors color) = 0;

  virtual void OnSpeechRateChange(double rate) = 0;

  virtual void OnVoiceChange(const std::string& voice, const std::string& lang) = 0;

  virtual void OnLanguagePrefChange(const std::string& lang, bool enabled) = 0;

  virtual void LogExtensionState() = 0;

  virtual void OnHighlightGranularityChanged(HighlightGranularity granularity) = 0;

  virtual void OnReadAloudAudioStateChange(bool playing) = 0;

  virtual void OnLinkClicked(const ::ui::AXTreeID& target_tree_id, int32_t target_node_id) = 0;

  virtual void OnImageDataRequested(const ::ui::AXTreeID& target_tree_id, int32_t target_node_id) = 0;

  virtual void OnSelectionChange(const ::ui::AXTreeID& target_tree_id, int32_t anchor_node_id, int32_t anchor_offset, int32_t focus_node_id, int32_t focus_offset) = 0;

  virtual void OnCollapseSelection() = 0;

  virtual void OnScreenshotRequested() = 0;

  virtual void ScrollToTargetNode(const ::ui::AXTreeID& target_tree_id, int32_t target_node_id) = 0;
};

class UntrustedPageProxy;

template <typename ImplRefTraits>
class UntrustedPageStub;

class UntrustedPageRequestValidator;


class UntrustedPage
    : public UntrustedPageInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "read_anything.mojom.UntrustedPage";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = UntrustedPageInterfaceBase;
  using Proxy_ = UntrustedPageProxy;

  template <typename ImplRefTraits>
  using Stub_ = UntrustedPageStub<ImplRefTraits>;

  using RequestValidator_ = UntrustedPageRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kAccessibilityEventReceivedMinVersion = 0,
    kOnGetVoicePackInfoMinVersion = 0,
    kAccessibilityLocationChangesReceivedMinVersion = 0,
    kOnActiveAXTreeIDChangedMinVersion = 0,
    kOnAXTreeDestroyedMinVersion = 0,
    kSetLanguageCodeMinVersion = 0,
    kOnTtsEngineInstalledMinVersion = 0,
    kSetDefaultLanguageCodeMinVersion = 0,
    kOnSettingsRestoredFromPrefsMinVersion = 0,
    kScreenAIServiceReadyMinVersion = 0,
    kOnReadingModeHiddenMinVersion = 0,
    kOnTabWillDetachMinVersion = 0,
    kOnTabMuteStateChangeMinVersion = 0,
    kOnImageDataDownloadedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct AccessibilityEventReceived_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnGetVoicePackInfo_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AccessibilityLocationChangesReceived_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnActiveAXTreeIDChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnAXTreeDestroyed_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetLanguageCode_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnTtsEngineInstalled_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetDefaultLanguageCode_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnSettingsRestoredFromPrefs_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ScreenAIServiceReady_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnReadingModeHidden_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnTabWillDetach_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnTabMuteStateChange_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnImageDataDownloaded_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~UntrustedPage() = default;

  virtual void AccessibilityEventReceived(const ::ui::AXTreeID& tree_id, const std::vector<::ui::AXTreeUpdate>& updates, const std::vector<::ui::AXEvent>& events) = 0;

  virtual void OnGetVoicePackInfo(VoicePackInfoPtr voice_pack_info) = 0;

  virtual void AccessibilityLocationChangesReceived(const ::ui::AXTreeID& tree_id, const ::ui::AXLocationAndScrollUpdates& details) = 0;
  // Default implementation for non-const ref params. This method can be
  // implemented as a performance optimization for non-const ref types.
  virtual void AccessibilityLocationChangesReceived(const ::ui::AXTreeID& tree_id, ::ui::AXLocationAndScrollUpdates& details) {
    AccessibilityLocationChangesReceived(std::move(tree_id), const_cast<const ::ui::AXLocationAndScrollUpdates&>(details));
  }

  virtual void OnActiveAXTreeIDChanged(const ::ui::AXTreeID& tree_id, int64_t ukm_source_id, bool is_pdf) = 0;

  virtual void OnAXTreeDestroyed(const ::ui::AXTreeID& tree_id) = 0;

  virtual void SetLanguageCode(const std::string& code) = 0;

  virtual void OnTtsEngineInstalled() = 0;

  virtual void SetDefaultLanguageCode(const std::string& code) = 0;

  virtual void OnSettingsRestoredFromPrefs(LineSpacing line_spacing, LetterSpacing letter_spacing, const std::string& font, double font_size, bool links_enabled, bool images_enabled, Colors color, double speech_rate, ::base::Value::Dict voices, ::base::Value::List languages_enabled_in_pref, HighlightGranularity granularity) = 0;

  virtual void ScreenAIServiceReady() = 0;

  virtual void OnReadingModeHidden() = 0;

  virtual void OnTabWillDetach() = 0;

  virtual void OnTabMuteStateChange(bool muted) = 0;

  virtual void OnImageDataDownloaded(const ::ui::AXTreeID& tree_id, int32_t node_id, const ::SkBitmap& image) = 0;
};



class  UntrustedPageHandlerFactoryProxy
    : public UntrustedPageHandlerFactory {
 public:
  using InterfaceType = UntrustedPageHandlerFactory;

  explicit UntrustedPageHandlerFactoryProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreateUntrustedPageHandler(::mojo::PendingRemote<UntrustedPage> page, ::mojo::PendingReceiver<UntrustedPageHandler> handler) final;
  
  void ShouldShowUI() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  UntrustedPageHandlerProxy
    : public UntrustedPageHandler {
 public:
  using InterfaceType = UntrustedPageHandler;

  explicit UntrustedPageHandlerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetDependencyParserModel(GetDependencyParserModelCallback callback) final;
  
  void GetVoicePackInfo(const std::string& language) final;
  
  void InstallVoicePack(const std::string& language) final;
  
  void UninstallVoice(const std::string& language) final;
  
  void OnCopy() final;
  
  void OnLineSpaceChange(LineSpacing line_spacing) final;
  
  void OnLetterSpaceChange(LetterSpacing letter_spacing) final;
  
  void OnFontChange(const std::string& font) final;
  
  void OnFontSizeChange(double font_size) final;
  
  void OnLinksEnabledChanged(bool enabled) final;
  
  void OnImagesEnabledChanged(bool enabled) final;
  
  void OnColorChange(Colors color) final;
  
  void OnSpeechRateChange(double rate) final;
  
  void OnVoiceChange(const std::string& voice, const std::string& lang) final;
  
  void OnLanguagePrefChange(const std::string& lang, bool enabled) final;
  
  void LogExtensionState() final;
  
  void OnHighlightGranularityChanged(HighlightGranularity granularity) final;
  
  void OnReadAloudAudioStateChange(bool playing) final;
  
  void OnLinkClicked(const ::ui::AXTreeID& target_tree_id, int32_t target_node_id) final;
  
  void OnImageDataRequested(const ::ui::AXTreeID& target_tree_id, int32_t target_node_id) final;
  
  void OnSelectionChange(const ::ui::AXTreeID& target_tree_id, int32_t anchor_node_id, int32_t anchor_offset, int32_t focus_node_id, int32_t focus_offset) final;
  
  void OnCollapseSelection() final;
  
  void OnScreenshotRequested() final;
  
  void ScrollToTargetNode(const ::ui::AXTreeID& target_tree_id, int32_t target_node_id) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  UntrustedPageProxy
    : public UntrustedPage {
 public:
  using InterfaceType = UntrustedPage;

  explicit UntrustedPageProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void AccessibilityEventReceived(const ::ui::AXTreeID& tree_id, const std::vector<::ui::AXTreeUpdate>& updates, const std::vector<::ui::AXEvent>& events) final;
  
  void OnGetVoicePackInfo(VoicePackInfoPtr voice_pack_info) final;
  
  void AccessibilityLocationChangesReceived(const ::ui::AXTreeID& tree_id, const ::ui::AXLocationAndScrollUpdates& details) final;
  
  void OnActiveAXTreeIDChanged(const ::ui::AXTreeID& tree_id, int64_t ukm_source_id, bool is_pdf) final;
  
  void OnAXTreeDestroyed(const ::ui::AXTreeID& tree_id) final;
  
  void SetLanguageCode(const std::string& code) final;
  
  void OnTtsEngineInstalled() final;
  
  void SetDefaultLanguageCode(const std::string& code) final;
  
  void OnSettingsRestoredFromPrefs(LineSpacing line_spacing, LetterSpacing letter_spacing, const std::string& font, double font_size, bool links_enabled, bool images_enabled, Colors color, double speech_rate, ::base::Value::Dict voices, ::base::Value::List languages_enabled_in_pref, HighlightGranularity granularity) final;
  
  void ScreenAIServiceReady() final;
  
  void OnReadingModeHidden() final;
  
  void OnTabWillDetach() final;
  
  void OnTabMuteStateChange(bool muted) final;
  
  void OnImageDataDownloaded(const ::ui::AXTreeID& tree_id, int32_t node_id, const ::SkBitmap& image) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  UntrustedPageHandlerFactoryStubDispatch {
 public:
  static bool Accept(UntrustedPageHandlerFactory* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      UntrustedPageHandlerFactory* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<UntrustedPageHandlerFactory>>
class UntrustedPageHandlerFactoryStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  UntrustedPageHandlerFactoryStub() = default;
  ~UntrustedPageHandlerFactoryStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return UntrustedPageHandlerFactoryStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return UntrustedPageHandlerFactoryStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  UntrustedPageHandlerStubDispatch {
 public:
  static bool Accept(UntrustedPageHandler* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      UntrustedPageHandler* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<UntrustedPageHandler>>
class UntrustedPageHandlerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  UntrustedPageHandlerStub() = default;
  ~UntrustedPageHandlerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return UntrustedPageHandlerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return UntrustedPageHandlerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  UntrustedPageStubDispatch {
 public:
  static bool Accept(UntrustedPage* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      UntrustedPage* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<UntrustedPage>>
class UntrustedPageStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  UntrustedPageStub() = default;
  ~UntrustedPageStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return UntrustedPageStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return UntrustedPageStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  UntrustedPageHandlerFactoryRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  UntrustedPageHandlerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  UntrustedPageRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  UntrustedPageHandlerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};






class  VoicePackInstallationState {
 public:
  using DataView = VoicePackInstallationStateDataView;
  using Data_ = internal::VoicePackInstallationState_Data;
  using Tag = Data_::VoicePackInstallationState_Tag;

  template <typename... Args>
  static VoicePackInstallationStatePtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |installation_state|.
  static VoicePackInstallationStatePtr NewInstallationState(
      InstallationState value);
  // Construct an instance holding |error_code|.
  static VoicePackInstallationStatePtr NewErrorCode(
      ErrorCode value);

  template <typename U>
  static VoicePackInstallationStatePtr From(const U& u) {
    return mojo::TypeConverter<VoicePackInstallationStatePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, VoicePackInstallationState>::Convert(*this);
  }
  ~VoicePackInstallationState();


  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = VoicePackInstallationStatePtr>
  VoicePackInstallationStatePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, VoicePackInstallationState>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, VoicePackInstallationState>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }
  size_t Hash(size_t seed) const;

  Tag which() const {
    return tag_;
  }

  bool is_installation_state() const { return tag_ == Tag::kInstallationState; }
  InstallationState get_installation_state() const {
    CHECK(tag_ == Tag::kInstallationState);
    return data_.installation_state;
  }
  void set_installation_state(InstallationState installation_state);

  bool is_error_code() const { return tag_ == Tag::kErrorCode; }
  ErrorCode get_error_code() const {
    CHECK(tag_ == Tag::kErrorCode);
    return data_.error_code;
  }
  void set_error_code(ErrorCode error_code);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        VoicePackInstallationState::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<VoicePackInstallationState::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kInstallationState)>,
        InstallationState value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kErrorCode)>,
        ErrorCode value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    InstallationState installation_state;
    ErrorCode error_code;
  };

  VoicePackInstallationState(
      std::in_place_index_t<static_cast<size_t>(Tag::kInstallationState)>,
      InstallationState value);
  VoicePackInstallationState(
      std::in_place_index_t<static_cast<size_t>(Tag::kErrorCode)>,
      ErrorCode value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};





class  VoicePackInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<VoicePackInfo, T>::value>;
  using DataView = VoicePackInfoDataView;
  using Data_ = internal::VoicePackInfo_Data;

  template <typename... Args>
  static VoicePackInfoPtr New(Args&&... args) {
    return VoicePackInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static VoicePackInfoPtr From(const U& u) {
    return mojo::TypeConverter<VoicePackInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, VoicePackInfo>::Convert(*this);
  }


  VoicePackInfo();

  VoicePackInfo(
      VoicePackInstallationStatePtr pack_state,
      const std::string& language);

VoicePackInfo(const VoicePackInfo&) = delete;
VoicePackInfo& operator=(const VoicePackInfo&) = delete;

  ~VoicePackInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = VoicePackInfoPtr>
  VoicePackInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, VoicePackInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, VoicePackInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, VoicePackInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VoicePackInfo::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VoicePackInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        VoicePackInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::VoicePackInfo_UnserializedMessageContext<
            UserType, VoicePackInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<VoicePackInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return VoicePackInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::VoicePackInfo_UnserializedMessageContext<
            UserType, VoicePackInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<VoicePackInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  VoicePackInstallationStatePtr pack_state;
  
  std::string language;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, VoicePackInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, VoicePackInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, VoicePackInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, VoicePackInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
VoicePackInstallationStatePtr VoicePackInstallationState::Clone() const {
  switch (tag_) {
    case Tag::kInstallationState:
      return NewInstallationState(
          mojo::Clone(data_.installation_state));
    case Tag::kErrorCode:
      return NewErrorCode(
          mojo::Clone(data_.error_code));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, VoicePackInstallationState>::value>::type*>
bool VoicePackInstallationState::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kInstallationState:
      return mojo::Equals(data_.installation_state, other.data_.installation_state);
    case Tag::kErrorCode:
      return mojo::Equals(data_.error_code, other.data_.error_code);
  }

  return false;
}
template <typename StructPtrType>
VoicePackInfoPtr VoicePackInfo::Clone() const {
  return New(
      mojo::Clone(pack_state),
      mojo::Clone(language)
  );
}

template <typename T, VoicePackInfo::EnableIfSame<T>*>
bool VoicePackInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->pack_state, other_struct.pack_state))
    return false;
  if (!mojo::Equals(this->language, other_struct.language))
    return false;
  return true;
}

template <typename T, VoicePackInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.pack_state < rhs.pack_state)
    return true;
  if (rhs.pack_state < lhs.pack_state)
    return false;
  if (lhs.language < rhs.language)
    return true;
  if (rhs.language < lhs.language)
    return false;
  return false;
}


}  // read_anything::mojom

namespace mojo {


template <>
struct  StructTraits<::read_anything::mojom::VoicePackInfo::DataView,
                                         ::read_anything::mojom::VoicePackInfoPtr> {
  static bool IsNull(const ::read_anything::mojom::VoicePackInfoPtr& input) { return !input; }
  static void SetToNull(::read_anything::mojom::VoicePackInfoPtr* output) { output->reset(); }

  static const decltype(::read_anything::mojom::VoicePackInfo::pack_state)& pack_state(
      const ::read_anything::mojom::VoicePackInfoPtr& input) {
    return input->pack_state;
  }

  static const decltype(::read_anything::mojom::VoicePackInfo::language)& language(
      const ::read_anything::mojom::VoicePackInfoPtr& input) {
    return input->language;
  }

  static bool Read(::read_anything::mojom::VoicePackInfo::DataView input, ::read_anything::mojom::VoicePackInfoPtr* output);
};


template <>
struct  UnionTraits<::read_anything::mojom::VoicePackInstallationState::DataView,
                                        ::read_anything::mojom::VoicePackInstallationStatePtr> {
  static bool IsNull(const ::read_anything::mojom::VoicePackInstallationStatePtr& input) { return !input; }
  static void SetToNull(::read_anything::mojom::VoicePackInstallationStatePtr* output) { output->reset(); }

  static ::read_anything::mojom::VoicePackInstallationState::Tag GetTag(const ::read_anything::mojom::VoicePackInstallationStatePtr& input) {
    return input->which();
  }

  static  ::read_anything::mojom::InstallationState installation_state(const ::read_anything::mojom::VoicePackInstallationStatePtr& input) {
    return input->get_installation_state();
  }

  static  ::read_anything::mojom::ErrorCode error_code(const ::read_anything::mojom::VoicePackInstallationStatePtr& input) {
    return input->get_error_code();
  }

  static bool Read(::read_anything::mojom::VoicePackInstallationState::DataView input, ::read_anything::mojom::VoicePackInstallationStatePtr* output);
};

}  // namespace mojo

#endif  // CHROME_COMMON_READ_ANYTHING_READ_ANYTHING_MOJOM_H_