// chrome/common/open_search_description_document_handler.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_COMMON_OPEN_SEARCH_DESCRIPTION_DOCUMENT_HANDLER_MOJOM_H_
#define CHROME_COMMON_OPEN_SEARCH_DESCRIPTION_DOCUMENT_HANDLER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/common/open_search_description_document_handler.mojom-features.h"  // IWYU pragma: export
#include "chrome/common/open_search_description_document_handler.mojom-shared.h"  // IWYU pragma: export
#include "chrome/common/open_search_description_document_handler.mojom-forward.h"  // IWYU pragma: export
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace chrome::mojom {

class OpenSearchDescriptionDocumentHandlerProxy;

template <typename ImplRefTraits>
class OpenSearchDescriptionDocumentHandlerStub;

class OpenSearchDescriptionDocumentHandlerRequestValidator;


class OpenSearchDescriptionDocumentHandler
    : public OpenSearchDescriptionDocumentHandlerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "chrome.mojom.OpenSearchDescriptionDocumentHandler";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = OpenSearchDescriptionDocumentHandlerInterfaceBase;
  using Proxy_ = OpenSearchDescriptionDocumentHandlerProxy;

  template <typename ImplRefTraits>
  using Stub_ = OpenSearchDescriptionDocumentHandlerStub<ImplRefTraits>;

  using RequestValidator_ = OpenSearchDescriptionDocumentHandlerRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kPageHasOpenSearchDescriptionDocumentMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct PageHasOpenSearchDescriptionDocument_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~OpenSearchDescriptionDocumentHandler() = default;

  virtual void PageHasOpenSearchDescriptionDocument(const ::GURL& page_url, const ::GURL& osdd_url) = 0;
};



class  OpenSearchDescriptionDocumentHandlerProxy
    : public OpenSearchDescriptionDocumentHandler {
 public:
  using InterfaceType = OpenSearchDescriptionDocumentHandler;

  explicit OpenSearchDescriptionDocumentHandlerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void PageHasOpenSearchDescriptionDocument(const ::GURL& page_url, const ::GURL& osdd_url) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  OpenSearchDescriptionDocumentHandlerStubDispatch {
 public:
  static bool Accept(OpenSearchDescriptionDocumentHandler* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      OpenSearchDescriptionDocumentHandler* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<OpenSearchDescriptionDocumentHandler>>
class OpenSearchDescriptionDocumentHandlerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  OpenSearchDescriptionDocumentHandlerStub() = default;
  ~OpenSearchDescriptionDocumentHandlerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return OpenSearchDescriptionDocumentHandlerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return OpenSearchDescriptionDocumentHandlerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  OpenSearchDescriptionDocumentHandlerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // chrome::mojom

namespace mojo {

}  // namespace mojo

#endif  // CHROME_COMMON_OPEN_SEARCH_DESCRIPTION_DOCUMENT_HANDLER_MOJOM_H_