// chrome/common/offline_page_auto_fetcher.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_COMMON_OFFLINE_PAGE_AUTO_FETCHER_MOJOM_H_
#define CHROME_COMMON_OFFLINE_PAGE_AUTO_FETCHER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/common/offline_page_auto_fetcher.mojom-features.h"  // IWYU pragma: export
#include "chrome/common/offline_page_auto_fetcher.mojom-shared.h"  // IWYU pragma: export
#include "chrome/common/offline_page_auto_fetcher.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace chrome::mojom {

class OfflinePageAutoFetcherProxy;

template <typename ImplRefTraits>
class OfflinePageAutoFetcherStub;

class OfflinePageAutoFetcherRequestValidator;
class OfflinePageAutoFetcherResponseValidator;


class OfflinePageAutoFetcher
    : public OfflinePageAutoFetcherInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "chrome.mojom.OfflinePageAutoFetcher";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = OfflinePageAutoFetcherInterfaceBase;
  using Proxy_ = OfflinePageAutoFetcherProxy;

  template <typename ImplRefTraits>
  using Stub_ = OfflinePageAutoFetcherStub<ImplRefTraits>;

  using RequestValidator_ = OfflinePageAutoFetcherRequestValidator;
  using ResponseValidator_ = OfflinePageAutoFetcherResponseValidator;
  enum MethodMinVersions : uint32_t {
    kTryScheduleMinVersion = 0,
    kCancelScheduleMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct TrySchedule_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CancelSchedule_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~OfflinePageAutoFetcher() = default;

  using TryScheduleCallback = base::OnceCallback<void(OfflinePageAutoFetcherScheduleResult)>;
  using TryScheduleMojoCallback = base::OnceCallback<void(OfflinePageAutoFetcherScheduleResult)>;

  virtual void TrySchedule(bool user_requested, TryScheduleCallback callback) = 0;

  virtual void CancelSchedule() = 0;
};



class  OfflinePageAutoFetcherProxy
    : public OfflinePageAutoFetcher {
 public:
  using InterfaceType = OfflinePageAutoFetcher;

  explicit OfflinePageAutoFetcherProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void TrySchedule(bool user_requested, TryScheduleCallback callback) final;
  
  void CancelSchedule() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  OfflinePageAutoFetcherStubDispatch {
 public:
  static bool Accept(OfflinePageAutoFetcher* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      OfflinePageAutoFetcher* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<OfflinePageAutoFetcher>>
class OfflinePageAutoFetcherStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  OfflinePageAutoFetcherStub() = default;
  ~OfflinePageAutoFetcherStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return OfflinePageAutoFetcherStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return OfflinePageAutoFetcherStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  OfflinePageAutoFetcherRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  OfflinePageAutoFetcherResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // chrome::mojom

namespace mojo {

}  // namespace mojo

#endif  // CHROME_COMMON_OFFLINE_PAGE_AUTO_FETCHER_MOJOM_H_