// chrome/common/network_easter_egg.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_COMMON_NETWORK_EASTER_EGG_MOJOM_H_
#define CHROME_COMMON_NETWORK_EASTER_EGG_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/common/network_easter_egg.mojom-features.h"  // IWYU pragma: export
#include "chrome/common/network_easter_egg.mojom-shared.h"  // IWYU pragma: export
#include "chrome/common/network_easter_egg.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace chrome::mojom {

class NetworkEasterEggProxy;

template <typename ImplRefTraits>
class NetworkEasterEggStub;

class NetworkEasterEggRequestValidator;
class NetworkEasterEggResponseValidator;


class NetworkEasterEgg
    : public NetworkEasterEggInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "chrome.mojom.NetworkEasterEgg";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = NetworkEasterEggInterfaceBase;
  using Proxy_ = NetworkEasterEggProxy;

  template <typename ImplRefTraits>
  using Stub_ = NetworkEasterEggStub<ImplRefTraits>;

  using RequestValidator_ = NetworkEasterEggRequestValidator;
  using ResponseValidator_ = NetworkEasterEggResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetHighScoreMinVersion = 0,
    kUpdateHighScoreMinVersion = 0,
    kResetHighScoreMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GetHighScore_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdateHighScore_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ResetHighScore_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~NetworkEasterEgg() = default;

  using GetHighScoreCallback = base::OnceCallback<void(uint32_t)>;
  using GetHighScoreMojoCallback = base::OnceCallback<void(uint32_t)>;

  virtual void GetHighScore(GetHighScoreCallback callback) = 0;

  virtual void UpdateHighScore(uint32_t high_score) = 0;

  virtual void ResetHighScore() = 0;
};



class  NetworkEasterEggProxy
    : public NetworkEasterEgg {
 public:
  using InterfaceType = NetworkEasterEgg;

  explicit NetworkEasterEggProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetHighScore(GetHighScoreCallback callback) final;
  
  void UpdateHighScore(uint32_t high_score) final;
  
  void ResetHighScore() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  NetworkEasterEggStubDispatch {
 public:
  static bool Accept(NetworkEasterEgg* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      NetworkEasterEgg* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<NetworkEasterEgg>>
class NetworkEasterEggStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  NetworkEasterEggStub() = default;
  ~NetworkEasterEggStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return NetworkEasterEggStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return NetworkEasterEggStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  NetworkEasterEggRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  NetworkEasterEggResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // chrome::mojom

namespace mojo {

}  // namespace mojo

#endif  // CHROME_COMMON_NETWORK_EASTER_EGG_MOJOM_H_