// chrome/common/network_diagnostics.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_COMMON_NETWORK_DIAGNOSTICS_MOJOM_H_
#define CHROME_COMMON_NETWORK_DIAGNOSTICS_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/common/network_diagnostics.mojom-features.h"  // IWYU pragma: export
#include "chrome/common/network_diagnostics.mojom-shared.h"  // IWYU pragma: export
#include "chrome/common/network_diagnostics.mojom-forward.h"  // IWYU pragma: export
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace chrome::mojom {

class NetworkDiagnosticsProxy;

template <typename ImplRefTraits>
class NetworkDiagnosticsStub;

class NetworkDiagnosticsRequestValidator;


class NetworkDiagnostics
    : public NetworkDiagnosticsInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "chrome.mojom.NetworkDiagnostics";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = NetworkDiagnosticsInterfaceBase;
  using Proxy_ = NetworkDiagnosticsProxy;

  template <typename ImplRefTraits>
  using Stub_ = NetworkDiagnosticsStub<ImplRefTraits>;

  using RequestValidator_ = NetworkDiagnosticsRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kRunNetworkDiagnosticsMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct RunNetworkDiagnostics_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~NetworkDiagnostics() = default;

  virtual void RunNetworkDiagnostics(const ::GURL& failed_url) = 0;
};

class NetworkDiagnosticsClientProxy;

template <typename ImplRefTraits>
class NetworkDiagnosticsClientStub;

class NetworkDiagnosticsClientRequestValidator;


class NetworkDiagnosticsClient
    : public NetworkDiagnosticsClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "chrome.mojom.NetworkDiagnosticsClient";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = NetworkDiagnosticsClientInterfaceBase;
  using Proxy_ = NetworkDiagnosticsClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = NetworkDiagnosticsClientStub<ImplRefTraits>;

  using RequestValidator_ = NetworkDiagnosticsClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kSetCanShowNetworkDiagnosticsDialogMinVersion = 0,
    kDNSProbeStatusMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SetCanShowNetworkDiagnosticsDialog_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DNSProbeStatus_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~NetworkDiagnosticsClient() = default;

  virtual void SetCanShowNetworkDiagnosticsDialog(bool can_show) = 0;

  virtual void DNSProbeStatus(int32_t status) = 0;
};



class  NetworkDiagnosticsProxy
    : public NetworkDiagnostics {
 public:
  using InterfaceType = NetworkDiagnostics;

  explicit NetworkDiagnosticsProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void RunNetworkDiagnostics(const ::GURL& failed_url) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  NetworkDiagnosticsClientProxy
    : public NetworkDiagnosticsClient {
 public:
  using InterfaceType = NetworkDiagnosticsClient;

  explicit NetworkDiagnosticsClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetCanShowNetworkDiagnosticsDialog(bool can_show) final;
  
  void DNSProbeStatus(int32_t status) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  NetworkDiagnosticsStubDispatch {
 public:
  static bool Accept(NetworkDiagnostics* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      NetworkDiagnostics* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<NetworkDiagnostics>>
class NetworkDiagnosticsStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  NetworkDiagnosticsStub() = default;
  ~NetworkDiagnosticsStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return NetworkDiagnosticsStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return NetworkDiagnosticsStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  NetworkDiagnosticsClientStubDispatch {
 public:
  static bool Accept(NetworkDiagnosticsClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      NetworkDiagnosticsClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<NetworkDiagnosticsClient>>
class NetworkDiagnosticsClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  NetworkDiagnosticsClientStub() = default;
  ~NetworkDiagnosticsClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return NetworkDiagnosticsClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return NetworkDiagnosticsClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  NetworkDiagnosticsRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  NetworkDiagnosticsClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // chrome::mojom

namespace mojo {

}  // namespace mojo

#endif  // CHROME_COMMON_NETWORK_DIAGNOSTICS_MOJOM_H_