// chrome/common/network_diagnostics.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "chrome/common/network_diagnostics.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/common/network_diagnostics.mojom-params-data.h"
#include "chrome/common/network_diagnostics.mojom-shared-message-ids.h"

#include "chrome/common/network_diagnostics.mojom-import-headers.h"
#include "chrome/common/network_diagnostics.mojom-test-utils.h"


namespace chrome::mojom {
// The declaration includes the definition on other builds.

NetworkDiagnostics::IPCStableHashFunction NetworkDiagnostics::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::NetworkDiagnostics>(message.name())) {
    case messages::NetworkDiagnostics::kRunNetworkDiagnostics: {
      return &NetworkDiagnostics::RunNetworkDiagnostics_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* NetworkDiagnostics::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::NetworkDiagnostics>(message.name())) {
      case messages::NetworkDiagnostics::kRunNetworkDiagnostics:
            return "Receive chrome::mojom::NetworkDiagnostics::RunNetworkDiagnostics";
    }
  } else {
    switch (static_cast<messages::NetworkDiagnostics>(message.name())) {
      case messages::NetworkDiagnostics::kRunNetworkDiagnostics:
            return "Receive reply chrome::mojom::NetworkDiagnostics::RunNetworkDiagnostics";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t NetworkDiagnostics::RunNetworkDiagnostics_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3d1bce8a;  // IPCStableHash for chrome::mojom::NetworkDiagnostics::RunNetworkDiagnostics
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

NetworkDiagnosticsProxy::NetworkDiagnosticsProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void NetworkDiagnosticsProxy::RunNetworkDiagnostics(
    const ::GURL& in_failed_url) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send chrome::mojom::NetworkDiagnostics::RunNetworkDiagnostics", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("failed_url"), in_failed_url,
                        "<value of type const ::GURL&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkDiagnostics::kRunNetworkDiagnostics), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::NetworkDiagnostics_RunNetworkDiagnostics_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->failed_url)::BaseType> failed_url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_failed_url,
    failed_url_fragment);

  params->failed_url.Set(
      failed_url_fragment.is_null() ? nullptr : failed_url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->failed_url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null failed_url in NetworkDiagnostics.RunNetworkDiagnostics request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkDiagnostics::Name_);
  message.set_method_name("RunNetworkDiagnostics");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool NetworkDiagnosticsStubDispatch::Accept(
    NetworkDiagnostics* impl,
    mojo::Message* message) {
  switch (static_cast<messages::NetworkDiagnostics>(message->header()->name)) {
    case messages::NetworkDiagnostics::kRunNetworkDiagnostics: {
      DCHECK(message->is_serialized());
      internal::NetworkDiagnostics_RunNetworkDiagnostics_Params_Data* params =
          reinterpret_cast<internal::NetworkDiagnostics_RunNetworkDiagnostics_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NetworkDiagnostics.0
      bool success = true;
      ::GURL p_failed_url{};
      NetworkDiagnostics_RunNetworkDiagnostics_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFailedUrl(&p_failed_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkDiagnostics::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RunNetworkDiagnostics(        
        std::move(p_failed_url));
      return true;
    }
  }
  return false;
}

// static
bool NetworkDiagnosticsStubDispatch::AcceptWithResponder(
    NetworkDiagnostics* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::NetworkDiagnostics>(message->header()->name)) {
    case messages::NetworkDiagnostics::kRunNetworkDiagnostics: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kNetworkDiagnosticsValidationInfo[] = {
    { &internal::NetworkDiagnostics_RunNetworkDiagnostics_Params_Data::Validate,
     nullptr /* no response */},
};

bool NetworkDiagnosticsRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::chrome::mojom::NetworkDiagnostics::Name_,
    kNetworkDiagnosticsValidationInfo);
}

// The declaration includes the definition on other builds.

NetworkDiagnosticsClient::IPCStableHashFunction NetworkDiagnosticsClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::NetworkDiagnosticsClient>(message.name())) {
    case messages::NetworkDiagnosticsClient::kSetCanShowNetworkDiagnosticsDialog: {
      return &NetworkDiagnosticsClient::SetCanShowNetworkDiagnosticsDialog_Sym::IPCStableHash;
    }
    case messages::NetworkDiagnosticsClient::kDNSProbeStatus: {
      return &NetworkDiagnosticsClient::DNSProbeStatus_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* NetworkDiagnosticsClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::NetworkDiagnosticsClient>(message.name())) {
      case messages::NetworkDiagnosticsClient::kSetCanShowNetworkDiagnosticsDialog:
            return "Receive chrome::mojom::NetworkDiagnosticsClient::SetCanShowNetworkDiagnosticsDialog";
      case messages::NetworkDiagnosticsClient::kDNSProbeStatus:
            return "Receive chrome::mojom::NetworkDiagnosticsClient::DNSProbeStatus";
    }
  } else {
    switch (static_cast<messages::NetworkDiagnosticsClient>(message.name())) {
      case messages::NetworkDiagnosticsClient::kSetCanShowNetworkDiagnosticsDialog:
            return "Receive reply chrome::mojom::NetworkDiagnosticsClient::SetCanShowNetworkDiagnosticsDialog";
      case messages::NetworkDiagnosticsClient::kDNSProbeStatus:
            return "Receive reply chrome::mojom::NetworkDiagnosticsClient::DNSProbeStatus";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t NetworkDiagnosticsClient::SetCanShowNetworkDiagnosticsDialog_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x08f9c0f0;  // IPCStableHash for chrome::mojom::NetworkDiagnosticsClient::SetCanShowNetworkDiagnosticsDialog
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkDiagnosticsClient::DNSProbeStatus_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2b29cdff;  // IPCStableHash for chrome::mojom::NetworkDiagnosticsClient::DNSProbeStatus
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

NetworkDiagnosticsClientProxy::NetworkDiagnosticsClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void NetworkDiagnosticsClientProxy::SetCanShowNetworkDiagnosticsDialog(
    bool in_can_show) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send chrome::mojom::NetworkDiagnosticsClient::SetCanShowNetworkDiagnosticsDialog", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("can_show"), in_can_show,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkDiagnosticsClient::kSetCanShowNetworkDiagnosticsDialog), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::NetworkDiagnosticsClient_SetCanShowNetworkDiagnosticsDialog_Params_Data> params(
          message);
  params.Allocate();

  params->can_show = in_can_show;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkDiagnosticsClient::Name_);
  message.set_method_name("SetCanShowNetworkDiagnosticsDialog");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NetworkDiagnosticsClientProxy::DNSProbeStatus(
    int32_t in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send chrome::mojom::NetworkDiagnosticsClient::DNSProbeStatus", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkDiagnosticsClient::kDNSProbeStatus), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::NetworkDiagnosticsClient_DNSProbeStatus_Params_Data> params(
          message);
  params.Allocate();

  params->status = in_status;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkDiagnosticsClient::Name_);
  message.set_method_name("DNSProbeStatus");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool NetworkDiagnosticsClientStubDispatch::Accept(
    NetworkDiagnosticsClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::NetworkDiagnosticsClient>(message->header()->name)) {
    case messages::NetworkDiagnosticsClient::kSetCanShowNetworkDiagnosticsDialog: {
      DCHECK(message->is_serialized());
      internal::NetworkDiagnosticsClient_SetCanShowNetworkDiagnosticsDialog_Params_Data* params =
          reinterpret_cast<internal::NetworkDiagnosticsClient_SetCanShowNetworkDiagnosticsDialog_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NetworkDiagnosticsClient.0
      bool success = true;
      bool p_can_show{};
      NetworkDiagnosticsClient_SetCanShowNetworkDiagnosticsDialog_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_can_show = input_data_view.can_show();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkDiagnosticsClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetCanShowNetworkDiagnosticsDialog(        
        std::move(p_can_show));
      return true;
    }
    case messages::NetworkDiagnosticsClient::kDNSProbeStatus: {
      DCHECK(message->is_serialized());
      internal::NetworkDiagnosticsClient_DNSProbeStatus_Params_Data* params =
          reinterpret_cast<internal::NetworkDiagnosticsClient_DNSProbeStatus_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NetworkDiagnosticsClient.1
      bool success = true;
      int32_t p_status{};
      NetworkDiagnosticsClient_DNSProbeStatus_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_status = input_data_view.status();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkDiagnosticsClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DNSProbeStatus(        
        std::move(p_status));
      return true;
    }
  }
  return false;
}

// static
bool NetworkDiagnosticsClientStubDispatch::AcceptWithResponder(
    NetworkDiagnosticsClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::NetworkDiagnosticsClient>(message->header()->name)) {
    case messages::NetworkDiagnosticsClient::kSetCanShowNetworkDiagnosticsDialog: {
      break;
    }
    case messages::NetworkDiagnosticsClient::kDNSProbeStatus: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kNetworkDiagnosticsClientValidationInfo[] = {
    { &internal::NetworkDiagnosticsClient_SetCanShowNetworkDiagnosticsDialog_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::NetworkDiagnosticsClient_DNSProbeStatus_Params_Data::Validate,
     nullptr /* no response */},
};

bool NetworkDiagnosticsClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::chrome::mojom::NetworkDiagnosticsClient::Name_,
    kNetworkDiagnosticsClientValidationInfo);
}



}  // chrome::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace chrome::mojom {


void NetworkDiagnosticsInterceptorForTesting::RunNetworkDiagnostics(const ::GURL& failed_url) {
  GetForwardingInterface()->RunNetworkDiagnostics(
    std::move(failed_url)
    );
}
NetworkDiagnosticsAsyncWaiter::NetworkDiagnosticsAsyncWaiter(
    NetworkDiagnostics* proxy) : proxy_(proxy) {}

NetworkDiagnosticsAsyncWaiter::~NetworkDiagnosticsAsyncWaiter() = default;





void NetworkDiagnosticsClientInterceptorForTesting::SetCanShowNetworkDiagnosticsDialog(bool can_show) {
  GetForwardingInterface()->SetCanShowNetworkDiagnosticsDialog(
    std::move(can_show)
    );
}
void NetworkDiagnosticsClientInterceptorForTesting::DNSProbeStatus(int32_t status) {
  GetForwardingInterface()->DNSProbeStatus(
    std::move(status)
    );
}
NetworkDiagnosticsClientAsyncWaiter::NetworkDiagnosticsClientAsyncWaiter(
    NetworkDiagnosticsClient* proxy) : proxy_(proxy) {}

NetworkDiagnosticsClientAsyncWaiter::~NetworkDiagnosticsClientAsyncWaiter() = default;







}  // chrome::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif