// chrome/common/importer/profile_import.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_COMMON_IMPORTER_PROFILE_IMPORT_MOJOM_H_
#define CHROME_COMMON_IMPORTER_PROFILE_IMPORT_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/common/importer/profile_import.mojom-features.h"  // IWYU pragma: export
#include "chrome/common/importer/profile_import.mojom-shared.h"  // IWYU pragma: export
#include "chrome/common/importer/profile_import.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/string16.mojom.h"
#include "sandbox/policy/mojom/sandbox.mojom-forward.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "mojo/public/cpp/bindings/lib/native_enum_serialization.h"
#include "mojo/public/cpp/bindings/lib/native_struct_serialization.h"
#include "chrome/common/importer/importer_autofill_form_data_entry.h"
#include "components/favicon_base/favicon_usage_data.h"
#include "components/user_data_importer/common/imported_bookmark_entry.h"
#include "components/user_data_importer/common/importer_data_types.h"
#include "components/user_data_importer/common/importer_url_row.h"




namespace chrome::mojom {

class ProfileImportObserverProxy;

template <typename ImplRefTraits>
class ProfileImportObserverStub;

class ProfileImportObserverRequestValidator;


class ProfileImportObserver
    : public ProfileImportObserverInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "chrome.mojom.ProfileImportObserver";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ProfileImportObserverInterfaceBase;
  using Proxy_ = ProfileImportObserverProxy;

  template <typename ImplRefTraits>
  using Stub_ = ProfileImportObserverStub<ImplRefTraits>;

  using RequestValidator_ = ProfileImportObserverRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnImportStartMinVersion = 0,
    kOnImportFinishedMinVersion = 0,
    kOnImportItemStartMinVersion = 0,
    kOnImportItemFinishedMinVersion = 0,
    kOnHistoryImportStartMinVersion = 0,
    kOnHistoryImportGroupMinVersion = 0,
    kOnHomePageImportReadyMinVersion = 0,
    kOnBookmarksImportStartMinVersion = 0,
    kOnBookmarksImportGroupMinVersion = 0,
    kOnFaviconsImportStartMinVersion = 0,
    kOnFaviconsImportGroupMinVersion = 0,
    kOnPasswordFormImportReadyMinVersion = 0,
    kOnKeywordsImportReadyMinVersion = 0,
    kOnAutofillFormDataImportStartMinVersion = 0,
    kOnAutofillFormDataImportGroupMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnImportStart_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnImportFinished_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnImportItemStart_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnImportItemFinished_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnHistoryImportStart_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnHistoryImportGroup_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnHomePageImportReady_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnBookmarksImportStart_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnBookmarksImportGroup_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnFaviconsImportStart_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnFaviconsImportGroup_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnPasswordFormImportReady_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnKeywordsImportReady_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnAutofillFormDataImportStart_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnAutofillFormDataImportGroup_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ProfileImportObserver() = default;

  virtual void OnImportStart() = 0;

  virtual void OnImportFinished(bool succeeded, const std::string& error_msg) = 0;

  virtual void OnImportItemStart(::user_data_importer::ImportItem item) = 0;

  virtual void OnImportItemFinished(::user_data_importer::ImportItem item) = 0;

  virtual void OnHistoryImportStart(uint32_t total_history_rows_count) = 0;

  virtual void OnHistoryImportGroup(const std::vector<::user_data_importer::ImporterURLRow>& history_rows_group, int32_t visit_source) = 0;

  virtual void OnHomePageImportReady(const ::GURL& home_page) = 0;

  virtual void OnBookmarksImportStart(const ::std::u16string& first_folder_name, uint32_t total_bookmarks_count) = 0;

  virtual void OnBookmarksImportGroup(const std::vector<::user_data_importer::ImportedBookmarkEntry>& bookmarks_group) = 0;

  virtual void OnFaviconsImportStart(uint32_t total_favicons_count) = 0;

  virtual void OnFaviconsImportGroup(const ::favicon_base::FaviconUsageDataList& favicons_group) = 0;

  virtual void OnPasswordFormImportReady(const ::user_data_importer::ImportedPasswordForm& form) = 0;

  virtual void OnKeywordsImportReady(const std::vector<::user_data_importer::SearchEngineInfo>& search_engines, bool unique_on_host_and_path) = 0;

  virtual void OnAutofillFormDataImportStart(uint32_t total_autofill_form_data_entry_count) = 0;

  virtual void OnAutofillFormDataImportGroup(const std::vector<::ImporterAutofillFormDataEntry>& autofill_form_data_entry_group) = 0;
};

class ProfileImportProxy;

template <typename ImplRefTraits>
class ProfileImportStub;

class ProfileImportRequestValidator;


class ProfileImport
    : public ProfileImportInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "chrome.mojom.ProfileImport";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr auto kServiceSandbox = sandbox::mojom::Sandbox::kNoSandbox;
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ProfileImportInterfaceBase;
  using Proxy_ = ProfileImportProxy;

  template <typename ImplRefTraits>
  using Stub_ = ProfileImportStub<ImplRefTraits>;

  using RequestValidator_ = ProfileImportRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kStartImportMinVersion = 0,
    kCancelImportMinVersion = 0,
    kReportImportItemFinishedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct StartImport_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CancelImport_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ReportImportItemFinished_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ProfileImport() = default;

  virtual void StartImport(const ::user_data_importer::SourceProfile& source_profile, uint16_t items, const base::flat_map<uint32_t, std::string>& localized_strings, ::mojo::PendingRemote<ProfileImportObserver> observer) = 0;

  virtual void CancelImport() = 0;

  virtual void ReportImportItemFinished(::user_data_importer::ImportItem item) = 0;
};



class  ProfileImportObserverProxy
    : public ProfileImportObserver {
 public:
  using InterfaceType = ProfileImportObserver;

  explicit ProfileImportObserverProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnImportStart() final;
  
  void OnImportFinished(bool succeeded, const std::string& error_msg) final;
  
  void OnImportItemStart(::user_data_importer::ImportItem item) final;
  
  void OnImportItemFinished(::user_data_importer::ImportItem item) final;
  
  void OnHistoryImportStart(uint32_t total_history_rows_count) final;
  
  void OnHistoryImportGroup(const std::vector<::user_data_importer::ImporterURLRow>& history_rows_group, int32_t visit_source) final;
  
  void OnHomePageImportReady(const ::GURL& home_page) final;
  
  void OnBookmarksImportStart(const ::std::u16string& first_folder_name, uint32_t total_bookmarks_count) final;
  
  void OnBookmarksImportGroup(const std::vector<::user_data_importer::ImportedBookmarkEntry>& bookmarks_group) final;
  
  void OnFaviconsImportStart(uint32_t total_favicons_count) final;
  
  void OnFaviconsImportGroup(const ::favicon_base::FaviconUsageDataList& favicons_group) final;
  
  void OnPasswordFormImportReady(const ::user_data_importer::ImportedPasswordForm& form) final;
  
  void OnKeywordsImportReady(const std::vector<::user_data_importer::SearchEngineInfo>& search_engines, bool unique_on_host_and_path) final;
  
  void OnAutofillFormDataImportStart(uint32_t total_autofill_form_data_entry_count) final;
  
  void OnAutofillFormDataImportGroup(const std::vector<::ImporterAutofillFormDataEntry>& autofill_form_data_entry_group) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  ProfileImportProxy
    : public ProfileImport {
 public:
  using InterfaceType = ProfileImport;

  explicit ProfileImportProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void StartImport(const ::user_data_importer::SourceProfile& source_profile, uint16_t items, const base::flat_map<uint32_t, std::string>& localized_strings, ::mojo::PendingRemote<ProfileImportObserver> observer) final;
  
  void CancelImport() final;
  
  void ReportImportItemFinished(::user_data_importer::ImportItem item) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  ProfileImportObserverStubDispatch {
 public:
  static bool Accept(ProfileImportObserver* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ProfileImportObserver* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ProfileImportObserver>>
class ProfileImportObserverStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ProfileImportObserverStub() = default;
  ~ProfileImportObserverStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ProfileImportObserverStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ProfileImportObserverStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  ProfileImportStubDispatch {
 public:
  static bool Accept(ProfileImport* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ProfileImport* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ProfileImport>>
class ProfileImportStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ProfileImportStub() = default;
  ~ProfileImportStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ProfileImportStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ProfileImportStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  ProfileImportObserverRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  ProfileImportRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};






















class  ImportedPasswordForm {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ImportedPasswordForm, T>::value>;
  using DataView = ImportedPasswordFormDataView;
  using Data_ = internal::ImportedPasswordForm_Data;
  using Scheme = ImportedPasswordForm_Scheme;

  template <typename... Args>
  static ImportedPasswordFormPtr New(Args&&... args) {
    return ImportedPasswordFormPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ImportedPasswordFormPtr From(const U& u) {
    return mojo::TypeConverter<ImportedPasswordFormPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ImportedPasswordForm>::Convert(*this);
  }


  ImportedPasswordForm();

  ImportedPasswordForm(
      ImportedPasswordForm::Scheme scheme,
      const std::string& signon_realm,
      const ::GURL& url,
      const ::GURL& action,
      const ::std::u16string& username_element,
      const ::std::u16string& username_value,
      const ::std::u16string& password_element,
      const ::std::u16string& password_value,
      bool blocked_by_user);


  ~ImportedPasswordForm();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ImportedPasswordFormPtr>
  ImportedPasswordFormPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ImportedPasswordForm::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ImportedPasswordForm::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ImportedPasswordForm::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ImportedPasswordForm::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ImportedPasswordForm::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ImportedPasswordForm::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ImportedPasswordForm_UnserializedMessageContext<
            UserType, ImportedPasswordForm::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ImportedPasswordForm::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ImportedPasswordForm::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ImportedPasswordForm_UnserializedMessageContext<
            UserType, ImportedPasswordForm::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ImportedPasswordForm::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ImportedPasswordForm::Scheme scheme;
  
  std::string signon_realm;
  
  ::GURL url;
  
  ::GURL action;
  
  ::std::u16string username_element;
  
  ::std::u16string username_value;
  
  ::std::u16string password_element;
  
  ::std::u16string password_value;
  
  bool blocked_by_user;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ImportedPasswordForm::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ImportedPasswordForm::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ImportedPasswordForm::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ImportedPasswordForm::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
ImportedPasswordFormPtr ImportedPasswordForm::Clone() const {
  return New(
      mojo::Clone(scheme),
      mojo::Clone(signon_realm),
      mojo::Clone(url),
      mojo::Clone(action),
      mojo::Clone(username_element),
      mojo::Clone(username_value),
      mojo::Clone(password_element),
      mojo::Clone(password_value),
      mojo::Clone(blocked_by_user)
  );
}

template <typename T, ImportedPasswordForm::EnableIfSame<T>*>
bool ImportedPasswordForm::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->scheme, other_struct.scheme))
    return false;
  if (!mojo::Equals(this->signon_realm, other_struct.signon_realm))
    return false;
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  if (!mojo::Equals(this->action, other_struct.action))
    return false;
  if (!mojo::Equals(this->username_element, other_struct.username_element))
    return false;
  if (!mojo::Equals(this->username_value, other_struct.username_value))
    return false;
  if (!mojo::Equals(this->password_element, other_struct.password_element))
    return false;
  if (!mojo::Equals(this->password_value, other_struct.password_value))
    return false;
  if (!mojo::Equals(this->blocked_by_user, other_struct.blocked_by_user))
    return false;
  return true;
}

template <typename T, ImportedPasswordForm::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.scheme < rhs.scheme)
    return true;
  if (rhs.scheme < lhs.scheme)
    return false;
  if (lhs.signon_realm < rhs.signon_realm)
    return true;
  if (rhs.signon_realm < lhs.signon_realm)
    return false;
  if (lhs.url < rhs.url)
    return true;
  if (rhs.url < lhs.url)
    return false;
  if (lhs.action < rhs.action)
    return true;
  if (rhs.action < lhs.action)
    return false;
  if (lhs.username_element < rhs.username_element)
    return true;
  if (rhs.username_element < lhs.username_element)
    return false;
  if (lhs.username_value < rhs.username_value)
    return true;
  if (rhs.username_value < lhs.username_value)
    return false;
  if (lhs.password_element < rhs.password_element)
    return true;
  if (rhs.password_element < lhs.password_element)
    return false;
  if (lhs.password_value < rhs.password_value)
    return true;
  if (rhs.password_value < lhs.password_value)
    return false;
  if (lhs.blocked_by_user < rhs.blocked_by_user)
    return true;
  if (rhs.blocked_by_user < lhs.blocked_by_user)
    return false;
  return false;
}


}  // chrome::mojom

namespace mojo {


template <>
struct  StructTraits<::chrome::mojom::ImportedPasswordForm::DataView,
                                         ::chrome::mojom::ImportedPasswordFormPtr> {
  static bool IsNull(const ::chrome::mojom::ImportedPasswordFormPtr& input) { return !input; }
  static void SetToNull(::chrome::mojom::ImportedPasswordFormPtr* output) { output->reset(); }

  static decltype(::chrome::mojom::ImportedPasswordForm::scheme) scheme(
      const ::chrome::mojom::ImportedPasswordFormPtr& input) {
    return input->scheme;
  }

  static const decltype(::chrome::mojom::ImportedPasswordForm::signon_realm)& signon_realm(
      const ::chrome::mojom::ImportedPasswordFormPtr& input) {
    return input->signon_realm;
  }

  static const decltype(::chrome::mojom::ImportedPasswordForm::url)& url(
      const ::chrome::mojom::ImportedPasswordFormPtr& input) {
    return input->url;
  }

  static const decltype(::chrome::mojom::ImportedPasswordForm::action)& action(
      const ::chrome::mojom::ImportedPasswordFormPtr& input) {
    return input->action;
  }

  static const decltype(::chrome::mojom::ImportedPasswordForm::username_element)& username_element(
      const ::chrome::mojom::ImportedPasswordFormPtr& input) {
    return input->username_element;
  }

  static const decltype(::chrome::mojom::ImportedPasswordForm::username_value)& username_value(
      const ::chrome::mojom::ImportedPasswordFormPtr& input) {
    return input->username_value;
  }

  static const decltype(::chrome::mojom::ImportedPasswordForm::password_element)& password_element(
      const ::chrome::mojom::ImportedPasswordFormPtr& input) {
    return input->password_element;
  }

  static const decltype(::chrome::mojom::ImportedPasswordForm::password_value)& password_value(
      const ::chrome::mojom::ImportedPasswordFormPtr& input) {
    return input->password_value;
  }

  static decltype(::chrome::mojom::ImportedPasswordForm::blocked_by_user) blocked_by_user(
      const ::chrome::mojom::ImportedPasswordFormPtr& input) {
    return input->blocked_by_user;
  }

  static bool Read(::chrome::mojom::ImportedPasswordForm::DataView input, ::chrome::mojom::ImportedPasswordFormPtr* output);
};

}  // namespace mojo

#endif  // CHROME_COMMON_IMPORTER_PROFILE_IMPORT_MOJOM_H_