// chrome/common/google_accounts_private_api_extension.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_COMMON_GOOGLE_ACCOUNTS_PRIVATE_API_EXTENSION_MOJOM_H_
#define CHROME_COMMON_GOOGLE_ACCOUNTS_PRIVATE_API_EXTENSION_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/common/google_accounts_private_api_extension.mojom-features.h"  // IWYU pragma: export
#include "chrome/common/google_accounts_private_api_extension.mojom-shared.h"  // IWYU pragma: export
#include "chrome/common/google_accounts_private_api_extension.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace chrome::mojom {

class GoogleAccountsPrivateApiExtensionProxy;

template <typename ImplRefTraits>
class GoogleAccountsPrivateApiExtensionStub;

class GoogleAccountsPrivateApiExtensionRequestValidator;


class GoogleAccountsPrivateApiExtension
    : public GoogleAccountsPrivateApiExtensionInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "chrome.mojom.GoogleAccountsPrivateApiExtension";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = GoogleAccountsPrivateApiExtensionInterfaceBase;
  using Proxy_ = GoogleAccountsPrivateApiExtensionProxy;

  template <typename ImplRefTraits>
  using Stub_ = GoogleAccountsPrivateApiExtensionStub<ImplRefTraits>;

  using RequestValidator_ = GoogleAccountsPrivateApiExtensionRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kSetConsentResultMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SetConsentResult_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~GoogleAccountsPrivateApiExtension() = default;

  virtual void SetConsentResult(const std::string& consent_result) = 0;
};



class  GoogleAccountsPrivateApiExtensionProxy
    : public GoogleAccountsPrivateApiExtension {
 public:
  using InterfaceType = GoogleAccountsPrivateApiExtension;

  explicit GoogleAccountsPrivateApiExtensionProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetConsentResult(const std::string& consent_result) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  GoogleAccountsPrivateApiExtensionStubDispatch {
 public:
  static bool Accept(GoogleAccountsPrivateApiExtension* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      GoogleAccountsPrivateApiExtension* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<GoogleAccountsPrivateApiExtension>>
class GoogleAccountsPrivateApiExtensionStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  GoogleAccountsPrivateApiExtensionStub() = default;
  ~GoogleAccountsPrivateApiExtensionStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return GoogleAccountsPrivateApiExtensionStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return GoogleAccountsPrivateApiExtensionStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  GoogleAccountsPrivateApiExtensionRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // chrome::mojom

namespace mojo {

}  // namespace mojo

#endif  // CHROME_COMMON_GOOGLE_ACCOUNTS_PRIVATE_API_EXTENSION_MOJOM_H_