// chrome/common/actor_webui.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "chrome/common/actor_webui.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/common/actor_webui.mojom-params-data.h"
namespace actor {
namespace webui {
namespace mojom {

NOINLINE static const char* UserGrantedPermissionDurationToStringHelper(UserGrantedPermissionDuration value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case UserGrantedPermissionDuration::kOneTime:
      return "kOneTime";
    case UserGrantedPermissionDuration::kAlwaysAllow:
      return "kAlwaysAllow";
    default:
      return nullptr;
  }
}

std::string UserGrantedPermissionDurationToString(UserGrantedPermissionDuration value) {
  const char *str = UserGrantedPermissionDurationToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown UserGrantedPermissionDuration value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, UserGrantedPermissionDuration value) {
  return os << UserGrantedPermissionDurationToString(value);
}

NOINLINE static const char* SelectCredentialDialogErrorReasonToStringHelper(SelectCredentialDialogErrorReason value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case SelectCredentialDialogErrorReason::kDialogPromiseNoSubscriber:
      return "kDialogPromiseNoSubscriber";
    default:
      return nullptr;
  }
}

std::string SelectCredentialDialogErrorReasonToString(SelectCredentialDialogErrorReason value) {
  const char *str = SelectCredentialDialogErrorReasonToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown SelectCredentialDialogErrorReason value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, SelectCredentialDialogErrorReason value) {
  return os << SelectCredentialDialogErrorReasonToString(value);
}

NOINLINE static const char* UserConfirmationDialogErrorReasonToStringHelper(UserConfirmationDialogErrorReason value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case UserConfirmationDialogErrorReason::kDialogPromiseNoSubscriber:
      return "kDialogPromiseNoSubscriber";
    case UserConfirmationDialogErrorReason::kPreemptedByNewRequest:
      return "kPreemptedByNewRequest";
    default:
      return nullptr;
  }
}

std::string UserConfirmationDialogErrorReasonToString(UserConfirmationDialogErrorReason value) {
  const char *str = UserConfirmationDialogErrorReasonToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown UserConfirmationDialogErrorReason value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, UserConfirmationDialogErrorReason value) {
  return os << UserConfirmationDialogErrorReasonToString(value);
}

namespace internal {
// static
bool UserConfirmationDialogPayload_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const UserConfirmationDialogPayload_Data* object = static_cast<const UserConfirmationDialogPayload_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case UserConfirmationDialogPayload_Tag::kNavigationOrigin: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_navigation_origin, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_navigation_origin, validation_context))
        return false;
      return true;
    }
    case UserConfirmationDialogPayload_Tag::kDownloadId: {

      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in UserConfirmationDialogPayload");
      return false;
    }
  }
}
// static
bool UserConfirmationDialogResult_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const UserConfirmationDialogResult_Data* object = static_cast<const UserConfirmationDialogResult_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case UserConfirmationDialogResult_Tag::kPermissionGranted: {

      return true;
    }
    case UserConfirmationDialogResult_Tag::kErrorReason: {


      if (!::actor::webui::mojom::internal::UserConfirmationDialogErrorReason_Data
            ::Validate(object->data.f_error_reason, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in UserConfirmationDialogResult");
      return false;
    }
  }
}


// static
bool TaskOptions_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TaskOptions_Data* object =
      static_cast<const TaskOptions_Data*>(data);

  constexpr const mojo::internal::ContainerValidateParams& title_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->title, validation_context,
                                         &title_validate_params)) {
    return false;
  }

  return true;
}

TaskOptions_Data::TaskOptions_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Credential_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Credential_Data* object =
      static_cast<const Credential_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->username, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& username_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->username, validation_context,
                                         &username_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->source_site_or_app, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& source_site_or_app_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->source_site_or_app, validation_context,
                                         &source_site_or_app_validate_params)) {
    return false;
  }

  return true;
}

Credential_Data::Credential_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SelectCredentialDialogRequest_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SelectCredentialDialogRequest_Data* object =
      static_cast<const SelectCredentialDialogRequest_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->credentials, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& credentials_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->credentials, validation_context,
                                         &credentials_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->icons, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& icons_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->icons, validation_context,
                                         &icons_validate_params)) {
    return false;
  }

  return true;
}

SelectCredentialDialogRequest_Data::SelectCredentialDialogRequest_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SelectCredentialDialogResponse_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SelectCredentialDialogResponse_Data* object =
      static_cast<const SelectCredentialDialogResponse_Data*>(data);


  if (!::actor::webui::mojom::internal::SelectCredentialDialogErrorReason_Data
        ::Validate(object->error_reason_$value, validation_context))
    return false;


  if (!::actor::webui::mojom::internal::UserGrantedPermissionDuration_Data
        ::Validate(object->permission_duration_$value, validation_context))
    return false;

  return true;
}

SelectCredentialDialogResponse_Data::SelectCredentialDialogResponse_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UserConfirmationDialogRequest_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UserConfirmationDialogRequest_Data* object =
      static_cast<const UserConfirmationDialogRequest_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->payload, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->payload, validation_context))
    return false;

  return true;
}

UserConfirmationDialogRequest_Data::UserConfirmationDialogRequest_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UserConfirmationDialogResponse_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UserConfirmationDialogResponse_Data* object =
      static_cast<const UserConfirmationDialogResponse_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->result, validation_context))
    return false;

  return true;
}

UserConfirmationDialogResponse_Data::UserConfirmationDialogResponse_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace webui
}  // namespace actor

namespace perfetto {

// static
void TraceFormatTraits<::actor::webui::mojom::UserGrantedPermissionDuration>::WriteIntoTrace(
   perfetto::TracedValue context, ::actor::webui::mojom::UserGrantedPermissionDuration value) {
  return std::move(context).WriteString(::actor::webui::mojom::UserGrantedPermissionDurationToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::actor::webui::mojom::SelectCredentialDialogErrorReason>::WriteIntoTrace(
   perfetto::TracedValue context, ::actor::webui::mojom::SelectCredentialDialogErrorReason value) {
  return std::move(context).WriteString(::actor::webui::mojom::SelectCredentialDialogErrorReasonToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::actor::webui::mojom::UserConfirmationDialogErrorReason>::WriteIntoTrace(
   perfetto::TracedValue context, ::actor::webui::mojom::UserConfirmationDialogErrorReason value) {
  return std::move(context).WriteString(::actor::webui::mojom::UserConfirmationDialogErrorReasonToString(value));
}

} // namespace perfetto