// chrome/common/actor_webui.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_COMMON_ACTOR_WEBUI_MOJOM_SEND_VALIDATION_H_
#define CHROME_COMMON_ACTOR_WEBUI_MOJOM_SEND_VALIDATION_H_

#include "chrome/common/actor_webui.mojom-shared-internal.h"
#include "skia/public/mojom/bitmap.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"

#include "chrome/common/actor_webui.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::actor::webui::mojom::UserGrantedPermissionDuration, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::actor::webui::mojom::SelectCredentialDialogErrorReason, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::actor::webui::mojom::UserConfirmationDialogErrorReason, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::actor::webui::mojom::TaskOptionsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::actor::webui::mojom::TaskOptionsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::actor::webui::mojom::internal::TaskOptions_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::title(input)) in_title = Traits::title(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->title)::BaseType> title_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_title,
        title_fragment);

      fragment->title.Set(
          title_fragment.is_null() ? nullptr : title_fragment.data());
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::actor::webui::mojom::CredentialDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::actor::webui::mojom::CredentialDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::actor::webui::mojom::internal::Credential_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->id = Traits::id(input);

      decltype(Traits::username(input)) in_username = Traits::username(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->username)::BaseType> username_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_username,
        username_fragment);

      fragment->username.Set(
          username_fragment.is_null() ? nullptr : username_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->username.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null username in Credential struct");

      decltype(Traits::source_site_or_app(input)) in_source_site_or_app = Traits::source_site_or_app(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->source_site_or_app)::BaseType> source_site_or_app_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_source_site_or_app,
        source_site_or_app_fragment);

      fragment->source_site_or_app.Set(
          source_site_or_app_fragment.is_null() ? nullptr : source_site_or_app_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->source_site_or_app.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null source_site_or_app in Credential struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::actor::webui::mojom::SelectCredentialDialogRequestDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::actor::webui::mojom::SelectCredentialDialogRequestDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::actor::webui::mojom::internal::SelectCredentialDialogRequest_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->task_id = Traits::task_id(input);

      fragment->show_dialog = Traits::show_dialog(input);

      decltype(Traits::credentials(input)) in_credentials = Traits::credentials(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->credentials)::BaseType>
          credentials_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& credentials_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::actor::webui::mojom::CredentialDataView>, send_validation>(
        in_credentials,
        credentials_fragment,
        &credentials_validate_params);

      fragment->credentials.Set(
          credentials_fragment.is_null() ? nullptr : credentials_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->credentials.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null credentials in SelectCredentialDialogRequest struct");

      decltype(Traits::icons(input)) in_icons = Traits::icons(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->icons)::BaseType>
          icons_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& icons_validate_params =
          mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
      
      mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, ::skia::mojom::BitmapN32DataView>, send_validation>(
        in_icons,
        icons_fragment,
        &icons_validate_params);

      fragment->icons.Set(
          icons_fragment.is_null() ? nullptr : icons_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->icons.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null icons in SelectCredentialDialogRequest struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::actor::webui::mojom::SelectCredentialDialogResponseDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::actor::webui::mojom::SelectCredentialDialogResponseDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::actor::webui::mojom::internal::SelectCredentialDialogResponse_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->task_id = Traits::task_id(input);
      fragment->error_reason_$flag = Traits::error_reason(input).has_value();
      if (Traits::error_reason(input).has_value()) {
        
        mojo::internal::Serialize<::actor::webui::mojom::SelectCredentialDialogErrorReason>(
          Traits::error_reason(input).value(),
          &fragment->error_reason_$value);
      } else {
        fragment->error_reason_$value =
            static_cast<int32_t>(::actor::webui::mojom::SelectCredentialDialogErrorReason::kMinValue);
      }
      fragment->permission_duration_$flag = Traits::permission_duration(input).has_value();
      if (Traits::permission_duration(input).has_value()) {
        
        mojo::internal::Serialize<::actor::webui::mojom::UserGrantedPermissionDuration>(
          Traits::permission_duration(input).value(),
          &fragment->permission_duration_$value);
      } else {
        fragment->permission_duration_$value =
            static_cast<int32_t>(::actor::webui::mojom::UserGrantedPermissionDuration::kMinValue);
      }
      fragment->selected_credential_id_$flag = Traits::selected_credential_id(input).has_value();
      if (Traits::selected_credential_id(input).has_value()) {
        fragment->selected_credential_id_$value = Traits::selected_credential_id(input).value();
      }
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::actor::webui::mojom::UserConfirmationDialogRequestDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::actor::webui::mojom::UserConfirmationDialogRequestDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::actor::webui::mojom::internal::UserConfirmationDialogRequest_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::payload(input)) in_payload = Traits::payload(input);
      mojo::internal::MessageFragment<decltype(fragment->payload)>
          payload_fragment(fragment.message());
      payload_fragment.Claim(&fragment->payload);
      
      mojo::internal::Serialize<::actor::webui::mojom::UserConfirmationDialogPayloadDataView, send_validation>(
        in_payload,
        payload_fragment,
        true);

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->payload.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null payload in UserConfirmationDialogRequest struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::actor::webui::mojom::UserConfirmationDialogResponseDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::actor::webui::mojom::UserConfirmationDialogResponseDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::actor::webui::mojom::internal::UserConfirmationDialogResponse_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::result(input)) in_result = Traits::result(input);
      mojo::internal::MessageFragment<decltype(fragment->result)>
          result_fragment(fragment.message());
      result_fragment.Claim(&fragment->result);
      
      mojo::internal::Serialize<::actor::webui::mojom::UserConfirmationDialogResultDataView, send_validation>(
        in_result,
        result_fragment,
        true);

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->result.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null result in UserConfirmationDialogResponse struct");
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::actor::webui::mojom::UserConfirmationDialogPayloadDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::actor::webui::mojom::UserConfirmationDialogPayloadDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::actor::webui::mojom::internal::UserConfirmationDialogPayload_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::actor::webui::mojom::UserConfirmationDialogPayloadDataView::Tag::kNavigationOrigin: {
    decltype(Traits::navigation_origin(input))
    in_navigation_origin = Traits::navigation_origin(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_navigation_origin)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::url::mojom::OriginDataView, send_validation>(
  in_navigation_origin,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null navigation_origin in UserConfirmationDialogPayload union");
    fragment->data.f_navigation_origin.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::actor::webui::mojom::UserConfirmationDialogPayloadDataView::Tag::kDownloadId: {
    decltype(Traits::download_id(input))
    in_download_id = Traits::download_id(input);
    fragment->data.f_download_id = in_download_id;
    break;
  }
}
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::actor::webui::mojom::UserConfirmationDialogResultDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::actor::webui::mojom::UserConfirmationDialogResultDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::actor::webui::mojom::internal::UserConfirmationDialogResult_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::actor::webui::mojom::UserConfirmationDialogResultDataView::Tag::kPermissionGranted: {
    decltype(Traits::permission_granted(input))
    in_permission_granted = Traits::permission_granted(input);
    fragment->data.f_permission_granted = in_permission_granted;
    break;
  }
  case ::actor::webui::mojom::UserConfirmationDialogResultDataView::Tag::kErrorReason: {
    decltype(Traits::error_reason(input))
    in_error_reason = Traits::error_reason(input);
        
mojo::internal::Serialize<::actor::webui::mojom::UserConfirmationDialogErrorReason, send_validation>(
  in_error_reason,
  &fragment->data.f_error_reason);
    break;
  }
}
  }
};

}  // namespace mojo::internal

#endif  // CHROME_COMMON_ACTOR_WEBUI_MOJOM_SEND_VALIDATION_H_