// chrome/common/actor_webui.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_COMMON_ACTOR_WEBUI_MOJOM_DATA_VIEW_H_
#define CHROME_COMMON_ACTOR_WEBUI_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "chrome/common/actor_webui.mojom-shared-internal.h"
#include "skia/public/mojom/bitmap.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"


namespace actor::webui::mojom {
class TaskOptionsDataView;

class CredentialDataView;

class SelectCredentialDialogRequestDataView;

class SelectCredentialDialogResponseDataView;

class UserConfirmationDialogRequestDataView;

class UserConfirmationDialogResponseDataView;

class UserConfirmationDialogPayloadDataView;
class UserConfirmationDialogResultDataView;


}  // actor::webui::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::actor::webui::mojom::TaskOptionsDataView> {
  using Data = ::actor::webui::mojom::internal::TaskOptions_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::actor::webui::mojom::CredentialDataView> {
  using Data = ::actor::webui::mojom::internal::Credential_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::actor::webui::mojom::SelectCredentialDialogRequestDataView> {
  using Data = ::actor::webui::mojom::internal::SelectCredentialDialogRequest_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::actor::webui::mojom::SelectCredentialDialogResponseDataView> {
  using Data = ::actor::webui::mojom::internal::SelectCredentialDialogResponse_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::actor::webui::mojom::UserConfirmationDialogRequestDataView> {
  using Data = ::actor::webui::mojom::internal::UserConfirmationDialogRequest_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::actor::webui::mojom::UserConfirmationDialogResponseDataView> {
  using Data = ::actor::webui::mojom::internal::UserConfirmationDialogResponse_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::actor::webui::mojom::UserConfirmationDialogPayloadDataView> {
  using Data = ::actor::webui::mojom::internal::UserConfirmationDialogPayload_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::actor::webui::mojom::UserConfirmationDialogResultDataView> {
  using Data = ::actor::webui::mojom::internal::UserConfirmationDialogResult_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace actor::webui::mojom {


enum class UserGrantedPermissionDuration : int32_t {
  
  kOneTime = 0,
  
  kAlwaysAllow = 1,
  kMinValue = 0,
  kMaxValue = 1,
  kDefaultValue = 0
};

 std::ostream& operator<<(std::ostream& os, UserGrantedPermissionDuration value);
inline bool IsKnownEnumValue(UserGrantedPermissionDuration value) {
  return internal::UserGrantedPermissionDuration_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
inline UserGrantedPermissionDuration ToKnownEnumValue(UserGrantedPermissionDuration value) {
  if (IsKnownEnumValue(value)) {
    return value;
  }
  return UserGrantedPermissionDuration::kDefaultValue;
}


enum class SelectCredentialDialogErrorReason : int32_t {
  
  kDialogPromiseNoSubscriber = 0,
  kMinValue = 0,
  kMaxValue = 0,
  kDefaultValue = 0
};

 std::ostream& operator<<(std::ostream& os, SelectCredentialDialogErrorReason value);
inline bool IsKnownEnumValue(SelectCredentialDialogErrorReason value) {
  return internal::SelectCredentialDialogErrorReason_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
inline SelectCredentialDialogErrorReason ToKnownEnumValue(SelectCredentialDialogErrorReason value) {
  if (IsKnownEnumValue(value)) {
    return value;
  }
  return SelectCredentialDialogErrorReason::kDefaultValue;
}


enum class UserConfirmationDialogErrorReason : int32_t {
  
  kDialogPromiseNoSubscriber = 0,
  
  kPreemptedByNewRequest = 1,
  kMinValue = 0,
  kMaxValue = 1,
  kDefaultValue = 0
};

 std::ostream& operator<<(std::ostream& os, UserConfirmationDialogErrorReason value);
inline bool IsKnownEnumValue(UserConfirmationDialogErrorReason value) {
  return internal::UserConfirmationDialogErrorReason_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
inline UserConfirmationDialogErrorReason ToKnownEnumValue(UserConfirmationDialogErrorReason value) {
  if (IsKnownEnumValue(value)) {
    return value;
  }
  return UserConfirmationDialogErrorReason::kDefaultValue;
}


class TaskOptionsDataView {
 public:
  TaskOptionsDataView() = default;

  TaskOptionsDataView(
      internal::TaskOptions_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTitleDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTitle(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `title` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTitle` instead "
    "of `ReadTitle if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->title.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::TaskOptions_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CredentialDataView {
 public:
  CredentialDataView() = default;

  CredentialDataView(
      internal::Credential_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t id() const {
    return data_->id;
  }
  inline void GetUsernameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUsername(UserType* output) {
    
    auto* pointer = data_->username.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetSourceSiteOrAppDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSourceSiteOrApp(UserType* output) {
    
    auto* pointer = data_->source_site_or_app.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::Credential_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SelectCredentialDialogRequestDataView {
 public:
  SelectCredentialDialogRequestDataView() = default;

  SelectCredentialDialogRequestDataView(
      internal::SelectCredentialDialogRequest_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t task_id() const {
    return data_->task_id;
  }
  bool show_dialog() const {
    return data_->show_dialog;
  }
  inline void GetCredentialsDataView(
      mojo::ArrayDataView<CredentialDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCredentials(UserType* output) {
    
    auto* pointer = data_->credentials.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::actor::webui::mojom::CredentialDataView>>(
        pointer, output, message_);
  }
  inline void GetIconsDataView(
      mojo::MapDataView<mojo::StringDataView, ::skia::mojom::BitmapN32DataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIcons(UserType* output) {
    
    auto* pointer = data_->icons.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<mojo::StringDataView, ::skia::mojom::BitmapN32DataView>>(
        pointer, output, message_);
  }
 private:
  internal::SelectCredentialDialogRequest_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SelectCredentialDialogResponseDataView {
 public:
  SelectCredentialDialogResponseDataView() = default;

  SelectCredentialDialogResponseDataView(
      internal::SelectCredentialDialogResponse_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int32_t task_id() const {
    return data_->task_id;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadErrorReason(UserType* output) const {
    if (!data_->error_reason_$flag) {
      *output = std::nullopt;
      return true;
    }

    return mojo::internal::Deserialize<::actor::webui::mojom::SelectCredentialDialogErrorReason>(
        data_->error_reason_$value, &output->emplace());
  }
  std::optional<SelectCredentialDialogErrorReason> error_reason() const {
    if (!data_->error_reason_$flag) {
      return std::nullopt;
    }
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::actor::webui::mojom::SelectCredentialDialogErrorReason>(data_->error_reason_$value));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadPermissionDuration(UserType* output) const {
    if (!data_->permission_duration_$flag) {
      *output = std::nullopt;
      return true;
    }

    return mojo::internal::Deserialize<::actor::webui::mojom::UserGrantedPermissionDuration>(
        data_->permission_duration_$value, &output->emplace());
  }
  std::optional<UserGrantedPermissionDuration> permission_duration() const {
    if (!data_->permission_duration_$flag) {
      return std::nullopt;
    }
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::actor::webui::mojom::UserGrantedPermissionDuration>(data_->permission_duration_$value));
  }
  std::optional<int32_t> selected_credential_id() const {

    return data_->selected_credential_id_$flag
        ? std::make_optional(data_->selected_credential_id_$value)
        : std::nullopt;
  }
 private:
  internal::SelectCredentialDialogResponse_Data* data_ = nullptr;
};


class UserConfirmationDialogRequestDataView {
 public:
  UserConfirmationDialogRequestDataView() = default;

  UserConfirmationDialogRequestDataView(
      internal::UserConfirmationDialogRequest_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPayloadDataView(
      UserConfirmationDialogPayloadDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPayload(UserType* output) {
    
    auto* pointer = !data_->payload.is_null() ? &data_->payload : nullptr;
    return mojo::internal::Deserialize<::actor::webui::mojom::UserConfirmationDialogPayloadDataView>(
        pointer, output, message_);
  }
 private:
  internal::UserConfirmationDialogRequest_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class UserConfirmationDialogResponseDataView {
 public:
  UserConfirmationDialogResponseDataView() = default;

  UserConfirmationDialogResponseDataView(
      internal::UserConfirmationDialogResponse_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetResultDataView(
      UserConfirmationDialogResultDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadResult(UserType* output) {
    
    auto* pointer = !data_->result.is_null() ? &data_->result : nullptr;
    return mojo::internal::Deserialize<::actor::webui::mojom::UserConfirmationDialogResultDataView>(
        pointer, output, message_);
  }
 private:
  internal::UserConfirmationDialogResponse_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class UserConfirmationDialogPayloadDataView {
 public:
  using Tag = internal::UserConfirmationDialogPayload_Data::UserConfirmationDialogPayload_Tag;

  UserConfirmationDialogPayloadDataView() = default;

  UserConfirmationDialogPayloadDataView(
      internal::UserConfirmationDialogPayload_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_navigation_origin() const { return data_->tag == Tag::kNavigationOrigin; }
  inline void GetNavigationOriginDataView(
      ::url::mojom::OriginDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadNavigationOrigin(UserType* output) const {
    
    CHECK(is_navigation_origin());
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        data_->data.f_navigation_origin.Get(), output, message_);
  }
  bool is_download_id() const { return data_->tag == Tag::kDownloadId; }
  int32_t download_id() const {
    CHECK(is_download_id());
    return data_->data.f_download_id;
  }

 private:
  internal::UserConfirmationDialogPayload_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class UserConfirmationDialogResultDataView {
 public:
  using Tag = internal::UserConfirmationDialogResult_Data::UserConfirmationDialogResult_Tag;

  UserConfirmationDialogResultDataView() = default;

  UserConfirmationDialogResultDataView(
      internal::UserConfirmationDialogResult_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_permission_granted() const { return data_->tag == Tag::kPermissionGranted; }
  bool permission_granted() const {
    CHECK(is_permission_granted());
    return data_->data.f_permission_granted;
  }
  bool is_error_reason() const { return data_->tag == Tag::kErrorReason; }
  template <typename UserType>
  [[nodiscard]] bool ReadErrorReason(UserType* output) const {
    CHECK(is_error_reason());
    return mojo::internal::Deserialize<::actor::webui::mojom::UserConfirmationDialogErrorReason>(
        data_->data.f_error_reason, output);
  }
  UserConfirmationDialogErrorReason error_reason() const {
    CHECK(is_error_reason());
    // TODO(dcheng): This seems incorrect, as it bypasses enum traits.
    return ::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::actor::webui::mojom::UserConfirmationDialogErrorReason>(data_->data.f_error_reason));
  }

 private:
  internal::UserConfirmationDialogResult_Data* data_ = nullptr;
};



}  // actor::webui::mojom

#endif  // CHROME_COMMON_ACTOR_WEBUI_MOJOM_DATA_VIEW_H_