// chrome/browser/ui/webui_browser/browser.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_BROWSER_BROWSER_MOJOM_H_
#define CHROME_BROWSER_UI_WEBUI_BROWSER_BROWSER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/browser/ui/webui_browser/browser.mojom-features.h"  // IWYU pragma: export
#include "chrome/browser/ui/webui_browser/browser.mojom-shared.h"  // IWYU pragma: export
#include "chrome/browser/ui/webui_browser/browser.mojom-forward.h"  // IWYU pragma: export
#include "chrome/browser/ui/tabs/tab_strip_api/tab_strip_api_types.mojom.h"
#include "mojo/public/mojom/base/values.mojom-forward.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace webui_browser::mojom {

class PageHandlerFactoryProxy;

template <typename ImplRefTraits>
class PageHandlerFactoryStub;

class PageHandlerFactoryRequestValidator;


class PageHandlerFactory
    : public PageHandlerFactoryInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "webui_browser.mojom.PageHandlerFactory";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PageHandlerFactoryInterfaceBase;
  using Proxy_ = PageHandlerFactoryProxy;

  template <typename ImplRefTraits>
  using Stub_ = PageHandlerFactoryStub<ImplRefTraits>;

  using RequestValidator_ = PageHandlerFactoryRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kCreatePageHandlerMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CreatePageHandler_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PageHandlerFactory() = default;

  virtual void CreatePageHandler(::mojo::PendingRemote<Page> page, ::mojo::PendingReceiver<PageHandler> handler) = 0;
};

class PageProxy;

template <typename ImplRefTraits>
class PageStub;

class PageRequestValidator;


class Page
    : public PageInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "webui_browser.mojom.Page";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PageInterfaceBase;
  using Proxy_ = PageProxy;

  template <typename ImplRefTraits>
  using Stub_ = PageStub<ImplRefTraits>;

  using RequestValidator_ = PageRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kSetFocusToLocationBarMinVersion = 0,
    kSetReloadStopStateMinVersion = 0,
    kShowSidePanelMinVersion = 0,
    kCloseSidePanelMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SetFocusToLocationBar_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetReloadStopState_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ShowSidePanel_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CloseSidePanel_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~Page() = default;

  virtual void SetFocusToLocationBar(bool is_user_initiated) = 0;

  virtual void SetReloadStopState(bool is_loading) = 0;

  virtual void ShowSidePanel(int32_t guest_contents_id, const std::string& title) = 0;

  virtual void CloseSidePanel() = 0;
};

class PageHandlerProxy;

template <typename ImplRefTraits>
class PageHandlerStub;

class PageHandlerRequestValidator;
class PageHandlerResponseValidator;


class PageHandler
    : public PageHandlerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "webui_browser.mojom.PageHandler";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PageHandlerInterfaceBase;
  using Proxy_ = PageHandlerProxy;

  template <typename ImplRefTraits>
  using Stub_ = PageHandlerStub<ImplRefTraits>;

  using RequestValidator_ = PageHandlerRequestValidator;
  using ResponseValidator_ = PageHandlerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetGuestIdForTabIdMinVersion = 0,
    kLoadTabSearchMinVersion = 0,
    kShowTabSearchBubbleMinVersion = 0,
    kOpenAppMenuMinVersion = 0,
    kOpenProfileMenuMinVersion = 0,
    kLaunchDevToolsForBrowserMinVersion = 0,
    kOnSidePanelClosedMinVersion = 0,
    kMinimizeMinVersion = 0,
    kMaximizeMinVersion = 0,
    kRestoreMinVersion = 0,
    kCloseMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GetGuestIdForTabId_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct LoadTabSearch_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ShowTabSearchBubble_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OpenAppMenu_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OpenProfileMenu_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct LaunchDevToolsForBrowser_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnSidePanelClosed_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Minimize_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Maximize_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Restore_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Close_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PageHandler() = default;

  using GetGuestIdForTabIdCallback = base::OnceCallback<void(int32_t)>;
  using GetGuestIdForTabIdMojoCallback = base::OnceCallback<void(int32_t)>;

  virtual void GetGuestIdForTabId(const ::tabs_api::NodeId& tab_id, ::mojo::PendingReceiver<GuestHandler> handler, GetGuestIdForTabIdCallback callback) = 0;

  using LoadTabSearchCallback = base::OnceCallback<void(int32_t)>;
  using LoadTabSearchMojoCallback = base::OnceCallback<void(int32_t)>;

  virtual void LoadTabSearch(LoadTabSearchCallback callback) = 0;

  virtual void ShowTabSearchBubble(const std::string& anchor_name) = 0;

  virtual void OpenAppMenu() = 0;

  virtual void OpenProfileMenu() = 0;

  virtual void LaunchDevToolsForBrowser() = 0;

  virtual void OnSidePanelClosed() = 0;

  virtual void Minimize() = 0;

  virtual void Maximize() = 0;

  virtual void Restore() = 0;

  virtual void Close() = 0;
};

class GuestHandlerProxy;

template <typename ImplRefTraits>
class GuestHandlerStub;

class GuestHandlerRequestValidator;
class GuestHandlerResponseValidator;


class GuestHandler
    : public GuestHandlerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "webui_browser.mojom.GuestHandler";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = GuestHandlerInterfaceBase;
  using Proxy_ = GuestHandlerProxy;

  template <typename ImplRefTraits>
  using Stub_ = GuestHandlerStub<ImplRefTraits>;

  using RequestValidator_ = GuestHandlerRequestValidator;
  using ResponseValidator_ = GuestHandlerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kNavigateMinVersion = 0,
    kCanGoBackMinVersion = 0,
    kGoBackMinVersion = 0,
    kCanGoForwardMinVersion = 0,
    kGoForwardMinVersion = 0,
    kReloadMinVersion = 0,
    kStopLoadingMinVersion = 0,
    kOpenPageInfoMenuMinVersion = 0,
    kGetSecurityIconMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Navigate_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CanGoBack_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GoBack_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CanGoForward_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GoForward_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Reload_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct StopLoading_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OpenPageInfoMenu_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetSecurityIcon_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~GuestHandler() = default;

  virtual void Navigate(const ::GURL& src) = 0;

  using CanGoBackCallback = base::OnceCallback<void(bool)>;
  using CanGoBackMojoCallback = base::OnceCallback<void(bool)>;

  virtual void CanGoBack(CanGoBackCallback callback) = 0;

  virtual void GoBack() = 0;

  using CanGoForwardCallback = base::OnceCallback<void(bool)>;
  using CanGoForwardMojoCallback = base::OnceCallback<void(bool)>;

  virtual void CanGoForward(CanGoForwardCallback callback) = 0;

  virtual void GoForward() = 0;

  virtual void Reload() = 0;

  virtual void StopLoading() = 0;

  virtual void OpenPageInfoMenu() = 0;

  using GetSecurityIconCallback = base::OnceCallback<void(SecurityIcon)>;
  using GetSecurityIconMojoCallback = base::OnceCallback<void(SecurityIcon)>;

  virtual void GetSecurityIcon(GetSecurityIconCallback callback) = 0;
};



class  PageHandlerFactoryProxy
    : public PageHandlerFactory {
 public:
  using InterfaceType = PageHandlerFactory;

  explicit PageHandlerFactoryProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreatePageHandler(::mojo::PendingRemote<Page> page, ::mojo::PendingReceiver<PageHandler> handler) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  PageProxy
    : public Page {
 public:
  using InterfaceType = Page;

  explicit PageProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetFocusToLocationBar(bool is_user_initiated) final;
  
  void SetReloadStopState(bool is_loading) final;
  
  void ShowSidePanel(int32_t guest_contents_id, const std::string& title) final;
  
  void CloseSidePanel() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  PageHandlerProxy
    : public PageHandler {
 public:
  using InterfaceType = PageHandler;

  explicit PageHandlerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetGuestIdForTabId(const ::tabs_api::NodeId& tab_id, ::mojo::PendingReceiver<GuestHandler> handler, GetGuestIdForTabIdCallback callback) final;
  
  void LoadTabSearch(LoadTabSearchCallback callback) final;
  
  void ShowTabSearchBubble(const std::string& anchor_name) final;
  
  void OpenAppMenu() final;
  
  void OpenProfileMenu() final;
  
  void LaunchDevToolsForBrowser() final;
  
  void OnSidePanelClosed() final;
  
  void Minimize() final;
  
  void Maximize() final;
  
  void Restore() final;
  
  void Close() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  GuestHandlerProxy
    : public GuestHandler {
 public:
  using InterfaceType = GuestHandler;

  explicit GuestHandlerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Navigate(const ::GURL& src) final;
  
  void CanGoBack(CanGoBackCallback callback) final;
  
  void GoBack() final;
  
  void CanGoForward(CanGoForwardCallback callback) final;
  
  void GoForward() final;
  
  void Reload() final;
  
  void StopLoading() final;
  
  void OpenPageInfoMenu() final;
  
  void GetSecurityIcon(GetSecurityIconCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  PageHandlerFactoryStubDispatch {
 public:
  static bool Accept(PageHandlerFactory* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PageHandlerFactory* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PageHandlerFactory>>
class PageHandlerFactoryStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PageHandlerFactoryStub() = default;
  ~PageHandlerFactoryStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerFactoryStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerFactoryStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PageStubDispatch {
 public:
  static bool Accept(Page* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      Page* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<Page>>
class PageStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PageStub() = default;
  ~PageStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PageHandlerStubDispatch {
 public:
  static bool Accept(PageHandler* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PageHandler* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PageHandler>>
class PageHandlerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PageHandlerStub() = default;
  ~PageHandlerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  GuestHandlerStubDispatch {
 public:
  static bool Accept(GuestHandler* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      GuestHandler* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<GuestHandler>>
class GuestHandlerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  GuestHandlerStub() = default;
  ~GuestHandlerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return GuestHandlerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return GuestHandlerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PageHandlerFactoryRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PageRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PageHandlerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  GuestHandlerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PageHandlerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  GuestHandlerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // webui_browser::mojom

namespace mojo {

}  // namespace mojo

#endif  // CHROME_BROWSER_UI_WEBUI_BROWSER_BROWSER_MOJOM_H_