// chrome/browser/ui/webui_browser/bookmark_bar.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_BROWSER_BOOKMARK_BAR_MOJOM_SHARED_H_
#define CHROME_BROWSER_UI_WEBUI_BROWSER_BOOKMARK_BAR_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/browser/ui/webui_browser/bookmark_bar.mojom-shared-internal.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "chrome/browser/ui/webui_browser/bookmark_bar.mojom-data-view.h"




namespace std {

template <>
struct hash<::bookmark_bar::mojom::BookmarkType>
    : public mojo::internal::EnumHashImpl<::bookmark_bar::mojom::BookmarkType> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::bookmark_bar::mojom::BookmarkType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::bookmark_bar::mojom::BookmarkType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::bookmark_bar::mojom::BookmarkType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::bookmark_bar::mojom::BookmarkDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::bookmark_bar::mojom::BookmarkDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::bookmark_bar::mojom::internal::BookmarkData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->id = Traits::id(input);

    decltype(Traits::title(input)) in_title = Traits::title(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->title)::BaseType> title_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_title,
      title_fragment);

    fragment->title.Set(
        title_fragment.is_null() ? nullptr : title_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->title.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null title in BookmarkData struct");

    
    mojo::internal::Serialize<::bookmark_bar::mojom::BookmarkType>(
      Traits::type(input),
      &fragment->type);

    decltype(Traits::page_url_for_favicon(input)) in_page_url_for_favicon = Traits::page_url_for_favicon(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->page_url_for_favicon)::BaseType> page_url_for_favicon_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_page_url_for_favicon,
      page_url_for_favicon_fragment);

    fragment->page_url_for_favicon.Set(
        page_url_for_favicon_fragment.is_null() ? nullptr : page_url_for_favicon_fragment.data());
  }

  static bool Deserialize(::bookmark_bar::mojom::internal::BookmarkData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::bookmark_bar::mojom::BookmarkDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace bookmark_bar::mojom {

inline void BookmarkDataDataView::GetTitleDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->title.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void BookmarkDataDataView::GetPageUrlForFaviconDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->page_url_for_favicon.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}



}  // bookmark_bar::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::bookmark_bar::mojom::BookmarkType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::bookmark_bar::mojom::BookmarkType value);
};

} // namespace perfetto

#endif  // CHROME_BROWSER_UI_WEBUI_BROWSER_BOOKMARK_BAR_MOJOM_SHARED_H_