// chrome/browser/ui/webui/web_app_internals/web_app_internals.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "chrome/browser/ui/webui/web_app_internals/web_app_internals.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/browser/ui/webui/web_app_internals/web_app_internals.mojom-params-data.h"
namespace mojom {

namespace internal {
// static
bool InstallIsolatedWebAppResult_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const InstallIsolatedWebAppResult_Data* object = static_cast<const InstallIsolatedWebAppResult_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case InstallIsolatedWebAppResult_Tag::kSuccess: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_success, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_success, validation_context))
        return false;
      return true;
    }
    case InstallIsolatedWebAppResult_Tag::kError: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_error, 2, validation_context)) {
        return false;
      }
      constexpr const mojo::internal::ContainerValidateParams& error_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      if (!mojo::internal::ValidateContainer(object->data.f_error, validation_context,
                                             &error_validate_params)) {
        return false;
      }
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in InstallIsolatedWebAppResult");
      return false;
    }
  }
}
// static
bool IwaDevModeLocation_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const IwaDevModeLocation_Data* object = static_cast<const IwaDevModeLocation_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case IwaDevModeLocation_Tag::kProxyOrigin: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_proxy_origin, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_proxy_origin, validation_context))
        return false;
      return true;
    }
    case IwaDevModeLocation_Tag::kBundlePath: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_bundle_path, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_bundle_path, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in IwaDevModeLocation");
      return false;
    }
  }
}
// static
bool ParseUpdateManifestFromUrlResult_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const ParseUpdateManifestFromUrlResult_Data* object = static_cast<const ParseUpdateManifestFromUrlResult_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case ParseUpdateManifestFromUrlResult_Tag::kUpdateManifest: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_update_manifest, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_update_manifest, validation_context))
        return false;
      return true;
    }
    case ParseUpdateManifestFromUrlResult_Tag::kError: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_error, 2, validation_context)) {
        return false;
      }
      constexpr const mojo::internal::ContainerValidateParams& error_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      if (!mojo::internal::ValidateContainer(object->data.f_error, validation_context,
                                             &error_validate_params)) {
        return false;
      }
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in ParseUpdateManifestFromUrlResult");
      return false;
    }
  }
}


// static
bool InstallIsolatedWebAppSuccess_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const InstallIsolatedWebAppSuccess_Data* object =
      static_cast<const InstallIsolatedWebAppSuccess_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->web_bundle_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& web_bundle_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->web_bundle_id, validation_context,
                                         &web_bundle_id_validate_params)) {
    return false;
  }

  return true;
}

InstallIsolatedWebAppSuccess_Data::InstallIsolatedWebAppSuccess_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UpdateInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UpdateInfo_Data* object =
      static_cast<const UpdateInfo_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->update_manifest_url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->update_manifest_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->update_channel, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& update_channel_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->update_channel, validation_context,
                                         &update_channel_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& pinned_version_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->pinned_version, validation_context,
                                         &pinned_version_validate_params)) {
    return false;
  }

  return true;
}

UpdateInfo_Data::UpdateInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IwaDevModeAppInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const IwaDevModeAppInfo_Data* object =
      static_cast<const IwaDevModeAppInfo_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->app_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& app_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->app_id, validation_context,
                                         &app_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->name, validation_context,
                                         &name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->location, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->location, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->installed_version, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& installed_version_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->installed_version, validation_context,
                                         &installed_version_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->update_info, validation_context))
    return false;

  return true;
}

IwaDevModeAppInfo_Data::IwaDevModeAppInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VersionEntry_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VersionEntry_Data* object =
      static_cast<const VersionEntry_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->version, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& version_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->version, validation_context,
                                         &version_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->web_bundle_url, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->web_bundle_url, validation_context))
    return false;

  return true;
}

VersionEntry_Data::VersionEntry_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UpdateManifest_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UpdateManifest_Data* object =
      static_cast<const UpdateManifest_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->versions, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& versions_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->versions, validation_context,
                                         &versions_validate_params)) {
    return false;
  }

  return true;
}

UpdateManifest_Data::UpdateManifest_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool InstallFromBundleUrlParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const InstallFromBundleUrlParams_Data* object =
      static_cast<const InstallFromBundleUrlParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->web_bundle_url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->web_bundle_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->update_info, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->update_info, validation_context))
    return false;

  return true;
}

InstallFromBundleUrlParams_Data::InstallFromBundleUrlParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebAppInternalsHandler_GetDebugInfoAsJsonString_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebAppInternalsHandler_GetDebugInfoAsJsonString_Params_Data* object =
      static_cast<const WebAppInternalsHandler_GetDebugInfoAsJsonString_Params_Data*>(data);

  return true;
}

WebAppInternalsHandler_GetDebugInfoAsJsonString_Params_Data::WebAppInternalsHandler_GetDebugInfoAsJsonString_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebAppInternalsHandler_GetDebugInfoAsJsonString_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebAppInternalsHandler_GetDebugInfoAsJsonString_ResponseParams_Data* object =
      static_cast<const WebAppInternalsHandler_GetDebugInfoAsJsonString_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& result_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->result, validation_context,
                                         &result_validate_params)) {
    return false;
  }

  return true;
}

WebAppInternalsHandler_GetDebugInfoAsJsonString_ResponseParams_Data::WebAppInternalsHandler_GetDebugInfoAsJsonString_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebAppInternalsHandler_InstallIsolatedWebAppFromDevProxy_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebAppInternalsHandler_InstallIsolatedWebAppFromDevProxy_Params_Data* object =
      static_cast<const WebAppInternalsHandler_InstallIsolatedWebAppFromDevProxy_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  return true;
}

WebAppInternalsHandler_InstallIsolatedWebAppFromDevProxy_Params_Data::WebAppInternalsHandler_InstallIsolatedWebAppFromDevProxy_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebAppInternalsHandler_InstallIsolatedWebAppFromDevProxy_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebAppInternalsHandler_InstallIsolatedWebAppFromDevProxy_ResponseParams_Data* object =
      static_cast<const WebAppInternalsHandler_InstallIsolatedWebAppFromDevProxy_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->result, validation_context))
    return false;

  return true;
}

WebAppInternalsHandler_InstallIsolatedWebAppFromDevProxy_ResponseParams_Data::WebAppInternalsHandler_InstallIsolatedWebAppFromDevProxy_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebAppInternalsHandler_SelectFileAndInstallIsolatedWebAppFromDevBundle_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebAppInternalsHandler_SelectFileAndInstallIsolatedWebAppFromDevBundle_Params_Data* object =
      static_cast<const WebAppInternalsHandler_SelectFileAndInstallIsolatedWebAppFromDevBundle_Params_Data*>(data);

  return true;
}

WebAppInternalsHandler_SelectFileAndInstallIsolatedWebAppFromDevBundle_Params_Data::WebAppInternalsHandler_SelectFileAndInstallIsolatedWebAppFromDevBundle_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebAppInternalsHandler_SelectFileAndInstallIsolatedWebAppFromDevBundle_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebAppInternalsHandler_SelectFileAndInstallIsolatedWebAppFromDevBundle_ResponseParams_Data* object =
      static_cast<const WebAppInternalsHandler_SelectFileAndInstallIsolatedWebAppFromDevBundle_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->result, validation_context))
    return false;

  return true;
}

WebAppInternalsHandler_SelectFileAndInstallIsolatedWebAppFromDevBundle_ResponseParams_Data::WebAppInternalsHandler_SelectFileAndInstallIsolatedWebAppFromDevBundle_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebAppInternalsHandler_ParseUpdateManifestFromUrl_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebAppInternalsHandler_ParseUpdateManifestFromUrl_Params_Data* object =
      static_cast<const WebAppInternalsHandler_ParseUpdateManifestFromUrl_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->update_manifest_url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->update_manifest_url, validation_context))
    return false;

  return true;
}

WebAppInternalsHandler_ParseUpdateManifestFromUrl_Params_Data::WebAppInternalsHandler_ParseUpdateManifestFromUrl_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebAppInternalsHandler_ParseUpdateManifestFromUrl_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebAppInternalsHandler_ParseUpdateManifestFromUrl_ResponseParams_Data* object =
      static_cast<const WebAppInternalsHandler_ParseUpdateManifestFromUrl_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->result, validation_context))
    return false;

  return true;
}

WebAppInternalsHandler_ParseUpdateManifestFromUrl_ResponseParams_Data::WebAppInternalsHandler_ParseUpdateManifestFromUrl_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebAppInternalsHandler_InstallIsolatedWebAppFromBundleUrl_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebAppInternalsHandler_InstallIsolatedWebAppFromBundleUrl_Params_Data* object =
      static_cast<const WebAppInternalsHandler_InstallIsolatedWebAppFromBundleUrl_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->params, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->params, validation_context))
    return false;

  return true;
}

WebAppInternalsHandler_InstallIsolatedWebAppFromBundleUrl_Params_Data::WebAppInternalsHandler_InstallIsolatedWebAppFromBundleUrl_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebAppInternalsHandler_InstallIsolatedWebAppFromBundleUrl_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebAppInternalsHandler_InstallIsolatedWebAppFromBundleUrl_ResponseParams_Data* object =
      static_cast<const WebAppInternalsHandler_InstallIsolatedWebAppFromBundleUrl_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->result, validation_context))
    return false;

  return true;
}

WebAppInternalsHandler_InstallIsolatedWebAppFromBundleUrl_ResponseParams_Data::WebAppInternalsHandler_InstallIsolatedWebAppFromBundleUrl_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebAppInternalsHandler_UpdateDevProxyIsolatedWebApp_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebAppInternalsHandler_UpdateDevProxyIsolatedWebApp_Params_Data* object =
      static_cast<const WebAppInternalsHandler_UpdateDevProxyIsolatedWebApp_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->app_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& app_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->app_id, validation_context,
                                         &app_id_validate_params)) {
    return false;
  }

  return true;
}

WebAppInternalsHandler_UpdateDevProxyIsolatedWebApp_Params_Data::WebAppInternalsHandler_UpdateDevProxyIsolatedWebApp_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebAppInternalsHandler_UpdateDevProxyIsolatedWebApp_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebAppInternalsHandler_UpdateDevProxyIsolatedWebApp_ResponseParams_Data* object =
      static_cast<const WebAppInternalsHandler_UpdateDevProxyIsolatedWebApp_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& result_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->result, validation_context,
                                         &result_validate_params)) {
    return false;
  }

  return true;
}

WebAppInternalsHandler_UpdateDevProxyIsolatedWebApp_ResponseParams_Data::WebAppInternalsHandler_UpdateDevProxyIsolatedWebApp_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebAppInternalsHandler_SelectFileAndUpdateIsolatedWebAppFromDevBundle_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebAppInternalsHandler_SelectFileAndUpdateIsolatedWebAppFromDevBundle_Params_Data* object =
      static_cast<const WebAppInternalsHandler_SelectFileAndUpdateIsolatedWebAppFromDevBundle_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->app_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& app_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->app_id, validation_context,
                                         &app_id_validate_params)) {
    return false;
  }

  return true;
}

WebAppInternalsHandler_SelectFileAndUpdateIsolatedWebAppFromDevBundle_Params_Data::WebAppInternalsHandler_SelectFileAndUpdateIsolatedWebAppFromDevBundle_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebAppInternalsHandler_SelectFileAndUpdateIsolatedWebAppFromDevBundle_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebAppInternalsHandler_SelectFileAndUpdateIsolatedWebAppFromDevBundle_ResponseParams_Data* object =
      static_cast<const WebAppInternalsHandler_SelectFileAndUpdateIsolatedWebAppFromDevBundle_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& result_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->result, validation_context,
                                         &result_validate_params)) {
    return false;
  }

  return true;
}

WebAppInternalsHandler_SelectFileAndUpdateIsolatedWebAppFromDevBundle_ResponseParams_Data::WebAppInternalsHandler_SelectFileAndUpdateIsolatedWebAppFromDevBundle_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebAppInternalsHandler_UpdateManifestInstalledIsolatedWebApp_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebAppInternalsHandler_UpdateManifestInstalledIsolatedWebApp_Params_Data* object =
      static_cast<const WebAppInternalsHandler_UpdateManifestInstalledIsolatedWebApp_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->app_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& app_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->app_id, validation_context,
                                         &app_id_validate_params)) {
    return false;
  }

  return true;
}

WebAppInternalsHandler_UpdateManifestInstalledIsolatedWebApp_Params_Data::WebAppInternalsHandler_UpdateManifestInstalledIsolatedWebApp_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebAppInternalsHandler_UpdateManifestInstalledIsolatedWebApp_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebAppInternalsHandler_UpdateManifestInstalledIsolatedWebApp_ResponseParams_Data* object =
      static_cast<const WebAppInternalsHandler_UpdateManifestInstalledIsolatedWebApp_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& result_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->result, validation_context,
                                         &result_validate_params)) {
    return false;
  }

  return true;
}

WebAppInternalsHandler_UpdateManifestInstalledIsolatedWebApp_ResponseParams_Data::WebAppInternalsHandler_UpdateManifestInstalledIsolatedWebApp_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebAppInternalsHandler_SetUpdateChannelForIsolatedWebApp_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebAppInternalsHandler_SetUpdateChannelForIsolatedWebApp_Params_Data* object =
      static_cast<const WebAppInternalsHandler_SetUpdateChannelForIsolatedWebApp_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->app_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& app_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->app_id, validation_context,
                                         &app_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->update_channel, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& update_channel_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->update_channel, validation_context,
                                         &update_channel_validate_params)) {
    return false;
  }

  return true;
}

WebAppInternalsHandler_SetUpdateChannelForIsolatedWebApp_Params_Data::WebAppInternalsHandler_SetUpdateChannelForIsolatedWebApp_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebAppInternalsHandler_SetUpdateChannelForIsolatedWebApp_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebAppInternalsHandler_SetUpdateChannelForIsolatedWebApp_ResponseParams_Data* object =
      static_cast<const WebAppInternalsHandler_SetUpdateChannelForIsolatedWebApp_ResponseParams_Data*>(data);

  return true;
}

WebAppInternalsHandler_SetUpdateChannelForIsolatedWebApp_ResponseParams_Data::WebAppInternalsHandler_SetUpdateChannelForIsolatedWebApp_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebAppInternalsHandler_SetPinnedVersionForIsolatedWebApp_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebAppInternalsHandler_SetPinnedVersionForIsolatedWebApp_Params_Data* object =
      static_cast<const WebAppInternalsHandler_SetPinnedVersionForIsolatedWebApp_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->app_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& app_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->app_id, validation_context,
                                         &app_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->pinned_version, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& pinned_version_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->pinned_version, validation_context,
                                         &pinned_version_validate_params)) {
    return false;
  }

  return true;
}

WebAppInternalsHandler_SetPinnedVersionForIsolatedWebApp_Params_Data::WebAppInternalsHandler_SetPinnedVersionForIsolatedWebApp_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebAppInternalsHandler_SetPinnedVersionForIsolatedWebApp_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebAppInternalsHandler_SetPinnedVersionForIsolatedWebApp_ResponseParams_Data* object =
      static_cast<const WebAppInternalsHandler_SetPinnedVersionForIsolatedWebApp_ResponseParams_Data*>(data);

  return true;
}

WebAppInternalsHandler_SetPinnedVersionForIsolatedWebApp_ResponseParams_Data::WebAppInternalsHandler_SetPinnedVersionForIsolatedWebApp_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebAppInternalsHandler_ResetPinnedVersionForIsolatedWebApp_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebAppInternalsHandler_ResetPinnedVersionForIsolatedWebApp_Params_Data* object =
      static_cast<const WebAppInternalsHandler_ResetPinnedVersionForIsolatedWebApp_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->app_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& app_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->app_id, validation_context,
                                         &app_id_validate_params)) {
    return false;
  }

  return true;
}

WebAppInternalsHandler_ResetPinnedVersionForIsolatedWebApp_Params_Data::WebAppInternalsHandler_ResetPinnedVersionForIsolatedWebApp_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebAppInternalsHandler_SetAllowDowngradesForIsolatedWebApp_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebAppInternalsHandler_SetAllowDowngradesForIsolatedWebApp_Params_Data* object =
      static_cast<const WebAppInternalsHandler_SetAllowDowngradesForIsolatedWebApp_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->app_id, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& app_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->app_id, validation_context,
                                         &app_id_validate_params)) {
    return false;
  }

  return true;
}

WebAppInternalsHandler_SetAllowDowngradesForIsolatedWebApp_Params_Data::WebAppInternalsHandler_SetAllowDowngradesForIsolatedWebApp_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebAppInternalsHandler_SearchForIsolatedWebAppUpdates_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebAppInternalsHandler_SearchForIsolatedWebAppUpdates_Params_Data* object =
      static_cast<const WebAppInternalsHandler_SearchForIsolatedWebAppUpdates_Params_Data*>(data);

  return true;
}

WebAppInternalsHandler_SearchForIsolatedWebAppUpdates_Params_Data::WebAppInternalsHandler_SearchForIsolatedWebAppUpdates_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebAppInternalsHandler_SearchForIsolatedWebAppUpdates_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebAppInternalsHandler_SearchForIsolatedWebAppUpdates_ResponseParams_Data* object =
      static_cast<const WebAppInternalsHandler_SearchForIsolatedWebAppUpdates_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& result_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->result, validation_context,
                                         &result_validate_params)) {
    return false;
  }

  return true;
}

WebAppInternalsHandler_SearchForIsolatedWebAppUpdates_ResponseParams_Data::WebAppInternalsHandler_SearchForIsolatedWebAppUpdates_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebAppInternalsHandler_GetIsolatedWebAppDevModeAppInfo_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebAppInternalsHandler_GetIsolatedWebAppDevModeAppInfo_Params_Data* object =
      static_cast<const WebAppInternalsHandler_GetIsolatedWebAppDevModeAppInfo_Params_Data*>(data);

  return true;
}

WebAppInternalsHandler_GetIsolatedWebAppDevModeAppInfo_Params_Data::WebAppInternalsHandler_GetIsolatedWebAppDevModeAppInfo_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebAppInternalsHandler_GetIsolatedWebAppDevModeAppInfo_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebAppInternalsHandler_GetIsolatedWebAppDevModeAppInfo_ResponseParams_Data* object =
      static_cast<const WebAppInternalsHandler_GetIsolatedWebAppDevModeAppInfo_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->apps, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& apps_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->apps, validation_context,
                                         &apps_validate_params)) {
    return false;
  }

  return true;
}

WebAppInternalsHandler_GetIsolatedWebAppDevModeAppInfo_ResponseParams_Data::WebAppInternalsHandler_GetIsolatedWebAppDevModeAppInfo_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebAppInternalsHandler_RotateKey_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebAppInternalsHandler_RotateKey_Params_Data* object =
      static_cast<const WebAppInternalsHandler_RotateKey_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->web_bundle_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& web_bundle_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->web_bundle_id, validation_context,
                                         &web_bundle_id_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& rotated_key_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->rotated_key, validation_context,
                                         &rotated_key_validate_params)) {
    return false;
  }

  return true;
}

WebAppInternalsHandler_RotateKey_Params_Data::WebAppInternalsHandler_RotateKey_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom